/*
 * Copyright (C) 2015-2016 Willi Ye <williye97@gmail.com>
 *
 * This file is part of Kernel Adiutor.
 *
 * Kernel Adiutor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Kernel Adiutor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Kernel Adiutor.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package com.smartpack.kernelmanager.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;

import com.smartpack.kernelmanager.R;
import com.smartpack.kernelmanager.activities.tools.profile.ProfileActivity;
import com.smartpack.kernelmanager.fragments.kernel.BatteryFragment;
import com.smartpack.kernelmanager.fragments.kernel.CPUFragment;
import com.smartpack.kernelmanager.fragments.kernel.CPUHotplugFragment;
import com.smartpack.kernelmanager.fragments.kernel.CPUVoltageFragment;
import com.smartpack.kernelmanager.fragments.kernel.DisplayLEDFragment;
import com.smartpack.kernelmanager.fragments.kernel.EntropyFragment;
import com.smartpack.kernelmanager.fragments.kernel.GPUFragment;
import com.smartpack.kernelmanager.fragments.kernel.IOAdvancedFragment;
import com.smartpack.kernelmanager.fragments.kernel.IOFragment;
import com.smartpack.kernelmanager.fragments.kernel.KLapseFragment;
import com.smartpack.kernelmanager.fragments.kernel.KSMFragment;
import com.smartpack.kernelmanager.fragments.kernel.LMKFragment;
import com.smartpack.kernelmanager.fragments.kernel.MiscFragment;
import com.smartpack.kernelmanager.fragments.kernel.ScreenFragment;
import com.smartpack.kernelmanager.fragments.kernel.SoundFragment;
import com.smartpack.kernelmanager.fragments.kernel.ThermalFragment;
import com.smartpack.kernelmanager.fragments.kernel.VMFragment;
import com.smartpack.kernelmanager.fragments.kernel.WakeFragment;
import com.smartpack.kernelmanager.fragments.kernel.WakelockFragment;
import com.smartpack.kernelmanager.fragments.kernel.boost.CPUBoostFragment;
import com.smartpack.kernelmanager.fragments.kernel.boost.PowerHalFragment;
import com.smartpack.kernelmanager.fragments.kernel.boost.StuneBoostFragment;
import com.smartpack.kernelmanager.fragments.tools.CustomControlsFragment;
import com.smartpack.kernelmanager.utils.Prefs;
import com.smartpack.kernelmanager.utils.Utils;

import java.util.HashMap;

/**
 * Created by willi on 03.05.16.
 */
public class ApplyOnBootFragment extends BaseFragment {

    public static final String CPU = "cpu_onboot";
    public static final String CPU_BOOST = "cpuboost_onboot";
    public static final String POWERHAL_BOOST = "powerhal_onboot";
    public static final String STUNE_BOOST = "stuneboost_onboot";
    public static final String CPU_VOLTAGE = "cpuvoltage_onboot";
    public static final String CPU_HOTPLUG = "cpuhotplug_onboot";
    public static final String THERMAL = "thermal_onboot";
    public static final String GPU = "gpu_onboot";
    public static final String SCREEN = "screen_onboot";
    public static final String KLAPSE = "klapse_onboot";
    public static final String WAKE = "wake_onboot";
    public static final String SOUND = "sound_onboot";
    public static final String BATTERY = "battery_onboot";
    public static final String LED = "led_onboot";
    public static final String IO = "io_onboot";
    public static final String IO_ADVANCED = "ioadv_onboot";
    public static final String KSM = "ksm_onboot";
    public static final String LMK = "lmk_onboot";
    public static final String WAKELOCKS = "wakelocks_onboot";
    public static final String VM = "vm_onboot";
    public static final String ENTROPY = "entropy_onboot";
    public static final String MISC = "misc_onboot";
    public static final String CUSTOMCONTROL = "customcontrol_onboot";

    private static final HashMap<Class, String> sAssignments = new HashMap<>();

    static {
        sAssignments.put(CPUFragment.class, CPU);
        sAssignments.put(CPUBoostFragment.class, CPU_BOOST);
        sAssignments.put(PowerHalFragment.class, POWERHAL_BOOST);
        sAssignments.put(StuneBoostFragment.class, STUNE_BOOST);
        sAssignments.put(CPUVoltageFragment.class, CPU_VOLTAGE);
        sAssignments.put(CPUHotplugFragment.class, CPU_HOTPLUG);
        sAssignments.put(ThermalFragment.class, THERMAL);
        sAssignments.put(GPUFragment.class, GPU);
        sAssignments.put(ScreenFragment.class, SCREEN);
        sAssignments.put(KLapseFragment.class, KLAPSE);
        sAssignments.put(WakeFragment.class, WAKE);
        sAssignments.put(SoundFragment.class, SOUND);
        sAssignments.put(BatteryFragment.class, BATTERY);
        sAssignments.put(DisplayLEDFragment.class, LED);
        sAssignments.put(IOFragment.class, IO);
        sAssignments.put(IOAdvancedFragment.class, IO_ADVANCED);
        sAssignments.put(KSMFragment.class, KSM);
        sAssignments.put(LMKFragment.class, LMK);
        sAssignments.put(WakelockFragment.class, WAKELOCKS);
        sAssignments.put(VMFragment.class, VM);
        sAssignments.put(EntropyFragment.class, ENTROPY);
        sAssignments.put(MiscFragment.class, MISC);
        sAssignments.put(CustomControlsFragment.class, CUSTOMCONTROL);
    }

    public static String getAssignment(Class fragment) {
        if (!sAssignments.containsKey(fragment)) {
            throw new RuntimeException("Assignment key does not exists: " + fragment.getSimpleName());
        }
        return sAssignments.get(fragment);
    }

    public static ApplyOnBootFragment newInstance(RecyclerViewFragment recyclerViewFragment) {
        Bundle args = new Bundle();
        args.putString("category", getAssignment(recyclerViewFragment.getClass()));
        ApplyOnBootFragment fragment = new ApplyOnBootFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getActivity() instanceof ProfileActivity) {
            View rootView = inflater.inflate(R.layout.fragment_description, container, false);

            TextView title = rootView.findViewById(R.id.title);
            TextView summary = rootView.findViewById(R.id.summary);

            title.setText(getString(R.string.apply_on_boot));
            summary.setText(getString(R.string.apply_on_boot_not_available));

            return rootView;
        } else {
            View rootView = inflater.inflate(R.layout.fragment_apply_on_boot, container, false);

            assert getArguments() != null;
            final String category = getArguments().getString("category");
            SwitchCompat switcher = rootView.findViewById(R.id.switcher);
            switcher.setChecked(Prefs.getBoolean("enable_onboot", true, getActivity()) &&
                    Prefs.getBoolean(category, false, getActivity()));
            switcher.setOnCheckedChangeListener((buttonView, isChecked) -> {
                if (Prefs.getBoolean("enable_onboot", true, getActivity())) {
                    Prefs.saveBoolean(category, isChecked, getActivity());
                } else {
                    Utils.snackbar(rootView, getString(R.string.enable_onboot_message));
                }
            });
            return rootView;
        }
    }

}