package com.example.util.simpletimetracker.domain.base

sealed interface ResultContainer<out T> {
    object Undefined : ResultContainer<Nothing>
    data class Defined<out T>(val value: T) : ResultContainer<T>

    fun getValueOrNull(): T? {
        return (this as? Defined)?.value
    }
}