package com.psrivastava.deviceframegenerator.devices;

import java.util.Arrays;

public class Device {

	private String id;
	private String title;
	private String url;

	private float physicalSize;
	private int density;

	private int[] landOffset;
	private int[] portOffset;

	private int[] portSize;

	private int thumbnail;

	public Device(String id, String title, String url, float physicalSize,
			int density, int[] landOffset, int[] portOffset, int[] portSize,
			int thumbnail) {
		super();
		this.id = id;
		this.title = title;
		this.url = url;
		this.physicalSize = physicalSize;
		this.density = density;
		this.landOffset = landOffset;
		this.portOffset = portOffset;
		this.portSize = portSize;
		this.thumbnail = thumbnail;
	}

	public Device(Device device) {
		this.id = device.id;
		this.title = device.title;
		this.url = device.url;

		this.physicalSize = device.physicalSize;
		this.density = device.density;

		this.landOffset = device.landOffset;
		this.portOffset = device.portOffset;

		this.portSize = device.portSize;
	}

	@Override
	public String toString() {
		return "Device [title=" + title + ", portSize="
				+ Arrays.toString(portSize) + "]";
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public float getPhysicalSize() {
		return physicalSize;
	}

	public void setPhysicalSize(float physicalSize) {
		this.physicalSize = physicalSize;
	}

	public int getDensity() {
		return density;
	}

	public void setDensity(int density) {
		this.density = density;
	}

	public int[] getLandOffset() {
		return landOffset;
	}

	public void setLandOffset(int[] landOffset) {
		this.landOffset = landOffset;
	}

	public int[] getPortOffset() {
		return portOffset;
	}

	public void setPortOffset(int[] portOffset) {
		this.portOffset = portOffset;
	}

	public int[] getPortSize() {
		return portSize;
	}

	public void setPortSize(int[] portSize) {
		this.portSize = portSize;
	}

	public int getThumbnail() {
		return thumbnail;
	}

	public void setThumbnail(int thumbnail) {
		this.thumbnail = thumbnail;
	}

}
