package com.psrivastava.deviceframegenerator;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.actionbarsherlock.app.SherlockDialogFragment;

public class AboutDialogFragment extends SherlockDialogFragment {

	private View.OnClickListener mOnClickListener;

	public AboutDialogFragment() {
		// Empty constructor required for DialogFragment
	}

	/* (non-Javadoc)
	 * @see com.actionbarsherlock.app.SherlockDialogFragment#onAttach(android.app.Activity)
	 */
	@Override
	public void onAttach(Activity activity) {
		super.onAttach(activity);
		try {
			mOnClickListener = (View.OnClickListener) activity;
		} catch (ClassCastException e) {
			e.printStackTrace();
		}
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		View view = inflater.inflate(R.layout.about_fragment, container);

		if (Build.VERSION.SDK_INT > Build.VERSION_CODES.HONEYCOMB) {
			view.setBackgroundResource(android.R.drawable.dialog_holo_dark_frame);
		}

		view.findViewById(R.id.textView_attribution).setOnClickListener(
				mOnClickListener);
		view.findViewById(R.id.textView_credits).setOnClickListener(
				mOnClickListener);
		view.findViewById(R.id.textView_donate).setOnClickListener(
				mOnClickListener);
		view.findViewById(R.id.textView_issues).setOnClickListener(
				mOnClickListener);

		getDialog().setTitle(R.string.app_name);

		return view;
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// gives a unified look across all versions
		if (Build.VERSION.SDK_INT > Build.VERSION_CODES.HONEYCOMB) {
			setStyle(DialogFragment.STYLE_NO_FRAME, 0);
		} else {
			setStyle(DialogFragment.STYLE_NO_TITLE, 0);
		}

	}

}
