/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.notificationcompat2;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.widget.RemoteViews;
import com.jakewharton.notificationcompat2.NotificationCompatBase;
import com.jakewharton.notificationcompat2.NotificationCompatHC;
import com.jakewharton.notificationcompat2.NotificationCompatICS;
import com.jakewharton.notificationcompat2.NotificationCompatJB;
import java.util.ArrayList;

public class NotificationCompat2 {
    @Deprecated
    public static final int FLAG_HIGH_PRIORITY = 128;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_LOW = -1;
    public static final int PRIORITY_MAX = 2;
    public static final int PRIORITY_MIN = -2;
    private static final NotificationCompatImpl IMPL = Build.VERSION.SDK_INT >= 16 ? new NotificationCompatJB() : (Build.VERSION.SDK_INT >= 14 ? new NotificationCompatICS() : (Build.VERSION.SDK_INT >= 11 ? new NotificationCompatHC() : new NotificationCompatBase()));

    public static class InboxStyle
    extends Style {
        ArrayList<CharSequence> mLines;

        public InboxStyle() {
        }

        public InboxStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public InboxStyle addLine(CharSequence charSequence) {
            if (this.mLines == null) {
                this.mLines = new ArrayList();
            }
            this.mLines.add(charSequence);
            return this;
        }

        @Override
        public Notification build() {
            this.checkBuilder();
            if (Build.VERSION.SDK_INT >= 16) {
                return NotificationCompatJB.buildInboxStyle(this);
            }
            return this.mBuilder.build();
        }

        public InboxStyle setBigContentTitle(CharSequence charSequence) {
            this.internalSetBigContentTitle(charSequence);
            return this;
        }

        public InboxStyle setSummaryText(CharSequence charSequence) {
            this.internalSetSummaryText(charSequence);
            return this;
        }
    }

    public static class BigTextStyle
    extends Style {
        CharSequence mBigText;

        public BigTextStyle() {
        }

        public BigTextStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public BigTextStyle bigText(CharSequence charSequence) {
            this.mBigText = charSequence;
            return this;
        }

        @Override
        public Notification build() {
            this.checkBuilder();
            if (Build.VERSION.SDK_INT >= 16) {
                return NotificationCompatJB.buildBigTextStyle(this);
            }
            return this.mBuilder.build();
        }

        public BigTextStyle setBigContentTitle(CharSequence charSequence) {
            this.internalSetBigContentTitle(charSequence);
            return this;
        }

        public BigTextStyle setSummaryText(CharSequence charSequence) {
            this.internalSetSummaryText(charSequence);
            return this;
        }
    }

    public static class BigPictureStyle
    extends Style {
        Bitmap mBigLargeIcon;
        Bitmap mBigPicture;

        public BigPictureStyle() {
        }

        public BigPictureStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public BigPictureStyle bigLargeIcon(Bitmap bitmap) {
            this.mBigLargeIcon = bitmap;
            return this;
        }

        public BigPictureStyle bigPicture(Bitmap bitmap) {
            this.mBigPicture = bitmap;
            return this;
        }

        @Override
        public Notification build() {
            this.checkBuilder();
            if (Build.VERSION.SDK_INT >= 16) {
                return NotificationCompatJB.buildBigPictureStyle(this);
            }
            return this.mBuilder.build();
        }

        public BigPictureStyle setBigContentTitle(CharSequence charSequence) {
            this.internalSetBigContentTitle(charSequence);
            return this;
        }

        public BigPictureStyle setSummaryText(CharSequence charSequence) {
            this.internalSetSummaryText(charSequence);
            return this;
        }
    }

    public static abstract class Style {
        protected Builder mBuilder;
        CharSequence mBigContentTitle;
        CharSequence mSummaryText;

        public abstract Notification build();

        public void setBuilder(Builder builder) {
            this.mBuilder = builder;
        }

        protected void checkBuilder() {
            if (this.mBuilder == null) {
                throw new IllegalStateException("No builder.");
            }
        }

        protected RemoteViews getStandardView(int n) {
            return null;
        }

        protected void internalSetBigContentTitle(CharSequence charSequence) {
            this.mBigContentTitle = charSequence;
        }

        protected void internalSetSummaryText(CharSequence charSequence) {
            this.mSummaryText = charSequence;
        }
    }

    public static class Builder {
        final Context mContext;
        CharSequence mContentTitle;
        CharSequence mContentText;
        PendingIntent mContentIntent;
        PendingIntent mFullScreenIntent;
        RemoteViews mTickerView;
        Bitmap mLargeIcon;
        CharSequence mContentInfo;
        int mNumber;
        int mPriority;
        CharSequence mSubText;
        boolean mUsesChronometer;
        Style mStyle;
        ArrayList<Integer> mActionIcons;
        ArrayList<CharSequence> mActionTitles;
        ArrayList<PendingIntent> mActionIntents;
        int mProgress;
        int mProgressMax;
        boolean mProgressIndeterminate;
        boolean mProgressSet;
        Notification mNotification = new Notification();

        public Builder(Context context) {
            this.mContext = context;
            this.mNotification.when = System.currentTimeMillis();
            this.mNotification.audioStreamType = -1;
            this.mPriority = 0;
        }

        public Builder setWhen(long l) {
            this.mNotification.when = l;
            return this;
        }

        public Builder setSmallIcon(int n) {
            this.mNotification.icon = n;
            return this;
        }

        public Builder setSmallIcon(int n, int n2) {
            this.mNotification.icon = n;
            this.mNotification.iconLevel = n2;
            return this;
        }

        public Builder setContentTitle(CharSequence charSequence) {
            this.mContentTitle = charSequence;
            return this;
        }

        public Builder setContentText(CharSequence charSequence) {
            this.mContentText = charSequence;
            return this;
        }

        public Builder setNumber(int n) {
            this.mNumber = n;
            return this;
        }

        public Builder setContentInfo(CharSequence charSequence) {
            this.mContentInfo = charSequence;
            return this;
        }

        public Builder setProgress(int n, int n2, boolean bl) {
            this.mProgressSet = true;
            this.mProgressMax = n;
            this.mProgress = n2;
            this.mProgressIndeterminate = bl;
            return this;
        }

        public Builder setContent(RemoteViews remoteViews) {
            this.mNotification.contentView = remoteViews;
            return this;
        }

        public Builder setContentIntent(PendingIntent pendingIntent) {
            this.mContentIntent = pendingIntent;
            return this;
        }

        public Builder setDeleteIntent(PendingIntent pendingIntent) {
            this.mNotification.deleteIntent = pendingIntent;
            return this;
        }

        public Builder setFullScreenIntent(PendingIntent pendingIntent, boolean bl) {
            this.mFullScreenIntent = pendingIntent;
            this.setFlag(128, bl);
            return this;
        }

        public Builder setTicker(CharSequence charSequence) {
            this.mNotification.tickerText = charSequence;
            return this;
        }

        public Builder setTicker(CharSequence charSequence, RemoteViews remoteViews) {
            this.mNotification.tickerText = charSequence;
            this.mTickerView = remoteViews;
            return this;
        }

        public Builder setLargeIcon(Bitmap bitmap) {
            this.mLargeIcon = bitmap;
            return this;
        }

        public Builder setSound(Uri uri) {
            this.mNotification.sound = uri;
            this.mNotification.audioStreamType = -1;
            return this;
        }

        public Builder setSound(Uri uri, int n) {
            this.mNotification.sound = uri;
            this.mNotification.audioStreamType = n;
            return this;
        }

        public Builder setVibrate(long[] lArray) {
            this.mNotification.vibrate = lArray;
            return this;
        }

        public Builder setLights(int n, int n2, int n3) {
            this.mNotification.ledARGB = n;
            this.mNotification.ledOnMS = n2;
            this.mNotification.ledOffMS = n3;
            boolean bl = this.mNotification.ledOnMS != 0 && this.mNotification.ledOffMS != 0;
            this.mNotification.flags = this.mNotification.flags & 0xFFFFFFFE | (bl ? 1 : 0);
            return this;
        }

        public Builder setOngoing(boolean bl) {
            this.setFlag(2, bl);
            return this;
        }

        public Builder setOnlyAlertOnce(boolean bl) {
            this.setFlag(8, bl);
            return this;
        }

        public Builder setAutoCancel(boolean bl) {
            this.setFlag(16, bl);
            return this;
        }

        public Builder setDefaults(int n) {
            this.mNotification.defaults = n;
            if ((n & 4) != 0) {
                this.mNotification.flags |= 1;
            }
            return this;
        }

        private void setFlag(int n, boolean bl) {
            this.mNotification.flags = bl ? (this.mNotification.flags |= n) : (this.mNotification.flags &= ~n);
        }

        public Builder addAction(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            if (this.mActionIcons == null) {
                this.mActionIcons = new ArrayList();
                this.mActionTitles = new ArrayList();
                this.mActionIntents = new ArrayList();
            }
            this.mActionIcons.add(n);
            this.mActionTitles.add(charSequence);
            this.mActionIntents.add(pendingIntent);
            return this;
        }

        public Builder setPriority(int n) {
            this.mPriority = n;
            return this;
        }

        public Builder setStyle(Style style) {
            this.mStyle = style;
            return this;
        }

        public Builder setSubText(CharSequence charSequence) {
            this.mSubText = charSequence;
            return this;
        }

        public Builder setUsesChronometer(boolean bl) {
            this.mUsesChronometer = bl;
            return this;
        }

        @Deprecated
        public Notification getNotification() {
            return this.build();
        }

        public Notification build() {
            return IMPL.build(this);
        }
    }

    static interface NotificationCompatImpl {
        public Notification build(Builder var1);
    }
}

