/*
 * Decompiled with CFR 0.152.
 */
package de.neofonie.mobile.app.android.widget.crouton;

import android.app.Activity;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import de.neofonie.mobile.app.android.widget.crouton.Crouton;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

final class Manager
extends Handler {
    private static Manager INSTANCE;
    private Queue<Crouton> croutonQueue = new LinkedBlockingQueue<Crouton>();

    private Manager() {
    }

    static synchronized Manager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Manager();
        }
        return INSTANCE;
    }

    void add(Crouton crouton) {
        this.croutonQueue.add(crouton);
        this.displayCrouton();
    }

    private void displayCrouton() {
        if (this.croutonQueue.isEmpty()) {
            return;
        }
        Crouton currentCrouton = this.croutonQueue.peek();
        if (currentCrouton.getActivity() == null) {
            this.croutonQueue.poll();
        }
        if (!currentCrouton.isShowing()) {
            this.sendMessage(currentCrouton, -1040157475);
        } else {
            this.sendMessageDelayed(currentCrouton, 794631, this.calculateCroutonDuration(currentCrouton));
        }
    }

    private long calculateCroutonDuration(Crouton crouton) {
        long croutonDuration = 0L;
        croutonDuration += (long)crouton.getStyle().durationInMilliseconds;
        croutonDuration += crouton.getInAnimation().getDuration();
        return croutonDuration += crouton.getOutAnimation().getDuration();
    }

    private void sendMessage(Crouton crouton, int messageId) {
        Message message = this.obtainMessage(messageId);
        message.obj = crouton;
        this.sendMessage(message);
    }

    private void sendMessageDelayed(Crouton crouton, int messageId, long delay) {
        Message message = this.obtainMessage(messageId);
        message.obj = crouton;
        this.sendMessageDelayed(message, delay);
    }

    public void handleMessage(Message message) {
        Crouton crouton = (Crouton)message.obj;
        switch (message.what) {
            case 794631: {
                this.displayCrouton();
                break;
            }
            case -1040157475: {
                this.addCroutonToView(crouton);
                break;
            }
            case -1040155167: {
                this.removeCrouton(crouton);
                break;
            }
            default: {
                super.handleMessage(message);
            }
        }
    }

    private void addCroutonToView(Crouton crouton) {
        if (crouton.isShowing()) {
            return;
        }
        View croutonView = crouton.getView();
        if (croutonView.getParent() == null) {
            ViewGroup.LayoutParams params = croutonView.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-2, -2);
            }
            crouton.getActivity().addContentView(croutonView, params);
        }
        croutonView.startAnimation(crouton.getInAnimation());
        this.sendMessageDelayed(crouton, -1040155167, (long)crouton.getStyle().durationInMilliseconds + crouton.getInAnimation().getDuration());
    }

    private void removeCrouton(Crouton crouton) {
        View croutonView = crouton.getView();
        ViewGroup croutonParentView = (ViewGroup)croutonView.getParent();
        if (croutonParentView != null) {
            croutonView.startAnimation(crouton.getOutAnimation());
            Crouton removed = this.croutonQueue.poll();
            croutonParentView.removeView(croutonView);
            if (removed != null) {
                removed.detachActivity();
            }
            this.sendMessageDelayed(crouton, 794631, crouton.getOutAnimation().getDuration());
        }
    }

    void removeCroutonImmediately(Crouton crouton) {
        if (this.croutonQueue != null) {
            Iterator croutonIterator = this.croutonQueue.iterator();
            while (croutonIterator.hasNext()) {
                Crouton c = (Crouton)croutonIterator.next();
                if (!c.equals(crouton) || c.getActivity() == null) continue;
                if (crouton.isShowing()) {
                    ((ViewGroup)c.getView().getParent()).removeView(c.getView());
                }
                this.removeAllMessagesForCrouton(c);
                croutonIterator.remove();
                break;
            }
        }
    }

    void clearCroutonQueue() {
        this.removeAllMessages();
        if (this.croutonQueue != null) {
            for (Crouton crouton : this.croutonQueue) {
                if (!crouton.isShowing()) continue;
                ((ViewGroup)crouton.getView().getParent()).removeView(crouton.getView());
            }
            this.croutonQueue.clear();
        }
    }

    void clearCroutonsForActivity(Activity activity) {
        if (this.croutonQueue != null) {
            Iterator croutonIterator = this.croutonQueue.iterator();
            while (croutonIterator.hasNext()) {
                Crouton crouton = (Crouton)croutonIterator.next();
                if (crouton.getActivity() == null || !crouton.getActivity().equals(activity)) continue;
                if (crouton.isShowing()) {
                    ((ViewGroup)crouton.getView().getParent()).removeView(crouton.getView());
                }
                this.removeAllMessagesForCrouton(crouton);
                croutonIterator.remove();
            }
        }
    }

    private void removeAllMessages() {
        this.removeMessages(-1040157475);
        this.removeMessages(794631);
        this.removeMessages(-1040155167);
    }

    private void removeAllMessagesForCrouton(Crouton crouton) {
        this.removeMessages(-1040157475, crouton);
        this.removeMessages(794631, crouton);
        this.removeMessages(-1040155167, crouton);
    }

    private static final class Messages {
        public static final int DISPLAY_CROUTON = 794631;
        public static final int ADD_CROUTON_TO_VIEW = -1040157475;
        public static final int REMOVE_CROUTON = -1040155167;

        private Messages() {
        }
    }
}

