/*
 * Decompiled with CFR 0.152.
 */
package de.neofonie.mobile.app.android.widget.crouton;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import de.neofonie.mobile.app.android.widget.crouton.Manager;
import de.neofonie.mobile.app.android.widget.crouton.Style;

public final class Crouton {
    private static final int IMAGE_ID = 256;
    private static final int TEXT_ID = 257;
    private final CharSequence text;
    private final Style style;
    private final View customView;
    private Activity activity;
    private FrameLayout croutonView;
    private Animation inAnimation;
    private Animation outAnimation;

    private Crouton(Activity activity, CharSequence text, Style style) {
        if (activity == null || text == null || style == null) {
            throw new IllegalArgumentException("Null parameters are not accepted");
        }
        this.activity = activity;
        this.text = text;
        this.style = style;
        this.customView = null;
    }

    private Crouton(Activity activity, View customView) {
        if (activity == null || customView == null) {
            throw new IllegalArgumentException("Null parameters are not accepted");
        }
        this.activity = activity;
        this.customView = customView;
        this.style = new Style.Builder().build();
        this.text = null;
    }

    public static Crouton makeText(Activity activity, CharSequence text, Style style) {
        return new Crouton(activity, text, style);
    }

    public static Crouton makeText(Activity activity, int textResourceId, Style style) {
        return Crouton.makeText(activity, activity.getString(textResourceId), style);
    }

    public static Crouton make(Activity activity, View customView) {
        return new Crouton(activity, customView);
    }

    public static void showText(Activity activity, CharSequence text, Style style) {
        Crouton.makeText(activity, text, style).show();
    }

    public static void show(Activity activity, View customView) {
        Crouton.make(activity, customView).show();
    }

    public static void showText(Activity activity, int textResourceId, Style style) {
        Crouton.showText(activity, activity.getString(textResourceId), style);
    }

    public static void cancelAllCroutons() {
        Manager.getInstance().clearCroutonQueue();
    }

    public static void clearCroutonsForActivity(Activity activity) {
        Manager.getInstance().clearCroutonsForActivity(activity);
    }

    public void cancel() {
        Manager manager = Manager.getInstance();
        manager.removeCroutonImmediately(this);
    }

    public void show() {
        Manager.getInstance().add(this);
    }

    boolean isShowing() {
        return this.activity != null && this.croutonView != null && this.croutonView.getParent() != null;
    }

    void detachActivity() {
        this.activity = null;
    }

    Style getStyle() {
        return this.style;
    }

    Activity getActivity() {
        return this.activity;
    }

    CharSequence getText() {
        return this.text;
    }

    View getView() {
        if (this.customView != null) {
            return this.customView;
        }
        if (this.croutonView == null) {
            this.initializeCroutonView();
        }
        return this.croutonView;
    }

    private void initializeCroutonView() {
        Resources resources = this.activity.getResources();
        this.croutonView = new FrameLayout((Context)this.activity);
        int height = this.style.heightInPixels;
        if (this.style.heightDimensionResId > 0) {
            height = resources.getDimensionPixelSize(this.style.heightDimensionResId);
        }
        this.croutonView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, height));
        if (this.style.backgroundColorValue != -1) {
            this.croutonView.setBackgroundColor(this.style.backgroundColorValue);
        } else {
            this.croutonView.setBackgroundColor(resources.getColor(this.style.backgroundColorResourceId));
        }
        if (this.style.backgroundDrawableResourceId != 0) {
            Bitmap background = BitmapFactory.decodeResource((Resources)resources, (int)this.style.backgroundDrawableResourceId);
            BitmapDrawable drawable = new BitmapDrawable(resources, background);
            if (this.style.isTileEnabled) {
                drawable.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
            }
            this.croutonView.setBackgroundDrawable((Drawable)drawable);
        }
        RelativeLayout contentView = new RelativeLayout((Context)this.activity);
        contentView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        int padding = this.style.paddingInPixels;
        if (this.style.paddingDimensionResId > 0) {
            padding = resources.getDimensionPixelSize(this.style.paddingDimensionResId);
        }
        contentView.setPadding(padding, padding, padding, padding);
        ImageView image = null;
        if (this.style.imageDrawable != null || this.style.imageResId != 0) {
            image = new ImageView((Context)this.activity);
            image.setId(256);
            image.setAdjustViewBounds(true);
            image.setScaleType(this.style.imageScaleType);
            if (this.style.imageDrawable != null) {
                image.setImageDrawable(this.style.imageDrawable);
            }
            if (this.style.imageResId != 0) {
                image.setImageResource(this.style.imageResId);
            }
            RelativeLayout.LayoutParams imageParams = new RelativeLayout.LayoutParams(-2, -2);
            imageParams.addRule(9, -1);
            imageParams.addRule(15, -1);
            contentView.addView((View)image, (ViewGroup.LayoutParams)imageParams);
        }
        TextView text = new TextView((Context)this.activity);
        text.setId(257);
        text.setText(this.text);
        text.setTypeface(Typeface.DEFAULT_BOLD);
        text.setGravity(this.style.gravity);
        if (this.style.textColorResourceId != 0) {
            text.setTextColor(resources.getColor(this.style.textColorResourceId));
        }
        if (this.style.textSize != 0) {
            text.setTextSize(2, (float)this.style.textSize);
        }
        if (this.style.textShadowColorResId != 0) {
            int textShadowColor = resources.getColor(this.style.textShadowColorResId);
            float textShadowRadius = this.style.textShadowRadius;
            float textShadowDx = this.style.textShadowDx;
            float textShadowDy = this.style.textShadowDy;
            text.setShadowLayer(textShadowRadius, textShadowDx, textShadowDy, textShadowColor);
        }
        if (this.style.textAppearanceResId != 0) {
            text.setTextAppearance((Context)this.activity, this.style.textAppearanceResId);
        }
        RelativeLayout.LayoutParams textParams = new RelativeLayout.LayoutParams(-1, -2);
        if (image != null) {
            textParams.addRule(1, image.getId());
        }
        contentView.addView((View)text, (ViewGroup.LayoutParams)textParams);
        this.croutonView.addView((View)contentView);
    }

    public Animation getInAnimation() {
        if (this.inAnimation == null && this.activity != null) {
            this.inAnimation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)this.getStyle().inAnimationResId);
        }
        return this.inAnimation;
    }

    public Animation getOutAnimation() {
        if (this.outAnimation == null && this.activity != null) {
            this.outAnimation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)this.getStyle().outAnimationResId);
        }
        return this.outAnimation;
    }
}

