package com.prof18.feedflow.shared.ui.accounts.icons

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.prof18.feedflow.shared.ui.utils.PreviewTheme

val Bazqux: ImageVector
    get() {
        val current = _bazqux
        if (current != null) return current

        return ImageVector.Builder(
            name = "Bazqux",
            defaultWidth = 32.0.dp,
            defaultHeight = 32.0.dp,
            viewportWidth = 512.0f,
            viewportHeight = 512.0f,
        ).apply {
            path(
                fill = SolidColor(Color(0xFF49ACD7)),
                pathFillType = PathFillType.EvenOdd,
            ) {
                // M 427 0
                moveTo(x = 427.0f, y = 0.0f)
                // H 85
                horizontalLineTo(x = 85.0f)
                // A 85 85 0 0 0 0 85
                arcTo(
                    horizontalEllipseRadius = 85.0f,
                    verticalEllipseRadius = 85.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    x1 = 0.0f,
                    y1 = 85.0f,
                )
                // v 342
                verticalLineToRelative(dy = 342.0f)
                // a 85 85 0 0 0 85 85
                arcToRelative(
                    a = 85.0f,
                    b = 85.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = 85.0f,
                    dy1 = 85.0f,
                )
                // h 342
                horizontalLineToRelative(dx = 342.0f)
                // a 85 85 0 0 0 85 -85
                arcToRelative(
                    a = 85.0f,
                    b = 85.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = 85.0f,
                    dy1 = -85.0f,
                )
                // V 85
                verticalLineTo(y = 85.0f)
                // a 85 85 0 0 0 -85 -85
                arcToRelative(
                    a = 85.0f,
                    b = 85.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = -85.0f,
                    dy1 = -85.0f,
                )
                // m -21 429
                moveToRelative(dx = -21.0f, dy = 429.0f)
                // h -83.2
                horizontalLineToRelative(dx = -83.2f)
                // q -27.66 -48.66 -50.1 -84.12
                quadToRelative(
                    dx1 = -27.66f,
                    dy1 = -48.66f,
                    dx2 = -50.1f,
                    dy2 = -84.12f,
                )
                // a 1867 1867 0 0 0 -48.34 -73.12
                arcToRelative(
                    a = 1867.0f,
                    b = 1867.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = -48.34f,
                    dy1 = -73.12f,
                )
                // h -31.59
                horizontalLineToRelative(dx = -31.59f)
                // V 381.8
                verticalLineTo(y = 381.8f)
                // q 0 8.56 2.4 15.16
                quadToRelative(
                    dx1 = 0.0f,
                    dy1 = 8.56f,
                    dx2 = 2.4f,
                    dy2 = 15.16f,
                )
                // q 2.39 6.36 10.24 9.79
                quadToRelative(
                    dx1 = 2.39f,
                    dy1 = 6.36f,
                    dx2 = 10.24f,
                    dy2 = 9.79f,
                )
                // q 3.91 1.71 13.72 3.18
                quadToRelative(
                    dx1 = 3.91f,
                    dy1 = 1.71f,
                    dx2 = 13.72f,
                    dy2 = 3.18f,
                )
                // a 152 152 0 0 0 16.55 1.7
                arcToRelative(
                    a = 152.0f,
                    b = 152.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = 16.55f,
                    dy1 = 1.7f,
                )
                // V 429
                verticalLineTo(y = 429.0f)
                // H 105
                horizontalLineTo(x = 105.0f)
                // v -17.36
                verticalLineToRelative(dy = -17.36f)
                // q 5.23 -0.5 15.03 -1.71
                quadToRelative(
                    dx1 = 5.23f,
                    dy1 = -0.5f,
                    dx2 = 15.03f,
                    dy2 = -1.71f,
                )
                // q 10.02 -1.23 13.94 -3.18
                quadToRelative(
                    dx1 = 10.02f,
                    dy1 = -1.23f,
                    dx2 = 13.94f,
                    dy2 = -3.18f,
                )
                // a 19 19 0 0 0 9.36 -9.3
                arcToRelative(
                    a = 19.0f,
                    b = 19.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = 9.36f,
                    dy1 = -9.3f,
                )
                // q 3.05 -6.1 3.05 -15.65
                quadToRelative(
                    dx1 = 3.05f,
                    dy1 = -6.1f,
                    dx2 = 3.05f,
                    dy2 = -15.65f,
                )
                // V 130.9
                verticalLineTo(y = 130.9f)
                // q 0 -8.55 -2.18 -15.15
                quadToRelative(
                    dx1 = 0.0f,
                    dy1 = -8.55f,
                    dx2 = -2.18f,
                    dy2 = -15.15f,
                )
                // t -10.23 -10.03
                reflectiveQuadToRelative(
                    dx1 = -10.23f,
                    dy1 = -10.03f,
                )
                // q -5.44 -2.2 -14.16 -3.91
                quadToRelative(
                    dx1 = -5.44f,
                    dy1 = -2.2f,
                    dx2 = -14.16f,
                    dy2 = -3.91f,
                )
                // q -8.7 -1.95 -14.81 -2.45
                quadToRelative(
                    dx1 = -8.7f,
                    dy1 = -1.95f,
                    dx2 = -14.81f,
                    dy2 = -2.45f,
                )
                // V 82
                verticalLineTo(y = 82.0f)
                // h 142.66
                horizontalLineToRelative(dx = 142.66f)
                // a 141 141 0 0 1 36.8 4.65
                arcToRelative(
                    a = 141.0f,
                    b = 141.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = true,
                    dx1 = 36.8f,
                    dy1 = 4.65f,
                )
                // a 92 92 0 0 1 31.15 14.42
                arcToRelative(
                    a = 92.0f,
                    b = 92.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = true,
                    dx1 = 31.15f,
                    dy1 = 14.42f,
                )
                // q 13.5 9.79 21.57 25.68
                quadToRelative(
                    dx1 = 13.5f,
                    dy1 = 9.79f,
                    dx2 = 21.57f,
                    dy2 = 25.68f,
                )
                // q 8.05 15.65 8.05 37.9
                quadToRelative(
                    dx1 = 8.05f,
                    dy1 = 15.65f,
                    dx2 = 8.05f,
                    dy2 = 37.9f,
                )
                // q 0 20.06 -5.44 35.46
                quadToRelative(
                    dx1 = 0.0f,
                    dy1 = 20.06f,
                    dx2 = -5.44f,
                    dy2 = 35.46f,
                )
                // a 74 74 0 0 1 -16.12 26.66
                arcToRelative(
                    a = 74.0f,
                    b = 74.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = true,
                    dx1 = -16.12f,
                    dy1 = 26.66f,
                )
                // a 99 99 0 0 1 -23.52 18.34
                arcToRelative(
                    a = 99.0f,
                    b = 99.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = true,
                    dx1 = -23.52f,
                    dy1 = 18.34f,
                )
                // a 173 173 0 0 1 -30.27 12.96
                arcToRelative(
                    a = 173.0f,
                    b = 173.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = true,
                    dx1 = -30.27f,
                    dy1 = 12.96f,
                )
                // a 3910 3910 0 0 1 37.9 57.22
                arcToRelative(
                    a = 3910.0f,
                    b = 3910.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = true,
                    dx1 = 37.9f,
                    dy1 = 57.22f,
                )
                // q 15.24 23.24 37.24 56.49
                quadToRelative(
                    dx1 = 15.24f,
                    dy1 = 23.24f,
                    dx2 = 37.24f,
                    dy2 = 56.49f,
                )
                // q 9.57 14.67 17.2 21.76
                quadToRelative(
                    dx1 = 9.57f,
                    dy1 = 14.67f,
                    dx2 = 17.2f,
                    dy2 = 21.76f,
                )
                // a 99 99 0 0 0 15.47 11.25
                arcToRelative(
                    a = 99.0f,
                    b = 99.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = 15.47f,
                    dy1 = 11.25f,
                )
                // q 5.66 3.18 14.15 4.9
                quadToRelative(
                    dx1 = 5.66f,
                    dy1 = 3.18f,
                    dx2 = 14.15f,
                    dy2 = 4.9f,
                )
                // a 95 95 0 0 0 14.16 1.95z
                arcToRelative(
                    a = 95.0f,
                    b = 95.0f,
                    theta = 0.0f,
                    isMoreThanHalf = false,
                    isPositiveArc = false,
                    dx1 = 14.16f,
                    dy1 = 1.95f,
                )
                close()
                // M 291.44 170.28
                moveTo(x = 291.44f, y = 170.28f)
                // q 0 -31.55 -16.12 -49.89
                quadToRelative(
                    dx1 = 0.0f,
                    dy1 = -31.55f,
                    dx2 = -16.12f,
                    dy2 = -49.89f,
                )
                // q -16.12 -18.58 -45.52 -18.58
                quadToRelative(
                    dx1 = -16.12f,
                    dy1 = -18.58f,
                    dx2 = -45.52f,
                    dy2 = -18.58f,
                )
                // h -37.03
                horizontalLineToRelative(dx = -37.03f)
                // v 148.92
                verticalLineToRelative(dy = 148.92f)
                // h 28.53
                horizontalLineToRelative(dx = 28.53f)
                // q 30.06 0 50.1 -21.52
                quadToRelative(
                    dx1 = 30.06f,
                    dy1 = 0.0f,
                    dx2 = 50.1f,
                    dy2 = -21.52f,
                )
                // q 20.04 -21.75 20.04 -58.93
                quadToRelative(
                    dx1 = 20.04f,
                    dy1 = -21.75f,
                    dx2 = 20.04f,
                    dy2 = -58.93f,
                )
            }
        }.build().also { _bazqux = it }
    }

@Preview
@Composable
private fun IconPreview() {
    PreviewTheme {
        Column(
            verticalArrangement = Arrangement.spacedBy(8.dp),
            horizontalAlignment = Alignment.CenterHorizontally,
        ) {
            Image(
                imageVector = Bazqux,
                contentDescription = null,
                modifier = Modifier
                    .width(512.0.dp)
                    .height(512.0.dp),
            )
        }
    }
}

@Suppress("ObjectPropertyName")
private var _bazqux: ImageVector? = null
