package com.prof18.feedflow.shared.ui.utils

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.prof18.feedflow.shared.ui.style.DarkColorScheme
import com.prof18.feedflow.shared.ui.style.LightColorScheme
import com.prof18.feedflow.shared.ui.style.Spacing

@Composable
fun PreviewHelper(
    modifier: Modifier = Modifier,
    paddingEnabled: Boolean = true,
    content: @Composable ColumnScope.() -> Unit,
) {
    Column(modifier = modifier) {
        PreviewTheme(darkTheme = false) {
            PreviewColumn(paddingEnabled = paddingEnabled, content = content)
        }
        PreviewTheme(darkTheme = true) {
            PreviewColumn(paddingEnabled = paddingEnabled, content = content)
        }
    }
}

@Composable
fun PreviewColumn(
    modifier: Modifier = Modifier,
    paddingEnabled: Boolean = true,
    content: @Composable ColumnScope.() -> Unit,
) {
    Column(
        modifier = modifier
            .background(MaterialTheme.colorScheme.background)
            .padding(
                if (paddingEnabled) Spacing.small else 0.dp,
            ),
        verticalArrangement = Arrangement.spacedBy(Spacing.small),
    ) {
        content()
    }
}

@Composable
fun PreviewTheme(
    darkTheme: Boolean,
    content: @Composable () -> Unit,
) {
    val colorScheme = when {
        darkTheme -> DarkColorScheme
        else -> LightColorScheme
    }

    MaterialTheme(
        colorScheme = colorScheme,
        content = content,
    )
}
