--Copyright 2014 Matthias Wimmer
--          2015 Dominik Meyer
--          2020 William Westcott
--Licensed under the Apache License, Version 2.0 (the "License");
--You may not use this file except in compliance with the License.
--You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
--Unless required by applicable law or agreed to in writing, software distributed under the License 
--is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--See the License for the specific language governing permissions and limitations under the License.

BEGIN;
DROP TABLE IF EXISTS android_metadata;
DROP TABLE IF EXISTS topic;
DROP TABLE IF EXISTS topic_exam_settings;
DROP TABLE IF EXISTS category;
DROP TABLE IF EXISTS question;
DROP TABLE IF EXISTS answer;
DROP TABLE IF EXISTS category_to_topic;
DROP TABLE IF EXISTS question_to_topic;
DROP TABLE IF EXISTS question_to_category;
DROP TABLE IF EXISTS outdated_questions;


CREATE TABLE android_metadata (locale TEXT);
INSERT INTO android_metadata VALUES('en-US');


CREATE TABLE topic (_id INT NOT NULL PRIMARY KEY, order_index INT NOT NULL UNIQUE, name TEXT NOT NULL, isprimary INT);
CREATE TABLE topic_exam_settings (_id INT NOT NULL PRIMARY KEY, topic_id INT NOT NULL REFERENCES topic(_id), number_questions INT, number_questions_pass INT, seconds_available INT);
CREATE TABLE category (_id INT NOT NULL PRIMARY KEY, name TEXT NOT NULL, reference TEXT NOT NULL, isprimary INT, parent INT REFERENCES category(_id));
CREATE TABLE question (_id INT NOT NULL PRIMARY KEY, reference TEXT, question TEXT NOT NULL, level INT NOT NULL, next_time INT NOT NULL, wrong INT, correct INT, help TEXT);
CREATE TABLE answer (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), order_index INT, answer TEXT NOT NULL, help TEXT);
CREATE TABLE category_to_topic (_id INT NOT NULL PRIMARY KEY, category_id INT NOT NULL REFERENCES category(_id), topic_id INT NOT NULL REFERENCES topic(_id));
CREATE TABLE question_to_topic (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), topic_id INT NOT NULL REFERENCES topic(_id));
CREATE TABLE question_to_category (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), category_id INT NOT NULL REFERENCES category(_id));
CREATE TABLE outdated_questions (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), outdated_since INT NOT NULL);


INSERT INTO topic VALUES (1, 1, 'Technician License (T)', 1);
INSERT INTO topic VALUES (2, 2, 'General License (G)', 1);
INSERT INTO topic VALUES (3, 3, 'Extra License (E)', 1);


INSERT INTO topic_exam_settings VALUES (1, 1, 35, 26, 1800);
INSERT INTO topic_exam_settings VALUES (2, 2, 35, 26, 1800);
INSERT INTO topic_exam_settings VALUES (3, 3, 50, 37, 3600);


INSERT INTO category VALUES (0, 'Category base', 'X', 1, 0);
INSERT INTO category VALUES (1, 'Technician License', 'T', 1, 0);
INSERT INTO category VALUES (2, 'General License', 'G', 1, 0);
INSERT INTO category VALUES (3, 'Extra License', 'E', 1, 0);

INSERT INTO category VALUES (4, 'FCC Rules, descriptions, and definitions for the Amateur Radio Service, operator and station license responsibilities', 'T1', 0, 1);
INSERT INTO category VALUES (5, 'Amateur Radio Service: purpose and permissible use of the Amateur Radio Service, operator/primary station license grant; Meanings of basic terms used in FCC rules; Interference; RACES rules; Phonetics; Frequency Coordinator ', 'T1A', 0, 4);
INSERT INTO category VALUES (6, 'Authorized frequencies: frequency allocations; ITU; emission modes; restricted sub-bands; spectrum sharing; transmissions near band edges; contacting the International Space Station; power output', 'T1B', 0, 4);
INSERT INTO category VALUES (7, 'Operator licensing: operator classes; sequential and vanity call sign systems; international communications; reciprocal operation; places where the Amateur Radio Service is regulated by the FCC; name and address on FCC license database; license term; renewal; grace period', 'T1C', 0, 4);
INSERT INTO category VALUES (8, 'Authorized and prohibited transmission: communications with other countries; music; exchange of information with other services; indecent language; compensation for use of station; retransmission of other amateur signals; codes and ciphers; sale of equipment; unidentified transmissions; one-way transmission', 'T1D', 0, 4);
INSERT INTO category VALUES (9, 'Control operator and control types: control operator required; eligibility; designation of control operator; privileges and duties; control point; local, automatic and remote control; location of control operator', 'T1E', 0, 4);
INSERT INTO category VALUES (10, 'Station identification; repeaters; third-party communications; club stations; FCC inspection', 'T1F', 0, 4);
INSERT INTO category VALUES (11, 'Operating Procedures', 'T2', 0, 1);
INSERT INTO category VALUES (12, 'Station operation: choosing an operating frequency; calling another station; test transmissions; procedural signs; use of minimum power; choosing an operating frequency; band plans; calling frequencies; repeater offsets ', 'T2A', 0, 11);
INSERT INTO category VALUES (13, 'VHF/UHF operating practices: SSB phone; FM repeater; simplex; splits and shifts; CTCSS; DTMF; tone squelch; carrier squelch; phonetics; operational problem resolution; Q signals', 'T2B', 0, 11);
INSERT INTO category VALUES (14, 'Public service: emergency and non-emergency operations; applicability of FCC rules; RACES and ARES; net and traffic procedures; operating restrictions during emergencies', 'T2C', 0, 11);
INSERT INTO category VALUES (15, 'Radio wave characteristics: properties of radio waves; propagation modes', 'T3', 0, 1);
INSERT INTO category VALUES (16, 'Radio wave characteristics: how a radio signal travels; fading; multipath; polarization; wavelength vs absorption; antenna orientation ', 'T3A', 0, 15);
INSERT INTO category VALUES (17, 'Radio and electromagnetic wave properties: the electromagnetic spectrum; wavelength vs frequency; nature and velocity of electromagnetic waves; definition of UHF, VHF, HF bands; calculating wavelength', 'T3B', 0, 15);
INSERT INTO category VALUES (18, 'Propagation modes: line of sight; sporadic E; meteor and auroral scatter and reflections; tropospheric ducting; F layer skip; radio horizon', 'T3C', 0, 15);
INSERT INTO category VALUES (19, 'Amateur radio practices and station set-up', 'T4', 0, 1);
INSERT INTO category VALUES (20, 'Station setup: connecting microphones; reducing unwanted emissions; power source; connecting a computer; RF grounding; connecting digital equipment; connecting an SWR meter ', 'T4A', 0, 19);
INSERT INTO category VALUES (21, 'Operating controls: tuning; use of filters; squelch function; AGC; transceiver operation; memory channels ', 'T4B', 0, 19);
INSERT INTO category VALUES (22, 'Electrical principles: math for electronics; electronic principles; Ohm’s Law', 'T5', 0, 1);
INSERT INTO category VALUES (23, 'Electrical principles, units, and terms: current and voltage; conductors and insulators; alternating and direct current; series and parallel circuits ', 'T5A', 0, 22);
INSERT INTO category VALUES (24, 'Math for electronics: conversion of electrical units; decibels; the metric system', 'T5B', 0, 22);
INSERT INTO category VALUES (25, 'Electronic principles: capacitance; inductance; current flow in circuits; alternating current; definition of RF; definition of polarity; DC power calculations; impedance', 'T5C', 0, 22);
INSERT INTO category VALUES (26, 'Ohm’s Law: formulas and usage; components in series and parallel', 'T5D', 0, 22);
INSERT INTO category VALUES (27, 'Electrical components; circuit diagrams; component functions', 'T6', 0, 1);
INSERT INTO category VALUES (28, 'Electrical components: fixed and variable resistors; capacitors and inductors; fuses; switches; batteries ', 'T6A', 0, 27);
INSERT INTO category VALUES (29, 'Semiconductors: basic principles and applications of solid state devices; diodes and transistors', 'T6B', 0, 27);
INSERT INTO category VALUES (30, 'Circuit diagrams; schematic symbols', 'T6C', 0, 27);
INSERT INTO category VALUES (31, 'Component functions: rectification; switches; indicators; power supply components; resonant circuit; shielding; power transformers; integrated circuits', 'T6D', 0, 27);
INSERT INTO category VALUES (32, 'Station equipment: common transmitter and receiver problems; antenna measurements; troubleshooting; basic repair and testing', 'T7', 0, 1);
INSERT INTO category VALUES (33, 'Station equipment: receivers; transmitters; transceivers; modulation; transverters; transmit and receive amplifiers ', 'T7A', 0, 32);
INSERT INTO category VALUES (34, 'Common transmitter and receiver problems: symptoms of overload and overdrive; distortion; causes of interference; interference and consumer electronics; part 15 devices; over-modulation; RF feedback; off frequency signals', 'T7B', 0, 32);
INSERT INTO category VALUES (35, 'Antenna measurements and troubleshooting: measuring SWR; dummy loads; coaxial cables; causes of feed line failures', 'T7C', 0, 32);
INSERT INTO category VALUES (36, 'Basic repair and testing: soldering; using basic test instruments; connecting a voltmeter, ammeter, or ohmmeter', 'T7D', 0, 32);
INSERT INTO category VALUES (37, 'Modulation modes: amateur satellite operation; operating activities; non-voice and digital communications', 'T8', 0, 1);
INSERT INTO category VALUES (38, 'Modulation modes: bandwidth of various signals; choice of emission type ', 'T8A', 0, 37);
INSERT INTO category VALUES (39, 'Amateur satellite operation; Doppler shift; basic orbits; operating protocols; transmitter power considerations; telemetry and telecommand; satellite tracking ', 'T8B', 0, 37);
INSERT INTO category VALUES (40, 'Operating activities: radio direction finding; radio control; contests; linking over the internet; grid locators', 'T8C', 0, 37);
INSERT INTO category VALUES (41, 'Non-voice and digital communications: image signals; digital modes; CW; packet radio; PSK31; APRS; error detection and correction; NTSC; amateur radio networking; Digital Mobile/Migration Radio ', 'T8D', 0, 37);
INSERT INTO category VALUES (42, 'Antennas and feed lines', 'T9', 0, 1);
INSERT INTO category VALUES (43, 'Antennas: vertical and horizontal polarization; concept of gain; common portable and mobile antennas; relationships between resonant length and frequency; concept of dipole antennas ', 'T9A', 0, 42);
INSERT INTO category VALUES (44, 'Feed lines: types, attenuation vs frequency, selecting; SWR concepts; Antenna tuners (couplers); RF Connectors: selecting, weather protection', 'T9B', 0, 42);
INSERT INTO category VALUES (45, 'Electrical safety: AC and DC power circuits; antenna installation; RF hazards', 'T0', 0, 1);
INSERT INTO category VALUES (46, 'Power circuits and hazards: hazardous voltages; fuses and circuit breakers; grounding; lightning protection; battery safety; electrical code compliance ', 'T0A', 0, 45);
INSERT INTO category VALUES (47, 'Antenna safety: tower safety and grounding; erecting an antenna support; safely installing an antenna', 'T0B', 0, 45);
INSERT INTO category VALUES (48, 'RF hazards: radiation exposure; proximity to antennas; recognized safe power levels; exposure to others; radiation types; duty cycle', 'T0C', 0, 45);

INSERT INTO category VALUES (49, 'COMMISSION’S RULES', 'G1', 0, 2);
INSERT INTO category VALUES (50, 'General class control operator frequency privileges; primary and secondary allocations ', 'G1A', 0, 49);
INSERT INTO category VALUES (51, 'Antenna structure limitations; good engineering and good amateur practice; beacon operation; prohibited transmissions; retransmitting radio signals', 'G1B', 0, 49);
INSERT INTO category VALUES (52, 'Transmitter power regulations; data emission standards; 60-meter operation requirements', 'G1C', 0, 49);
INSERT INTO category VALUES (53, 'Volunteer Examiners and Volunteer Examiner Coordinators; temporary identification; element credit', 'G1D', 0, 49);
INSERT INTO category VALUES (54, 'Control categories; repeater regulations; third-party rules; ITU regions; automatically controlled digital station', 'G1E', 0, 49);
INSERT INTO category VALUES (55, 'OPERATING PROCEDURES', 'G2', 0, 2);
INSERT INTO category VALUES (56, 'Phone operating procedures; USB/LSB conventions; breaking into a contact; VOX operation ', 'G2A', 0, 55);
INSERT INTO category VALUES (57, 'Operating courtesy; band plans; emergencies, including drills and emergency communications', 'G2B', 0, 55);
INSERT INTO category VALUES (58, 'CW operating procedures and procedural signals; Q signals and common abbreviations: full break-in', 'G2C', 0, 55);
INSERT INTO category VALUES (59, 'Volunteer Monitoring Program; HF operations', 'G2D', 0, 55);
INSERT INTO category VALUES (60, 'Digital operating procedures', 'G2E', 0, 55);
INSERT INTO category VALUES (61, 'RADIO WAVE PROPAGATION', 'G3', 0, 2);
INSERT INTO category VALUES (62, 'Sunspots and solar radiation; ionospheric disturbances; propagation forecasting and indices', 'G3A', 0, 61);
INSERT INTO category VALUES (63, 'Maximum Usable Frequency; Lowest Usable Frequency; propagation', 'G3B', 0, 61);
INSERT INTO category VALUES (64, 'Ionospheric layers; critical angle and frequency; HF scatter; Near Vertical Incidence Skywave', 'G3C', 0, 61);
INSERT INTO category VALUES (65, 'AMATEUR RADIO PRACTICES', 'G4', 0, 2);
INSERT INTO category VALUES (66, 'Station operation and setup', 'G4A', 0, 65);
INSERT INTO category VALUES (67, 'Test and monitoring equipment; two-tone test', 'G4B', 0, 65);
INSERT INTO category VALUES (68, 'Interference to consumer electronics; grounding; DSP', 'G4C', 0, 65);
INSERT INTO category VALUES (69, 'Speech processors; S meters; sideband operation near band edges', 'G4D', 0, 65);
INSERT INTO category VALUES (70, 'HF mobile radio installations; alternative energy source operation', 'G4E', 0, 65);
INSERT INTO category VALUES (71, 'ELECTRICAL PRINCIPLES', 'G5', 0, 2);
INSERT INTO category VALUES (72, 'Reactance; inductance; capacitance; impedance; impedance matching', 'G5A', 0, 71);
INSERT INTO category VALUES (73, 'The decibel; current and voltage dividers; electrical power calculations; sine wave root-mean-square (RMS) values; PEP calculations', 'G5B', 0, 71);
INSERT INTO category VALUES (74, 'Resistors, capacitors, and inductors in series and parallel; transformers', 'G5C', 0, 71);
INSERT INTO category VALUES (75, 'CIRCUIT COMPONENTS', 'G6', 0, 2);
INSERT INTO category VALUES (76, 'Resistors; capacitors; inductors; rectifiers; solid-state diodes and transistors; vacuum tubes; batteries', 'G6A', 0, 75);
INSERT INTO category VALUES (77, 'Analog and digital integrated circuits (ICs); memory; I/O devices; microwave ICs (MMICs); display devices; connectors; ferrite cores', 'G6B', 0, 75);
INSERT INTO category VALUES (78, 'PRACTICAL CIRCUITS', 'G7', 0, 2);
INSERT INTO category VALUES (79, 'Power supplies; schematic symbols', 'G7A', 0, 78);
INSERT INTO category VALUES (80, 'Digital circuits; amplifiers and oscillators', 'G7B', 0, 78);
INSERT INTO category VALUES (81, 'Receivers and transmitters; filters; oscillators', 'G7C', 0, 78);
INSERT INTO category VALUES (82, 'SIGNALS AND EMISSIONS', 'G8', 0, 2);
INSERT INTO category VALUES (83, 'Carriers and modulation: AM; FM; single sideband; modulation envelope; digital modulation; overmodulation', 'G8A', 0, 82);
INSERT INTO category VALUES (84, 'Frequency mixing; multiplication; bandwidths of various modes; deviation; duty cycle; intermodulation', 'G8B', 0, 82);
INSERT INTO category VALUES (85, 'Digital emission modes', 'G8C', 0, 82);
INSERT INTO category VALUES (86, 'ANTENNAS AND FEED LINES', 'G9', 0, 2);
INSERT INTO category VALUES (87, 'Antenna feed lines: characteristic impedance and attenuation; SWR calculation, measurement, and effects; matching networks', 'G9A', 0, 86);
INSERT INTO category VALUES (88, 'Basic antennas', 'G9B', 0, 86);
INSERT INTO category VALUES (89, 'Directional antennas', 'G9C', 0, 86);
INSERT INTO category VALUES (90, 'Specialized antennas', 'G9D', 0, 86);
INSERT INTO category VALUES (91, 'ELECTRICAL AND RF SAFETY', 'G0', 0, 2);
INSERT INTO category VALUES (92, 'RF safety principles, rules and guidelines; routine station evaluation', 'G0A', 0, 91);
INSERT INTO category VALUES (93, 'Station safety: electrical shock, safety grounding, fusing, interlocks, wiring, antenna and tower safety', 'G0B', 0, 91);

INSERT INTO category VALUES (94, 'COMMISSION RULES', 'E1', 0, 3);
INSERT INTO category VALUES (95, 'Operating Standards: frequency privileges; automatic message forwarding; stations aboard ships or aircraft; power restriction on 630 and 2200 meter bands ', 'E1A', 0, 94);
INSERT INTO category VALUES (96, 'Station restrictions and special operations: restrictions on station location; general operating restrictions; spurious emissions; antenna structure restrictions; RACES operations ', 'E1B', 0, 94);
INSERT INTO category VALUES (97, 'Rules pertaining to automatic and remote control; band-specific regulations; operating in, and communicating with foreign countries; spurious emission standards; HF modulation index limit; bandwidth definition ', 'E1C', 0, 94);
INSERT INTO category VALUES (98, 'Amateur space and Earth stations; telemetry and telecommand rules; identification of balloon transmissions; one-way communications ', 'E1D', 0, 94);
INSERT INTO category VALUES (99, 'Volunteer examiner program: definitions; qualifications; preparation and administration of exams; accreditation; question pools; documentation requirements ', 'E1E', 0, 94);
INSERT INTO category VALUES (100, 'Miscellaneous rules: external RF power amplifiers; prohibited communications; spread spectrum; auxiliary stations; Canadian amateurs operating in the U.S.; special temporary authority; control operator of an auxiliary station ', 'E1F', 0, 94);
INSERT INTO category VALUES (101, 'OPERATING PROCEDURES', 'E2', 0, 3);
INSERT INTO category VALUES (102, 'Amateur radio in space: amateur satellites; orbital mechanics; frequencies and modes; satellite hardware; satellite operations ', 'E2A', 0, 101);
INSERT INTO category VALUES (103, 'Television practices: fast scan television standards and techniques; slow scan television standards and techniques ', 'E2B', 0, 101);
INSERT INTO category VALUES (104, 'Operating methods: contest and DX operating; remote operation techniques; Cabrillo format; QSLing; RF network connected systems ', 'E2C', 0, 101);
INSERT INTO category VALUES (105, 'Operating methods: VHF and UHF digital modes and procedures; APRS; EME procedures; meteor scatter procedures ', 'E2D', 0, 101);
INSERT INTO category VALUES (106, 'Operating methods: operating HF digital modes ', 'E2E', 0, 101);
INSERT INTO category VALUES (107, 'RADIO WAVE PROPAGATION', 'E3', 0, 3);
INSERT INTO category VALUES (108, 'Electromagnetic waves; Earth-Moon-Earth communications; meteor scatter; microwave tropospheric and scatter propagation; aurora propagation; ionospheric propagation changes over the day; circular polarization ', 'E3A', 0, 107);
INSERT INTO category VALUES (109, 'Transequatorial propagation; long-path; grayline; ordinary and extraordinary waves; chordal hop; sporadic E mechanisms ', 'E3B', 0, 107);
INSERT INTO category VALUES (110, 'Radio horizon; ground wave; propagation prediction techniques and modeling; effects of space weather parameters on propagation ', 'E3C', 0, 107);
INSERT INTO category VALUES (111, 'AMATEUR PRACTICES', 'E4', 0, 3);
INSERT INTO category VALUES (112, 'Test equipment: analog and digital instruments; spectrum analyzers; antenna analyzers; oscilloscopes; RF measurements; computer-aided measurements ', 'E4A', 0, 111);
INSERT INTO category VALUES (113, 'Measurement technique and limitations: instrument accuracy and performance limitations; probes; techniques to minimize errors; measurement of Q; instrument calibration; S parameters; vector network analyzers ', 'E4B', 0, 111);
INSERT INTO category VALUES (114, 'Receiver performance characteristics: phase noise, noise floor, image rejection, MDS, signal-to-noise ratio, noise figure, reciprocal mixing; selectivity; effects of SDR receiver non-linearity; use of attenuators at low frequencies ', 'E4C', 0, 111);
INSERT INTO category VALUES (115, 'Receiver performance characteristics: blocking dynamic range; intermodulation and cross-modulation interference; third-order intercept; desensitization; preselector ', 'E4D', 0, 111);
INSERT INTO category VALUES (116, 'Noise suppression and interference: system noise; electrical appliance noise; line noise; locating noise sources; DSP noise reduction; noise blankers; grounding for signals; common mode currents ', 'E4E', 0, 111);
INSERT INTO category VALUES (117, 'ELECTRICAL PRINCIPLES', 'E5', 0, 3);
INSERT INTO category VALUES (118, 'Resonance and Q: characteristics of resonant circuits: series and parallel resonance; definitions and effects of Q; half-power bandwidth; phase relationships in reactive circuits ', 'E5A', 0, 117);
INSERT INTO category VALUES (119, 'Time constants and phase relationships: RL and RC time constants; phase angle in reactive circuits and components; admittance and susceptance ', 'E5B', 0, 117);
INSERT INTO category VALUES (120, 'Coordinate systems and phasors in electronics: Rectangular Coordinates; Polar Coordinates; Phasors ', 'E5C', 0, 117);
INSERT INTO category VALUES (121, 'AC and RF energy in real circuits: skin effect; electromagnetic fields; reactive power; power factor; electrical length of conductors at UHF and microwave frequencies; microstrip ', 'E5D', 0, 117);
INSERT INTO category VALUES (122, 'CIRCUIT COMPONENTS', 'E6', 0, 3);
INSERT INTO category VALUES (123, 'Semiconductor materials and devices: semiconductor materials; germanium, silicon, P-type, N-type; transistor types: NPN, PNP, junction, field-effect transistors: enhancement mode; depletion mode; MOS; CMOS; N-channel; P-channel ', 'E6A', 0, 122);
INSERT INTO category VALUES (124, 'Diodes ', 'E6B', 0, 122);
INSERT INTO category VALUES (125, 'Digital ICs: Families of digital ICs; gates; Programmable Logic Devices (PLDs) ', 'E6C', 0, 122);
INSERT INTO category VALUES (126, 'Toroidal and Solenoidal Inductors: permeability, core material, selecting, winding; transformers; piezoelectric devices ', 'E6D', 0, 122);
INSERT INTO category VALUES (127, 'Analog ICs: MMICs, IC packaging characteristics ', 'E6E', 0, 122);
INSERT INTO category VALUES (128, 'Electro-optical technology: photoconductivity; photovoltaic devices; optical sensors and encoders; optical isolation ', 'E6F', 0, 122);
INSERT INTO category VALUES (129, 'PRACTICAL CIRCUITS', 'E7', 0, 3);
INSERT INTO category VALUES (130, 'Digital circuits: digital circuit principles and logic circuits; classes of logic elements; positive and negative logic; frequency dividers; truth tables ', 'E7A', 0, 129);
INSERT INTO category VALUES (131, 'Amplifiers: Class of operation; vacuum tube and solid-state circuits; distortion and intermodulation; spurious and parasitic suppression; microwave amplifiers; switching-type amplifiers ', 'E7B', 0, 129);
INSERT INTO category VALUES (132, 'Filters and matching networks: types of networks; types of filters; filter applications; filter characteristics; impedance matching; DSP filtering ', 'E7C', 0, 129);
INSERT INTO category VALUES (133, 'Power supplies and voltage regulators; Solar array charge controllers ', 'E7D', 0, 129);
INSERT INTO category VALUES (134, 'Modulation and demodulation: reactance, phase and balanced modulators; detectors; mixer stages ', 'E7E', 0, 129);
INSERT INTO category VALUES (135, 'DSP filtering and other operations; software defined radio fundamentals; DSP modulation and demodulation ', 'E7F', 0, 129);
INSERT INTO category VALUES (136, 'Active filters and op-amp circuits: active audio filters; characteristics; basic circuit design; operational amplifiers ', 'E7G', 0, 129);
INSERT INTO category VALUES (137, 'Oscillators and signal sources: types of oscillators; synthesizers and phase-locked loops; direct digital synthesizers; stabilizing thermal drift; microphonics; high-accuracy oscillators ', 'E7H', 0, 129);
INSERT INTO category VALUES (138, 'SIGNALS AND EMISSIONS', 'E8', 0, 3);
INSERT INTO category VALUES (139, 'AC waveforms: sine, square, and irregular waveforms; AC measurements; average power and PEP of RF signals; Fourier analysis; analog to digital conversion: digital to analog conversion; advantages of digital communications ', 'E8A', 0, 138);
INSERT INTO category VALUES (140, 'Modulation and demodulation: modulation methods; modulation index and deviation ratio; frequency and time division multiplexing; Orthogonal Frequency Division Multiplexing ', 'E8B', 0, 138);
INSERT INTO category VALUES (141, 'Digital signals: digital communication modes; information rate vs. bandwidth; error correction ', 'E8C', 0, 138);
INSERT INTO category VALUES (142, 'Keying defects and overmodulation of digital signals; digital codes; spread spectrum ', 'E8D', 0, 138);
INSERT INTO category VALUES (143, 'ANTENNAS AND TRANSMISSION LINES', 'E9', 0, 3);
INSERT INTO category VALUES (144, 'Basic Antenna parameters: radiation resistance, gain, beamwidth, efficiency; effective radiated power ', 'E9A', 0, 143);
INSERT INTO category VALUES (145, 'Antenna patterns and designs: E and H plane patterns; gain as a function of pattern; antenna modeling ', 'E9B', 0, 143);
INSERT INTO category VALUES (146, 'Practical wire antennas; folded dipoles; phased arrays; effects of ground near antennas ', 'E9C', 0, 143);
INSERT INTO category VALUES (147, 'Yagi antennas; parabolic reflectors; circular polarization; loading coils; top loading; feedpoint impedance of electrically short antennas; antenna Q; RF grounding ', 'E9D', 0, 143);
INSERT INTO category VALUES (148, 'Matching: matching antennas to feed lines; phasing lines; power dividers ', 'E9E', 0, 143);
INSERT INTO category VALUES (149, 'Transmission lines: characteristics of open and shorted feed lines; coax versus open-wire; velocity factor; electrical length; coaxial cable dielectrics ', 'E9F', 0, 143);
INSERT INTO category VALUES (150, 'The Smith chart ', 'E9G', 0, 143);
INSERT INTO category VALUES (151, 'Receiving Antennas: radio direction finding antennas; Beverage antennas; specialized receiving antennas; long-wire receiving antennas ', 'E9H', 0, 143);
INSERT INTO category VALUES (152, 'SAFETY', 'E0', 0, 3);
INSERT INTO category VALUES (153, 'Safety: RF radiation hazards; hazardous materials; grounding ', 'E0A', 0, 152);


INSERT INTO question VALUES (1, 'T1A01', 'Which of the following is a purpose of the Amateur Radio Service as stated in the FCC rules and regulations?', 0, 1, 0, 0, '97.1');
INSERT INTO question VALUES (2, 'T1A02', 'Which agency regulates and enforces the rules for the Amateur Radio Service in the United States?', 0, 1, 0, 0, '97.1');
INSERT INTO question VALUES (3, 'T1A03', 'What are the FCC rules regarding the use of a phonetic alphabet for station identification in the Amateur Radio Service?', 0, 1, 0, 0, '97.119(b)(2)');
INSERT INTO question VALUES (4, 'T1A04', 'How many operator/primary station license grants may be held by any one person?', 0, 1, 0, 0, '97.5(b)(1)');
INSERT INTO question VALUES (5, 'T1A05', 'What is proof of possession of an FCC-issued operator/primary license grant?', 0, 1, 0, 0, '97.7');
INSERT INTO question VALUES (6, 'T1A06', 'What is the FCC Part 97 definition of a beacon?', 0, 1, 0, 0, '97.3(a)(9)');
INSERT INTO question VALUES (7, 'T1A07', 'What is the FCC Part 97 definition of a space station?', 0, 1, 0, 0, '97.3(a)(41)');
INSERT INTO question VALUES (8, 'T1A08', 'Which of the following entities recommends transmit/receive channels and other parameters for auxiliary and repeater stations?', 0, 1, 0, 0, '97.3(a)(22)');
INSERT INTO question VALUES (9, 'T1A09', 'Who selects a Frequency Coordinator?', 0, 1, 0, 0, '97.3(a)(22)');
INSERT INTO question VALUES (10, 'T1A10', 'Which of the following describes the Radio Amateur Civil Emergency Service (RACES)?', 0, 1, 0, 0, '97.3(a)(38), 97.407');
INSERT INTO question VALUES (11, 'T1A11', 'When is willful interference to other amateur radio stations permitted?', 0, 1, 0, 0, '97.101 (d)');
INSERT INTO question VALUES (12, 'T1B01', 'What is the International Telecommunications Union (ITU)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (13, 'T1B02', 'Which amateur radio stations may make contact with an amateur radio station on the International Space Station (ISS) using 2 meter and 70 cm band frequencies?', 0, 1, 0, 0, '97.301, 97.207(c)');
INSERT INTO question VALUES (14, 'T1B03', 'Which frequency is within the 6 meter amateur band?', 0, 1, 0, 0, '97.301(a)');
INSERT INTO question VALUES (15, 'T1B04', 'Which amateur band are you using when your station is transmitting on 146.52 MHz?', 0, 1, 0, 0, '97.301(a)');
INSERT INTO question VALUES (16, 'T1B05', 'What is the limitation for emissions on the frequencies between 219 and 220 MHz?', 0, 1, 0, 0, '97.305(c)');
INSERT INTO question VALUES (17, 'T1B06', 'On which HF bands does a Technician class operator have phone privileges?', 0, 1, 0, 0, '97.301(e), 97.305');
INSERT INTO question VALUES (18, 'T1B07', 'Which of the following VHF/UHF frequency ranges are limited to CW only?', 0, 1, 0, 0, '97.305(a), (c)');
INSERT INTO question VALUES (19, 'T1B08', 'Which of the following is a result of the fact that the Amateur Radio Service is secondary in all or portions of some amateur bands (such as portions of the 70 cm band)?', 0, 1, 0, 0, '97.303');
INSERT INTO question VALUES (20, 'T1B09', 'Why should you not set your transmit frequency to be exactly at the edge of an amateur band or sub-band?', 0, 1, 0, 0, '97.101(a), 97.301(a-e)');
INSERT INTO question VALUES (21, 'T1B10', 'Which of the following HF bands have frequencies available to the Technician class operator for RTTY and data transmissions?', 0, 1, 0, 0, '97.301(e), 97.305(c)');
INSERT INTO question VALUES (22, 'T1B11', 'What is the maximum peak envelope power output for Technician class operators using their assigned portions of the HF bands?', 0, 1, 0, 0, '97.313');
INSERT INTO question VALUES (23, 'T1B12', 'Except for some specific restrictions, what is the maximum peak envelope power output for Technician class operators using frequencies above 30 MHz?', 0, 1, 0, 0, '97.313(b)');
INSERT INTO question VALUES (24, 'T1C01', 'For which license classes are new licenses currently available from the FCC?', 0, 1, 0, 0, '97.9(a), 97.17(a)');
INSERT INTO question VALUES (25, 'T1C02', 'Who may select a desired call sign under the vanity call sign rules?', 0, 1, 0, 0, '97.19');
INSERT INTO question VALUES (26, 'T1C03', 'What types of international communications is an FCC-licensed amateur radio station permitted to make?', 0, 1, 0, 0, '97.117');
INSERT INTO question VALUES (27, 'T1C04', 'When are you allowed to operate your amateur station in a foreign country?', 0, 1, 0, 0, '97.107');
INSERT INTO question VALUES (28, 'T1C05', 'Which of the following is a valid call sign for a Technician class amateur radio station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (29, 'T1C06', 'From which of the following locations may an FCC-licensed amateur station transmit?', 0, 1, 0, 0, '97.5(a)(2)');
INSERT INTO question VALUES (30, 'T1C07', 'What may result when correspondence from the FCC is returned as undeliverable because the grantee failed to provide and maintain a correct mailing address with the FCC?', 0, 1, 0, 0, '97.23');
INSERT INTO question VALUES (31, 'T1C08', 'What is the normal term for an FCC-issued primary station/operator amateur radio license grant?', 0, 1, 0, 0, '97.25');
INSERT INTO question VALUES (32, 'T1C09', 'What is the grace period following the expiration of an amateur license within which the license may be renewed?', 0, 1, 0, 0, '97.21(a)(b)');
INSERT INTO question VALUES (33, 'T1C10', 'How soon after passing the examination for your first amateur radio license may you operate a transmitter on an Amateur Radio Service frequency?', 0, 1, 0, 0, '97.5a');
INSERT INTO question VALUES (34, 'T1C11', 'If your license has expired and is still within the allowable grace period, may you continue to operate a transmitter on Amateur Radio Service frequencies?', 0, 1, 0, 0, '97.21(b)');
INSERT INTO question VALUES (35, 'T1D01', 'With which countries are FCC-licensed amateur radio stations prohibited from exchanging communications?', 0, 1, 0, 0, '97.111(a)(1)');
INSERT INTO question VALUES (36, 'T1D02', 'Under which of the following circumstances may an amateur radio station make one-way transmissions?', 0, 1, 0, 0, '97.113(b),97.111(b)');
INSERT INTO question VALUES (37, 'T1D03', 'When is it permissible to transmit messages encoded to hide their meaning?', 0, 1, 0, 0, '97.211(b), 97.215(b), 97.114(a)(4)');
INSERT INTO question VALUES (38, 'T1D04', 'Under what conditions is an amateur station authorized to transmit music using a phone emission?', 0, 1, 0, 0, '97.113(a)(4), 97.113(c)');
INSERT INTO question VALUES (39, 'T1D05', 'When may amateur radio operators use their stations to notify other amateurs of the availability of equipment for sale or trade?', 0, 1, 0, 0, '97.113(a)(3)(ii)');
INSERT INTO question VALUES (40, 'T1D06', 'What, if any, are the restrictions concerning transmission of language that may be considered indecent or obscene?', 0, 1, 0, 0, '97.113(a)(4)');
INSERT INTO question VALUES (41, 'T1D07', 'What types of amateur stations can automatically retransmit the signals of other amateur stations?', 0, 1, 0, 0, '97.113(d)');
INSERT INTO question VALUES (42, 'T1D08', 'In which of the following circumstances may the control operator of an amateur station receive compensation for operating that station?', 0, 1, 0, 0, '97.113(a)(3)(iii)');
INSERT INTO question VALUES (43, 'T1D09', 'Under which of the following circumstances are amateur stations authorized to transmit signals related to broadcasting, program production, or news gathering, assuming no other means is available?', 0, 1, 0, 0, '97.113(5)(b)');
INSERT INTO question VALUES (44, 'T1D10', 'What is the meaning of the term broadcasting in the FCC rules for the Amateur Radio Service?', 0, 1, 0, 0, '97.3(a)(10)');
INSERT INTO question VALUES (45, 'T1D11', 'When may an amateur station transmit without on-the-air identification?', 0, 1, 0, 0, '97.119(a)');
INSERT INTO question VALUES (46, 'T1E01', 'When is an amateur station permitted to transmit without a control operator?', 0, 1, 0, 0, '97.7(a)');
INSERT INTO question VALUES (47, 'T1E02', 'Who may be the control operator of a station communicating through an amateur satellite or space station?', 0, 1, 0, 0, '97.301, 97.207(c)');
INSERT INTO question VALUES (48, 'T1E03', 'Who must designate the station control operator?', 0, 1, 0, 0, '97.103(b)');
INSERT INTO question VALUES (49, 'T1E04', 'What determines the transmitting privileges of an amateur station?', 0, 1, 0, 0, '97.103(b)');
INSERT INTO question VALUES (50, 'T1E05', 'What is an amateur station control point?', 0, 1, 0, 0, '97.3(a)(14)');
INSERT INTO question VALUES (51, 'T1E06', 'When, under normal circumstances, may a Technician class licensee be the control operator of a station operating in an exclusive Amateur Extra class operator segment of the amateur bands?', 0, 1, 0, 0, '97.301');
INSERT INTO question VALUES (52, 'T1E07', 'When the control operator is not the station licensee, who is responsible for the proper operation of the station?', 0, 1, 0, 0, '97.103(a)');
INSERT INTO question VALUES (53, 'T1E08', 'Which of the following is an example of automatic control?', 0, 1, 0, 0, '97.3(a)(6), 97.205(d)');
INSERT INTO question VALUES (54, 'T1E09', 'Which of the following is true of remote control operation?', 0, 1, 0, 0, '97.109(c)');
INSERT INTO question VALUES (55, 'T1E10', 'Which of the following is an example of remote control as defined in Part 97?', 0, 1, 0, 0, '97.3(a)(39)');
INSERT INTO question VALUES (56, 'T1E11', 'Who does the FCC presume to be the control operator of an amateur station, unless documentation to the contrary is in the station records?', 0, 1, 0, 0, '97.103(a)');
INSERT INTO question VALUES (57, 'T1F01', 'When must the station licensee make the station and its records available for FCC inspection?', 0, 1, 0, 0, '97.103(c)');
INSERT INTO question VALUES (58, 'T1F02', 'When using tactical identifiers such as “Race Headquarters” during a community service net operation, how often must your station transmit the station’s FCC-assigned call sign?', 0, 1, 0, 0, '97.119 (a)');
INSERT INTO question VALUES (59, 'T1F03', 'When is an amateur station required to transmit its assigned call sign?', 0, 1, 0, 0, '97.119(a)');
INSERT INTO question VALUES (60, 'T1F04', 'Which of the following is an acceptable language to use for station identification when operating in a phone sub-band?', 0, 1, 0, 0, '97.119(b)(2)');
INSERT INTO question VALUES (61, 'T1F05', 'What method of call sign identification is required for a station transmitting phone signals?', 0, 1, 0, 0, '97.119(b)(2)');
INSERT INTO question VALUES (62, 'T1F06', 'Which of the following formats of a self-assigned indicator is acceptable when identifying using a phone transmission?', 0, 1, 0, 0, '97.119(c)');
INSERT INTO question VALUES (63, 'T1F07', 'Which of the following restrictions apply when a non-licensed person is allowed to speak to a foreign station using a station under the control of a Technician class control operator?', 0, 1, 0, 0, '97.115(a)(2)');
INSERT INTO question VALUES (64, 'T1F08', 'What is meant by the term Third Party Communications?', 0, 1, 0, 0, '97.3(a)(47)');
INSERT INTO question VALUES (65, 'T1F09', 'What type of amateur station simultaneously retransmits the signal of another amateur station on a different channel or channels?', 0, 1, 0, 0, '97.3(a)(40)');
INSERT INTO question VALUES (66, 'T1F10', 'Who is accountable should a repeater inadvertently retransmit communications that violate the FCC rules?', 0, 1, 0, 0, '97.205(g)');
INSERT INTO question VALUES (67, 'T1F11', 'Which of the following is a requirement for the issuance of a club station license grant?', 0, 1, 0, 0, '97.5(b)(2)');
INSERT INTO question VALUES (68, 'T2A01', 'Which of the following is a common repeater frequency offset in the 2 meter band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (69, 'T2A02', 'What is the national calling frequency for FM simplex operations in the 2 meter band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (70, 'T2A03', 'What is a common repeater frequency offset in the 70 cm band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (71, 'T2A04', 'What is an appropriate way to call another station on a repeater if you know the other station''s call sign?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (72, 'T2A05', 'How should you respond to a station calling CQ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (73, 'T2A06', 'Which of the following is required when making on-the-air test transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (74, 'T2A07', 'What is meant by "repeater offset?"', 0, 1, 0, 0, '');
INSERT INTO question VALUES (75, 'T2A08', 'What is the meaning of the procedural signal “CQ”?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (76, 'T2A09', 'What brief statement indicates that you are listening on a repeater and looking for a contact?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (77, 'T2A10', 'What is a band plan, beyond the privileges established by the FCC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (78, 'T2A11', 'What term describes an amateur station that is transmitting and receiving on the same frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (79, 'T2A12', 'Which of the following is a guideline when choosing an operating frequency for calling CQ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (80, 'T2B01', 'What is the most common use of the “reverse split” function of a VHF/UHF transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (81, 'T2B02', 'What term describes the use of a sub-audible tone transmitted along with normal voice audio to open the squelch of a receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (82, 'T2B03', 'If a station is not strong enough to keep a repeater’s receiver squelch open, which of the following might allow you to receive the station’s signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (83, 'T2B04', 'Which of the following could be the reason you are unable to access a repeater whose output you can hear?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (84, 'T2B05', 'What might be the problem if a repeater user says your transmissions are breaking up on voice peaks?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (85, 'T2B06', 'What type of tones are used to control repeaters linked by the Internet Relay Linking Project (IRLP) protocol?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (86, 'T2B07', 'How can you join a digital repeater’s “talk group”?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (87, 'T2B08', 'Which of the following applies when two stations transmitting on the same frequency interfere with each other?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (88, 'T2B09', 'What is a “talk group” on a DMR digital repeater?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (89, 'T2B10', 'Which Q signal indicates that you are receiving interference from other stations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (90, 'T2B11', 'Which Q signal indicates that you are changing frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (91, 'T2B12', 'Why are simplex channels designated in the VHF/UHF band plans?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (92, 'T2B13', 'Where may SSB phone be used in amateur bands above 50 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (93, 'T2B14', 'Which of the following describes a linked repeater network?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (94, 'T2C01', 'When do the FCC rules NOT apply to the operation of an amateur station?', 0, 1, 0, 0, '97.103(a)');
INSERT INTO question VALUES (95, 'T2C02', 'What is meant by the term "NCS" used in net operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (96, 'T2C03', 'What should be done when using voice modes to ensure that voice messages containing unusual words are received correctly?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (97, 'T2C04', 'What do RACES and ARES have in common?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (98, 'T2C05', 'What does the term “traffic” refer to in net operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (99, 'T2C06', 'Which of the following is an accepted practice to get the immediate attention of a net control station when reporting an emergency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (100, 'T2C07', 'Which of the following is an accepted practice for an amateur operator who has checked into a net?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (101, 'T2C08', 'Which of the following is a characteristic of good traffic handling?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (102, 'T2C09', 'Are amateur station control operators ever permitted to operate outside the frequency privileges of their license class?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (103, 'T2C10', 'What information is contained in the preamble of a formal traffic message?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (104, 'T2C11', 'What is meant by the term “check,” in reference to a formal traffic message?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (105, 'T2C12', 'What is the Amateur Radio Emergency Service (ARES)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (106, 'T3A01', 'What should you do if another operator reports that your station’s 2 meter signals were strong just a moment ago, but now they are weak or distorted?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (107, 'T3A02', 'Why might the range of VHF and UHF signals be greater in the winter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (108, 'T3A03', 'What antenna polarization is normally used for long-distance weak-signal CW and SSB contacts using the VHF and UHF bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (109, 'T3A04', 'What can happen if the antennas at opposite ends of a VHF or UHF line of sight radio link are not using the same polarization?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (110, 'T3A05', 'When using a directional antenna, how might your station be able to access a distant repeater if buildings or obstructions are blocking the direct line of sight path?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (111, 'T3A06', 'What term is commonly used to describe the rapid fluttering sound sometimes heard from mobile stations that are moving while transmitting?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (112, 'T3A07', 'What type of wave carries radio signals between transmitting and receiving stations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (113, 'T3A08', 'Which of the following is a likely cause of irregular fading of signals received by ionospheric reflection?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (114, 'T3A09', 'Which of the following results from the fact that skip signals refracted from the ionosphere are elliptically polarized?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (115, 'T3A10', 'What may occur if data signals arrive via multiple paths?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (116, 'T3A11', 'Which part of the atmosphere enables the propagation of radio signals around the world?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (117, 'T3A12', 'How might fog and light rain affect radio range on the 10 meter and 6 meter bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (118, 'T3A13', 'What weather condition would decrease range at microwave frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (119, 'T3B01', 'What is the name for the distance a radio wave travels during one complete cycle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (120, 'T3B02', 'What property of a radio wave is used to describe its polarization?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (121, 'T3B03', 'What are the two components of a radio wave?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (122, 'T3B04', 'How fast does a radio wave travel through free space?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (123, 'T3B05', 'How does the wavelength of a radio wave relate to its frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (124, 'T3B06', 'What is the formula for converting frequency to approximate wavelength in meters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (125, 'T3B07', 'What property of radio waves is often used to identify the different frequency bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (126, 'T3B08', 'What are the frequency limits of the VHF spectrum?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (127, 'T3B09', 'What are the frequency limits of the UHF spectrum?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (128, 'T3B10', 'What frequency range is referred to as HF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (129, 'T3B11', 'What is the approximate velocity of a radio wave as it travels through free space?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (130, 'T3C01', 'Why are direct (not via a repeater) UHF signals rarely heard from stations outside your local coverage area?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (131, 'T3C02', 'Which of the following is an advantage of HF vs VHF and higher frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (132, 'T3C03', 'What is a characteristic of VHF signals received via auroral reflection?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (133, 'T3C04', 'Which of the following propagation types is most commonly associated with occasional strong over-the-horizon signals on the 10, 6, and 2 meter bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (134, 'T3C05', 'Which of the following effects might cause radio signals to be heard despite obstructions between the transmitting and receiving stations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (135, 'T3C06', 'What mode is responsible for allowing over-the-horizon VHF and UHF communications to ranges of approximately 300 miles on a regular basis?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (136, 'T3C07', 'What band is best suited for communicating via meteor scatter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (137, 'T3C08', 'What causes tropospheric ducting?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (138, 'T3C09', 'What is generally the best time for long-distance 10 meter band propagation via the F layer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (139, 'T3C10', 'Which of the following bands may provide long distance communications during the peak of the sunspot cycle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (140, 'T3C11', 'Why do VHF and UHF radio signals usually travel somewhat farther than the visual line of sight distance between two stations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (141, 'T4A01', 'What must be considered to determine the minimum current capacity needed for a transceiver power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (142, 'T4A02', 'How might a computer be used as part of an amateur radio station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (143, 'T4A03', 'Why should wiring between the power source and radio be heavy-gauge wire and kept as short as possible?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (144, 'T4A04', 'Which computer sound card port is connected to a transceiver’s headphone or speaker output for operating digital modes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (145, 'T4A05', 'What is the proper location for an external SWR meter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (146, 'T4A06', 'Which of the following connections might be used between a voice transceiver and a computer for digital operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (147, 'T4A07', 'How is a computer’s sound card used when conducting digital communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (148, 'T4A08', 'Which of the following conductors provides the lowest impedance to RF signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (149, 'T4A09', 'Which of the following could you use to cure distorted audio caused by RF current on the shield of a microphone cable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (150, 'T4A10', 'What is the source of a high-pitched whine that varies with engine speed in a mobile transceiver’s receive audio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (151, 'T4A11', 'Where should the negative return connection of a mobile transceiver''s power cable be connected?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (152, 'T4B01', 'What may happen if a transmitter is operated with the microphone gain set too high?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (153, 'T4B02', 'Which of the following can be used to enter the operating frequency on a modern transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (154, 'T4B03', 'What is the purpose of the squelch control on a transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (155, 'T4B04', 'What is a way to enable quick access to a favorite frequency on your transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (156, 'T4B05', 'Which of the following would reduce ignition interference to a receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (157, 'T4B06', 'Which of the following controls could be used if the voice pitch of a single-sideband signal seems too high or low?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (158, 'T4B07', 'What does the term “RIT” mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (159, 'T4B08', 'What is the advantage of having multiple receive bandwidth choices on a multimode transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (160, 'T4B09', 'Which of the following is an appropriate receive filter bandwidth for minimizing noise and interference for SSB reception?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (161, 'T4B10', 'Which of the following is an appropriate receive filter bandwidth for minimizing noise and interference for CW reception?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (162, 'T4B11', 'What is the function of automatic gain control, or AGC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (163, 'T4B12', 'Which of the following could be used to remove power line noise or ignition noise?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (164, 'T4B13', 'Which of the following is a use for the scanning function of an FM transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (165, 'T5A01', 'Electrical current is measured in which of the following units?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (166, 'T5A02', 'Electrical power is measured in which of the following units?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (167, 'T5A03', 'What is the name for the flow of electrons in an electric circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (168, 'T5A04', 'What is the name for a current that flows only in one direction?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (169, 'T5A05', 'What is the electrical term for the electromotive force (EMF) that causes electron flow?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (170, 'T5A06', 'How much voltage does a mobile transceiver typically require?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (171, 'T5A07', 'Which of the following is a good electrical conductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (172, 'T5A08', 'Which of the following is a good electrical insulator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (173, 'T5A09', 'What is the name for a current that reverses direction on a regular basis?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (174, 'T5A10', 'Which term describes the rate at which electrical energy is used?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (175, 'T5A11', 'What is the unit of electromotive force?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (176, 'T5A12', 'What describes the number of times per second that an alternating current makes a complete cycle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (177, 'T5A13', 'In which type of circuit is current the same through all components?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (178, 'T5A14', 'In which type of circuit is voltage the same across all components?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (179, 'T5B01', 'How many milliamperes is 1.5 amperes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (180, 'T5B02', 'What is another way to specify a radio signal frequency of 1,500,000 hertz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (181, 'T5B03', 'How many volts are equal to one kilovolt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (182, 'T5B04', 'How many volts are equal to one microvolt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (183, 'T5B05', 'Which of the following is equal to 500 milliwatts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (184, 'T5B06', 'If an ammeter calibrated in amperes is used to measure a 3000-milliampere current, what reading would it show?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (185, 'T5B07', 'If a frequency display calibrated in megahertz shows a reading of 3.525 MHz, what would it show if it were calibrated in kilohertz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (186, 'T5B08', 'How many microfarads are equal to 1,000,000 picofarads?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (187, 'T5B09', 'What is the approximate amount of change, measured in decibels (dB), of a power increase from 5 watts to 10 watts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (188, 'T5B10', 'What is the approximate amount of change, measured in decibels (dB), of a power decrease from 12 watts to 3 watts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (189, 'T5B11', 'What is the amount of change, measured in decibels (dB), of a power increase from 20 watts to 200 watts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (190, 'T5B12', 'Which of the following frequencies is equal to 28,400 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (191, 'T5B13', 'If a frequency display shows a reading of 2425 MHz, what frequency is that in GHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (192, 'T5C01', 'What is the ability to store energy in an electric field called?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (193, 'T5C02', 'What is the basic unit of capacitance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (194, 'T5C03', 'What is the ability to store energy in a magnetic field called?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (195, 'T5C04', 'What is the basic unit of inductance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (196, 'T5C05', 'What is the unit of frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (197, 'T5C06', 'What does the abbreviation “RF” refer to?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (198, 'T5C07', 'A radio wave is made up of what type of energy?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (199, 'T5C08', 'What is the formula used to calculate electrical power in a DC circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (200, 'T5C09', 'How much power is being used in a circuit when the applied voltage is 13.8 volts DC and the current is 10 amperes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (201, 'T5C10', 'How much power is being used in a circuit when the applied voltage is 12 volts DC and the current is 2.5 amperes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (202, 'T5C11', 'How many amperes are flowing in a circuit when the applied voltage is 12 volts DC and the load is 120 watts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (203, 'T5C12', 'What is impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (204, 'T5C13', 'What is a unit of impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (205, 'T5C14', 'What is the proper abbreviation for megahertz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (206, 'T5D01', 'What formula is used to calculate current in a circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (207, 'T5D02', 'What formula is used to calculate voltage in a circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (208, 'T5D03', 'What formula is used to calculate resistance in a circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (209, 'T5D04', 'What is the resistance of a circuit in which a current of 3 amperes flows through a resistor connected to 90 volts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (210, 'T5D05', 'What is the resistance in a circuit for which the applied voltage is 12 volts and the current flow is 1.5 amperes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (211, 'T5D06', 'What is the resistance of a circuit that draws 4 amperes from a 12-volt source?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (212, 'T5D07', 'What is the current in a circuit with an applied voltage of 120 volts and a resistance of 80 ohms?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (213, 'T5D08', 'What is the current through a 100-ohm resistor connected across 200 volts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (214, 'T5D09', 'What is the current through a 24-ohm resistor connected across 240 volts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (215, 'T5D10', 'What is the voltage across a 2-ohm resistor if a current of 0.5 amperes flows through it?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (216, 'T5D11', 'What is the voltage across a 10-ohm resistor if a current of 1 ampere flows through it?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (217, 'T5D12', 'What is the voltage across a 10-ohm resistor if a current of 2 amperes flows through it?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (218, 'T5D13', 'What happens to current at the junction of two components in series?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (219, 'T5D14', 'What happens to current at the junction of two components in parallel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (220, 'T5D15', 'What is the voltage across each of two components in series with a voltage source?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (221, 'T5D16', 'What is the voltage across each of two components in parallel with a voltage source?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (222, 'T6A01', 'What electrical component opposes the flow of current in a DC circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (223, 'T6A02', 'What type of component is often used as an adjustable volume control?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (224, 'T6A03', 'What electrical parameter is controlled by a potentiometer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (225, 'T6A04', 'What electrical component stores energy in an electric field?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (226, 'T6A05', 'What type of electrical component consists of two or more conductive surfaces separated by an insulator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (227, 'T6A06', 'What type of electrical component stores energy in a magnetic field?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (228, 'T6A07', 'What electrical component usually is constructed as a coil of wire?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (229, 'T6A08', 'What electrical component is used to connect or disconnect electrical circuits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (230, 'T6A09', 'What electrical component is used to protect other circuit components from current overloads?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (231, 'T6A10', 'Which of the following battery types is rechargeable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (232, 'T6A11', 'Which of the following battery types is not rechargeable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (233, 'T6B01', 'What class of electronic components uses a voltage or current signal to control current flow?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (234, 'T6B02', 'What electronic component allows current to flow in only one direction?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (235, 'T6B03', 'Which of these components can be used as an electronic switch or amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (236, 'T6B04', 'Which of the following components can consist of three layers of semiconductor material?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (237, 'T6B05', 'Which of the following electronic components can amplify signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (238, 'T6B06', 'How is the cathode lead of a semiconductor diode often marked on the package?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (239, 'T6B07', 'What does the abbreviation LED stand for?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (240, 'T6B08', 'What does the abbreviation FET stand for?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (241, 'T6B09', 'What are the names of the two electrodes of a diode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (242, 'T6B10', 'Which of the following could be the primary gain-producing component in an RF power amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (243, 'T6B11', 'What is the term that describes a device''s ability to amplify a signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (244, 'T6C01', 'What is the name of an electrical wiring diagram that uses standard component symbols?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (245, 'T6C02', 'What is component 1 in figure T1?<p><img src=''t1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (246, 'T6C03', 'What is component 2 in figure T1?<p><img src=''t1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (247, 'T6C04', 'What is component 3 in figure T1?<p><img src=''t1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (248, 'T6C05', 'What is component 4 in figure T1?<p><img src=''t1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (249, 'T6C06', 'What is component 6 in figure T2?<p><img src=''t2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (250, 'T6C07', 'What is component 8 in figure T2?<p><img src=''t2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (251, 'T6C08', 'What is component 9 in figure T2?<p><img src=''t2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (252, 'T6C09', 'What is component 4 in figure T2?<p><img src=''t2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (253, 'T6C10', 'What is component 3 in figure T3?<p><img src=''t3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (254, 'T6C11', 'What is component 4 in figure T3?<p><img src=''t3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (255, 'T6C12', 'What do the symbols on an electrical schematic represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (256, 'T6C13', 'Which of the following is accurately represented in electrical schematics?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (257, 'T6D01', 'Which of the following devices or circuits changes an alternating current into a varying direct current signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (258, 'T6D02', 'What is a relay?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (259, 'T6D03', 'What type of switch is represented by component 3 in figure T2?<p><img src=''t2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (260, 'T6D04', 'Which of the following displays an electrical quantity as a numeric value?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (261, 'T6D05', 'What type of circuit controls the amount of voltage from a power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (262, 'T6D06', 'What component is commonly used to change 120V AC house current to a lower AC voltage for other uses?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (263, 'T6D07', 'Which of the following is commonly used as a visual indicator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (264, 'T6D08', 'Which of the following is combined with an inductor to make a tuned circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (265, 'T6D09', 'What is the name of a device that combines several semiconductors and other components into one package?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (266, 'T6D10', 'What is the function of component 2 in Figure T1?<p><img src=''t1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (267, 'T6D11', 'Which of the following is a resonant or tuned circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (268, 'T6D12', 'Which of the following is a common reason to use shielded wire?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (269, 'T7A01', 'Which term describes the ability of a receiver to detect the presence of a signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (270, 'T7A02', 'What is a transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (271, 'T7A03', 'Which of the following is used to convert a radio signal from one frequency to another?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (272, 'T7A04', 'Which term describes the ability of a receiver to discriminate between multiple signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (273, 'T7A05', 'What is the name of a circuit that generates a signal at a specific frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (274, 'T7A06', 'What device converts the RF input and output of a transceiver to another band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (275, 'T7A07', 'What is meant by “PTT”?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (276, 'T7A08', 'Which of the following describes combining speech with an RF carrier signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (277, 'T7A09', 'What is the function of the SSB/CW-FM switch on a VHF power amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (278, 'T7A10', 'What device increases the low-power output from a handheld transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (279, 'T7A11', 'Where is an RF preamplifier installed?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (280, 'T7B01', 'What can you do if you are told your FM handheld or mobile transceiver is over-deviating?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (281, 'T7B02', 'What would cause a broadcast AM or FM radio to receive an amateur radio transmission unintentionally?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (282, 'T7B03', 'Which of the following can cause radio frequency interference?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (283, 'T7B04', 'Which of the following is a way to reduce or eliminate interference from an amateur transmitter to a nearby telephone?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (284, 'T7B05', 'How can overload of a non-amateur radio or TV receiver by an amateur signal be reduced or eliminated?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (285, 'T7B06', 'Which of the following actions should you take if a neighbor tells you that your station’s transmissions are interfering with their radio or TV reception?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (286, 'T7B07', 'Which of the following can reduce overload to a VHF transceiver from a nearby FM broadcast station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (287, 'T7B08', 'What should you do if something in a neighbor’s home is causing harmful interference to your amateur station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (288, 'T7B09', 'What is a Part 15 device?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (289, 'T7B10', 'What might be a problem if you receive a report that your audio signal through the repeater is distorted or unintelligible?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (290, 'T7B11', 'What is a symptom of RF feedback in a transmitter or transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (291, 'T7B12', 'What should be the first step to resolve cable TV interference from your ham radio transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (292, 'T7C01', 'What is the primary purpose of a dummy load?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (293, 'T7C02', 'Which of the following instruments can be used to determine if an antenna is resonant at the desired operating frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (294, 'T7C03', 'What, in general terms, is standing wave ratio (SWR)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (295, 'T7C04', 'What reading on an SWR meter indicates a perfect impedance match between the antenna and the feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (296, 'T7C05', 'Why do most solid-state amateur radio transmitters reduce output power as SWR increases?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (297, 'T7C06', 'What does an SWR reading of 4:1 indicate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (298, 'T7C07', 'What happens to power lost in a feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (299, 'T7C08', 'What instrument other than an SWR meter could you use to determine if a feed line and antenna are properly matched?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (300, 'T7C09', 'Which of the following is the most common cause for failure of coaxial cables?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (301, 'T7C10', 'Why should the outer jacket of coaxial cable be resistant to ultraviolet light?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (302, 'T7C11', 'What is a disadvantage of air core coaxial cable when compared to foam or solid dielectric types?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (303, 'T7C12', 'What does a dummy load consist of?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (304, 'T7D01', 'Which instrument would you use to measure electric potential or electromotive force?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (305, 'T7D02', 'What is the correct way to connect a voltmeter to a circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (306, 'T7D03', 'How is a simple ammeter connected to a circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (307, 'T7D04', 'Which instrument is used to measure electric current?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (308, 'T7D05', 'What instrument is used to measure resistance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (309, 'T7D06', 'Which of the following might damage a multimeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (310, 'T7D07', 'Which of the following measurements are commonly made using a multimeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (311, 'T7D08', 'Which of the following types of solder is best for radio and electronic use?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (312, 'T7D09', 'What is the characteristic appearance of a cold solder joint?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (313, 'T7D10', 'What is probably happening when an ohmmeter, connected across an unpowered circuit, initially indicates a low resistance and then shows increasing resistance with time?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (314, 'T7D11', 'Which of the following precautions should be taken when measuring circuit resistance with an ohmmeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (315, 'T7D12', 'Which of the following precautions should be taken when measuring high voltages with a voltmeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (316, 'T8A01', 'Which of the following is a form of amplitude modulation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (317, 'T8A02', 'What type of modulation is most commonly used for VHF packet radio transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (318, 'T8A03', 'Which type of voice mode is most often used for long-distance (weak signal) contacts on the VHF and UHF bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (319, 'T8A04', 'Which type of modulation is most commonly used for VHF and UHF voice repeaters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (320, 'T8A05', 'Which of the following types of emission has the narrowest bandwidth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (321, 'T8A06', 'Which sideband is normally used for 10 meter HF, VHF, and UHF single-sideband communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (322, 'T8A07', 'What is an advantage of single sideband (SSB) over FM for voice transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (323, 'T8A08', 'What is the approximate bandwidth of a single sideband (SSB) voice signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (324, 'T8A09', 'What is the approximate bandwidth of a VHF repeater FM phone signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (325, 'T8A10', 'What is the typical bandwidth of analog fast-scan TV transmissions on the 70 centimeter band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (326, 'T8A11', 'What is the approximate maximum bandwidth required to transmit a CW signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (327, 'T8B01', 'What telemetry information is typically transmitted by satellite beacons?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (328, 'T8B02', 'What is the impact of using too much effective radiated power on a satellite uplink?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (329, 'T8B03', 'Which of the following are provided by satellite tracking programs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (330, 'T8B04', 'What mode of transmission is commonly used by amateur radio satellites?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (331, 'T8B05', 'What is a satellite beacon?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (332, 'T8B06', 'Which of the following are inputs to a satellite tracking program?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (333, 'T8B07', 'With regard to satellite communications, what is Doppler shift?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (334, 'T8B08', 'What is meant by the statement that a satellite is operating in mode U/V?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (335, 'T8B09', 'What causes spin fading of satellite signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (336, 'T8B10', 'What do the initials LEO tell you about an amateur satellite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (337, 'T8B11', 'Who may receive telemetry from a space station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (338, 'T8B12', 'Which of the following is a good way to judge whether your uplink power is neither too low nor too high?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (339, 'T8C01', 'Which of the following methods is used to locate sources of noise interference or jamming?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (340, 'T8C02', 'Which of these items would be useful for a hidden transmitter hunt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (341, 'T8C03', 'What operating activity involves contacting as many stations as possible during a specified period?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (342, 'T8C04', 'Which of the following is good procedure when contacting another station in a radio contest?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (343, 'T8C05', 'What is a grid locator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (344, 'T8C06', 'How is access to some IRLP nodes accomplished?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (345, 'T8C07', 'What is meant by Voice Over Internet Protocol (VoIP) as used in amateur radio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (346, 'T8C08', 'What is the Internet Radio Linking Project (IRLP)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (347, 'T8C09', 'How might you obtain a list of active nodes that use VoIP?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (348, 'T8C10', 'What must be done before you may use the EchoLink system to communicate using a repeater?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (349, 'T8C11', 'What name is given to an amateur radio station that is used to connect other amateur stations to the internet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (350, 'T8D01', 'Which of the following is a digital communications mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (351, 'T8D02', 'What does the term “APRS” mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (352, 'T8D03', 'Which of the following devices is used to provide data to the transmitter when sending automatic position reports from a mobile amateur radio station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (353, 'T8D04', 'What type of transmission is indicated by the term "NTSC?"', 0, 1, 0, 0, '');
INSERT INTO question VALUES (354, 'T8D05', 'Which of the following is an application of APRS (Automatic Packet Reporting System)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (355, 'T8D06', 'What does the abbreviation "PSK" mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (356, 'T8D07', 'Which of the following best describes DMR (Digital Mobile Radio)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (357, 'T8D08', 'Which of the following may be included in packet transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (358, 'T8D09', 'What code is used when sending CW in the amateur bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (359, 'T8D10', 'Which of the following operating activities is supported by digital mode software in the WSJT suite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (360, 'T8D11', 'What is an ARQ transmission system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (361, 'T8D12', 'Which of the following best describes Broadband-Hamnet(TM), also referred to as a high-speed multi-media network?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (362, 'T8D13', 'What is FT8?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (363, 'T8D14', 'What is an electronic keyer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (364, 'T9A01', 'What is a beam antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (365, 'T9A02', 'Which of the following describes a type of antenna loading?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (366, 'T9A03', 'Which of the following describes a simple dipole oriented parallel to the Earth''s surface?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (367, 'T9A04', 'What is a disadvantage of the “rubber duck” antenna supplied with most handheld radio transceivers when compared to a full-sized quarter-wave antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (368, 'T9A05', 'How would you change a dipole antenna to make it resonant on a higher frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (369, 'T9A06', 'What type of antennas are the quad, Yagi, and dish?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (370, 'T9A07', 'What is a disadvantage of using a handheld VHF transceiver, with its integral antenna, inside a vehicle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (371, 'T9A08', 'What is the approximate length, in inches, of a quarter-wavelength vertical antenna for 146 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (372, 'T9A09', 'What is the approximate length, in inches, of a half-wavelength 6 meter dipole antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (373, 'T9A10', 'In which direction does a half-wave dipole antenna radiate the strongest signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (374, 'T9A11', 'What is the gain of an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (375, 'T9A12', 'What is an advantage of using a properly mounted 5/8 wavelength antenna for VHF or UHF mobile service?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (376, 'T9B01', 'Why is it important to have low SWR when using coaxial cable feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (377, 'T9B02', 'What is the impedance of most coaxial cables used in amateur radio installations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (378, 'T9B03', 'Why is coaxial cable the most common feed line selected for amateur radio antenna systems?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (379, 'T9B04', 'What is the major function of an antenna tuner (antenna coupler)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (380, 'T9B05', 'In general, what happens as the frequency of a signal passing through coaxial cable is increased?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (381, 'T9B06', 'Which of the following connectors is most suitable for frequencies above 400 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (382, 'T9B07', 'Which of the following is true of PL-259 type coax connectors?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (383, 'T9B08', 'Why should coax connectors exposed to the weather be sealed against water intrusion?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (384, 'T9B09', 'What can cause erratic changes in SWR readings?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (385, 'T9B10', 'What is the electrical difference between RG-58 and RG-8 coaxial cable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (386, 'T9B11', 'Which of the following types of feed line has the lowest loss at VHF and UHF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (387, 'T0A01', 'Which of the following is a safety hazard of a 12-volt storage battery?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (388, 'T0A02', 'What health hazard is presented by electrical current flowing through the body?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (389, 'T0A03', 'In the United States, what is connected to the green wire in a three-wire electrical AC plug?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (390, 'T0A04', 'What is the purpose of a fuse in an electrical circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (391, 'T0A05', 'Why is it unwise to install a 20-ampere fuse in the place of a 5-ampere fuse?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (392, 'T0A06', 'What is a good way to guard against electrical shock at your station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (393, 'T0A07', 'Which of these precautions should be taken when installing devices for lightning protection in a coaxial cable feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (394, 'T0A08', 'What safety equipment should always be included in home-built equipment that is powered from 120V AC power circuits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (395, 'T0A09', 'What should be done to all external ground rods or earth connections?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (396, 'T0A10', 'What can happen if a lead-acid storage battery is charged or discharged too quickly?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (397, 'T0A11', 'What kind of hazard might exist in a power supply when it is turned off and disconnected?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (398, 'T0B01', 'When should members of a tower work team wear a hard hat and safety glasses?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (399, 'T0B02', 'What is a good precaution to observe before climbing an antenna tower?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (400, 'T0B03', 'Under what circumstances is it safe to climb a tower without a helper or observer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (401, 'T0B04', 'Which of the following is an important safety precaution to observe when putting up an antenna tower?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (402, 'T0B05', 'What is the purpose of a gin pole?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (403, 'T0B06', 'What is the minimum safe distance from a power line to allow when installing an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (404, 'T0B07', 'Which of the following is an important safety rule to remember when using a crank-up tower?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (405, 'T0B08', 'What is considered to be a proper grounding method for a tower?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (406, 'T0B09', 'Why should you avoid attaching an antenna to a utility pole?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (407, 'T0B10', 'Which of the following is true when installing grounding conductors used for lightning protection?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (408, 'T0B11', 'Which of the following establishes grounding requirements for an amateur radio tower or antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (409, 'T0B12', 'Which of the following is good practice when installing ground wires on a tower for lightning protection?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (410, 'T0B13', 'What is the purpose of a safety wire through a turnbuckle used to tension guy lines?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (411, 'T0C01', 'What type of radiation are VHF and UHF radio signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (412, 'T0C02', 'Which of the following frequencies has the lowest value for Maximum Permissible Exposure limit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (413, 'T0C03', 'What is the maximum power level that an amateur radio station may use at VHF frequencies before an RF exposure evaluation is required?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (414, 'T0C04', 'What factors affect the RF exposure of people near an amateur station antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (415, 'T0C05', 'Why do exposure limits vary with frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (416, 'T0C06', 'Which of the following is an acceptable method to determine that your station complies with FCC RF exposure regulations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (417, 'T0C07', 'What could happen if a person accidentally touched your antenna while you were transmitting?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (418, 'T0C08', 'Which of the following actions might amateur operators take to prevent exposure to RF radiation in excess of FCCsupplied limits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (419, 'T0C09', 'How can you make sure your station stays in compliance with RF safety regulations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (420, 'T0C10', 'Why is duty cycle one of the factors used to determine safe RF radiation exposure levels?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (421, 'T0C11', 'What is the definition of duty cycle during the averaging time for RF exposure?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (422, 'T0C12', 'How does RF radiation differ from ionizing radiation (radioactivity)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (423, 'T0C13', 'If the averaging time for exposure is 6 minutes, how much power density is permitted if the signal is present for 3 minutes and absent for 3 minutes rather than being present for the entire 6 minutes?', 0, 1, 0, 0, '');

INSERT INTO question VALUES (424, 'G1A01', 'On which HF/MF bands is a General class license holder granted all amateur frequency privileges?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (425, 'G1A02', 'On which of the following bands is phone operation prohibited?', 0, 1, 0, 0, '97.305');
INSERT INTO question VALUES (426, 'G1A03', 'On which of the following bands is image transmission prohibited?', 0, 1, 0, 0, '97.305');
INSERT INTO question VALUES (427, 'G1A04', 'Which of the following amateur bands is restricted to communication only on specific channels, rather than frequency ranges?', 0, 1, 0, 0, '97.303(h)');
INSERT INTO question VALUES (428, 'G1A05', 'Which of the following frequencies is in the General class portion of the 40-meter band in ITU Region 2?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (429, 'G1A06', 'Which of the following frequencies is within the General class portion of the 75-meter phone band?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (430, 'G1A07', 'Which of the following frequencies is within the General class portion of the 20-meter phone band?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (431, 'G1A08', 'Which of the following frequencies is within the General class portion of the 80-meter band?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (432, 'G1A09', 'Which of the following frequencies is within the General class portion of the 15-meter band?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (433, 'G1A10', 'Which of the following frequencies is available to a control operator holding a General class license?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (434, 'G1A11', 'When General class licensees are not permitted to use the entire voice portion of a band, which portion of the voice segment is generally available to them?', 0, 1, 0, 0, '97.301');
INSERT INTO question VALUES (435, 'G1A12', 'Which of the following applies when the FCC rules designate the Amateur Service as a secondary user on a band?', 0, 1, 0, 0, '97.303');
INSERT INTO question VALUES (436, 'G1A13', 'What is the appropriate action if, when operating on either the 30-meter or 60-meter bands, a station in the primary service interferes with your contact?', 0, 1, 0, 0, '97.303(5)(h)(2)(j)');
INSERT INTO question VALUES (437, 'G1A14', 'Which of the following may apply in areas under FCC jurisdiction outside of ITU Region 2?', 0, 1, 0, 0, '97.301(d)');
INSERT INTO question VALUES (438, 'G1A15', 'What portion of the 10-meter band is available for repeater use?', 0, 1, 0, 0, '97.205(b)');
INSERT INTO question VALUES (439, 'G1B01', 'What is the maximum height above ground to which an antenna structure may be erected without requiring notification to the FAA and registration with the FCC, provided it is not at or near a public use airport?', 0, 1, 0, 0, '97.15(a)');
INSERT INTO question VALUES (440, 'G1B02', 'With which of the following conditions must beacon stations comply?', 0, 1, 0, 0, '97.203(b)');
INSERT INTO question VALUES (441, 'G1B03', 'Which of the following is a purpose of a beacon station as identified in the FCC rules?', 0, 1, 0, 0, '97.3(a)(9)');
INSERT INTO question VALUES (442, 'G1B04', 'Which of the following transmissions is permitted?', 0, 1, 0, 0, '97.113(c)');
INSERT INTO question VALUES (443, 'G1B05', 'Which of the following one-way transmissions are permitted?', 0, 1, 0, 0, '97.111((5)(b)');
INSERT INTO question VALUES (444, 'G1B06', 'Under what conditions are state and local governments permitted to regulate Amateur Radio antenna structures?', 0, 1, 0, 0, '97.15(b), PRB-1, 101 FCC 2d 952 (1985)');
INSERT INTO question VALUES (445, 'G1B07', 'What are the restrictions on the use of abbreviations or procedural signals in the Amateur Service?', 0, 1, 0, 0, '97.113(a)(4)');
INSERT INTO question VALUES (446, 'G1B08', 'When choosing a transmitting frequency, what should you do to comply with good amateur practice?', 0, 1, 0, 0, '97.101(a)');
INSERT INTO question VALUES (447, 'G1B09', 'On what HF frequencies are automatically controlled beacons permitted?', 0, 1, 0, 0, '97.203(d)');
INSERT INTO question VALUES (448, 'G1B10', 'What is the power limit for beacon stations?', 0, 1, 0, 0, '97.203(c)');
INSERT INTO question VALUES (449, 'G1B11', 'Who or what determines “good engineering and good amateur practice,” as applied to the operation of an amateur station in all respects not covered by the Part 97 rules?', 0, 1, 0, 0, '97.101(a)');
INSERT INTO question VALUES (450, 'G1B12', 'When is it permissible to communicate with amateur stations in countries outside the areas administered by the Federal Communications Commission?', 0, 1, 0, 0, '97.111(a)(1)');
INSERT INTO question VALUES (451, 'G1C01', 'What is the maximum transmitting power an amateur station may use on 10.140 MHz?', 0, 1, 0, 0, '97.313(c)(1)');
INSERT INTO question VALUES (452, 'G1C02', 'What is the maximum transmitting power an amateur station may use on the 12-meter band?', 0, 1, 0, 0, '97.313');
INSERT INTO question VALUES (453, 'G1C03', 'What is the maximum bandwidth permitted by FCC rules for Amateur Radio stations transmitting on USB frequencies in the 60-meter band?', 0, 1, 0, 0, '97.303(h)(1)');
INSERT INTO question VALUES (454, 'G1C04', 'Which of the following limitations apply to transmitter power on every amateur band?', 0, 1, 0, 0, '97.313(a)');
INSERT INTO question VALUES (455, 'G1C05', 'What is the limit for transmitter power on the 28 MHz band for a General Class control operator?', 0, 1, 0, 0, '97.313');
INSERT INTO question VALUES (456, 'G1C06', 'What is the limit for transmitter power on the 1.8 MHz band?', 0, 1, 0, 0, '97.313');
INSERT INTO question VALUES (457, 'G1C07', 'What is the maximum symbol rate permitted for RTTY or data emission transmission on the 20-meter band?', 0, 1, 0, 0, '97.305(c), 97.307(f)(3)');
INSERT INTO question VALUES (458, 'G1C08', 'What is the maximum symbol rate permitted for RTTY or data emission transmitted at frequencies below 28 MHz?', 0, 1, 0, 0, '97.307(f)(3)');
INSERT INTO question VALUES (459, 'G1C09', 'What is the maximum symbol rate permitted for RTTY or data emission transmitted on the 1.25-meter and 70centimeter bands?', 0, 1, 0, 0, '97.305(c) and 97.307(f)(5)');
INSERT INTO question VALUES (460, 'G1C10', 'What is the maximum symbol rate permitted for RTTY or data emission transmissions on the 10-meter band?', 0, 1, 0, 0, '97.305(c) and 97.307(f)(4)');
INSERT INTO question VALUES (461, 'G1C11', 'What is the maximum symbol rate permitted for RTTY or data emission transmissions on the 2-meter band?', 0, 1, 0, 0, '97.305(c) and 97.307(f)(5)');
INSERT INTO question VALUES (462, 'G1C12', 'Which of the following is required by the FCC rules when operating in the 60-meter band?', 0, 1, 0, 0, '97.303(i)');
INSERT INTO question VALUES (463, 'G1C13', 'What must be done before using a new digital protocol on the air?', 0, 1, 0, 0, '97.309(a)(4)');
INSERT INTO question VALUES (464, 'G1C14', 'What is the maximum power limit on the 60-meter band?', 0, 1, 0, 0, '97.313(i)');
INSERT INTO question VALUES (465, 'G1C15', 'What measurement is specified by FCC rules that regulate maximum power output?', 0, 1, 0, 0, '97.313');
INSERT INTO question VALUES (466, 'G1D01', 'Who may receive partial credit for the elements represented by an expired Amateur Radio license?', 0, 1, 0, 0, '97.501, 97.505(a)');
INSERT INTO question VALUES (467, 'G1D02', 'What license examinations may you administer when you are an accredited VE holding a General class operator license?', 0, 1, 0, 0, '97.509(b)(3)(i)');
INSERT INTO question VALUES (468, 'G1D03', 'On which of the following band segments may you operate if you are a Technician class operator and have a Certificate of Successful Completion of Examination (CSCE) for General class privileges?', 0, 1, 0, 0, '97.9(b)');
INSERT INTO question VALUES (469, 'G1D04', 'Which of the following is a requirement for administering a Technician class license examination?', 0, 1, 0, 0, '97.509(3)(i)(c)');
INSERT INTO question VALUES (470, 'G1D05', 'Which of the following must a person have before they can be an administering VE for a Technician class license examination?', 0, 1, 0, 0, '97.509(b)(3)(i)');
INSERT INTO question VALUES (471, 'G1D06', 'When must you add the special identifier "AG" after your call sign if you are a Technician class licensee and have a Certificate of Successful Completion of Examination (CSCE) for General class operator privileges, but the FCC has not yet posted your upgrade on its website?', 0, 1, 0, 0, '97.119(f)(2)');
INSERT INTO question VALUES (472, 'G1D07', 'Volunteer Examiners are accredited by what organization?', 0, 1, 0, 0, '97.509(b)(1)');
INSERT INTO question VALUES (473, 'G1D08', 'Which of the following criteria must be met for a non-U.S. citizen to be an accredited Volunteer Examiner?', 0, 1, 0, 0, '97.509(b)(3)');
INSERT INTO question VALUES (474, 'G1D09', 'How long is a Certificate of Successful Completion of Examination (CSCE) valid for exam element credit?', 0, 1, 0, 0, '97.9(b)');
INSERT INTO question VALUES (475, 'G1D10', 'What is the minimum age that one must be to qualify as an accredited Volunteer Examiner?', 0, 1, 0, 0, '97.509(b)(2)');
INSERT INTO question VALUES (476, 'G1D11', 'What is required to obtain a new General Class license after a previously-held license has expired and the twoyear grace period has passed?', 0, 1, 0, 0, '97.505');
INSERT INTO question VALUES (477, 'G1E01', 'Which of the following would disqualify a third party from participating in stating a message over an amateur station?', 0, 1, 0, 0, '97.115(b)(2)');
INSERT INTO question VALUES (478, 'G1E02', 'When may a 10-meter repeater retransmit the 2-meter signal from a station that has a Technician class control operator?', 0, 1, 0, 0, '97.205(b)');
INSERT INTO question VALUES (479, 'G1E03', 'What is required to conduct communications with a digital station operating under automatic control outside the automatic control band segments?', 0, 1, 0, 0, '97.221');
INSERT INTO question VALUES (480, 'G1E04', 'Which of the following conditions require a licensed Amateur Radio operator to take specific steps to avoid harmful interference to other users or facilities?', 0, 1, 0, 0, '97.13(b), 97.303, 97.311(b)');
INSERT INTO question VALUES (481, 'G1E05', 'What types of messages for a third party in another country may be transmitted by an amateur station?', 0, 1, 0, 0, '97.115(a)(2), 97.117');
INSERT INTO question VALUES (482, 'G1E06', 'The frequency allocations of which ITU region apply to radio amateurs operating in North and South America?', 0, 1, 0, 0, '97.301, ITU Radio Regulations');
INSERT INTO question VALUES (483, 'G1E07', 'In what part of the 13-centimeter band may an amateur station communicate with non-licensed Wi-Fi stations?', 0, 1, 0, 0, '97.111');
INSERT INTO question VALUES (484, 'G1E08', 'What is the maximum PEP output allowed for spread spectrum transmissions?', 0, 1, 0, 0, '97.313(j)');
INSERT INTO question VALUES (485, 'G1E09', 'Under what circumstances are messages that are sent via digital modes exempt from Part 97 third-party rules that apply to other modes of communication?', 0, 1, 0, 0, '97.115');
INSERT INTO question VALUES (486, 'G1E10', 'Why should an amateur operator normally avoid transmitting on 14.100, 18.110, 21.150, 24. 930 and 28.200 MHz?', 0, 1, 0, 0, '97.101');
INSERT INTO question VALUES (487, 'G1E11', 'On what bands may automatically controlled stations transmitting RTTY or data emissions communicate with other automatically controlled digital station?', 0, 1, 0, 0, '97.221, 97.305');
INSERT INTO question VALUES (488, 'G2A01', 'Which sideband is most commonly used for voice communications on frequencies of 14 MHz or higher?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (489, 'G2A02', 'Which of the following modes is most commonly used for voice communications on the 160-meter, 75-meter, and 40-meter bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (490, 'G2A03', 'Which of the following is most commonly used for SSB voice communications in the VHF and UHF bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (491, 'G2A04', 'Which mode is most commonly used for voice communications on the 17-meter and 12-meter bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (492, 'G2A05', 'Which mode of voice communication is most commonly used on the HF amateur bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (493, 'G2A06', 'Which of the following is an advantage when using single sideband, as compared to other analog voice modes on the HF amateur bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (494, 'G2A07', 'Which of the following statements is true of the single sideband voice mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (495, 'G2A08', 'What is the recommended way to break in to a phone contact?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (496, 'G2A09', 'Why do most amateur stations use lower sideband on the 160-meter, 75-meter, and 40-meter bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (497, 'G2A10', 'Which of the following statements is true of voice VOX operation versus PTT operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (498, 'G2A11', 'Generally, who should respond to a station in the contiguous 48 states who calls “CQ DX”?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (499, 'G2A12', 'What control is typically adjusted for proper ALC setting on an amateur single sideband transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (500, 'G2B01', 'Which of the following is true concerning access to frequencies?', 0, 1, 0, 0, '97.101(b), (c)');
INSERT INTO question VALUES (501, 'G2B02', 'What is the first thing you should do if you are communicating with another amateur station and hear a station in distress break in?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (502, 'G2B03', 'What is good amateur practice if propagation changes during a contact and you notice interference from other stations on the frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (503, 'G2B04', 'When selecting a CW transmitting frequency, what minimum separation should be used to minimize interference to stations on adjacent frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (504, 'G2B05', 'When selecting an SSB transmitting frequency, what minimum separation should be used to minimize interference to stations on adjacent frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (505, 'G2B06', 'What is a practical way to avoid harmful interference on an apparently clear frequency before calling CQ on CW or phone?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (506, 'G2B07', 'Which of the following complies with good amateur practice when choosing a frequency on which to initiate a call?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (507, 'G2B08', 'What is the voluntary band plan restriction for U.S. stations transmitting within the 48 contiguous states in the 50.1 to 50.125 MHz band segment?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (508, 'G2B09', 'Who may be the control operator of an amateur station transmitting in RACES to assist relief operations during a disaster?', 0, 1, 0, 0, '97.407(a)');
INSERT INTO question VALUES (509, 'G2B10', 'When is an amateur station allowed to use any means at its disposal to assist another station in distress?', 0, 1, 0, 0, '97.405(b)');
INSERT INTO question VALUES (510, 'G2B11', 'What frequency should be used to send a distress call?', 0, 1, 0, 0, '97.405');
INSERT INTO question VALUES (511, 'G2C01', 'Which of the following describes full break-in telegraphy (QSK)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (512, 'G2C02', 'What should you do if a CW station sends “QRS?”', 0, 1, 0, 0, '');
INSERT INTO question VALUES (513, 'G2C03', 'What does it mean when a CW operator sends “KN” at the end of a transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (514, 'G2C04', 'What does the Q signal “QRL?” mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (515, 'G2C05', 'What is the best speed to use when answering a CQ in Morse code?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (516, 'G2C06', 'What does the term “zero beat” mean in CW operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (517, 'G2C07', 'When sending CW, what does a “C” mean when added to the RST report?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (518, 'G2C08', 'What prosign is sent to indicate the end of a formal message when using CW?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (519, 'G2C09', 'What does the Q signal “QSL” mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (520, 'G2C10', 'What does the Q signal “QRN” mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (521, 'G2C11', 'What does the Q signal “QRV” mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (522, 'G2D01', 'What is the Volunteer Monitoring Program?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (523, 'G2D02', 'Which of the following are objectives of the Volunteer Monitoring Program?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (524, 'G2D03', 'What skills learned during hidden transmitter hunts are of help to the Volunteer Monitoring Program?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (525, 'G2D04', 'Which of the following describes an azimuthal projection map?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (526, 'G2D05', 'Which of the following is a good way to indicate on a clear frequency in the HF phone bands that you are looking for a contact with any station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (527, 'G2D06', 'How is a directional antenna pointed when making a “long-path” contact with another station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (528, 'G2D07', 'Which of the following are examples of the NATO Phonetic Alphabet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (529, 'G2D08', 'What is a reason why many amateurs keep a station log?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (530, 'G2D09', 'Which of the following is required when participating in a contest on HF frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (531, 'G2D10', 'What is QRP operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (532, 'G2D11', 'Which of the following is typical of the lower HF frequencies during the summer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (533, 'G2E01', 'Which mode is normally used when sending RTTY signals via AFSK with an SSB transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (534, 'G2E02', 'How can a PACTOR modem or controller be used to determine if the channel is in use by other PACTOR stations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (535, 'G2E03', 'What symptoms may result from other signals interfering with a PACTOR or WINMOR transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (536, 'G2E04', 'What segment of the 20-meter band is most often used for digital transmissions (avoiding the DX propagation beacons)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (537, 'G2E05', 'What is the standard sideband used to generate a JT65, JT9, or FT8 digital signal when using AFSK in any amateur band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (538, 'G2E06', 'What is the most common frequency shift for RTTY emissions in the amateur HF bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (539, 'G2E07', 'What segment of the 80-meter band is most commonly used for digital transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (540, 'G2E08', 'In what segment of the 20-meter band are most PSK31 operations commonly found?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (541, 'G2E09', 'How do you join a contact between two stations using the PACTOR protocol?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (542, 'G2E10', 'Which of the following is a way to establish contact with a digital messaging system gateway station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (543, 'G2E11', 'Which of the following is characteristic of the FT8 mode of the WSJT-X family?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (544, 'G2E12', 'Which of the following connectors would be a good choice for a serial data port?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (545, 'G2E13', 'Which communication system sometimes uses the internet to transfer messages?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (546, 'G2E14', 'What could be wrong if you cannot decode an RTTY or other FSK signal even though it is apparently tuned in properly?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (547, 'G2E15', 'Which of the following is a requirement when using the FT8 digital mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (548, 'G3A01', 'What is the significance of the sunspot number with regard to HF propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (549, 'G3A02', 'What effect does a Sudden Ionospheric Disturbance have on the daytime ionospheric propagation of HF radio waves?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (550, 'G3A03', 'Approximately how long does it take the increased ultraviolet and X-ray radiation from solar flares to affect radio propagation on Earth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (551, 'G3A04', 'Which of the following are least reliable for long-distance communications during periods of low solar activity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (552, 'G3A05', 'What is the solar flux index?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (553, 'G3A06', 'What is a geomagnetic storm?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (554, 'G3A07', 'At what point in the solar cycle does the 20-meter band usually support worldwide propagation during daylight hours?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (555, 'G3A08', 'Which of the following effects can a geomagnetic storm have on radio propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (556, 'G3A09', 'What benefit can high geomagnetic activity have on radio communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (557, 'G3A10', 'What causes HF propagation conditions to vary periodically in a roughly 28-day cycle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (558, 'G3A11', 'How long does it take charged particles from coronal mass ejections to affect radio propagation on Earth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (559, 'G3A12', 'What does the K-index indicate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (560, 'G3A13', 'What does the A-index indicate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (561, 'G3A14', 'How are radio communications usually affected by the charged particles that reach Earth from solar coronal holes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (562, 'G3B01', 'What is a characteristic of skywave signals arriving at your location by both short-path and long-path propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (563, 'G3B02', 'What factors affect the MUF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (564, 'G3B03', 'Which of the following applies when selecting a frequency for lowest attenuation when transmitting on HF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (565, 'G3B04', 'What is a reliable way to determine if the MUF is high enough to support skip propagation between your station and a distant location on frequencies between 14 and 30 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (566, 'G3B05', 'What usually happens to radio waves with frequencies below the MUF and above the LUF when they are sent into the ionosphere?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (567, 'G3B06', 'What usually happens to radio waves with frequencies below the LUF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (568, 'G3B07', 'What does LUF stand for?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (569, 'G3B08', 'What does MUF stand for?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (570, 'G3B09', 'What is the approximate maximum distance along the Earth’s surface that is normally covered in one hop using the F2 region?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (571, 'G3B10', 'What is the approximate maximum distance along the Earth’s surface that is normally covered in one hop using the E region?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (572, 'G3B11', 'What happens to HF propagation when the LUF exceeds the MUF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (573, 'G3C01', 'Which ionospheric layer is closest to the surface of Earth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (574, 'G3C02', 'Where on Earth do ionospheric layers reach their maximum height?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (575, 'G3C03', 'Why is the F2 region mainly responsible for the longest distance radio wave propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (576, 'G3C04', 'What does the term “critical angle” mean, as used in radio wave propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (577, 'G3C05', 'Why is long-distance communication on the 40-meter, 60-meter, 80-meter, and 160-meter bands more difficult during the day?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (578, 'G3C06', 'What is a characteristic of HF scatter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (579, 'G3C07', 'What makes HF scatter signals often sound distorted?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (580, 'G3C08', 'Why are HF scatter signals in the skip zone usually weak?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (581, 'G3C09', 'What type of propagation allows signals to be heard in the transmitting station’s skip zone?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (582, 'G3C10', 'What is Near Vertical Incidence Skywave (NVIS) propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (583, 'G3C11', 'Which ionospheric layer is the most absorbent of long skip signals during daylight hours on frequencies below 10 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (584, 'G4A01', 'What is the purpose of the “notch filter” found on many HF transceivers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (585, 'G4A02', 'What is one advantage of selecting the opposite, or “reverse,” sideband when receiving CW signals on a typical HF transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (586, 'G4A03', 'What is normally meant by operating a transceiver in “split” mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (587, 'G4A04', 'What reading on the plate current meter of a vacuum tube RF power amplifier indicates correct adjustment of the plate tuning control?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (588, 'G4A05', 'What is a reason to use Automatic Level Control (ALC) with an RF power amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (589, 'G4A06', 'What type of device is often used to match transmitter output impedance to an impedance not equal to 50 ohms?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (590, 'G4A07', 'What condition can lead to permanent damage to a solid-state RF power amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (591, 'G4A08', 'What is the correct adjustment for the load or coupling control of a vacuum tube RF power amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (592, 'G4A09', 'Why is a time delay sometimes included in a transmitter keying circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (593, 'G4A10', 'What is the purpose of an electronic keyer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (594, 'G4A11', 'Which of the following is a use for the IF shift control on a receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (595, 'G4A12', 'Which of the following is a common use for the dual-VFO feature on a transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (596, 'G4A13', 'What is one reason to use the attenuator function that is present on many HF transceivers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (597, 'G4A14', 'What is likely to happen if a transceiver’s ALC system is not set properly when transmitting AFSK signals with the radio using single sideband mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (598, 'G4A15', 'Which of the following can be a symptom of transmitted RF being picked up by an audio cable carrying AFSK data signals between a computer and a transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (599, 'G4A16', 'How does a noise blanker work?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (600, 'G4A17', 'What happens as the noise reduction control level in a receiver is increased?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (601, 'G4B01', 'What item of test equipment contains horizontal and vertical channel amplifiers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (602, 'G4B02', 'Which of the following is an advantage of an oscilloscope versus a digital voltmeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (603, 'G4B03', 'Which of the following is the best instrument to use when checking the keying waveform of a CW transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (604, 'G4B04', 'What signal source is connected to the vertical input of an oscilloscope when checking the RF envelope pattern of a transmitted signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (605, 'G4B05', 'Why is high input impedance desirable for a voltmeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (606, 'G4B06', 'What is an advantage of a digital voltmeter as compared to an analog voltmeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (607, 'G4B07', 'What signals are used to conduct a two-tone test?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (608, 'G4B08', 'Which of the following instruments may be used to monitor relative RF output when making antenna and transmitter adjustments?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (609, 'G4B09', 'Which of the following can be determined with a field strength meter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (610, 'G4B10', 'Which of the following can be determined with a directional wattmeter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (611, 'G4B11', 'Which of the following must be connected to an antenna analyzer when it is being used for SWR measurements?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (612, 'G4B12', 'What problem can occur when making measurements on an antenna system with an antenna analyzer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (613, 'G4B13', 'What is a use for an antenna analyzer other than measuring the SWR of an antenna system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (614, 'G4B14', 'What is an instance in which the use of an instrument with analog readout may be preferred over an instrument with digital readout?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (615, 'G4B15', 'What type of transmitter performance does a two-tone test analyze?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (616, 'G4C01', 'Which of the following might be useful in reducing RF interference to audio frequency devices?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (617, 'G4C02', 'Which of the following could be a cause of interference covering a wide range of frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (618, 'G4C03', 'What sound is heard from an audio device or telephone if there is interference from a nearby single sideband phone transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (619, 'G4C04', 'What is the effect on an audio device when there is interference from a nearby CW transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (620, 'G4C05', 'What might be the problem if you receive an RF burn when touching your equipment while transmitting on an HF band, assuming the equipment is connected to a ground rod?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (621, 'G4C06', 'What effect can be caused by a resonant ground connection?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (622, 'G4C07', 'Why should soldered joints not be used with the wires that connect the base of a tower to a system of ground rods?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (623, 'G4C08', 'Which of the following would reduce RF interference caused by common-mode current on an audio cable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (624, 'G4C09', 'How can a ground loop be avoided?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (625, 'G4C10', 'What could be a symptom of a ground loop somewhere in your station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (626, 'G4C11', 'What technique helps to minimize RF “hot spots” in an amateur station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (627, 'G4C12', 'Which of the following is an advantage of a receiver DSP IF filter as compared to an analog filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (628, 'G4C13', 'Why must the metal enclosure of every item of station equipment be grounded?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (629, 'G4D01', 'What is the purpose of a speech processor as used in a modern transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (630, 'G4D02', 'Which of the following describes how a speech processor affects a transmitted single sideband phone signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (631, 'G4D03', 'Which of the following can be the result of an incorrectly adjusted speech processor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (632, 'G4D04', 'What does an S meter measure?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (633, 'G4D05', 'How does a signal that reads 20 dB over S9 compare to one that reads S9 on a receiver, assuming a properly calibrated S meter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (634, 'G4D06', 'Where is an S meter found?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (635, 'G4D07', 'How much must the power output of a transmitter be raised to change the S meter reading on a distant receiver from S8 to S9?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (636, 'G4D08', 'What frequency range is occupied by a 3 kHz LSB signal when the displayed carrier frequency is set to 7.178 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (637, 'G4D09', 'What frequency range is occupied by a 3 kHz USB signal with the displayed carrier frequency set to 14.347 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (638, 'G4D10', 'How close to the lower edge of the phone segment should your displayed carrier frequency be when using 3 kHz wide LSB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (639, 'G4D11', 'How close to the upper edge of the phone segment should your displayed carrier frequency be when using 3 kHz wide USB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (640, 'G4E01', 'What is the purpose of a capacitance hat on a mobile antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (641, 'G4E02', 'What is the purpose of a corona ball on an HF mobile antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (642, 'G4E03', 'Which of the following direct, fused power connections would be the best for a 100 watt HF mobile installation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (643, 'G4E04', 'Why is it best NOT to draw the DC power for a 100 watt HF transceiver from a vehicle’s auxiliary power socket?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (644, 'G4E05', 'Which of the following most limits an HF mobile installation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (645, 'G4E06', 'What is one disadvantage of using a shortened mobile antenna as opposed to a full-size antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (646, 'G4E07', 'Which of the following may cause receive interference in a radio installed in a vehicle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (647, 'G4E08', 'What is the name of the process by which sunlight is changed directly into electricity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (648, 'G4E09', 'What is the approximate open-circuit voltage from a fully illuminated silicon photovoltaic cell?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (649, 'G4E10', 'What is the reason that a series diode is connected between a solar panel and a storage battery that is being charged by the panel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (650, 'G4E11', 'Which of the following is a disadvantage of using wind as the primary source of power for an emergency station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (651, 'G5A01', 'What is impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (652, 'G5A02', 'What is reactance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (653, 'G5A03', 'Which of the following causes opposition to the flow of alternating current in an inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (654, 'G5A04', 'Which of the following causes opposition to the flow of alternating current in a capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (655, 'G5A05', 'How does an inductor react to AC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (656, 'G5A06', 'How does a capacitor react to AC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (657, 'G5A07', 'What happens when the impedance of an electrical load is equal to the output impedance of a power source, assuming both impedances are resistive?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (658, 'G5A08', 'What is one reason to use an impedance matching transformer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (659, 'G5A09', 'What unit is used to measure reactance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (660, 'G5A10', 'Which of the following devices can be used for impedance matching at radio frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (661, 'G5A11', 'Which of the following describes one method of impedance matching between two AC circuits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (662, 'G5B01', 'What dB change represents a factor of two increase or decrease in power?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (663, 'G5B02', 'How does the total current relate to the individual currents in each branch of a purely resistive parallel circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (664, 'G5B03', 'How many watts of electrical power are used if 400 VDC is supplied to an 800 ohm load?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (665, 'G5B04', 'How many watts of electrical power are used by a 12 VDC light bulb that draws 0.2 amperes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (666, 'G5B05', 'How many watts are dissipated when a current of 7.0 milliamperes flows through a 1250 ohm resistance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (667, 'G5B06', 'What is the output PEP from a transmitter if an oscilloscope measures 200 volts peak-to-peak across a 50 ohm dummy load connected to the transmitter output?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (668, 'G5B07', 'What value of an AC signal produces the same power dissipation in a resistor as a DC voltage of the same value?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (669, 'G5B08', 'What is the peak-to-peak voltage of a sine wave with an RMS voltage of 120.0 volts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (670, 'G5B09', 'What is the RMS voltage of a sine wave with a value of 17 volts peak?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (671, 'G5B10', 'What percentage of power loss would result from a transmission line loss of 1 dB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (672, 'G5B11', 'What is the ratio of peak envelope power to average power for an unmodulated carrier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (673, 'G5B12', 'What would be the RMS voltage across a 50 ohm dummy load dissipating 1200 watts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (674, 'G5B13', 'What is the output PEP of an unmodulated carrier if an average reading wattmeter connected to the transmitter output indicates 1060 watts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (675, 'G5B14', 'What is the output PEP from a transmitter if an oscilloscope measures 500 volts peak-to-peak across a 50 ohm resistive load connected to the transmitter output?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (676, 'G5C01', 'What causes a voltage to appear across the secondary winding of a transformer when an AC voltage source is connected across its primary winding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (677, 'G5C02', 'What happens if a signal is applied to the secondary winding of a 4:1 voltage step-down transformer instead of the primary winding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (678, 'G5C03', 'Which of the following components increases the total resistance of a resistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (679, 'G5C04', 'What is the total resistance of three 100 ohm resistors in parallel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (680, 'G5C05', 'If three equal value resistors in series produce 450 ohms, what is the value of each resistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (681, 'G5C06', 'What is the RMS voltage across a 500-turn secondary winding in a transformer if the 2250-turn primary is connected to 120 VAC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (682, 'G5C07', 'What is the turns ratio of a transformer used to match an audio amplifier having 600 ohm output impedance to a speaker having 4 ohm impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (683, 'G5C08', 'What is the equivalent capacitance of two 5.0 nanofarad capacitors and one 750 picofarad capacitor connected in parallel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (684, 'G5C09', 'What is the capacitance of three 100 microfarad capacitors connected in series?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (685, 'G5C10', 'What is the inductance of three 10 millihenry inductors connected in parallel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (686, 'G5C11', 'What is the inductance of a 20 millihenry inductor connected in series with a 50 millihenry inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (687, 'G5C12', 'What is the capacitance of a 20 microfarad capacitor connected in series with a 50 microfarad capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (688, 'G5C13', 'Which of the following components should be added to a capacitor to increase the capacitance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (689, 'G5C14', 'Which of the following components should be added to an inductor to increase the inductance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (690, 'G5C15', 'What is the total resistance of a 10 ohm, a 20 ohm, and a 50 ohm resistor connected in parallel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (691, 'G5C16', 'Why is the conductor of the primary winding of many voltage step-up transformers larger in diameter than the conductor of the secondary winding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (692, 'G5C17', 'What is the value in nanofarads (nF) of a 22,000 picofarad (pF) capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (693, 'G5C18', 'What is the value in microfarads of a 4700 nanofarad (nF) capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (694, 'G6A01', 'What is the minimum allowable discharge voltage for maximum life of a standard 12 volt lead-acid battery?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (695, 'G6A02', 'What is an advantage of the low internal resistance of nickel-cadmium batteries?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (696, 'G6A03', 'What is the approximate junction threshold voltage of a germanium diode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (697, 'G6A04', 'Which of the following is an advantage of an electrolytic capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (698, 'G6A05', 'What is the approximate junction threshold voltage of a conventional silicon diode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (699, 'G6A06', 'Which of the following is a reason not to use wire-wound resistors in an RF circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (700, 'G6A07', 'What are the stable operating points for a bipolar transistor used as a switch in a logic circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (701, 'G6A08', 'What is an advantage of using a ferrite core toroidal inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (702, 'G6A09', 'Which of the following describes the construction of a MOSFET?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (703, 'G6A10', 'Which element of a triode vacuum tube is used to regulate the flow of electrons between cathode and plate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (704, 'G6A11', 'What happens when an inductor is operated above its self-resonant frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (705, 'G6A12', 'What is the primary purpose of a screen grid in a vacuum tube?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (706, 'G6A13', 'Why is the polarity of applied voltages important for polarized capacitors?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (707, 'G6A14', 'Which of the following is an advantage of ceramic capacitors as compared to other types of capacitors?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (708, 'G6B01', 'What determines the performance of a ferrite core at different frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (709, 'G6B02', 'What is meant by the term MMIC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (710, 'G6B03', 'Which of the following is an advantage of CMOS integrated circuits compared to TTL integrated circuits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (711, 'G6B04', 'What is meant by the term ROM?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (712, 'G6B05', 'What is meant when memory is characterized as non-volatile?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (713, 'G6B06', 'What kind of device is an integrated circuit operational amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (714, 'G6B07', 'Which of the following describes a type N connector?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (715, 'G6B08', 'How is an LED biased when emitting light?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (716, 'G6B09', 'Which of the following is a characteristic of a liquid crystal display?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (717, 'G6B10', 'How does a ferrite bead or core reduce common-mode RF current on the shield of a coaxial cable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (718, 'G6B11', 'What is a type SMA connector?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (719, 'G6B12', 'Which of these connector types is commonly used for audio signals in Amateur Radio stations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (720, 'G6B13', 'Which of these connector types is commonly used for RF connections at frequencies up to 150 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (721, 'G7A01', 'What useful feature does a power supply bleeder resistor provide?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (722, 'G7A02', 'Which of the following components are used in a power supply filter network?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (723, 'G7A03', 'Which type of rectifier circuit uses two diodes and a center-tapped transformer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (724, 'G7A04', 'What is an advantage of a half-wave rectifier in a power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (725, 'G7A05', 'What portion of the AC cycle is converted to DC by a half-wave rectifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (726, 'G7A06', 'What portion of the AC cycle is converted to DC by a full-wave rectifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (727, 'G7A07', 'What is the output waveform of an unfiltered full-wave rectifier connected to a resistive load?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (728, 'G7A08', 'Which of the following is an advantage of a switchmode power supply as compared to a linear power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (729, 'G7A09', 'Which symbol in figure G7-1 represents a field effect transistor?<p><img src=''g7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (730, 'G7A10', 'Which symbol in figure G7-1 represents a Zener diode?<p><img src=''g7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (731, 'G7A11', 'Which symbol in figure G7-1 represents an NPN junction transistor?<p><img src=''g7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (732, 'G7A12', 'Which symbol in Figure G7-1 represents a solid core transformer?<p><img src=''g7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (733, 'G7A13', 'Which symbol in Figure G7-1 represents a tapped inductor?<p><img src=''g7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (734, 'G7B01', 'What is the reason for neutralizing the final amplifier stage of a transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (735, 'G7B02', 'Which of these classes of amplifiers has the highest efficiency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (736, 'G7B03', 'Which of the following describes the function of a two-input AND gate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (737, 'G7B04', 'Which of the following describes the function of a two input NOR gate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (738, 'G7B05', 'How many states does a 3-bit binary counter have?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (739, 'G7B06', 'What is a shift register?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (740, 'G7B07', 'Which of the following are basic components of a sine wave oscillator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (741, 'G7B08', 'How is the efficiency of an RF power amplifier determined?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (742, 'G7B09', 'What determines the frequency of an LC oscillator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (743, 'G7B10', 'Which of the following describes a linear amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (744, 'G7B11', 'For which of the following modes is a Class C power stage appropriate for amplifying a modulated signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (745, 'G7C01', 'Which of the following is used to process signals from the balanced modulator then send them to the mixer in some single sideband phone transmitters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (746, 'G7C02', 'Which circuit is used to combine signals from the carrier oscillator and speech amplifier then send the result to the filter in some single sideband phone transmitters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (747, 'G7C03', 'What circuit is used to process signals from the RF amplifier and local oscillator then send the result to the IF filter in a superheterodyne receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (748, 'G7C04', 'What circuit is used to combine signals from the IF amplifier and BFO and send the result to the AF amplifier in some single sideband receivers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (749, 'G7C05', 'Which of the following is an advantage of a direct digital synthesizer (DDS)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (750, 'G7C06', 'What should be the impedance of a low-pass filter as compared to the impedance of the transmission line into which it is inserted?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (751, 'G7C07', 'What is the simplest combination of stages that implement a superheterodyne receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (752, 'G7C08', 'What circuit is used in analog FM receivers to convert IF output signals to audio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (753, 'G7C09', 'What is the phase difference between the I and Q signals that software-defined radio (SDR) equipment uses for modulation and demodulation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (754, 'G7C10', 'What is an advantage of using I and Q signals in software-defined radios (SDRs)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (755, 'G7C11', 'What is meant by the term “software-defined radio” (SDR)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (756, 'G7C12', 'What is the frequency above which a low-pass filter’s output power is less than half the input power?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (757, 'G7C13', 'What term specifies a filter’s maximum ability to reject signals outside its passband?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (758, 'G7C14', 'The bandwidth of a band-pass filter is measured between what two frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (759, 'G7C15', 'What term specifies a filter’s attenuation inside its passband?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (760, 'G7C16', 'Which of the following is a typical application for a Direct Digital Synthesizer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (761, 'G8A01', 'How is an FSK signal generated?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (762, 'G8A02', 'What is the name of the process that changes the phase angle of an RF signal to convey information?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (763, 'G8A03', 'What is the name of the process that changes the instantaneous frequency of an RF wave to convey information?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (764, 'G8A04', 'What emission is produced by a reactance modulator connected to a transmitter RF amplifier stage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (765, 'G8A05', 'What type of modulation varies the instantaneous power level of the RF signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (766, 'G8A06', 'Which of the following is characteristic of QPSK31?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (767, 'G8A07', 'Which of the following phone emissions uses the narrowest bandwidth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (768, 'G8A08', 'Which of the following is an effect of overmodulation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (769, 'G8A09', 'What type of modulation is used by the FT8 digital mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (770, 'G8A10', 'What is meant by the term “flat-topping,” when referring to a single sideband phone transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (771, 'G8A11', 'What is the modulation envelope of an AM signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (772, 'G8A12', 'Which of the following narrow-band digital modes can receive signals with very low signal-to-noise ratios?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (773, 'G8B01', 'Which mixer input is varied or tuned to convert signals of different frequencies to an intermediate frequency (IF)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (774, 'G8B02', 'If a receiver mixes a 13.800 MHz VFO with a 14.255 MHz received signal to produce a 455 kHz intermediate frequency (IF) signal, what type of interference will a 13.345 MHz signal produce in the receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (775, 'G8B03', 'What is another term for the mixing of two RF signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (776, 'G8B04', 'What is the stage in a VHF FM transmitter that generates a harmonic of a lower frequency signal to reach the desired operating frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (777, 'G8B05', 'What is the approximate bandwidth of a PACTOR-III signal at maximum data rate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (778, 'G8B06', 'What is the total bandwidth of an FM phone transmission having 5 kHz deviation and 3 kHz modulating frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (779, 'G8B07', 'What is the frequency deviation for a 12.21 MHz reactance modulated oscillator in a 5 kHz deviation, 146.52 MHz FM phone transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (780, 'G8B08', 'Why is it important to know the duty cycle of the mode you are using when transmitting?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (781, 'G8B09', 'Why is it good to match receiver bandwidth to the bandwidth of the operating mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (782, 'G8B10', 'What is the relationship between transmitted symbol rate and bandwidth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (783, 'G8B11', 'What combination of a mixer’s Local Oscillator (LO) and RF input frequencies is found in the output?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (784, 'G8B12', 'What process combines two signals in a non-linear circuit or connection to produce unwanted spurious outputs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (785, 'G8C01', 'On what band do amateurs share channels with the unlicensed Wi-Fi service?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (786, 'G8C02', 'Which digital mode is used as a low-power beacon for assessing HF propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (787, 'G8C03', 'What part of a packet radio frame contains the routing and handling information?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (788, 'G8C04', 'Which of the following describes Baudot code?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (789, 'G8C05', 'In the PACTOR protocol, what is meant by a NAK response to a transmitted packet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (790, 'G8C06', 'What action results from a failure to exchange information due to excessive transmission attempts when using PACTOR or WINMOR?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (791, 'G8C07', 'How does the receiving station respond to an ARQ data mode packet containing errors?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (792, 'G8C08', 'Which of the following statements is true about PSK31?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (793, 'G8C09', 'What does the number 31 represent in “PSK31”?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (794, 'G8C10', 'How does forward error correction (FEC) allow the receiver to correct errors in received data packets?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (795, 'G8C11', 'How are the two separate frequencies of a Frequency Shift Keyed (FSK) signal identified?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (796, 'G8C12', 'Which type of code is used for sending characters in a PSK31 signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (797, 'G8C13', 'What is indicated on a waterfall display by one or more vertical lines on either side of a digital signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (798, 'G8C14', 'Which of the following describes a waterfall display?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (799, 'G9A01', 'Which of the following factors determine the characteristic impedance of a parallel conductor antenna feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (800, 'G9A02', 'What are the typical characteristic impedances of coaxial cables used for antenna feed lines at amateur stations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (801, 'G9A03', 'What is the typical characteristic impedance of “window line” parallel transmission line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (802, 'G9A04', 'What might cause reflected power at the point where a feed line connects to an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (803, 'G9A05', 'How does the attenuation of coaxial cable change as the frequency of the signal it is carrying increases?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (804, 'G9A06', 'In what units is RF feed line loss usually expressed?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (805, 'G9A07', 'What must be done to prevent standing waves on an antenna feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (806, 'G9A08', 'If the SWR on an antenna feed line is 5 to 1, and a matching network at the transmitter end of the feed line is adjusted to 1 to 1 SWR, what is the resulting SWR on the feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (807, 'G9A09', 'What standing wave ratio will result when connecting a 50 ohm feed line to a non-reactive load having 200 ohm impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (808, 'G9A10', 'What standing wave ratio will result when connecting a 50 ohm feed line to a non-reactive load having 10 ohm impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (809, 'G9A11', 'What standing wave ratio will result when connecting a 50 ohm feed line to a non-reactive load having 50 ohm impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (810, 'G9A12', 'What is the interaction between high standing wave ratio (SWR) and transmission line loss?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (811, 'G9A13', 'What is the effect of transmission line loss on SWR measured at the input to the line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (812, 'G9B01', 'What is one disadvantage of a directly fed random-wire HF antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (813, 'G9B02', 'Which of the following is a common way to adjust the feed-point impedance of a quarter wave ground-plane vertical antenna to be approximately 50 ohms?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (814, 'G9B03', 'Which of the following best describes the radiation pattern of a quarter-wave, ground-plane vertical antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (815, 'G9B04', 'What is the radiation pattern of a dipole antenna in free space in a plane containing the conductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (816, 'G9B05', 'How does antenna height affect the horizontal (azimuthal) radiation pattern of a horizontal dipole HF antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (817, 'G9B06', 'Where should the radial wires of a ground-mounted vertical antenna system be placed?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (818, 'G9B07', 'How does the feed-point impedance of a 1/2 wave dipole antenna change as the antenna is lowered below 1/4 wave above ground?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (819, 'G9B08', 'How does the feed point impedance of a 1/2 wave dipole change as the feed point is moved from the center toward the ends?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (820, 'G9B09', 'Which of the following is an advantage of a horizontally polarized as compared to a vertically polarized HF antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (821, 'G9B10', 'What is the approximate length for a 1/2 wave dipole antenna cut for 14.250 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (822, 'G9B11', 'What is the approximate length for a 1/2 wave dipole antenna cut for 3.550 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (823, 'G9B12', 'What is the approximate length for a 1/4 wave vertical antenna cut for 28.5 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (824, 'G9C01', 'Which of the following would increase the bandwidth of a Yagi antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (825, 'G9C02', 'What is the approximate length of the driven element of a Yagi antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (826, 'G9C03', 'How do the lengths of a three-element Yagi reflector and director compare to that of the driven element?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (827, 'G9C04', 'How does antenna gain stated in dBi compare to gain stated in dBd for the same antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (828, 'G9C05', 'How does increasing boom length and adding directors affect a Yagi antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (829, 'G9C06', 'What configuration of the loops of a two-element quad antenna must be used for the antenna to operate as a beam antenna, assuming one of the elements is used as a reflector?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (830, 'G9C07', 'What does “front-to-back ratio” mean in reference to a Yagi antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (831, 'G9C08', 'What is meant by the “main lobe” of a directive antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (832, 'G9C09', 'How does the gain of two three-element, horizontally polarized Yagi antennas spaced vertically 1/2 wavelength apart typically compare to the gain of a single three-element Yagi?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (833, 'G9C10', 'Which of the following can be adjusted to optimize forward gain, front-to-back ratio, or SWR bandwidth of a Yagi antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (834, 'G9C11', 'Which HF antenna would be the best to use for minimizing interference?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (835, 'G9C12', 'Which of the following is an advantage of using a gamma match with a Yagi antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (836, 'G9C13', 'Approximately how long is each side of the driven element of a quad antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (837, 'G9C14', 'How does the forward gain of a two-element quad antenna compare to the forward gain of a three-element Yagi antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (838, 'G9C15', 'What is meant by the terms dBi and dBd when referring to antenna gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (839, 'G9C16', 'What is a beta or hairpin match?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (840, 'G9D01', 'Which of the following antenna types will be most effective as a Near Vertical Incidence Skywave (NVIS) antenna for short-skip communications on 40 meters during the day?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (841, 'G9D02', 'What is the feed-point impedance of an end-fed half-wave antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (842, 'G9D03', 'In which direction is the maximum radiation from a portable VHF/UHF “halo” antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (843, 'G9D04', 'What is the primary purpose of antenna traps?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (844, 'G9D05', 'What is an advantage of vertical stacking of horizontally polarized Yagi antennas?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (845, 'G9D06', 'Which of the following is an advantage of a log periodic antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (846, 'G9D07', 'Which of the following describes a log periodic antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (847, 'G9D08', 'How does a “screwdriver” mobile antenna adjust its feed-point impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (848, 'G9D09', 'What is the primary use of a Beverage antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (849, 'G9D10', 'In which direction or directions does an electrically small loop (less than 1/3 wavelength in circumference) have nulls in its radiation pattern?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (850, 'G9D11', 'Which of the following is a disadvantage of multiband antennas?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (851, 'G9D12', 'What is the common name of a dipole with a single central support?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (852, 'G9D13', 'What is the combined vertical and horizontal polarization pattern of a multi-wavelength, horizontal loop antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (853, 'G0A01', 'What is one way that RF energy can affect human body tissue?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (854, 'G0A02', 'Which of the following properties is important in estimating whether an RF signal exceeds the maximum permissible exposure (MPE)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (855, 'G0A03', 'How can you determine that your station complies with FCC RF exposure regulations?', 0, 1, 0, 0, '97.13(c)(1)');
INSERT INTO question VALUES (856, 'G0A04', 'What does “time averaging” mean in reference to RF radiation exposure?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (857, 'G0A05', 'What must you do if an evaluation of your station shows RF energy radiated from your station exceeds permissible limits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (858, 'G0A06', 'What precaution should be taken when installing a ground-mounted antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (859, 'G0A07', 'What effect does transmitter duty cycle have when evaluating RF exposure?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (860, 'G0A08', 'Which of the following steps must an amateur operator take to ensure compliance with RF safety regulations when transmitter power exceeds levels specified in FCC Part 97.13?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (861, 'G0A09', 'What type of instrument can be used to accurately measure an RF field?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (862, 'G0A10', 'What is one thing that can be done if evaluation shows that a neighbor might receive more than the allowable limit of RF exposure from the main lobe of a directional antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (863, 'G0A11', 'What precaution should you take if you install an indoor transmitting antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (864, 'G0B01', 'Which wire or wires in a four-conductor connection should be attached to fuses or circuit breakers in a device operated from a 240 VAC single phase source?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (865, 'G0B02', 'According to the National Electrical Code, what is the minimum wire size that may be used safely for wiring with a 20 ampere circuit breaker?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (866, 'G0B03', 'Which size of fuse or circuit breaker would be appropriate to use with a circuit that uses AWG number 14 wiring?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (867, 'G0B04', 'Which of the following is a primary reason for not placing a gasoline-fueled generator inside an occupied area?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (868, 'G0B05', 'Which of the following conditions will cause a Ground Fault Circuit Interrupter (GFCI) to disconnect the 120 or 240 Volt AC line power to a device?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (869, 'G0B06', 'Which of the following is covered by the National Electrical Code?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (870, 'G0B07', 'Which of these choices should be observed when climbing a tower using a safety belt or harness?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (871, 'G0B08', 'What should be done by any person preparing to climb a tower that supports electrically powered devices?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (872, 'G0B09', 'Which of the following is true of an emergency generator installation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (873, 'G0B10', 'Which of the following is a danger from lead-tin solder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (874, 'G0B11', 'Which of the following is good practice for lightning protection grounds?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (875, 'G0B12', 'What is the purpose of a power supply interlock?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (876, 'G0B13', 'What must you do when powering your house from an emergency generator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (877, 'G0B14', 'What precaution should you take whenever you adjust or repair an antenna?', 0, 1, 0, 0, '');

INSERT INTO question VALUES (878, 'E1A01', 'Which of the following carrier frequencies is illegal for LSB AFSK emissions on the 17 meter band RTTY and data segment of 18.068 to 18.110 MHz?', 0, 1, 0, 0, '97.305, 97.307(b)');
INSERT INTO question VALUES (879, 'E1A02', 'When using a transceiver that displays the carrier frequency of phone signals, which of the following displayed frequencies represents the lowest frequency at which a properly adjusted LSB emission will be totally within the band?', 0, 1, 0, 0, '97.301, 97.305');
INSERT INTO question VALUES (880, 'E1A03', 'What is the maximum legal carrier frequency on the 20 meter band for transmitting USB AFSK digital signals having a 1 kHz bandwidth?', 0, 1, 0, 0, '97.305, 97.307(b)');
INSERT INTO question VALUES (881, 'E1A04', 'With your transceiver displaying the carrier frequency of phone signals, you hear a DX station calling CQ on 3.601 MHz LSB. Is it legal to return the call using lower sideband on the same frequency?', 0, 1, 0, 0, '97.301, 97.305');
INSERT INTO question VALUES (882, 'E1A05', 'What is the maximum power output permitted on the 60 meter band?', 0, 1, 0, 0, '97.313');
INSERT INTO question VALUES (883, 'E1A06', 'Where must the carrier frequency of a CW signal be set to comply with FCC rules for 60 meter operation?', 0, 1, 0, 0, '97.303(h)(1)');
INSERT INTO question VALUES (884, 'E1A07', 'What is the maximum power permitted on the 2200 meter band?', 0, 1, 0, 0, '97.313(k)');
INSERT INTO question VALUES (885, 'E1A08', 'If a station in a message forwarding system inadvertently forwards a message that is in violation of FCC rules, who is primarily accountable for the rules violation?', 0, 1, 0, 0, '97.219');
INSERT INTO question VALUES (886, 'E1A09', 'What action or actions should you take if your digital message forwarding station inadvertently forwards a communication that violates FCC rules?', 0, 1, 0, 0, '97.219');
INSERT INTO question VALUES (887, 'E1A10', 'If an amateur station is installed aboard a ship or aircraft, what condition must be met before the station is operated?', 0, 1, 0, 0, '97.11');
INSERT INTO question VALUES (888, 'E1A11', 'Which of the following describes authorization or licensing required when operating an amateur station aboard a U.S.-registered vessel in international waters?', 0, 1, 0, 0, '97.5');
INSERT INTO question VALUES (889, 'E1A12', 'What special operating frequency restrictions are imposed on slow scan TV transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (890, 'E1A13', 'Who must be in physical control of the station apparatus of an amateur station aboard any vessel or craft that is documented or registered in the United States?', 0, 1, 0, 0, '97.5');
INSERT INTO question VALUES (891, 'E1A14', 'Except in some parts of Alaska, what is the maximum power permitted on the 630 meter band?', 0, 1, 0, 0, '97.313(l)');
INSERT INTO question VALUES (892, 'E1B01', 'Which of the following constitutes a spurious emission?', 0, 1, 0, 0, '97.3');
INSERT INTO question VALUES (893, 'E1B02', 'Which of the following is an acceptable bandwidth for Digital Radio Mondiale (DRM) based voice or SSTV digital transmissions made on the HF amateur bands?', 0, 1, 0, 0, '97.307(f)(2)');
INSERT INTO question VALUES (894, 'E1B03', 'Within what distance must an amateur station protect an FCC monitoring facility from harmful interference?', 0, 1, 0, 0, '97.13');
INSERT INTO question VALUES (895, 'E1B04', 'What must be done before placing an amateur station within an officially designated wilderness area or wildlife preserve, or an area listed in the National Register of Historic Places?', 0, 1, 0, 0, '97.13, 1.1305-1.1319');
INSERT INTO question VALUES (896, 'E1B05', 'What is the National Radio Quiet Zone?', 0, 1, 0, 0, '97.3');
INSERT INTO question VALUES (897, 'E1B06', 'Which of the following additional rules apply if you are installing an amateur station antenna at a site at or near a public use airport?', 0, 1, 0, 0, '97.15');
INSERT INTO question VALUES (898, 'E1B07', 'To what type of regulations does PRB-1 apply?', 0, 1, 0, 0, '97.15');
INSERT INTO question VALUES (899, 'E1B08', 'What limitations may the FCC place on an amateur station if its signal causes interference to domestic broadcast reception, assuming that the receivers involved are of good engineering design?', 0, 1, 0, 0, '97.121');
INSERT INTO question VALUES (900, 'E1B09', 'Which amateur stations may be operated under RACES rules?', 0, 1, 0, 0, '97.407');
INSERT INTO question VALUES (901, 'E1B10', 'What frequencies are authorized to an amateur station operating under RACES rules?', 0, 1, 0, 0, '97.407');
INSERT INTO question VALUES (902, 'E1B11', 'What does PRB-1 require of regulations affecting amateur radio?', 0, 1, 0, 0, '97.15');
INSERT INTO question VALUES (903, 'E1B12', 'What must the control operator of a repeater operating in the 70 cm band do if a radiolocation system experiences interference from that repeater?', 0, 1, 0, 0, '97.303(b)');
INSERT INTO question VALUES (904, 'E1C01', 'What is the maximum bandwidth for a data emission on 60 meters?', 0, 1, 0, 0, '97.303');
INSERT INTO question VALUES (905, 'E1C02', 'Which of the following types of communications may be transmitted to amateur stations in foreign countries?', 0, 1, 0, 0, '97.117');
INSERT INTO question VALUES (906, 'E1C03', 'How do the control operator responsibilities of a station under automatic control differ from one under local control?', 0, 1, 0, 0, '97.109(d)');
INSERT INTO question VALUES (907, 'E1C04', 'What is meant by IARP?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (908, 'E1C05', 'When may an automatically controlled station originate third party communications?', 0, 1, 0, 0, '97.221(c)(1), 97.115(c)');
INSERT INTO question VALUES (909, 'E1C06', 'Which of the following is required in order to operate in accordance with CEPT rules in foreign countries where permitted?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (910, 'E1C07', 'At what level below a signal''s mean power level is its bandwidth determined according to FCC rules?', 0, 1, 0, 0, '97.3(a)(8)');
INSERT INTO question VALUES (911, 'E1C08', 'What is the maximum permissible duration of a remotely controlled station''s transmissions if its control link malfunctions?', 0, 1, 0, 0, '97.213');
INSERT INTO question VALUES (912, 'E1C09', 'What is the highest modulation index permitted at the highest modulation frequency for angle modulation below 29.0 MHz?', 0, 1, 0, 0, '97.307');
INSERT INTO question VALUES (913, 'E1C10', 'What is the permitted mean power of any spurious emission relative to the mean power of the fundamental emission from a station transmitter or external RF amplifier installed after January 1, 2003 and transmitting on a frequency below 30 MHz?', 0, 1, 0, 0, '97.307');
INSERT INTO question VALUES (914, 'E1C11', 'Which of the following operating arrangements allows an FCC-licensed U.S. citizen to operate in many European countries, and alien amateurs from many European countries to operate in the U.S.?', 0, 1, 0, 0, '97.5');
INSERT INTO question VALUES (915, 'E1C12', 'On what portion of the 630 meter band are phone emissions permitted?', 0, 1, 0, 0, '97.305(c)');
INSERT INTO question VALUES (916, 'E1C13', 'What notifications must be given before transmitting on the 630 meter or 2200 meter bands?', 0, 1, 0, 0, '97.303(g)');
INSERT INTO question VALUES (917, 'E1C14', 'How long must an operator wait after filing a notification with the Utilities Telecom Commission before operating on the 2200 meter or 630 meter band?', 0, 1, 0, 0, '97.303(g)');
INSERT INTO question VALUES (918, 'E1D01', 'What is the definition of telemetry?', 0, 1, 0, 0, '97.3');
INSERT INTO question VALUES (919, 'E1D02', 'Which of the following may transmit special codes intended to obscure the meaning of messages?', 0, 1, 0, 0, '97.211(b)');
INSERT INTO question VALUES (920, 'E1D03', 'What is a space telecommand station?', 0, 1, 0, 0, '97.3(a)(45)');
INSERT INTO question VALUES (921, 'E1D04', 'Which of the following is required in the identification transmissions from a balloon-borne telemetry station?', 0, 1, 0, 0, '97.119(a)');
INSERT INTO question VALUES (922, 'E1D05', 'What must be posted at the station location of a station being operated by telecommand on or within 50 km of the earth''s surface?', 0, 1, 0, 0, '97.213(d)');
INSERT INTO question VALUES (923, 'E1D06', 'What is the maximum permitted transmitter output power when operating a model craft by telecommand?', 0, 1, 0, 0, '97.215(c)');
INSERT INTO question VALUES (924, 'E1D07', 'Which HF amateur bands have frequencies authorized for space stations?', 0, 1, 0, 0, '97.207');
INSERT INTO question VALUES (925, 'E1D08', 'Which VHF amateur bands have frequencies authorized for space stations?', 0, 1, 0, 0, '97.207');
INSERT INTO question VALUES (926, 'E1D09', 'Which UHF amateur bands have frequencies authorized for space stations?', 0, 1, 0, 0, '97.207');
INSERT INTO question VALUES (927, 'E1D10', 'Which amateur stations are eligible to be telecommand stations of space stations (subject to the privileges of the class of operator license held by the control operator of the station)?', 0, 1, 0, 0, '97.211');
INSERT INTO question VALUES (928, 'E1D11', 'Which amateur stations are eligible to operate as Earth stations?', 0, 1, 0, 0, '97.209');
INSERT INTO question VALUES (929, 'E1D12', 'Which of the following amateur stations may transmit one-way communications?', 0, 1, 0, 0, '97.207(e), 97.203(g)');
INSERT INTO question VALUES (930, 'E1E01', 'For which types of out-of-pocket expenses do the Part 97 rules state that VEs and VECs may be reimbursed?', 0, 1, 0, 0, '97.527');
INSERT INTO question VALUES (931, 'E1E02', 'Who does Part 97 task with maintaining the pools of questions for all U.S. amateur license examinations?', 0, 1, 0, 0, '97.523');
INSERT INTO question VALUES (932, 'E1E03', 'What is a Volunteer Examiner Coordinator?', 0, 1, 0, 0, '97.521');
INSERT INTO question VALUES (933, 'E1E04', 'Which of the following best describes the Volunteer Examiner accreditation process?', 0, 1, 0, 0, '97.509, 97.525');
INSERT INTO question VALUES (934, 'E1E05', 'What is the minimum passing score on all amateur operator license examinations?', 0, 1, 0, 0, '97.503');
INSERT INTO question VALUES (935, 'E1E06', 'Who is responsible for the proper conduct and necessary supervision during an amateur operator license examination session?', 0, 1, 0, 0, '97.509');
INSERT INTO question VALUES (936, 'E1E07', 'What should a VE do if a candidate fails to comply with the examiner''s instructions during an amateur operator license examination?', 0, 1, 0, 0, '97.509');
INSERT INTO question VALUES (937, 'E1E08', 'To which of the following examinees may a VE not administer an examination?', 0, 1, 0, 0, '97.509');
INSERT INTO question VALUES (938, 'E1E09', 'What may be the penalty for a VE who fraudulently administers or certifies an examination?', 0, 1, 0, 0, '97.509');
INSERT INTO question VALUES (939, 'E1E10', 'What must the administering VEs do after the administration of a successful examination for an amateur operator license?', 0, 1, 0, 0, '97.509(h)');
INSERT INTO question VALUES (940, 'E1E11', 'What must the VE team do if an examinee scores a passing grade on all examination elements needed for an upgrade or new license?', 0, 1, 0, 0, '97.509(m)');
INSERT INTO question VALUES (941, 'E1E12', 'What must the VE team do with the application form if the examinee does not pass the exam?', 0, 1, 0, 0, '97.509(j)');
INSERT INTO question VALUES (942, 'E1F01', 'On what frequencies are spread spectrum transmissions permitted?', 0, 1, 0, 0, '97.305');
INSERT INTO question VALUES (943, 'E1F02', 'What privileges are authorized in the U.S. to persons holding an amateur service license granted by the government of Canada?', 0, 1, 0, 0, '97.107');
INSERT INTO question VALUES (944, 'E1F03', 'Under what circumstances may a dealer sell an external RF power amplifier capable of operation below 144 MHz if it has not been granted FCC certification?', 0, 1, 0, 0, '97.315');
INSERT INTO question VALUES (945, 'E1F04', 'Which of the following geographic descriptions approximately describes "Line A"?', 0, 1, 0, 0, '97.3');
INSERT INTO question VALUES (946, 'E1F05', 'Amateur stations may not transmit in which of the following frequency segments if they are located in the contiguous 48 states and north of Line A?', 0, 1, 0, 0, '97.303');
INSERT INTO question VALUES (947, 'E1F06', 'Under what circumstances might the FCC issue a Special Temporary Authority (STA) to an amateur station?', 0, 1, 0, 0, '1.931');
INSERT INTO question VALUES (948, 'E1F07', 'When may an amateur station send a message to a business?', 0, 1, 0, 0, '97.113');
INSERT INTO question VALUES (949, 'E1F08', 'Which of the following types of amateur station communications are prohibited?', 0, 1, 0, 0, '97.113(c)');
INSERT INTO question VALUES (950, 'E1F09', 'Which of the following conditions apply when transmitting spread spectrum emissions?', 0, 1, 0, 0, '97.311');
INSERT INTO question VALUES (951, 'E1F10', 'Who may be the control operator of an auxiliary station?', 0, 1, 0, 0, '97.201');
INSERT INTO question VALUES (952, 'E1F11', 'Which of the following best describes one of the standards that must be met by an external RF power amplifier if it is to qualify for a grant of FCC certification?', 0, 1, 0, 0, '97.317');
INSERT INTO question VALUES (953, 'E2A01', 'What is the direction of an ascending pass for an amateur satellite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (954, 'E2A02', 'Which of the following occurs when a satellite is using an inverted linear transponder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (955, 'E2A03', 'How is the signal inverted by an inverting linear transponder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (956, 'E2A04', 'What is meant by the term mode? as applied to an amateur radio satellite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (957, 'E2A05', 'What do the letters in a satellite''s mode designator specify?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (958, 'E2A06', 'What are Keplerian elements?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (959, 'E2A07', 'Which of the following types of signals can be relayed through a linear transponder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (960, 'E2A08', 'Why should effective radiated power to a satellite that uses a linear transponder be limited?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (961, 'E2A09', 'What do the terms L band and S band specify regarding satellite communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (962, 'E2A10', 'What type of satellite appears to stay in one position in the sky?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (963, 'E2A11', 'What type of antenna can be used to minimize the effects of spin modulation and Faraday rotation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (964, 'E2A12', 'What is the purpose of digital store-and-forward functions on an amateur radio satellite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (965, 'E2A13', 'Which of the following techniques is normally used by low Earth orbiting digital satellites to relay messages around the world?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (966, 'E2B01', 'How many times per second is a new frame transmitted in a fast-scan (NTSC) television system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (967, 'E2B02', 'How many horizontal lines make up a fast-scan (NTSC) television frame?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (968, 'E2B03', 'How is an interlaced scanning pattern generated in a fast-scan (NTSC) television system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (969, 'E2B04', 'How is color information sent in analog SSTV?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (970, 'E2B05', 'Which of the following describes the use of vestigial sideband in analog fast-scan TV transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (971, 'E2B06', 'What is vestigial sideband modulation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (972, 'E2B07', 'What is the name of the signal component that carries color information in NTSC video?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (973, 'E2B08', 'What technique allows commercial analog TV receivers to be used for fast-scan TV operations on the 70 cm band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (974, 'E2B09', 'What hardware, other than a receiver with SSB capability and a suitable computer, is needed to decode SSTV using Digital Radio Mondiale (DRM)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (975, 'E2B10', 'What aspect of an analog slow-scan television signal encodes the brightness of the picture?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (976, 'E2B11', 'What is the function of the Vertical Interval Signaling (VIS) code sent as part of an SSTV transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (977, 'E2B12', 'What signals SSTV receiving software to begin a new picture line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (978, 'E2C01', 'What indicator is required to be used by U.S.-licensed operators when operating a station via remote control and the remote transmitter is located in the U.S.?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (979, 'E2C02', 'Which of the following best describes the term self-spotting? in connection with HF contest operating?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (980, 'E2C03', 'From which of the following bands is amateur radio contesting generally excluded?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (981, 'E2C04', 'Which of the following frequencies are sometimes used for amateur radio mesh networks?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (982, 'E2C05', 'What is the function of a DX QSL Manager?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (983, 'E2C06', 'During a VHF/UHF contest, in which band segment would you expect to find the highest level of SSB or CW activity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (984, 'E2C07', 'What is the Cabrillo format?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (985, 'E2C08', 'Which of the following contacts may be confirmed through the U.S. QSL bureau system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (986, 'E2C09', 'What type of equipment is commonly used to implement an amateur radio mesh network?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (987, 'E2C10', 'Why might a DX station state that they are listening on another frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (988, 'E2C11', 'How should you generally identify your station when attempting to contact a DX station during a contest or in a pileup?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (989, 'E2C12', 'What technique do individual nodes use to form a mesh network?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (990, 'E2D01', 'Which of the following digital modes is designed for meteor scatter communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (991, 'E2D02', 'Which of the following is a good technique for making meteor scatter contacts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (992, 'E2D03', 'Which of the following digital modes is especially useful for EME communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (993, 'E2D04', 'What technology is used to track, in real time, balloons carrying amateur radio transmitters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (994, 'E2D05', 'What is one advantage of the JT65 mode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (995, 'E2D06', 'Which of the following describes a method of establishing EME contacts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (996, 'E2D07', 'What digital protocol is used by APRS?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (997, 'E2D08', 'What type of packet frame is used to transmit APRS beacon data?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (998, 'E2D09', 'What type of modulation is used for JT65 contacts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (999, 'E2D10', 'How can an APRS station be used to help support a public service communications activity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1000, 'E2D11', 'Which of the following data are used by the APRS network to communicate station location?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1001, 'E2E01', 'Which of the following types of modulation is common for data emissions below 30 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1002, 'E2E02', 'What do the letters FEC mean as they relate to digital operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1003, 'E2E03', 'How is the timing of FT4 contacts organized?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1004, 'E2E04', 'What is indicated when one of the ellipses in an FSK crossed-ellipse display suddenly disappears?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1005, 'E2E05', 'Which of these digital modes does not support keyboard-to-keyboard operation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1006, 'E2E06', 'What is the most common data rate used for HF packet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1007, 'E2E07', 'Which of the following is a possible reason that attempts to initiate contact with a digital station on a clear frequency are unsuccessful?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1008, 'E2E08', 'Which of the following HF digital modes can be used to transfer binary files?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1009, 'E2E09', 'Which of the following HF digital modes uses variable-length coding for bandwidth efficiency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1010, 'E2E10', 'Which of these digital modes has the narrowest bandwidth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1011, 'E2E11', 'What is the difference between direct FSK and audio FSK?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1012, 'E2E12', 'How do ALE stations establish contact?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1013, 'E2E13', 'Which of these digital modes has the fastest data throughput under clear communication conditions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1014, 'E3A01', 'What is the approximate maximum separation measured along the surface of the Earth between two stations communicating by EME?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1015, 'E3A02', 'What characterizes libration fading of an EME signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1016, 'E3A03', 'When scheduling EME contacts, which of these conditions will generally result in the least path loss?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1017, 'E3A04', 'What do Hepburn maps predict?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1018, 'E3A05', 'Tropospheric propagation of microwave signals often occurs in association with what phenomenon?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1019, 'E3A06', 'What might help to restore contact when DX signals become too weak to copy across an entire HF band a few hours after sunset?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1020, 'E3A07', 'Atmospheric ducts capable of propagating microwave signals often form over what geographic feature?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1021, 'E3A08', 'When a meteor strikes the Earth''s atmosphere, a cylindrical region of free electrons is formed at what layer of the ionosphere?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1022, 'E3A09', 'Which of the following frequency ranges is most suited for meteor scatter communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1023, 'E3A10', 'Which type of atmospheric structure can create a path for microwave propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1024, 'E3A11', 'What is a typical range for tropospheric propagation of microwave signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1025, 'E3A12', 'What is the cause of auroral activity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1026, 'E3A13', 'Which of these emission modes is best for auroral propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1027, 'E3A14', 'What is meant by circularly polarized electromagnetic waves?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1028, 'E3B01', 'What is transequatorial propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1029, 'E3B02', 'What is the approximate maximum range for signals using transequatorial propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1030, 'E3B03', 'What is the best time of day for transequatorial propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1031, 'E3B04', 'What is meant by the terms "extraordinary" and "ordinary" waves?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1032, 'E3B05', 'Which amateur bands typically support long-path propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1033, 'E3B06', 'Which of the following amateur bands most frequently provides long-path propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1034, 'E3B07', 'What happens to linearly polarized radio waves that split into ordinary and extraordinary waves in the ionosphere?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1035, 'E3B08', 'What is the term for the long path opening that exists between two points on the Earth which are simultaneously near sunrise and sunset?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1036, 'E3B09', 'At what time of year is sporadic E propagation most likely to occur?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1037, 'E3B10', 'Why is chordal hop propagation desirable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1038, 'E3B11', 'At what time of day can sporadic E propagation occur?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1039, 'E3B12', 'What is the primary characteristic of chordal hop propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1040, 'E3C01', 'What does the radio communication term "ray tracing" describe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1041, 'E3C02', 'What is indicated by a rising A or K index?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1042, 'E3C03', 'Which of the following signal paths is most likely to experience high levels of absorption when the A index or K index is elevated?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1043, 'E3C04', 'What does the value of Bz (B sub Z) represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1044, 'E3C05', 'What orientation of Bz (B sub z) increases the likelihood that incoming particles from the sun will cause disturbed conditions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1045, 'E3C06', 'By how much does the VHF/UHF radio horizon distance exceed the geometric horizon?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1046, 'E3C07', 'Which of the following descriptors indicates the greatest solar flare intensity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1047, 'E3C08', 'What does the space weather term G5 mean?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1048, 'E3C09', 'How does the intensity of an X3 flare compare to that of an X2 flare?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1049, 'E3C10', 'What does the 304A solar parameter measure?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1050, 'E3C11', 'What does VOACAP software model?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1051, 'E3C12', 'How does the maximum range of ground-wave propagation change when the signal frequency is increased?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1052, 'E3C13', 'What type of polarization is best for ground-wave propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1053, 'E3C14', 'Why does the radio-path horizon distance exceed the geometric horizon?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1054, 'E3C15', 'What might be indicated by a sudden rise in radio background noise across a large portion of the HF spectrum?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1055, 'E4A01', 'Which of the following limits the highest frequency signal that can be accurately displayed on a digital oscilloscope?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1056, 'E4A02', 'Which of the following parameters does a spectrum analyzer display on the vertical and horizontal axes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1057, 'E4A03', 'Which of the following test instruments is used to display spurious signals and/or intermodulation distortion products generated by an SSB transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1058, 'E4A04', 'How is the compensation of an oscilloscope probe typically adjusted?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1059, 'E4A05', 'What is the purpose of the prescaler function on a frequency counter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1060, 'E4A06', 'What is the effect of aliasing on a digital oscilloscope caused by setting the time base too slow?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1061, 'E4A07', 'Which of the following is an advantage of using an antenna analyzer compared to an SWR bridge to measure antenna SWR?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1062, 'E4A08', 'Which of the following measures SWR?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1063, 'E4A09', 'Which of the following is good practice when using an oscilloscope probe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1064, 'E4A10', 'Which of the following displays multiple digital signal states simultaneously?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1065, 'E4A11', 'How should an antenna analyzer be connected when measuring antenna resonance and feed point impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1066, 'E4B01', 'Which of the following factors most affects the accuracy of a frequency counter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1067, 'E4B02', 'What is the significance of voltmeter sensitivity expressed in ohms per volt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1068, 'E4B03', 'Which S parameter is equivalent to forward gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1069, 'E4B04', 'Which S parameter represents input port return loss or reflection coefficient (equivalent to VSWR)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1070, 'E4B05', 'What three test loads are used to calibrate an RF vector network analyzer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1071, 'E4B06', 'How much power is being absorbed by the load when a directional power meter connected between a transmitter and a terminating load reads 100 watts forward power and 25 watts reflected power?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1072, 'E4B07', 'What do the subscripts of S parameters represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1073, 'E4B08', 'Which of the following can be used to measure the Q of a series-tuned circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1074, 'E4B09', 'What is indicated if the current reading on an RF ammeter placed in series with the antenna feed line of a transmitter increases as the transmitter is tuned to resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1075, 'E4B10', 'Which of the following methods measures intermodulation distortion in an SSB transmitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1076, 'E4B11', 'Which of the following can be measured with a vector network analyzer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1077, 'E4C01', 'What is an effect of excessive phase noise in a receiver''s local oscillator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1078, 'E4C02', 'Which of the following receiver circuits can be effective in eliminating interference from strong out-of-band signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1079, 'E4C03', 'What is the term for the suppression in an FM receiver of one signal by another stronger signal on the same frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1080, 'E4C04', 'What is the noise figure of a receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1081, 'E4C05', 'What does a receiver noise floor of -174 dBm represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1082, 'E4C06', 'A CW receiver with the AGC off has an equivalent input noise power density of -174 dBm/Hz.  What would be the level of an unmodulated carrier input to this receiver that would yield an audio output SNR of 0 dB in a 400 Hz noise bandwidth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1083, 'E4C07', 'What does the MDS of a receiver represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1084, 'E4C08', 'An SDR receiver is overloaded when input signals exceed what level?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1085, 'E4C09', 'Which of the following choices is a good reason for selecting a high frequency for the design of the IF in a superheterodyne HF or VHF communications receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1086, 'E4C10', 'What is an advantage of having a variety of receiver IF bandwidths from which to select?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1087, 'E4C11', 'Why can an attenuator be used to reduce receiver overload on the lower frequency HF bands with little or no impact on signal-to-noise ratio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1088, 'E4C12', 'Which of the following has the largest effect on an SDR receiver''s dynamic range?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1089, 'E4C13', 'How does a narrow-band roofing filter affect receiver performance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1090, 'E4C14', 'What transmit frequency might generate an image response signal in a receiver tuned to 14.300 MHz and that uses a 455 kHz IF frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1091, 'E4C15', 'What is reciprocal mixing?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1092, 'E4D01', 'What is meant by the blocking dynamic range of a receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1093, 'E4D02', 'Which of the following describes problems caused by poor dynamic range in a receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1094, 'E4D03', 'How can intermodulation interference between two repeaters occur?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1095, 'E4D04', 'Which of the following may reduce or eliminate intermodulation interference in a repeater caused by another transmitter operating in close proximity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1096, 'E4D05', 'What transmitter frequencies would cause an intermodulation-product signal in a receiver tuned to 146.70 MHz when a nearby station transmits on 146.52 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1097, 'E4D06', 'What is the term for spurious signals generated by the combination of two or more signals in a non-linear device or circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1098, 'E4D07', 'Which of the following reduces the likelihood of receiver desensitization?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1099, 'E4D08', 'What causes intermodulation in an electronic circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1100, 'E4D09', 'What is the purpose of the preselector in a communications receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1101, 'E4D10', 'What does a third-order intercept level of 40 dBm mean with respect to receiver performance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1102, 'E4D11', 'Why are odd-order intermodulation products, created within a receiver, of particular interest compared to other products?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1103, 'E4D12', 'What is the term for the reduction in receiver sensitivity caused by a strong signal near the received frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1104, 'E4E01', 'What problem can occur when using an automatic notch filter (ANF) to remove interfering carriers while receiving CW signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1105, 'E4E02', 'Which of the following types of noise can often be reduced with a digital signal processing noise filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1106, 'E4E03', 'Which of the following signals might a receiver noise blanker be able to remove from desired signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1107, 'E4E04', 'How can conducted and radiated noise caused by an automobile alternator be suppressed?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1108, 'E4E05', 'How can radio frequency interference from an AC motor be suppressed?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1109, 'E4E06', 'What is one type of electrical interference that might be caused by a nearby personal computer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1110, 'E4E07', 'Which of the following can cause shielded cables to radiate or receive interference?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1111, 'E4E08', 'What current flows equally on all conductors of an unshielded multi-conductor cable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1112, 'E4E09', 'What undesirable effect can occur when using an IF noise blanker?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1113, 'E4E10', 'What might be the cause of a loud roaring or buzzing AC line interference that comes and goes at intervals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1114, 'E4E11', 'What could cause local AM broadcast band signals to combine to generate spurious signals in the MF or HF bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1115, 'E5A01', 'What can cause the voltage across reactances in a series RLC circuit to be higher than the voltage applied to the entire circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1116, 'E5A02', 'What is resonance in an LC or RLC circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1117, 'E5A03', 'What is the magnitude of the impedance of a series RLC circuit at resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1118, 'E5A04', 'What is the magnitude of the impedance of a parallel RLC circuit at resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1119, 'E5A05', 'What is the result of increasing the Q of an impedance-matching circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1120, 'E5A06', 'What is the magnitude of the circulating current within the components of a parallel LC circuit at resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1121, 'E5A07', 'What is the magnitude of the current at the input of a parallel RLC circuit at resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1122, 'E5A08', 'What is the phase relationship between the current through and the voltage across a series resonant circuit at resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1123, 'E5A09', 'How is the Q of an RLC parallel resonant circuit calculated?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1124, 'E5A10', 'How is the Q of an RLC series resonant circuit calculated?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1125, 'E5A11', 'What is the half-power bandwidth of a resonant circuit that has a resonant frequency of 7.1 MHz and a Q of 150?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1126, 'E5A12', 'What is the half-power bandwidth of a resonant circuit that has a resonant frequency of 3.7 MHz and a Q of 118?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1127, 'E5A13', 'What is an effect of increasing Q in a series resonant circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1128, 'E5A14', 'What is the resonant frequency of an RLC circuit if R is 22 ohms, L is 50 microhenries and C is 40 picofarads?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1129, 'E5A15', 'Which of the following increases Q for inductors and capacitors?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1130, 'E5A16', 'What is the resonant frequency of an RLC circuit if R is 33 ohms, L is 50 microhenries and C is 10 picofarads?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1131, 'E5B01', 'What is the term for the time required for the capacitor in an RC circuit to be charged to 63.2% of the applied voltage or to discharge to 36.8% of its initial voltage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1132, 'E5B02', 'What letter is commonly used to represent susceptance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1133, 'E5B03', 'How is impedance in polar form converted to an equivalent admittance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1134, 'E5B04', 'What is the time constant of a circuit having two 220 microfarad capacitors and two 1 megohm resistors, all in parallel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1135, 'E5B05', 'What happens to the magnitude of a pure reactance when it is converted to a susceptance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1136, 'E5B06', 'What is susceptance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1137, 'E5B07', 'What is the phase angle between the voltage across and the current through a series RLC circuit if XC is 500 ohms, R is 1 kilohm, and XL is 250 ohms?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1138, 'E5B08', 'What is the phase angle between the voltage across and the current through a series RLC circuit if XC is 100 ohms, R is 100 ohms, and XL is 75 ohms?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1139, 'E5B09', 'What is the relationship between the AC current through a capacitor and the voltage across a capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1140, 'E5B10', 'What is the relationship between the AC current through an inductor and the voltage across an inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1141, 'E5B11', 'What is the phase angle between the voltage across and the current through a series RLC circuit if XC is 25 ohms, R is 100 ohms, and XL is 50 ohms?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1142, 'E5B12', 'What is admittance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1143, 'E5C01', 'Which of the following represents capacitive reactance in rectangular notation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1144, 'E5C02', 'How are impedances described in polar coordinates?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1145, 'E5C03', 'Which of the following represents an inductive reactance in polar coordinates?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1146, 'E5C04', 'What coordinate system is often used to display the resistive, inductive, and/or capacitive reactance components of impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1147, 'E5C05', 'What is the name of the diagram used to show the phase relationship between impedances at a given frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1148, 'E5C06', 'What does the impedance 50-j25 represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1149, 'E5C07', 'Where is the impedance of a pure resistance plotted on rectangular coordinates?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1150, 'E5C08', 'What coordinate system is often used to display the phase angle of a circuit containing resistance, inductive and/or capacitive reactance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1151, 'E5C09', 'When using rectangular coordinates to graph the impedance of a circuit, what do the axes represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1152, 'E5C10', 'Which point on Figure E5-1 best represents the impedance of a series circuit consisting of a 400-ohm resistor and a 38-picofarad capacitor at 14 MHz?<p><img src=''e5_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1153, 'E5C11', 'Which point in Figure E5-1 best represents the impedance of a series circuit consisting of a 300-ohm resistor and an 18-microhenry inductor at 3.505 MHz?<p><img src=''e5_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1154, 'E5C12', 'Which point on Figure E5-1 best represents the impedance of a series circuit consisting of a 300-ohm resistor and a 19-picofarad capacitor at 21.200 MHz?<p><img src=''e5_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1155, 'E5D01', 'What is the result of skin effect?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1156, 'E5D02', 'Why is it important to keep lead lengths short for components used in circuits for VHF and above?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1157, 'E5D03', 'What is microstrip?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1158, 'E5D04', 'Why are short connections used at microwave frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1159, 'E5D05', 'What is the power factor of an RL circuit having a 30-degree phase angle between the voltage and the current?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1160, 'E5D06', 'In what direction is the magnetic field oriented about a conductor in relation to the direction of electron flow?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1161, 'E5D07', 'How many watts are consumed in a circuit having a power factor of 0.71 if the apparent power is 500VA?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1162, 'E5D08', 'How many watts are consumed in a circuit having a power factor of 0.6 if the input is 200VAC at 5 amperes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1163, 'E5D09', 'What happens to reactive power in an AC circuit that has both ideal inductors and ideal capacitors?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1164, 'E5D10', 'How can the true power be determined in an AC circuit where the voltage and current are out of phase?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1165, 'E5D11', 'What is the power factor of an RL circuit having a 60-degree phase angle between the voltage and the current?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1166, 'E5D12', 'How many watts are consumed in a circuit having a power factor of 0.2 if the input is 100 VAC at 4 amperes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1167, 'E5D13', 'How many watts are consumed in a circuit consisting of a 100-ohm resistor in series with a 100-ohm inductive reactance drawing 1 ampere?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1168, 'E5D14', 'What is reactive power?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1169, 'E5D15', 'What is the power factor of an RL circuit having a 45-degree phase angle between the voltage and the current?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1170, 'E6A01', 'In what application is gallium arsenide used as a semiconductor material?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1171, 'E6A02', 'Which of the following semiconductor materials contains excess free electrons?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1172, 'E6A03', 'Why does a PN-junction diode not conduct current when reverse biased?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1173, 'E6A04', 'What is the name given to an impurity atom that adds holes to a semiconductor crystal structure?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1174, 'E6A05', 'How does DC input impedance at the gate of a field-effect transistor compare with the DC input impedance of a bipolar transistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1175, 'E6A06', 'What is the beta of a bipolar junction transistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1176, 'E6A07', 'Which of the following indicates that a silicon NPN junction transistor is biased on?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1177, 'E6A08', 'What term indicates the frequency at which the grounded-base current gain of a transistor has decreased to 0.7 of the gain obtainable at 1 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1178, 'E6A09', 'What is a depletion-mode FET?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1179, 'E6A10', 'In Figure E6-1, what is the schematic symbol for an N-channel dual-gate MOSFET?<p><img src=''e6_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1180, 'E6A11', 'In Figure E6-1, what is the schematic symbol for a P-channel junction FET?<p><img src=''e6_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1181, 'E6A12', 'Why do many MOSFET devices have internally connected Zener diodes on the gates?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1182, 'E6B01', 'What is the most useful characteristic of a Zener diode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1183, 'E6B02', 'What is an important characteristic of a Schottky diode as compared to an ordinary silicon diode when used as a power supply rectifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1184, 'E6B03', 'What type of bias is required for an LED to emit light?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1185, 'E6B04', 'What type of semiconductor device is designed for use as a voltage-controlled capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1186, 'E6B05', 'What characteristic of a PIN diode makes it useful as an RF switch?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1187, 'E6B06', 'Which of the following is a common use of a Schottky diode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1188, 'E6B07', 'What is the failure mechanism when a junction diode fails due to excessive current?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1189, 'E6B08', 'Which of the following is a Schottky barrier diode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1190, 'E6B09', 'What is a common use for point-contact diodes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1191, 'E6B10', 'In Figure E6-2, what is the schematic symbol for a light-emitting diode?<p><img src=''e6_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1192, 'E6B11', 'What is used to control the attenuation of RF signals by a PIN diode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1193, 'E6C01', 'What is the function of hysteresis in a comparator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1194, 'E6C02', 'What happens when the level of a comparator''s input signal crosses the threshold?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1195, 'E6C03', 'What is tri-state logic?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1196, 'E6C04', 'Which of the following is an advantage of BiCMOS logic?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1197, 'E6C05', 'What is an advantage of CMOS logic devices over TTL devices?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1198, 'E6C06', 'Why do CMOS digital integrated circuits have high immunity to noise on the input signal or power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1199, 'E6C07', 'What best describes a pull-up or pull-down resistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1200, 'E6C08', 'In Figure E6-3, what is the schematic symbol for a NAND gate?<p><img src=''e6_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1201, 'E6C09', 'What is a Programmable Logic Device (PLD)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1202, 'E6C10', 'In Figure E6-3, what is the schematic symbol for a NOR gate?<p><img src=''e6_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1203, 'E6C11', 'In Figure E6-3, what is the schematic symbol for the NOT operation (inverter)?<p><img src=''e6_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1204, 'E6D01', 'Why should core saturation of an impedance matching transformer be avoided?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1205, 'E6D02', 'What is the equivalent circuit of a quartz crystal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1206, 'E6D03', 'Which of the following is an aspect of the piezoelectric effect?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1207, 'E6D04', 'Which materials are commonly used as a core in an inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1208, 'E6D05', 'What is one reason for using ferrite cores rather than powdered iron in an inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1209, 'E6D06', 'What core material property determines the inductance of an inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1210, 'E6D07', 'What is current in the primary winding of a transformer called if no load is attached to the secondary?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1211, 'E6D08', 'What is one reason for using powdered-iron cores rather than ferrite cores in an inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1212, 'E6D09', 'What devices are commonly used as VHF and UHF parasitic suppressors at the input and output terminals of a transistor HF amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1213, 'E6D10', 'What is a primary advantage of using a toroidal core instead of a solenoidal core in an inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1214, 'E6D11', 'Which type of core material decreases inductance when inserted into a coil?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1215, 'E6D12', 'What is inductor saturation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1216, 'E6D13', 'What is the primary cause of inductor self-resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1217, 'E6E01', 'Why is gallium arsenide (GaAs) useful for semiconductor devices operating at UHF and higher frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1218, 'E6E02', 'Which of the following device packages is a through-hole type?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1219, 'E6E03', 'Which of the following materials is likely to provide the highest frequency of operation when used in MMICs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1220, 'E6E04', 'Which is the most common input and output impedance of circuits that use MMICs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1221, 'E6E05', 'Which of the following noise figure values is typical of a low-noise UHF preamplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1222, 'E6E06', 'What characteristics of the MMIC make it a popular choice for VHF through microwave circuits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1223, 'E6E07', 'What type of transmission line is used for connections to MMICs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1224, 'E6E08', 'How is power supplied to the most common type of MMIC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1225, 'E6E09', 'Which of the following component package types would be most suitable for use at frequencies above the HF range?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1226, 'E6E10', 'What advantage does surface-mount technology offer at RF compared to using through-hole components?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1227, 'E6E11', 'What is a characteristic of DIP packaging used for integrated circuits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1228, 'E6E12', 'Why are DIP through-hole package ICs not typically used at UHF and higher frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1229, 'E6F01', 'What absorbs the energy from light falling on a photovoltaic cell?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1230, 'E6F02', 'What happens to the conductivity of a photoconductive material when light shines on it?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1231, 'E6F03', 'What is the most common configuration of an optoisolator or optocoupler?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1232, 'E6F04', 'What is the photovoltaic effect?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1233, 'E6F05', 'Which describes an optical shaft encoder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1234, 'E6F06', 'Which of these materials is most commonly used to create photoconductive devices?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1235, 'E6F07', 'What is a solid-state relay?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1236, 'E6F08', 'Why are optoisolators often used in conjunction with solid-state circuits when switching 120 VAC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1237, 'E6F09', 'What is the efficiency of a photovoltaic cell?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1238, 'E6F10', 'What is the most common type of photovoltaic cell used for electrical power generation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1239, 'E6F11', 'What is the approximate open-circuit voltage produced by a fully illuminated silicon photovoltaic cell?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1240, 'E7A01', 'Which circuit is bistable?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1241, 'E7A02', 'What is the function of a decade counter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1242, 'E7A03', 'Which of the following can divide the frequency of a pulse train by 2?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1243, 'E7A04', 'How many flip-flops are required to divide a signal frequency by 4?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1244, 'E7A05', 'Which of the following is a circuit that continuously alternates between two states without an external clock?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1245, 'E7A06', 'What is a characteristic of a monostable multivibrator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1246, 'E7A07', 'What logical operation does a NAND gate perform?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1247, 'E7A08', 'What logical operation does an OR gate perform?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1248, 'E7A09', 'What logical operation is performed by an exclusive NOR gate?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1249, 'E7A10', 'What is a truth table?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1250, 'E7A11', 'What type of logic defines "1" as a high voltage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1251, 'E7B01', 'For what portion of the signal cycle does each active element in a push-pull Class AB amplifier conduct?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1252, 'E7B02', 'What is a Class D amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1253, 'E7B03', 'Which of the following components form the output of a class D amplifier circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1254, 'E7B04', 'Where on the load line of a Class A common emitter amplifier would bias normally be set?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1255, 'E7B05', 'What can be done to prevent unwanted oscillations in an RF power amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1256, 'E7B06', 'Which of the following amplifier types reduces even-order harmonics?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1257, 'E7B07', 'Which of the following is a likely result when a Class C amplifier is used to amplify a single-sideband phone signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1258, 'E7B08', 'How can an RF power amplifier be neutralized?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1259, 'E7B09', 'Which of the following describes how the loading and tuning capacitors are to be adjusted when tuning a vacuum tube RF power amplifier that employs a Pi-network output circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1260, 'E7B10', 'In Figure E7-1, what is the purpose of R1 and R2?<p><img src=''e7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1261, 'E7B11', 'In Figure E7-1, what is the purpose of R3?<p><img src=''e7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1262, 'E7B12', 'What type of amplifier circuit is shown in Figure E7-1?<p><img src=''e7_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1263, 'E7B13', 'Which of the following describes an emitter follower (or common collector) amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1264, 'E7B14', 'Why are switching amplifiers more efficient than linear amplifiers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1265, 'E7B15', 'What is one way to prevent thermal runaway in a bipolar transistor amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1266, 'E7B16', 'What is the effect of intermodulation products in a linear power amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1267, 'E7B17', 'Why are odd-order rather than even-order intermodulation distortion products of concern in linear power amplifiers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1268, 'E7B18', 'What is a characteristic of a grounded-grid amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1269, 'E7C01', 'How are the capacitors and inductors of a low-pass filter Pi-network arranged between the network''s input and output?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1270, 'E7C02', 'Which of the following is a property of a T-network with series capacitors and a parallel shunt inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1271, 'E7C03', 'What advantage does a series-L Pi-L-network have over a series-L Pi-network for impedance matching between the final amplifier of a vacuum-tube transmitter and an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1272, 'E7C04', 'How does an impedance-matching circuit transform a complex impedance to a resistive impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1273, 'E7C05', 'Which filter type is described as having ripple in the passband and a sharp cutoff?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1274, 'E7C06', 'What are the distinguishing features of an elliptical filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1275, 'E7C07', 'Which describes a Pi-L-network used for matching a vacuum tube final amplifier to a 50-ohm unbalanced output?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1276, 'E7C08', 'Which of the following factors has the greatest effect on the bandwidth and response shape of a crystal ladder filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1277, 'E7C09', 'What is a crystal lattice filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1278, 'E7C10', 'Which of the following filters would be the best choice for use in a 2 meter band repeater duplexer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1279, 'E7C11', 'Which of the following describes a receiving filter''s ability to reject signals occupying an adjacent channel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1280, 'E7C12', 'What is one advantage of a Pi-matching network over an L-matching network consisting of a single inductor and a single capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1281, 'E7D01', 'How does a linear electronic voltage regulator work?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1282, 'E7D02', 'What is a characteristic of a switching electronic voltage regulator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1283, 'E7D03', 'What device is typically used as a stable voltage reference in a linear voltage regulator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1284, 'E7D04', 'Which of the following types of linear voltage regulator usually make the most efficient use of the primary power source?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1285, 'E7D05', 'Which of the following types of linear voltage regulator places a constant load on the unregulated voltage source?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1286, 'E7D06', 'What is the purpose of Q1 in the circuit shown in Figure E7-2?<p><img src=''e7_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1287, 'E7D07', 'What is the purpose of C2 in the circuit shown in Figure E7-2?<p><img src=''e7_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1288, 'E7D08', 'What type of circuit is shown in Figure E7-2?<p><img src=''e7_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1289, 'E7D09', 'What is the main reason to use a charge controller with a solar power system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1290, 'E7D10', 'What is the primary reason that a high-frequency switching type high-voltage power supply can be both less expensive and lighter in weight than a conventional power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1291, 'E7D11', 'What is the function of the pass transistor in a linear voltage regulator circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1292, 'E7D12', 'What is the dropout voltage of an analog voltage regulator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1293, 'E7D13', 'What is the equation for calculating power dissipated by a series linear voltage regulator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1294, 'E7D14', 'What is the purpose of connecting equal-value resistors across power supply filter capacitors connected in series?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1295, 'E7D15', 'What is the purpose of a step-start circuit in a high-voltage power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1296, 'E7E01', 'Which of the following can be used to generate FM phone emissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1297, 'E7E02', 'What is the function of a reactance modulator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1298, 'E7E03', 'What is a frequency discriminator stage in a FM receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1299, 'E7E04', 'What is one way a single-sideband phone signal can be generated?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1300, 'E7E05', 'What circuit is added to an FM transmitter to boost the higher audio frequencies?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1301, 'E7E06', 'Why is de-emphasis commonly used in FM communications receivers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1302, 'E7E07', 'What is meant by the term "baseband" in radio communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1303, 'E7E08', 'What are the principal frequencies that appear at the output of a mixer circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1304, 'E7E09', 'What occurs when an excessive amount of signal energy reaches a mixer circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1305, 'E7E10', 'How does a diode envelope detector function?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1306, 'E7E11', 'Which type of detector circuit is used for demodulating SSB signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1307, 'E7F01', 'What is meant by direct digital conversion as applied to software defined radios?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1308, 'E7F02', 'What kind of digital signal processing audio filter is used to remove unwanted noise from a received SSB signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1309, 'E7F03', 'What type of digital signal processing filter is used to generate an SSB signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1310, 'E7F04', 'What is a common method of generating an SSB signal using digital signal processing?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1311, 'E7F05', 'How frequently must an analog signal be sampled by an analog-to-digital converter so that the signal can be accurately reproduced?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1312, 'E7F06', 'What is the minimum number of bits required for an analog-to-digital converter to sample a signal with a range of 1 volt at a resolution of 1 millivolt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1313, 'E7F07', 'What function is performed by a Fast Fourier Transform?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1314, 'E7F08', 'What is the function of decimation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1315, 'E7F09', 'Why is an anti-aliasing digital filter required in a digital decimator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1316, 'E7F10', 'What aspect of receiver analog-to-digital conversion determines the maximum receive bandwidth of a Direct Digital Conversion SDR?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1317, 'E7F11', 'What sets the minimum detectable signal level for a direct-sampling SDR receiver in the absence of atmospheric or thermal noise?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1318, 'E7F12', 'Which of the following is an advantage of a Finite Impulse Response (FIR) filter vs an Infinite Impulse Response (IIR) digital filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1319, 'E7F13', 'What is the function of taps in a digital signal processing filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1320, 'E7F14', 'Which of the following would allow a digital signal processing filter to create a sharper filter response?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1321, 'E7G01', 'What is the typical output impedance of an op-amp?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1322, 'E7G02', 'What is ringing in a filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1323, 'E7G03', 'What is the typical input impedance of an op-amp?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1324, 'E7G04', 'What is meant by the "op-amp input offset voltage"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1325, 'E7G05', 'How can unwanted ringing and audio instability be prevented in an op-amp RC audio filter circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1326, 'E7G06', 'What is the gain-bandwidth of an operational amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1327, 'E7G07', 'What magnitude of voltage gain can be expected from the circuit in Figure E7-3 when R1 is 10 ohms and RF is 470 ohms?<p><img src=''e7_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1328, 'E7G08', 'How does the gain of an ideal operational amplifier vary with frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1329, 'E7G09', 'What will be the output voltage of the circuit shown in Figure E7-3 if R1 is 1000 ohms, RF is 10,000 ohms, and 0.23 volts DC is applied to the input?<p><img src=''e7_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1330, 'E7G10', 'What absolute voltage gain can be expected from the circuit in Figure E7-3 when R1 is 1800 ohms and RF is 68 kilohms?<p><img src=''e7_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1331, 'E7G11', 'What absolute voltage gain can be expected from the circuit in Figure E7-3 when R1 is 3300 ohms and RF is 47 kilohms?<p><img src=''e7_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1332, 'E7G12', 'What is an operational amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1333, 'E7H01', 'What are three oscillator circuits used in amateur radio equipment?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1334, 'E7H02', 'What is a microphonic?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1335, 'E7H03', 'How is positive feedback supplied in a Hartley oscillator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1336, 'E7H04', 'How is positive feedback supplied in a Colpitts oscillator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1337, 'E7H05', 'How is positive feedback supplied in a Pierce oscillator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1338, 'E7H06', 'Which of the following oscillator circuits are commonly used in VFOs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1339, 'E7H07', 'How can an oscillator''s microphonic responses be reduced?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1340, 'E7H08', 'Which of the following components can be used to reduce thermal drift in crystal oscillators?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1341, 'E7H09', 'What type of frequency synthesizer circuit uses a phase accumulator, lookup table, digital to analog converter, and a low-pass anti-alias filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1342, 'E7H10', 'What information is contained in the lookup table of a direct digital synthesizer (DDS)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1343, 'E7H11', 'What are the major spectral impurity components of direct digital synthesizers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1344, 'E7H12', 'Which of the following must be done to ensure that a crystal oscillator provides the frequency specified by the crystal manufacturer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1345, 'E7H13', 'Which of the following is a technique for providing highly accurate and stable oscillators needed for microwave transmission and reception?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1346, 'E7H14', 'What is a phase-locked loop circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1347, 'E7H15', 'Which of these functions can be performed by a phase-locked loop?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1348, 'E8A01', 'What is the name of the process that shows that a square wave is made up of a sine wave plus all its odd harmonics?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1349, 'E8A02', 'Which of the following is a type of analog-to-digital conversion?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1350, 'E8A03', 'What type of wave does a Fourier analysis show to be made up of sine waves of a given fundamental frequency plus all its harmonics?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1351, 'E8A04', 'What is "dither" with respect to analog-to-digital converters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1352, 'E8A05', 'What of the following instruments would be the most accurate for measuring the RMS voltage of a complex waveform?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1353, 'E8A06', 'What is the approximate ratio of PEP-to-average power in a typical single-sideband phone signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1354, 'E8A07', 'What determines the PEP-to-average power ratio of a single-sideband phone signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1355, 'E8A08', 'Why would a direct or flash conversion analog-to-digital converter be useful for a software defined radio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1356, 'E8A09', 'How many different input levels can be encoded by an analog-to-digital converter with 8-bit resolution?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1357, 'E8A10', 'What is the purpose of a low-pass filter used in conjunction with a digital-to-analog converter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1358, 'E8A11', 'Which of the following is a measure of the quality of an analog-to-digital converter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1359, 'E8B01', 'What is the modulation index of an FM signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1360, 'E8B02', 'How does the modulation index of a phase-modulated emission vary with RF carrier frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1361, 'E8B03', 'What is the modulation index of an FM-phone signal having a maximum frequency deviation of 3000 Hz either side of the carrier frequency when the modulating frequency is 1000 Hz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1362, 'E8B04', 'What is the modulation index of an FM-phone signal having a maximum carrier deviation of plus or minus 6 kHz when modulated with a 2 kHz modulating frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1363, 'E8B05', 'What is the deviation ratio of an FM-phone signal having a maximum frequency swing of plus-or-minus 5 kHz when the maximum modulation frequency is 3 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1364, 'E8B06', 'What is the deviation ratio of an FM-phone signal having a maximum frequency swing of plus or minus 7.5 kHz when the maximum modulation frequency is 3.5 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1365, 'E8B07', 'Orthogonal Frequency Division Multiplexing is a technique used for which type of amateur communication?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1366, 'E8B08', 'What describes Orthogonal Frequency Division Multiplexing?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1367, 'E8B09', 'What is deviation ratio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1368, 'E8B10', 'What is frequency division multiplexing?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1369, 'E8B11', 'What is digital time division multiplexing?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1370, 'E8C01', 'How is Forward Error Correction implemented?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1371, 'E8C02', 'What is the definition of symbol rate in a digital transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1372, 'E8C03', 'Why should phase-shifting of a PSK signal be done at the zero crossing of the RF signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1373, 'E8C04', 'What technique minimizes the bandwidth of a PSK31 signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1374, 'E8C05', 'What is the approximate bandwidth of a 13-WPM International Morse Code transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1375, 'E8C06', 'What is the bandwidth of a 170-hertz shift, 300-baud ASCII transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1376, 'E8C07', 'What is the bandwidth of a 4800-Hz frequency shift, 9600-baud ASCII FM transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1377, 'E8C08', 'How does ARQ accomplish error correction?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1378, 'E8C09', 'Which digital code allows only one bit to change between sequential code values?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1379, 'E8C10', 'How may symbol rate be increased without increasing bandwidth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1380, 'E8C11', 'What is the relationship between symbol rate and baud?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1381, 'E8C12', 'What factors affect the bandwidth of a transmitted CW signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1382, 'E8D01', 'Why are received spread spectrum signals resistant to interference?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1383, 'E8D02', 'What spread spectrum communications technique uses a high-speed binary bit stream to shift the phase of an RF carrier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1384, 'E8D03', 'How does the spread spectrum technique of frequency hopping work?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1385, 'E8D04', 'What is the primary effect of extremely short rise or fall time on a CW signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1386, 'E8D05', 'What is the most common method of reducing key clicks?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1387, 'E8D06', 'What is the advantage of including parity bits in ASCII characters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1388, 'E8D07', 'What is a common cause of overmodulation of AFSK signals?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1389, 'E8D08', 'What parameter evaluates distortion of an AFSK signal caused by excessive input audio levels?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1390, 'E8D09', 'What is considered an acceptable maximum IMD level for an idling PSK signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1391, 'E8D10', 'What are some of the differences between the Baudot digital code and ASCII?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1392, 'E8D11', 'What is one advantage of using ASCII code for data communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1393, 'E9A01', 'What is an isotropic antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1394, 'E9A02', 'What is the effective radiated power relative to a dipole of a repeater station with 150 watts transmitter power output, 2 dB feed line loss, 2.2 dB duplexer loss, and 7 dBd antenna gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1395, 'E9A03', 'What is the radiation resistance of an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1396, 'E9A04', 'Which of the following factors affect the feed point impedance of an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1397, 'E9A05', 'What is included in the total resistance of an antenna system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1398, 'E9A06', 'What is the effective radiated power relative to a dipole of a repeater station with 200 watts transmitter power output, 4 dB feed line loss, 3.2 dB duplexer loss, 0.8 dB circulator loss, and 10 dBd antenna gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1399, 'E9A07', 'What is the effective isotropic radiated power of a repeater station with 200 watts transmitter power output, 2 dB feed line loss, 2.8 dB duplexer loss, 1.2 dB circulator loss, and 7 dBi antenna gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1400, 'E9A08', 'What is antenna bandwidth?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1401, 'E9A09', 'What is antenna efficiency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1402, 'E9A10', 'Which of the following improves the efficiency of a ground-mounted quarter-wave vertical antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1403, 'E9A11', 'Which of the following factors determines ground losses for a ground-mounted vertical antenna operating in the 3 MHz to 30 MHz range?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1404, 'E9A12', 'How much gain does an antenna have compared to a 1/2-wavelength dipole when it has 6 dB gain over an isotropic antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1405, 'E9A13', 'What term describes station output, taking into account all gains and losses?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1406, 'E9B01', 'In the antenna radiation pattern shown in Figure E9-1, what is the beamwidth?<p><img src=''e9_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1407, 'E9B02', 'In the antenna radiation pattern shown in Figure E9-1, what is the front-to-back ratio?<p><img src=''e9_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1408, 'E9B03', 'In the antenna radiation pattern shown in Figure E9-1, what is the front-to-side ratio?<p><img src=''e9_1.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1409, 'E9B04', 'What is the front-to-back ratio of the radiation pattern shown in Figure E9-2?<p><img src=''e9_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1410, 'E9B05', 'What type of antenna pattern is shown in Figure E9-2?<p><img src=''e9_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1411, 'E9B06', 'What is the elevation angle of peak response in the antenna radiation pattern shown in Figure E9-2?<p><img src=''e9_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1412, 'E9B07', 'How does the total amount of radiation emitted by a directional gain antenna compare with the total amount of radiation emitted from a theoretical isotropic antenna, assuming each is driven by the same amount of power?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1413, 'E9B08', 'What is the far field of an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1414, 'E9B09', 'What type of computer program technique is commonly used for modeling antennas?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1415, 'E9B10', 'What is the principle of a Method of Moments analysis?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1416, 'E9B11', 'What is a disadvantage of decreasing the number of wire segments in an antenna model below 10 segments per half-wavelength?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1417, 'E9C01', 'What is the radiation pattern of two 1/4-wavelength vertical antennas spaced 1/2-wavelength apart and fed 180 degrees out of phase?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1418, 'E9C02', 'What is the radiation pattern of two 1/4 wavelength vertical antennas spaced 1/4 wavelength apart and fed 90 degrees out of phase?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1419, 'E9C03', 'What is the radiation pattern of two 1/4-wavelength vertical antennas spaced 1/2 wavelength apart and fed in phase?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1420, 'E9C04', 'What happens to the radiation pattern of an unterminated long wire antenna as the wire length is increased?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1421, 'E9C05', 'Which of the following is a type of OCFD antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1422, 'E9C06', 'What is the effect of adding a terminating resistor to a rhombic antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1423, 'E9C07', 'What is the approximate feed point impedance at the center of a two-wire folded dipole antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1424, 'E9C08', 'What is a folded dipole antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1425, 'E9C09', 'Which of the following describes a G5RV antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1426, 'E9C10', 'Which of the following describes a Zepp antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1427, 'E9C11', 'How is the far-field elevation pattern of a vertically polarized antenna affected by being mounted over seawater versus soil?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1428, 'E9C12', 'Which of the following describes an Extended Double Zepp antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1429, 'E9C13', 'How does the radiation pattern of a horizontally polarized 3-element beam antenna vary with increasing height above ground?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1430, 'E9C14', 'How does the performance of a horizontally polarized antenna mounted on the side of a hill compare with the same antenna mounted on flat ground?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1431, 'E9D01', 'How much does the gain of an ideal parabolic dish antenna change when the operating frequency is doubled?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1432, 'E9D02', 'How can linearly polarized Yagi antennas be used to produce circular polarization?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1433, 'E9D03', 'Where should a high Q loading coil be placed to minimize losses in a shortened vertical antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1434, 'E9D04', 'Why should an HF mobile antenna loading coil have a high ratio of reactance to resistance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1435, 'E9D05', 'What usually occurs if a Yagi antenna is designed solely for maximum forward gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1436, 'E9D06', 'What happens to the SWR bandwidth when one or more loading coils are used to resonate an electrically short antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1437, 'E9D07', 'What is an advantage of using top loading in a shortened HF vertical antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1438, 'E9D08', 'What happens as the Q of an antenna increases?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1439, 'E9D09', 'What is the function of a loading coil used as part of an HF mobile antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1440, 'E9D10', 'What happens to feed-point impedance at the base of a fixed length HF mobile antenna when operated below its resonant frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1441, 'E9D11', 'Which of the following conductors would be best for minimizing losses in a station''s RF ground system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1442, 'E9D12', 'Which of the following would provide the best RF ground for your station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1443, 'E9E01', 'What system matches a higher-impedance transmission line to a lower-impedance antenna by connecting the line to the driven element in two places spaced a fraction of a wavelength each side of element center?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1444, 'E9E02', 'What is the name of an antenna matching system that matches an unbalanced feed line to an antenna by feeding the driven element both at the center of the element and at a fraction of a wavelength to one side of center?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1445, 'E9E03', 'What is the name of the matching system that uses a section of transmission line connected in parallel with the feed line at or near the feed point?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1446, 'E9E04', 'What is the purpose of the series capacitor in a gamma-type antenna matching network?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1447, 'E9E05', 'How must an antenna''s driven element be tuned to use a hairpin matching system?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1448, 'E9E06', 'Which of these feed line impedances would be suitable for constructing a quarter-wave Q-section for matching a 100-ohm loop to 50-ohm feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1449, 'E9E07', 'What parameter describes the interactions at the load end of a mismatched transmission line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1450, 'E9E08', 'What is a use for a Wilkinson divider?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1451, 'E9E09', 'Which of the following is used to shunt-feed a grounded tower at its base?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1452, 'E9E10', 'Which of these choices is an effective way to match an antenna with a 100-ohm feed point impedance to a 50-ohm coaxial cable feed line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1453, 'E9E11', 'What is the primary purpose of phasing lines when used with an antenna having multiple driven elements?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1454, 'E9F01', 'What is the velocity factor of a transmission line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1455, 'E9F02', 'Which of the following has the biggest effect on the velocity factor of a transmission line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1456, 'E9F03', 'Why is the physical length of a coaxial cable transmission line shorter than its electrical length?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1457, 'E9F04', 'What impedance does a 1/2-wavelength transmission line present to a generator when the line is shorted at the far end?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1458, 'E9F05', 'What is the approximate physical length of a solid polyethylene dielectric coaxial transmission line that is electrically 1/4 wavelength long at 14.1 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1459, 'E9F06', 'What is the approximate physical length of an air-insulated, parallel conductor transmission line that is electrically 1/2 wavelength long at 14.10 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1460, 'E9F07', 'How does ladder line compare to small-diameter coaxial cable such as RG-58 at 50 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1461, 'E9F08', 'Which of the following is a significant difference between foam dielectric coaxial cable and solid dielectric cable, assuming all other parameters are the same?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1462, 'E9F09', 'What is the approximate physical length of a foam polyethylene dielectric coaxial transmission line that is electrically 1/4 wavelength long at 7.2 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1463, 'E9F10', 'What impedance does a 1/8-wavelength transmission line present to a generator when the line is shorted at the far end?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1464, 'E9F11', 'What impedance does a 1/8-wavelength transmission line present to a generator when the line is open at the far end?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1465, 'E9F12', 'What impedance does a 1/4-wavelength transmission line present to a generator when the line is open at the far end?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1466, 'E9F13', 'What impedance does a 1/4-wavelength transmission line present to a generator when the line is shorted at the far end?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1467, 'E9G01', 'Which of the following can be calculated using a Smith chart?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1468, 'E9G02', 'What type of coordinate system is used in a Smith chart?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1469, 'E9G03', 'Which of the following is often determined using a Smith chart?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1470, 'E9G04', 'What are the two families of circles and arcs that make up a Smith chart?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1471, 'E9G05', 'Which of the following is a common use for a Smith chart?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1472, 'E9G06', 'On the Smith chart shown in Figure E9-3, what is the name for the large outer circle on which the reactance arcs terminate?<p><img src=''e9_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1473, 'E9G07', 'On the Smith chart shown in Figure E9-3, what is the only straight line shown?<p><img src=''e9_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1474, 'E9G08', 'What is the process of normalization with regard to a Smith chart?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1475, 'E9G09', 'What third family of circles is often added to a Smith chart during the process of solving problems?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1476, 'E9G10', 'What do the arcs on a Smith chart represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1477, 'E9G11', 'How are the wavelength scales on a Smith chart calibrated?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1478, 'E9H01', 'When constructing a Beverage antenna, which of the following factors should be included in the design to achieve good performance at the desired frequency?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1479, 'E9H02', 'Which is generally true for low band (160 meter and 80 meter) receiving antennas?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1480, 'E9H03', 'What is Receiving Directivity Factor (RDF)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1481, 'E9H04', 'What is an advantage of placing a grounded electrostatic shield around a small loop direction-finding antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1482, 'E9H05', 'What is the main drawback of a small wire-loop antenna for direction finding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1483, 'E9H06', 'What is the triangulation method of direction finding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1484, 'E9H07', 'Why is RF attenuation used when direction-finding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1485, 'E9H08', 'What is the function of a sense antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1486, 'E9H09', 'What is a Pennant antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1487, 'E9H10', 'How can the output voltage of a multiple-turn receiving loop antenna be increased?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1488, 'E9H11', 'What feature of a cardioid pattern antenna makes it useful for direction finding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1489, 'E0A01', 'What is the primary function of an external earth connection or ground rod?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1490, 'E0A02', 'When evaluating RF exposure levels from your station at a neighbor''s home, what must you do?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1491, 'E0A03', 'Over what range of frequencies are the FCC human body RF exposure limits most restrictive?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1492, 'E0A04', 'When evaluating a site with multiple transmitters operating at the same time, the operators and licensees of which transmitters are responsible for mitigating over-exposure situations?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1493, 'E0A05', 'What is one of the potential hazards of operating in the amateur radio microwave bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1494, 'E0A06', 'Why are there separate electric (E) and magnetic (H) field MPE limits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1495, 'E0A07', 'How may dangerous levels of carbon monoxide from an emergency generator be detected?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1496, 'E0A08', 'What does SAR measure?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1497, 'E0A09', 'Which insulating material commonly used as a thermal conductor for some types of electronic devices is extremely toxic if broken or crushed and the particles are accidentally inhaled?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1498, 'E0A10', 'What toxic material may be present in some electronic components such as high voltage capacitors and transformers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1499, 'E0A11', 'Which of the following injuries can result from using high-power UHF or microwave transmitters?', 0, 1, 0, 0, '');

INSERT INTO question VALUES (1500, 'E1A03_OLD', 'With your transceiver displaying the carrier frequency of phone signals, you hear a station calling CQ on 14.349 MHz USB. Is it legal to return the call using upper sideband on the same frequency?', 0, 1, 0, 0, '97.301, 97.305');

INSERT INTO question VALUES (1501, 'E1A07_OLD', 'Which amateur band requires transmission on specific channels rather than on a range of frequencies?', 0, 1, 0, 0, '97.303');

INSERT INTO question VALUES (1502, 'E1A12_OLD', 'With your transceiver displaying the carrier frequency of CW signals, you hear a DX station''s CQ on 3.500 MHz. Is it legal to return the call using CW on the same frequency?', 0, 1, 0, 0, '97.301, 97.305');

INSERT INTO question VALUES (1503, 'E1B02_OLD', 'Which of the following factors might cause the physical location of an amateur station apparatus or antenna structure to be restricted?', 0, 1, 0, 0, '97.13');
INSERT INTO question VALUES (1504, 'E1C01_OLD', 'What is a remotely controlled station?', 0, 1, 0, 0, '97.3');
INSERT INTO question VALUES (1505, 'E1C02_OLD', 'What is meant by automatic control of a station?', 0, 1, 0, 0, '97.3, 97.109');
INSERT INTO question VALUES (1506, 'E1C06_OLD', 'Which of the following statements concerning remotely controlled amateur stations is true?', 0, 1, 0, 0, '97.109');
INSERT INTO question VALUES (1507, 'E1C07_OLD', 'What is meant by local control?', 0, 1, 0, 0, '97.3');
INSERT INTO question VALUES (1508, 'E1C09_OLD', 'Which of these ranges of frequencies is available for an automatically controlled repeater operating below 30 MHz?', 0, 1, 0, 0, '97.205');	
INSERT INTO question VALUES (1509, 'E1C10_OLD', 'What types of amateur stations may automatically retransmit the radio signals of other amateur stations?', 0, 1, 0, 0, '97.113');
INSERT INTO question VALUES (1510, 'E1D02_OLD', 'What is the amateur satellite service?', 0, 1, 0, 0, '97.3');	
INSERT INTO question VALUES (1511, 'E1D04_OLD', 'What is an Earth station in the amateur satellite service?', 0, 1, 0, 0, '97.3');	
INSERT INTO question VALUES (1512, 'E1D05_OLD', 'What class of licensee is authorized to be the control operator of a space station?', 0, 1, 0, 0, '97.207');	
INSERT INTO question VALUES (1513, 'E1D06_OLD', 'Which of the following is a requirement of a space station?', 0, 1, 0, 0, '97.207');
INSERT INTO question VALUES (1514, 'E1E01_OLD', 'What is the minimum number of qualified VEs required to administer an Element 4 amateur operator license examination?', 0, 1, 0, 0, '97.509');
INSERT INTO question VALUES (1515, 'E1E13_OLD', 'Which of these choices is an acceptable method for monitoring the applicants if a VEC opts to conduct an exam session remotely?', 0, 1, 0, 0, '97.509');
INSERT INTO question VALUES (1516, 'E1F10_OLD', 'What is the maximum permitted transmitter peak envelope power for an amateur station transmitting spread spectrum communications?', 0, 1, 0, 0, '97.313');
INSERT INTO question VALUES (1517, 'E2A02_OLD', 'What is the direction of a descending pass for an amateur satellite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1518, 'E2A03_OLD', 'What is the orbital period of an Earth satellite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1519, 'E2A06_OLD', 'On what band would a satellite receive signals if it were operating in mode U/V?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1520, 'E2A10_OLD', 'Why may the received signal from an amateur satellite exhibit a rapidly repeating fading effect?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1521, 'E2A12_OLD', 'What is one way to predict the location of a satellite at a given time?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1522, 'E2B08_OLD', 'Which of the following is a common method of transmitting accompanying audio with amateur fast-scan television?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1523, 'E2B12_OLD', 'How are analog SSTV images typically transmitted on the HF bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1524, 'E2B13_OLD', 'How many lines are commonly used in each frame of an amateur slow-scan color television picture?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1525, 'E2B17_OLD', 'What is the approximate bandwidth of a slow-scan TV signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1526, 'E2B18_OLD', 'On which of the following frequencies is one likely to find FM ATV transmissions?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1527, 'E2C01_OLD', 'Which of the following is true about contest operating?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1528, 'E2D12_OLD', 'How does JT65 improve EME communications?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1529, 'E2E07_OLD', 'What is the typical bandwidth of a properly modulated MFSK16 signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1530, 'E2E12_OLD', 'Which type of control is used by stations using the Automatic Link Enable (ALE) protocol?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1531, 'E3A06_OLD', 'Which of the following is required for microwave propagation via rain scatter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1532, 'E3A14_OLD', 'From the contiguous 48 states, in which approximate direction should an antenna be pointed to take maximum advantage of aurora propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1533, 'E3A15_OLD', 'What is an electromagnetic wave?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1534, 'E3A16_OLD', 'Which of the following best describes electromagnetic waves traveling in free space?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1535, 'E3B07_OLD', 'Which of the following could account for hearing an echo on the received signal of a distant station?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1536, 'E3B10_OLD', 'What is the cause of gray-line propagation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1537, 'E4A05_OLD', 'What might be an advantage of a digital vs an analog oscilloscope?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1538, 'E4A09_OLD', 'When using a computer’s soundcard input to digitize signals, what is the highest frequency signal that can be digitized without aliasing?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1539, 'E4A12_OLD', 'Which of the following procedures is an important precaution to follow when connecting a spectrum analyzer to a transmitter output?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1540, 'E4A15_OLD', 'What is an advantage of a period-measuring frequency counter over a direct-count type?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1541, 'E4B02_OLD', 'What is an advantage of using a bridge circuit to measure impedance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1542, 'E4B03_OLD', 'If a frequency counter with a specified accuracy of +/- 1.0 ppm reads 146,520,000 Hz, what is the most the actual frequency being measured could differ from the reading?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1543, 'E4B04_OLD', 'If a frequency counter with a specified accuracy of +/- 0.1 ppm reads 146,520,000 Hz, what is the most the actual frequency being measured could differ from the reading?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1544, 'E4B05_OLD', 'If a frequency counter with a specified accuracy of +/- 10 ppm reads 146,520,000 Hz, what is the most the actual frequency being measured could differ from the reading?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1545, 'E4B14_OLD', 'What happens if a dip meter is too tightly coupled to a tuned circuit being checked?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1546, 'E4C10_OLD', 'Which of the following is a desirable amount of selectivity for an amateur RTTY HF receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1547, 'E4C11_OLD', 'Which of the following is a desirable amount of selectivity for an amateur SSB phone receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1548, 'E4C12_OLD', 'What is an undesirable effect of using too wide a filter bandwidth in the IF section of a receiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1549, 'E4C16_OLD', 'Which of the following is caused by missing codes in an SDR receiver’s analog-to-digital converter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1550, 'E4C17_OLD', 'Which of the following has the largest effect on an SDR receiver’s linearity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1551, 'E4D07_OLD', 'Which describes the most significant effect of an off-frequency signal when it is causing cross-modulation interference to a desired signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1552, 'E4D13_OLD', 'Which of the following can cause receiver desensitization?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1553, 'E4E01_OLD', 'Which of the following types of receiver noise can often be reduced by use of a receiver noise blanker?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1554, 'E4E02_OLD', 'Which of the following types of receiver noise can often be reduced with a DSP noise filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1555, 'E4E06_OLD', 'What is a major cause of atmospheric static?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1556, 'E4E07_OLD', 'How can you determine if line noise interference is being generated within your home?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1557, 'E4E08_OLD', 'What type of signal is picked up by electrical wiring near a radio antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1558, 'E4E10_OLD', 'What is a common characteristic of interference caused by a touch controlled electrical device?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1559, 'E4E11_OLD', 'Which is the most likely cause if you are hearing combinations of local AM broadcast signals within one or more of the MF or HF ham bands?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1560, 'E5A04_OLD', 'What is the magnitude of the impedance of a circuit with a resistor, an inductor and a capacitor all in parallel, at resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1561, 'E5A05_OLD', 'What is the magnitude of the current at the input of a series RLC circuit as the frequency goes through resonance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1562, 'E5B02_OLD', 'What is the term for the time it takes for a charged capacitor in an RC circuit to discharge to 36.8% of its initial voltage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1563, 'E5B03_OLD', 'What happens to the phase angle of a reactance when it is converted to a susceptance?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1564, 'E5C04_OLD', 'Which of the following represents a capacitive reactance in polar coordinates?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1565, 'E5C07_OLD', 'What is a vector?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1566, 'E5C10_OLD', 'When using rectangular coordinates to graph the impedance of a circuit, what does the vertical axis represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1567, 'E5C11_OLD', 'What do the two numbers that are used to define a point on a graph using rectangular coordinates represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1568, 'E5C12_OLD', 'If you plot the impedance of a circuit using the rectangular coordinate system and find the impedance point falls on the right side of the graph on the horizontal axis, what do you know about the circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1569, 'E5C17_OLD', 'Which point on Figure E5-2 best represents the impedance of a series circuit consisting of a 300 ohm resistor, a 0.64microhenry inductor and an 85-picofarad capacitor at 24.900 MHz?<p><img src=''e5_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1570, 'E5D05_OLD', 'Which parasitic characteristic increases with conductor length?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1571, 'E5D07_OLD', 'What determines the strength of the magnetic field around a conductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1572, 'E5D08_OLD', 'What type of energy is stored in an electromagnetic or electrostatic field?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1573, 'E6A05_OLD', 'What is the alpha of a bipolar junction transistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1574, 'E6A13_OLD', 'What do the initials CMOS stand for?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1575, 'E6A15_OLD', 'Which semiconductor material contains excess holes in the outer shell of electrons?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1576, 'E6A16_OLD', 'What are the majority charge carriers in N-type semiconductor material?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1577, 'E6A17_OLD', 'What are the names of the three terminals of a field-effect transistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1578, 'E6B03_OLD', 'What special type of diode is capable of both amplification and oscillation?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1579, 'E6B12_OLD', 'What is one common use for PIN diodes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1580, 'E6C12_OLD', 'What is BiCMOS logic?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1581, 'E6C13_OLD', 'Which of the following is an advantage of BiCMOS logic?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1582, 'E6C14_OLD', 'What is the primary advantage of using a Programmable Gate Array (PGA) in a logic circuit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1583, 'E6D01_OLD', 'How many turns will be required to produce a 5-microhenry inductor using a powdered-iron toroidal core that has an inductance index (A L) value of 40 microhenrys/100 turns?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1584, 'E6D07_OLD', 'What is the usable frequency range of inductors that use toroidal cores, assuming a correct selection of core material for the frequency being used?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1585, 'E6D11_OLD', 'How many turns will be required to produce a 1-mH inductor using a core that has an inductance index (A L) value of 523 millihenrys/1000 turns?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1586, 'E6D12_OLD', 'What is the definition of saturation in a ferrite core inductor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1587, 'E6D14_OLD', 'Which type of slug material decreases inductance when inserted into a coil?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1588, 'E6D16_OLD', 'What is the common name for a capacitor connected across a transformer secondary that is used to absorb transient voltage spikes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1589, 'E6E01_OLD', 'Which of the following is true of a charge-coupled device (CCD)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1590, 'E6E07_OLD', 'Which of the following is typically used to construct a MMIC-based microwave amplifier?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1591, 'E6E10_OLD', 'What is the packaging technique in which leadless components are soldered directly to circuit boards?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1592, 'E6E12_OLD', 'Why are high-power RF amplifier ICs and transistors sometimes mounted in ceramic packages?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1593, 'E6F01_OLD', 'What is photoconductivity?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1594, 'E6F13_OLD', 'What is a liquid crystal display (LCD)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1595, 'E6F14_OLD', 'Which of the following is true of LCD displays?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1596, 'E7A12_OLD', 'What type of logic defines "0" as a high voltage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1597, 'E7B13_OLD', 'In Figure E7-2, what is the purpose of R?<p><img src=''e7_2_old.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1598, 'E7C07_OLD', 'What kind of filter would you use to attenuate an interfering carrier signal while receiving an SSB transmission?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1599, 'E7C09_OLD', 'What is a Jones filter as used as part of an HF receiver IF stage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1600, 'E7C11_OLD', 'Which of the following is the common name for a filter network which is equivalent to two L-networks connected back-toback with the two inductors in series and the capacitors in shunt at the input and output?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1601, 'E7C14_OLD', 'Which mode is most affected by non-linear phase response in a receiver IF filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1602, 'E7D11_OLD', 'What circuit element is controlled by a series analog voltage regulator to maintain a constant output voltage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1603, 'E7D14_OLD', 'What is one purpose of a "bleeder" resistor in a conventional unregulated power supply?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1604, 'E7D16_OLD', 'When several electrolytic filter capacitors are connected in series to increase the operating voltage of a power supply filter circuit, why should resistors be connected across each capacitor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1605, 'E7E03_OLD', 'How does an analog phase modulator function?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1606, 'E7F12_OLD', 'What digital process is applied to I and Q signals in order to recover the baseband modulation information?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1607, 'E7F16_OLD', 'How might the sampling rate of an existing digital signal be adjusted by a factor of 3/4?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1608, 'E7F17_OLD', 'What do the letters I and Q in I/Q Modulation represent?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1609, 'E7G06_OLD', 'Which of the following is the most appropriate use of an op-amp active filter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1610, 'E8A02_OLD', 'What type of wave has a rise time significantly faster than its fall time (or vice versa)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1611, 'E8A11_OLD', 'What type of information can be conveyed using digital waveforms?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1612, 'E8A12_OLD', 'What is an advantage of using digital signals instead of analog signals to convey the same information?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1613, 'E8B01_OLD', 'What is the term for the ratio between the frequency deviation of an RF carrier wave and the modulating frequency of its corresponding FM-phone signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1614, 'E8C10_OLD', 'What is an advantage of Gray code in digital communications where symbols are transmitted as multiple bits?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1615, 'E8D06_OLD', 'Which of the following indicates likely overmodulation of an AFSK signal such as PSK or MFSK?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1616, 'E9A02_OLD', 'What antenna has no gain in any direction?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1617, 'E9A03_OLD', 'Why would one need to know the feed point impedance of an antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1618, 'E9A06_OLD', 'How does the beamwidth of an antenna vary as the gain is increased?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1619, 'E9A07_OLD', 'What is meant by antenna gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1620, 'E9A13_OLD', 'How much gain does an antenna have compared to a 1/2-wavelength dipole when it has 12 dB gain over an isotropic antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1621, 'E9A17_OLD', 'What is the effective radiated power of a repeater station with 200 watts transmitter power output, 2 dB feed line loss, 2.8 dB duplexer loss, 1.2 dB circulator loss, and 7 dBi antenna gain?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1622, 'E9B04_OLD', 'What may occur when a directional antenna is operated at different frequencies within the band for which it was designed?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1623, 'E9B08_OLD', 'How can the approximate beam-width in a given plane of a directional antenna be determined?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1624, 'E9B13_OLD', 'What does the abbreviation NEC stand for when applied to antenna modeling programs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1625, 'E9B14_OLD', 'What type of information can be obtained by submitting the details of a proposed new antenna to a modeling program?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1626, 'E9B16_OLD', 'How many elevation lobes appear in the forward direction of the antenna radiation pattern shown in Figure E9-2?<p><img src=''e9_2.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1627, 'E9C05_OLD', 'What is an OCFD antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1628, 'E9C13_OLD', 'What is the main effect of placing a vertical antenna over an imperfect ground?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1629, 'E9D05_OLD', 'What is a disadvantage of using a multiband trapped antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1630, 'E9E06_OLD', 'What is the equivalent lumped-constant network for a hairpin matching system of a 3-element Yagi?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1631, 'E9E08_OLD', 'Which of the following measurements is characteristic of a mismatched transmission line?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1632, 'E9E09_OLD', 'Which of these matching systems is an effective method of connecting a 50 ohm coaxial cable feed line to a grounded tower so it can be used as a vertical antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1633, 'E9E11_OLD', 'What is an effective way of matching a feed line to a VHF or UHF antenna when the impedances of both the antenna and feed line are unknown?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1634, 'E9F04_OLD', 'What is the typical velocity factor for a coaxial cable with solid polyethylene dielectric?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1635, 'E9F08_OLD', 'What is the term for the ratio of the actual speed at which a signal travels through a transmission line to the speed of light in a vacuum?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1636, 'E9F09_OLD', 'What is the approximate physical length of a solid polyethylene dielectric coaxial transmission line that is electrically onequarter wavelength long at 7.2 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1637, 'E9F15_OLD', 'What impedance does a 1/2 wavelength transmission line present to a generator when the line is open at the far end?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1638, 'E9G05_OLD', 'What type of chart is shown in Figure E9-3?<p><img src=''e9_3.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1639, 'E9H04_OLD', 'What is an advantage of using a shielded loop antenna for direction finding?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1640, 'E9H09_OLD', 'Which of the following describes the construction of a receiving loop antenna?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1641, 'E0A03_OLD', 'Which of the following would be a practical way to estimate whether the RF fields produced by an amateur radio station are within permissible MPE limits?', 0, 1, 0, 0, '');

INSERT INTO answer VALUES (3, 1, 0, 'Advancing skills in the technical and communication phases of the radio art', ' ');
INSERT INTO answer VALUES (1, 1, 1, 'Providing personal radio communications for as many citizens as possible', ' ');
INSERT INTO answer VALUES (2, 1, 2, 'Providing communications for international non-profit organizations', ' ');
INSERT INTO answer VALUES (4, 1, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (7, 2, 0, 'The FCC', ' ');
INSERT INTO answer VALUES (5, 2, 1, 'FEMA', ' ');
INSERT INTO answer VALUES (6, 2, 2, 'Homeland Security', ' ');
INSERT INTO answer VALUES (8, 2, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (12, 3, 0, 'It is encouraged', ' ');
INSERT INTO answer VALUES (9, 3, 1, 'It is required when transmitting emergency messages', ' ');
INSERT INTO answer VALUES (10, 3, 2, 'It is prohibited', ' ');
INSERT INTO answer VALUES (11, 3, 3, 'It is required when in contact with foreign stations', ' ');
INSERT INTO answer VALUES (13, 4, 0, 'One', ' ');
INSERT INTO answer VALUES (14, 4, 1, 'No more than two', ' ');
INSERT INTO answer VALUES (15, 4, 2, 'One for each band on which the person plans to operate', ' ');
INSERT INTO answer VALUES (16, 4, 3, 'One for each permanent station location from which the person plans to operate', ' ');
INSERT INTO answer VALUES (19, 5, 0, 'The control operator''s operator/primary station license must appear in the FCC ULS consolidated licensee database', ' ');
INSERT INTO answer VALUES (17, 5, 1, 'A printed operator/primary station license issued by the FCC must be displayed at the transmitter site', ' ');
INSERT INTO answer VALUES (18, 5, 2, 'The control operator must have an operator/primary station license in his or her possession when in control of a transmitter', ' ');
INSERT INTO answer VALUES (20, 5, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (23, 6, 0, 'An amateur station transmitting communications for the purposes of observing propagation or related experimental activities', ' ');
INSERT INTO answer VALUES (21, 6, 1, 'A government transmitter marking the amateur radio band edges', ' ');
INSERT INTO answer VALUES (22, 6, 2, 'A bulletin sent by the FCC to announce a national emergency', ' ');
INSERT INTO answer VALUES (24, 6, 3, 'A continuous transmission of weather information authorized in the amateur bands by the National Weather Service', ' ');
INSERT INTO answer VALUES (27, 7, 0, 'An amateur station located more than 50 km above the Earth''s surface', ' ');
INSERT INTO answer VALUES (25, 7, 1, 'Any satellite orbiting the earth', ' ');
INSERT INTO answer VALUES (26, 7, 2, 'A manned satellite orbiting the earth', ' ');
INSERT INTO answer VALUES (28, 7, 3, 'An amateur station using amateur radio satellites for relay of signals', ' ');
INSERT INTO answer VALUES (30, 8, 0, 'Volunteer Frequency Coordinator recognized by local amateurs', ' ');
INSERT INTO answer VALUES (29, 8, 1, 'Frequency Spectrum Manager appointed by the FCC', ' ');
INSERT INTO answer VALUES (31, 8, 2, 'FCC Regional Field Office', ' ');
INSERT INTO answer VALUES (32, 8, 3, 'International Telecommunications Union', ' ');
INSERT INTO answer VALUES (35, 9, 0, 'Amateur operators in a local or regional area whose stations are eligible to be repeater or auxiliary stations', ' ');
INSERT INTO answer VALUES (33, 9, 1, 'The FCC Office of Spectrum Management and Coordination Policy', ' ');
INSERT INTO answer VALUES (34, 9, 2, 'The local chapter of the Office of National Council of Independent Frequency Coordinators', ' ');
INSERT INTO answer VALUES (36, 9, 3, 'FCC Regional Field Office', ' ');
INSERT INTO answer VALUES (40, 10, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (37, 10, 1, 'A radio service using amateur frequencies for emergency management or civil defense communications', ' ');
INSERT INTO answer VALUES (38, 10, 2, 'A radio service using amateur stations for emergency management or civil defense communications', ' ');
INSERT INTO answer VALUES (39, 10, 3, 'An emergency service using amateur operators certified by a civil defense organization as being enrolled in that organization', ' ');
INSERT INTO answer VALUES (42, 11, 0, 'At no time', ' ');
INSERT INTO answer VALUES (41, 11, 1, 'To stop another amateur station which is breaking the FCC rules', ' ');
INSERT INTO answer VALUES (43, 11, 2, 'When making short test transmissions', ' ');
INSERT INTO answer VALUES (44, 11, 3, 'At any time, stations in the Amateur Radio Service are not protected from willful interference', ' ');
INSERT INTO answer VALUES (46, 12, 0, 'A United Nations agency for information and communication technology issues', ' ');
INSERT INTO answer VALUES (45, 12, 1, 'An agency of the United States Department of Telecommunications Management', ' ');
INSERT INTO answer VALUES (47, 12, 2, 'An independent frequency coordination agency', ' ');
INSERT INTO answer VALUES (48, 12, 3, 'A department of the FCC', ' ');
INSERT INTO answer VALUES (50, 13, 0, 'Any amateur holding a Technician or higher-class license', ' ');
INSERT INTO answer VALUES (49, 13, 1, 'Only members of amateur radio clubs at NASA facilities', ' ');
INSERT INTO answer VALUES (51, 13, 2, 'Only the astronaut''s family members who are hams', ' ');
INSERT INTO answer VALUES (52, 13, 3, 'Contacts with the ISS are not permitted on amateur radio frequencies', ' ');
INSERT INTO answer VALUES (54, 14, 0, '52.525 MHz', ' ');
INSERT INTO answer VALUES (53, 14, 1, '49.00 MHz', ' ');
INSERT INTO answer VALUES (55, 14, 2, '28.50 MHz', ' ');
INSERT INTO answer VALUES (56, 14, 3, '222.15 MHz', ' ');
INSERT INTO answer VALUES (57, 15, 0, '2 meter band', ' ');
INSERT INTO answer VALUES (58, 15, 1, '20 meter band', ' ');
INSERT INTO answer VALUES (59, 15, 2, '14 meter band', ' ');
INSERT INTO answer VALUES (60, 15, 3, '6 meter band', ' ');
INSERT INTO answer VALUES (62, 16, 0, 'Fixed digital message forwarding systems only', ' ');
INSERT INTO answer VALUES (61, 16, 1, 'Spread spectrum only', ' ');
INSERT INTO answer VALUES (63, 16, 2, 'Emergency traffic only', ' ');
INSERT INTO answer VALUES (64, 16, 3, 'Fast-scan television only', ' ');
INSERT INTO answer VALUES (66, 17, 0, '10 meter band only', ' ');
INSERT INTO answer VALUES (65, 17, 1, 'None', ' ');
INSERT INTO answer VALUES (67, 17, 2, '80 meter, 40 meter, 15 meter and 10 meter bands', ' ');
INSERT INTO answer VALUES (68, 17, 3, '30 meter band only', ' ');
INSERT INTO answer VALUES (69, 18, 0, '50.0 MHz to 50.1 MHz and 144.0 MHz to 144.1 MHz', ' ');
INSERT INTO answer VALUES (70, 18, 1, '219 MHz to 220 MHz and 420.0 MHz to 420.1 MHz', ' ');
INSERT INTO answer VALUES (71, 18, 2, '902.0 MHz to 902.1 MHZ', ' ');
INSERT INTO answer VALUES (72, 18, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (73, 19, 0, 'U.S. amateurs may find non-amateur stations in those portions, and must avoid interfering with them', ' ');
INSERT INTO answer VALUES (74, 19, 1, 'U.S. amateurs must give foreign amateur stations priority in those portions', ' ');
INSERT INTO answer VALUES (75, 19, 2, 'International communications are not permitted in those portions', ' ');
INSERT INTO answer VALUES (76, 19, 3, 'Digital transmissions are not permitted in those portions', ' ');
INSERT INTO answer VALUES (80, 20, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (77, 20, 1, 'To allow for calibration error in the transmitter frequency display', ' ');
INSERT INTO answer VALUES (78, 20, 2, 'So that modulation sidebands do not extend beyond the band edge', ' ');
INSERT INTO answer VALUES (79, 20, 3, 'To allow for transmitter frequency drift', ' ');
INSERT INTO answer VALUES (84, 21, 0, '10 meter band only', ' ');
INSERT INTO answer VALUES (81, 21, 1, '10 meter, 12 meter, 17 meter, and 40 meter bands', ' ');
INSERT INTO answer VALUES (82, 21, 2, '10 meter, 15 meter, 40 meter, and 80 meter bands', ' ');
INSERT INTO answer VALUES (83, 21, 3, '30 meter band only', ' ');
INSERT INTO answer VALUES (85, 22, 0, '200 watts', ' ');
INSERT INTO answer VALUES (86, 22, 1, '100 watts', ' ');
INSERT INTO answer VALUES (87, 22, 2, '50 watts', ' ');
INSERT INTO answer VALUES (88, 22, 3, '10 watts', ' ');
INSERT INTO answer VALUES (92, 23, 0, '1500 watts', ' ');
INSERT INTO answer VALUES (89, 23, 1, '50 watts', ' ');
INSERT INTO answer VALUES (90, 23, 2, '100 watts', ' ');
INSERT INTO answer VALUES (91, 23, 3, '500 watts', ' ');
INSERT INTO answer VALUES (96, 24, 0, 'Technician, General, Amateur Extra', ' ');
INSERT INTO answer VALUES (93, 24, 1, 'Novice, Technician, General, Advanced', ' ');
INSERT INTO answer VALUES (94, 24, 2, 'Technician, Technician Plus, General, Advanced', ' ');
INSERT INTO answer VALUES (95, 24, 3, 'Novice, Technician Plus, General, Advanced', ' ');
INSERT INTO answer VALUES (100, 25, 0, 'Any licensed amateur', ' ');
INSERT INTO answer VALUES (97, 25, 1, 'Only a licensed amateur with a General or Amateur Extra class license', ' ');
INSERT INTO answer VALUES (98, 25, 2, 'Only a licensed amateur with an Amateur Extra class license', ' ');
INSERT INTO answer VALUES (99, 25, 3, 'Only a licensed amateur who has been licensed continuously for more than 10 years', ' ');
INSERT INTO answer VALUES (101, 26, 0, 'Communications incidental to the purposes of the Amateur Radio Service and remarks of a personal character', ' ');
INSERT INTO answer VALUES (102, 26, 1, 'Communications incidental to conducting business or remarks of a personal nature', ' ');
INSERT INTO answer VALUES (103, 26, 2, 'Only communications incidental to contest exchanges, all other communications are prohibited', ' ');
INSERT INTO answer VALUES (104, 26, 3, 'Any communications that would be permitted by an international broadcast station', ' ');
INSERT INTO answer VALUES (105, 27, 0, 'When the foreign country authorizes it', ' ');
INSERT INTO answer VALUES (106, 27, 1, 'When there is a mutual agreement allowing third party communications', ' ');
INSERT INTO answer VALUES (107, 27, 2, 'When authorization permits amateur communications in a foreign language', ' ');
INSERT INTO answer VALUES (108, 27, 3, 'When you are communicating with non-licensed individuals in another country', ' ');
INSERT INTO answer VALUES (109, 28, 0, 'K1XXX', ' ');
INSERT INTO answer VALUES (110, 28, 1, 'KA1X', ' ');
INSERT INTO answer VALUES (111, 28, 2, 'W1XX', ' ');
INSERT INTO answer VALUES (112, 28, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (116, 29, 0, 'From any vessel or craft located in international waters and documented or registered in the United States', ' ');
INSERT INTO answer VALUES (113, 29, 1, 'From within any country that belongs to the International Telecommunications Union', ' ');
INSERT INTO answer VALUES (114, 29, 2, 'From within any country that is a member of the United Nations', ' ');
INSERT INTO answer VALUES (115, 29, 3, 'From anywhere within International Telecommunications Union (ITU) Regions 2 and 3', ' ');
INSERT INTO answer VALUES (118, 30, 0, 'Revocation of the station license or suspension of the operator license', ' ');
INSERT INTO answer VALUES (117, 30, 1, 'Fine or imprisonment', ' ');
INSERT INTO answer VALUES (119, 30, 2, 'Require the licensee to be re-examined', ' ');
INSERT INTO answer VALUES (120, 30, 3, 'A reduction of one rank in operator class', ' ');
INSERT INTO answer VALUES (123, 31, 0, 'Ten years', ' ');
INSERT INTO answer VALUES (121, 31, 1, 'Five years', ' ');
INSERT INTO answer VALUES (122, 31, 2, 'Life', ' ');
INSERT INTO answer VALUES (124, 31, 3, 'Twenty years', ' ');
INSERT INTO answer VALUES (125, 32, 0, 'Two years', ' ');
INSERT INTO answer VALUES (126, 32, 1, 'Three years', ' ');
INSERT INTO answer VALUES (127, 32, 2, 'Five years', ' ');
INSERT INTO answer VALUES (128, 32, 3, 'Ten years', ' ');
INSERT INTO answer VALUES (131, 33, 0, 'As soon as your operator/station license grant appears in the FCC’s license database', ' ');
INSERT INTO answer VALUES (129, 33, 1, 'Immediately', ' ');
INSERT INTO answer VALUES (130, 33, 2, '30 days after the test date', ' ');
INSERT INTO answer VALUES (132, 33, 3, 'You must wait until you receive your license in the mail from the FCC', ' ');
INSERT INTO answer VALUES (133, 34, 0, 'No, transmitting is not allowed until the FCC license database shows that the license has been renewed', ' ');
INSERT INTO answer VALUES (134, 34, 1, 'Yes, but only if you identify using the suffix GP', ' ');
INSERT INTO answer VALUES (135, 34, 2, 'Yes, but only during authorized nets', ' ');
INSERT INTO answer VALUES (136, 34, 3, 'Yes, for up to two years', ' ');
INSERT INTO answer VALUES (137, 35, 0, 'Any country whose administration has notified the International Telecommunications Union (ITU) that it objects to such communications', ' ');
INSERT INTO answer VALUES (138, 35, 1, 'Any country whose administration has notified the American Radio Relay League (ARRL) that it objects to such communications', ' ');
INSERT INTO answer VALUES (139, 35, 2, 'Any country engaged in hostilities with another country', ' ');
INSERT INTO answer VALUES (140, 35, 3, 'Any country in violation of the War Powers Act of 1934', ' ');
INSERT INTO answer VALUES (142, 36, 0, 'When transmitting code practice, information bulletins, or transmissions necessary to provide emergency communications', ' ');
INSERT INTO answer VALUES (141, 36, 1, 'Under no circumstances', ' ');
INSERT INTO answer VALUES (143, 36, 2, 'At any time, as long as no music is transmitted', ' ');
INSERT INTO answer VALUES (144, 36, 3, 'At any time, as long as the material being transmitted did not originate from a commercial broadcast station', ' ');
INSERT INTO answer VALUES (147, 37, 0, 'Only when transmitting control commands to space stations or radio control craft', ' ');
INSERT INTO answer VALUES (145, 37, 1, 'Only during contests', ' ');
INSERT INTO answer VALUES (146, 37, 2, 'Only when operating mobile', ' ');
INSERT INTO answer VALUES (148, 37, 3, 'Only when frequencies above 1280 MHz are used', ' ');
INSERT INTO answer VALUES (149, 38, 0, 'When incidental to an authorized retransmission of manned spacecraft communications', ' ');
INSERT INTO answer VALUES (150, 38, 1, 'When the music produces no spurious emissions', ' ');
INSERT INTO answer VALUES (151, 38, 2, 'When the purpose is to interfere with an illegal transmission', ' ');
INSERT INTO answer VALUES (152, 38, 3, 'When the music is transmitted above 1280 MHz', ' ');
INSERT INTO answer VALUES (153, 39, 0, 'When the equipment is normally used in an amateur station and such activity is not conducted on a regular basis', ' ');
INSERT INTO answer VALUES (154, 39, 1, 'When the asking price is $100.00 or less', ' ');
INSERT INTO answer VALUES (155, 39, 2, 'When the asking price is less than its appraised value', ' ');
INSERT INTO answer VALUES (156, 39, 3, 'When the equipment is not the personal property of either the station licensee or the control operator or their close relatives', ' ');
INSERT INTO answer VALUES (158, 40, 0, 'Any such language is prohibited', ' ');
INSERT INTO answer VALUES (157, 40, 1, 'The FCC maintains a list of words that are not permitted to be used on amateur frequencies', ' ');
INSERT INTO answer VALUES (159, 40, 2, 'The ITU maintains a list of words that are not permitted to be used on amateur frequencies', ' ');
INSERT INTO answer VALUES (160, 40, 3, 'There is no such prohibition', ' ');
INSERT INTO answer VALUES (162, 41, 0, 'Repeater, auxiliary, or space stations', ' ');
INSERT INTO answer VALUES (161, 41, 1, 'Auxiliary, beacon, or Earth stations', ' ');
INSERT INTO answer VALUES (163, 41, 2, 'Beacon, repeater, or space stations', ' ');
INSERT INTO answer VALUES (164, 41, 3, 'Earth, repeater, or space stations', ' ');
INSERT INTO answer VALUES (166, 42, 0, 'When the communication is incidental to classroom instruction at an educational institution', ' ');
INSERT INTO answer VALUES (165, 42, 1, 'When the communication is related to the sale of amateur equipment by the control operator''s employer', ' ');
INSERT INTO answer VALUES (167, 42, 2, 'When the communication is made to obtain emergency information for a local broadcast station', ' ');
INSERT INTO answer VALUES (168, 42, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (169, 43, 0, 'Only where such communications directly relate to the immediate safety of human life or protection of property', ' ');
INSERT INTO answer VALUES (170, 43, 1, 'Only when broadcasting communications to or from the space shuttle', ' ');
INSERT INTO answer VALUES (171, 43, 2, 'Only where noncommercial programming is gathered and supplied exclusively to the National Public Radio network', ' ');
INSERT INTO answer VALUES (172, 43, 3, 'Only when using amateur repeaters linked to the internet', ' ');
INSERT INTO answer VALUES (176, 44, 0, 'Transmissions intended for reception by the general public', ' ');
INSERT INTO answer VALUES (173, 44, 1, 'Two-way transmissions by amateur stations', ' ');
INSERT INTO answer VALUES (174, 44, 2, 'Transmission of music', ' ');
INSERT INTO answer VALUES (175, 44, 3, 'Transmission of messages directed only to amateur operators', ' ');
INSERT INTO answer VALUES (180, 45, 0, 'When transmitting signals to control model craft', ' ');
INSERT INTO answer VALUES (177, 45, 1, 'When the transmissions are of a brief nature to make station adjustments', ' ');
INSERT INTO answer VALUES (178, 45, 2, 'When the transmissions are unmodulated', ' ');
INSERT INTO answer VALUES (179, 45, 3, 'When the transmitted power level is below 1 watt', ' ');
INSERT INTO answer VALUES (184, 46, 0, 'Never', ' ');
INSERT INTO answer VALUES (181, 46, 1, 'When using automatic control, such as in the case of a repeater', ' ');
INSERT INTO answer VALUES (182, 46, 2, 'When the station licensee is away and another licensed amateur is using the station', ' ');
INSERT INTO answer VALUES (183, 46, 3, 'When the transmitting station is an auxiliary station', ' ');
INSERT INTO answer VALUES (188, 47, 0, 'Any amateur whose license privileges allow them to transmit on the satellite uplink frequency', ' ');
INSERT INTO answer VALUES (185, 47, 1, 'Only an Amateur Extra Class operator', ' ');
INSERT INTO answer VALUES (186, 47, 2, 'A General class or higher licensee who has a satellite operator certification', ' ');
INSERT INTO answer VALUES (187, 47, 3, 'Only an Amateur Extra Class operator who is also an AMSAT member', ' ');
INSERT INTO answer VALUES (189, 48, 0, 'The station licensee', ' ');
INSERT INTO answer VALUES (190, 48, 1, 'The FCC', ' ');
INSERT INTO answer VALUES (191, 48, 2, 'The frequency coordinator', ' ');
INSERT INTO answer VALUES (192, 48, 3, 'The ITU', ' ');
INSERT INTO answer VALUES (196, 49, 0, 'The class of operator license held by the control operator', ' ');
INSERT INTO answer VALUES (193, 49, 1, 'The frequency authorized by the frequency coordinator', ' ');
INSERT INTO answer VALUES (194, 49, 2, 'The frequencies printed on the license grant', ' ');
INSERT INTO answer VALUES (195, 49, 3, 'The highest class of operator license held by anyone on the premises', ' ');
INSERT INTO answer VALUES (199, 50, 0, 'The location at which the control operator function is performed', ' ');
INSERT INTO answer VALUES (197, 50, 1, 'The location of the station’s transmitting antenna', ' ');
INSERT INTO answer VALUES (198, 50, 2, 'The location of the station transmitting apparatus', ' ');
INSERT INTO answer VALUES (200, 50, 3, 'The mailing address of the station licensee', ' ');
INSERT INTO answer VALUES (201, 51, 0, 'At no time', ' ');
INSERT INTO answer VALUES (202, 51, 1, 'When operating a special event station', ' ');
INSERT INTO answer VALUES (203, 51, 2, 'As part of a multi-operator contest team', ' ');
INSERT INTO answer VALUES (204, 51, 3, 'When using a club station whose trustee is an Amateur Extra class operator licensee', ' ');
INSERT INTO answer VALUES (208, 52, 0, 'The control operator and the station licensee are equally responsible', ' ');
INSERT INTO answer VALUES (205, 52, 1, 'All licensed amateurs who are present at the operation', ' ');
INSERT INTO answer VALUES (206, 52, 2, 'Only the station licensee', ' ');
INSERT INTO answer VALUES (207, 52, 3, 'Only the control operator', ' ');
INSERT INTO answer VALUES (209, 53, 0, 'Repeater operation', ' ');
INSERT INTO answer VALUES (210, 53, 1, 'Controlling the station over the internet', ' ');
INSERT INTO answer VALUES (211, 53, 2, 'Using a computer or other device to send CW automatically', ' ');
INSERT INTO answer VALUES (212, 53, 3, 'Using a computer or other device to identify automatically', ' ');
INSERT INTO answer VALUES (216, 54, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (213, 54, 1, 'The control operator must be at the control point', ' ');
INSERT INTO answer VALUES (214, 54, 2, 'A control operator is required at all times', ' ');
INSERT INTO answer VALUES (215, 54, 3, 'The control operator indirectly manipulates the controls', ' ');
INSERT INTO answer VALUES (218, 55, 0, 'Operating the station over the internet', ' ');
INSERT INTO answer VALUES (217, 55, 1, 'Repeater operation', ' ');
INSERT INTO answer VALUES (219, 55, 2, 'Controlling a model aircraft, boat, or car by amateur radio', ' ');
INSERT INTO answer VALUES (220, 55, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (224, 56, 0, 'The station licensee', ' ');
INSERT INTO answer VALUES (221, 56, 1, 'The station custodian', ' ');
INSERT INTO answer VALUES (222, 56, 2, 'The third-party participant', ' ');
INSERT INTO answer VALUES (223, 56, 3, 'The person operating the station equipment', ' ');
INSERT INTO answer VALUES (226, 57, 0, 'At any time upon request by an FCC representative', ' ');
INSERT INTO answer VALUES (225, 57, 1, 'At any time ten days after notification by the FCC of such an inspection', ' ');
INSERT INTO answer VALUES (227, 57, 2, 'Only after failing to comply with an FCC notice of violation', ' ');
INSERT INTO answer VALUES (228, 57, 3, 'Only when presented with a valid warrant by an FCC official or government agent', ' ');
INSERT INTO answer VALUES (231, 58, 0, 'At the end of each communication and every ten minutes during a communication', ' ');
INSERT INTO answer VALUES (229, 58, 1, 'Never, the tactical call is sufficient', ' ');
INSERT INTO answer VALUES (230, 58, 2, 'Once during every hour', ' ');
INSERT INTO answer VALUES (232, 58, 3, 'At the end of every transmission', ' ');
INSERT INTO answer VALUES (236, 59, 0, 'At least every 10 minutes during and at the end of a communication', ' ');
INSERT INTO answer VALUES (233, 59, 1, 'At the beginning of each contact, and every 10 minutes thereafter', ' ');
INSERT INTO answer VALUES (234, 59, 2, 'At least once during each transmission', ' ');
INSERT INTO answer VALUES (235, 59, 3, 'At least every 15 minutes during and at the end of a communication', ' ');
INSERT INTO answer VALUES (239, 60, 0, 'The English language', ' ');
INSERT INTO answer VALUES (237, 60, 1, 'Any language recognized by the United Nations', ' ');
INSERT INTO answer VALUES (238, 60, 2, 'Any language recognized by the ITU', ' ');
INSERT INTO answer VALUES (240, 60, 3, 'English, French, or Spanish', ' ');
INSERT INTO answer VALUES (242, 61, 0, 'Send the call sign using a CW or phone emission', ' ');
INSERT INTO answer VALUES (241, 61, 1, 'Send the call sign followed by the indicator RPT', ' ');
INSERT INTO answer VALUES (243, 61, 2, 'Send the call sign followed by the indicator R', ' ');
INSERT INTO answer VALUES (244, 61, 3, 'Send the call sign using only a phone emission', ' ');
INSERT INTO answer VALUES (248, 62, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (245, 62, 1, 'KL7CC stroke W3', ' ');
INSERT INTO answer VALUES (246, 62, 2, 'KL7CC slant W3', ' ');
INSERT INTO answer VALUES (247, 62, 3, 'KL7CC slash W3', ' ');
INSERT INTO answer VALUES (250, 63, 0, 'The foreign station must be one with which the U.S. has a third-party agreement', ' ');
INSERT INTO answer VALUES (249, 63, 1, 'The person must be a U.S. citizen', ' ');
INSERT INTO answer VALUES (251, 63, 2, 'The licensed control operator must do the station identification', ' ');
INSERT INTO answer VALUES (252, 63, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (253, 64, 0, 'A message from a control operator to another amateur station control operator on behalf of another person', ' ');
INSERT INTO answer VALUES (254, 64, 1, 'Amateur radio communications where three stations are in communications with one another', ' ');
INSERT INTO answer VALUES (255, 64, 2, 'Operation when the transmitting equipment is licensed to a person other than the control operator', ' ');
INSERT INTO answer VALUES (256, 64, 3, 'Temporary authorization for an unlicensed person to transmit on the amateur bands for technical experiments', ' ');
INSERT INTO answer VALUES (259, 65, 0, 'Repeater station', ' ');
INSERT INTO answer VALUES (257, 65, 1, 'Beacon station', ' ');
INSERT INTO answer VALUES (258, 65, 2, 'Earth station', ' ');
INSERT INTO answer VALUES (260, 65, 3, 'Message forwarding station', ' ');
INSERT INTO answer VALUES (261, 66, 0, 'The control operator of the originating station', ' ');
INSERT INTO answer VALUES (262, 66, 1, 'The control operator of the repeater', ' ');
INSERT INTO answer VALUES (263, 66, 2, 'The owner of the repeater', ' ');
INSERT INTO answer VALUES (264, 66, 3, 'Both the originating station and the repeater owner', ' ');
INSERT INTO answer VALUES (266, 67, 0, 'The club must have at least four members', ' ');
INSERT INTO answer VALUES (265, 67, 1, 'The trustee must have an Amateur Extra class operator license grant', ' ');
INSERT INTO answer VALUES (267, 67, 2, 'The club must be registered with the American Radio Relay League', ' ');
INSERT INTO answer VALUES (268, 67, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (270, 68, 0, 'Plus or minus 600 kHz', ' ');
INSERT INTO answer VALUES (269, 68, 1, 'Plus or minus 5 MHz', ' ');
INSERT INTO answer VALUES (271, 68, 2, 'Plus or minus 500 kHz', ' ');
INSERT INTO answer VALUES (272, 68, 3, 'Plus or minus 1 MHz', ' ');
INSERT INTO answer VALUES (273, 69, 0, '146.520 MHz', ' ');
INSERT INTO answer VALUES (274, 69, 1, '145.000 MHz', ' ');
INSERT INTO answer VALUES (275, 69, 2, '432.100 MHz', ' ');
INSERT INTO answer VALUES (276, 69, 3, '446.000 MHz', ' ');
INSERT INTO answer VALUES (277, 70, 0, 'Plus or minus 5 MHz', ' ');
INSERT INTO answer VALUES (278, 70, 1, 'Plus or minus 600 kHz', ' ');
INSERT INTO answer VALUES (279, 70, 2, 'Plus or minus 500 kHz', ' ');
INSERT INTO answer VALUES (280, 70, 3, 'Plus or minus 1 MHz', ' ');
INSERT INTO answer VALUES (282, 71, 0, 'Say the station''s call sign, then identify with your call sign', ' ');
INSERT INTO answer VALUES (281, 71, 1, 'Say "break, break," then say the station''s call sign', ' ');
INSERT INTO answer VALUES (283, 71, 2, 'Say "CQ" three times, then the other station''s call sign', ' ');
INSERT INTO answer VALUES (284, 71, 3, 'Wait for the station to call CQ, then answer it', ' ');
INSERT INTO answer VALUES (287, 72, 0, 'Transmit the other station’s call sign followed by your call sign', ' ');
INSERT INTO answer VALUES (285, 72, 1, 'Transmit "CQ" followed by the other station’s call sign', ' ');
INSERT INTO answer VALUES (286, 72, 2, 'Transmit your call sign followed by the other station’s call sign', ' ');
INSERT INTO answer VALUES (288, 72, 3, 'Transmit a signal report followed by your call sign', ' ');
INSERT INTO answer VALUES (289, 73, 0, 'Identify the transmitting station', ' ');
INSERT INTO answer VALUES (290, 73, 1, 'Conduct tests only between 10 p.m. and 6 a.m. local time', ' ');
INSERT INTO answer VALUES (291, 73, 2, 'Notify the FCC of the transmissions', ' ');
INSERT INTO answer VALUES (292, 73, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (293, 74, 0, 'The difference between a repeater’s transmit frequency and its receive frequency', ' ');
INSERT INTO answer VALUES (294, 74, 1, 'The repeater has a time delay to prevent interference', ' ');
INSERT INTO answer VALUES (295, 74, 2, 'The repeater station identification is done on a separate frequency', ' ');
INSERT INTO answer VALUES (296, 74, 3, 'The number of simultaneous transmit frequencies used by a repeater', ' ');
INSERT INTO answer VALUES (300, 75, 0, 'Calling any station', ' ');
INSERT INTO answer VALUES (297, 75, 1, 'Call on the quarter hour', ' ');
INSERT INTO answer VALUES (298, 75, 2, 'A new antenna is being tested (no station should answer)', ' ');
INSERT INTO answer VALUES (299, 75, 3, 'Only the called station should transmit', ' ');
INSERT INTO answer VALUES (302, 76, 0, 'Your call sign', ' ');
INSERT INTO answer VALUES (301, 76, 1, 'The words “Hello test” followed by your call sign', ' ');
INSERT INTO answer VALUES (303, 76, 2, 'The repeater call sign followed by your call sign', ' ');
INSERT INTO answer VALUES (304, 76, 3, 'The letters “QSY” followed by your call sign', ' ');
INSERT INTO answer VALUES (305, 77, 0, 'A voluntary guideline for using different modes or activities within an amateur band', ' ');
INSERT INTO answer VALUES (306, 77, 1, 'A mandated list of operating schedules', ' ');
INSERT INTO answer VALUES (307, 77, 2, 'A list of scheduled net frequencies', ' ');
INSERT INTO answer VALUES (308, 77, 3, 'A plan devised by a club to indicate frequency band usage', ' ');
INSERT INTO answer VALUES (311, 78, 0, 'Simplex', ' ');
INSERT INTO answer VALUES (309, 78, 1, 'Full duplex', ' ');
INSERT INTO answer VALUES (310, 78, 2, 'Diplex', ' ');
INSERT INTO answer VALUES (312, 78, 3, 'Multiplex', ' ');
INSERT INTO answer VALUES (316, 79, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (313, 79, 1, 'Listen first to be sure that no one else is using the frequency', ' ');
INSERT INTO answer VALUES (314, 79, 2, 'Ask if the frequency is in use', ' ');
INSERT INTO answer VALUES (315, 79, 3, 'Make sure you are in your assigned band', ' ');
INSERT INTO answer VALUES (319, 80, 0, 'Listen on a repeater’s input frequency', ' ');
INSERT INTO answer VALUES (317, 80, 1, 'Reduce power output', ' ');
INSERT INTO answer VALUES (318, 80, 2, 'Increase power output', ' ');
INSERT INTO answer VALUES (320, 80, 3, 'Listen on a repeater’s output frequency', ' ');
INSERT INTO answer VALUES (324, 81, 0, 'CTCSS', ' ');
INSERT INTO answer VALUES (321, 81, 1, 'Carrier squelch', ' ');
INSERT INTO answer VALUES (322, 81, 2, 'Tone burst', ' ');
INSERT INTO answer VALUES (323, 81, 3, 'DTMF', ' ');
INSERT INTO answer VALUES (326, 82, 0, 'Listen on the repeater input frequency', ' ');
INSERT INTO answer VALUES (325, 82, 1, 'Open the squelch on your radio', ' ');
INSERT INTO answer VALUES (327, 82, 2, 'Listen on the repeater output frequency', ' ');
INSERT INTO answer VALUES (328, 82, 3, 'Increase your transmit power', ' ');
INSERT INTO answer VALUES (332, 83, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (329, 83, 1, 'Improper transceiver offset', ' ');
INSERT INTO answer VALUES (330, 83, 2, 'The repeater may require a proper CTCSS tone from your transceiver', ' ');
INSERT INTO answer VALUES (331, 83, 3, 'The repeater may require a proper DCS tone from your transceiver', ' ');
INSERT INTO answer VALUES (335, 84, 0, 'You are talking too loudly', ' ');
INSERT INTO answer VALUES (333, 84, 1, 'You have the incorrect offset', ' ');
INSERT INTO answer VALUES (334, 84, 2, 'You need to talk louder', ' ');
INSERT INTO answer VALUES (336, 84, 3, 'Your transmit power is too high', ' ');
INSERT INTO answer VALUES (337, 85, 0, 'DTMF', ' ');
INSERT INTO answer VALUES (338, 85, 1, 'CTCSS', ' ');
INSERT INTO answer VALUES (339, 85, 2, 'EchoLink', ' ');
INSERT INTO answer VALUES (340, 85, 3, 'Sub-audible', ' ');
INSERT INTO answer VALUES (343, 86, 0, 'Program your radio with the group’s ID or code', ' ');
INSERT INTO answer VALUES (341, 86, 1, 'Register your radio with the local FCC office', ' ');
INSERT INTO answer VALUES (342, 86, 2, 'Join the repeater owner’s club', ' ');
INSERT INTO answer VALUES (344, 86, 3, 'Sign your call after the courtesy tone', ' ');
INSERT INTO answer VALUES (345, 87, 0, 'Common courtesy should prevail, but no one has absolute right to an amateur frequency', ' ');
INSERT INTO answer VALUES (346, 87, 1, 'Whoever has the strongest signal has priority on the frequency', ' ');
INSERT INTO answer VALUES (347, 87, 2, 'Whoever has been on the frequency the longest has priority on the frequency', ' ');
INSERT INTO answer VALUES (348, 87, 3, 'The station that has the weakest signal has priority on the frequency', ' ');
INSERT INTO answer VALUES (350, 88, 0, 'A way for groups of users to share a channel at different times without being heard by other users on the channel', ' ');
INSERT INTO answer VALUES (349, 88, 1, 'A group of operators sharing common interests', ' ');
INSERT INTO answer VALUES (351, 88, 2, 'A protocol that increases the signal-to-noise ratio when multiple repeaters are linked together', ' ');
INSERT INTO answer VALUES (352, 88, 3, 'A net that meets at a particular time', ' ');
INSERT INTO answer VALUES (353, 89, 0, 'QRM', ' ');
INSERT INTO answer VALUES (354, 89, 1, 'QRN', ' ');
INSERT INTO answer VALUES (355, 89, 2, 'QTH', ' ');
INSERT INTO answer VALUES (356, 89, 3, 'QSB', ' ');
INSERT INTO answer VALUES (358, 90, 0, 'QSY', ' ');
INSERT INTO answer VALUES (357, 90, 1, 'QRU', ' ');
INSERT INTO answer VALUES (359, 90, 2, 'QSL', ' ');
INSERT INTO answer VALUES (360, 90, 3, 'QRZ', ' ');
INSERT INTO answer VALUES (361, 91, 0, 'So that stations within mutual communications range can communicate without tying up a repeater', ' ');
INSERT INTO answer VALUES (362, 91, 1, 'For contest operation', ' ');
INSERT INTO answer VALUES (363, 91, 2, 'For working DX only', ' ');
INSERT INTO answer VALUES (364, 91, 3, 'So that stations with simple transmitters can access the repeater without automated offset', ' ');
INSERT INTO answer VALUES (367, 92, 0, 'In at least some portion of all these bands', ' ');
INSERT INTO answer VALUES (365, 92, 1, 'Only in sub-bands allocated to General class or higher licensees', ' ');
INSERT INTO answer VALUES (366, 92, 2, 'Only on repeaters', ' ');
INSERT INTO answer VALUES (368, 92, 3, 'On any band as long as power is limited to 25 watts', ' ');
INSERT INTO answer VALUES (369, 93, 0, 'A network of repeaters where signals received by one repeater are repeated by all the repeaters', ' ');
INSERT INTO answer VALUES (370, 93, 1, 'A repeater with more than one receiver', ' ');
INSERT INTO answer VALUES (371, 93, 2, 'Multiple repeaters with the same owner', ' ');
INSERT INTO answer VALUES (372, 93, 3, 'A system of repeaters linked by APRS', ' ');
INSERT INTO answer VALUES (376, 94, 0, 'Never, FCC rules always apply', ' ');
INSERT INTO answer VALUES (373, 94, 1, 'When operating a RACES station', ' ');
INSERT INTO answer VALUES (374, 94, 2, 'When operating under special FEMA rules', ' ');
INSERT INTO answer VALUES (375, 94, 3, 'When operating under special ARES rules', ' ');
INSERT INTO answer VALUES (378, 95, 0, 'Net Control Station', ' ');
INSERT INTO answer VALUES (377, 95, 1, 'Nominal Control System', ' ');
INSERT INTO answer VALUES (379, 95, 2, 'National Communications Standard', ' ');
INSERT INTO answer VALUES (380, 95, 3, 'Normal Communications Syntax', ' ');
INSERT INTO answer VALUES (383, 96, 0, 'Spell the words using a standard phonetic alphabet', ' ');
INSERT INTO answer VALUES (381, 96, 1, 'Send the words by voice and Morse code', ' ');
INSERT INTO answer VALUES (382, 96, 2, 'Speak very loudly into the microphone', ' ');
INSERT INTO answer VALUES (384, 96, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (388, 97, 0, 'Both organizations may provide communications during emergencies', ' ');
INSERT INTO answer VALUES (385, 97, 1, 'They represent the two largest ham clubs in the United States', ' ');
INSERT INTO answer VALUES (386, 97, 2, 'Both organizations broadcast road and weather information', ' ');
INSERT INTO answer VALUES (387, 97, 3, 'Neither may handle emergency traffic supporting public service agencies', ' ');
INSERT INTO answer VALUES (389, 98, 0, 'Formal messages exchanged by net stations', ' ');
INSERT INTO answer VALUES (390, 98, 1, 'The number of stations checking in and out of a net', ' ');
INSERT INTO answer VALUES (391, 98, 2, 'Operation by mobile or portable stations', ' ');
INSERT INTO answer VALUES (392, 98, 3, 'Requests to activate the net by a served agency', ' ');
INSERT INTO answer VALUES (395, 99, 0, 'Begin your transmission by saying "Priority" or "Emergency" followed by your call sign', ' ');
INSERT INTO answer VALUES (393, 99, 1, 'Repeat "SOS" three times followed by the call sign of the reporting station', ' ');
INSERT INTO answer VALUES (394, 99, 2, 'Press the push-to-talk button three times', ' ');
INSERT INTO answer VALUES (396, 99, 3, 'Play a pre-recorded emergency alert tone followed by your call sign', ' ');
INSERT INTO answer VALUES (399, 100, 0, 'Remain on frequency without transmitting until asked to do so by the net control station', ' ');
INSERT INTO answer VALUES (397, 100, 1, 'Provided that the frequency is quiet, announce the station call sign and location every 5 minutes', ' ');
INSERT INTO answer VALUES (398, 100, 2, 'Move 5 kHz away from the net''s frequency and use high power to ask other hams to keep clear of the net frequency', ' ');
INSERT INTO answer VALUES (400, 100, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (401, 101, 0, 'Passing messages exactly as received', ' ');
INSERT INTO answer VALUES (402, 101, 1, 'Making decisions as to whether messages are worthy of relay or delivery', ' ');
INSERT INTO answer VALUES (403, 101, 2, 'Ensuring that any newsworthy messages are relayed to the news media', ' ');
INSERT INTO answer VALUES (404, 101, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (408, 102, 0, 'Yes, but only if necessary in situations involving the immediate safety of human life or protection of property', ' ');
INSERT INTO answer VALUES (405, 102, 1, 'No', ' ');
INSERT INTO answer VALUES (406, 102, 2, 'Yes, but only when part of a FEMA emergency plan', ' ');
INSERT INTO answer VALUES (407, 102, 3, 'Yes, but only when part of a RACES emergency plan', ' ');
INSERT INTO answer VALUES (412, 103, 0, 'The information needed to track the message', ' ');
INSERT INTO answer VALUES (409, 103, 1, 'The email address of the originating station', ' ');
INSERT INTO answer VALUES (410, 103, 2, 'The address of the intended recipient', ' ');
INSERT INTO answer VALUES (411, 103, 3, 'The telephone number of the addressee', ' ');
INSERT INTO answer VALUES (413, 104, 0, 'The number of words or word equivalents in the text portion of the message', ' ');
INSERT INTO answer VALUES (414, 104, 1, 'The value of a money order attached to the message', ' ');
INSERT INTO answer VALUES (415, 104, 2, 'A list of stations that have relayed the message', ' ');
INSERT INTO answer VALUES (416, 104, 3, 'A box on the message form that indicates that the message was received and/or relayed', ' ');
INSERT INTO answer VALUES (417, 105, 0, 'Licensed amateurs who have voluntarily registered their qualifications and equipment for communications duty in the public service', ' ');
INSERT INTO answer VALUES (418, 105, 1, 'Licensed amateurs who are members of the military and who voluntarily agreed to provide message handling services in the case of an emergency', ' ');
INSERT INTO answer VALUES (419, 105, 2, 'A training program that provides licensing courses for those interested in obtaining an amateur license to use during emergencies', ' ');
INSERT INTO answer VALUES (420, 105, 3, 'A training program that certifies amateur operators for membership in the Radio Amateur Civil Emergency Service', ' ');
INSERT INTO answer VALUES (424, 106, 0, 'Try moving a few feet or changing the direction of your antenna if possible, as reflections may be causing multi-path distortion', ' ');
INSERT INTO answer VALUES (421, 106, 1, 'Change the batteries in your radio to a different type', ' ');
INSERT INTO answer VALUES (422, 106, 2, 'Turn on the CTCSS tone', ' ');
INSERT INTO answer VALUES (423, 106, 3, 'Ask the other operator to adjust his squelch control', ' ');
INSERT INTO answer VALUES (426, 107, 0, 'Less absorption by vegetation', ' ');
INSERT INTO answer VALUES (425, 107, 1, 'Less ionospheric absorption', ' ');
INSERT INTO answer VALUES (427, 107, 2, 'Less solar activity', ' ');
INSERT INTO answer VALUES (428, 107, 3, 'Less tropospheric absorption', ' ');
INSERT INTO answer VALUES (431, 108, 0, 'Horizontal', ' ');
INSERT INTO answer VALUES (429, 108, 1, 'Right-hand circular', ' ');
INSERT INTO answer VALUES (430, 108, 2, 'Left-hand circular', ' ');
INSERT INTO answer VALUES (432, 108, 3, 'Vertical', ' ');
INSERT INTO answer VALUES (434, 109, 0, 'Signals could be significantly weaker', ' ');
INSERT INTO answer VALUES (433, 109, 1, 'The modulation sidebands might become inverted', ' ');
INSERT INTO answer VALUES (435, 109, 2, 'Signals have an echo effect on voices', ' ');
INSERT INTO answer VALUES (436, 109, 3, 'Nothing significant will happen', ' ');
INSERT INTO answer VALUES (438, 110, 0, 'Try to find a path that reflects signals to the repeater', ' ');
INSERT INTO answer VALUES (437, 110, 1, 'Change from vertical to horizontal polarization', ' ');
INSERT INTO answer VALUES (439, 110, 2, 'Try the long path', ' ');
INSERT INTO answer VALUES (440, 110, 3, 'Increase the antenna SWR', ' ');
INSERT INTO answer VALUES (442, 111, 0, 'Picket fencing', ' ');
INSERT INTO answer VALUES (441, 111, 1, 'Flip-flopping', ' ');
INSERT INTO answer VALUES (443, 111, 2, 'Frequency shifting', ' ');
INSERT INTO answer VALUES (444, 111, 3, 'Pulsing', ' ');
INSERT INTO answer VALUES (445, 112, 0, 'Electromagnetic', ' ');
INSERT INTO answer VALUES (446, 112, 1, 'Electrostatic', ' ');
INSERT INTO answer VALUES (447, 112, 2, 'Surface acoustic', ' ');
INSERT INTO answer VALUES (448, 112, 3, 'Ferromagnetic', ' ');
INSERT INTO answer VALUES (451, 113, 0, 'Random combining of signals arriving via different paths', ' ');
INSERT INTO answer VALUES (449, 113, 1, 'Frequency shift due to Faraday rotation', ' ');
INSERT INTO answer VALUES (450, 113, 2, 'Interference from thunderstorms', ' ');
INSERT INTO answer VALUES (452, 113, 3, 'Intermodulation distortion', ' ');
INSERT INTO answer VALUES (454, 114, 0, 'Either vertically or horizontally polarized antennas may be used for transmission or reception', ' ');
INSERT INTO answer VALUES (453, 114, 1, 'Digital modes are unusable', ' ');
INSERT INTO answer VALUES (455, 114, 2, 'FM voice is unusable', ' ');
INSERT INTO answer VALUES (456, 114, 3, 'Both the transmitting and receiving antennas must be of the same polarization', ' ');
INSERT INTO answer VALUES (460, 115, 0, 'Error rates are likely to increase', ' ');
INSERT INTO answer VALUES (457, 115, 1, 'Transmission rates can be increased by a factor equal to the number of separate paths observed', ' ');
INSERT INTO answer VALUES (458, 115, 2, 'Transmission rates must be decreased by a factor equal to the number of separate paths observed', ' ');
INSERT INTO answer VALUES (459, 115, 3, 'No significant changes will occur if the signals are transmitted using FM', ' ');
INSERT INTO answer VALUES (463, 116, 0, 'The ionosphere', ' ');
INSERT INTO answer VALUES (461, 116, 1, 'The stratosphere', ' ');
INSERT INTO answer VALUES (462, 116, 2, 'The troposphere', ' ');
INSERT INTO answer VALUES (464, 116, 3, 'The magnetosphere', ' ');
INSERT INTO answer VALUES (466, 117, 0, 'Fog and light rain will have little effect on these bands', ' ');
INSERT INTO answer VALUES (465, 117, 1, 'Fog and rain absorb these wavelength bands', ' ');
INSERT INTO answer VALUES (467, 117, 2, 'Fog and rain will deflect these signals', ' ');
INSERT INTO answer VALUES (468, 117, 3, 'Fog and rain will increase radio range', ' ');
INSERT INTO answer VALUES (471, 118, 0, 'Precipitation', ' ');
INSERT INTO answer VALUES (469, 118, 1, 'High winds', ' ');
INSERT INTO answer VALUES (470, 118, 2, 'Low barometric pressure', ' ');
INSERT INTO answer VALUES (472, 118, 3, 'Colder temperatures', ' ');
INSERT INTO answer VALUES (475, 119, 0, 'Wavelength', ' ');
INSERT INTO answer VALUES (473, 119, 1, 'Wave speed', ' ');
INSERT INTO answer VALUES (474, 119, 2, 'Waveform', ' ');
INSERT INTO answer VALUES (476, 119, 3, 'Wave spread', ' ');
INSERT INTO answer VALUES (477, 120, 0, 'The orientation of the electric field', ' ');
INSERT INTO answer VALUES (478, 120, 1, 'The orientation of the magnetic field', ' ');
INSERT INTO answer VALUES (479, 120, 2, 'The ratio of the energy in the magnetic field to the energy in the electric field', ' ');
INSERT INTO answer VALUES (480, 120, 3, 'The ratio of the velocity to the wavelength', ' ');
INSERT INTO answer VALUES (483, 121, 0, 'Electric and magnetic fields', ' ');
INSERT INTO answer VALUES (481, 121, 1, 'AC and DC', ' ');
INSERT INTO answer VALUES (482, 121, 2, 'Voltage and current', ' ');
INSERT INTO answer VALUES (484, 121, 3, 'Ionizing and non-ionizing radiation', ' ');
INSERT INTO answer VALUES (485, 122, 0, 'At the speed of light', ' ');
INSERT INTO answer VALUES (486, 122, 1, 'At the speed of sound', ' ');
INSERT INTO answer VALUES (487, 122, 2, 'Its speed is inversely proportional to its wavelength', ' ');
INSERT INTO answer VALUES (488, 122, 3, 'Its speed increases as the frequency increases', ' ');
INSERT INTO answer VALUES (490, 123, 0, 'The wavelength gets shorter as the frequency increases', ' ');
INSERT INTO answer VALUES (489, 123, 1, 'The wavelength gets longer as the frequency increases', ' ');
INSERT INTO answer VALUES (491, 123, 2, 'There is no relationship between wavelength and frequency', ' ');
INSERT INTO answer VALUES (492, 123, 3, 'The wavelength depends on the bandwidth of the signal', ' ');
INSERT INTO answer VALUES (496, 124, 0, 'Wavelength in meters equals 300 divided by frequency in megahertz', ' ');
INSERT INTO answer VALUES (493, 124, 1, 'Wavelength in meters equals frequency in hertz multiplied by 300', ' ');
INSERT INTO answer VALUES (494, 124, 2, 'Wavelength in meters equals frequency in hertz divided by 300', ' ');
INSERT INTO answer VALUES (495, 124, 3, 'Wavelength in meters equals frequency in megahertz divided by 300', ' ');
INSERT INTO answer VALUES (497, 125, 0, 'The approximate wavelength', ' ');
INSERT INTO answer VALUES (498, 125, 1, 'The magnetic intensity of waves', ' ');
INSERT INTO answer VALUES (499, 125, 2, 'The time it takes for waves to travel one mile', ' ');
INSERT INTO answer VALUES (500, 125, 3, 'The voltage standing wave ratio of waves', ' ');
INSERT INTO answer VALUES (502, 126, 0, '30 to 300 MHz', ' ');
INSERT INTO answer VALUES (501, 126, 1, '30 to 300 kHz', ' ');
INSERT INTO answer VALUES (503, 126, 2, '300 to 3000 kHz', ' ');
INSERT INTO answer VALUES (504, 126, 3, '300 to 3000 MHz', ' ');
INSERT INTO answer VALUES (508, 127, 0, '300 to 3000 MHz', ' ');
INSERT INTO answer VALUES (505, 127, 1, '30 to 300 kHz', ' ');
INSERT INTO answer VALUES (506, 127, 2, '30 to 300 MHz', ' ');
INSERT INTO answer VALUES (507, 127, 3, '300 to 3000 kHz', ' ');
INSERT INTO answer VALUES (511, 128, 0, '3 to 30 MHz', ' ');
INSERT INTO answer VALUES (509, 128, 1, '300 to 3000 MHz', ' ');
INSERT INTO answer VALUES (510, 128, 2, '30 to 300 MHz', ' ');
INSERT INTO answer VALUES (512, 128, 3, '300 to 3000 kHz', ' ');
INSERT INTO answer VALUES (514, 129, 0, '300,000,000 meters per second', ' ');
INSERT INTO answer VALUES (513, 129, 1, '150,000 kilometers per second', ' ');
INSERT INTO answer VALUES (515, 129, 2, '300,000,000 miles per hour', ' ');
INSERT INTO answer VALUES (516, 129, 3, '150,000 miles per hour', ' ');
INSERT INTO answer VALUES (519, 130, 0, 'UHF signals are usually not reflected by the ionosphere', ' ');
INSERT INTO answer VALUES (517, 130, 1, 'They are too weak to go very far', ' ');
INSERT INTO answer VALUES (518, 130, 2, 'FCC regulations prohibit them from going more than 50 miles', ' ');
INSERT INTO answer VALUES (520, 130, 3, 'UHF signals are absorbed by the ionospheric D layer', ' ');
INSERT INTO answer VALUES (523, 131, 0, 'Long distance ionospheric propagation is far more common on HF', ' ');
INSERT INTO answer VALUES (521, 131, 1, 'HF antennas are generally smaller', ' ');
INSERT INTO answer VALUES (522, 131, 2, 'HF accommodates wider bandwidth signals', ' ');
INSERT INTO answer VALUES (524, 131, 3, 'There is less atmospheric interference (static) on HF', ' ');
INSERT INTO answer VALUES (526, 132, 0, 'The signals exhibit rapid fluctuations of strength and often sound distorted', ' ');
INSERT INTO answer VALUES (525, 132, 1, 'Signals from distances of 10,000 or more miles are common', ' ');
INSERT INTO answer VALUES (527, 132, 2, 'These types of signals occur only during winter nighttime hours', ' ');
INSERT INTO answer VALUES (528, 132, 3, 'These types of signals are generally strongest when your antenna is aimed west', ' ');
INSERT INTO answer VALUES (530, 133, 0, 'Sporadic E', ' ');
INSERT INTO answer VALUES (529, 133, 1, 'Backscatter', ' ');
INSERT INTO answer VALUES (531, 133, 2, 'D layer absorption', ' ');
INSERT INTO answer VALUES (532, 133, 3, 'Gray-line propagation', ' ');
INSERT INTO answer VALUES (533, 134, 0, 'Knife-edge diffraction', ' ');
INSERT INTO answer VALUES (534, 134, 1, 'Faraday rotation', ' ');
INSERT INTO answer VALUES (535, 134, 2, 'Quantum tunneling', ' ');
INSERT INTO answer VALUES (536, 134, 3, 'Doppler shift', ' ');
INSERT INTO answer VALUES (537, 135, 0, 'Tropospheric ducting', ' ');
INSERT INTO answer VALUES (538, 135, 1, 'D layer refraction', ' ');
INSERT INTO answer VALUES (539, 135, 2, 'F2 layer refraction', ' ');
INSERT INTO answer VALUES (540, 135, 3, 'Faraday rotation', ' ');
INSERT INTO answer VALUES (542, 136, 0, '6 meter band', ' ');
INSERT INTO answer VALUES (541, 136, 1, '10 meter band', ' ');
INSERT INTO answer VALUES (543, 136, 2, '2 meter band', ' ');
INSERT INTO answer VALUES (544, 136, 3, '70 centimeter band', ' ');
INSERT INTO answer VALUES (548, 137, 0, 'Temperature inversions in the atmosphere', ' ');
INSERT INTO answer VALUES (545, 137, 1, 'Discharges of lightning during electrical storms', ' ');
INSERT INTO answer VALUES (546, 137, 2, 'Sunspots and solar flares', ' ');
INSERT INTO answer VALUES (547, 137, 3, 'Updrafts from hurricanes and tornadoes', ' ');
INSERT INTO answer VALUES (549, 138, 0, 'From dawn to shortly after sunset during periods of high sunspot activity', ' ');
INSERT INTO answer VALUES (550, 138, 1, 'From shortly after sunset to dawn during periods of high sunspot activity', ' ');
INSERT INTO answer VALUES (551, 138, 2, 'From dawn to shortly after sunset during periods of low sunspot activity', ' ');
INSERT INTO answer VALUES (552, 138, 3, 'From shortly after sunset to dawn during periods of low sunspot activity', ' ');
INSERT INTO answer VALUES (553, 139, 0, '6 or 10 meter bands', ' ');
INSERT INTO answer VALUES (554, 139, 1, '23 centimeter band', ' ');
INSERT INTO answer VALUES (555, 139, 2, '70 centimeter or 1.25 meter bands', ' ');
INSERT INTO answer VALUES (556, 139, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (559, 140, 0, 'The Earth seems less curved to radio waves than to light', ' ');
INSERT INTO answer VALUES (557, 140, 1, 'Radio signals move somewhat faster than the speed of light', ' ');
INSERT INTO answer VALUES (558, 140, 2, 'Radio waves are not blocked by dust particles', ' ');
INSERT INTO answer VALUES (560, 140, 3, 'Radio waves are blocked by dust particles', ' ');
INSERT INTO answer VALUES (564, 141, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (561, 141, 1, 'Efficiency of the transmitter at full power output', ' ');
INSERT INTO answer VALUES (562, 141, 2, 'Receiver and control circuit power', ' ');
INSERT INTO answer VALUES (563, 141, 3, 'Power supply regulation and heat dissipation', ' ');
INSERT INTO answer VALUES (568, 142, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (565, 142, 1, 'For logging contacts and contact information', ' ');
INSERT INTO answer VALUES (566, 142, 2, 'For sending and/or receiving CW', ' ');
INSERT INTO answer VALUES (567, 142, 3, 'For generating and decoding digital signals', ' ');
INSERT INTO answer VALUES (569, 143, 0, 'To avoid voltage falling below that needed for proper operation', ' ');
INSERT INTO answer VALUES (570, 143, 1, 'To provide a good counterpoise for the antenna', ' ');
INSERT INTO answer VALUES (571, 143, 2, 'To avoid RF interference', ' ');
INSERT INTO answer VALUES (572, 143, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (575, 144, 0, 'Microphone or line input', ' ');
INSERT INTO answer VALUES (573, 144, 1, 'Headphone output', ' ');
INSERT INTO answer VALUES (574, 144, 2, 'Mute', ' ');
INSERT INTO answer VALUES (576, 144, 3, 'PCI or SDI', ' ');
INSERT INTO answer VALUES (577, 145, 0, 'In series with the feed line, between the transmitter and antenna', ' ');
INSERT INTO answer VALUES (578, 145, 1, 'In series with the station''s ground', ' ');
INSERT INTO answer VALUES (579, 145, 2, 'In parallel with the push-to-talk line and the antenna', ' ');
INSERT INTO answer VALUES (580, 145, 3, 'In series with the power supply cable, as close as possible to the radio', ' ');
INSERT INTO answer VALUES (583, 146, 0, 'Receive audio, transmit audio, and push-to-talk (PTT)', ' ');
INSERT INTO answer VALUES (581, 146, 1, 'Receive and transmit mode, status, and location', ' ');
INSERT INTO answer VALUES (582, 146, 2, 'Antenna and RF power', ' ');
INSERT INTO answer VALUES (584, 146, 3, 'NMEA GPS location and DC power', ' ');
INSERT INTO answer VALUES (587, 147, 0, 'The sound card provides audio to the radio''s microphone input and converts received audio to digital form', ' ');
INSERT INTO answer VALUES (585, 147, 1, 'The sound card communicates between the computer CPU and the video display', ' ');
INSERT INTO answer VALUES (586, 147, 2, 'The sound card records the audio frequency for video display', ' ');
INSERT INTO answer VALUES (588, 147, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (592, 148, 0, 'Flat strap', ' ');
INSERT INTO answer VALUES (589, 148, 1, 'Round stranded wire', ' ');
INSERT INTO answer VALUES (590, 148, 2, 'Round copper-clad steel wire', ' ');
INSERT INTO answer VALUES (591, 148, 3, 'Twisted-pair cable', ' ');
INSERT INTO answer VALUES (596, 149, 0, 'Ferrite choke', ' ');
INSERT INTO answer VALUES (593, 149, 1, 'Band-pass filter', ' ');
INSERT INTO answer VALUES (594, 149, 2, 'Low-pass filter', ' ');
INSERT INTO answer VALUES (595, 149, 3, 'Preamplifier', ' ');
INSERT INTO answer VALUES (598, 150, 0, 'The alternator', ' ');
INSERT INTO answer VALUES (597, 150, 1, 'The ignition system', ' ');
INSERT INTO answer VALUES (599, 150, 2, 'The electric fuel pump', ' ');
INSERT INTO answer VALUES (600, 150, 3, 'Anti-lock braking system controllers', ' ');
INSERT INTO answer VALUES (601, 151, 0, 'At the battery or engine block ground strap', ' ');
INSERT INTO answer VALUES (602, 151, 1, 'At the antenna mount', ' ');
INSERT INTO answer VALUES (603, 151, 2, 'To any metal part of the vehicle', ' ');
INSERT INTO answer VALUES (604, 151, 3, 'Through the transceiver’s mounting bracket', ' ');
INSERT INTO answer VALUES (606, 152, 0, 'The output signal might become distorted', ' ');
INSERT INTO answer VALUES (605, 152, 1, 'The output power might be too high', ' ');
INSERT INTO answer VALUES (607, 152, 2, 'The frequency might vary', ' ');
INSERT INTO answer VALUES (608, 152, 3, 'The SWR might increase', ' ');
INSERT INTO answer VALUES (609, 153, 0, 'The keypad or VFO knob', ' ');
INSERT INTO answer VALUES (610, 153, 1, 'The CTCSS or DTMF encoder', ' ');
INSERT INTO answer VALUES (611, 153, 2, 'The Automatic Frequency Control', ' ');
INSERT INTO answer VALUES (612, 153, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (616, 154, 0, 'To mute receiver output noise when no signal is being received', ' ');
INSERT INTO answer VALUES (613, 154, 1, 'To set the highest level of volume desired', ' ');
INSERT INTO answer VALUES (614, 154, 2, 'To set the transmitter power level', ' ');
INSERT INTO answer VALUES (615, 154, 3, 'To adjust the automatic gain control', ' ');
INSERT INTO answer VALUES (618, 155, 0, 'Store the frequency in a memory channel', ' ');
INSERT INTO answer VALUES (617, 155, 1, 'Enable the CTCSS tones', ' ');
INSERT INTO answer VALUES (619, 155, 2, 'Disable the CTCSS tones', ' ');
INSERT INTO answer VALUES (620, 155, 3, 'Use the scan mode to select the desired frequency', ' ');
INSERT INTO answer VALUES (623, 156, 0, 'Turn on the noise blanker', ' ');
INSERT INTO answer VALUES (621, 156, 1, 'Change frequency slightly', ' ');
INSERT INTO answer VALUES (622, 156, 2, 'Decrease the squelch setting', ' ');
INSERT INTO answer VALUES (624, 156, 3, 'Use the RIT control', ' ');
INSERT INTO answer VALUES (628, 157, 0, 'The receiver RIT or clarifier', ' ');
INSERT INTO answer VALUES (625, 157, 1, 'The AGC or limiter', ' ');
INSERT INTO answer VALUES (626, 157, 2, 'The bandwidth selection', ' ');
INSERT INTO answer VALUES (627, 157, 3, 'The tone squelch', ' ');
INSERT INTO answer VALUES (630, 158, 0, 'Receiver Incremental Tuning', ' ');
INSERT INTO answer VALUES (629, 158, 1, 'Receiver Input Tone', ' ');
INSERT INTO answer VALUES (631, 158, 2, 'Rectifier Inverter Test', ' ');
INSERT INTO answer VALUES (632, 158, 3, 'Remote Input Transmitter', ' ');
INSERT INTO answer VALUES (634, 159, 0, 'Permits noise or interference reduction by selecting a bandwidth matching the mode', ' ');
INSERT INTO answer VALUES (633, 159, 1, 'Permits monitoring several modes at once', ' ');
INSERT INTO answer VALUES (635, 159, 2, 'Increases the number of frequencies that can be stored in memory', ' ');
INSERT INTO answer VALUES (636, 159, 3, 'Increases the amount of offset between receive and transmit frequencies', ' ');
INSERT INTO answer VALUES (639, 160, 0, '2400 Hz', ' ');
INSERT INTO answer VALUES (637, 160, 1, '500 Hz', ' ');
INSERT INTO answer VALUES (638, 160, 2, '1000 Hz', ' ');
INSERT INTO answer VALUES (640, 160, 3, '5000 Hz', ' ');
INSERT INTO answer VALUES (641, 161, 0, '500 Hz', ' ');
INSERT INTO answer VALUES (642, 161, 1, '1000 Hz', ' ');
INSERT INTO answer VALUES (643, 161, 2, '2400 Hz', ' ');
INSERT INTO answer VALUES (644, 161, 3, '5000 Hz', ' ');
INSERT INTO answer VALUES (645, 162, 0, 'To keep received audio relatively constant', ' ');
INSERT INTO answer VALUES (646, 162, 1, 'To protect an antenna from lightning', ' ');
INSERT INTO answer VALUES (647, 162, 2, 'To eliminate RF on the station cabling', ' ');
INSERT INTO answer VALUES (648, 162, 3, 'An asymmetric goniometer control used for antenna matching', ' ');
INSERT INTO answer VALUES (650, 163, 0, 'Noise blanker', ' ');
INSERT INTO answer VALUES (649, 163, 1, 'Squelch', ' ');
INSERT INTO answer VALUES (651, 163, 2, 'Notch filter', ' ');
INSERT INTO answer VALUES (652, 163, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (655, 164, 0, 'To scan through a range of frequencies to check for activity', ' ');
INSERT INTO answer VALUES (653, 164, 1, 'To check incoming signal deviation', ' ');
INSERT INTO answer VALUES (654, 164, 2, 'To prevent interference to nearby repeaters', ' ');
INSERT INTO answer VALUES (656, 164, 3, 'To check for messages left on a digital bulletin board', ' ');
INSERT INTO answer VALUES (660, 165, 0, 'Amperes', ' ');
INSERT INTO answer VALUES (657, 165, 1, 'Volts', ' ');
INSERT INTO answer VALUES (658, 165, 2, 'Watts', ' ');
INSERT INTO answer VALUES (659, 165, 3, 'Ohms', ' ');
INSERT INTO answer VALUES (662, 166, 0, 'Watts', ' ');
INSERT INTO answer VALUES (661, 166, 1, 'Volts', ' ');
INSERT INTO answer VALUES (663, 166, 2, 'Ohms', ' ');
INSERT INTO answer VALUES (664, 166, 3, 'Amperes', ' ');
INSERT INTO answer VALUES (668, 167, 0, 'Current', ' ');
INSERT INTO answer VALUES (665, 167, 1, 'Voltage', ' ');
INSERT INTO answer VALUES (666, 167, 2, 'Resistance', ' ');
INSERT INTO answer VALUES (667, 167, 3, 'Capacitance', ' ');
INSERT INTO answer VALUES (670, 168, 0, 'Direct current', ' ');
INSERT INTO answer VALUES (669, 168, 1, 'Alternating current', ' ');
INSERT INTO answer VALUES (671, 168, 2, 'Normal current', ' ');
INSERT INTO answer VALUES (672, 168, 3, 'Smooth current', ' ');
INSERT INTO answer VALUES (673, 169, 0, 'Voltage', ' ');
INSERT INTO answer VALUES (674, 169, 1, 'Ampere-hours', ' ');
INSERT INTO answer VALUES (675, 169, 2, 'Capacitance', ' ');
INSERT INTO answer VALUES (676, 169, 3, 'Inductance', ' ');
INSERT INTO answer VALUES (677, 170, 0, 'About 12 volts', ' ');
INSERT INTO answer VALUES (678, 170, 1, 'About 30 volts', ' ');
INSERT INTO answer VALUES (679, 170, 2, 'About 120 volts', ' ');
INSERT INTO answer VALUES (680, 170, 3, 'About 240 volts', ' ');
INSERT INTO answer VALUES (683, 171, 0, 'Copper', ' ');
INSERT INTO answer VALUES (681, 171, 1, 'Glass', ' ');
INSERT INTO answer VALUES (682, 171, 2, 'Wood', ' ');
INSERT INTO answer VALUES (684, 171, 3, 'Rubber', ' ');
INSERT INTO answer VALUES (686, 172, 0, 'Glass', ' ');
INSERT INTO answer VALUES (685, 172, 1, 'Copper', ' ');
INSERT INTO answer VALUES (687, 172, 2, 'Aluminum', ' ');
INSERT INTO answer VALUES (688, 172, 3, 'Mercury', ' ');
INSERT INTO answer VALUES (689, 173, 0, 'Alternating current', ' ');
INSERT INTO answer VALUES (690, 173, 1, 'Direct current', ' ');
INSERT INTO answer VALUES (691, 173, 2, 'Circular current', ' ');
INSERT INTO answer VALUES (692, 173, 3, 'Vertical current', ' ');
INSERT INTO answer VALUES (695, 174, 0, 'Power', ' ');
INSERT INTO answer VALUES (693, 174, 1, 'Resistance', ' ');
INSERT INTO answer VALUES (694, 174, 2, 'Current', ' ');
INSERT INTO answer VALUES (696, 174, 3, 'Voltage', ' ');
INSERT INTO answer VALUES (697, 175, 0, 'The volt', ' ');
INSERT INTO answer VALUES (698, 175, 1, 'The watt', ' ');
INSERT INTO answer VALUES (699, 175, 2, 'The ampere', ' ');
INSERT INTO answer VALUES (700, 175, 3, 'The ohm', ' ');
INSERT INTO answer VALUES (704, 176, 0, 'Frequency', ' ');
INSERT INTO answer VALUES (701, 176, 1, 'Pulse rate', ' ');
INSERT INTO answer VALUES (702, 176, 2, 'Speed', ' ');
INSERT INTO answer VALUES (703, 176, 3, 'Wavelength', ' ');
INSERT INTO answer VALUES (705, 177, 0, 'Series', ' ');
INSERT INTO answer VALUES (706, 177, 1, 'Parallel', ' ');
INSERT INTO answer VALUES (707, 177, 2, 'Resonant', ' ');
INSERT INTO answer VALUES (708, 177, 3, 'Branch', ' ');
INSERT INTO answer VALUES (710, 178, 0, 'Parallel', ' ');
INSERT INTO answer VALUES (709, 178, 1, 'Series', ' ');
INSERT INTO answer VALUES (711, 178, 2, 'Resonant', ' ');
INSERT INTO answer VALUES (712, 178, 3, 'Branch', ' ');
INSERT INTO answer VALUES (715, 179, 0, '1500 milliamperes', ' ');
INSERT INTO answer VALUES (713, 179, 1, '15 milliamperes', ' ');
INSERT INTO answer VALUES (714, 179, 2, '150 milliamperes', ' ');
INSERT INTO answer VALUES (716, 179, 3, '15,000 milliamperes', ' ');
INSERT INTO answer VALUES (717, 180, 0, '1500 kHz', ' ');
INSERT INTO answer VALUES (718, 180, 1, '1500 MHz', ' ');
INSERT INTO answer VALUES (719, 180, 2, '15 GHz', ' ');
INSERT INTO answer VALUES (720, 180, 3, '150 kHz', ' ');
INSERT INTO answer VALUES (723, 181, 0, 'One thousand volts', ' ');
INSERT INTO answer VALUES (721, 181, 1, 'One one-thousandth of a volt', ' ');
INSERT INTO answer VALUES (722, 181, 2, 'One hundred volts', ' ');
INSERT INTO answer VALUES (724, 181, 3, 'One million volts', ' ');
INSERT INTO answer VALUES (725, 182, 0, 'One one-millionth of a volt', ' ');
INSERT INTO answer VALUES (726, 182, 1, 'One million volts', ' ');
INSERT INTO answer VALUES (727, 182, 2, 'One thousand kilovolts', ' ');
INSERT INTO answer VALUES (728, 182, 3, 'One one-thousandth of a volt', ' ');
INSERT INTO answer VALUES (730, 183, 0, '0.5 watts', ' ');
INSERT INTO answer VALUES (729, 183, 1, '0.02 watts', ' ');
INSERT INTO answer VALUES (731, 183, 2, '5 watts', ' ');
INSERT INTO answer VALUES (732, 183, 3, '50 watts', ' ');
INSERT INTO answer VALUES (735, 184, 0, '3 amperes', ' ');
INSERT INTO answer VALUES (733, 184, 1, '0.003 amperes', ' ');
INSERT INTO answer VALUES (734, 184, 2, '0.3 amperes', ' ');
INSERT INTO answer VALUES (736, 184, 3, '3,000,000 amperes', ' ');
INSERT INTO answer VALUES (739, 185, 0, '3525 kHz', ' ');
INSERT INTO answer VALUES (737, 185, 1, '0.003525 kHz', ' ');
INSERT INTO answer VALUES (738, 185, 2, '35.25 kHz', ' ');
INSERT INTO answer VALUES (740, 185, 3, '3,525,000 kHz', ' ');
INSERT INTO answer VALUES (742, 186, 0, '1 microfarad', ' ');
INSERT INTO answer VALUES (741, 186, 1, '0.001 microfarads', ' ');
INSERT INTO answer VALUES (743, 186, 2, '1000 microfarads', ' ');
INSERT INTO answer VALUES (744, 186, 3, '1,000,000,000 microfarads', ' ');
INSERT INTO answer VALUES (746, 187, 0, '3 dB', ' ');
INSERT INTO answer VALUES (745, 187, 1, '2 dB', ' ');
INSERT INTO answer VALUES (747, 187, 2, '5 dB', ' ');
INSERT INTO answer VALUES (748, 187, 3, '10 dB', ' ');
INSERT INTO answer VALUES (751, 188, 0, '-6 dB', ' ');
INSERT INTO answer VALUES (749, 188, 1, '-1 dB', ' ');
INSERT INTO answer VALUES (750, 188, 2, '-3 dB', ' ');
INSERT INTO answer VALUES (752, 188, 3, '-9 dB', ' ');
INSERT INTO answer VALUES (753, 189, 0, '10 dB', ' ');
INSERT INTO answer VALUES (754, 189, 1, '12 dB', ' ');
INSERT INTO answer VALUES (755, 189, 2, '18 dB', ' ');
INSERT INTO answer VALUES (756, 189, 3, '28 dB', ' ');
INSERT INTO answer VALUES (757, 190, 0, '28.400 MHz', ' ');
INSERT INTO answer VALUES (758, 190, 1, '2.800 MHz', ' ');
INSERT INTO answer VALUES (759, 190, 2, '284.00 MHz', ' ');
INSERT INTO answer VALUES (760, 190, 3, '28.400 kHz', ' ');
INSERT INTO answer VALUES (763, 191, 0, '2.425 GHz', ' ');
INSERT INTO answer VALUES (761, 191, 1, '0.002425 GHz', ' ');
INSERT INTO answer VALUES (762, 191, 2, '24.25 GHz', ' ');
INSERT INTO answer VALUES (764, 191, 3, '2425 GHz', ' ');
INSERT INTO answer VALUES (768, 192, 0, 'Capacitance', ' ');
INSERT INTO answer VALUES (765, 192, 1, 'Inductance', ' ');
INSERT INTO answer VALUES (766, 192, 2, 'Resistance', ' ');
INSERT INTO answer VALUES (767, 192, 3, 'Tolerance', ' ');
INSERT INTO answer VALUES (769, 193, 0, 'The farad', ' ');
INSERT INTO answer VALUES (770, 193, 1, 'The ohm', ' ');
INSERT INTO answer VALUES (771, 193, 2, 'The volt', ' ');
INSERT INTO answer VALUES (772, 193, 3, 'The henry', ' ');
INSERT INTO answer VALUES (776, 194, 0, 'Inductance', ' ');
INSERT INTO answer VALUES (773, 194, 1, 'Admittance', ' ');
INSERT INTO answer VALUES (774, 194, 2, 'Capacitance', ' ');
INSERT INTO answer VALUES (775, 194, 3, 'Resistance', ' ');
INSERT INTO answer VALUES (779, 195, 0, 'The henry', ' ');
INSERT INTO answer VALUES (777, 195, 1, 'The coulomb', ' ');
INSERT INTO answer VALUES (778, 195, 2, 'The farad', ' ');
INSERT INTO answer VALUES (780, 195, 3, 'The ohm', ' ');
INSERT INTO answer VALUES (781, 196, 0, 'Hertz', ' ');
INSERT INTO answer VALUES (782, 196, 1, 'Henry', ' ');
INSERT INTO answer VALUES (783, 196, 2, 'Farad', ' ');
INSERT INTO answer VALUES (784, 196, 3, 'Tesla', ' ');
INSERT INTO answer VALUES (785, 197, 0, 'Radio frequency signals of all types', ' ');
INSERT INTO answer VALUES (786, 197, 1, 'The resonant frequency of a tuned circuit', ' ');
INSERT INTO answer VALUES (787, 197, 2, 'The real frequency transmitted as opposed to the apparent frequency', ' ');
INSERT INTO answer VALUES (788, 197, 3, 'Reflective force in antenna transmission lines', ' ');
INSERT INTO answer VALUES (790, 198, 0, 'Electromagnetic', ' ');
INSERT INTO answer VALUES (789, 198, 1, 'Pressure', ' ');
INSERT INTO answer VALUES (791, 198, 2, 'Gravity', ' ');
INSERT INTO answer VALUES (792, 198, 3, 'Thermal', ' ');
INSERT INTO answer VALUES (793, 199, 0, 'Power (P) equals voltage (E) multiplied by current (I)', ' ');
INSERT INTO answer VALUES (794, 199, 1, 'Power (P) equals voltage (E) divided by current (I)', ' ');
INSERT INTO answer VALUES (795, 199, 2, 'Power (P) equals voltage (E) minus current (I)', ' ');
INSERT INTO answer VALUES (796, 199, 3, 'Power (P) equals voltage (E) plus current (I)', ' ');
INSERT INTO answer VALUES (797, 200, 0, '138 watts', ' ');
INSERT INTO answer VALUES (798, 200, 1, '0.7 watts', ' ');
INSERT INTO answer VALUES (799, 200, 2, '23.8 watts', ' ');
INSERT INTO answer VALUES (800, 200, 3, '3.8 watts', ' ');
INSERT INTO answer VALUES (802, 201, 0, '30 watts', ' ');
INSERT INTO answer VALUES (801, 201, 1, '4.8 watts', ' ');
INSERT INTO answer VALUES (803, 201, 2, '14.5 watts', ' ');
INSERT INTO answer VALUES (804, 201, 3, '0.208 watts', ' ');
INSERT INTO answer VALUES (806, 202, 0, '10 amperes', ' ');
INSERT INTO answer VALUES (805, 202, 1, '0.1 amperes', ' ');
INSERT INTO answer VALUES (807, 202, 2, '12 amperes', ' ');
INSERT INTO answer VALUES (808, 202, 3, '132 amperes', ' ');
INSERT INTO answer VALUES (809, 203, 0, 'A measure of the opposition to AC current flow in a circuit', ' ');
INSERT INTO answer VALUES (810, 203, 1, 'The inverse of resistance', ' ');
INSERT INTO answer VALUES (811, 203, 2, 'The Q or Quality Factor of a component', ' ');
INSERT INTO answer VALUES (812, 203, 3, 'The power handling capability of a component', ' ');
INSERT INTO answer VALUES (816, 204, 0, 'Ohms', ' ');
INSERT INTO answer VALUES (813, 204, 1, 'Volts', ' ');
INSERT INTO answer VALUES (814, 204, 2, 'Amperes', ' ');
INSERT INTO answer VALUES (815, 204, 3, 'Coulombs', ' ');
INSERT INTO answer VALUES (820, 205, 0, 'MHz', ' ');
INSERT INTO answer VALUES (817, 205, 1, 'mHz', ' ');
INSERT INTO answer VALUES (818, 205, 2, 'mhZ', ' ');
INSERT INTO answer VALUES (819, 205, 3, 'Mhz', ' ');
INSERT INTO answer VALUES (822, 206, 0, 'Current (I) equals voltage (E) divided by resistance (R)', ' ');
INSERT INTO answer VALUES (821, 206, 1, 'Current (I) equals voltage (E) multiplied by resistance (R)', ' ');
INSERT INTO answer VALUES (823, 206, 2, 'Current (I) equals voltage (E) added to resistance (R)', ' ');
INSERT INTO answer VALUES (824, 206, 3, 'Current (I) equals voltage (E) minus resistance (R)', ' ');
INSERT INTO answer VALUES (825, 207, 0, 'Voltage (E) equals current (I) multiplied by resistance (R)', ' ');
INSERT INTO answer VALUES (826, 207, 1, 'Voltage (E) equals current (I) divided by resistance (R)', ' ');
INSERT INTO answer VALUES (827, 207, 2, 'Voltage (E) equals current (I) added to resistance (R)', ' ');
INSERT INTO answer VALUES (828, 207, 3, 'Voltage (E) equals current (I) minus resistance (R)', ' ');
INSERT INTO answer VALUES (830, 208, 0, 'Resistance (R) equals voltage (E) divided by current (I)', ' ');
INSERT INTO answer VALUES (829, 208, 1, 'Resistance (R) equals voltage (E) multiplied by current (I)', ' ');
INSERT INTO answer VALUES (831, 208, 2, 'Resistance (R) equals voltage (E) added to current (I)', ' ');
INSERT INTO answer VALUES (832, 208, 3, 'Resistance (R) equals voltage (E) minus current (I)', ' ');
INSERT INTO answer VALUES (834, 209, 0, '30 ohms', ' ');
INSERT INTO answer VALUES (833, 209, 1, '3 ohms', ' ');
INSERT INTO answer VALUES (835, 209, 2, '93 ohms', ' ');
INSERT INTO answer VALUES (836, 209, 3, '270 ohms', ' ');
INSERT INTO answer VALUES (839, 210, 0, '8 ohms', ' ');
INSERT INTO answer VALUES (837, 210, 1, '18 ohms', ' ');
INSERT INTO answer VALUES (838, 210, 2, '0.125 ohms', ' ');
INSERT INTO answer VALUES (840, 210, 3, '13.5 ohms', ' ');
INSERT INTO answer VALUES (841, 211, 0, '3 ohms', ' ');
INSERT INTO answer VALUES (842, 211, 1, '16 ohms', ' ');
INSERT INTO answer VALUES (843, 211, 2, '48 ohms', ' ');
INSERT INTO answer VALUES (844, 211, 3, '8 ohms', ' ');
INSERT INTO answer VALUES (848, 212, 0, '1.5 amperes', ' ');
INSERT INTO answer VALUES (845, 212, 1, '9600 amperes', ' ');
INSERT INTO answer VALUES (846, 212, 2, '200 amperes', ' ');
INSERT INTO answer VALUES (847, 212, 3, '0.667 amperes', ' ');
INSERT INTO answer VALUES (851, 213, 0, '2 amperes', ' ');
INSERT INTO answer VALUES (849, 213, 1, '20,000 amperes', ' ');
INSERT INTO answer VALUES (850, 213, 2, '0.5 amperes', ' ');
INSERT INTO answer VALUES (852, 213, 3, '100 amperes', ' ');
INSERT INTO answer VALUES (855, 214, 0, '10 amperes', ' ');
INSERT INTO answer VALUES (853, 214, 1, '24,000 amperes', ' ');
INSERT INTO answer VALUES (854, 214, 2, '0.1 amperes', ' ');
INSERT INTO answer VALUES (856, 214, 3, '216 amperes', ' ');
INSERT INTO answer VALUES (857, 215, 0, '1 volt', ' ');
INSERT INTO answer VALUES (858, 215, 1, '0.25 volts', ' ');
INSERT INTO answer VALUES (859, 215, 2, '2.5 volts', ' ');
INSERT INTO answer VALUES (860, 215, 3, '1.5 volts', ' ');
INSERT INTO answer VALUES (862, 216, 0, '10 volts', ' ');
INSERT INTO answer VALUES (861, 216, 1, '1 volt', ' ');
INSERT INTO answer VALUES (863, 216, 2, '11 volts', ' ');
INSERT INTO answer VALUES (864, 216, 3, '9 volts', ' ');
INSERT INTO answer VALUES (868, 217, 0, '20 volts', ' ');
INSERT INTO answer VALUES (865, 217, 1, '8 volts', ' ');
INSERT INTO answer VALUES (866, 217, 2, '0.2 volts', ' ');
INSERT INTO answer VALUES (867, 217, 3, '12 volts', ' ');
INSERT INTO answer VALUES (870, 218, 0, 'It is unchanged', ' ');
INSERT INTO answer VALUES (869, 218, 1, 'It divides equally between them', ' ');
INSERT INTO answer VALUES (871, 218, 2, 'It divides based on the on the value of the components', ' ');
INSERT INTO answer VALUES (872, 218, 3, 'The current in the second component is zero', ' ');
INSERT INTO answer VALUES (873, 219, 0, 'It divides between them dependent on the value of the components', ' ');
INSERT INTO answer VALUES (874, 219, 1, 'It is the same in both components', ' ');
INSERT INTO answer VALUES (875, 219, 2, 'Its value doubles', ' ');
INSERT INTO answer VALUES (876, 219, 3, 'Its value is halved', ' ');
INSERT INTO answer VALUES (879, 220, 0, 'It is determined by the type and value of the components', ' ');
INSERT INTO answer VALUES (877, 220, 1, 'The same voltage as the source', ' ');
INSERT INTO answer VALUES (878, 220, 2, 'Half the source voltage', ' ');
INSERT INTO answer VALUES (880, 220, 3, 'Twice the source voltage', ' ');
INSERT INTO answer VALUES (884, 221, 0, 'The same voltage as the source', ' ');
INSERT INTO answer VALUES (881, 221, 1, 'It is determined by the type and value of the components', ' ');
INSERT INTO answer VALUES (882, 221, 2, 'Half the source voltage', ' ');
INSERT INTO answer VALUES (883, 221, 3, 'Twice the source voltage', ' ');
INSERT INTO answer VALUES (886, 222, 0, 'Resistor', ' ');
INSERT INTO answer VALUES (885, 222, 1, 'Inductor', ' ');
INSERT INTO answer VALUES (887, 222, 2, 'Voltmeter', ' ');
INSERT INTO answer VALUES (888, 222, 3, 'Transformer', ' ');
INSERT INTO answer VALUES (891, 223, 0, 'Potentiometer', ' ');
INSERT INTO answer VALUES (889, 223, 1, 'Fixed resistor', ' ');
INSERT INTO answer VALUES (890, 223, 2, 'Power resistor', ' ');
INSERT INTO answer VALUES (892, 223, 3, 'Transformer', ' ');
INSERT INTO answer VALUES (894, 224, 0, 'Resistance', ' ');
INSERT INTO answer VALUES (893, 224, 1, 'Inductance', ' ');
INSERT INTO answer VALUES (895, 224, 2, 'Capacitance', ' ');
INSERT INTO answer VALUES (896, 224, 3, 'Field strength', ' ');
INSERT INTO answer VALUES (898, 225, 0, 'Capacitor', ' ');
INSERT INTO answer VALUES (897, 225, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (899, 225, 2, 'Inductor', ' ');
INSERT INTO answer VALUES (900, 225, 3, 'Diode', ' ');
INSERT INTO answer VALUES (904, 226, 0, 'Capacitor', ' ');
INSERT INTO answer VALUES (901, 226, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (902, 226, 2, 'Potentiometer', ' ');
INSERT INTO answer VALUES (903, 226, 3, 'Oscillator', ' ');
INSERT INTO answer VALUES (907, 227, 0, 'Inductor', ' ');
INSERT INTO answer VALUES (905, 227, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (906, 227, 2, 'Capacitor', ' ');
INSERT INTO answer VALUES (908, 227, 3, 'Diode', ' ');
INSERT INTO answer VALUES (912, 228, 0, 'Inductor', ' ');
INSERT INTO answer VALUES (909, 228, 1, 'Switch', ' ');
INSERT INTO answer VALUES (910, 228, 2, 'Capacitor', ' ');
INSERT INTO answer VALUES (911, 228, 3, 'Diode', ' ');
INSERT INTO answer VALUES (914, 229, 0, 'Switch', ' ');
INSERT INTO answer VALUES (913, 229, 1, 'Magnetron', ' ');
INSERT INTO answer VALUES (915, 229, 2, 'Thermistor', ' ');
INSERT INTO answer VALUES (916, 229, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (917, 230, 0, 'Fuse', ' ');
INSERT INTO answer VALUES (918, 230, 1, 'Capacitor', ' ');
INSERT INTO answer VALUES (919, 230, 2, 'Inductor', ' ');
INSERT INTO answer VALUES (920, 230, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (924, 231, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (921, 231, 1, 'Nickel-metal hydride', ' ');
INSERT INTO answer VALUES (922, 231, 2, 'Lithium-ion', ' ');
INSERT INTO answer VALUES (923, 231, 3, 'Lead-acid gel-cell', ' ');
INSERT INTO answer VALUES (926, 232, 0, 'Carbon-zinc', ' ');
INSERT INTO answer VALUES (925, 232, 1, 'Nickel-cadmium', ' ');
INSERT INTO answer VALUES (927, 232, 2, 'Lead-acid', ' ');
INSERT INTO answer VALUES (928, 232, 3, 'Lithium-ion', ' ');
INSERT INTO answer VALUES (932, 233, 0, 'Transistors', ' ');
INSERT INTO answer VALUES (929, 233, 1, 'Capacitors', ' ');
INSERT INTO answer VALUES (930, 233, 2, 'Inductors', ' ');
INSERT INTO answer VALUES (931, 233, 3, 'Resistors', ' ');
INSERT INTO answer VALUES (935, 234, 0, 'Diode', ' ');
INSERT INTO answer VALUES (933, 234, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (934, 234, 2, 'Fuse', ' ');
INSERT INTO answer VALUES (936, 234, 3, 'Driven element', ' ');
INSERT INTO answer VALUES (939, 235, 0, 'Transistor', ' ');
INSERT INTO answer VALUES (937, 235, 1, 'Oscillator', ' ');
INSERT INTO answer VALUES (938, 235, 2, 'Potentiometer', ' ');
INSERT INTO answer VALUES (940, 235, 3, 'Voltmeter', ' ');
INSERT INTO answer VALUES (942, 236, 0, 'Transistor', ' ');
INSERT INTO answer VALUES (941, 236, 1, 'Alternator', ' ');
INSERT INTO answer VALUES (943, 236, 2, 'Triode', ' ');
INSERT INTO answer VALUES (944, 236, 3, 'Pentagrid converter', ' ');
INSERT INTO answer VALUES (945, 237, 0, 'Transistor', ' ');
INSERT INTO answer VALUES (946, 237, 1, 'Variable resistor', ' ');
INSERT INTO answer VALUES (947, 237, 2, 'Electrolytic capacitor', ' ');
INSERT INTO answer VALUES (948, 237, 3, 'Multi-cell battery', ' ');
INSERT INTO answer VALUES (950, 238, 0, 'With a stripe', ' ');
INSERT INTO answer VALUES (949, 238, 1, 'With the word "cathode"', ' ');
INSERT INTO answer VALUES (951, 238, 2, 'With the letter C', ' ');
INSERT INTO answer VALUES (952, 238, 3, 'With the letter K', ' ');
INSERT INTO answer VALUES (954, 239, 0, 'Light Emitting Diode', ' ');
INSERT INTO answer VALUES (953, 239, 1, 'Low Emission Diode', ' ');
INSERT INTO answer VALUES (955, 239, 2, 'Liquid Emission Detector', ' ');
INSERT INTO answer VALUES (956, 239, 3, 'Long Echo Delay', ' ');
INSERT INTO answer VALUES (957, 240, 0, 'Field Effect Transistor', ' ');
INSERT INTO answer VALUES (958, 240, 1, 'Fast Electron Transistor', ' ');
INSERT INTO answer VALUES (959, 240, 2, 'Free Electron Transmitter', ' ');
INSERT INTO answer VALUES (960, 240, 3, 'Frequency Emission Transmitter', ' ');
INSERT INTO answer VALUES (963, 241, 0, 'Anode and cathode', ' ');
INSERT INTO answer VALUES (961, 241, 1, 'Plus and minus', ' ');
INSERT INTO answer VALUES (962, 241, 2, 'Source and drain', ' ');
INSERT INTO answer VALUES (964, 241, 3, 'Gate and base', ' ');
INSERT INTO answer VALUES (966, 242, 0, 'Transistor', ' ');
INSERT INTO answer VALUES (965, 242, 1, 'Transformer', ' ');
INSERT INTO answer VALUES (967, 242, 2, 'Reactor', ' ');
INSERT INTO answer VALUES (968, 242, 3, 'Resistor', ' ');
INSERT INTO answer VALUES (969, 243, 0, 'Gain', ' ');
INSERT INTO answer VALUES (970, 243, 1, 'Forward resistance', ' ');
INSERT INTO answer VALUES (971, 243, 2, 'Forward voltage drop', ' ');
INSERT INTO answer VALUES (972, 243, 3, 'On resistance', ' ');
INSERT INTO answer VALUES (975, 244, 0, 'Schematic', ' ');
INSERT INTO answer VALUES (973, 244, 1, 'Bill of materials', ' ');
INSERT INTO answer VALUES (974, 244, 2, 'Connector pinout', ' ');
INSERT INTO answer VALUES (976, 244, 3, 'Flow chart', ' ');
INSERT INTO answer VALUES (977, 245, 0, 'Resistor', ' ');
INSERT INTO answer VALUES (978, 245, 1, 'Transistor', ' ');
INSERT INTO answer VALUES (979, 245, 2, 'Battery', ' ');
INSERT INTO answer VALUES (980, 245, 3, 'Connector', ' ');
INSERT INTO answer VALUES (982, 246, 0, 'Transistor', ' ');
INSERT INTO answer VALUES (981, 246, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (983, 246, 2, 'Indicator lamp', ' ');
INSERT INTO answer VALUES (984, 246, 3, 'Connector', ' ');
INSERT INTO answer VALUES (987, 247, 0, 'Lamp', ' ');
INSERT INTO answer VALUES (985, 247, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (986, 247, 2, 'Transistor', ' ');
INSERT INTO answer VALUES (988, 247, 3, 'Ground symbol', ' ');
INSERT INTO answer VALUES (991, 248, 0, 'Battery', ' ');
INSERT INTO answer VALUES (989, 248, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (990, 248, 2, 'Transistor', ' ');
INSERT INTO answer VALUES (992, 248, 3, 'Ground symbol', ' ');
INSERT INTO answer VALUES (994, 249, 0, 'Capacitor', ' ');
INSERT INTO answer VALUES (993, 249, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (995, 249, 2, 'Regulator IC', ' ');
INSERT INTO answer VALUES (996, 249, 3, 'Transistor', ' ');
INSERT INTO answer VALUES (1000, 250, 0, 'Light emitting diode', ' ');
INSERT INTO answer VALUES (997, 250, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (998, 250, 2, 'Inductor', ' ');
INSERT INTO answer VALUES (999, 250, 3, 'Regulator IC', ' ');
INSERT INTO answer VALUES (1003, 251, 0, 'Variable resistor', ' ');
INSERT INTO answer VALUES (1001, 251, 1, 'Variable capacitor', ' ');
INSERT INTO answer VALUES (1002, 251, 2, 'Variable inductor', ' ');
INSERT INTO answer VALUES (1004, 251, 3, 'Variable transformer', ' ');
INSERT INTO answer VALUES (1008, 252, 0, 'Transformer', ' ');
INSERT INTO answer VALUES (1005, 252, 1, 'Variable inductor', ' ');
INSERT INTO answer VALUES (1006, 252, 2, 'Double-pole switch', ' ');
INSERT INTO answer VALUES (1007, 252, 3, 'Potentiometer', ' ');
INSERT INTO answer VALUES (1012, 253, 0, 'Variable inductor', ' ');
INSERT INTO answer VALUES (1009, 253, 1, 'Connector', ' ');
INSERT INTO answer VALUES (1010, 253, 2, 'Meter', ' ');
INSERT INTO answer VALUES (1011, 253, 3, 'Variable capacitor', ' ');
INSERT INTO answer VALUES (1013, 254, 0, 'Antenna', ' ');
INSERT INTO answer VALUES (1014, 254, 1, 'Transmitter', ' ');
INSERT INTO answer VALUES (1015, 254, 2, 'Dummy load', ' ');
INSERT INTO answer VALUES (1016, 254, 3, 'Ground', ' ');
INSERT INTO answer VALUES (1017, 255, 0, 'Electrical components', ' ');
INSERT INTO answer VALUES (1018, 255, 1, 'Logic states', ' ');
INSERT INTO answer VALUES (1019, 255, 2, 'Digital codes', ' ');
INSERT INTO answer VALUES (1020, 255, 3, 'Traffic nodes', ' ');
INSERT INTO answer VALUES (1023, 256, 0, 'The way components are interconnected', ' ');
INSERT INTO answer VALUES (1021, 256, 1, 'Wire lengths', ' ');
INSERT INTO answer VALUES (1022, 256, 2, 'Physical appearance of components', ' ');
INSERT INTO answer VALUES (1024, 256, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1026, 257, 0, 'Rectifier', ' ');
INSERT INTO answer VALUES (1025, 257, 1, 'Transformer', ' ');
INSERT INTO answer VALUES (1027, 257, 2, 'Amplifier', ' ');
INSERT INTO answer VALUES (1028, 257, 3, 'Reflector', ' ');
INSERT INTO answer VALUES (1029, 258, 0, 'An electrically-controlled switch', ' ');
INSERT INTO answer VALUES (1030, 258, 1, 'A current controlled amplifier', ' ');
INSERT INTO answer VALUES (1031, 258, 2, 'An optical sensor', ' ');
INSERT INTO answer VALUES (1032, 258, 3, 'A pass transistor', ' ');
INSERT INTO answer VALUES (1033, 259, 0, 'Single-pole single-throw', ' ');
INSERT INTO answer VALUES (1034, 259, 1, 'Single-pole double-throw', ' ');
INSERT INTO answer VALUES (1035, 259, 2, 'Double-pole single-throw', ' ');
INSERT INTO answer VALUES (1036, 259, 3, 'Double-pole double-throw', ' ');
INSERT INTO answer VALUES (1039, 260, 0, 'Meter', ' ');
INSERT INTO answer VALUES (1037, 260, 1, 'Potentiometer', ' ');
INSERT INTO answer VALUES (1038, 260, 2, 'Transistor', ' ');
INSERT INTO answer VALUES (1040, 260, 3, 'Relay', ' ');
INSERT INTO answer VALUES (1041, 261, 0, 'Regulator', ' ');
INSERT INTO answer VALUES (1042, 261, 1, 'Oscillator', ' ');
INSERT INTO answer VALUES (1043, 261, 2, 'Filter', ' ');
INSERT INTO answer VALUES (1044, 261, 3, 'Phase inverter', ' ');
INSERT INTO answer VALUES (1046, 262, 0, 'Transformer', ' ');
INSERT INTO answer VALUES (1045, 262, 1, 'Variable capacitor', ' ');
INSERT INTO answer VALUES (1047, 262, 2, 'Transistor', ' ');
INSERT INTO answer VALUES (1048, 262, 3, 'Diode', ' ');
INSERT INTO answer VALUES (1049, 263, 0, 'LED', ' ');
INSERT INTO answer VALUES (1050, 263, 1, 'FET', ' ');
INSERT INTO answer VALUES (1051, 263, 2, 'Zener diode', ' ');
INSERT INTO answer VALUES (1052, 263, 3, 'Bipolar transistor', ' ');
INSERT INTO answer VALUES (1056, 264, 0, 'Capacitor', ' ');
INSERT INTO answer VALUES (1053, 264, 1, 'Resistor', ' ');
INSERT INTO answer VALUES (1054, 264, 2, 'Zener diode', ' ');
INSERT INTO answer VALUES (1055, 264, 3, 'Potentiometer', ' ');
INSERT INTO answer VALUES (1059, 265, 0, 'Integrated circuit', ' ');
INSERT INTO answer VALUES (1057, 265, 1, 'Transducer', ' ');
INSERT INTO answer VALUES (1058, 265, 2, 'Multi-pole relay', ' ');
INSERT INTO answer VALUES (1060, 265, 3, 'Transformer', ' ');
INSERT INTO answer VALUES (1063, 266, 0, 'Control the flow of current', ' ');
INSERT INTO answer VALUES (1061, 266, 1, 'Give off light when current flows through it', ' ');
INSERT INTO answer VALUES (1062, 266, 2, 'Supply electrical energy', ' ');
INSERT INTO answer VALUES (1064, 266, 3, 'Convert electrical energy into radio waves', ' ');
INSERT INTO answer VALUES (1065, 267, 0, 'An inductor and a capacitor connected in series or parallel to form a filter', ' ');
INSERT INTO answer VALUES (1066, 267, 1, 'A type of voltage regulator', ' ');
INSERT INTO answer VALUES (1067, 267, 2, 'A resistor circuit used for reducing standing wave ratio', ' ');
INSERT INTO answer VALUES (1068, 267, 3, 'A circuit designed to provide high-fidelity audio', ' ');
INSERT INTO answer VALUES (1071, 268, 0, 'To prevent coupling of unwanted signals to or from the wire', ' ');
INSERT INTO answer VALUES (1069, 268, 1, 'To decrease the resistance of DC power connections', ' ');
INSERT INTO answer VALUES (1070, 268, 2, 'To increase the current carrying capability of the wire', ' ');
INSERT INTO answer VALUES (1072, 268, 3, 'To couple the wire to other signals', ' ');
INSERT INTO answer VALUES (1074, 269, 0, 'Sensitivity', ' ');
INSERT INTO answer VALUES (1073, 269, 1, 'Linearity', ' ');
INSERT INTO answer VALUES (1075, 269, 2, 'Selectivity', ' ');
INSERT INTO answer VALUES (1076, 269, 3, 'Total Harmonic Distortion', ' ');
INSERT INTO answer VALUES (1078, 270, 0, 'A unit combining the functions of a transmitter and a receiver', ' ');
INSERT INTO answer VALUES (1077, 270, 1, 'A type of antenna switch', ' ');
INSERT INTO answer VALUES (1079, 270, 2, 'A component in a repeater that filters out unwanted interference', ' ');
INSERT INTO answer VALUES (1080, 270, 3, 'A type of antenna matching network', ' ');
INSERT INTO answer VALUES (1082, 271, 0, 'Mixer', ' ');
INSERT INTO answer VALUES (1081, 271, 1, 'Phase splitter', ' ');
INSERT INTO answer VALUES (1083, 271, 2, 'Inverter', ' ');
INSERT INTO answer VALUES (1084, 271, 3, 'Amplifier', ' ');
INSERT INTO answer VALUES (1087, 272, 0, 'Selectivity', ' ');
INSERT INTO answer VALUES (1085, 272, 1, 'Discrimination ratio', ' ');
INSERT INTO answer VALUES (1086, 272, 2, 'Sensitivity', ' ');
INSERT INTO answer VALUES (1088, 272, 3, 'Harmonic distortion', ' ');
INSERT INTO answer VALUES (1092, 273, 0, 'Oscillator', ' ');
INSERT INTO answer VALUES (1089, 273, 1, 'Reactance modulator', ' ');
INSERT INTO answer VALUES (1090, 273, 2, 'Product detector', ' ');
INSERT INTO answer VALUES (1091, 273, 3, 'Low-pass filter', ' ');
INSERT INTO answer VALUES (1095, 274, 0, 'Transverter', ' ');
INSERT INTO answer VALUES (1093, 274, 1, 'High-pass filter', ' ');
INSERT INTO answer VALUES (1094, 274, 2, 'Low-pass filter', ' ');
INSERT INTO answer VALUES (1096, 274, 3, 'Phase converter', ' ');
INSERT INTO answer VALUES (1100, 275, 0, 'The push-to-talk function that switches between receive and transmit', ' ');
INSERT INTO answer VALUES (1097, 275, 1, 'Pre-transmission tuning to reduce transmitter harmonic emission', ' ');
INSERT INTO answer VALUES (1098, 275, 2, 'Precise tone transmissions used to limit repeater access to only certain signals', ' ');
INSERT INTO answer VALUES (1099, 275, 3, 'A primary transformer tuner use to match antennas', ' ');
INSERT INTO answer VALUES (1103, 276, 0, 'Modulation', ' ');
INSERT INTO answer VALUES (1101, 276, 1, 'Impedance matching', ' ');
INSERT INTO answer VALUES (1102, 276, 2, 'Oscillation', ' ');
INSERT INTO answer VALUES (1104, 276, 3, 'Low-pass filtering', ' ');
INSERT INTO answer VALUES (1106, 277, 0, 'Set the amplifier for proper operation in the selected mode', ' ');
INSERT INTO answer VALUES (1105, 277, 1, 'Change the mode of the transmitted signal', ' ');
INSERT INTO answer VALUES (1107, 277, 2, 'Change the frequency range of the amplifier to operate in the proper portion of the band', ' ');
INSERT INTO answer VALUES (1108, 277, 3, 'Reduce the received signal noise', ' ');
INSERT INTO answer VALUES (1110, 278, 0, 'An RF power amplifier', ' ');
INSERT INTO answer VALUES (1109, 278, 1, 'A voltage divider', ' ');
INSERT INTO answer VALUES (1111, 278, 2, 'An impedance network', ' ');
INSERT INTO answer VALUES (1112, 278, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1113, 279, 0, 'Between the antenna and receiver', ' ');
INSERT INTO answer VALUES (1114, 279, 1, 'At the output of the transmitter''s power amplifier', ' ');
INSERT INTO answer VALUES (1115, 279, 2, 'Between a transmitter and antenna tuner', ' ');
INSERT INTO answer VALUES (1116, 279, 3, 'At the receiver''s audio output', ' ');
INSERT INTO answer VALUES (1120, 280, 0, 'Talk farther away from the microphone', ' ');
INSERT INTO answer VALUES (1117, 280, 1, 'Talk louder into the microphone', ' ');
INSERT INTO answer VALUES (1118, 280, 2, 'Let the transceiver cool off', ' ');
INSERT INTO answer VALUES (1119, 280, 3, 'Change to a higher power level', ' ');
INSERT INTO answer VALUES (1121, 281, 0, 'The receiver is unable to reject strong signals outside the AM or FM band', ' ');
INSERT INTO answer VALUES (1122, 281, 1, 'The microphone gain of the transmitter is turned up too high', ' ');
INSERT INTO answer VALUES (1123, 281, 2, 'The audio amplifier of the transmitter is overloaded', ' ');
INSERT INTO answer VALUES (1124, 281, 3, 'The deviation of an FM transmitter is set too low', ' ');
INSERT INTO answer VALUES (1128, 282, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1125, 282, 1, 'Fundamental overload', ' ');
INSERT INTO answer VALUES (1126, 282, 2, 'Harmonics', ' ');
INSERT INTO answer VALUES (1127, 282, 3, 'Spurious emissions', ' ');
INSERT INTO answer VALUES (1132, 283, 0, 'Put an RF filter on the telephone', ' ');
INSERT INTO answer VALUES (1129, 283, 1, 'Put a filter on the amateur transmitter', ' ');
INSERT INTO answer VALUES (1130, 283, 2, 'Reduce the microphone gain', ' ');
INSERT INTO answer VALUES (1131, 283, 3, 'Reduce the SWR on the transmitter transmission line', ' ');
INSERT INTO answer VALUES (1133, 284, 0, 'Block the amateur signal with a filter at the antenna input of the affected receiver', ' ');
INSERT INTO answer VALUES (1134, 284, 1, 'Block the interfering signal with a filter on the amateur transmitter', ' ');
INSERT INTO answer VALUES (1135, 284, 2, 'Switch the transmitter from FM to SSB', ' ');
INSERT INTO answer VALUES (1136, 284, 3, 'Switch the transmitter to a narrow-band mode', ' ');
INSERT INTO answer VALUES (1137, 285, 0, 'Make sure that your station is functioning properly and that it does not cause interference to your own radio or television when it is tuned to the same channel', ' ');
INSERT INTO answer VALUES (1138, 285, 1, 'Immediately turn off your transmitter and contact the nearest FCC office for assistance', ' ');
INSERT INTO answer VALUES (1139, 285, 2, 'Tell them that your license gives you the right to transmit and nothing can be done to reduce the interference', ' ');
INSERT INTO answer VALUES (1140, 285, 3, 'Install a harmonic doubler on the output of your transmitter and tune it until the interference is eliminated', ' ');
INSERT INTO answer VALUES (1144, 286, 0, 'Band-reject filter', ' ');
INSERT INTO answer VALUES (1141, 286, 1, 'RF preamplifier', ' ');
INSERT INTO answer VALUES (1142, 286, 2, 'Double-shielded coaxial cable', ' ');
INSERT INTO answer VALUES (1143, 286, 3, 'Using headphones instead of the speaker', ' ');
INSERT INTO answer VALUES (1148, 287, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1145, 287, 1, 'Work with your neighbor to identify the offending device', ' ');
INSERT INTO answer VALUES (1146, 287, 2, 'Politely inform your neighbor about the rules that prohibit the use of devices that cause interference', ' ');
INSERT INTO answer VALUES (1147, 287, 3, 'Check your station and make sure it meets the standards of good amateur practice', ' ');
INSERT INTO answer VALUES (1149, 288, 0, 'An unlicensed device that may emit low-powered radio signals on frequencies used by a licensed service', ' ');
INSERT INTO answer VALUES (1150, 288, 1, 'An amplifier that has been type-certified for amateur radio', ' ');
INSERT INTO answer VALUES (1151, 288, 2, 'A device for long-distance communications using special codes sanctioned by the International Amateur Radio Union', ' ');
INSERT INTO answer VALUES (1152, 288, 3, 'A type of test set used to determine whether a transmitter complies with FCC regulation 91.15', ' ');
INSERT INTO answer VALUES (1156, 289, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1153, 289, 1, 'Your transmitter is slightly off frequency', ' ');
INSERT INTO answer VALUES (1154, 289, 2, 'Your batteries are running low', ' ');
INSERT INTO answer VALUES (1155, 289, 3, 'You are in a bad location', ' ');
INSERT INTO answer VALUES (1159, 290, 0, 'Reports of garbled, distorted, or unintelligible voice transmissions', ' ');
INSERT INTO answer VALUES (1157, 290, 1, 'Excessive SWR at the antenna connection', ' ');
INSERT INTO answer VALUES (1158, 290, 2, 'The transmitter will not stay on the desired frequency', ' ');
INSERT INTO answer VALUES (1160, 290, 3, 'Frequent blowing of power supply fuses', ' ');
INSERT INTO answer VALUES (1164, 291, 0, 'Be sure all TV coaxial connectors are installed properly', ' ');
INSERT INTO answer VALUES (1161, 291, 1, 'Add a low-pass filter to the TV antenna input', ' ');
INSERT INTO answer VALUES (1162, 291, 2, 'Add a high-pass filter to the TV antenna input', ' ');
INSERT INTO answer VALUES (1163, 291, 3, 'Add a preamplifier to the TV antenna input', ' ');
INSERT INTO answer VALUES (1165, 292, 0, 'To prevent transmitting signals over the air when making tests', ' ');
INSERT INTO answer VALUES (1166, 292, 1, 'To prevent over-modulation of a transmitter', ' ');
INSERT INTO answer VALUES (1167, 292, 2, 'To improve the efficiency of an antenna', ' ');
INSERT INTO answer VALUES (1168, 292, 3, 'To improve the signal-to-noise ratio of a receiver', ' ');
INSERT INTO answer VALUES (1170, 293, 0, 'An antenna analyzer', ' ');
INSERT INTO answer VALUES (1169, 293, 1, 'A VTVM', ' ');
INSERT INTO answer VALUES (1171, 293, 2, 'A Q meter', ' ');
INSERT INTO answer VALUES (1172, 293, 3, 'A frequency counter', ' ');
INSERT INTO answer VALUES (1173, 294, 0, 'A measure of how well a load is matched to a transmission line', ' ');
INSERT INTO answer VALUES (1174, 294, 1, 'The ratio of high to low impedance in a feed line', ' ');
INSERT INTO answer VALUES (1175, 294, 2, 'The transmitter efficiency ratio', ' ');
INSERT INTO answer VALUES (1176, 294, 3, 'An indication of the quality of your station’s ground connection', ' ');
INSERT INTO answer VALUES (1179, 295, 0, '1 to 1', ' ');
INSERT INTO answer VALUES (1177, 295, 1, '2 to 1', ' ');
INSERT INTO answer VALUES (1178, 295, 2, '1 to 3', ' ');
INSERT INTO answer VALUES (1180, 295, 3, '10 to 1', ' ');
INSERT INTO answer VALUES (1181, 296, 0, 'To protect the output amplifier transistors', ' ');
INSERT INTO answer VALUES (1182, 296, 1, 'To comply with FCC rules on spectral purity', ' ');
INSERT INTO answer VALUES (1183, 296, 2, 'Because power supplies cannot supply enough current at high SWR', ' ');
INSERT INTO answer VALUES (1184, 296, 3, 'To improve the impedance match to the feed line', ' ');
INSERT INTO answer VALUES (1188, 297, 0, 'Impedance mismatch', ' ');
INSERT INTO answer VALUES (1185, 297, 1, 'Loss of -4 dB', ' ');
INSERT INTO answer VALUES (1186, 297, 2, 'Good impedance match', ' ');
INSERT INTO answer VALUES (1187, 297, 3, 'Gain of +4 dB', ' ');
INSERT INTO answer VALUES (1191, 298, 0, 'It is converted into heat', ' ');
INSERT INTO answer VALUES (1189, 298, 1, 'It increases the SWR', ' ');
INSERT INTO answer VALUES (1190, 298, 2, 'It comes back into your transmitter and could cause damage', ' ');
INSERT INTO answer VALUES (1192, 298, 3, 'It can cause distortion of your signal', ' ');
INSERT INTO answer VALUES (1196, 299, 0, 'Directional wattmeter', ' ');
INSERT INTO answer VALUES (1193, 299, 1, 'Voltmeter', ' ');
INSERT INTO answer VALUES (1194, 299, 2, 'Ohmmeter', ' ');
INSERT INTO answer VALUES (1195, 299, 3, 'Iambic pentameter', ' ');
INSERT INTO answer VALUES (1197, 300, 0, 'Moisture contamination', ' ');
INSERT INTO answer VALUES (1198, 300, 1, 'Gamma rays', ' ');
INSERT INTO answer VALUES (1199, 300, 2, 'The velocity factor exceeds 1.0', ' ');
INSERT INTO answer VALUES (1200, 300, 3, 'Overloading', ' ');
INSERT INTO answer VALUES (1204, 301, 0, 'Ultraviolet light can damage the jacket and allow water to enter the cable', ' ');
INSERT INTO answer VALUES (1201, 301, 1, 'Ultraviolet resistant jackets prevent harmonic radiation', ' ');
INSERT INTO answer VALUES (1202, 301, 2, 'Ultraviolet light can increase losses in the cable’s jacket', ' ');
INSERT INTO answer VALUES (1203, 301, 3, 'Ultraviolet and RF signals can mix, causing interference', ' ');
INSERT INTO answer VALUES (1207, 302, 0, 'It requires special techniques to prevent water absorption', ' ');
INSERT INTO answer VALUES (1205, 302, 1, 'It has more loss per foot', ' ');
INSERT INTO answer VALUES (1206, 302, 2, 'It cannot be used for VHF or UHF antennas', ' ');
INSERT INTO answer VALUES (1208, 302, 3, 'It cannot be used at below freezing temperatures', ' ');
INSERT INTO answer VALUES (1210, 303, 0, 'A non-inductive resistor and a heat sink', ' ');
INSERT INTO answer VALUES (1209, 303, 1, 'A high-gain amplifier and a TR switch', ' ');
INSERT INTO answer VALUES (1211, 303, 2, 'A low-voltage power supply and a DC relay', ' ');
INSERT INTO answer VALUES (1212, 303, 3, 'A 50 ohm reactance used to terminate a transmission line', ' ');
INSERT INTO answer VALUES (1214, 304, 0, 'A voltmeter', ' ');
INSERT INTO answer VALUES (1213, 304, 1, 'An ammeter', ' ');
INSERT INTO answer VALUES (1215, 304, 2, 'A wavemeter', ' ');
INSERT INTO answer VALUES (1216, 304, 3, 'An ohmmeter', ' ');
INSERT INTO answer VALUES (1218, 305, 0, 'In parallel with the circuit', ' ');
INSERT INTO answer VALUES (1217, 305, 1, 'In series with the circuit', ' ');
INSERT INTO answer VALUES (1219, 305, 2, 'In quadrature with the circuit', ' ');
INSERT INTO answer VALUES (1220, 305, 3, 'In phase with the circuit', ' ');
INSERT INTO answer VALUES (1221, 306, 0, 'In series with the circuit', ' ');
INSERT INTO answer VALUES (1222, 306, 1, 'In parallel with the circuit', ' ');
INSERT INTO answer VALUES (1223, 306, 2, 'In quadrature with the circuit', ' ');
INSERT INTO answer VALUES (1224, 306, 3, 'In phase with the circuit', ' ');
INSERT INTO answer VALUES (1228, 307, 0, 'An ammeter', ' ');
INSERT INTO answer VALUES (1225, 307, 1, 'An ohmmeter', ' ');
INSERT INTO answer VALUES (1226, 307, 2, 'A wavemeter', ' ');
INSERT INTO answer VALUES (1227, 307, 3, 'A voltmeter', ' ');
INSERT INTO answer VALUES (1232, 308, 0, 'An ohmmeter', ' ');
INSERT INTO answer VALUES (1229, 308, 1, 'An oscilloscope', ' ');
INSERT INTO answer VALUES (1230, 308, 2, 'A spectrum analyzer', ' ');
INSERT INTO answer VALUES (1231, 308, 3, 'A noise bridge', ' ');
INSERT INTO answer VALUES (1235, 309, 0, 'Attempting to measure voltage when using the resistance setting', ' ');
INSERT INTO answer VALUES (1233, 309, 1, 'Measuring a voltage too small for the chosen scale', ' ');
INSERT INTO answer VALUES (1234, 309, 2, 'Leaving the meter in the milliamps position overnight', ' ');
INSERT INTO answer VALUES (1236, 309, 3, 'Not allowing it to warm up properly', ' ');
INSERT INTO answer VALUES (1240, 310, 0, 'Voltage and resistance', ' ');
INSERT INTO answer VALUES (1237, 310, 1, 'SWR and RF power', ' ');
INSERT INTO answer VALUES (1238, 310, 2, 'Signal strength and noise', ' ');
INSERT INTO answer VALUES (1239, 310, 3, 'Impedance and reactance', ' ');
INSERT INTO answer VALUES (1243, 311, 0, 'Rosin-core solder', ' ');
INSERT INTO answer VALUES (1241, 311, 1, 'Acid-core solder', ' ');
INSERT INTO answer VALUES (1242, 311, 2, 'Silver solder', ' ');
INSERT INTO answer VALUES (1244, 311, 3, 'Aluminum solder', ' ');
INSERT INTO answer VALUES (1247, 312, 0, 'A grainy or dull surface', ' ');
INSERT INTO answer VALUES (1245, 312, 1, 'Dark black spots', ' ');
INSERT INTO answer VALUES (1246, 312, 2, 'A bright or shiny surface', ' ');
INSERT INTO answer VALUES (1248, 312, 3, 'A greenish tint', ' ');
INSERT INTO answer VALUES (1250, 313, 0, 'The circuit contains a large capacitor', ' ');
INSERT INTO answer VALUES (1249, 313, 1, 'The ohmmeter is defective', ' ');
INSERT INTO answer VALUES (1251, 313, 2, 'The circuit contains a large inductor', ' ');
INSERT INTO answer VALUES (1252, 313, 3, 'The circuit is a relaxation oscillator', ' ');
INSERT INTO answer VALUES (1254, 314, 0, 'Ensure that the circuit is not powered', ' ');
INSERT INTO answer VALUES (1253, 314, 1, 'Ensure that the applied voltages are correct', ' ');
INSERT INTO answer VALUES (1255, 314, 2, 'Ensure that the circuit is grounded', ' ');
INSERT INTO answer VALUES (1256, 314, 3, 'Ensure that the circuit is operating at the correct frequency', ' ');
INSERT INTO answer VALUES (1258, 315, 0, 'Ensure that the voltmeter and leads are rated for use at the voltages to be measured', ' ');
INSERT INTO answer VALUES (1257, 315, 1, 'Ensure that the voltmeter has very low impedance', ' ');
INSERT INTO answer VALUES (1259, 315, 2, 'Ensure that the circuit is grounded through the voltmeter', ' ');
INSERT INTO answer VALUES (1260, 315, 3, 'Ensure that the voltmeter is set to the correct frequency', ' ');
INSERT INTO answer VALUES (1263, 316, 0, 'Single sideband', ' ');
INSERT INTO answer VALUES (1261, 316, 1, 'Spread spectrum', ' ');
INSERT INTO answer VALUES (1262, 316, 2, 'Packet radio', ' ');
INSERT INTO answer VALUES (1264, 316, 3, 'Phase shift keying (PSK)', ' ');
INSERT INTO answer VALUES (1265, 317, 0, 'FM', ' ');
INSERT INTO answer VALUES (1266, 317, 1, 'SSB', ' ');
INSERT INTO answer VALUES (1267, 317, 2, 'AM', ' ');
INSERT INTO answer VALUES (1268, 317, 3, 'PSK', ' ');
INSERT INTO answer VALUES (1271, 318, 0, 'SSB', ' ');
INSERT INTO answer VALUES (1269, 318, 1, 'FM', ' ');
INSERT INTO answer VALUES (1270, 318, 2, 'DRM', ' ');
INSERT INTO answer VALUES (1272, 318, 3, 'PM', ' ');
INSERT INTO answer VALUES (1276, 319, 0, 'FM', ' ');
INSERT INTO answer VALUES (1273, 319, 1, 'AM', ' ');
INSERT INTO answer VALUES (1274, 319, 2, 'SSB', ' ');
INSERT INTO answer VALUES (1275, 319, 3, 'PSK', ' ');
INSERT INTO answer VALUES (1279, 320, 0, 'CW', ' ');
INSERT INTO answer VALUES (1277, 320, 1, 'FM voice', ' ');
INSERT INTO answer VALUES (1278, 320, 2, 'SSB voice', ' ');
INSERT INTO answer VALUES (1280, 320, 3, 'Slow-scan TV', ' ');
INSERT INTO answer VALUES (1281, 321, 0, 'Upper sideband', ' ');
INSERT INTO answer VALUES (1282, 321, 1, 'Lower sideband', ' ');
INSERT INTO answer VALUES (1283, 321, 2, 'Suppressed sideband', ' ');
INSERT INTO answer VALUES (1284, 321, 3, 'Inverted sideband', ' ');
INSERT INTO answer VALUES (1287, 322, 0, 'SSB signals have narrower bandwidth', ' ');
INSERT INTO answer VALUES (1285, 322, 1, 'SSB signals are easier to tune', ' ');
INSERT INTO answer VALUES (1286, 322, 2, 'SSB signals are less susceptible to interference', ' ');
INSERT INTO answer VALUES (1288, 322, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1290, 323, 0, '3 kHz', ' ');
INSERT INTO answer VALUES (1289, 323, 1, '1 kHz', ' ');
INSERT INTO answer VALUES (1291, 323, 2, '6 kHz', ' ');
INSERT INTO answer VALUES (1292, 323, 3, '15 kHz', ' ');
INSERT INTO answer VALUES (1295, 324, 0, 'Between 10 and 15 kHz', ' ');
INSERT INTO answer VALUES (1293, 324, 1, 'Less than 500 Hz', ' ');
INSERT INTO answer VALUES (1294, 324, 2, 'About 150 kHz', ' ');
INSERT INTO answer VALUES (1296, 324, 3, 'Between 50 and 125 kHz', ' ');
INSERT INTO answer VALUES (1298, 325, 0, 'About 6 MHz', ' ');
INSERT INTO answer VALUES (1297, 325, 1, 'More than 10 MHz', ' ');
INSERT INTO answer VALUES (1299, 325, 2, 'About 3 MHz', ' ');
INSERT INTO answer VALUES (1300, 325, 3, 'About 1 MHz', ' ');
INSERT INTO answer VALUES (1302, 326, 0, '150 Hz', ' ');
INSERT INTO answer VALUES (1301, 326, 1, '2.4 kHz', ' ');
INSERT INTO answer VALUES (1303, 326, 2, '1000 Hz', ' ');
INSERT INTO answer VALUES (1304, 326, 3, '15 kHz', ' ');
INSERT INTO answer VALUES (1307, 327, 0, 'Health and status of the satellite', ' ');
INSERT INTO answer VALUES (1305, 327, 1, 'The signal strength of received signals', ' ');
INSERT INTO answer VALUES (1306, 327, 2, 'Time of day accurate to plus or minus 1/10 second', ' ');
INSERT INTO answer VALUES (1308, 327, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1310, 328, 0, 'Blocking access by other users', ' ');
INSERT INTO answer VALUES (1309, 328, 1, 'Possibility of commanding the satellite to an improper mode', ' ');
INSERT INTO answer VALUES (1311, 328, 2, 'Overloading the satellite batteries', ' ');
INSERT INTO answer VALUES (1312, 328, 3, 'Possibility of rebooting the satellite control computer', ' ');
INSERT INTO answer VALUES (1316, 329, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1313, 329, 1, 'Maps showing the real-time position of the satellite track over the earth', ' ');
INSERT INTO answer VALUES (1314, 329, 2, 'The time, azimuth, and elevation of the start, maximum altitude, and end of a pass', ' ');
INSERT INTO answer VALUES (1315, 329, 3, 'The apparent frequency of the satellite transmission, including effects of Doppler shift', ' ');
INSERT INTO answer VALUES (1320, 330, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1317, 330, 1, 'SSB', ' ');
INSERT INTO answer VALUES (1318, 330, 2, 'FM', ' ');
INSERT INTO answer VALUES (1319, 330, 3, 'CW/data', ' ');
INSERT INTO answer VALUES (1324, 331, 0, 'A transmission from a satellite that contains status information', ' ');
INSERT INTO answer VALUES (1321, 331, 1, 'The primary transmit antenna on the satellite', ' ');
INSERT INTO answer VALUES (1322, 331, 2, 'An indicator light that shows where to point your antenna', ' ');
INSERT INTO answer VALUES (1323, 331, 3, 'A reflective surface on the satellite', ' ');
INSERT INTO answer VALUES (1326, 332, 0, 'The Keplerian elements', ' ');
INSERT INTO answer VALUES (1325, 332, 1, 'The weight of the satellite', ' ');
INSERT INTO answer VALUES (1327, 332, 2, 'The last observed time of zero Doppler shift', ' ');
INSERT INTO answer VALUES (1328, 332, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1331, 333, 0, 'An observed change in signal frequency caused by relative motion between the satellite and the earth station', ' ');
INSERT INTO answer VALUES (1329, 333, 1, 'A change in the satellite orbit', ' ');
INSERT INTO answer VALUES (1330, 333, 2, 'A mode where the satellite receives signals on one band and transmits on another', ' ');
INSERT INTO answer VALUES (1332, 333, 3, 'A special digital communications mode for some satellites', ' ');
INSERT INTO answer VALUES (1334, 334, 0, 'The satellite uplink is in the 70 centimeter band and the downlink is in the 2 meter band', ' ');
INSERT INTO answer VALUES (1333, 334, 1, 'The satellite uplink is in the 15 meter band and the downlink is in the 10 meter band', ' ');
INSERT INTO answer VALUES (1335, 334, 2, 'The satellite operates using ultraviolet frequencies', ' ');
INSERT INTO answer VALUES (1336, 334, 3, 'The satellite frequencies are usually variable', ' ');
INSERT INTO answer VALUES (1338, 335, 0, 'Rotation of the satellite and its antennas', ' ');
INSERT INTO answer VALUES (1337, 335, 1, 'Circular polarized noise interference radiated from the sun', ' ');
INSERT INTO answer VALUES (1339, 335, 2, 'Doppler shift of the received signal', ' ');
INSERT INTO answer VALUES (1340, 335, 3, 'Interfering signals within the satellite uplink band', ' ');
INSERT INTO answer VALUES (1343, 336, 0, 'The satellite is in a Low Earth Orbit', ' ');
INSERT INTO answer VALUES (1341, 336, 1, 'The satellite battery is in Low Energy Operation mode', ' ');
INSERT INTO answer VALUES (1342, 336, 2, 'The satellite is performing a Lunar Ejection Orbit maneuver', ' ');
INSERT INTO answer VALUES (1344, 336, 3, 'The satellite uses Light Emitting Optics', ' ');
INSERT INTO answer VALUES (1345, 337, 0, 'Anyone who can receive the telemetry signal', ' ');
INSERT INTO answer VALUES (1346, 337, 1, 'A licensed radio amateur with a transmitter equipped for interrogating the satellite', ' ');
INSERT INTO answer VALUES (1347, 337, 2, 'A licensed radio amateur who has been certified by the protocol developer', ' ');
INSERT INTO answer VALUES (1348, 337, 3, 'A licensed radio amateur who has registered for an access code from AMSAT', ' ');
INSERT INTO answer VALUES (1351, 338, 0, 'Your signal strength on the downlink should be about the same as the beacon', ' ');
INSERT INTO answer VALUES (1349, 338, 1, 'Check your signal strength report in the telemetry data', ' ');
INSERT INTO answer VALUES (1350, 338, 2, 'Listen for distortion on your downlink signal', ' ');
INSERT INTO answer VALUES (1352, 338, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1355, 339, 0, 'Radio direction finding', ' ');
INSERT INTO answer VALUES (1353, 339, 1, 'Echolocation', ' ');
INSERT INTO answer VALUES (1354, 339, 2, 'Doppler radar', ' ');
INSERT INTO answer VALUES (1356, 339, 3, 'Phase locking', ' ');
INSERT INTO answer VALUES (1358, 340, 0, 'A directional antenna', ' ');
INSERT INTO answer VALUES (1357, 340, 1, 'Calibrated SWR meter', ' ');
INSERT INTO answer VALUES (1359, 340, 2, 'A calibrated noise bridge', ' ');
INSERT INTO answer VALUES (1360, 340, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1361, 341, 0, 'Contesting', ' ');
INSERT INTO answer VALUES (1362, 341, 1, 'Net operations', ' ');
INSERT INTO answer VALUES (1363, 341, 2, 'Public service events', ' ');
INSERT INTO answer VALUES (1364, 341, 3, 'Simulated emergency exercises', ' ');
INSERT INTO answer VALUES (1367, 342, 0, 'Send only the minimum information needed for proper identification and the contest exchange', ' ');
INSERT INTO answer VALUES (1365, 342, 1, 'Sign only the last two letters of your call if there are many other stations calling', ' ');
INSERT INTO answer VALUES (1366, 342, 2, 'Contact the station twice to be sure that you are in his log', ' ');
INSERT INTO answer VALUES (1368, 342, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1369, 343, 0, 'A letter-number designator assigned to a geographic location', ' ');
INSERT INTO answer VALUES (1370, 343, 1, 'A letter-number designator assigned to an azimuth and elevation', ' ');
INSERT INTO answer VALUES (1371, 343, 2, 'An instrument for neutralizing a final amplifier', ' ');
INSERT INTO answer VALUES (1372, 343, 3, 'An instrument for radio direction finding', ' ');
INSERT INTO answer VALUES (1374, 344, 0, 'By using DTMF signals', ' ');
INSERT INTO answer VALUES (1373, 344, 1, 'By obtaining a password that is sent via voice to the node', ' ');
INSERT INTO answer VALUES (1375, 344, 2, 'By entering the proper internet password', ' ');
INSERT INTO answer VALUES (1376, 344, 3, 'By using CTCSS tone codes', ' ');
INSERT INTO answer VALUES (1380, 345, 0, 'A method of delivering voice communications over the internet using digital techniques', ' ');
INSERT INTO answer VALUES (1377, 345, 1, 'A set of rules specifying how to identify your station when linked over the internet to another station', ' ');
INSERT INTO answer VALUES (1378, 345, 2, 'A set of guidelines for contacting DX stations during contests using internet access', ' ');
INSERT INTO answer VALUES (1379, 345, 3, 'A technique for measuring the modulation quality of a transmitter using remote sites monitored via the internet', ' ');
INSERT INTO answer VALUES (1381, 346, 0, 'A technique to connect amateur radio systems, such as repeaters, via the internet using Voice Over Internet Protocol (VoIP)', ' ');
INSERT INTO answer VALUES (1382, 346, 1, 'A system for providing access to websites via amateur radio', ' ');
INSERT INTO answer VALUES (1383, 346, 2, 'A system for informing amateurs in real time of the frequency of active DX stations', ' ');
INSERT INTO answer VALUES (1384, 346, 3, 'A technique for measuring signal strength of an amateur transmitter via the internet', ' ');
INSERT INTO answer VALUES (1388, 347, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1385, 347, 1, 'By subscribing to an on line service', ' ');
INSERT INTO answer VALUES (1386, 347, 2, 'From on line repeater lists maintained by the local repeater frequency coordinator', ' ');
INSERT INTO answer VALUES (1387, 347, 3, 'From a repeater directory', ' ');
INSERT INTO answer VALUES (1392, 348, 0, 'You must register your call sign and provide proof of license', ' ');
INSERT INTO answer VALUES (1389, 348, 1, 'You must complete the required EchoLink training', ' ');
INSERT INTO answer VALUES (1390, 348, 2, 'You must have purchased a license to use the EchoLink software', ' ');
INSERT INTO answer VALUES (1391, 348, 3, 'You must be sponsored by a current EchoLink user', ' ');
INSERT INTO answer VALUES (1393, 349, 0, 'A gateway', ' ');
INSERT INTO answer VALUES (1394, 349, 1, 'A repeater', ' ');
INSERT INTO answer VALUES (1395, 349, 2, 'A digipeater', ' ');
INSERT INTO answer VALUES (1396, 349, 3, 'A beacon', ' ');
INSERT INTO answer VALUES (1400, 350, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1397, 350, 1, 'Packet radio', ' ');
INSERT INTO answer VALUES (1398, 350, 2, 'IEEE 802.11', ' ');
INSERT INTO answer VALUES (1399, 350, 3, 'JT65', ' ');
INSERT INTO answer VALUES (1401, 351, 0, 'Automatic Packet Reporting System', ' ');
INSERT INTO answer VALUES (1402, 351, 1, 'Associated Public Radio Station', ' ');
INSERT INTO answer VALUES (1403, 351, 2, 'Auto Planning Radio Set-up', ' ');
INSERT INTO answer VALUES (1404, 351, 3, 'Advanced Polar Radio System', ' ');
INSERT INTO answer VALUES (1408, 352, 0, 'A Global Positioning System receiver', ' ');
INSERT INTO answer VALUES (1405, 352, 1, 'The vehicle speedometer', ' ');
INSERT INTO answer VALUES (1406, 352, 2, 'A WWV receiver', ' ');
INSERT INTO answer VALUES (1407, 352, 3, 'A connection to a broadcast FM sub-carrier receiver', ' ');
INSERT INTO answer VALUES (1411, 353, 0, 'An analog fast scan color TV signal', ' ');
INSERT INTO answer VALUES (1409, 353, 1, 'A Normal Transmission mode in Static Circuit', ' ');
INSERT INTO answer VALUES (1410, 353, 2, 'A special mode for earth satellite uplink', ' ');
INSERT INTO answer VALUES (1412, 353, 3, 'A frame compression scheme for TV signals', ' ');
INSERT INTO answer VALUES (1413, 354, 0, 'Providing real-time tactical digital communications in conjunction with a map showing the locations of stations', ' ');
INSERT INTO answer VALUES (1414, 354, 1, 'Showing automatically the number of packets transmitted via PACTOR during a specific time interval', ' ');
INSERT INTO answer VALUES (1415, 354, 2, 'Providing voice over internet connection between repeaters', ' ');
INSERT INTO answer VALUES (1416, 354, 3, 'Providing information on the number of stations signed into a repeater', ' ');
INSERT INTO answer VALUES (1418, 355, 0, 'Phase Shift Keying', ' ');
INSERT INTO answer VALUES (1417, 355, 1, 'Pulse Shift Keying', ' ');
INSERT INTO answer VALUES (1419, 355, 2, 'Packet Short Keying', ' ');
INSERT INTO answer VALUES (1420, 355, 3, 'Phased Slide Keying', ' ');
INSERT INTO answer VALUES (1421, 356, 0, 'A technique for time-multiplexing two digital voice signals on a single 12.5 kHz repeater channel', ' ');
INSERT INTO answer VALUES (1422, 356, 1, 'An automatic position tracking mode for FM mobiles communicating through repeaters', ' ');
INSERT INTO answer VALUES (1423, 356, 2, 'An automatic computer logging technique for hands-off logging when communicating while operating a vehicle', ' ');
INSERT INTO answer VALUES (1424, 356, 3, 'A digital technique for transmitting on two repeater inputs simultaneously for automatic error correction', ' ');
INSERT INTO answer VALUES (1428, 357, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1425, 357, 1, 'A check sum that permits error detection', ' ');
INSERT INTO answer VALUES (1426, 357, 2, 'A header that contains the call sign of the station to which the information is being sent', ' ');
INSERT INTO answer VALUES (1427, 357, 3, 'Automatic repeat request in case of error', ' ');
INSERT INTO answer VALUES (1431, 358, 0, 'International Morse', ' ');
INSERT INTO answer VALUES (1429, 358, 1, 'Baudot', ' ');
INSERT INTO answer VALUES (1430, 358, 2, 'Hamming', ' ');
INSERT INTO answer VALUES (1432, 358, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1436, 359, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1433, 359, 1, 'Moonbounce or Earth-Moon-Earth', ' ');
INSERT INTO answer VALUES (1434, 359, 2, 'Weak-signal propagation beacons', ' ');
INSERT INTO answer VALUES (1435, 359, 3, 'Meteor scatter', ' ');
INSERT INTO answer VALUES (1439, 360, 0, 'A digital scheme whereby the receiving station detects errors and sends a request to the sending station to retransmit the information', ' ');
INSERT INTO answer VALUES (1437, 360, 1, 'A special transmission format limited to video signals', ' ');
INSERT INTO answer VALUES (1438, 360, 2, 'A system used to encrypt command signals to an amateur radio satellite', ' ');
INSERT INTO answer VALUES (1440, 360, 3, 'A method of compressing the data in a message so more information can be sent in a shorter time', ' ');
INSERT INTO answer VALUES (1441, 361, 0, 'An amateur-radio-based data network using commercial Wi-Fi gear with modified firmware', ' ');
INSERT INTO answer VALUES (1442, 361, 1, 'A wide-bandwidth digital voice mode employing DRM protocols', ' ');
INSERT INTO answer VALUES (1443, 361, 2, 'A satellite communications network using modified commercial satellite TV hardware', ' ');
INSERT INTO answer VALUES (1444, 361, 3, 'An internet linking protocol used to network repeaters', ' ');
INSERT INTO answer VALUES (1446, 362, 0, 'A digital mode capable of operating in low signal-to-noise conditions that transmits on 15-second intervals', ' ');
INSERT INTO answer VALUES (1445, 362, 1, 'A wideband FM voice mode', ' ');
INSERT INTO answer VALUES (1447, 362, 2, 'An eight channel multiplex mode for FM repeaters', ' ');
INSERT INTO answer VALUES (1448, 362, 3, 'A digital slow scan TV mode with forward error correction and automatic color compensation', ' ');
INSERT INTO answer VALUES (1451, 363, 0, 'A device that assists in manual sending of Morse code', ' ');
INSERT INTO answer VALUES (1449, 363, 1, 'A device for switching antennas from transmit to receive', ' ');
INSERT INTO answer VALUES (1450, 363, 2, 'A device for voice activated switching from receive to transmit', ' ');
INSERT INTO answer VALUES (1452, 363, 3, 'An interlock to prevent unauthorized use of a radio', ' ');
INSERT INTO answer VALUES (1455, 364, 0, 'An antenna that concentrates signals in one direction', ' ');
INSERT INTO answer VALUES (1453, 364, 1, 'An antenna built from aluminum I-beams', ' ');
INSERT INTO answer VALUES (1454, 364, 2, 'An omnidirectional antenna invented by Clarence Beam', ' ');
INSERT INTO answer VALUES (1456, 364, 3, 'An antenna that reverses the phase of received signals', ' ');
INSERT INTO answer VALUES (1457, 365, 0, 'Inserting an inductor in the radiating portion of the antenna to make it electrically longer', ' ');
INSERT INTO answer VALUES (1458, 365, 1, 'Inserting a resistor in the radiating portion of the antenna to make it resonant', ' ');
INSERT INTO answer VALUES (1459, 365, 2, 'Installing a spring in the base of a mobile vertical antenna to make it more flexible', ' ');
INSERT INTO answer VALUES (1460, 365, 3, 'Strengthening the radiating elements of a beam antenna to better resist wind damage', ' ');
INSERT INTO answer VALUES (1462, 366, 0, 'A horizontally polarized antenna', ' ');
INSERT INTO answer VALUES (1461, 366, 1, 'A ground-wave antenna', ' ');
INSERT INTO answer VALUES (1463, 366, 2, 'A rhombic antenna', ' ');
INSERT INTO answer VALUES (1464, 366, 3, 'A vertically polarized antenna', ' ');
INSERT INTO answer VALUES (1465, 367, 0, 'It does not transmit or receive as effectively', ' ');
INSERT INTO answer VALUES (1466, 367, 1, 'It transmits only circularly polarized signals', ' ');
INSERT INTO answer VALUES (1467, 367, 2, 'If the rubber end cap is lost, it will unravel very easily', ' ');
INSERT INTO answer VALUES (1468, 367, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1471, 368, 0, 'Shorten it', ' ');
INSERT INTO answer VALUES (1469, 368, 1, 'Lengthen it', ' ');
INSERT INTO answer VALUES (1470, 368, 2, 'Insert coils in series with radiating wires', ' ');
INSERT INTO answer VALUES (1472, 368, 3, 'Add capacitive loading to the ends of the radiating wires', ' ');
INSERT INTO answer VALUES (1475, 369, 0, 'Directional antennas', ' ');
INSERT INTO answer VALUES (1473, 369, 1, 'Non-resonant antennas', ' ');
INSERT INTO answer VALUES (1474, 369, 2, 'Log periodic antennas', ' ');
INSERT INTO answer VALUES (1476, 369, 3, 'Isotropic antennas', ' ');
INSERT INTO answer VALUES (1477, 370, 0, 'Signals might not propagate well due to the shielding effect of the vehicle', ' ');
INSERT INTO answer VALUES (1478, 370, 1, 'It might cause the transceiver to overheat', ' ');
INSERT INTO answer VALUES (1479, 370, 2, 'The SWR might decrease, decreasing the signal strength', ' ');
INSERT INTO answer VALUES (1480, 370, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1483, 371, 0, '19', ' ');
INSERT INTO answer VALUES (1481, 371, 1, '112', ' ');
INSERT INTO answer VALUES (1482, 371, 2, '50', ' ');
INSERT INTO answer VALUES (1484, 371, 3, '12', ' ');
INSERT INTO answer VALUES (1487, 372, 0, '112', ' ');
INSERT INTO answer VALUES (1485, 372, 1, '6', ' ');
INSERT INTO answer VALUES (1486, 372, 2, '50', ' ');
INSERT INTO answer VALUES (1488, 372, 3, '236', ' ');
INSERT INTO answer VALUES (1491, 373, 0, 'Broadside to the antenna', ' ');
INSERT INTO answer VALUES (1489, 373, 1, 'Equally in all directions', ' ');
INSERT INTO answer VALUES (1490, 373, 2, 'Off the ends of the antenna', ' ');
INSERT INTO answer VALUES (1492, 373, 3, 'In the direction of the feed line', ' ');
INSERT INTO answer VALUES (1495, 374, 0, 'The increase in signal strength in a specified direction compared to a reference antenna', ' ');
INSERT INTO answer VALUES (1493, 374, 1, 'The additional power that is added to the transmitter power', ' ');
INSERT INTO answer VALUES (1494, 374, 2, 'The additional power that is lost in the antenna when transmitting on a higher frequency', ' ');
INSERT INTO answer VALUES (1496, 374, 3, 'The increase in impedance on receive or transmit compared to a reference antenna', ' ');
INSERT INTO answer VALUES (1497, 375, 0, 'It has a lower radiation angle and more gain than a 1/4 wavelength antenna', ' ');
INSERT INTO answer VALUES (1498, 375, 1, 'It has very high angle radiation for better communicating through a repeater', ' ');
INSERT INTO answer VALUES (1499, 375, 2, 'It eliminates distortion caused by reflected signals', ' ');
INSERT INTO answer VALUES (1500, 375, 3, 'It has 10 times the power gain of a 1/4 wavelength design', ' ');
INSERT INTO answer VALUES (1502, 376, 0, 'To reduce signal loss', ' ');
INSERT INTO answer VALUES (1501, 376, 1, 'To reduce television interference', ' ');
INSERT INTO answer VALUES (1503, 376, 2, 'To prolong antenna life', ' ');
INSERT INTO answer VALUES (1504, 376, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1506, 377, 0, '50 ohms', ' ');
INSERT INTO answer VALUES (1505, 377, 1, '8 ohms', ' ');
INSERT INTO answer VALUES (1507, 377, 2, '600 ohms', ' ');
INSERT INTO answer VALUES (1508, 377, 3, '12 ohms', ' ');
INSERT INTO answer VALUES (1509, 378, 0, 'It is easy to use and requires few special installation considerations', ' ');
INSERT INTO answer VALUES (1510, 378, 1, 'It has less loss than any other type of feed line', ' ');
INSERT INTO answer VALUES (1511, 378, 2, 'It can handle more power than any other type of feed line', ' ');
INSERT INTO answer VALUES (1512, 378, 3, 'It is less expensive than any other type of feed line', ' ');
INSERT INTO answer VALUES (1513, 379, 0, 'It matches the antenna system impedance to the transceiver''s output impedance', ' ');
INSERT INTO answer VALUES (1514, 379, 1, 'It helps a receiver automatically tune in weak stations', ' ');
INSERT INTO answer VALUES (1515, 379, 2, 'It allows an antenna to be used on both transmit and receive', ' ');
INSERT INTO answer VALUES (1516, 379, 3, 'It automatically selects the proper antenna for the frequency band being used', ' ');
INSERT INTO answer VALUES (1520, 380, 0, 'The loss increases', ' ');
INSERT INTO answer VALUES (1517, 380, 1, 'The characteristic impedance decreases', ' ');
INSERT INTO answer VALUES (1518, 380, 2, 'The loss decreases', ' ');
INSERT INTO answer VALUES (1519, 380, 3, 'The characteristic impedance increases', ' ');
INSERT INTO answer VALUES (1522, 381, 0, 'A Type N connector', ' ');
INSERT INTO answer VALUES (1521, 381, 1, 'A UHF (PL-259/SO-239) connector', ' ');
INSERT INTO answer VALUES (1523, 381, 2, 'An RS-213 connector', ' ');
INSERT INTO answer VALUES (1524, 381, 3, 'A DB-25 connector', ' ');
INSERT INTO answer VALUES (1527, 382, 0, 'They are commonly used at HF frequencies', ' ');
INSERT INTO answer VALUES (1525, 382, 1, 'They are preferred for microwave operation', ' ');
INSERT INTO answer VALUES (1526, 382, 2, 'They are watertight', ' ');
INSERT INTO answer VALUES (1528, 382, 3, 'They are a bayonet type connector', ' ');
INSERT INTO answer VALUES (1529, 383, 0, 'To prevent an increase in feed line loss', ' ');
INSERT INTO answer VALUES (1530, 383, 1, 'To prevent interference to telephones', ' ');
INSERT INTO answer VALUES (1531, 383, 2, 'To keep the jacket from becoming loose', ' ');
INSERT INTO answer VALUES (1532, 383, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1534, 384, 0, 'A loose connection in an antenna or a feed line', ' ');
INSERT INTO answer VALUES (1533, 384, 1, 'The transmitter is being modulated', ' ');
INSERT INTO answer VALUES (1535, 384, 2, 'The transmitter is being over-modulated', ' ');
INSERT INTO answer VALUES (1536, 384, 3, 'Interference from other stations is distorting your signal', ' ');
INSERT INTO answer VALUES (1539, 385, 0, 'RG-8 cable has less loss at a given frequency', ' ');
INSERT INTO answer VALUES (1537, 385, 1, 'There is no significant difference between the two types', ' ');
INSERT INTO answer VALUES (1538, 385, 2, 'RG-58 cable has two shields', ' ');
INSERT INTO answer VALUES (1540, 385, 3, 'RG-58 cable can handle higher power levels', ' ');
INSERT INTO answer VALUES (1543, 386, 0, 'Air-insulated hard line', ' ');
INSERT INTO answer VALUES (1541, 386, 1, '50-ohm flexible coax', ' ');
INSERT INTO answer VALUES (1542, 386, 2, 'Multi-conductor unbalanced cable', ' ');
INSERT INTO answer VALUES (1544, 386, 3, '75-ohm flexible coax', ' ');
INSERT INTO answer VALUES (1546, 387, 0, 'Shorting the terminals can cause burns, fire, or an explosion', ' ');
INSERT INTO answer VALUES (1545, 387, 1, 'Touching both terminals with the hands can cause electrical shock', ' ');
INSERT INTO answer VALUES (1547, 387, 2, 'RF emissions from the battery', ' ');
INSERT INTO answer VALUES (1548, 387, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1552, 388, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1549, 388, 1, 'It may cause injury by heating tissue', ' ');
INSERT INTO answer VALUES (1550, 388, 2, 'It may disrupt the electrical functions of cells', ' ');
INSERT INTO answer VALUES (1551, 388, 3, 'It may cause involuntary muscle contractions', ' ');
INSERT INTO answer VALUES (1555, 389, 0, 'Equipment ground', ' ');
INSERT INTO answer VALUES (1553, 389, 1, 'Neutral', ' ');
INSERT INTO answer VALUES (1554, 389, 2, 'Hot', ' ');
INSERT INTO answer VALUES (1556, 389, 3, 'The white wire', ' ');
INSERT INTO answer VALUES (1558, 390, 0, 'To interrupt power in case of overload', ' ');
INSERT INTO answer VALUES (1557, 390, 1, 'To prevent power supply ripple from damaging a circuit', ' ');
INSERT INTO answer VALUES (1559, 390, 2, 'To limit current to prevent shocks', ' ');
INSERT INTO answer VALUES (1560, 390, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1563, 391, 0, 'Excessive current could cause a fire', ' ');
INSERT INTO answer VALUES (1561, 391, 1, 'The larger fuse would be likely to blow because it is rated for higher current', ' ');
INSERT INTO answer VALUES (1562, 391, 2, 'The power supply ripple would greatly increase', ' ');
INSERT INTO answer VALUES (1564, 391, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1568, 392, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1565, 392, 1, 'Use three-wire cords and plugs for all AC powered equipment', ' ');
INSERT INTO answer VALUES (1566, 392, 2, 'Connect all AC powered station equipment to a common safety ground', ' ');
INSERT INTO answer VALUES (1567, 392, 3, 'Use a circuit protected by a ground-fault interrupter', ' ');
INSERT INTO answer VALUES (1572, 393, 0, 'Mount all of the protectors on a metal plate that is in turn connected to an external ground rod', ' ');
INSERT INTO answer VALUES (1569, 393, 1, 'Include a parallel bypass switch for each protector so that it can be switched out of the circuit when running high power', ' ');
INSERT INTO answer VALUES (1570, 393, 2, 'Include a series switch in the ground line of each protector to prevent RF overload from inadvertently damaging the protector', ' ');
INSERT INTO answer VALUES (1571, 393, 3, 'Keep the ground wires from each protector separate and connected to station ground', ' ');
INSERT INTO answer VALUES (1573, 394, 0, 'A fuse or circuit breaker in series with the AC hot conductor', ' ');
INSERT INTO answer VALUES (1574, 394, 1, 'An AC voltmeter across the incoming power source', ' ');
INSERT INTO answer VALUES (1575, 394, 2, 'An inductor in parallel with the AC power source', ' ');
INSERT INTO answer VALUES (1576, 394, 3, 'A capacitor in series with the AC power source', ' ');
INSERT INTO answer VALUES (1579, 395, 0, 'Bond them together with heavy wire or conductive strap', ' ');
INSERT INTO answer VALUES (1577, 395, 1, 'Waterproof them with silicone caulk or electrical tape', ' ');
INSERT INTO answer VALUES (1578, 395, 2, 'Keep them as far apart as possible', ' ');
INSERT INTO answer VALUES (1580, 395, 3, 'Tune them for resonance on the lowest frequency of operation', ' ');
INSERT INTO answer VALUES (1581, 396, 0, 'The battery could overheat, give off flammable gas, or explode', ' ');
INSERT INTO answer VALUES (1582, 396, 1, 'The voltage can become reversed', ' ');
INSERT INTO answer VALUES (1583, 396, 2, 'The memory effect will reduce the capacity of the battery', ' ');
INSERT INTO answer VALUES (1584, 396, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1588, 397, 0, 'You might receive an electric shock from the charge stored in large capacitors', ' ');
INSERT INTO answer VALUES (1585, 397, 1, 'Static electricity could damage the grounding system', ' ');
INSERT INTO answer VALUES (1586, 397, 2, 'Circulating currents inside the transformer might cause damage', ' ');
INSERT INTO answer VALUES (1587, 397, 3, 'The fuse might blow if you remove the cover', ' ');
INSERT INTO answer VALUES (1591, 398, 0, 'At all times when any work is being done on the tower', ' ');
INSERT INTO answer VALUES (1589, 398, 1, 'At all times except when climbing the tower', ' ');
INSERT INTO answer VALUES (1590, 398, 2, 'At all times except when belted firmly to the tower', ' ');
INSERT INTO answer VALUES (1592, 398, 3, 'Only when the tower exceeds 30 feet in height', ' ');
INSERT INTO answer VALUES (1595, 399, 0, 'Put on a carefully inspected climbing harness(fall arrester)and safety glasses', ' ');
INSERT INTO answer VALUES (1593, 399, 1, 'Make sure that you wear a grounded wrist strap', ' ');
INSERT INTO answer VALUES (1594, 399, 2, 'Remove all tower grounding connections', ' ');
INSERT INTO answer VALUES (1596, 399, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1600, 400, 0, 'Never', ' ');
INSERT INTO answer VALUES (1597, 400, 1, 'When no electrical work is being performed', ' ');
INSERT INTO answer VALUES (1598, 400, 2, 'When no mechanical work is being performed', ' ');
INSERT INTO answer VALUES (1599, 400, 3, 'When the work being done is not more than 20 feet above the ground', ' ');
INSERT INTO answer VALUES (1603, 401, 0, 'Look for and stay clear of any overhead electrical wires', ' ');
INSERT INTO answer VALUES (1601, 401, 1, 'Wear a ground strap connected to your wrist at all times', ' ');
INSERT INTO answer VALUES (1602, 401, 2, 'Insulate the base of the tower to avoid lightning strikes', ' ');
INSERT INTO answer VALUES (1604, 401, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1607, 402, 0, 'To lift tower sections or antennas', ' ');
INSERT INTO answer VALUES (1605, 402, 1, 'To temporarily replace guy wires', ' ');
INSERT INTO answer VALUES (1606, 402, 2, 'To be used in place of a safety harness', ' ');
INSERT INTO answer VALUES (1608, 402, 3, 'To provide a temporary ground', ' ');
INSERT INTO answer VALUES (1612, 403, 0, 'Enough so that if the antenna falls unexpectedly, no part of it can come closer than 10 feet to the power wires', ' ');
INSERT INTO answer VALUES (1609, 403, 1, 'Half the width of your property', ' ');
INSERT INTO answer VALUES (1610, 403, 2, 'The height of the power line above ground', ' ');
INSERT INTO answer VALUES (1611, 403, 3, '1/2 wavelength at the operating frequency', ' ');
INSERT INTO answer VALUES (1615, 404, 0, 'This type of tower must not be climbed unless retracted or mechanical safety locking devices have been installed', ' ');
INSERT INTO answer VALUES (1613, 404, 1, 'This type of tower must never be painted', ' ');
INSERT INTO answer VALUES (1614, 404, 2, 'This type of tower must never be grounded', ' ');
INSERT INTO answer VALUES (1616, 404, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1619, 405, 0, 'Separate eight-foot long ground rods for each tower leg, bonded to the tower and each other', ' ');
INSERT INTO answer VALUES (1617, 405, 1, 'A single four-foot ground rod, driven into the ground no more than 12 inches from the base', ' ');
INSERT INTO answer VALUES (1618, 405, 2, 'A ferrite-core RF choke connected between the tower and ground', ' ');
INSERT INTO answer VALUES (1620, 405, 3, 'A connection between the tower base and a cold water pipe', ' ');
INSERT INTO answer VALUES (1623, 406, 0, 'The antenna could contact high-voltage power lines', ' ');
INSERT INTO answer VALUES (1621, 406, 1, 'The antenna will not work properly because of induced voltages', ' ');
INSERT INTO answer VALUES (1622, 406, 2, 'The utility company will charge you an extra monthly fee', ' ');
INSERT INTO answer VALUES (1624, 406, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1627, 407, 0, 'Sharp bends must be avoided', ' ');
INSERT INTO answer VALUES (1625, 407, 1, 'Only non-insulated wire must be used', ' ');
INSERT INTO answer VALUES (1626, 407, 2, 'Wires must be carefully routed with precise right-angle bends', ' ');
INSERT INTO answer VALUES (1628, 407, 3, 'Common grounds must be avoided', ' ');
INSERT INTO answer VALUES (1630, 408, 0, 'Local electrical codes', ' ');
INSERT INTO answer VALUES (1629, 408, 1, 'FCC Part 97 Rules', ' ');
INSERT INTO answer VALUES (1631, 408, 2, 'FAA tower lighting regulations', ' ');
INSERT INTO answer VALUES (1632, 408, 3, 'UL recommended practices', ' ');
INSERT INTO answer VALUES (1635, 409, 0, 'Ensure that connections are short and direct', ' ');
INSERT INTO answer VALUES (1633, 409, 1, 'Put a loop in the ground connection to prevent water damage to the ground system', ' ');
INSERT INTO answer VALUES (1634, 409, 2, 'Make sure that all bends in the ground wires are clean, right-angle bends', ' ');
INSERT INTO answer VALUES (1636, 409, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1638, 410, 0, 'Prevent loosening of the guy line from vibration', ' ');
INSERT INTO answer VALUES (1637, 410, 1, 'Secure the guy if the turnbuckle breaks', ' ');
INSERT INTO answer VALUES (1639, 410, 2, 'Prevent theft or vandalism', ' ');
INSERT INTO answer VALUES (1640, 410, 3, 'Deter unauthorized climbing of the tower', ' ');
INSERT INTO answer VALUES (1644, 411, 0, 'Non-ionizing radiation', ' ');
INSERT INTO answer VALUES (1641, 411, 1, 'Gamma radiation', ' ');
INSERT INTO answer VALUES (1642, 411, 2, 'Ionizing radiation', ' ');
INSERT INTO answer VALUES (1643, 411, 3, 'Alpha radiation', ' ');
INSERT INTO answer VALUES (1646, 412, 0, '50 MHz', ' ');
INSERT INTO answer VALUES (1645, 412, 1, '3.5 MHz', ' ');
INSERT INTO answer VALUES (1647, 412, 2, '440 MHz', ' ');
INSERT INTO answer VALUES (1648, 412, 3, '1296 MHz', ' ');
INSERT INTO answer VALUES (1651, 413, 0, '50 watts PEP at the antenna', ' ');
INSERT INTO answer VALUES (1649, 413, 1, '1500 watts PEP transmitter output', ' ');
INSERT INTO answer VALUES (1650, 413, 2, '1 watt forward power', ' ');
INSERT INTO answer VALUES (1652, 413, 3, '50 watts PEP reflected power', ' ');
INSERT INTO answer VALUES (1656, 414, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1653, 414, 1, 'Frequency and power level of the RF field', ' ');
INSERT INTO answer VALUES (1654, 414, 2, 'Distance from the antenna to a person', ' ');
INSERT INTO answer VALUES (1655, 414, 3, 'Radiation pattern of the antenna', ' ');
INSERT INTO answer VALUES (1660, 415, 0, 'The human body absorbs more RF energy at some frequencies than at others', ' ');
INSERT INTO answer VALUES (1657, 415, 1, 'Lower frequency RF fields have more energy than higher frequency fields', ' ');
INSERT INTO answer VALUES (1658, 415, 2, 'Lower frequency RF fields do not penetrate the human body', ' ');
INSERT INTO answer VALUES (1659, 415, 3, 'Higher frequency RF fields are transient in nature', ' ');
INSERT INTO answer VALUES (1664, 416, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1661, 416, 1, 'By calculation based on FCC OET Bulletin 65', ' ');
INSERT INTO answer VALUES (1662, 416, 2, 'By calculation based on computer modeling', ' ');
INSERT INTO answer VALUES (1663, 416, 3, 'By measurement of field strength using calibrated equipment', ' ');
INSERT INTO answer VALUES (1666, 417, 0, 'They might receive a painful RF burn', ' ');
INSERT INTO answer VALUES (1665, 417, 1, 'Touching the antenna could cause television interference', ' ');
INSERT INTO answer VALUES (1667, 417, 2, 'They might develop radiation poisoning', ' ');
INSERT INTO answer VALUES (1668, 417, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1669, 418, 0, 'Relocate antennas', ' ');
INSERT INTO answer VALUES (1670, 418, 1, 'Relocate the transmitter', ' ');
INSERT INTO answer VALUES (1671, 418, 2, 'Increase the duty cycle', ' ');
INSERT INTO answer VALUES (1672, 418, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1674, 419, 0, 'By re-evaluating the station whenever an item of equipment is changed', ' ');
INSERT INTO answer VALUES (1673, 419, 1, 'By informing the FCC of any changes made in your station', ' ');
INSERT INTO answer VALUES (1675, 419, 2, 'By making sure your antennas have low SWR', ' ');
INSERT INTO answer VALUES (1676, 419, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (1677, 420, 0, 'It affects the average exposure of people to radiation', ' ');
INSERT INTO answer VALUES (1678, 420, 1, 'It affects the peak exposure of people to radiation', ' ');
INSERT INTO answer VALUES (1679, 420, 2, 'It takes into account the antenna feed line loss', ' ');
INSERT INTO answer VALUES (1680, 420, 3, 'It takes into account the thermal effects of the final amplifier', ' ');
INSERT INTO answer VALUES (1683, 421, 0, 'The percentage of time that a transmitter is transmitting', ' ');
INSERT INTO answer VALUES (1681, 421, 1, 'The difference between the lowest power output and the highest power output of a transmitter', ' ');
INSERT INTO answer VALUES (1682, 421, 2, 'The difference between the PEP and average power output of a transmitter', ' ');
INSERT INTO answer VALUES (1684, 421, 3, 'The percentage of time that a transmitter is not transmitting', ' ');
INSERT INTO answer VALUES (1685, 422, 0, 'RF radiation does not have sufficient energy to cause genetic damage', ' ');
INSERT INTO answer VALUES (1686, 422, 1, 'RF radiation can only be detected with an RF dosimeter', ' ');
INSERT INTO answer VALUES (1687, 422, 2, 'RF radiation is limited in range to a few feet', ' ');
INSERT INTO answer VALUES (1688, 422, 3, 'RF radiation is perfectly safe', ' ');
INSERT INTO answer VALUES (1691, 423, 0, '2 times as much', ' ');
INSERT INTO answer VALUES (1689, 423, 1, '3 times as much', ' ');
INSERT INTO answer VALUES (1690, 423, 2, '1/2 as much', ' ');
INSERT INTO answer VALUES (1692, 423, 3, 'There is no adjustment allowed for shorter exposure times', ' ');

INSERT INTO answer VALUES (1695, 424, 0, '160 meters, 60 meters, 30 meters, 17 meters, 12 meters, and 10 meters', ' ');
INSERT INTO answer VALUES (1693, 424, 1, '60 meters, 20 meters, 17 meters, and 12 meters', ' ');
INSERT INTO answer VALUES (1694, 424, 2, '160 meters, 80 meters, 40 meters, and 10 meters', ' ');
INSERT INTO answer VALUES (1696, 424, 3, '160 meters, 30 meters, 17 meters, 15 meters, 12 meters, and 10 meters', ' ');
INSERT INTO answer VALUES (1698, 425, 0, '30 meters', ' ');
INSERT INTO answer VALUES (1697, 425, 1, '160 meters', ' ');
INSERT INTO answer VALUES (1699, 425, 2, '17 meters', ' ');
INSERT INTO answer VALUES (1700, 425, 3, '12 meters', ' ');
INSERT INTO answer VALUES (1702, 426, 0, '30 meters', ' ');
INSERT INTO answer VALUES (1701, 426, 1, '160 meters', ' ');
INSERT INTO answer VALUES (1703, 426, 2, '20 meters', ' ');
INSERT INTO answer VALUES (1704, 426, 3, '12 meters', ' ');
INSERT INTO answer VALUES (1708, 427, 0, '60 meters', ' ');
INSERT INTO answer VALUES (1705, 427, 1, '11 meters', ' ');
INSERT INTO answer VALUES (1706, 427, 2, '12 meters', ' ');
INSERT INTO answer VALUES (1707, 427, 3, '30 meters', ' ');
INSERT INTO answer VALUES (1709, 428, 0, '7.250 MHz', ' ');
INSERT INTO answer VALUES (1710, 428, 1, '7.500 MHz', ' ');
INSERT INTO answer VALUES (1711, 428, 2, '40.200 MHz', ' ');
INSERT INTO answer VALUES (1712, 428, 3, '40.500 MHz', ' ');
INSERT INTO answer VALUES (1715, 429, 0, '3900 kHz', ' ');
INSERT INTO answer VALUES (1713, 429, 1, '1875 kHz', ' ');
INSERT INTO answer VALUES (1714, 429, 2, '3750 kHz', ' ');
INSERT INTO answer VALUES (1716, 429, 3, '4005 kHz', ' ');
INSERT INTO answer VALUES (1719, 430, 0, '14305 kHz', ' ');
INSERT INTO answer VALUES (1717, 430, 1, '14005 kHz', ' ');
INSERT INTO answer VALUES (1718, 430, 2, '14105 kHz', ' ');
INSERT INTO answer VALUES (1720, 430, 3, '14405 kHz', ' ');
INSERT INTO answer VALUES (1723, 431, 0, '3560 kHz', ' ');
INSERT INTO answer VALUES (1721, 431, 1, '1855 kHz', ' ');
INSERT INTO answer VALUES (1722, 431, 2, '2560 kHz', ' ');
INSERT INTO answer VALUES (1724, 431, 3, '3650 kHz', ' ');
INSERT INTO answer VALUES (1727, 432, 0, '21300 kHz', ' ');
INSERT INTO answer VALUES (1725, 432, 1, '14250 kHz', ' ');
INSERT INTO answer VALUES (1726, 432, 2, '18155 kHz', ' ');
INSERT INTO answer VALUES (1728, 432, 3, '24900 kHz', ' ');
INSERT INTO answer VALUES (1732, 433, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (1729, 433, 1, '28.020 MHz', ' ');
INSERT INTO answer VALUES (1730, 433, 2, '28.350 MHz', ' ');
INSERT INTO answer VALUES (1731, 433, 3, '28.550 MHz', ' ');
INSERT INTO answer VALUES (1734, 434, 0, 'The upper frequency end', ' ');
INSERT INTO answer VALUES (1733, 434, 1, 'The lower frequency end', ' ');
INSERT INTO answer VALUES (1735, 434, 2, 'The lower frequency end on frequencies below 7.3 MHz, and the upper end on frequencies above 14.150 MHz', ' ');
INSERT INTO answer VALUES (1736, 434, 3, 'The upper frequency end on frequencies below 7.3 MHz, and the lower end on frequencies above 14.150 MHz', ' ');
INSERT INTO answer VALUES (1739, 435, 0, 'Amateur stations can use the band only if they do not cause harmful interference to primary users', ' ');
INSERT INTO answer VALUES (1737, 435, 1, 'Amateur stations must record the call sign of the primary service station before operating on a frequency assigned to that station', ' ');
INSERT INTO answer VALUES (1738, 435, 2, 'Amateur stations can use the band only during emergencies', ' ');
INSERT INTO answer VALUES (1740, 435, 3, 'Amateur stations may only operate during specific hours of the day, while primary users are permitted 24hour use of the band', ' ');
INSERT INTO answer VALUES (1744, 436, 0, 'Move to a clear frequency or stop transmitting', ' ');
INSERT INTO answer VALUES (1741, 436, 1, 'Notify the FCCs regional Engineer in Charge of the interference', ' ');
INSERT INTO answer VALUES (1742, 436, 2, 'Increase your transmitter’s power to overcome the interference', ' ');
INSERT INTO answer VALUES (1743, 436, 3, 'Attempt to contact the station and request that it stop the interference', ' ');
INSERT INTO answer VALUES (1748, 437, 0, 'Frequency allocations may differ', ' ');
INSERT INTO answer VALUES (1745, 437, 1, 'Station identification may have to be in a language other than English', ' ');
INSERT INTO answer VALUES (1746, 437, 2, 'Morse code may not be permitted', ' ');
INSERT INTO answer VALUES (1747, 437, 3, 'Digital transmission may not be permitted', ' ');
INSERT INTO answer VALUES (1752, 438, 0, 'The portion above 29.5 MHz', ' ');
INSERT INTO answer VALUES (1749, 438, 1, 'The entire band', ' ');
INSERT INTO answer VALUES (1750, 438, 2, 'The portion between 28.1 MHz and 28.2 MHz', ' ');
INSERT INTO answer VALUES (1751, 438, 3, 'The portion between 28.3 MHz and 28.5 MHz', ' ');
INSERT INTO answer VALUES (1755, 439, 0, '200 feet', ' ');
INSERT INTO answer VALUES (1753, 439, 1, '50 feet', ' ');
INSERT INTO answer VALUES (1754, 439, 2, '100 feet', ' ');
INSERT INTO answer VALUES (1756, 439, 3, '300 feet', ' ');
INSERT INTO answer VALUES (1760, 440, 0, 'There must be no more than one beacon signal transmitting in the same band from the same station location', ' ');
INSERT INTO answer VALUES (1757, 440, 1, 'A beacon station may not use automatic control', ' ');
INSERT INTO answer VALUES (1758, 440, 2, 'The frequency must be coordinated with the National Beacon Organization', ' ');
INSERT INTO answer VALUES (1759, 440, 3, 'The frequency must be posted on the internet or published in a national periodical', ' ');
INSERT INTO answer VALUES (1761, 441, 0, 'Observation of propagation and reception', ' ');
INSERT INTO answer VALUES (1762, 441, 1, 'Automatic identification of repeaters', ' ');
INSERT INTO answer VALUES (1763, 441, 2, 'Transmission of bulletins of general interest to Amateur Radio licensees', ' ');
INSERT INTO answer VALUES (1764, 441, 3, 'Identifying net frequencies', ' ');
INSERT INTO answer VALUES (1767, 442, 0, 'Occasional retransmission of weather and propagation forecast information from U.S. government stations', ' ');
INSERT INTO answer VALUES (1765, 442, 1, 'Unidentified transmissions for test purposes only', ' ');
INSERT INTO answer VALUES (1766, 442, 2, 'Retransmission of other amateur station signals by any amateur station', ' ');
INSERT INTO answer VALUES (1768, 442, 3, 'Coded messages of any kind, if not intended to facilitate a criminal act', ' ');
INSERT INTO answer VALUES (1770, 443, 0, 'Transmissions necessary to assist learning the International Morse code', ' ');
INSERT INTO answer VALUES (1769, 443, 1, 'Unidentified test transmissions of less than one minute in duration', ' ');
INSERT INTO answer VALUES (1771, 443, 2, 'Regular transmissions offering equipment for sale, if intended for Amateur Radio use', ' ');
INSERT INTO answer VALUES (1772, 443, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (1776, 444, 0, 'Amateur Service communications must be reasonably accommodated, and regulations must constitute the minimum practical to accommodate a legitimate purpose of the state or local entity', ' ');
INSERT INTO answer VALUES (1773, 444, 1, 'Under no circumstances, FCC rules take priority', ' ');
INSERT INTO answer VALUES (1774, 444, 2, 'At any time and to any extent necessary to accomplish a legitimate purpose of the state or local entity,provided that proper filings are made with the FCC', ' ');
INSERT INTO answer VALUES (1775, 444, 3, 'Only when such structures exceed 50 feet in height and are clearly visible 1000 feet from the structure', ' ');
INSERT INTO answer VALUES (1778, 445, 0, 'They may be used if they do not obscure the meaning of a message', ' ');
INSERT INTO answer VALUES (1777, 445, 1, 'Only “Q” signals are permitted', ' ');
INSERT INTO answer VALUES (1779, 445, 2, 'They are not permitted', ' ');
INSERT INTO answer VALUES (1780, 445, 3, 'Only “10 codes” are permitted', ' ');
INSERT INTO answer VALUES (1784, 446, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (1781, 446, 1, 'Ensure that the frequency and mode selected are within your license class privileges', ' ');
INSERT INTO answer VALUES (1782, 446, 2, 'Follow generally accepted band plans agreed to by the Amateur Radio community', ' ');
INSERT INTO answer VALUES (1783, 446, 3, 'Monitor the frequency before transmitting', ' ');
INSERT INTO answer VALUES (1788, 447, 0, '28.20 MHz to 28.30 MHz', ' ');
INSERT INTO answer VALUES (1785, 447, 1, 'On any frequency if power is less than 1 watt', ' ');
INSERT INTO answer VALUES (1786, 447, 2, 'On any frequency if transmissions are in Morse code', ' ');
INSERT INTO answer VALUES (1787, 447, 3, '21.08 MHz to 21.09 MHz', ' ');
INSERT INTO answer VALUES (1791, 448, 0, '100 watts PEP output', ' ');
INSERT INTO answer VALUES (1789, 448, 1, '10 watts PEP output', ' ');
INSERT INTO answer VALUES (1790, 448, 2, '20 watts PEP output', ' ');
INSERT INTO answer VALUES (1792, 448, 3, '200 watts PEP output', ' ');
INSERT INTO answer VALUES (1793, 449, 0, 'The FCC', ' ');
INSERT INTO answer VALUES (1794, 449, 1, 'The control operator', ' ');
INSERT INTO answer VALUES (1795, 449, 2, 'The IEEE', ' ');
INSERT INTO answer VALUES (1796, 449, 3, 'The ITU', ' ');
INSERT INTO answer VALUES (1798, 450, 0, 'When the contact is with amateurs in any country except those whose administrations have notified the ITU that they object to such communications', ' ');
INSERT INTO answer VALUES (1797, 450, 1, 'Only when the foreign country has a formal third-party agreement filed with the FCC', ' ');
INSERT INTO answer VALUES (1799, 450, 2, 'When the contact is with amateurs in any country as long as the communication is conducted in English', ' ');
INSERT INTO answer VALUES (1800, 450, 3, 'Only when the foreign country is a member of the International Amateur Radio Union', ' ');
INSERT INTO answer VALUES (1801, 451, 0, '200 watts PEP output', ' ');
INSERT INTO answer VALUES (1802, 451, 1, '1000 watts PEP output', ' ');
INSERT INTO answer VALUES (1803, 451, 2, '1500 watts PEP output', ' ');
INSERT INTO answer VALUES (1804, 451, 3, '2000 watts PEP output', ' ');
INSERT INTO answer VALUES (1807, 452, 0, '1500 watts PEP output', ' ');
INSERT INTO answer VALUES (1805, 452, 1, '50 watts PEP output', ' ');
INSERT INTO answer VALUES (1806, 452, 2, '200 watts PEP output', ' ');
INSERT INTO answer VALUES (1808, 452, 3, 'An effective radiated power equivalent to 100 watts from a half-wave dipole', ' ');
INSERT INTO answer VALUES (1809, 453, 0, '2.8 kHz', ' ');
INSERT INTO answer VALUES (1810, 453, 1, '5.6 kHz', ' ');
INSERT INTO answer VALUES (1811, 453, 2, '1.8 kHz', ' ');
INSERT INTO answer VALUES (1812, 453, 3, '3 kHz', ' ');
INSERT INTO answer VALUES (1813, 454, 0, 'Only the minimum power necessary to carry out the desired communications should be used', ' ');
INSERT INTO answer VALUES (1814, 454, 1, 'Power must be limited to 200 watts when using data transmissions', ' ');
INSERT INTO answer VALUES (1815, 454, 2, 'Power should be limited as necessary to avoid interference to another radio service on the frequency', ' ');
INSERT INTO answer VALUES (1816, 454, 3, 'Effective radiated power cannot exceed 1500 watts', ' ');
INSERT INTO answer VALUES (1819, 455, 0, '1500 watts PEP output', ' ');
INSERT INTO answer VALUES (1817, 455, 1, '100 watts PEP output', ' ');
INSERT INTO answer VALUES (1818, 455, 2, '1000 watts PEP output', ' ');
INSERT INTO answer VALUES (1820, 455, 3, '2000 watts PEP output', ' ');
INSERT INTO answer VALUES (1824, 456, 0, '1500 watts PEP output', ' ');
INSERT INTO answer VALUES (1821, 456, 1, '200 watts PEP output', ' ');
INSERT INTO answer VALUES (1822, 456, 2, '1000 watts PEP output', ' ');
INSERT INTO answer VALUES (1823, 456, 3, '1200 watts PEP output', ' ');
INSERT INTO answer VALUES (1828, 457, 0, '300 baud', ' ');
INSERT INTO answer VALUES (1825, 457, 1, '56 kilobaud', ' ');
INSERT INTO answer VALUES (1826, 457, 2, '19.6 kilobaud', ' ');
INSERT INTO answer VALUES (1827, 457, 3, '1200 baud', ' ');
INSERT INTO answer VALUES (1832, 458, 0, '300 baud', ' ');
INSERT INTO answer VALUES (1829, 458, 1, '56 kilobaud', ' ');
INSERT INTO answer VALUES (1830, 458, 2, '19.6 kilobaud', ' ');
INSERT INTO answer VALUES (1831, 458, 3, '1200 baud', ' ');
INSERT INTO answer VALUES (1833, 459, 0, '56 kilobaud', ' ');
INSERT INTO answer VALUES (1834, 459, 1, '19.6 kilobaud', ' ');
INSERT INTO answer VALUES (1835, 459, 2, '1200 baud', ' ');
INSERT INTO answer VALUES (1836, 459, 3, '300 baud', ' ');
INSERT INTO answer VALUES (1839, 460, 0, '1200 baud', ' ');
INSERT INTO answer VALUES (1837, 460, 1, '56 kilobaud', ' ');
INSERT INTO answer VALUES (1838, 460, 2, '19.6 kilobaud', ' ');
INSERT INTO answer VALUES (1840, 460, 3, '300 baud', ' ');
INSERT INTO answer VALUES (1842, 461, 0, '19.6 kilobaud', ' ');
INSERT INTO answer VALUES (1841, 461, 1, '56 kilobaud', ' ');
INSERT INTO answer VALUES (1843, 461, 2, '1200 baud', ' ');
INSERT INTO answer VALUES (1844, 461, 3, '300 baud', ' ');
INSERT INTO answer VALUES (1845, 462, 0, 'If you are using an antenna other than a dipole, you must keep a record of the gain of your antenna', ' ');
INSERT INTO answer VALUES (1846, 462, 1, 'You must keep a record of the date, time, frequency, power level, and stations worked', ' ');
INSERT INTO answer VALUES (1847, 462, 2, 'You must keep a record of all third-party traffic', ' ');
INSERT INTO answer VALUES (1848, 462, 3, 'You must keep a record of the manufacturer of your equipment and the antenna used', ' ');
INSERT INTO answer VALUES (1851, 463, 0, 'Publicly document the technical characteristics of the protocol', ' ');
INSERT INTO answer VALUES (1849, 463, 1, 'Type-certify equipment to FCC standards', ' ');
INSERT INTO answer VALUES (1850, 463, 2, 'Obtain an experimental license from the FCC', ' ');
INSERT INTO answer VALUES (1852, 463, 3, 'Submit a rule-making proposal to the FCC describing the codes and methods of the technique', ' ');
INSERT INTO answer VALUES (1855, 464, 0, 'ERP of 100 watts PEP with respect to a dipole', ' ');
INSERT INTO answer VALUES (1853, 464, 1, '1500 watts PEP', ' ');
INSERT INTO answer VALUES (1854, 464, 2, '10 watts RMS', ' ');
INSERT INTO answer VALUES (1856, 464, 3, 'ERP of 100 watts PEP with respect to an isotropic antenna', ' ');
INSERT INTO answer VALUES (1860, 465, 0, 'PEP', ' ');
INSERT INTO answer VALUES (1857, 465, 1, 'RMS', ' ');
INSERT INTO answer VALUES (1858, 465, 2, 'Average', ' ');
INSERT INTO answer VALUES (1859, 465, 3, 'Forward', ' ');
INSERT INTO answer VALUES (1861, 466, 0, 'Any person who can demonstrate that they once held an FCC-issued General, Advanced, or Amateur Extra class license that was not revoked by the FCC', ' ');
INSERT INTO answer VALUES (1862, 466, 1, 'Anyone who held an FCC-issued Amateur Radio license that has been expired for not less than 5 years and not more than 15 years', ' ');
INSERT INTO answer VALUES (1863, 466, 2, 'Any person who previously held an amateur license issued by another country, but only if that country has a current reciprocal licensing agreement with the FCC', ' ');
INSERT INTO answer VALUES (1864, 466, 3, 'Only persons who once held an FCC issued Novice, Technician, or Technician Plus license', ' ');
INSERT INTO answer VALUES (1867, 467, 0, 'Technician only', ' ');
INSERT INTO answer VALUES (1865, 467, 1, 'General and Technician', ' ');
INSERT INTO answer VALUES (1866, 467, 2, 'General only', ' ');
INSERT INTO answer VALUES (1868, 467, 3, 'Amateur Extra, General, and Technician', ' ');
INSERT INTO answer VALUES (1871, 468, 0, 'On any General or Technician class band segment', ' ');
INSERT INTO answer VALUES (1869, 468, 1, 'Only the Technician band segments until your upgrade is posted in the FCC database', ' ');
INSERT INTO answer VALUES (1870, 468, 2, 'Only on the Technician band segments until your license arrives in the mail', ' ');
INSERT INTO answer VALUES (1872, 468, 3, 'On any General or Technician class band segment except 30 meters and 60 meters', ' ');
INSERT INTO answer VALUES (1873, 469, 0, 'At least three General class or higher VEs must observe the examination', ' ');
INSERT INTO answer VALUES (1874, 469, 1, 'At least two General class or higher VEs must be present', ' ');
INSERT INTO answer VALUES (1875, 469, 2, 'At least two General class or higher VEs must be present, but only one need be Amateur Extra class', ' ');
INSERT INTO answer VALUES (1876, 469, 3, 'At least three VEs of Technician class or higher must observe the examination', ' ');
INSERT INTO answer VALUES (1880, 470, 0, 'An FCC General class or higher license and VEC accreditation', ' ');
INSERT INTO answer VALUES (1877, 470, 1, 'Notification to the FCC that you want to give an examination', ' ');
INSERT INTO answer VALUES (1878, 470, 2, 'Receipt of a Certificate of Successful Completion of Examination (CSCE) for General class', ' ');
INSERT INTO answer VALUES (1879, 470, 3, 'Possession of a properly obtained telegraphy license', ' ');
INSERT INTO answer VALUES (1881, 471, 0, 'Whenever you operate using General class frequency privileges', ' ');
INSERT INTO answer VALUES (1882, 471, 1, 'Whenever you operate on any amateur frequency', ' ');
INSERT INTO answer VALUES (1883, 471, 2, 'Whenever you operate using Technician frequency privileges', ' ');
INSERT INTO answer VALUES (1884, 471, 3, 'A special identifier is not required if your General class license application has been filed with the FCC', ' ');
INSERT INTO answer VALUES (1887, 472, 0, 'A Volunteer Examiner Coordinator', ' ');
INSERT INTO answer VALUES (1885, 472, 1, 'The Federal Communications Commission', ' ');
INSERT INTO answer VALUES (1886, 472, 2, 'The Universal Licensing System', ' ');
INSERT INTO answer VALUES (1888, 472, 3, 'The Wireless Telecommunications Bureau', ' ');
INSERT INTO answer VALUES (1890, 473, 0, 'The person must hold an FCC granted Amateur Radio license of General class or above', ' ');
INSERT INTO answer VALUES (1889, 473, 1, 'The person must be a resident of the U.S. for a minimum of 5 years', ' ');
INSERT INTO answer VALUES (1891, 473, 2, 'The person’s home citizenship must be in ITU region 2', ' ');
INSERT INTO answer VALUES (1892, 473, 3, 'None of these choices is correct; a non-U.S. citizen cannot be a Volunteer Examiner', ' ');
INSERT INTO answer VALUES (1895, 474, 0, '365 days', ' ');
INSERT INTO answer VALUES (1893, 474, 1, '30 days', ' ');
INSERT INTO answer VALUES (1894, 474, 2, '180 days', ' ');
INSERT INTO answer VALUES (1896, 474, 3, 'For as long as your current license is valid', ' ');
INSERT INTO answer VALUES (1898, 475, 0, '18 years', ' ');
INSERT INTO answer VALUES (1897, 475, 1, '12 years', ' ');
INSERT INTO answer VALUES (1899, 475, 2, '21 years', ' ');
INSERT INTO answer VALUES (1900, 475, 3, 'There is no age limit', ' ');
INSERT INTO answer VALUES (1904, 476, 0, 'The applicant must pass the current Element 2 exam', ' ');
INSERT INTO answer VALUES (1901, 476, 1, 'They must have a letter from the FCC showing they once held an amateur or commercial license', ' ');
INSERT INTO answer VALUES (1902, 476, 2, 'There are no requirements other than being able to show a copy of the expired license', ' ');
INSERT INTO answer VALUES (1903, 476, 3, 'The applicant must be able to produce a copy of a page from a call book published in the U.S. showing his or her name and address', ' ');
INSERT INTO answer VALUES (1905, 477, 0, 'The third party’s amateur license has been revoked and not reinstated', ' ');
INSERT INTO answer VALUES (1906, 477, 1, 'The third party is not a U.S. citizen', ' ');
INSERT INTO answer VALUES (1907, 477, 2, 'The third party is a licensed amateur', ' ');
INSERT INTO answer VALUES (1908, 477, 3, 'The third party is speaking in a language other than English', ' ');
INSERT INTO answer VALUES (1912, 478, 0, 'Only if the 10-meter repeater control operator holds at least a General class license', ' ');
INSERT INTO answer VALUES (1909, 478, 1, 'Under no circumstances', ' ');
INSERT INTO answer VALUES (1910, 478, 2, 'Only if the station on 10-meters is operating under a Special Temporary Authorization allowing such retransmission', ' ');
INSERT INTO answer VALUES (1911, 478, 3, 'Only during an FCC-declared general state of communications emergency', ' ');
INSERT INTO answer VALUES (1913, 479, 0, 'The station initiating the contact must be under local or remote control', ' ');
INSERT INTO answer VALUES (1914, 479, 1, 'The interrogating transmission must be made by another automatically controlled station', ' ');
INSERT INTO answer VALUES (1915, 479, 2, 'No third-party traffic may be transmitted', ' ');
INSERT INTO answer VALUES (1916, 479, 3, 'The control operator of the interrogating station must hold an Amateur Extra Class license', ' ');
INSERT INTO answer VALUES (1920, 480, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (1917, 480, 1, 'When operating within one mile of an FCC Monitoring Station', ' ');
INSERT INTO answer VALUES (1918, 480, 2, 'When using a band where the Amateur Service is secondary', ' ');
INSERT INTO answer VALUES (1919, 480, 3, 'When a station is transmitting spread spectrum emissions', ' ');
INSERT INTO answer VALUES (1923, 481, 0, 'Only messages relating to Amateur Radio or remarks of a personal character, or messages relating to emergencies or disaster relief', ' ');
INSERT INTO answer VALUES (1921, 481, 1, 'Any message, as long as the amateur operator is not paid', ' ');
INSERT INTO answer VALUES (1922, 481, 2, 'Only messages for other licensed amateurs', ' ');
INSERT INTO answer VALUES (1924, 481, 3, 'Any messages, as long as the text of the message is recorded in the station log', ' ');
INSERT INTO answer VALUES (1927, 482, 0, 'Region 2', ' ');
INSERT INTO answer VALUES (1925, 482, 1, 'Region 4', ' ');
INSERT INTO answer VALUES (1926, 482, 2, 'Region 3', ' ');
INSERT INTO answer VALUES (1928, 482, 3, 'Region 1', ' ');
INSERT INTO answer VALUES (1932, 483, 0, 'No part', ' ');
INSERT INTO answer VALUES (1929, 483, 1, 'Anywhere in the band', ' ');
INSERT INTO answer VALUES (1930, 483, 2, 'Channels 1 through 4', ' ');
INSERT INTO answer VALUES (1931, 483, 3, 'Channels 42 through 45', ' ');
INSERT INTO answer VALUES (1934, 484, 0, '10 watts', ' ');
INSERT INTO answer VALUES (1933, 484, 1, '100 milliwatts', ' ');
INSERT INTO answer VALUES (1935, 484, 2, '100 watts', ' ');
INSERT INTO answer VALUES (1936, 484, 3, '1500 watts', ' ');
INSERT INTO answer VALUES (1937, 485, 0, 'Under no circumstances', ' ');
INSERT INTO answer VALUES (1938, 485, 1, 'When messages are encrypted', ' ');
INSERT INTO answer VALUES (1939, 485, 2, 'When messages are not encrypted', ' ');
INSERT INTO answer VALUES (1940, 485, 3, 'When under automatic control', ' ');
INSERT INTO answer VALUES (1941, 486, 0, 'A system of propagation beacon stations operates on those frequencies', ' ');
INSERT INTO answer VALUES (1942, 486, 1, 'A system of automatic digital stations operates on those frequencies', ' ');
INSERT INTO answer VALUES (1943, 486, 2, 'These frequencies are set aside for emergency operations', ' ');
INSERT INTO answer VALUES (1944, 486, 3, 'These frequencies are set aside for bulletins from the FCC', ' ');
INSERT INTO answer VALUES (1948, 487, 0, 'Anywhere in the 6-meter or shorter wavelength bands, and in limited segments of some of the HF bands', ' ');
INSERT INTO answer VALUES (1945, 487, 1, 'On any band segment where digital operation is permitted', ' ');
INSERT INTO answer VALUES (1946, 487, 2, 'Anywhere in the non-phone segments of the 10-meter or shorter wavelength bands', ' ');
INSERT INTO answer VALUES (1947, 487, 3, 'Only in the non-phone Extra Class segments of the bands', ' ');
INSERT INTO answer VALUES (1949, 488, 0, 'Upper sideband', ' ');
INSERT INTO answer VALUES (1950, 488, 1, 'Lower sideband', ' ');
INSERT INTO answer VALUES (1951, 488, 2, 'Vestigial sideband', ' ');
INSERT INTO answer VALUES (1952, 488, 3, 'Double sideband', ' ');
INSERT INTO answer VALUES (1954, 489, 0, 'Lower sideband', ' ');
INSERT INTO answer VALUES (1953, 489, 1, 'Upper sideband', ' ');
INSERT INTO answer VALUES (1955, 489, 2, 'Vestigial sideband', ' ');
INSERT INTO answer VALUES (1956, 489, 3, 'Double sideband', ' ');
INSERT INTO answer VALUES (1957, 490, 0, 'Upper sideband', ' ');
INSERT INTO answer VALUES (1958, 490, 1, 'Lower sideband', ' ');
INSERT INTO answer VALUES (1959, 490, 2, 'Vestigial sideband', ' ');
INSERT INTO answer VALUES (1960, 490, 3, 'Double sideband', ' ');
INSERT INTO answer VALUES (1961, 491, 0, 'Upper sideband', ' ');
INSERT INTO answer VALUES (1962, 491, 1, 'Lower sideband', ' ');
INSERT INTO answer VALUES (1963, 491, 2, 'Vestigial sideband', ' ');
INSERT INTO answer VALUES (1964, 491, 3, 'Double sideband', ' ');
INSERT INTO answer VALUES (1967, 492, 0, 'Single sideband', ' ');
INSERT INTO answer VALUES (1965, 492, 1, 'Frequency modulation', ' ');
INSERT INTO answer VALUES (1966, 492, 2, 'Double sideband', ' ');
INSERT INTO answer VALUES (1968, 492, 3, 'Phase modulation', ' ');
INSERT INTO answer VALUES (1972, 493, 0, 'Less bandwidth used and greater power efficiency', ' ');
INSERT INTO answer VALUES (1969, 493, 1, 'Very high fidelity voice modulation', ' ');
INSERT INTO answer VALUES (1970, 493, 2, 'Less subject to interference from atmospheric static crashes', ' ');
INSERT INTO answer VALUES (1971, 493, 3, 'Ease of tuning on receive and immunity to impulse noise', ' ');
INSERT INTO answer VALUES (1974, 494, 0, 'Only one sideband is transmitted; the other sideband and carrier are suppressed', ' ');
INSERT INTO answer VALUES (1973, 494, 1, 'Only one sideband and the carrier are transmitted; the other sideband is suppressed', ' ');
INSERT INTO answer VALUES (1975, 494, 2, 'SSB is the only voice mode that is authorized on the 20-meter, 15-meter, and 10-meter amateur bands', ' ');
INSERT INTO answer VALUES (1976, 494, 3, 'SSB is the only voice mode that is authorized on the 160-meter, 75-meter, and 40-meter amateur bands', ' ');
INSERT INTO answer VALUES (1978, 495, 0, 'Say your call sign once', ' ');
INSERT INTO answer VALUES (1977, 495, 1, 'Say “QRZ” several times, followed by your call sign', ' ');
INSERT INTO answer VALUES (1979, 495, 2, 'Say “Breaker Breaker”', ' ');
INSERT INTO answer VALUES (1980, 495, 3, 'Say “CQ” followed by the call sign of either station', ' ');
INSERT INTO answer VALUES (1984, 496, 0, 'It is good amateur practice', ' ');
INSERT INTO answer VALUES (1981, 496, 1, 'Lower sideband is more efficient than upper sideband at these frequencies', ' ');
INSERT INTO answer VALUES (1982, 496, 2, 'Lower sideband is the only sideband legal on these frequency bands', ' ');
INSERT INTO answer VALUES (1983, 496, 3, 'Because it is fully compatible with an AM detector', ' ');
INSERT INTO answer VALUES (1986, 497, 0, 'It allows “hands free” operation', ' ');
INSERT INTO answer VALUES (1985, 497, 1, 'The received signal is more natural sounding', ' ');
INSERT INTO answer VALUES (1987, 497, 2, 'It occupies less bandwidth', ' ');
INSERT INTO answer VALUES (1988, 497, 3, 'It provides more power output', ' ');
INSERT INTO answer VALUES (1991, 498, 0, 'Any stations outside the lower 48 states', ' ');
INSERT INTO answer VALUES (1989, 498, 1, 'Any caller is welcome to respond', ' ');
INSERT INTO answer VALUES (1990, 498, 2, 'Only stations in Germany', ' ');
INSERT INTO answer VALUES (1992, 498, 3, 'Only contest stations', ' ');
INSERT INTO answer VALUES (1994, 499, 0, 'Transmit audio or microphone gain', ' ');
INSERT INTO answer VALUES (1993, 499, 1, 'The RF clipping level', ' ');
INSERT INTO answer VALUES (1995, 499, 2, 'Antenna inductance or capacitance', ' ');
INSERT INTO answer VALUES (1996, 499, 3, 'Attenuator level', ' ');
INSERT INTO answer VALUES (1999, 500, 0, 'Except during emergencies, no amateur station has priority access to any frequency', ' ');
INSERT INTO answer VALUES (1997, 500, 1, 'Nets always have priority', ' ');
INSERT INTO answer VALUES (1998, 500, 2, 'QSOs in progress always have priority', ' ');
INSERT INTO answer VALUES (2000, 500, 3, 'Contest operations must always yield to non-contest use of frequencies', ' ');
INSERT INTO answer VALUES (2002, 501, 0, 'Acknowledge the station in distress and determine what assistance may be needed', ' ');
INSERT INTO answer VALUES (2001, 501, 1, 'Continue your communication because you were on the frequency first', ' ');
INSERT INTO answer VALUES (2003, 501, 2, 'Change to a different frequency', ' ');
INSERT INTO answer VALUES (2004, 501, 3, 'Immediately cease all transmissions', ' ');
INSERT INTO answer VALUES (2007, 502, 0, 'Attempt to resolve the interference problem with the other stations in a mutually acceptable manner', ' ');
INSERT INTO answer VALUES (2005, 502, 1, 'Tell the interfering stations to change frequency', ' ');
INSERT INTO answer VALUES (2006, 502, 2, 'Report the interference to your local Amateur Auxiliary Coordinator', ' ');
INSERT INTO answer VALUES (2008, 502, 3, 'Increase power to overcome interference', ' ');
INSERT INTO answer VALUES (2010, 503, 0, '150 to 500 Hz', ' ');
INSERT INTO answer VALUES (2009, 503, 1, '5 to 50 Hz', ' ');
INSERT INTO answer VALUES (2011, 503, 2, '1 to 3 kHz', ' ');
INSERT INTO answer VALUES (2012, 503, 3, '3 to 6 kHz', ' ');
INSERT INTO answer VALUES (2015, 504, 0, 'Approximately 3 kHz', ' ');
INSERT INTO answer VALUES (2013, 504, 1, '5 to 50 Hz', ' ');
INSERT INTO answer VALUES (2014, 504, 2, '150 to 500 Hz', ' ');
INSERT INTO answer VALUES (2016, 504, 3, 'Approximately 6 kHz', ' ');
INSERT INTO answer VALUES (2017, 505, 0, 'Send “QRL?” on CW, followed by your call sign; or, if using phone, ask if the frequency is in use, followed by your call sign', ' ');
INSERT INTO answer VALUES (2018, 505, 1, 'Listen for 2 minutes before calling CQ', ' ');
INSERT INTO answer VALUES (2019, 505, 2, 'Send the letter “V” in Morse code several times and listen for a response, or say “test” several times and listen for a response', ' ');
INSERT INTO answer VALUES (2020, 505, 3, 'Send “QSY” on CW or if using phone, announce “the frequency is in use,” then give your call sign and listen for a response', ' ');
INSERT INTO answer VALUES (2023, 506, 0, 'Follow the voluntary band plan for the operating mode you intend to use', ' ');
INSERT INTO answer VALUES (2021, 506, 1, 'Check to see if the channel is assigned to another station', ' ');
INSERT INTO answer VALUES (2022, 506, 2, 'Identify your station by transmitting your call sign at least 3 times', ' ');
INSERT INTO answer VALUES (2024, 506, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2025, 507, 0, 'Only contacts with stations not within the 48 contiguous states', ' ');
INSERT INTO answer VALUES (2026, 507, 1, 'Only contacts with other stations within the 48 contiguous states', ' ');
INSERT INTO answer VALUES (2027, 507, 2, 'Only digital contacts', ' ');
INSERT INTO answer VALUES (2028, 507, 3, 'Only SSTV contacts', ' ');
INSERT INTO answer VALUES (2029, 508, 0, 'Only a person holding an FCC-issued amateur operator license', ' ');
INSERT INTO answer VALUES (2030, 508, 1, 'Only a RACES net control operator', ' ');
INSERT INTO answer VALUES (2031, 508, 2, 'A person holding an FCC-issued amateur operator license or an appropriate government official', ' ');
INSERT INTO answer VALUES (2032, 508, 3, 'Any control operator when normal communication systems are operational', ' ');
INSERT INTO answer VALUES (2035, 509, 0, 'At any time during an actual emergency', ' ');
INSERT INTO answer VALUES (2033, 509, 1, 'Only when transmitting in RACES', ' ');
INSERT INTO answer VALUES (2034, 509, 2, 'At any time when transmitting in an organized net', ' ');
INSERT INTO answer VALUES (2036, 509, 3, 'Only on authorized HF frequencies', ' ');
INSERT INTO answer VALUES (2037, 510, 0, 'Whichever frequency has the best chance of communicating the distress message', ' ');
INSERT INTO answer VALUES (2038, 510, 1, 'Only frequencies authorized for RACES or ARES stations', ' ');
INSERT INTO answer VALUES (2039, 510, 2, 'Only frequencies that are within your operating privileges', ' ');
INSERT INTO answer VALUES (2040, 510, 3, 'Only frequencies used by police, fire, or emergency medical services', ' ');
INSERT INTO answer VALUES (2044, 511, 0, 'Transmitting stations can receive between code characters and elements', ' ');
INSERT INTO answer VALUES (2041, 511, 1, 'Breaking stations send the Morse code prosign “BK”', ' ');
INSERT INTO answer VALUES (2042, 511, 2, 'Automatic keyers, instead of hand keys, are used to send Morse code', ' ');
INSERT INTO answer VALUES (2043, 511, 3, 'An operator must activate a manual send/receive switch before and after every transmission', ' ');
INSERT INTO answer VALUES (2045, 512, 0, 'Send slower', ' ');
INSERT INTO answer VALUES (2046, 512, 1, 'Change frequency', ' ');
INSERT INTO answer VALUES (2047, 512, 2, 'Increase your power', ' ');
INSERT INTO answer VALUES (2048, 512, 3, 'Repeat everything twice', ' ');
INSERT INTO answer VALUES (2051, 513, 0, 'Listening only for a specific station or stations', ' ');
INSERT INTO answer VALUES (2049, 513, 1, 'Listening for novice stations', ' ');
INSERT INTO answer VALUES (2050, 513, 2, 'Operating full break-in', ' ');
INSERT INTO answer VALUES (2052, 513, 3, 'Closing station now', ' ');
INSERT INTO answer VALUES (2056, 514, 0, '“Are you busy?” or “Is this frequency in use?”', ' ');
INSERT INTO answer VALUES (2053, 514, 1, '“Will you keep the frequency clear?”', ' ');
INSERT INTO answer VALUES (2054, 514, 2, '“Are you operating full break-in?” or “Can you operate full break-in?”', ' ');
INSERT INTO answer VALUES (2055, 514, 3, '“Are you listening only for a specific station?”', ' ');
INSERT INTO answer VALUES (2058, 515, 0, 'The fastest speed at which you are comfortable copying, but no faster than the CQ', ' ');
INSERT INTO answer VALUES (2057, 515, 1, 'The fastest speed at which you are comfortable copying, but no slower than the CQ', ' ');
INSERT INTO answer VALUES (2059, 515, 2, 'At the standard calling speed of 10 wpm', ' ');
INSERT INTO answer VALUES (2060, 515, 3, 'At the standard calling speed of 5 wpm', ' ');
INSERT INTO answer VALUES (2064, 516, 0, 'Matching the transmit frequency to the frequency of a received signal', ' ');
INSERT INTO answer VALUES (2061, 516, 1, 'Matching the speed of the transmitting station', ' ');
INSERT INTO answer VALUES (2062, 516, 2, 'Operating split to avoid interference on frequency', ' ');
INSERT INTO answer VALUES (2063, 516, 3, 'Sending without error', ' ');
INSERT INTO answer VALUES (2065, 517, 0, 'Chirpy or unstable signal', ' ');
INSERT INTO answer VALUES (2066, 517, 1, 'Report was read from an S meter rather than estimated', ' ');
INSERT INTO answer VALUES (2067, 517, 2, '100 percent copy', ' ');
INSERT INTO answer VALUES (2068, 517, 3, 'Key clicks', ' ');
INSERT INTO answer VALUES (2071, 518, 0, 'AR', ' ');
INSERT INTO answer VALUES (2069, 518, 1, 'SK', ' ');
INSERT INTO answer VALUES (2070, 518, 2, 'BK', ' ');
INSERT INTO answer VALUES (2072, 518, 3, 'KN', ' ');
INSERT INTO answer VALUES (2075, 519, 0, 'I acknowledge receipt', ' ');
INSERT INTO answer VALUES (2073, 519, 1, 'Send slower', ' ');
INSERT INTO answer VALUES (2074, 519, 2, 'We have already confirmed by card', ' ');
INSERT INTO answer VALUES (2076, 519, 3, 'We have worked before', ' ');
INSERT INTO answer VALUES (2080, 520, 0, 'I am troubled by static', ' ');
INSERT INTO answer VALUES (2077, 520, 1, 'Send more slowly', ' ');
INSERT INTO answer VALUES (2078, 520, 2, 'Stop sending', ' ');
INSERT INTO answer VALUES (2079, 520, 3, 'Zero beat my signal', ' ');
INSERT INTO answer VALUES (2084, 521, 0, 'I am ready to receive messages', ' ');
INSERT INTO answer VALUES (2081, 521, 1, 'You are sending too fast', ' ');
INSERT INTO answer VALUES (2082, 521, 2, 'There is interference on the frequency', ' ');
INSERT INTO answer VALUES (2083, 521, 3, 'I am quitting for the day', ' ');
INSERT INTO answer VALUES (2085, 522, 0, 'Amateur volunteers who are formally enlisted to monitor the airwaves for rules violations', ' ');
INSERT INTO answer VALUES (2086, 522, 1, 'Amateur volunteers who conduct amateur licensing examinations', ' ');
INSERT INTO answer VALUES (2087, 522, 2, 'Amateur volunteers who conduct frequency coordination for amateur VHF repeaters', ' ');
INSERT INTO answer VALUES (2088, 522, 3, 'Amateur volunteers who use their station equipment to help civil defense organizations in times of emergency', ' ');
INSERT INTO answer VALUES (2090, 523, 0, 'To encourage amateur radio operators to self-regulate and comply with the rules', ' ');
INSERT INTO answer VALUES (2089, 523, 1, 'To conduct efficient and orderly amateur licensing examinations', ' ');
INSERT INTO answer VALUES (2091, 523, 2, 'To coordinate repeaters for efficient and orderly spectrum usage', ' ');
INSERT INTO answer VALUES (2092, 523, 3, 'To provide emergency and public safety communications', ' ');
INSERT INTO answer VALUES (2094, 524, 0, 'Direction finding used to locate stations violating FCC rules', ' ');
INSERT INTO answer VALUES (2093, 524, 1, 'Identification of out-of-band operation', ' ');
INSERT INTO answer VALUES (2095, 524, 2, 'Identification of different call signs', ' ');
INSERT INTO answer VALUES (2096, 524, 3, 'Hunters have an opportunity to transmit on non-amateur frequencies', ' ');
INSERT INTO answer VALUES (2098, 525, 0, 'A map that shows true bearings and distances from a particular location', ' ');
INSERT INTO answer VALUES (2097, 525, 1, 'A map that shows accurate land masses', ' ');
INSERT INTO answer VALUES (2099, 525, 2, 'A map that shows the angle at which an amateur satellite crosses the equator', ' ');
INSERT INTO answer VALUES (2100, 525, 3, 'A map that shows the number of degrees longitude that an amateur satellite appears to move westward at the equator with each orbit', ' ');
INSERT INTO answer VALUES (2103, 526, 0, 'Repeat “CQ” a few times, followed by “this is,” then your call sign a few times, then pause to listen, repeat as necessary', ' ');
INSERT INTO answer VALUES (2101, 526, 1, 'Sign your call sign once, followed by the words “listening for a call” -- if no answer, change frequency and repeat', ' ');
INSERT INTO answer VALUES (2102, 526, 2, 'Say “QTC” followed by “this is” and your call sign -- if no answer, change frequency and repeat', ' ');
INSERT INTO answer VALUES (2104, 526, 3, 'Transmit an unmodulated carried for approximately 10 seconds, followed by “this is” and your call sign, and pause to listen -- repeat as necessary', ' ');
INSERT INTO answer VALUES (2107, 527, 0, '180 degrees from the station’s short-path heading', ' ');
INSERT INTO answer VALUES (2105, 527, 1, 'Toward the rising sun', ' ');
INSERT INTO answer VALUES (2106, 527, 2, 'Along the grayline', ' ');
INSERT INTO answer VALUES (2108, 527, 3, 'Toward the north', ' ');
INSERT INTO answer VALUES (2112, 528, 0, 'Alpha, Bravo, Charlie, Delta', ' ');
INSERT INTO answer VALUES (2109, 528, 1, 'Able, Baker, Charlie, Dog', ' ');
INSERT INTO answer VALUES (2110, 528, 2, 'Adam, Boy, Charles, David', ' ');
INSERT INTO answer VALUES (2111, 528, 3, 'America, Boston, Canada, Denmark', ' ');
INSERT INTO answer VALUES (2116, 529, 0, 'To help with a reply if the FCC requests information', ' ');
INSERT INTO answer VALUES (2113, 529, 1, 'The ITU requires a log of all international contacts', ' ');
INSERT INTO answer VALUES (2114, 529, 2, 'The ITU requires a log of all international third-party traffic', ' ');
INSERT INTO answer VALUES (2115, 529, 3, 'The log provides evidence of operation needed to renew a license without retest', ' ');
INSERT INTO answer VALUES (2119, 530, 0, 'Identify your station per normal FCC regulations', ' ');
INSERT INTO answer VALUES (2117, 530, 1, 'Submit a log to the contest sponsor', ' ');
INSERT INTO answer VALUES (2118, 530, 2, 'Send a QSL card to the stations worked, or QSL via Logbook of The World', ' ');
INSERT INTO answer VALUES (2120, 530, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2122, 531, 0, 'Low-power transmit operation', ' ');
INSERT INTO answer VALUES (2121, 531, 1, 'Remote piloted model control', ' ');
INSERT INTO answer VALUES (2123, 531, 2, 'Transmission using Quick Response Protocol', ' ');
INSERT INTO answer VALUES (2124, 531, 3, 'Traffic relay procedure net operation', ' ');
INSERT INTO answer VALUES (2128, 532, 0, 'High levels of atmospheric noise or “static”', ' ');
INSERT INTO answer VALUES (2125, 532, 1, 'Poor propagation at any time of day', ' ');
INSERT INTO answer VALUES (2126, 532, 2, 'World-wide propagation during the daylight hours', ' ');
INSERT INTO answer VALUES (2127, 532, 3, 'Heavy distortion on signals due to photon absorption', ' ');
INSERT INTO answer VALUES (2132, 533, 0, 'LSB', ' ');
INSERT INTO answer VALUES (2129, 533, 1, 'USB', ' ');
INSERT INTO answer VALUES (2130, 533, 2, 'DSB', ' ');
INSERT INTO answer VALUES (2131, 533, 3, 'CW', ' ');
INSERT INTO answer VALUES (2134, 534, 0, 'Put the modem or controller in a mode which allows monitoring communications without a connection', ' ');
INSERT INTO answer VALUES (2133, 534, 1, 'Unplug the data connector temporarily and see if the channel-busy indication is turned off', ' ');
INSERT INTO answer VALUES (2135, 534, 2, 'Transmit UI packets several times and wait to see if there is a response from another PACTOR station', ' ');
INSERT INTO answer VALUES (2136, 534, 3, 'Send the message, ”Is this frequency in use?”', ' ');
INSERT INTO answer VALUES (2140, 535, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2137, 535, 1, 'Frequent retries or timeouts', ' ');
INSERT INTO answer VALUES (2138, 535, 2, 'Long pauses in message transmission', ' ');
INSERT INTO answer VALUES (2139, 535, 3, 'Failure to establish a connection between stations', ' ');
INSERT INTO answer VALUES (2142, 536, 0, '14.070 - 14.112 MHz', ' ');
INSERT INTO answer VALUES (2141, 536, 1, '14.000 - 14.050 MHz', ' ');
INSERT INTO answer VALUES (2143, 536, 2, '14.150 - 14.225 MHz', ' ');
INSERT INTO answer VALUES (2144, 536, 3, '14.275 - 14.350 MHz', ' ');
INSERT INTO answer VALUES (2146, 537, 0, 'USB', ' ');
INSERT INTO answer VALUES (2145, 537, 1, 'LSB', ' ');
INSERT INTO answer VALUES (2147, 537, 2, 'DSB', ' ');
INSERT INTO answer VALUES (2148, 537, 3, 'SSB', ' ');
INSERT INTO answer VALUES (2150, 538, 0, '170 Hz', ' ');
INSERT INTO answer VALUES (2149, 538, 1, '85 Hz', ' ');
INSERT INTO answer VALUES (2151, 538, 2, '425 Hz', ' ');
INSERT INTO answer VALUES (2152, 538, 3, '850 Hz', ' ');
INSERT INTO answer VALUES (2153, 539, 0, '3570 – 3600 kHz', ' ');
INSERT INTO answer VALUES (2154, 539, 1, '3500 – 3525 kHz', ' ');
INSERT INTO answer VALUES (2155, 539, 2, '3700 – 3750 kHz', ' ');
INSERT INTO answer VALUES (2156, 539, 3, '3775 – 3825 kHz', ' ');
INSERT INTO answer VALUES (2160, 540, 0, 'Below the RTTY segment, near 14.070 MHz', ' ');
INSERT INTO answer VALUES (2157, 540, 1, 'At the bottom of the slow-scan TV segment, near 14.230 MHz', ' ');
INSERT INTO answer VALUES (2158, 540, 2, 'At the top of the SSB phone segment, near 14.325 MHz', ' ');
INSERT INTO answer VALUES (2159, 540, 3, 'In the middle of the CW segment, near 14.100 MHz', ' ');
INSERT INTO answer VALUES (2163, 541, 0, 'Joining an existing contact is not possible, PACTOR connections are limited to two stations', ' ');
INSERT INTO answer VALUES (2161, 541, 1, 'Send broadcast packets containing your call sign while in MONITOR mode', ' ');
INSERT INTO answer VALUES (2162, 541, 2, 'Transmit a steady carrier until the PACTOR protocol times out and disconnects', ' ');
INSERT INTO answer VALUES (2164, 541, 3, 'Send a NAK response continuously so that the sending station must stand by', ' ');
INSERT INTO answer VALUES (2168, 542, 0, 'Transmit a connect message on the station’s published frequency', ' ');
INSERT INTO answer VALUES (2165, 542, 1, 'Send an email to the system control operator', ' ');
INSERT INTO answer VALUES (2166, 542, 2, 'Send QRL in Morse code', ' ');
INSERT INTO answer VALUES (2167, 542, 3, 'Respond when the station broadcasts its SSID', ' ');
INSERT INTO answer VALUES (2172, 543, 0, 'Typical exchanges are limited to call signs, grid locators, and signal reports', ' ');
INSERT INTO answer VALUES (2169, 543, 1, 'It is a keyboard-to-keyboard chat mode', ' ');
INSERT INTO answer VALUES (2170, 543, 2, 'Each transmission takes exactly 60 seconds', ' ');
INSERT INTO answer VALUES (2171, 543, 3, 'It is limited to use on VHF', ' ');
INSERT INTO answer VALUES (2176, 544, 0, 'DE-9', ' ');
INSERT INTO answer VALUES (2173, 544, 1, 'PL-259', ' ');
INSERT INTO answer VALUES (2174, 544, 2, 'Type N', ' ');
INSERT INTO answer VALUES (2175, 544, 3, 'Type SMA', ' ');
INSERT INTO answer VALUES (2177, 545, 0, 'Winlink', ' ');
INSERT INTO answer VALUES (2178, 545, 1, 'RTTY', ' ');
INSERT INTO answer VALUES (2179, 545, 2, 'ARES', ' ');
INSERT INTO answer VALUES (2180, 545, 3, 'SKYWARN', ' ');
INSERT INTO answer VALUES (2184, 546, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2181, 546, 1, 'The mark and space frequencies may be reversed', ' ');
INSERT INTO answer VALUES (2182, 546, 2, 'You may have selected the wrong baud rate', ' ');
INSERT INTO answer VALUES (2183, 546, 3, 'You may be listening on the wrong sideband', ' ');
INSERT INTO answer VALUES (2186, 547, 0, 'Computer time accurate within approximately 1 second', ' ');
INSERT INTO answer VALUES (2185, 547, 1, 'A special hardware modem', ' ');
INSERT INTO answer VALUES (2187, 547, 2, 'Receiver attenuator set to -12 dB', ' ');
INSERT INTO answer VALUES (2188, 547, 3, 'A vertically polarized antenna', ' ');
INSERT INTO answer VALUES (2189, 548, 0, 'Higher sunspot numbers generally indicate a greater probability of good propagation at higher frequencies', ' ');
INSERT INTO answer VALUES (2190, 548, 1, 'Lower sunspot numbers generally indicate greater probability of sporadic E propagation', ' ');
INSERT INTO answer VALUES (2191, 548, 2, 'A zero sunspot number indicates that radio propagation is not possible on any band', ' ');
INSERT INTO answer VALUES (2192, 548, 3, 'A zero sunspot number indicates undisturbed conditions', ' ');
INSERT INTO answer VALUES (2194, 549, 0, 'It disrupts signals on lower frequencies more than those on higher frequencies', ' ');
INSERT INTO answer VALUES (2193, 549, 1, 'It enhances propagation on all HF frequencies', ' ');
INSERT INTO answer VALUES (2195, 549, 2, 'It disrupts communications via satellite more than direct communications', ' ');
INSERT INTO answer VALUES (2196, 549, 3, 'None, because only areas on the night side of the Earth are affected', ' ');
INSERT INTO answer VALUES (2199, 550, 0, '8 minutes', ' ');
INSERT INTO answer VALUES (2197, 550, 1, '28 days', ' ');
INSERT INTO answer VALUES (2198, 550, 2, '1 to 2 hours', ' ');
INSERT INTO answer VALUES (2200, 550, 3, '20 to 40 hours', ' ');
INSERT INTO answer VALUES (2204, 551, 0, '15 meters, 12 meters, and 10 meters', ' ');
INSERT INTO answer VALUES (2201, 551, 1, '80 meters and 160 meters', ' ');
INSERT INTO answer VALUES (2202, 551, 2, '60 meters and 40 meters', ' ');
INSERT INTO answer VALUES (2203, 551, 3, '30 meters and 20 meters', ' ');
INSERT INTO answer VALUES (2208, 552, 0, 'A measure of solar radiation at 10.7 centimeters wavelength', ' ');
INSERT INTO answer VALUES (2205, 552, 1, 'A measure of the highest frequency that is useful for ionospheric propagation between two points on Earth', ' ');
INSERT INTO answer VALUES (2206, 552, 2, 'A count of sunspots that is adjusted for solar emissions', ' ');
INSERT INTO answer VALUES (2207, 552, 3, 'Another name for the American sunspot number', ' ');
INSERT INTO answer VALUES (2212, 553, 0, 'A temporary disturbance in Earth’s magnetosphere', ' ');
INSERT INTO answer VALUES (2209, 553, 1, 'A sudden drop in the solar flux index', ' ');
INSERT INTO answer VALUES (2210, 553, 2, 'A thunderstorm that affects radio propagation', ' ');
INSERT INTO answer VALUES (2211, 553, 3, 'Ripples in the ionosphere', ' ');
INSERT INTO answer VALUES (2216, 554, 0, 'At any point in the solar cycle', ' ');
INSERT INTO answer VALUES (2213, 554, 1, 'At the summer solstice', ' ');
INSERT INTO answer VALUES (2214, 554, 2, 'Only at the maximum point of the solar cycle', ' ');
INSERT INTO answer VALUES (2215, 554, 3, 'Only at the minimum point of the solar cycle', ' ');
INSERT INTO answer VALUES (2218, 555, 0, 'Degraded high-latitude HF propagation', ' ');
INSERT INTO answer VALUES (2217, 555, 1, 'Improved high-latitude HF propagation', ' ');
INSERT INTO answer VALUES (2219, 555, 2, 'Improved ground wave propagation', ' ');
INSERT INTO answer VALUES (2220, 555, 3, 'Degraded ground wave propagation', ' ');
INSERT INTO answer VALUES (2221, 556, 0, 'Auroras that can reflect VHF signals', ' ');
INSERT INTO answer VALUES (2222, 556, 1, 'Higher signal strength for HF signals passing through the polar regions', ' ');
INSERT INTO answer VALUES (2223, 556, 2, 'Improved HF long path propagation', ' ');
INSERT INTO answer VALUES (2224, 556, 3, 'Reduced long delayed echoes', ' ');
INSERT INTO answer VALUES (2227, 557, 0, 'The sun’s rotation on its axis', ' ');
INSERT INTO answer VALUES (2225, 557, 1, 'Long term oscillations in the upper atmosphere', ' ');
INSERT INTO answer VALUES (2226, 557, 2, 'Cyclic variation in Earth’s radiation belts', ' ');
INSERT INTO answer VALUES (2228, 557, 3, 'The position of the moon in its orbit', ' ');
INSERT INTO answer VALUES (2232, 558, 0, '20 to 40 hours', ' ');
INSERT INTO answer VALUES (2229, 558, 1, '28 days', ' ');
INSERT INTO answer VALUES (2230, 558, 2, '14 days', ' ');
INSERT INTO answer VALUES (2231, 558, 3, '4 to 8 minutes', ' ');
INSERT INTO answer VALUES (2234, 559, 0, 'The short-term stability of Earth’s magnetic field', ' ');
INSERT INTO answer VALUES (2233, 559, 1, 'The relative position of sunspots on the surface of the sun', ' ');
INSERT INTO answer VALUES (2235, 559, 2, 'The stability of the sun’s magnetic field', ' ');
INSERT INTO answer VALUES (2236, 559, 3, 'The solar radio flux at Boulder, Colorado', ' ');
INSERT INTO answer VALUES (2239, 560, 0, 'The long-term stability of Earth’s geomagnetic field', ' ');
INSERT INTO answer VALUES (2237, 560, 1, 'The relative position of sunspots on the surface of the sun', ' ');
INSERT INTO answer VALUES (2238, 560, 2, 'The amount of polarization of the sun’s electric field', ' ');
INSERT INTO answer VALUES (2240, 560, 3, 'The solar radio flux at Boulder, Colorado', ' ');
INSERT INTO answer VALUES (2242, 561, 0, 'HF communications are disturbed', ' ');
INSERT INTO answer VALUES (2241, 561, 1, 'HF communications are improved', ' ');
INSERT INTO answer VALUES (2243, 561, 2, 'VHF/UHF ducting is improved', ' ');
INSERT INTO answer VALUES (2244, 561, 3, 'VHF/UHF ducting is disturbed', ' ');
INSERT INTO answer VALUES (2248, 562, 0, 'A slightly delayed echo might be heard', ' ');
INSERT INTO answer VALUES (2245, 562, 1, 'Periodic fading approximately every 10 seconds', ' ');
INSERT INTO answer VALUES (2246, 562, 2, 'Signal strength increased by 3 dB', ' ');
INSERT INTO answer VALUES (2247, 562, 3, 'The signal might be cancelled causing severe attenuation', ' ');
INSERT INTO answer VALUES (2252, 563, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2249, 563, 1, 'Path distance and location', ' ');
INSERT INTO answer VALUES (2250, 563, 2, 'Time of day and season', ' ');
INSERT INTO answer VALUES (2251, 563, 3, 'Solar radiation and ionospheric disturbances', ' ');
INSERT INTO answer VALUES (2253, 564, 0, 'Select a frequency just below the MUF', ' ');
INSERT INTO answer VALUES (2254, 564, 1, 'Select a frequency just above the LUF', ' ');
INSERT INTO answer VALUES (2255, 564, 2, 'Select a frequency just below the critical frequency', ' ');
INSERT INTO answer VALUES (2256, 564, 3, 'Select a frequency just above the critical frequency', ' ');
INSERT INTO answer VALUES (2257, 565, 0, 'Listen for signals from an international beacon in the frequency range you plan to use', ' ');
INSERT INTO answer VALUES (2258, 565, 1, 'Send a series of dots on the band and listen for echoes from your signal', ' ');
INSERT INTO answer VALUES (2259, 565, 2, 'Check the strength of TV signals from western Europe', ' ');
INSERT INTO answer VALUES (2260, 565, 3, 'Check the strength of signals in the MF AM broadcast band', ' ');
INSERT INTO answer VALUES (2261, 566, 0, 'They are bent back to Earth', ' ');
INSERT INTO answer VALUES (2262, 566, 1, 'They pass through the ionosphere', ' ');
INSERT INTO answer VALUES (2263, 566, 2, 'They are amplified by interaction with the ionosphere', ' ');
INSERT INTO answer VALUES (2264, 566, 3, 'They are bent and trapped in the ionosphere to circle Earth', ' ');
INSERT INTO answer VALUES (2267, 567, 0, 'They are completely absorbed by the ionosphere', ' ');
INSERT INTO answer VALUES (2265, 567, 1, 'They are bent back to Earth', ' ');
INSERT INTO answer VALUES (2266, 567, 2, 'They pass through the ionosphere', ' ');
INSERT INTO answer VALUES (2268, 567, 3, 'They are bent and trapped in the ionosphere to circle Earth', ' ');
INSERT INTO answer VALUES (2269, 568, 0, 'The Lowest Usable Frequency for communications between two points', ' ');
INSERT INTO answer VALUES (2270, 568, 1, 'The Longest Universal Function for communications between two points', ' ');
INSERT INTO answer VALUES (2271, 568, 2, 'The Lowest Usable Frequency during a 24-hour period', ' ');
INSERT INTO answer VALUES (2272, 568, 3, 'The Longest Universal Function during a 24-hour period', ' ');
INSERT INTO answer VALUES (2274, 569, 0, 'The Maximum Usable Frequency for communications between two points', ' ');
INSERT INTO answer VALUES (2273, 569, 1, 'The Minimum Usable Frequency for communications between two points', ' ');
INSERT INTO answer VALUES (2275, 569, 2, 'The Minimum Usable Frequency during a 24-hour period', ' ');
INSERT INTO answer VALUES (2276, 569, 3, 'The Maximum Usable Frequency during a 24-hour period', ' ');
INSERT INTO answer VALUES (2279, 570, 0, '2,500 miles', ' ');
INSERT INTO answer VALUES (2277, 570, 1, '180 miles', ' ');
INSERT INTO answer VALUES (2278, 570, 2, '1,200 miles', ' ');
INSERT INTO answer VALUES (2280, 570, 3, '12,000 miles', ' ');
INSERT INTO answer VALUES (2282, 571, 0, '1,200 miles', ' ');
INSERT INTO answer VALUES (2281, 571, 1, '180 miles', ' ');
INSERT INTO answer VALUES (2283, 571, 2, '2,500 miles', ' ');
INSERT INTO answer VALUES (2284, 571, 3, '12,000 miles', ' ');
INSERT INTO answer VALUES (2285, 572, 0, 'No HF radio frequency will support ordinary skywave communications over the path', ' ');
INSERT INTO answer VALUES (2286, 572, 1, 'HF communications over the path are enhanced', ' ');
INSERT INTO answer VALUES (2287, 572, 2, 'Double hop propagation along the path is more common', ' ');
INSERT INTO answer VALUES (2288, 572, 3, 'Propagation over the path on all HF frequencies is enhanced', ' ');
INSERT INTO answer VALUES (2289, 573, 0, 'The D layer', ' ');
INSERT INTO answer VALUES (2290, 573, 1, 'The E layer', ' ');
INSERT INTO answer VALUES (2291, 573, 2, 'The F1 layer', ' ');
INSERT INTO answer VALUES (2292, 573, 3, 'The F2 layer', ' ');
INSERT INTO answer VALUES (2293, 574, 0, 'Where the sun is overhead', ' ');
INSERT INTO answer VALUES (2294, 574, 1, 'Where the sun is on the opposite side of Earth', ' ');
INSERT INTO answer VALUES (2295, 574, 2, 'Where the sun is rising', ' ');
INSERT INTO answer VALUES (2296, 574, 3, 'Where the sun has just set', ' ');
INSERT INTO answer VALUES (2299, 575, 0, 'Because it is the highest ionospheric region', ' ');
INSERT INTO answer VALUES (2297, 575, 1, 'Because it is the densest ionospheric layer', ' ');
INSERT INTO answer VALUES (2298, 575, 2, 'Because of the Doppler effect', ' ');
INSERT INTO answer VALUES (2300, 575, 3, 'Because of meteor trails at that level', ' ');
INSERT INTO answer VALUES (2304, 576, 0, 'The highest takeoff angle that will return a radio wave to Earth under specific ionospheric conditions', ' ');
INSERT INTO answer VALUES (2301, 576, 1, 'The long path azimuth of a distant station', ' ');
INSERT INTO answer VALUES (2302, 576, 2, 'The short path azimuth of a distant station', ' ');
INSERT INTO answer VALUES (2303, 576, 3, 'The lowest takeoff angle that will return a radio wave to Earth under specific ionospheric conditions', ' ');
INSERT INTO answer VALUES (2307, 577, 0, 'The D layer absorbs signals at these frequencies during daylight hours', ' ');
INSERT INTO answer VALUES (2305, 577, 1, 'The F layer absorbs signals at these frequencies during daylight hours', ' ');
INSERT INTO answer VALUES (2306, 577, 2, 'The F layer is unstable during daylight hours', ' ');
INSERT INTO answer VALUES (2308, 577, 3, 'The E layer is unstable during daylight hours', ' ');
INSERT INTO answer VALUES (2310, 578, 0, 'Signals have a fluttering sound', ' ');
INSERT INTO answer VALUES (2309, 578, 1, 'Phone signals have high intelligibility', ' ');
INSERT INTO answer VALUES (2311, 578, 2, 'There are very large, sudden swings in signal strength', ' ');
INSERT INTO answer VALUES (2312, 578, 3, 'Scatter propagation occurs only at night', ' ');
INSERT INTO answer VALUES (2316, 579, 0, 'Energy is scattered into the skip zone through several different radio wave paths', ' ');
INSERT INTO answer VALUES (2313, 579, 1, 'The ionospheric layer involved is unstable', ' ');
INSERT INTO answer VALUES (2314, 579, 2, 'Ground waves are absorbing much of the signal', ' ');
INSERT INTO answer VALUES (2315, 579, 3, 'The E-region is not present', ' ');
INSERT INTO answer VALUES (2317, 580, 0, 'Only a small part of the signal energy is scattered into the skip zone', ' ');
INSERT INTO answer VALUES (2318, 580, 1, 'Signals are scattered from the magnetosphere, which is not a good reflector', ' ');
INSERT INTO answer VALUES (2319, 580, 2, 'Propagation is through ground waves, which absorb most of the signal energy', ' ');
INSERT INTO answer VALUES (2320, 580, 3, 'Propagation is through ducts in the F region, which absorb most of the energy', ' ');
INSERT INTO answer VALUES (2322, 581, 0, 'Scatter', ' ');
INSERT INTO answer VALUES (2321, 581, 1, 'Faraday rotation', ' ');
INSERT INTO answer VALUES (2323, 581, 2, 'Chordal hop', ' ');
INSERT INTO answer VALUES (2324, 581, 3, 'Short-path', ' ');
INSERT INTO answer VALUES (2326, 582, 0, 'Short distance MF or HF propagation using high elevation angles', ' ');
INSERT INTO answer VALUES (2325, 582, 1, 'Propagation near the MUF', ' ');
INSERT INTO answer VALUES (2327, 582, 2, 'Long path HF propagation at sunrise and sunset', ' ');
INSERT INTO answer VALUES (2328, 582, 3, 'Double hop propagation near the LUF', ' ');
INSERT INTO answer VALUES (2332, 583, 0, 'The D layer', ' ');
INSERT INTO answer VALUES (2329, 583, 1, 'The F2 layer', ' ');
INSERT INTO answer VALUES (2330, 583, 2, 'The F1 layer', ' ');
INSERT INTO answer VALUES (2331, 583, 3, 'The E layer', ' ');
INSERT INTO answer VALUES (2334, 584, 0, 'To reduce interference from carriers in the receiver passband', ' ');
INSERT INTO answer VALUES (2333, 584, 1, 'To restrict the transmitter voice bandwidth', ' ');
INSERT INTO answer VALUES (2335, 584, 2, 'To eliminate receiver interference from impulse noise sources', ' ');
INSERT INTO answer VALUES (2336, 584, 3, 'To enhance the reception of a specific frequency on a crowded band', ' ');
INSERT INTO answer VALUES (2339, 585, 0, 'It may be possible to reduce or eliminate interference from other signals', ' ');
INSERT INTO answer VALUES (2337, 585, 1, 'Interference from impulse noise will be eliminated', ' ');
INSERT INTO answer VALUES (2338, 585, 2, 'More stations can be accommodated within a given signal passband', ' ');
INSERT INTO answer VALUES (2340, 585, 3, 'Accidental out-of-band operation can be prevented', ' ');
INSERT INTO answer VALUES (2343, 586, 0, 'The transceiver is set to different transmit and receive frequencies', ' ');
INSERT INTO answer VALUES (2341, 586, 1, 'The radio is operating at half power', ' ');
INSERT INTO answer VALUES (2342, 586, 2, 'The transceiver is operating from an external power source', ' ');
INSERT INTO answer VALUES (2344, 586, 3, 'The transmitter is emitting an SSB signal, as opposed to DSB operation', ' ');
INSERT INTO answer VALUES (2346, 587, 0, 'A pronounced dip', ' ');
INSERT INTO answer VALUES (2345, 587, 1, 'A pronounced peak', ' ');
INSERT INTO answer VALUES (2347, 587, 2, 'No change will be observed', ' ');
INSERT INTO answer VALUES (2348, 587, 3, 'A slow, rhythmic oscillation', ' ');
INSERT INTO answer VALUES (2351, 588, 0, 'To reduce distortion due to excessive drive', ' ');
INSERT INTO answer VALUES (2349, 588, 1, 'To balance the transmitter audio frequency response', ' ');
INSERT INTO answer VALUES (2350, 588, 2, 'To reduce harmonic radiation', ' ');
INSERT INTO answer VALUES (2352, 588, 3, 'To increase overall efficiency', ' ');
INSERT INTO answer VALUES (2355, 589, 0, 'Antenna coupler or antenna tuner', ' ');
INSERT INTO answer VALUES (2353, 589, 1, 'Balanced modulator', ' ');
INSERT INTO answer VALUES (2354, 589, 2, 'SWR bridge', ' ');
INSERT INTO answer VALUES (2356, 589, 3, 'Q multiplier', ' ');
INSERT INTO answer VALUES (2360, 590, 0, 'Excessive drive power', ' ');
INSERT INTO answer VALUES (2357, 590, 1, 'Insufficient drive power', ' ');
INSERT INTO answer VALUES (2358, 590, 2, 'Low input SWR', ' ');
INSERT INTO answer VALUES (2359, 590, 3, 'Shorting the input signal to ground', ' ');
INSERT INTO answer VALUES (2364, 591, 0, 'Maximum power output without exceeding maximum allowable plate current', ' ');
INSERT INTO answer VALUES (2361, 591, 1, 'Minimum SWR on the antenna', ' ');
INSERT INTO answer VALUES (2362, 591, 2, 'Minimum plate current without exceeding maximum allowable grid current', ' ');
INSERT INTO answer VALUES (2363, 591, 3, 'Highest plate voltage while minimizing grid current', ' ');
INSERT INTO answer VALUES (2367, 592, 0, 'To allow time for transmit-receive changeover operations to complete properly before RF output is allowed', ' ');
INSERT INTO answer VALUES (2365, 592, 1, 'To prevent stations from interfering with one another', ' ');
INSERT INTO answer VALUES (2366, 592, 2, 'To allow the transmitter power regulators to charge properly', ' ');
INSERT INTO answer VALUES (2368, 592, 3, 'To allow time for a warning signal to be sent to other stations', ' ');
INSERT INTO answer VALUES (2370, 593, 0, 'Automatic generation of strings of dots and dashes for CW operation', ' ');
INSERT INTO answer VALUES (2369, 593, 1, 'Automatic transmit/receive switching', ' ');
INSERT INTO answer VALUES (2371, 593, 2, 'VOX operation', ' ');
INSERT INTO answer VALUES (2372, 593, 3, 'Computer interface for PSK and RTTY operation', ' ');
INSERT INTO answer VALUES (2373, 594, 0, 'To avoid interference from stations very close to the receive frequency', ' ');
INSERT INTO answer VALUES (2374, 594, 1, 'To change frequency rapidly', ' ');
INSERT INTO answer VALUES (2375, 594, 2, 'To permit listening on a different frequency from that on which you are transmitting', ' ');
INSERT INTO answer VALUES (2376, 594, 3, 'To tune in stations that are slightly off frequency without changing your transmit frequency', ' ');
INSERT INTO answer VALUES (2379, 595, 0, 'To permit monitoring of two different frequencies', ' ');
INSERT INTO answer VALUES (2377, 595, 1, 'To allow transmitting on two frequencies at once', ' ');
INSERT INTO answer VALUES (2378, 595, 2, 'To permit full duplex operation — that is, transmitting and receiving at the same time', ' ');
INSERT INTO answer VALUES (2380, 595, 3, 'To facilitate computer interface', ' ');
INSERT INTO answer VALUES (2381, 596, 0, 'To reduce signal overload due to strong incoming signals', ' ');
INSERT INTO answer VALUES (2382, 596, 1, 'To reduce the transmitter power when driving a linear amplifier', ' ');
INSERT INTO answer VALUES (2383, 596, 2, 'To reduce power consumption when operating from batteries', ' ');
INSERT INTO answer VALUES (2384, 596, 3, 'To slow down received CW signals for better copy', ' ');
INSERT INTO answer VALUES (2386, 597, 0, 'Improper action of ALC distorts the signal and can cause spurious emissions', ' ');
INSERT INTO answer VALUES (2385, 597, 1, 'ALC will invert the modulation of the AFSK mode', ' ');
INSERT INTO answer VALUES (2387, 597, 2, 'When using digital modes, too much ALC activity can cause the transmitter to overheat', ' ');
INSERT INTO answer VALUES (2388, 597, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2392, 598, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2389, 598, 1, 'The VOX circuit does not un-key the transmitter', ' ');
INSERT INTO answer VALUES (2390, 598, 2, 'The transmitter signal is distorted', ' ');
INSERT INTO answer VALUES (2391, 598, 3, 'Frequent connection timeouts', ' ');
INSERT INTO answer VALUES (2395, 599, 0, 'By reducing receiver gain during a noise pulse', ' ');
INSERT INTO answer VALUES (2393, 599, 1, 'By temporarily increasing received bandwidth', ' ');
INSERT INTO answer VALUES (2394, 599, 2, 'By redirecting noise pulses into a filter capacitor', ' ');
INSERT INTO answer VALUES (2396, 599, 3, 'By clipping noise peaks', ' ');
INSERT INTO answer VALUES (2397, 600, 0, 'Received signals may become distorted', ' ');
INSERT INTO answer VALUES (2398, 600, 1, 'Received frequency may become unstable', ' ');
INSERT INTO answer VALUES (2399, 600, 2, 'CW signals may become severely attenuated', ' ');
INSERT INTO answer VALUES (2400, 600, 3, 'Received frequency may shift several kHz', ' ');
INSERT INTO answer VALUES (2404, 601, 0, 'An oscilloscope', ' ');
INSERT INTO answer VALUES (2401, 601, 1, 'An ohmmeter', ' ');
INSERT INTO answer VALUES (2402, 601, 2, 'A signal generator', ' ');
INSERT INTO answer VALUES (2403, 601, 3, 'An ammeter', ' ');
INSERT INTO answer VALUES (2408, 602, 0, 'Complex waveforms can be measured', ' ');
INSERT INTO answer VALUES (2405, 602, 1, 'An oscilloscope uses less power', ' ');
INSERT INTO answer VALUES (2406, 602, 2, 'Complex impedances can be easily measured', ' ');
INSERT INTO answer VALUES (2407, 602, 3, 'Input impedance is much lower', ' ');
INSERT INTO answer VALUES (2409, 603, 0, 'An oscilloscope', ' ');
INSERT INTO answer VALUES (2410, 603, 1, 'A field strength meter', ' ');
INSERT INTO answer VALUES (2411, 603, 2, 'A sidetone monitor', ' ');
INSERT INTO answer VALUES (2412, 603, 3, 'A wavemeter', ' ');
INSERT INTO answer VALUES (2416, 604, 0, 'The attenuated RF output of the transmitter', ' ');
INSERT INTO answer VALUES (2413, 604, 1, 'The local oscillator of the transmitter', ' ');
INSERT INTO answer VALUES (2414, 604, 2, 'An external RF oscillator', ' ');
INSERT INTO answer VALUES (2415, 604, 3, 'The transmitter balanced mixer output', ' ');
INSERT INTO answer VALUES (2420, 605, 0, 'It decreases the loading on circuits being measured', ' ');
INSERT INTO answer VALUES (2417, 605, 1, 'It improves the frequency response', ' ');
INSERT INTO answer VALUES (2418, 605, 2, 'It decreases battery consumption in the meter', ' ');
INSERT INTO answer VALUES (2419, 605, 3, 'It improves the resolution of the readings', ' ');
INSERT INTO answer VALUES (2423, 606, 0, 'Better precision for most uses', ' ');
INSERT INTO answer VALUES (2421, 606, 1, 'Better for measuring computer circuits', ' ');
INSERT INTO answer VALUES (2422, 606, 2, 'Better for RF measurements', ' ');
INSERT INTO answer VALUES (2424, 606, 3, 'Faster response', ' ');
INSERT INTO answer VALUES (2426, 607, 0, 'Two non-harmonically related audio signals', ' ');
INSERT INTO answer VALUES (2425, 607, 1, 'Two audio signals of the same frequency shifted 90 degrees', ' ');
INSERT INTO answer VALUES (2427, 607, 2, 'Two swept frequency tones', ' ');
INSERT INTO answer VALUES (2428, 607, 3, 'Two audio frequency range square wave signals of equal amplitude', ' ');
INSERT INTO answer VALUES (2429, 608, 0, 'A field strength meter', ' ');
INSERT INTO answer VALUES (2430, 608, 1, 'An antenna noise bridge', ' ');
INSERT INTO answer VALUES (2431, 608, 2, 'A multimeter', ' ');
INSERT INTO answer VALUES (2432, 608, 3, 'A Q meter', ' ');
INSERT INTO answer VALUES (2434, 609, 0, 'The radiation pattern of an antenna', ' ');
INSERT INTO answer VALUES (2433, 609, 1, 'The radiation resistance of an antenna', ' ');
INSERT INTO answer VALUES (2435, 609, 2, 'The presence and amount of phase distortion of a transmitter', ' ');
INSERT INTO answer VALUES (2436, 609, 3, 'The presence and amount of amplitude distortion of a transmitter', ' ');
INSERT INTO answer VALUES (2437, 610, 0, 'Standing wave ratio', ' ');
INSERT INTO answer VALUES (2438, 610, 1, 'Antenna front-to-back ratio', ' ');
INSERT INTO answer VALUES (2439, 610, 2, 'RF interference', ' ');
INSERT INTO answer VALUES (2440, 610, 3, 'Radio wave propagation', ' ');
INSERT INTO answer VALUES (2443, 611, 0, 'Antenna and feed line', ' ');
INSERT INTO answer VALUES (2441, 611, 1, 'Receiver', ' ');
INSERT INTO answer VALUES (2442, 611, 2, 'Transmitter', ' ');
INSERT INTO answer VALUES (2444, 611, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2446, 612, 0, 'Strong signals from nearby transmitters can affect the accuracy of measurements', ' ');
INSERT INTO answer VALUES (2445, 612, 1, 'Permanent damage to the analyzer may occur if it is operated into a high SWR', ' ');
INSERT INTO answer VALUES (2447, 612, 2, 'The analyzer can be damaged if measurements outside the ham bands are attempted', ' ');
INSERT INTO answer VALUES (2448, 612, 3, 'Connecting the analyzer to an antenna can cause it to absorb harmonics', ' ');
INSERT INTO answer VALUES (2451, 613, 0, 'Determining the impedance of coaxial cable', ' ');
INSERT INTO answer VALUES (2449, 613, 1, 'Measuring the front-to-back ratio of an antenna', ' ');
INSERT INTO answer VALUES (2450, 613, 2, 'Measuring the turns ratio of a power transformer', ' ');
INSERT INTO answer VALUES (2452, 613, 3, 'Determining the gain of a directional antenna', ' ');
INSERT INTO answer VALUES (2456, 614, 0, 'When adjusting tuned circuits', ' ');
INSERT INTO answer VALUES (2453, 614, 1, 'When testing logic circuits', ' ');
INSERT INTO answer VALUES (2454, 614, 2, 'When high precision is desired', ' ');
INSERT INTO answer VALUES (2455, 614, 3, 'When measuring the frequency of an oscillator', ' ');
INSERT INTO answer VALUES (2457, 615, 0, 'Linearity', ' ');
INSERT INTO answer VALUES (2458, 615, 1, 'Percentage of suppression of carrier and undesired sideband for SSB', ' ');
INSERT INTO answer VALUES (2459, 615, 2, 'Percentage of frequency modulation', ' ');
INSERT INTO answer VALUES (2460, 615, 3, 'Percentage of carrier phase shift', ' ');
INSERT INTO answer VALUES (2462, 616, 0, 'Bypass capacitor', ' ');
INSERT INTO answer VALUES (2461, 616, 1, 'Bypass inductor', ' ');
INSERT INTO answer VALUES (2463, 616, 2, 'Forward-biased diode', ' ');
INSERT INTO answer VALUES (2464, 616, 3, 'Reverse-biased diode', ' ');
INSERT INTO answer VALUES (2467, 617, 0, 'Arcing at a poor electrical connection', ' ');
INSERT INTO answer VALUES (2465, 617, 1, 'Not using a balun or line isolator to feed balanced antennas', ' ');
INSERT INTO answer VALUES (2466, 617, 2, 'Lack of rectification of the transmitter’s signal in power conductors', ' ');
INSERT INTO answer VALUES (2468, 617, 3, 'Using a balun to feed an unbalanced antenna', ' ');
INSERT INTO answer VALUES (2471, 618, 0, 'Distorted speech', ' ');
INSERT INTO answer VALUES (2469, 618, 1, 'A steady hum whenever the transmitter is on the air', ' ');
INSERT INTO answer VALUES (2470, 618, 2, 'On-and-off humming or clicking', ' ');
INSERT INTO answer VALUES (2472, 618, 3, 'Clearly audible speech', ' ');
INSERT INTO answer VALUES (2473, 619, 0, 'On-and-off humming or clicking', ' ');
INSERT INTO answer VALUES (2474, 619, 1, 'A CW signal at a nearly pure audio frequency', ' ');
INSERT INTO answer VALUES (2475, 619, 2, 'A chirpy CW signal', ' ');
INSERT INTO answer VALUES (2476, 619, 3, 'Severely distorted audio', ' ');
INSERT INTO answer VALUES (2480, 620, 0, 'The ground wire has high impedance on that frequency', ' ');
INSERT INTO answer VALUES (2477, 620, 1, 'Flat braid rather than round wire has been used for the ground wire', ' ');
INSERT INTO answer VALUES (2478, 620, 2, 'Insulated wire has been used for the ground wire', ' ');
INSERT INTO answer VALUES (2479, 620, 3, 'The ground rod is resonant', ' ');
INSERT INTO answer VALUES (2483, 621, 0, 'High RF voltages on the enclosures of station equipment', ' ');
INSERT INTO answer VALUES (2481, 621, 1, 'Overheating of ground straps', ' ');
INSERT INTO answer VALUES (2482, 621, 2, 'Corrosion of the ground rod', ' ');
INSERT INTO answer VALUES (2484, 621, 3, 'A ground loop', ' ');
INSERT INTO answer VALUES (2488, 622, 0, 'A soldered joint will likely be destroyed by the heat of a lightning strike', ' ');
INSERT INTO answer VALUES (2485, 622, 1, 'The resistance of solder is too high', ' ');
INSERT INTO answer VALUES (2486, 622, 2, 'Solder flux will prevent a low conductivity connection', ' ');
INSERT INTO answer VALUES (2487, 622, 3, 'Solder has too high a dielectric constant to provide adequate lightning protection', ' ');
INSERT INTO answer VALUES (2489, 623, 0, 'Placing a ferrite choke around the cable', ' ');
INSERT INTO answer VALUES (2490, 623, 1, 'Adding series capacitors to the conductors', ' ');
INSERT INTO answer VALUES (2491, 623, 2, 'Adding shunt inductors to the conductors', ' ');
INSERT INTO answer VALUES (2492, 623, 3, 'Adding an additional insulating jacket to the cable', ' ');
INSERT INTO answer VALUES (2496, 624, 0, 'Connect all ground conductors to a single point', ' ');
INSERT INTO answer VALUES (2493, 624, 1, 'Connect all ground conductors in series', ' ');
INSERT INTO answer VALUES (2494, 624, 2, 'Connect the AC neutral conductor to the ground wire', ' ');
INSERT INTO answer VALUES (2495, 624, 3, 'Avoid using lock washers and star washers when making ground connections', ' ');
INSERT INTO answer VALUES (2497, 625, 0, 'You receive reports of “hum” on your station’s transmitted signal', ' ');
INSERT INTO answer VALUES (2498, 625, 1, 'The SWR reading for one or more antennas is suddenly very high', ' ');
INSERT INTO answer VALUES (2499, 625, 2, 'An item of station equipment starts to draw excessive amounts of current', ' ');
INSERT INTO answer VALUES (2500, 625, 3, 'You receive reports of harmonic interference from your station', ' ');
INSERT INTO answer VALUES (2503, 626, 0, 'Bonding all equipment enclosures together', ' ');
INSERT INTO answer VALUES (2501, 626, 1, 'Building all equipment in a metal enclosure', ' ');
INSERT INTO answer VALUES (2502, 626, 2, 'Using surge suppressor power outlets', ' ');
INSERT INTO answer VALUES (2504, 626, 3, 'Low-pass filters on all feed lines', ' ');
INSERT INTO answer VALUES (2505, 627, 0, 'A wide range of filter bandwidths and shapes can be created', ' ');
INSERT INTO answer VALUES (2506, 627, 1, 'Fewer digital components are required', ' ');
INSERT INTO answer VALUES (2507, 627, 2, 'Mixing products are greatly reduced', ' ');
INSERT INTO answer VALUES (2508, 627, 3, 'The DSP filter is much more effective at VHF frequencies', ' ');
INSERT INTO answer VALUES (2512, 628, 0, 'It ensures that hazardous voltages cannot appear on the chassis', ' ');
INSERT INTO answer VALUES (2509, 628, 1, 'It prevents a blown fuse in the event of an internal short circuit', ' ');
INSERT INTO answer VALUES (2510, 628, 2, 'It prevents signal overload', ' ');
INSERT INTO answer VALUES (2511, 628, 3, 'It ensures that the neutral wire is grounded', ' ');
INSERT INTO answer VALUES (2513, 629, 0, 'Increase the intelligibility of transmitted phone signals during poor conditions', ' ');
INSERT INTO answer VALUES (2514, 629, 1, 'Increase transmitter bass response for more natural-sounding SSB signals', ' ');
INSERT INTO answer VALUES (2515, 629, 2, 'Prevent distortion of voice signals', ' ');
INSERT INTO answer VALUES (2516, 629, 3, 'Decrease high-frequency voice output to prevent out-of-band operation', ' ');
INSERT INTO answer VALUES (2518, 630, 0, 'It increases average power', ' ');
INSERT INTO answer VALUES (2517, 630, 1, 'It increases peak power', ' ');
INSERT INTO answer VALUES (2519, 630, 2, 'It reduces harmonic distortion', ' ');
INSERT INTO answer VALUES (2520, 630, 3, 'It reduces intermodulation distortion', ' ');
INSERT INTO answer VALUES (2524, 631, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2521, 631, 1, 'Distorted speech', ' ');
INSERT INTO answer VALUES (2522, 631, 2, 'Splatter', ' ');
INSERT INTO answer VALUES (2523, 631, 3, 'Excessive background pickup', ' ');
INSERT INTO answer VALUES (2527, 632, 0, 'Received signal strength', ' ');
INSERT INTO answer VALUES (2525, 632, 1, 'Conductance', ' ');
INSERT INTO answer VALUES (2526, 632, 2, 'Impedance', ' ');
INSERT INTO answer VALUES (2528, 632, 3, 'Transmitter power output', ' ');
INSERT INTO answer VALUES (2532, 633, 0, 'It is 100 times more powerful', ' ');
INSERT INTO answer VALUES (2529, 633, 1, 'It is 10 times less powerful', ' ');
INSERT INTO answer VALUES (2530, 633, 2, 'It is 20 times less powerful', ' ');
INSERT INTO answer VALUES (2531, 633, 3, 'It is 20 times more powerful', ' ');
INSERT INTO answer VALUES (2533, 634, 0, 'In a receiver', ' ');
INSERT INTO answer VALUES (2534, 634, 1, 'In an SWR bridge', ' ');
INSERT INTO answer VALUES (2535, 634, 2, 'In a transmitter', ' ');
INSERT INTO answer VALUES (2536, 634, 3, 'In a conductance bridge', ' ');
INSERT INTO answer VALUES (2539, 635, 0, 'Approximately 4 times', ' ');
INSERT INTO answer VALUES (2537, 635, 1, 'Approximately 1.5 times', ' ');
INSERT INTO answer VALUES (2538, 635, 2, 'Approximately 2 times', ' ');
INSERT INTO answer VALUES (2540, 635, 3, 'Approximately 8 times', ' ');
INSERT INTO answer VALUES (2543, 636, 0, '7.175 to 7.178 MHz', ' ');
INSERT INTO answer VALUES (2541, 636, 1, '7.178 to 7.181 MHz', ' ');
INSERT INTO answer VALUES (2542, 636, 2, '7.178 to 7.184 MHz', ' ');
INSERT INTO answer VALUES (2544, 636, 3, '7.1765 to 7.1795 MHz', ' ');
INSERT INTO answer VALUES (2546, 637, 0, '14.347 to 14.350 MHz', ' ');
INSERT INTO answer VALUES (2545, 637, 1, '14.347 to 14.647 MHz', ' ');
INSERT INTO answer VALUES (2547, 637, 2, '14.344 to 14.347 MHz', ' ');
INSERT INTO answer VALUES (2548, 637, 3, '14.3455 to 14.3485 MHz', ' ');
INSERT INTO answer VALUES (2549, 638, 0, 'At least 3 kHz above the edge of the segment', ' ');
INSERT INTO answer VALUES (2550, 638, 1, 'At least 3 kHz below the edge of the segment', ' ');
INSERT INTO answer VALUES (2551, 638, 2, 'At least 1 kHz below the edge of the segment', ' ');
INSERT INTO answer VALUES (2552, 638, 3, 'At least 1 kHz above the edge of the segment', ' ');
INSERT INTO answer VALUES (2554, 639, 0, 'At least 3 kHz below the edge of the band', ' ');
INSERT INTO answer VALUES (2553, 639, 1, 'At least 3 kHz above the edge of the band', ' ');
INSERT INTO answer VALUES (2555, 639, 2, 'At least 1 kHz above the edge of the segment', ' ');
INSERT INTO answer VALUES (2556, 639, 3, 'At least 1 kHz below the edge of the segment', ' ');
INSERT INTO answer VALUES (2559, 640, 0, 'To electrically lengthen a physically short antenna', ' ');
INSERT INTO answer VALUES (2557, 640, 1, 'To increase the power handling capacity of a whip antenna', ' ');
INSERT INTO answer VALUES (2558, 640, 2, 'To allow automatic band changing', ' ');
INSERT INTO answer VALUES (2560, 640, 3, 'To allow remote tuning', ' ');
INSERT INTO answer VALUES (2564, 641, 0, 'To reduce RF voltage discharge from the tip of the antenna while transmitting', ' ');
INSERT INTO answer VALUES (2561, 641, 1, 'To narrow the operating bandwidth of the antenna', ' ');
INSERT INTO answer VALUES (2562, 641, 2, 'To increase the “Q” of the antenna', ' ');
INSERT INTO answer VALUES (2563, 641, 3, 'To reduce the chance of damage if the antenna should strike an object', ' ');
INSERT INTO answer VALUES (2565, 642, 0, 'To the battery using heavy-gauge wire', ' ');
INSERT INTO answer VALUES (2566, 642, 1, 'To the alternator or generator using heavy-gauge wire', ' ');
INSERT INTO answer VALUES (2567, 642, 2, 'To the battery using resistor wire', ' ');
INSERT INTO answer VALUES (2568, 642, 3, 'To the alternator or generator using resistor wire', ' ');
INSERT INTO answer VALUES (2570, 643, 0, 'The socket’s wiring may be inadequate for the current drawn by the transceiver', ' ');
INSERT INTO answer VALUES (2569, 643, 1, 'The socket is not wired with an RF-shielded power cable', ' ');
INSERT INTO answer VALUES (2571, 643, 2, 'The DC polarity of the socket is reversed from the polarity of modern HF transceivers', ' ');
INSERT INTO answer VALUES (2572, 643, 3, 'Drawing more than 50 watts from this socket could cause the engine to overheat', ' ');
INSERT INTO answer VALUES (2575, 644, 0, 'Efficiency of the electrically short antenna', ' ');
INSERT INTO answer VALUES (2573, 644, 1, '“Picket fencing”', ' ');
INSERT INTO answer VALUES (2574, 644, 2, 'The wire gauge of the DC power line to the transceiver', ' ');
INSERT INTO answer VALUES (2576, 644, 3, 'FCC rules limiting mobile output power on the 75-meter band', ' ');
INSERT INTO answer VALUES (2579, 645, 0, 'Operating bandwidth may be very limited', ' ');
INSERT INTO answer VALUES (2577, 645, 1, 'Short antennas are more likely to cause distortion of transmitted signals', ' ');
INSERT INTO answer VALUES (2578, 645, 2, 'Short antennas can only receive circularly polarized signals', ' ');
INSERT INTO answer VALUES (2580, 645, 3, 'Harmonic radiation may increase', ' ');
INSERT INTO answer VALUES (2584, 646, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2581, 646, 1, 'The battery charging system', ' ');
INSERT INTO answer VALUES (2582, 646, 2, 'The fuel delivery system', ' ');
INSERT INTO answer VALUES (2583, 646, 3, 'The vehicle control computer', ' ');
INSERT INTO answer VALUES (2585, 647, 0, 'Photovoltaic conversion', ' ');
INSERT INTO answer VALUES (2586, 647, 1, 'Photon emission', ' ');
INSERT INTO answer VALUES (2587, 647, 2, 'Photosynthesis', ' ');
INSERT INTO answer VALUES (2588, 647, 3, 'Photon decomposition', ' ');
INSERT INTO answer VALUES (2590, 648, 0, '0.5 VDC', ' ');
INSERT INTO answer VALUES (2589, 648, 1, '0.02 VDC', ' ');
INSERT INTO answer VALUES (2591, 648, 2, '0.2 VDC', ' ');
INSERT INTO answer VALUES (2592, 648, 3, '1.38 VDC', ' ');
INSERT INTO answer VALUES (2594, 649, 0, 'The diode prevents self-discharge of the battery through the panel during times of low or no illumination', ' ');
INSERT INTO answer VALUES (2593, 649, 1, 'The diode serves to regulate the charging voltage to prevent overcharge', ' ');
INSERT INTO answer VALUES (2595, 649, 2, 'The diode limits the current flowing from the panel to a safe value', ' ');
INSERT INTO answer VALUES (2596, 649, 3, 'The diode greatly increases the efficiency during times of high illumination', ' ');
INSERT INTO answer VALUES (2599, 650, 0, 'A large energy storage system is needed to supply power when the wind is not blowing', ' ');
INSERT INTO answer VALUES (2597, 650, 1, 'The conversion efficiency from mechanical energy to electrical energy is less than 2 percent', ' ');
INSERT INTO answer VALUES (2598, 650, 2, 'The voltage and current ratings of such systems are not compatible with amateur equipment', ' ');
INSERT INTO answer VALUES (2600, 650, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2603, 651, 0, 'The opposition to the flow of current in an AC circuit', ' ');
INSERT INTO answer VALUES (2601, 651, 1, 'The electric charge stored by a capacitor', ' ');
INSERT INTO answer VALUES (2602, 651, 2, 'The inverse of resistance', ' ');
INSERT INTO answer VALUES (2604, 651, 3, 'The force of repulsion between two similar electric fields', ' ');
INSERT INTO answer VALUES (2606, 652, 0, 'Opposition to the flow of alternating current caused by capacitance or inductance', ' ');
INSERT INTO answer VALUES (2605, 652, 1, 'Opposition to the flow of direct current caused by resistance', ' ');
INSERT INTO answer VALUES (2607, 652, 2, 'A property of ideal resistors in AC circuits', ' ');
INSERT INTO answer VALUES (2608, 652, 3, 'A large spark produced at switch contacts when an inductor is de-energized', ' ');
INSERT INTO answer VALUES (2612, 653, 0, 'Reactance', ' ');
INSERT INTO answer VALUES (2609, 653, 1, 'Conductance', ' ');
INSERT INTO answer VALUES (2610, 653, 2, 'Reluctance', ' ');
INSERT INTO answer VALUES (2611, 653, 3, 'Admittance', ' ');
INSERT INTO answer VALUES (2615, 654, 0, 'Reactance', ' ');
INSERT INTO answer VALUES (2613, 654, 1, 'Conductance', ' ');
INSERT INTO answer VALUES (2614, 654, 2, 'Reluctance', ' ');
INSERT INTO answer VALUES (2616, 654, 3, 'Admittance', ' ');
INSERT INTO answer VALUES (2620, 655, 0, 'As the frequency of the applied AC increases, the reactance increases', ' ');
INSERT INTO answer VALUES (2617, 655, 1, 'As the frequency of the applied AC increases, the reactance decreases', ' ');
INSERT INTO answer VALUES (2618, 655, 2, 'As the amplitude of the applied AC increases, the reactance increases', ' ');
INSERT INTO answer VALUES (2619, 655, 3, 'As the amplitude of the applied AC increases, the reactance decreases', ' ');
INSERT INTO answer VALUES (2621, 656, 0, 'As the frequency of the applied AC increases, the reactance decreases', ' ');
INSERT INTO answer VALUES (2622, 656, 1, 'As the frequency of the applied AC increases, the reactance increases', ' ');
INSERT INTO answer VALUES (2623, 656, 2, 'As the amplitude of the applied AC increases, the reactance increases', ' ');
INSERT INTO answer VALUES (2624, 656, 3, 'As the amplitude of the applied AC increases, the reactance decreases', ' ');
INSERT INTO answer VALUES (2628, 657, 0, 'The source can deliver maximum power to the load', ' ');
INSERT INTO answer VALUES (2625, 657, 1, 'The source delivers minimum power to the load', ' ');
INSERT INTO answer VALUES (2626, 657, 2, 'The electrical load is shorted', ' ');
INSERT INTO answer VALUES (2627, 657, 3, 'No current can flow through the circuit', ' ');
INSERT INTO answer VALUES (2630, 658, 0, 'To maximize the transfer of power', ' ');
INSERT INTO answer VALUES (2629, 658, 1, 'To minimize transmitter power output', ' ');
INSERT INTO answer VALUES (2631, 658, 2, 'To reduce power supply ripple', ' ');
INSERT INTO answer VALUES (2632, 658, 3, 'To minimize radiation resistance', ' ');
INSERT INTO answer VALUES (2634, 659, 0, 'Ohm', ' ');
INSERT INTO answer VALUES (2633, 659, 1, 'Farad', ' ');
INSERT INTO answer VALUES (2635, 659, 2, 'Ampere', ' ');
INSERT INTO answer VALUES (2636, 659, 3, 'Siemens', ' ');
INSERT INTO answer VALUES (2640, 660, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2637, 660, 1, 'A transformer', ' ');
INSERT INTO answer VALUES (2638, 660, 2, 'A Pi-network', ' ');
INSERT INTO answer VALUES (2639, 660, 3, 'A length of transmission line', ' ');
INSERT INTO answer VALUES (2641, 661, 0, 'Insert an LC network between the two circuits', ' ');
INSERT INTO answer VALUES (2642, 661, 1, 'Reduce the power output of the first circuit', ' ');
INSERT INTO answer VALUES (2643, 661, 2, 'Increase the power output of the first circuit', ' ');
INSERT INTO answer VALUES (2644, 661, 3, 'Insert a circulator between the two circuits', ' ');
INSERT INTO answer VALUES (2646, 662, 0, 'Approximately 3 dB', ' ');
INSERT INTO answer VALUES (2645, 662, 1, 'Approximately 2 dB', ' ');
INSERT INTO answer VALUES (2647, 662, 2, 'Approximately 6 dB', ' ');
INSERT INTO answer VALUES (2648, 662, 3, 'Approximately 12 dB', ' ');
INSERT INTO answer VALUES (2651, 663, 0, 'It equals the sum of the currents through each branch', ' ');
INSERT INTO answer VALUES (2649, 663, 1, 'It equals the average of each branch current', ' ');
INSERT INTO answer VALUES (2650, 663, 2, 'It decreases as more parallel branches are added to the circuit', ' ');
INSERT INTO answer VALUES (2652, 663, 3, 'It is the sum of the reciprocal of each individual voltage drop', ' ');
INSERT INTO answer VALUES (2654, 664, 0, '200 watts', ' ');
INSERT INTO answer VALUES (2653, 664, 1, '0.5 watts', ' ');
INSERT INTO answer VALUES (2655, 664, 2, '400 watts', ' ');
INSERT INTO answer VALUES (2656, 664, 3, '3200 watts', ' ');
INSERT INTO answer VALUES (2657, 665, 0, '2.4 watts', ' ');
INSERT INTO answer VALUES (2658, 665, 1, '24 watts', ' ');
INSERT INTO answer VALUES (2659, 665, 2, '6 watts', ' ');
INSERT INTO answer VALUES (2660, 665, 3, '60 watts', ' ');
INSERT INTO answer VALUES (2661, 666, 0, 'Approximately 61 milliwatts', ' ');
INSERT INTO answer VALUES (2662, 666, 1, 'Approximately 61 watts', ' ');
INSERT INTO answer VALUES (2663, 666, 2, 'Approximately 11 milliwatts', ' ');
INSERT INTO answer VALUES (2664, 666, 3, 'Approximately 11 watts', ' ');
INSERT INTO answer VALUES (2666, 667, 0, '100 watts', ' ');
INSERT INTO answer VALUES (2665, 667, 1, '1.4 watts', ' ');
INSERT INTO answer VALUES (2667, 667, 2, '353.5 watts', ' ');
INSERT INTO answer VALUES (2668, 667, 3, '400 watts', ' ');
INSERT INTO answer VALUES (2671, 668, 0, 'The RMS value', ' ');
INSERT INTO answer VALUES (2669, 668, 1, 'The peak-to-peak value', ' ');
INSERT INTO answer VALUES (2670, 668, 2, 'The peak value', ' ');
INSERT INTO answer VALUES (2672, 668, 3, 'The reciprocal of the RMS value', ' ');
INSERT INTO answer VALUES (2676, 669, 0, '339.4 volts', ' ');
INSERT INTO answer VALUES (2673, 669, 1, '84.8 volts', ' ');
INSERT INTO answer VALUES (2674, 669, 2, '169.7 volts', ' ');
INSERT INTO answer VALUES (2675, 669, 3, '240.0 volts', ' ');
INSERT INTO answer VALUES (2678, 670, 0, '12 volts', ' ');
INSERT INTO answer VALUES (2677, 670, 1, '8.5 volts', ' ');
INSERT INTO answer VALUES (2679, 670, 2, '24 volts', ' ');
INSERT INTO answer VALUES (2680, 670, 3, '34 volts', ' ');
INSERT INTO answer VALUES (2683, 671, 0, '20.6 percent', ' ');
INSERT INTO answer VALUES (2681, 671, 1, '10.9 percent', ' ');
INSERT INTO answer VALUES (2682, 671, 2, '12.2 percent', ' ');
INSERT INTO answer VALUES (2684, 671, 3, '25.9 percent', ' ');
INSERT INTO answer VALUES (2686, 672, 0, '1.00', ' ');
INSERT INTO answer VALUES (2685, 672, 1, '0.707', ' ');
INSERT INTO answer VALUES (2687, 672, 2, '1.414', ' ');
INSERT INTO answer VALUES (2688, 672, 3, '2.00', ' ');
INSERT INTO answer VALUES (2690, 673, 0, '245 volts', ' ');
INSERT INTO answer VALUES (2689, 673, 1, '173 volts', ' ');
INSERT INTO answer VALUES (2691, 673, 2, '346 volts', ' ');
INSERT INTO answer VALUES (2692, 673, 3, '692 volts', ' ');
INSERT INTO answer VALUES (2694, 674, 0, '1060 watts', ' ');
INSERT INTO answer VALUES (2693, 674, 1, '530 watts', ' ');
INSERT INTO answer VALUES (2695, 674, 2, '1500 watts', ' ');
INSERT INTO answer VALUES (2696, 674, 3, '2120 watts', ' ');
INSERT INTO answer VALUES (2698, 675, 0, '625 watts', ' ');
INSERT INTO answer VALUES (2697, 675, 1, '8.75 watts', ' ');
INSERT INTO answer VALUES (2699, 675, 2, '2500 watts', ' ');
INSERT INTO answer VALUES (2700, 675, 3, '5000 watts', ' ');
INSERT INTO answer VALUES (2703, 676, 0, 'Mutual inductance', ' ');
INSERT INTO answer VALUES (2701, 676, 1, 'Capacitive coupling', ' ');
INSERT INTO answer VALUES (2702, 676, 2, 'Displacement current coupling', ' ');
INSERT INTO answer VALUES (2704, 676, 3, 'Mutual capacitance', ' ');
INSERT INTO answer VALUES (2705, 677, 0, 'The output voltage is multiplied by 4', ' ');
INSERT INTO answer VALUES (2706, 677, 1, 'The output voltage is divided by 4', ' ');
INSERT INTO answer VALUES (2707, 677, 2, 'Additional resistance must be added in series with the primary to prevent overload', ' ');
INSERT INTO answer VALUES (2708, 677, 3, 'Additional resistance must be added in parallel with the secondary to prevent overload', ' ');
INSERT INTO answer VALUES (2710, 678, 0, 'A series resistor', ' ');
INSERT INTO answer VALUES (2709, 678, 1, 'A parallel resistor', ' ');
INSERT INTO answer VALUES (2711, 678, 2, 'A series capacitor', ' ');
INSERT INTO answer VALUES (2712, 678, 3, 'A parallel capacitor', ' ');
INSERT INTO answer VALUES (2715, 679, 0, '33.3 ohms', ' ');
INSERT INTO answer VALUES (2713, 679, 1, '0.30 ohms', ' ');
INSERT INTO answer VALUES (2714, 679, 2, '0.33 ohms', ' ');
INSERT INTO answer VALUES (2716, 679, 3, '300 ohms', ' ');
INSERT INTO answer VALUES (2719, 680, 0, '150 ohms', ' ');
INSERT INTO answer VALUES (2717, 680, 1, '1500 ohms', ' ');
INSERT INTO answer VALUES (2718, 680, 2, '90 ohms', ' ');
INSERT INTO answer VALUES (2720, 680, 3, '175 ohms', ' ');
INSERT INTO answer VALUES (2723, 681, 0, '26.7 volts', ' ');
INSERT INTO answer VALUES (2721, 681, 1, '2370 volts', ' ');
INSERT INTO answer VALUES (2722, 681, 2, '540 volts', ' ');
INSERT INTO answer VALUES (2724, 681, 3, '5.9 volts', ' ');
INSERT INTO answer VALUES (2725, 682, 0, '12.2 to 1', ' ');
INSERT INTO answer VALUES (2726, 682, 1, '24.4 to 1', ' ');
INSERT INTO answer VALUES (2727, 682, 2, '150 to 1', ' ');
INSERT INTO answer VALUES (2728, 682, 3, '300 to 1', ' ');
INSERT INTO answer VALUES (2732, 683, 0, '10.750 nanofarads', ' ');
INSERT INTO answer VALUES (2729, 683, 1, '576.9 nanofarads', ' ');
INSERT INTO answer VALUES (2730, 683, 2, '1733 picofarads', ' ');
INSERT INTO answer VALUES (2731, 683, 3, '3583 picofarads', ' ');
INSERT INTO answer VALUES (2735, 684, 0, '33.3 microfarads', ' ');
INSERT INTO answer VALUES (2733, 684, 1, '0.30 microfarads', ' ');
INSERT INTO answer VALUES (2734, 684, 2, '0.33 microfarads', ' ');
INSERT INTO answer VALUES (2736, 684, 3, '300 microfarads', ' ');
INSERT INTO answer VALUES (2739, 685, 0, '3.3 millihenries', ' ');
INSERT INTO answer VALUES (2737, 685, 1, '0.30 henries', ' ');
INSERT INTO answer VALUES (2738, 685, 2, '3.3 henries', ' ');
INSERT INTO answer VALUES (2740, 685, 3, '30 millihenries', ' ');
INSERT INTO answer VALUES (2743, 686, 0, '70 millihenries', ' ');
INSERT INTO answer VALUES (2741, 686, 1, '0.07 millihenries', ' ');
INSERT INTO answer VALUES (2742, 686, 2, '14.3 millihenries', ' ');
INSERT INTO answer VALUES (2744, 686, 3, '1000 millihenries', ' ');
INSERT INTO answer VALUES (2746, 687, 0, '14.3 microfarads', ' ');
INSERT INTO answer VALUES (2745, 687, 1, '0.07 microfarads', ' ');
INSERT INTO answer VALUES (2747, 687, 2, '70 microfarads', ' ');
INSERT INTO answer VALUES (2748, 687, 3, '1000 microfarads', ' ');
INSERT INTO answer VALUES (2751, 688, 0, 'A capacitor in parallel', ' ');
INSERT INTO answer VALUES (2749, 688, 1, 'An inductor in series', ' ');
INSERT INTO answer VALUES (2750, 688, 2, 'A resistor in series', ' ');
INSERT INTO answer VALUES (2752, 688, 3, 'A capacitor in series', ' ');
INSERT INTO answer VALUES (2756, 689, 0, 'An inductor in series', ' ');
INSERT INTO answer VALUES (2753, 689, 1, 'A capacitor in series', ' ');
INSERT INTO answer VALUES (2754, 689, 2, 'A resistor in parallel', ' ');
INSERT INTO answer VALUES (2755, 689, 3, 'An inductor in parallel', ' ');
INSERT INTO answer VALUES (2757, 690, 0, '5.9 ohms', ' ');
INSERT INTO answer VALUES (2758, 690, 1, '0.17 ohms', ' ');
INSERT INTO answer VALUES (2759, 690, 2, '10000 ohms', ' ');
INSERT INTO answer VALUES (2760, 690, 3, '80 ohms', ' ');
INSERT INTO answer VALUES (2762, 691, 0, 'To accommodate the higher current of the primary', ' ');
INSERT INTO answer VALUES (2761, 691, 1, 'To improve the coupling between the primary and secondary', ' ');
INSERT INTO answer VALUES (2763, 691, 2, 'To prevent parasitic oscillations due to resistive losses in the primary', ' ');
INSERT INTO answer VALUES (2764, 691, 3, 'To ensure that the volume of the primary winding is equal to the volume of the secondary winding', ' ');
INSERT INTO answer VALUES (2767, 692, 0, '22', ' ');
INSERT INTO answer VALUES (2765, 692, 1, '0.22', ' ');
INSERT INTO answer VALUES (2766, 692, 2, '2.2', ' ');
INSERT INTO answer VALUES (2768, 692, 3, '220', ' ');
INSERT INTO answer VALUES (2772, 693, 0, '4.7', ' ');
INSERT INTO answer VALUES (2769, 693, 1, '47', ' ');
INSERT INTO answer VALUES (2770, 693, 2, '0.47', ' ');
INSERT INTO answer VALUES (2771, 693, 3, '47,000', ' ');
INSERT INTO answer VALUES (2775, 694, 0, '10.5 volts', ' ');
INSERT INTO answer VALUES (2773, 694, 1, '6 volts', ' ');
INSERT INTO answer VALUES (2774, 694, 2, '8.5 volts', ' ');
INSERT INTO answer VALUES (2776, 694, 3, '12 volts', ' ');
INSERT INTO answer VALUES (2778, 695, 0, 'High discharge current', ' ');
INSERT INTO answer VALUES (2777, 695, 1, 'Long life', ' ');
INSERT INTO answer VALUES (2779, 695, 2, 'High voltage', ' ');
INSERT INTO answer VALUES (2780, 695, 3, 'Rapid recharge', ' ');
INSERT INTO answer VALUES (2782, 696, 0, '0.3 volts', ' ');
INSERT INTO answer VALUES (2781, 696, 1, '0.1 volt', ' ');
INSERT INTO answer VALUES (2783, 696, 2, '0.7 volts', ' ');
INSERT INTO answer VALUES (2784, 696, 3, '1.0 volts', ' ');
INSERT INTO answer VALUES (2787, 697, 0, 'High capacitance for a given volume', ' ');
INSERT INTO answer VALUES (2785, 697, 1, 'Tight tolerance', ' ');
INSERT INTO answer VALUES (2786, 697, 2, 'Much less leakage than any other type', ' ');
INSERT INTO answer VALUES (2788, 697, 3, 'Inexpensive RF capacitor', ' ');
INSERT INTO answer VALUES (2791, 698, 0, '0.7 volts', ' ');
INSERT INTO answer VALUES (2789, 698, 1, '0.1 volt', ' ');
INSERT INTO answer VALUES (2790, 698, 2, '0.3 volts', ' ');
INSERT INTO answer VALUES (2792, 698, 3, '1.0 volts', ' ');
INSERT INTO answer VALUES (2794, 699, 0, 'The resistor’s inductance could make circuit performance unpredictable', ' ');
INSERT INTO answer VALUES (2793, 699, 1, 'The resistor’s tolerance value would not be adequate for such a circuit', ' ');
INSERT INTO answer VALUES (2795, 699, 2, 'The resistor could overheat', ' ');
INSERT INTO answer VALUES (2796, 699, 3, 'The resistor’s internal capacitance would detune the circuit', ' ');
INSERT INTO answer VALUES (2797, 700, 0, 'Its saturation and cutoff regions', ' ');
INSERT INTO answer VALUES (2798, 700, 1, 'Its active region (between the cutoff and saturation regions)', ' ');
INSERT INTO answer VALUES (2799, 700, 2, 'Its peak and valley current points', ' ');
INSERT INTO answer VALUES (2800, 700, 3, 'Its enhancement and depletion modes', ' ');
INSERT INTO answer VALUES (2804, 701, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2801, 701, 1, 'Large values of inductance may be obtained', ' ');
INSERT INTO answer VALUES (2802, 701, 2, 'The magnetic properties of the core may be optimized for a specific range of frequencies', ' ');
INSERT INTO answer VALUES (2803, 701, 3, 'Most of the magnetic field is contained in the core', ' ');
INSERT INTO answer VALUES (2806, 702, 0, 'The gate is separated from the channel with a thin insulating layer', ' ');
INSERT INTO answer VALUES (2805, 702, 1, 'The gate is formed by a back-biased junction', ' ');
INSERT INTO answer VALUES (2807, 702, 2, 'The source is separated from the drain by a thin insulating layer', ' ');
INSERT INTO answer VALUES (2808, 702, 3, 'The source is formed by depositing metal on silicon', ' ');
INSERT INTO answer VALUES (2809, 703, 0, 'Control grid', ' ');
INSERT INTO answer VALUES (2810, 703, 1, 'Heater', ' ');
INSERT INTO answer VALUES (2811, 703, 2, 'Screen grid', ' ');
INSERT INTO answer VALUES (2812, 703, 3, 'Trigger electrode', ' ');
INSERT INTO answer VALUES (2815, 704, 0, 'It becomes capacitive', ' ');
INSERT INTO answer VALUES (2813, 704, 1, 'Its reactance increases', ' ');
INSERT INTO answer VALUES (2814, 704, 2, 'Harmonics are generated', ' ');
INSERT INTO answer VALUES (2816, 704, 3, 'Catastrophic failure is likely', ' ');
INSERT INTO answer VALUES (2817, 705, 0, 'To reduce grid-to-plate capacitance', ' ');
INSERT INTO answer VALUES (2818, 705, 1, 'To increase efficiency', ' ');
INSERT INTO answer VALUES (2819, 705, 2, 'To increase the control grid resistance', ' ');
INSERT INTO answer VALUES (2820, 705, 3, 'To decrease plate resistance', ' ');
INSERT INTO answer VALUES (2824, 706, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2821, 706, 1, 'Incorrect polarity can cause the capacitor to short-circuit', ' ');
INSERT INTO answer VALUES (2822, 706, 2, 'Reverse voltages can destroy the dielectric layer of an electrolytic capacitor', ' ');
INSERT INTO answer VALUES (2823, 706, 3, 'The capacitor could overheat and explode', ' ');
INSERT INTO answer VALUES (2828, 707, 0, 'Comparatively low cost', ' ');
INSERT INTO answer VALUES (2825, 707, 1, 'Tight tolerance', ' ');
INSERT INTO answer VALUES (2826, 707, 2, 'High stability', ' ');
INSERT INTO answer VALUES (2827, 707, 3, 'High capacitance for given volume', ' ');
INSERT INTO answer VALUES (2831, 708, 0, 'The composition, or “mix,” of materials used', ' ');
INSERT INTO answer VALUES (2829, 708, 1, 'Its conductivity', ' ');
INSERT INTO answer VALUES (2830, 708, 2, 'Its thickness', ' ');
INSERT INTO answer VALUES (2832, 708, 3, 'The ratio of outer diameter to inner diameter', ' ');
INSERT INTO answer VALUES (2834, 709, 0, 'Monolithic Microwave Integrated Circuit', ' ');
INSERT INTO answer VALUES (2833, 709, 1, 'Multi-Megabyte Integrated Circuit', ' ');
INSERT INTO answer VALUES (2835, 709, 2, 'Military Manufactured Integrated Circuit', ' ');
INSERT INTO answer VALUES (2836, 709, 3, 'Mode Modulated Integrated Circuit', ' ');
INSERT INTO answer VALUES (2837, 710, 0, 'Low power consumption', ' ');
INSERT INTO answer VALUES (2838, 710, 1, 'High power handling capability', ' ');
INSERT INTO answer VALUES (2839, 710, 2, 'Better suited for RF amplification', ' ');
INSERT INTO answer VALUES (2840, 710, 3, 'Better suited for power supply regulation', ' ');
INSERT INTO answer VALUES (2842, 711, 0, 'Read Only Memory', ' ');
INSERT INTO answer VALUES (2841, 711, 1, 'Resistor Operated Memory', ' ');
INSERT INTO answer VALUES (2843, 711, 2, 'Random Operational Memory', ' ');
INSERT INTO answer VALUES (2844, 711, 3, 'Resistant to Overload Memory', ' ');
INSERT INTO answer VALUES (2847, 712, 0, 'The stored information is maintained even if power is removed', ' ');
INSERT INTO answer VALUES (2845, 712, 1, 'It is resistant to radiation damage', ' ');
INSERT INTO answer VALUES (2846, 712, 2, 'It is resistant to high temperatures', ' ');
INSERT INTO answer VALUES (2848, 712, 3, 'The stored information cannot be changed once written', ' ');
INSERT INTO answer VALUES (2852, 713, 0, 'Analog', ' ');
INSERT INTO answer VALUES (2849, 713, 1, 'Digital', ' ');
INSERT INTO answer VALUES (2850, 713, 2, 'MMIC', ' ');
INSERT INTO answer VALUES (2851, 713, 3, 'Programmable Logic', ' ');
INSERT INTO answer VALUES (2853, 714, 0, 'A moisture-resistant RF connector useful to 10 GHz', ' ');
INSERT INTO answer VALUES (2854, 714, 1, 'A small bayonet connector used for data circuits', ' ');
INSERT INTO answer VALUES (2855, 714, 2, 'A threaded connector used for hydraulic systems', ' ');
INSERT INTO answer VALUES (2856, 714, 3, 'An audio connector used in surround-sound installations', ' ');
INSERT INTO answer VALUES (2860, 715, 0, 'Forward biased', ' ');
INSERT INTO answer VALUES (2857, 715, 1, 'Beyond cutoff', ' ');
INSERT INTO answer VALUES (2858, 715, 2, 'At the Zener voltage', ' ');
INSERT INTO answer VALUES (2859, 715, 3, 'Reverse biased', ' ');
INSERT INTO answer VALUES (2861, 716, 0, 'It utilizes ambient or back lighting', ' ');
INSERT INTO answer VALUES (2862, 716, 1, 'It offers a wide dynamic range', ' ');
INSERT INTO answer VALUES (2863, 716, 2, 'It consumes relatively high power', ' ');
INSERT INTO answer VALUES (2864, 716, 3, 'It has relatively short lifetime', ' ');
INSERT INTO answer VALUES (2865, 717, 0, 'By creating an impedance in the current’s path', ' ');
INSERT INTO answer VALUES (2866, 717, 1, 'It converts common-mode current to differential mode', ' ');
INSERT INTO answer VALUES (2867, 717, 2, 'By creating an out-of-phase current to cancel the common-mode current', ' ');
INSERT INTO answer VALUES (2868, 717, 3, 'Ferrites expel magnetic fields', ' ');
INSERT INTO answer VALUES (2870, 718, 0, 'A small threaded connector suitable for signals up to several GHz', ' ');
INSERT INTO answer VALUES (2869, 718, 1, 'A large bayonet connector usable at power levels more than 1 KW', ' ');
INSERT INTO answer VALUES (2871, 718, 2, 'A connector designed for serial multiple access signals', ' ');
INSERT INTO answer VALUES (2872, 718, 3, 'A type of push-on connector intended for high-voltage applications', ' ');
INSERT INTO answer VALUES (2875, 719, 0, 'RCA Phono', ' ');
INSERT INTO answer VALUES (2873, 719, 1, 'PL-259', ' ');
INSERT INTO answer VALUES (2874, 719, 2, 'BNC', ' ');
INSERT INTO answer VALUES (2876, 719, 3, 'Type N', ' ');
INSERT INTO answer VALUES (2879, 720, 0, 'PL-259', ' ');
INSERT INTO answer VALUES (2877, 720, 1, 'Octal', ' ');
INSERT INTO answer VALUES (2878, 720, 2, 'RJ-11', ' ');
INSERT INTO answer VALUES (2880, 720, 3, 'DB-25', ' ');
INSERT INTO answer VALUES (2882, 721, 0, 'It ensures that the filter capacitors are discharged when power is removed', ' ');
INSERT INTO answer VALUES (2881, 721, 1, 'It acts as a fuse for excess voltage', ' ');
INSERT INTO answer VALUES (2883, 721, 2, 'It removes shock hazards from the induction coils', ' ');
INSERT INTO answer VALUES (2884, 721, 3, 'It eliminates ground loop current', ' ');
INSERT INTO answer VALUES (2888, 722, 0, 'Capacitors and inductors', ' ');
INSERT INTO answer VALUES (2885, 722, 1, 'Diodes', ' ');
INSERT INTO answer VALUES (2886, 722, 2, 'Transformers and transducers', ' ');
INSERT INTO answer VALUES (2887, 722, 3, 'Quartz crystals', ' ');
INSERT INTO answer VALUES (2889, 723, 0, 'Full-wave', ' ');
INSERT INTO answer VALUES (2890, 723, 1, 'Full-wave bridge', ' ');
INSERT INTO answer VALUES (2891, 723, 2, 'Half-wave', ' ');
INSERT INTO answer VALUES (2892, 723, 3, 'Synchronous', ' ');
INSERT INTO answer VALUES (2893, 724, 0, 'Only one diode is required', ' ');
INSERT INTO answer VALUES (2894, 724, 1, 'The ripple frequency is twice that of a full-wave rectifier', ' ');
INSERT INTO answer VALUES (2895, 724, 2, 'More current can be drawn from the half-wave rectifier', ' ');
INSERT INTO answer VALUES (2896, 724, 3, 'The output voltage is two times the peak output voltage of the transformer', ' ');
INSERT INTO answer VALUES (2898, 725, 0, '180 degrees', ' ');
INSERT INTO answer VALUES (2897, 725, 1, '90 degrees', ' ');
INSERT INTO answer VALUES (2899, 725, 2, '270 degrees', ' ');
INSERT INTO answer VALUES (2900, 725, 3, '360 degrees', ' ');
INSERT INTO answer VALUES (2904, 726, 0, '360 degrees', ' ');
INSERT INTO answer VALUES (2901, 726, 1, '90 degrees', ' ');
INSERT INTO answer VALUES (2902, 726, 2, '180 degrees', ' ');
INSERT INTO answer VALUES (2903, 726, 3, '270 degrees', ' ');
INSERT INTO answer VALUES (2905, 727, 0, 'A series of DC pulses at twice the frequency of the AC input', ' ');
INSERT INTO answer VALUES (2906, 727, 1, 'A series of DC pulses at the same frequency as the AC input', ' ');
INSERT INTO answer VALUES (2907, 727, 2, 'A sine wave at half the frequency of the AC input', ' ');
INSERT INTO answer VALUES (2908, 727, 3, 'A steady DC voltage', ' ');
INSERT INTO answer VALUES (2911, 728, 0, 'High-frequency operation allows the use of smaller components', ' ');
INSERT INTO answer VALUES (2909, 728, 1, 'Faster switching time makes higher output voltage possible', ' ');
INSERT INTO answer VALUES (2910, 728, 2, 'Fewer circuit components are required', ' ');
INSERT INTO answer VALUES (2912, 728, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2915, 729, 0, 'Symbol 1', ' ');
INSERT INTO answer VALUES (2913, 729, 1, 'Symbol 2', ' ');
INSERT INTO answer VALUES (2914, 729, 2, 'Symbol 5', ' ');
INSERT INTO answer VALUES (2916, 729, 3, 'Symbol 4', ' ');
INSERT INTO answer VALUES (2920, 730, 0, 'Symbol 5', ' ');
INSERT INTO answer VALUES (2917, 730, 1, 'Symbol 4', ' ');
INSERT INTO answer VALUES (2918, 730, 2, 'Symbol 1', ' ');
INSERT INTO answer VALUES (2919, 730, 3, 'Symbol 11', ' ');
INSERT INTO answer VALUES (2922, 731, 0, 'Symbol 2', ' ');
INSERT INTO answer VALUES (2921, 731, 1, 'Symbol 1', ' ');
INSERT INTO answer VALUES (2923, 731, 2, 'Symbol 7', ' ');
INSERT INTO answer VALUES (2924, 731, 3, 'Symbol 11', ' ');
INSERT INTO answer VALUES (2927, 732, 0, 'Symbol 6', ' ');
INSERT INTO answer VALUES (2925, 732, 1, 'Symbol 4', ' ');
INSERT INTO answer VALUES (2926, 732, 2, 'Symbol 7', ' ');
INSERT INTO answer VALUES (2928, 732, 3, 'Symbol 1', ' ');
INSERT INTO answer VALUES (2929, 733, 0, 'Symbol 7', ' ');
INSERT INTO answer VALUES (2930, 733, 1, 'Symbol 11', ' ');
INSERT INTO answer VALUES (2931, 733, 2, 'Symbol 6', ' ');
INSERT INTO answer VALUES (2932, 733, 3, 'Symbol 1', ' ');
INSERT INTO answer VALUES (2934, 734, 0, 'To eliminate self-oscillations', ' ');
INSERT INTO answer VALUES (2933, 734, 1, 'To limit the modulation index', ' ');
INSERT INTO answer VALUES (2935, 734, 2, 'To cut off the final amplifier during standby periods', ' ');
INSERT INTO answer VALUES (2936, 734, 3, 'To keep the carrier on frequency', ' ');
INSERT INTO answer VALUES (2940, 735, 0, 'Class C', ' ');
INSERT INTO answer VALUES (2937, 735, 1, 'Class A', ' ');
INSERT INTO answer VALUES (2938, 735, 2, 'Class B', ' ');
INSERT INTO answer VALUES (2939, 735, 3, 'Class AB', ' ');
INSERT INTO answer VALUES (2942, 736, 0, 'Output is high only when both inputs are high', ' ');
INSERT INTO answer VALUES (2941, 736, 1, 'Output is high when either or both inputs are low', ' ');
INSERT INTO answer VALUES (2943, 736, 2, 'Output is low when either or both inputs are high', ' ');
INSERT INTO answer VALUES (2944, 736, 3, 'Output is low only when both inputs are high', ' ');
INSERT INTO answer VALUES (2947, 737, 0, 'Output is low when either or both inputs are high', ' ');
INSERT INTO answer VALUES (2945, 737, 1, 'Output is high when either or both inputs are low', ' ');
INSERT INTO answer VALUES (2946, 737, 2, 'Output is high only when both inputs are high', ' ');
INSERT INTO answer VALUES (2948, 737, 3, 'Output is low only when both inputs are high', ' ');
INSERT INTO answer VALUES (2951, 738, 0, '8', ' ');
INSERT INTO answer VALUES (2949, 738, 1, '3', ' ');
INSERT INTO answer VALUES (2950, 738, 2, '6', ' ');
INSERT INTO answer VALUES (2952, 738, 3, '16', ' ');
INSERT INTO answer VALUES (2953, 739, 0, 'A clocked array of circuits that passes data in steps along the array', ' ');
INSERT INTO answer VALUES (2954, 739, 1, 'An array of operational amplifiers used for tri-state arithmetic operations', ' ');
INSERT INTO answer VALUES (2955, 739, 2, 'A digital mixer', ' ');
INSERT INTO answer VALUES (2956, 739, 3, 'An analog mixer', ' ');
INSERT INTO answer VALUES (2960, 740, 0, 'A filter and an amplifier operating in a feedback loop', ' ');
INSERT INTO answer VALUES (2957, 740, 1, 'An amplifier and a divider', ' ');
INSERT INTO answer VALUES (2958, 740, 2, 'A frequency multiplier and a mixer', ' ');
INSERT INTO answer VALUES (2959, 740, 3, 'A circulator and a filter operating in a feed-forward loop', ' ');
INSERT INTO answer VALUES (2962, 741, 0, 'Divide the RF output power by the DC input power', ' ');
INSERT INTO answer VALUES (2961, 741, 1, 'Divide the DC input power by the DC output power', ' ');
INSERT INTO answer VALUES (2963, 741, 2, 'Multiply the RF input power by the reciprocal of the RF output power', ' ');
INSERT INTO answer VALUES (2964, 741, 3, 'Add the RF input power to the DC output power', ' ');
INSERT INTO answer VALUES (2967, 742, 0, 'The inductance and capacitance in the tank circuit', ' ');
INSERT INTO answer VALUES (2965, 742, 1, 'The number of stages in the counter', ' ');
INSERT INTO answer VALUES (2966, 742, 2, 'The number of stages in the divider', ' ');
INSERT INTO answer VALUES (2968, 742, 3, 'The time delay of the lag circuit', ' ');
INSERT INTO answer VALUES (2970, 743, 0, 'An amplifier in which the output preserves the input waveform', ' ');
INSERT INTO answer VALUES (2969, 743, 1, 'Any RF power amplifier used in conjunction with an amateur transceiver', ' ');
INSERT INTO answer VALUES (2971, 743, 2, 'A Class C high efficiency amplifier', ' ');
INSERT INTO answer VALUES (2972, 743, 3, 'An amplifier used as a frequency multiplier', ' ');
INSERT INTO answer VALUES (2974, 744, 0, 'FM', ' ');
INSERT INTO answer VALUES (2973, 744, 1, 'SSB', ' ');
INSERT INTO answer VALUES (2975, 744, 2, 'AM', ' ');
INSERT INTO answer VALUES (2976, 744, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (2978, 745, 0, 'Filter', ' ');
INSERT INTO answer VALUES (2977, 745, 1, 'Carrier oscillator', ' ');
INSERT INTO answer VALUES (2979, 745, 2, 'IF amplifier', ' ');
INSERT INTO answer VALUES (2980, 745, 3, 'RF amplifier', ' ');
INSERT INTO answer VALUES (2984, 746, 0, 'Balanced modulator', ' ');
INSERT INTO answer VALUES (2981, 746, 1, 'Discriminator', ' ');
INSERT INTO answer VALUES (2982, 746, 2, 'Detector', ' ');
INSERT INTO answer VALUES (2983, 746, 3, 'IF amplifier', ' ');
INSERT INTO answer VALUES (2987, 747, 0, 'Mixer', ' ');
INSERT INTO answer VALUES (2985, 747, 1, 'Balanced modulator', ' ');
INSERT INTO answer VALUES (2986, 747, 2, 'IF amplifier', ' ');
INSERT INTO answer VALUES (2988, 747, 3, 'Detector', ' ');
INSERT INTO answer VALUES (2992, 748, 0, 'Product detector', ' ');
INSERT INTO answer VALUES (2989, 748, 1, 'RF oscillator', ' ');
INSERT INTO answer VALUES (2990, 748, 2, 'IF filter', ' ');
INSERT INTO answer VALUES (2991, 748, 3, 'Balanced modulator', ' ');
INSERT INTO answer VALUES (2996, 749, 0, 'Variable frequency with the stability of a crystal oscillator', ' ');
INSERT INTO answer VALUES (2993, 749, 1, 'Wide tuning range and no need for band switching', ' ');
INSERT INTO answer VALUES (2994, 749, 2, 'Relatively high-power output', ' ');
INSERT INTO answer VALUES (2995, 749, 3, 'Relatively low power consumption', ' ');
INSERT INTO answer VALUES (2998, 750, 0, 'About the same', ' ');
INSERT INTO answer VALUES (2997, 750, 1, 'Substantially higher', ' ');
INSERT INTO answer VALUES (2999, 750, 2, 'Substantially lower', ' ');
INSERT INTO answer VALUES (3000, 750, 3, 'Twice the transmission line impedance', ' ');
INSERT INTO answer VALUES (3003, 751, 0, 'HF oscillator, mixer, detector', ' ');
INSERT INTO answer VALUES (3001, 751, 1, 'RF amplifier, detector, audio amplifier', ' ');
INSERT INTO answer VALUES (3002, 751, 2, 'RF amplifier, mixer, IF discriminator', ' ');
INSERT INTO answer VALUES (3004, 751, 3, 'HF oscillator, prescaler, audio amplifier', ' ');
INSERT INTO answer VALUES (3008, 752, 0, 'Discriminator', ' ');
INSERT INTO answer VALUES (3005, 752, 1, 'Product detector', ' ');
INSERT INTO answer VALUES (3006, 752, 2, 'Phase inverter', ' ');
INSERT INTO answer VALUES (3007, 752, 3, 'Mixer', ' ');
INSERT INTO answer VALUES (3010, 753, 0, '90 degrees', ' ');
INSERT INTO answer VALUES (3009, 753, 1, 'Zero', ' ');
INSERT INTO answer VALUES (3011, 753, 2, '180 degrees', ' ');
INSERT INTO answer VALUES (3012, 753, 3, '45 degrees', ' ');
INSERT INTO answer VALUES (3014, 754, 0, 'All types of modulation can be created with appropriate processing', ' ');
INSERT INTO answer VALUES (3013, 754, 1, 'The need for high resolution analog-to-digital converters is eliminated', ' ');
INSERT INTO answer VALUES (3015, 754, 2, 'Minimum detectible signal level is reduced', ' ');
INSERT INTO answer VALUES (3016, 754, 3, 'Converting the signal from digital to analog creates mixing products', ' ');
INSERT INTO answer VALUES (3017, 755, 0, 'A radio in which most major signal processing functions are performed by software', ' ');
INSERT INTO answer VALUES (3018, 755, 1, 'A radio that provides computer interface for automatic logging of band and frequency', ' ');
INSERT INTO answer VALUES (3019, 755, 2, 'A radio that uses crystal filters designed using software', ' ');
INSERT INTO answer VALUES (3020, 755, 3, 'A computer model that can simulate performance of a radio to aid in the design process', ' ');
INSERT INTO answer VALUES (3023, 756, 0, 'Cutoff frequency', ' ');
INSERT INTO answer VALUES (3021, 756, 1, 'Notch frequency', ' ');
INSERT INTO answer VALUES (3022, 756, 2, 'Neper frequency', ' ');
INSERT INTO answer VALUES (3024, 756, 3, 'Rolloff frequency', ' ');
INSERT INTO answer VALUES (3028, 757, 0, 'Ultimate rejection', ' ');
INSERT INTO answer VALUES (3025, 757, 1, 'Notch depth', ' ');
INSERT INTO answer VALUES (3026, 757, 2, 'Rolloff', ' ');
INSERT INTO answer VALUES (3027, 757, 3, 'Insertion loss', ' ');
INSERT INTO answer VALUES (3029, 758, 0, 'Upper and lower half-power', ' ');
INSERT INTO answer VALUES (3030, 758, 1, 'Cutoff and rolloff', ' ');
INSERT INTO answer VALUES (3031, 758, 2, 'Pole and zero', ' ');
INSERT INTO answer VALUES (3032, 758, 3, 'Image and harmonic', ' ');
INSERT INTO answer VALUES (3033, 759, 0, 'Insertion loss', ' ');
INSERT INTO answer VALUES (3034, 759, 1, 'Return loss', ' ');
INSERT INTO answer VALUES (3035, 759, 2, 'Q', ' ');
INSERT INTO answer VALUES (3036, 759, 3, 'Ultimate rejection', ' ');
INSERT INTO answer VALUES (3037, 760, 0, 'A high-stability variable frequency oscillator in a transceiver', ' ');
INSERT INTO answer VALUES (3038, 760, 1, 'A digital voltmeter', ' ');
INSERT INTO answer VALUES (3039, 760, 2, 'A digital mode interface between a computer and a transceiver', ' ');
INSERT INTO answer VALUES (3040, 760, 3, 'A high-sensitivity radio direction finder', ' ');
INSERT INTO answer VALUES (3042, 761, 0, 'By changing an oscillator’s frequency directly with a digital control signal', ' ');
INSERT INTO answer VALUES (3041, 761, 1, 'By keying an FM transmitter with a sub-audible tone', ' ');
INSERT INTO answer VALUES (3043, 761, 2, 'By using a transceiver’s computer data interface protocol to change frequencies', ' ');
INSERT INTO answer VALUES (3044, 761, 3, 'By reconfiguring the CW keying input to act as a tone generator', ' ');
INSERT INTO answer VALUES (3046, 762, 0, 'Phase modulation', ' ');
INSERT INTO answer VALUES (3045, 762, 1, 'Phase convolution', ' ');
INSERT INTO answer VALUES (3047, 762, 2, 'Phase transformation', ' ');
INSERT INTO answer VALUES (3048, 762, 3, 'Phase inversion', ' ');
INSERT INTO answer VALUES (3052, 763, 0, 'Frequency modulation', ' ');
INSERT INTO answer VALUES (3049, 763, 1, 'Frequency convolution', ' ');
INSERT INTO answer VALUES (3050, 763, 2, 'Frequency transformation', ' ');
INSERT INTO answer VALUES (3051, 763, 3, 'Frequency conversion', ' ');
INSERT INTO answer VALUES (3054, 764, 0, 'Phase modulation', ' ');
INSERT INTO answer VALUES (3053, 764, 1, 'Multiplex modulation', ' ');
INSERT INTO answer VALUES (3055, 764, 2, 'Amplitude modulation', ' ');
INSERT INTO answer VALUES (3056, 764, 3, 'Pulse modulation', ' ');
INSERT INTO answer VALUES (3060, 765, 0, 'Amplitude modulation', ' ');
INSERT INTO answer VALUES (3057, 765, 1, 'Frequency shift keying', ' ');
INSERT INTO answer VALUES (3058, 765, 2, 'Phase modulation', ' ');
INSERT INTO answer VALUES (3059, 765, 3, 'Frequency modulation', ' ');
INSERT INTO answer VALUES (3064, 766, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3061, 766, 1, 'It is sideband sensitive', ' ');
INSERT INTO answer VALUES (3062, 766, 2, 'Its encoding provides error correction', ' ');
INSERT INTO answer VALUES (3063, 766, 3, 'Its bandwidth is approximately the same as BPSK31', ' ');
INSERT INTO answer VALUES (3065, 767, 0, 'Single sideband', ' ');
INSERT INTO answer VALUES (3066, 767, 1, 'Double sideband', ' ');
INSERT INTO answer VALUES (3067, 767, 2, 'Phase modulation', ' ');
INSERT INTO answer VALUES (3068, 767, 3, 'Frequency modulation', ' ');
INSERT INTO answer VALUES (3072, 768, 0, 'Excessive bandwidth', ' ');
INSERT INTO answer VALUES (3069, 768, 1, 'Insufficient audio', ' ');
INSERT INTO answer VALUES (3070, 768, 2, 'Insufficient bandwidth', ' ');
INSERT INTO answer VALUES (3071, 768, 3, 'Frequency drift', ' ');
INSERT INTO answer VALUES (3073, 769, 0, '8-tone frequency shift keying', ' ');
INSERT INTO answer VALUES (3074, 769, 1, 'Vestigial sideband', ' ');
INSERT INTO answer VALUES (3075, 769, 2, 'Amplitude compressed AM', ' ');
INSERT INTO answer VALUES (3076, 769, 3, 'Direct sequence spread spectrum', ' ');
INSERT INTO answer VALUES (3079, 770, 0, 'Signal distortion caused by excessive drive', ' ');
INSERT INTO answer VALUES (3077, 770, 1, 'Signal distortion caused by insufficient collector current', ' ');
INSERT INTO answer VALUES (3078, 770, 2, 'The transmitter’s automatic level control (ALC) is properly adjusted', ' ');
INSERT INTO answer VALUES (3080, 770, 3, 'The transmitter’s carrier is properly suppressed', ' ');
INSERT INTO answer VALUES (3081, 771, 0, 'The waveform created by connecting the peak values of the modulated signal', ' ');
INSERT INTO answer VALUES (3082, 771, 1, 'The carrier frequency that contains the signal', ' ');
INSERT INTO answer VALUES (3083, 771, 2, 'Spurious signals that envelop nearby frequencies', ' ');
INSERT INTO answer VALUES (3084, 771, 3, 'The bandwidth of the modulated signal', ' ');
INSERT INTO answer VALUES (3086, 772, 0, 'FT8', ' ');
INSERT INTO answer VALUES (3085, 772, 1, 'MSK144', ' ');
INSERT INTO answer VALUES (3087, 772, 2, 'AMTOR', ' ');
INSERT INTO answer VALUES (3088, 772, 3, 'MFSK32', ' ');
INSERT INTO answer VALUES (3090, 773, 0, 'Local oscillator', ' ');
INSERT INTO answer VALUES (3089, 773, 1, 'Image frequency', ' ');
INSERT INTO answer VALUES (3091, 773, 2, 'RF input', ' ');
INSERT INTO answer VALUES (3092, 773, 3, 'Beat frequency oscillator', ' ');
INSERT INTO answer VALUES (3094, 774, 0, 'Image response', ' ');
INSERT INTO answer VALUES (3093, 774, 1, 'Quadrature noise', ' ');
INSERT INTO answer VALUES (3095, 774, 2, 'Mixer interference', ' ');
INSERT INTO answer VALUES (3096, 774, 3, 'Intermediate interference', ' ');
INSERT INTO answer VALUES (3097, 775, 0, 'Heterodyning', ' ');
INSERT INTO answer VALUES (3098, 775, 1, 'Synthesizing', ' ');
INSERT INTO answer VALUES (3099, 775, 2, 'Cancellation', ' ');
INSERT INTO answer VALUES (3100, 775, 3, 'Phase inverting', ' ');
INSERT INTO answer VALUES (3104, 776, 0, 'Multiplier', ' ');
INSERT INTO answer VALUES (3101, 776, 1, 'Mixer', ' ');
INSERT INTO answer VALUES (3102, 776, 2, 'Reactance modulator', ' ');
INSERT INTO answer VALUES (3103, 776, 3, 'Pre-emphasis network', ' ');
INSERT INTO answer VALUES (3108, 777, 0, '2300 Hz', ' ');
INSERT INTO answer VALUES (3105, 777, 1, '31.5 Hz', ' ');
INSERT INTO answer VALUES (3106, 777, 2, '500 Hz', ' ');
INSERT INTO answer VALUES (3107, 777, 3, '1800 Hz', ' ');
INSERT INTO answer VALUES (3112, 778, 0, '16 kHz', ' ');
INSERT INTO answer VALUES (3109, 778, 1, '3 kHz', ' ');
INSERT INTO answer VALUES (3110, 778, 2, '5 kHz', ' ');
INSERT INTO answer VALUES (3111, 778, 3, '8 kHz', ' ');
INSERT INTO answer VALUES (3114, 779, 0, '416.7 Hz', ' ');
INSERT INTO answer VALUES (3113, 779, 1, '101.75 Hz', ' ');
INSERT INTO answer VALUES (3115, 779, 2, '5 kHz', ' ');
INSERT INTO answer VALUES (3116, 779, 3, '60 kHz', ' ');
INSERT INTO answer VALUES (3118, 780, 0, 'Some modes have high duty cycles that could exceed the transmitter’s average power rating', ' ');
INSERT INTO answer VALUES (3117, 780, 1, 'To aid in tuning your transmitter', ' ');
INSERT INTO answer VALUES (3119, 780, 2, 'To allow time for the other station to break in during a transmission', ' ');
INSERT INTO answer VALUES (3120, 780, 3, 'The attenuator will have to be adjusted accordingly', ' ');
INSERT INTO answer VALUES (3124, 781, 0, 'It results in the best signal-to-noise ratio', ' ');
INSERT INTO answer VALUES (3121, 781, 1, 'It is required by FCC rules', ' ');
INSERT INTO answer VALUES (3122, 781, 2, 'It minimizes power consumption in the receiver', ' ');
INSERT INTO answer VALUES (3123, 781, 3, 'It improves impedance matching of the antenna', ' ');
INSERT INTO answer VALUES (3126, 782, 0, 'Higher symbol rates require wider bandwidth', ' ');
INSERT INTO answer VALUES (3125, 782, 1, 'Symbol rate and bandwidth are not related', ' ');
INSERT INTO answer VALUES (3127, 782, 2, 'Lower symbol rates require wider bandwidth', ' ');
INSERT INTO answer VALUES (3128, 782, 3, 'Bandwidth is always half the symbol rate', ' ');
INSERT INTO answer VALUES (3131, 783, 0, 'The sum and difference', ' ');
INSERT INTO answer VALUES (3129, 783, 1, 'The ratio', ' ');
INSERT INTO answer VALUES (3130, 783, 2, 'The average', ' ');
INSERT INTO answer VALUES (3132, 783, 3, 'The arithmetic product', ' ');
INSERT INTO answer VALUES (3133, 784, 0, 'Intermodulation', ' ');
INSERT INTO answer VALUES (3134, 784, 1, 'Heterodyning', ' ');
INSERT INTO answer VALUES (3135, 784, 2, 'Detection', ' ');
INSERT INTO answer VALUES (3136, 784, 3, 'Rolloff', ' ');
INSERT INTO answer VALUES (3139, 785, 0, '2.4 GHz', ' ');
INSERT INTO answer VALUES (3137, 785, 1, '432 MHz', ' ');
INSERT INTO answer VALUES (3138, 785, 2, '902 MHz', ' ');
INSERT INTO answer VALUES (3140, 785, 3, '10.7 GHz', ' ');
INSERT INTO answer VALUES (3141, 786, 0, 'WSPR', ' ');
INSERT INTO answer VALUES (3142, 786, 1, 'Olivia', ' ');
INSERT INTO answer VALUES (3143, 786, 2, 'PSK31', ' ');
INSERT INTO answer VALUES (3144, 786, 3, 'SSB-SC', ' ');
INSERT INTO answer VALUES (3147, 787, 0, 'Header', ' ');
INSERT INTO answer VALUES (3145, 787, 1, 'Directory', ' ');
INSERT INTO answer VALUES (3146, 787, 2, 'Preamble', ' ');
INSERT INTO answer VALUES (3148, 787, 3, 'Footer', ' ');
INSERT INTO answer VALUES (3151, 788, 0, 'A 5-bit code with additional start and stop bits', ' ');
INSERT INTO answer VALUES (3149, 788, 1, 'A 7-bit code with start, stop, and parity bits', ' ');
INSERT INTO answer VALUES (3150, 788, 2, 'A code using error detection and correction', ' ');
INSERT INTO answer VALUES (3152, 788, 3, 'A code using SELCAL and LISTEN', ' ');
INSERT INTO answer VALUES (3153, 789, 0, 'The receiver is requesting the packet be retransmitted', ' ');
INSERT INTO answer VALUES (3154, 789, 1, 'The receiver is reporting the packet was received without error', ' ');
INSERT INTO answer VALUES (3155, 789, 2, 'The receiver is busy decoding the packet', ' ');
INSERT INTO answer VALUES (3156, 789, 3, 'The entire file has been received correctly', ' ');
INSERT INTO answer VALUES (3158, 790, 0, 'The connection is dropped', ' ');
INSERT INTO answer VALUES (3157, 790, 1, 'The checksum overflows', ' ');
INSERT INTO answer VALUES (3159, 790, 2, 'Packets will be routed incorrectly', ' ');
INSERT INTO answer VALUES (3160, 790, 3, 'Encoding reverts to the default character set', ' ');
INSERT INTO answer VALUES (3162, 791, 0, 'It requests the packet be retransmitted', ' ');
INSERT INTO answer VALUES (3161, 791, 1, 'It terminates the contact', ' ');
INSERT INTO answer VALUES (3163, 791, 2, 'It sends the packet back to the transmitting station', ' ');
INSERT INTO answer VALUES (3164, 791, 3, 'It requests a change in transmitting protocol', ' ');
INSERT INTO answer VALUES (3166, 792, 0, 'Upper case letters use longer Varicode bit sequences and thus slow down transmission', ' ');
INSERT INTO answer VALUES (3165, 792, 1, 'Upper case letters are sent with more power', ' ');
INSERT INTO answer VALUES (3167, 792, 2, 'Error correction is used to ensure accurate message reception', ' ');
INSERT INTO answer VALUES (3168, 792, 3, 'Higher power is needed as compared to RTTY for similar error rates', ' ');
INSERT INTO answer VALUES (3169, 793, 0, 'The approximate transmitted symbol rate', ' ');
INSERT INTO answer VALUES (3170, 793, 1, 'The version of the PSK protocol', ' ');
INSERT INTO answer VALUES (3171, 793, 2, 'The year in which PSK31 was invented', ' ');
INSERT INTO answer VALUES (3172, 793, 3, 'The number of characters that can be represented by PSK31', ' ');
INSERT INTO answer VALUES (3175, 794, 0, 'By transmitting redundant information with the data', ' ');
INSERT INTO answer VALUES (3173, 794, 1, 'By controlling transmitter output power for optimum signal strength', ' ');
INSERT INTO answer VALUES (3174, 794, 2, 'By using the Varicode character set', ' ');
INSERT INTO answer VALUES (3176, 794, 3, 'By using a parity bit with each character', ' ');
INSERT INTO answer VALUES (3180, 795, 0, 'Mark and space', ' ');
INSERT INTO answer VALUES (3177, 795, 1, 'Dot and dash', ' ');
INSERT INTO answer VALUES (3178, 795, 2, 'On and off', ' ');
INSERT INTO answer VALUES (3179, 795, 3, 'High and low', ' ');
INSERT INTO answer VALUES (3181, 796, 0, 'Varicode', ' ');
INSERT INTO answer VALUES (3182, 796, 1, 'Viterbi', ' ');
INSERT INTO answer VALUES (3183, 796, 2, 'Volumetric', ' ');
INSERT INTO answer VALUES (3184, 796, 3, 'Binary', ' ');
INSERT INTO answer VALUES (3188, 797, 0, 'Overmodulation', ' ');
INSERT INTO answer VALUES (3185, 797, 1, 'Long path propagation', ' ');
INSERT INTO answer VALUES (3186, 797, 2, 'Backscatter propagation', ' ');
INSERT INTO answer VALUES (3187, 797, 3, 'Insufficient modulation', ' ');
INSERT INTO answer VALUES (3191, 798, 0, 'Frequency is horizontal, signal strength is intensity, time is vertical', ' ');
INSERT INTO answer VALUES (3189, 798, 1, 'Frequency is horizontal, signal strength is vertical, time is intensity', ' ');
INSERT INTO answer VALUES (3190, 798, 2, 'Frequency is vertical, signal strength is intensity, time is horizontal', ' ');
INSERT INTO answer VALUES (3192, 798, 3, 'Frequency is vertical, signal strength is horizontal, time is intensity', ' ');
INSERT INTO answer VALUES (3193, 799, 0, 'The distance between the centers of the conductors and the radius of the conductors', ' ');
INSERT INTO answer VALUES (3194, 799, 1, 'The distance between the centers of the conductors and the length of the line', ' ');
INSERT INTO answer VALUES (3195, 799, 2, 'The radius of the conductors and the frequency of the signal', ' ');
INSERT INTO answer VALUES (3196, 799, 3, 'The frequency of the signal and the length of the line', ' ');
INSERT INTO answer VALUES (3198, 800, 0, '50 and 75 ohms', ' ');
INSERT INTO answer VALUES (3197, 800, 1, '25 and 30 ohms', ' ');
INSERT INTO answer VALUES (3199, 800, 2, '80 and 100 ohms', ' ');
INSERT INTO answer VALUES (3200, 800, 3, '500 and 750 ohms', ' ');
INSERT INTO answer VALUES (3204, 801, 0, '450 ohms', ' ');
INSERT INTO answer VALUES (3201, 801, 1, '50 ohms', ' ');
INSERT INTO answer VALUES (3202, 801, 2, '75 ohms', ' ');
INSERT INTO answer VALUES (3203, 801, 3, '100 ohms', ' ');
INSERT INTO answer VALUES (3207, 802, 0, 'A difference between feed-line impedance and antenna feed-point impedance', ' ');
INSERT INTO answer VALUES (3205, 802, 1, 'Operating an antenna at its resonant frequency', ' ');
INSERT INTO answer VALUES (3206, 802, 2, 'Using more transmitter power than the antenna can handle', ' ');
INSERT INTO answer VALUES (3208, 802, 3, 'Feeding the antenna with unbalanced feed line', ' ');
INSERT INTO answer VALUES (3210, 803, 0, 'Attenuation increases', ' ');
INSERT INTO answer VALUES (3209, 803, 1, 'Attenuation is independent of frequency', ' ');
INSERT INTO answer VALUES (3211, 803, 2, 'Attenuation decreases', ' ');
INSERT INTO answer VALUES (3212, 803, 3, 'Attenuation reaches a maximum at approximately 18 MHz', ' ');
INSERT INTO answer VALUES (3216, 804, 0, 'Decibels per 100 feet', ' ');
INSERT INTO answer VALUES (3213, 804, 1, 'Ohms per 1000 feet', ' ');
INSERT INTO answer VALUES (3214, 804, 2, 'Decibels per 1000 feet', ' ');
INSERT INTO answer VALUES (3215, 804, 3, 'Ohms per 100 feet', ' ');
INSERT INTO answer VALUES (3220, 805, 0, 'The antenna feed point impedance must be matched to the characteristic impedance of the feed line', ' ');
INSERT INTO answer VALUES (3217, 805, 1, 'The antenna feed point must be at DC ground potential', ' ');
INSERT INTO answer VALUES (3218, 805, 2, 'The feed line must be cut to a length equal to an odd number of electrical quarter wavelengths', ' ');
INSERT INTO answer VALUES (3219, 805, 3, 'The feed line must be cut to a length equal to an even number of physical half wavelengths', ' ');
INSERT INTO answer VALUES (3222, 806, 0, '5 to 1', ' ');
INSERT INTO answer VALUES (3221, 806, 1, '1 to 1', ' ');
INSERT INTO answer VALUES (3223, 806, 2, 'Between 1 to 1 and 5 to 1 depending on the characteristic impedance of the line', ' ');
INSERT INTO answer VALUES (3224, 806, 3, 'Between 1 to 1 and 5 to 1 depending on the reflected power at the transmitter', ' ');
INSERT INTO answer VALUES (3225, 807, 0, '4:1', ' ');
INSERT INTO answer VALUES (3226, 807, 1, '1:4', ' ');
INSERT INTO answer VALUES (3227, 807, 2, '2:1', ' ');
INSERT INTO answer VALUES (3228, 807, 3, '1:2', ' ');
INSERT INTO answer VALUES (3232, 808, 0, '5:1', ' ');
INSERT INTO answer VALUES (3229, 808, 1, '2:1', ' ');
INSERT INTO answer VALUES (3230, 808, 2, '50:1', ' ');
INSERT INTO answer VALUES (3231, 808, 3, '1:5', ' ');
INSERT INTO answer VALUES (3234, 809, 0, '1:1', ' ');
INSERT INTO answer VALUES (3233, 809, 1, '2:1', ' ');
INSERT INTO answer VALUES (3235, 809, 2, '50:50', ' ');
INSERT INTO answer VALUES (3236, 809, 3, '0:0', ' ');
INSERT INTO answer VALUES (3238, 810, 0, 'If a transmission line is lossy, high SWR will increase the loss', ' ');
INSERT INTO answer VALUES (3237, 810, 1, 'There is no interaction between transmission line loss and SWR', ' ');
INSERT INTO answer VALUES (3239, 810, 2, 'High SWR makes it difficult to measure transmission line loss', ' ');
INSERT INTO answer VALUES (3240, 810, 3, 'High SWR reduces the relative effect of transmission line loss', ' ');
INSERT INTO answer VALUES (3241, 811, 0, 'The higher the transmission line loss, the more the SWR will read artificially low', ' ');
INSERT INTO answer VALUES (3242, 811, 1, 'The higher the transmission line loss, the more the SWR will read artificially high', ' ');
INSERT INTO answer VALUES (3243, 811, 2, 'The higher the transmission line loss, the more accurate the SWR measurement will be', ' ');
INSERT INTO answer VALUES (3244, 811, 3, 'Transmission line loss does not affect the SWR measurement', ' ');
INSERT INTO answer VALUES (3246, 812, 0, 'You may experience RF burns when touching metal objects in your station', ' ');
INSERT INTO answer VALUES (3245, 812, 1, 'It must be longer than 1 wavelength', ' ');
INSERT INTO answer VALUES (3247, 812, 2, 'It produces only vertically polarized radiation', ' ');
INSERT INTO answer VALUES (3248, 812, 3, 'It is more effective on the lower HF bands than on the higher bands', ' ');
INSERT INTO answer VALUES (3250, 813, 0, 'Slope the radials downward', ' ');
INSERT INTO answer VALUES (3249, 813, 1, 'Slope the radials upward', ' ');
INSERT INTO answer VALUES (3251, 813, 2, 'Lengthen the radials', ' ');
INSERT INTO answer VALUES (3252, 813, 3, 'Shorten the radials', ' ');
INSERT INTO answer VALUES (3256, 814, 0, 'Omnidirectional in azimuth', ' ');
INSERT INTO answer VALUES (3253, 814, 1, 'Bi-directional in azimuth', ' ');
INSERT INTO answer VALUES (3254, 814, 2, 'Isotropic', ' ');
INSERT INTO answer VALUES (3255, 814, 3, 'Hemispherical', ' ');
INSERT INTO answer VALUES (3257, 815, 0, 'It is a figure-eight at right angles to the antenna', ' ');
INSERT INTO answer VALUES (3258, 815, 1, 'It is a figure-eight off both ends of the antenna', ' ');
INSERT INTO answer VALUES (3259, 815, 2, 'It is a circle (equal radiation in all directions)', ' ');
INSERT INTO answer VALUES (3260, 815, 3, 'It has a pair of lobes on one side of the antenna and a single lobe on the other side', ' ');
INSERT INTO answer VALUES (3263, 816, 0, 'If the antenna is less than 1/2 wavelength high, the azimuthal pattern is almost omnidirectional', ' ');
INSERT INTO answer VALUES (3261, 816, 1, 'If the antenna is too high, the pattern becomes unpredictable', ' ');
INSERT INTO answer VALUES (3262, 816, 2, 'Antenna height has no effect on the pattern', ' ');
INSERT INTO answer VALUES (3264, 816, 3, 'If the antenna is less than 1/2 wavelength high, radiation off the ends of the wire is eliminated', ' ');
INSERT INTO answer VALUES (3267, 817, 0, 'On the surface of the Earth or buried a few inches below the ground', ' ');
INSERT INTO answer VALUES (3265, 817, 1, 'As high as possible above the ground', ' ');
INSERT INTO answer VALUES (3266, 817, 2, 'Parallel to the antenna element', ' ');
INSERT INTO answer VALUES (3268, 817, 3, 'At the center of the antenna', ' ');
INSERT INTO answer VALUES (3270, 818, 0, 'It steadily decreases', ' ');
INSERT INTO answer VALUES (3269, 818, 1, 'It steadily increases', ' ');
INSERT INTO answer VALUES (3271, 818, 2, 'It peaks at about 1/8 wavelength above ground', ' ');
INSERT INTO answer VALUES (3272, 818, 3, 'It is unaffected by the height above ground', ' ');
INSERT INTO answer VALUES (3273, 819, 0, 'It steadily increases', ' ');
INSERT INTO answer VALUES (3274, 819, 1, 'It steadily decreases', ' ');
INSERT INTO answer VALUES (3275, 819, 2, 'It peaks at about 1/8 wavelength from the end', ' ');
INSERT INTO answer VALUES (3276, 819, 3, 'It is unaffected by the location of the feed point', ' ');
INSERT INTO answer VALUES (3277, 820, 0, 'Lower ground reflection losses', ' ');
INSERT INTO answer VALUES (3278, 820, 1, 'Lower feed-point impedance', ' ');
INSERT INTO answer VALUES (3279, 820, 2, 'Shorter radials', ' ');
INSERT INTO answer VALUES (3280, 820, 3, 'Lower radiation resistance', ' ');
INSERT INTO answer VALUES (3284, 821, 0, '33 feet', ' ');
INSERT INTO answer VALUES (3281, 821, 1, '8 feet', ' ');
INSERT INTO answer VALUES (3282, 821, 2, '16 feet', ' ');
INSERT INTO answer VALUES (3283, 821, 3, '24 feet', ' ');
INSERT INTO answer VALUES (3287, 822, 0, '132 feet', ' ');
INSERT INTO answer VALUES (3285, 822, 1, '42 feet', ' ');
INSERT INTO answer VALUES (3286, 822, 2, '84 feet', ' ');
INSERT INTO answer VALUES (3288, 822, 3, '263 feet', ' ');
INSERT INTO answer VALUES (3289, 823, 0, '8 feet', ' ');
INSERT INTO answer VALUES (3290, 823, 1, '11 feet', ' ');
INSERT INTO answer VALUES (3291, 823, 2, '16 feet', ' ');
INSERT INTO answer VALUES (3292, 823, 3, '21 feet', ' ');
INSERT INTO answer VALUES (3293, 824, 0, 'Larger-diameter elements', ' ');
INSERT INTO answer VALUES (3294, 824, 1, 'Closer element spacing', ' ');
INSERT INTO answer VALUES (3295, 824, 2, 'Loading coils in series with the element', ' ');
INSERT INTO answer VALUES (3296, 824, 3, 'Tapered-diameter elements', ' ');
INSERT INTO answer VALUES (3298, 825, 0, '1/2 wavelength', ' ');
INSERT INTO answer VALUES (3297, 825, 1, '1/4 wavelength', ' ');
INSERT INTO answer VALUES (3299, 825, 2, '3/4 wavelength', ' ');
INSERT INTO answer VALUES (3300, 825, 3, '1 wavelength', ' ');
INSERT INTO answer VALUES (3301, 826, 0, 'The reflector is longer, and the director is shorter', ' ');
INSERT INTO answer VALUES (3302, 826, 1, 'The reflector is shorter, and the director is longer', ' ');
INSERT INTO answer VALUES (3303, 826, 2, 'They are all the same length', ' ');
INSERT INTO answer VALUES (3304, 826, 3, 'Relative length depends on the frequency of operation', ' ');
INSERT INTO answer VALUES (3306, 827, 0, 'dBi gain figures are 2.15 dB higher than dBd gain figures', ' ');
INSERT INTO answer VALUES (3305, 827, 1, 'dBi gain figures are 2.15 dB lower than dBd gain figures', ' ');
INSERT INTO answer VALUES (3307, 827, 2, 'dBi gain figures are the same as the square root of dBd gain figures multiplied by 2.15', ' ');
INSERT INTO answer VALUES (3308, 827, 3, 'dBi gain figures are the reciprocal of dBd gain figures + 2.15 dB', ' ');
INSERT INTO answer VALUES (3309, 828, 0, 'Gain increases', ' ');
INSERT INTO answer VALUES (3310, 828, 1, 'Beamwidth increases', ' ');
INSERT INTO answer VALUES (3311, 828, 2, 'Front-to-back ratio decreases', ' ');
INSERT INTO answer VALUES (3312, 828, 3, 'Front-to-side ratio decreases', ' ');
INSERT INTO answer VALUES (3316, 829, 0, 'The reflector element must be approximately 5 percent longer than the driven element', ' ');
INSERT INTO answer VALUES (3313, 829, 1, 'The driven element must be fed with a balun transformer', ' ');
INSERT INTO answer VALUES (3314, 829, 2, 'There must be an open circuit in the driven element at the point opposite the feed point', ' ');
INSERT INTO answer VALUES (3315, 829, 3, 'The reflector element must be approximately 5 percent shorter than the driven element', ' ');
INSERT INTO answer VALUES (3319, 830, 0, 'The power radiated in the major radiation lobe compared to that in the opposite direction', ' ');
INSERT INTO answer VALUES (3317, 830, 1, 'The number of directors versus the number of reflectors', ' ');
INSERT INTO answer VALUES (3318, 830, 2, 'The relative position of the driven element with respect to the reflectors and directors', ' ');
INSERT INTO answer VALUES (3320, 830, 3, 'The ratio of forward gain to dipole gain', ' ');
INSERT INTO answer VALUES (3324, 831, 0, 'The direction of maximum radiated field strength from the antenna', ' ');
INSERT INTO answer VALUES (3321, 831, 1, 'The magnitude of the maximum vertical angle of radiation', ' ');
INSERT INTO answer VALUES (3322, 831, 2, 'The point of maximum current in a radiating antenna element', ' ');
INSERT INTO answer VALUES (3323, 831, 3, 'The maximum voltage standing wave point on a radiating element', ' ');
INSERT INTO answer VALUES (3326, 832, 0, 'Approximately 3 dB higher', ' ');
INSERT INTO answer VALUES (3325, 832, 1, 'Approximately 1.5 dB higher', ' ');
INSERT INTO answer VALUES (3327, 832, 2, 'Approximately 6 dB higher', ' ');
INSERT INTO answer VALUES (3328, 832, 3, 'Approximately 9 dB higher', ' ');
INSERT INTO answer VALUES (3332, 833, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3329, 833, 1, 'The physical length of the boom', ' ');
INSERT INTO answer VALUES (3330, 833, 2, 'The number of elements on the boom', ' ');
INSERT INTO answer VALUES (3331, 833, 3, 'The spacing of each element along the boom', ' ');
INSERT INTO answer VALUES (3335, 834, 0, 'A directional antenna', ' ');
INSERT INTO answer VALUES (3333, 834, 1, 'A quarter-wave vertical antenna', ' ');
INSERT INTO answer VALUES (3334, 834, 2, 'An isotropic antenna', ' ');
INSERT INTO answer VALUES (3336, 834, 3, 'An omnidirectional antenna', ' ');
INSERT INTO answer VALUES (3337, 835, 0, 'It does not require that the driven element be insulated from the boom', ' ');
INSERT INTO answer VALUES (3338, 835, 1, 'It does not require any inductors or capacitors', ' ');
INSERT INTO answer VALUES (3339, 835, 2, 'It is useful for matching multiband antennas', ' ');
INSERT INTO answer VALUES (3340, 835, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3341, 836, 0, '1/4 wavelength', ' ');
INSERT INTO answer VALUES (3342, 836, 1, '1/2 wavelength', ' ');
INSERT INTO answer VALUES (3343, 836, 2, '3/4 wavelength', ' ');
INSERT INTO answer VALUES (3344, 836, 3, '1 wavelength', ' ');
INSERT INTO answer VALUES (3345, 837, 0, 'About the same', ' ');
INSERT INTO answer VALUES (3346, 837, 1, 'About 2/3 as much', ' ');
INSERT INTO answer VALUES (3347, 837, 2, 'About 1.5 times as much', ' ');
INSERT INTO answer VALUES (3348, 837, 3, 'About twice as much', ' ');
INSERT INTO answer VALUES (3349, 838, 0, 'dBi refers to an isotropic antenna, dBd refers to a dipole antenna', ' ');
INSERT INTO answer VALUES (3350, 838, 1, 'dBi refers to an ionospheric reflecting antenna, dBd refers to a dissipative antenna', ' ');
INSERT INTO answer VALUES (3351, 838, 2, 'dBi refers to an inverted-vee antenna, dBd refers to a downward reflecting antenna', ' ');
INSERT INTO answer VALUES (3352, 838, 3, 'dBi refers to an isometric antenna, dBd refers to a discone antenna', ' ');
INSERT INTO answer VALUES (3353, 839, 0, 'It is a shorted transmission line stub placed at the feed point of a Yagi antenna to provide impedance matching', ' ');
INSERT INTO answer VALUES (3354, 839, 1, 'It is a ¼ wavelength section of 75 ohm coax in series with the feed point of a Yagi to provide impedance matching', ' ');
INSERT INTO answer VALUES (3355, 839, 2, 'It is a series capacitor selected to cancel the inductive reactance of a folded dipole antenna', ' ');
INSERT INTO answer VALUES (3356, 839, 3, 'It is a section of 300 ohm twinlead used to match a folded dipole antenna', ' ');
INSERT INTO answer VALUES (3357, 840, 0, 'A horizontal dipole placed between 1/10 and 1/4 wavelength above the ground', ' ');
INSERT INTO answer VALUES (3358, 840, 1, 'A vertical antenna placed between 1/4 and 1/2 wavelength above the ground', ' ');
INSERT INTO answer VALUES (3359, 840, 2, 'A left-hand circularly polarized antenna', ' ');
INSERT INTO answer VALUES (3360, 840, 3, 'A right-hand circularly polarized antenna', ' ');
INSERT INTO answer VALUES (3364, 841, 0, 'Very high', ' ');
INSERT INTO answer VALUES (3361, 841, 1, 'Very low', ' ');
INSERT INTO answer VALUES (3362, 841, 2, 'Approximately 50 ohms', ' ');
INSERT INTO answer VALUES (3363, 841, 3, 'Approximately 300 ohms', ' ');
INSERT INTO answer VALUES (3367, 842, 0, 'Omnidirectional in the plane of the halo', ' ');
INSERT INTO answer VALUES (3365, 842, 1, 'Broadside to the plane of the halo', ' ');
INSERT INTO answer VALUES (3366, 842, 2, 'Opposite the feed point', ' ');
INSERT INTO answer VALUES (3368, 842, 3, 'Toward the halo’s supporting mast', ' ');
INSERT INTO answer VALUES (3369, 843, 0, 'To permit multiband operation', ' ');
INSERT INTO answer VALUES (3370, 843, 1, 'To notch spurious frequencies', ' ');
INSERT INTO answer VALUES (3371, 843, 2, 'To provide balanced feed-point impedance', ' ');
INSERT INTO answer VALUES (3372, 843, 3, 'To prevent out-of-band operation', ' ');
INSERT INTO answer VALUES (3376, 844, 0, 'It narrows the main lobe in elevation', ' ');
INSERT INTO answer VALUES (3373, 844, 1, 'It allows quick selection of vertical or horizontal polarization', ' ');
INSERT INTO answer VALUES (3374, 844, 2, 'It allows simultaneous vertical and horizontal polarization', ' ');
INSERT INTO answer VALUES (3375, 844, 3, 'It narrows the main lobe in azimuth', ' ');
INSERT INTO answer VALUES (3377, 845, 0, 'Wide bandwidth', ' ');
INSERT INTO answer VALUES (3378, 845, 1, 'Higher gain per element than a Yagi antenna', ' ');
INSERT INTO answer VALUES (3379, 845, 2, 'Harmonic suppression', ' ');
INSERT INTO answer VALUES (3380, 845, 3, 'Polarization diversity', ' ');
INSERT INTO answer VALUES (3381, 846, 0, 'Element length and spacing vary logarithmically along the boom', ' ');
INSERT INTO answer VALUES (3382, 846, 1, 'Impedance varies periodically as a function of frequency', ' ');
INSERT INTO answer VALUES (3383, 846, 2, 'Gain varies logarithmically as a function of frequency', ' ');
INSERT INTO answer VALUES (3384, 846, 3, 'SWR varies periodically as a function of boom length', ' ');
INSERT INTO answer VALUES (3386, 847, 0, 'By varying the base loading inductance', ' ');
INSERT INTO answer VALUES (3385, 847, 1, 'By varying its body capacitance', ' ');
INSERT INTO answer VALUES (3387, 847, 2, 'By extending and retracting the whip', ' ');
INSERT INTO answer VALUES (3388, 847, 3, 'By deploying a capacitance hat', ' ');
INSERT INTO answer VALUES (3389, 848, 0, 'Directional receiving for low HF bands', ' ');
INSERT INTO answer VALUES (3390, 848, 1, 'Directional transmitting for low HF bands', ' ');
INSERT INTO answer VALUES (3391, 848, 2, 'Portable direction finding at higher HF frequencies', ' ');
INSERT INTO answer VALUES (3392, 848, 3, 'Portable direction finding at lower HF frequencies', ' ');
INSERT INTO answer VALUES (3394, 849, 0, 'Broadside to the loop', ' ');
INSERT INTO answer VALUES (3393, 849, 1, 'In the plane of the loop', ' ');
INSERT INTO answer VALUES (3395, 849, 2, 'Broadside and in the plane of the loop', ' ');
INSERT INTO answer VALUES (3396, 849, 3, 'Electrically small loops are omnidirectional', ' ');
INSERT INTO answer VALUES (3400, 850, 0, 'They have poor harmonic rejection', ' ');
INSERT INTO answer VALUES (3397, 850, 1, 'They present low impedance on all design frequencies', ' ');
INSERT INTO answer VALUES (3398, 850, 2, 'They must be used with an antenna tuner', ' ');
INSERT INTO answer VALUES (3399, 850, 3, 'They must be fed with open wire line', ' ');
INSERT INTO answer VALUES (3401, 851, 0, 'Inverted V', ' ');
INSERT INTO answer VALUES (3402, 851, 1, 'Inverted L', ' ');
INSERT INTO answer VALUES (3403, 851, 2, 'Sloper', ' ');
INSERT INTO answer VALUES (3404, 851, 3, 'Lazy H', ' ');
INSERT INTO answer VALUES (3407, 852, 0, 'Virtually omnidirectional with a lower peak vertical radiation angle than a dipole', ' ');
INSERT INTO answer VALUES (3405, 852, 1, 'A figure-eight, similar to a dipole', ' ');
INSERT INTO answer VALUES (3406, 852, 2, 'Four major loops with deep nulls', ' ');
INSERT INTO answer VALUES (3408, 852, 3, 'Radiation maximum is straight up', ' ');
INSERT INTO answer VALUES (3409, 853, 0, 'It heats body tissue', ' ');
INSERT INTO answer VALUES (3410, 853, 1, 'It causes radiation poisoning', ' ');
INSERT INTO answer VALUES (3411, 853, 2, 'It causes the blood count to reach a dangerously low level', ' ');
INSERT INTO answer VALUES (3412, 853, 3, 'It cools body tissue', ' ');
INSERT INTO answer VALUES (3416, 854, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3413, 854, 1, 'Its duty cycle', ' ');
INSERT INTO answer VALUES (3414, 854, 2, 'Its frequency', ' ');
INSERT INTO answer VALUES (3415, 854, 3, 'Its power density', ' ');
INSERT INTO answer VALUES (3420, 855, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3417, 855, 1, 'By calculation based on FCC OET Bulletin 65', ' ');
INSERT INTO answer VALUES (3418, 855, 2, 'By calculation based on computer modeling', ' ');
INSERT INTO answer VALUES (3419, 855, 3, 'By measurement of field strength using calibrated equipment', ' ');
INSERT INTO answer VALUES (3424, 856, 0, 'The total RF exposure averaged over a certain time', ' ');
INSERT INTO answer VALUES (3421, 856, 1, 'The average amount of power developed by the transmitter over a specific 24-hour period', ' ');
INSERT INTO answer VALUES (3422, 856, 2, 'The average time it takes RF radiation to have any long-term effect on the body', ' ');
INSERT INTO answer VALUES (3423, 856, 3, 'The total time of the exposure', ' ');
INSERT INTO answer VALUES (3425, 857, 0, 'Take action to prevent human exposure to the excessive RF fields', ' ');
INSERT INTO answer VALUES (3426, 857, 1, 'File an Environmental Impact Statement (EIS-97) with the FCC', ' ');
INSERT INTO answer VALUES (3427, 857, 2, 'Secure written permission from your neighbors to operate above the controlled MPE limits', ' ');
INSERT INTO answer VALUES (3428, 857, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3432, 858, 0, 'It should be installed such that it is protected against unauthorized access', ' ');
INSERT INTO answer VALUES (3429, 858, 1, 'It should not be installed higher than you can reach', ' ');
INSERT INTO answer VALUES (3430, 858, 2, 'It should not be installed in a wet area', ' ');
INSERT INTO answer VALUES (3431, 858, 3, 'It should be limited to 10 feet in height', ' ');
INSERT INTO answer VALUES (3433, 859, 0, 'A lower transmitter duty cycle permits greater short-term exposure levels', ' ');
INSERT INTO answer VALUES (3434, 859, 1, 'A higher transmitter duty cycle permits greater short-term exposure levels', ' ');
INSERT INTO answer VALUES (3435, 859, 2, 'Low duty cycle transmitters are exempt from RF exposure evaluation requirements', ' ');
INSERT INTO answer VALUES (3436, 859, 3, 'High duty cycle transmitters are exempt from RF exposure requirements', ' ');
INSERT INTO answer VALUES (3439, 860, 0, 'Perform a routine RF exposure evaluation', ' ');
INSERT INTO answer VALUES (3437, 860, 1, 'Post a copy of FCC Part 97.13 in the station', ' ');
INSERT INTO answer VALUES (3438, 860, 2, 'Post a copy of OET Bulletin 65 in the station', ' ');
INSERT INTO answer VALUES (3440, 860, 3, 'Contact the FCC for a visit to conduct a station evaluation', ' ');
INSERT INTO answer VALUES (3442, 861, 0, 'A calibrated field strength meter with a calibrated antenna', ' ');
INSERT INTO answer VALUES (3441, 861, 1, 'A receiver with an S meter', ' ');
INSERT INTO answer VALUES (3443, 861, 2, 'An SWR meter with a peak-reading function', ' ');
INSERT INTO answer VALUES (3444, 861, 3, 'An oscilloscope with a high-stability crystal marker generator', ' ');
INSERT INTO answer VALUES (3448, 862, 0, 'Take precautions to ensure that the antenna cannot be pointed in their direction', ' ');
INSERT INTO answer VALUES (3445, 862, 1, 'Change to a non-polarized antenna with higher gain', ' ');
INSERT INTO answer VALUES (3446, 862, 2, 'Post a warning sign that is clearly visible to the neighbor', ' ');
INSERT INTO answer VALUES (3447, 862, 3, 'Use an antenna with a higher front-to-back ratio', ' ');
INSERT INTO answer VALUES (3451, 863, 0, 'Make sure that MPE limits are not exceeded in occupied areas', ' ');
INSERT INTO answer VALUES (3449, 863, 1, 'Locate the antenna close to your operating position to minimize feed-line radiation', ' ');
INSERT INTO answer VALUES (3450, 863, 2, 'Position the antenna along the edge of a wall to reduce parasitic radiation', ' ');
INSERT INTO answer VALUES (3452, 863, 3, 'Make sure the antenna is properly shielded', ' ');
INSERT INTO answer VALUES (3453, 864, 0, 'Only the two wires carrying voltage', ' ');
INSERT INTO answer VALUES (3454, 864, 1, 'Only the neutral wire', ' ');
INSERT INTO answer VALUES (3455, 864, 2, 'Only the ground wire', ' ');
INSERT INTO answer VALUES (3456, 864, 3, 'All wires', ' ');
INSERT INTO answer VALUES (3459, 865, 0, 'AWG number 12', ' ');
INSERT INTO answer VALUES (3457, 865, 1, 'AWG number 20', ' ');
INSERT INTO answer VALUES (3458, 865, 2, 'AWG number 16', ' ');
INSERT INTO answer VALUES (3460, 865, 3, 'AWG number 8', ' ');
INSERT INTO answer VALUES (3464, 866, 0, '15 amperes', ' ');
INSERT INTO answer VALUES (3461, 866, 1, '100 amperes', ' ');
INSERT INTO answer VALUES (3462, 866, 2, '60 amperes', ' ');
INSERT INTO answer VALUES (3463, 866, 3, '30 amperes', ' ');
INSERT INTO answer VALUES (3465, 867, 0, 'Danger of carbon monoxide poisoning', ' ');
INSERT INTO answer VALUES (3466, 867, 1, 'Danger of engine over torque', ' ');
INSERT INTO answer VALUES (3467, 867, 2, 'Lack of oxygen for adequate combustion', ' ');
INSERT INTO answer VALUES (3468, 867, 3, 'Lack of nitrogen for adequate combustion', ' ');
INSERT INTO answer VALUES (3470, 868, 0, 'Current flowing from one or more of the voltage-carrying wires directly to ground', ' ');
INSERT INTO answer VALUES (3469, 868, 1, 'Current flowing from one or more of the voltage-carrying wires to the neutral wire', ' ');
INSERT INTO answer VALUES (3471, 868, 2, 'Overvoltage on the voltage-carrying wires', ' ');
INSERT INTO answer VALUES (3472, 868, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3475, 869, 0, 'Electrical safety inside the ham shack', ' ');
INSERT INTO answer VALUES (3473, 869, 1, 'Acceptable bandwidth limits', ' ');
INSERT INTO answer VALUES (3474, 869, 2, 'Acceptable modulation limits', ' ');
INSERT INTO answer VALUES (3476, 869, 3, 'RF exposure limits of the human body', ' ');
INSERT INTO answer VALUES (3478, 870, 0, 'Confirm that the belt is rated for the weight of the climber and that it is within its allowable service life', ' ');
INSERT INTO answer VALUES (3477, 870, 1, 'Never lean back and rely on the belt alone to support your weight', ' ');
INSERT INTO answer VALUES (3479, 870, 2, 'Ensure that all heavy tools are securely fastened to the belt D-ring', ' ');
INSERT INTO answer VALUES (3480, 870, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3482, 871, 0, 'Make sure all circuits that supply power to the tower are locked out and tagged', ' ');
INSERT INTO answer VALUES (3481, 871, 1, 'Notify the electric company that a person will be working on the tower', ' ');
INSERT INTO answer VALUES (3483, 871, 2, 'Unground the base of the tower', ' ');
INSERT INTO answer VALUES (3484, 871, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3485, 872, 0, 'The generator should be located in a well-ventilated area', ' ');
INSERT INTO answer VALUES (3486, 872, 1, 'The generator must be insulated from ground', ' ');
INSERT INTO answer VALUES (3487, 872, 2, 'Fuel should be stored near the generator for rapid refueling in case of an emergency', ' ');
INSERT INTO answer VALUES (3488, 872, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3489, 873, 0, 'Lead can contaminate food if hands are not washed carefully after handling the solder', ' ');
INSERT INTO answer VALUES (3490, 873, 1, 'High voltages can cause lead-tin solder to disintegrate suddenly', ' ');
INSERT INTO answer VALUES (3491, 873, 2, 'Tin in the solder can “cold flow,” causing shorts in the circuit', ' ');
INSERT INTO answer VALUES (3492, 873, 3, 'RF energy can convert the lead into a poisonous gas', ' ');
INSERT INTO answer VALUES (3496, 874, 0, 'They must be bonded together with all other grounds', ' ');
INSERT INTO answer VALUES (3493, 874, 1, 'They must be bonded to all buried water and gas lines', ' ');
INSERT INTO answer VALUES (3494, 874, 2, 'Bends in ground wires must be made as close as possible to a right angle', ' ');
INSERT INTO answer VALUES (3495, 874, 3, 'Lightning grounds must be connected to all ungrounded wiring', ' ');
INSERT INTO answer VALUES (3499, 875, 0, 'To ensure that dangerous voltages are removed if the cabinet is opened', ' ');
INSERT INTO answer VALUES (3497, 875, 1, 'To prevent unauthorized changes to the circuit that would void the manufacturer’s warranty', ' ');
INSERT INTO answer VALUES (3498, 875, 2, 'To shut down the unit if it becomes too hot', ' ');
INSERT INTO answer VALUES (3500, 875, 3, 'To shut off the power supply if too much voltage is produced', ' ');
INSERT INTO answer VALUES (3501, 876, 0, 'Disconnect the incoming utility power feed', ' ');
INSERT INTO answer VALUES (3502, 876, 1, 'Insure that the generator is not grounded', ' ');
INSERT INTO answer VALUES (3503, 876, 2, 'Insure that all lightning grounds are disconnected', ' ');
INSERT INTO answer VALUES (3504, 876, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3506, 877, 0, 'Turn off the transmitter and disconnect the feed line', ' ');
INSERT INTO answer VALUES (3505, 877, 1, 'Ensure that you and the antenna structure are grounded', ' ');
INSERT INTO answer VALUES (3507, 877, 2, 'Wear a radiation badge', ' ');
INSERT INTO answer VALUES (3508, 877, 3, 'All these choices are correct', ' ');

INSERT INTO answer VALUES (3509, 878, 0, '18.068 MHz', ' ');
INSERT INTO answer VALUES (3510, 878, 1, '18.100 MHz', ' ');
INSERT INTO answer VALUES (3511, 878, 2, '18.107 MHz', ' ');
INSERT INTO answer VALUES (3512, 878, 3, '18.110 MHz', ' ');
INSERT INTO answer VALUES (3516, 879, 0, '3 kHz above the lower band edge', ' ');
INSERT INTO answer VALUES (3513, 879, 1, 'The exact lower band edge', ' ');
INSERT INTO answer VALUES (3514, 879, 2, '300 Hz above the lower band edge', ' ');
INSERT INTO answer VALUES (3515, 879, 3, '1 kHz above the lower band edge', ' ');
INSERT INTO answer VALUES (3519, 880, 0, '14.149 MHz', ' ');
INSERT INTO answer VALUES (3517, 880, 1, '14.070 MHz', ' ');
INSERT INTO answer VALUES (3518, 880, 2, '14.100 MHz', ' ');
INSERT INTO answer VALUES (3520, 880, 3, '14.349 MHz', ' ');
INSERT INTO answer VALUES (3523, 881, 0, 'No, the sideband will extend beyond the edge of the phone band segment', ' ');
INSERT INTO answer VALUES (3521, 881, 1, 'Yes, because the DX station initiated the contact', ' ');
INSERT INTO answer VALUES (3522, 881, 2, 'Yes, because the displayed frequency is within the 75 meter phone band segment', ' ');
INSERT INTO answer VALUES (3524, 881, 3, 'No, U.S. stations are not permitted to use phone emissions below 3.610 MHz', ' ');
INSERT INTO answer VALUES (3527, 882, 0, '100 watts PEP effective radiated power relative to the gain of a half-wave dipole', ' ');
INSERT INTO answer VALUES (3525, 882, 1, '50 watts PEP effective radiated power relative to an isotropic radiator', ' ');
INSERT INTO answer VALUES (3526, 882, 2, '50 watts PEP effective radiated power relative to a dipole', ' ');
INSERT INTO answer VALUES (3528, 882, 3, '100 watts PEP effective radiated power relative to an isotropic radiator', ' ');
INSERT INTO answer VALUES (3530, 883, 0, 'At the center frequency of the channel', ' ');
INSERT INTO answer VALUES (3529, 883, 1, 'At the lowest frequency of the channel', ' ');
INSERT INTO answer VALUES (3531, 883, 2, 'At the highest frequency of the channel', ' ');
INSERT INTO answer VALUES (3532, 883, 3, 'On any frequency where the signal''s sidebands are within the channel', ' ');
INSERT INTO answer VALUES (3535, 884, 0, '1 watt EIRP (Equivalent isotropic radiated power)', ' ');
INSERT INTO answer VALUES (3533, 884, 1, '50 watts PEP', ' ');
INSERT INTO answer VALUES (3534, 884, 2, '100 watts PEP', ' ');
INSERT INTO answer VALUES (3536, 884, 3, '5 watts EIRP (Equivalent isotropic radiated power)', ' ');
INSERT INTO answer VALUES (3538, 885, 0, 'The control operator of the originating station', ' ');
INSERT INTO answer VALUES (3537, 885, 1, 'The control operator of the packet bulletin board station', ' ');
INSERT INTO answer VALUES (3539, 885, 2, 'The control operators of all the stations in the system', ' ');
INSERT INTO answer VALUES (3540, 885, 3, 'The control operators of all the stations in the system not authenticating the source from which they accept communications', ' ');
INSERT INTO answer VALUES (3541, 886, 0, 'Discontinue forwarding the communication as soon as you become aware of it', ' ');
INSERT INTO answer VALUES (3542, 886, 1, 'Notify the originating station that the communication does not comply with FCC rules', ' ');
INSERT INTO answer VALUES (3543, 886, 2, 'Notify the nearest FCC Field Engineers office', ' ');
INSERT INTO answer VALUES (3544, 886, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3545, 887, 0, 'Its operation must be approved by the master of the ship or the pilot in command of the aircraft', ' ');
INSERT INTO answer VALUES (3546, 887, 1, 'The amateur station operator must agree not to transmit when the main radio of the ship or aircraft is in use', ' ');
INSERT INTO answer VALUES (3547, 887, 2, 'The amateur station must have a power supply that is completely independent of the main ship or aircraft power supply', ' ');
INSERT INTO answer VALUES (3548, 887, 3, 'The amateur operator must have an FCC Marine or Aircraft endorsement on his or her amateur license', ' ');
INSERT INTO answer VALUES (3550, 888, 0, 'Any FCC-issued amateur license', ' ');
INSERT INTO answer VALUES (3549, 888, 1, 'Any amateur license with an FCC Marine or Aircraft endorsement', ' ');
INSERT INTO answer VALUES (3551, 888, 2, 'Only General Class or higher amateur licenses', ' ');
INSERT INTO answer VALUES (3552, 888, 3, 'An unrestricted Radiotelephone Operator Permit', ' ');
INSERT INTO answer VALUES (3555, 889, 0, 'They are restricted to phone band segments', ' ');
INSERT INTO answer VALUES (3553, 889, 1, 'None; they are allowed on all amateur frequencies', ' ');
INSERT INTO answer VALUES (3554, 889, 2, 'They are restricted to 7.245 MHz, 14.245 MHz, 21.345 MHz, and 28.945 MHz', ' ');
INSERT INTO answer VALUES (3556, 889, 3, 'They are not permitted above 54 MHz', ' ');
INSERT INTO answer VALUES (3558, 890, 0, 'Any person holding an FCC issued amateur license or who is authorized for alien reciprocal operation', ' ');
INSERT INTO answer VALUES (3557, 890, 1, 'Only a person with an FCC Marine Radio license grant', ' ');
INSERT INTO answer VALUES (3559, 890, 2, 'Only a person named in an amateur station license grant', ' ');
INSERT INTO answer VALUES (3560, 890, 3, 'Any person named in an amateur station license grant or a person holding an unrestricted Radiotelephone Operator Permit', ' ');
INSERT INTO answer VALUES (3564, 891, 0, '5 watts EIRP', ' ');
INSERT INTO answer VALUES (3561, 891, 1, '50 watts PEP', ' ');
INSERT INTO answer VALUES (3562, 891, 2, '100 watts PEP', ' ');
INSERT INTO answer VALUES (3563, 891, 3, '1 watt EIRP', ' ');
INSERT INTO answer VALUES (3568, 892, 0, 'An emission outside the signal''s necessary bandwidth that can be reduced or eliminated without affecting the information transmitted', ' ');
INSERT INTO answer VALUES (3565, 892, 1, 'An amateur station transmission made without the proper call sign identification', ' ');
INSERT INTO answer VALUES (3566, 892, 2, 'A signal transmitted to prevent its detection by any station other than the intended recipient', ' ');
INSERT INTO answer VALUES (3567, 892, 3, 'Any transmitted signal that unintentionally interferes with another licensed radio station', ' ');
INSERT INTO answer VALUES (3569, 893, 0, '3 kHz', ' ');
INSERT INTO answer VALUES (3570, 893, 1, '10 kHz', ' ');
INSERT INTO answer VALUES (3571, 893, 2, '15 kHz', ' ');
INSERT INTO answer VALUES (3572, 893, 3, '20 kHz', ' ');
INSERT INTO answer VALUES (3573, 894, 0, '1 mile', ' ');
INSERT INTO answer VALUES (3574, 894, 1, '3 miles', ' ');
INSERT INTO answer VALUES (3575, 894, 2, '10 miles', ' ');
INSERT INTO answer VALUES (3576, 894, 3, '30 miles', ' ');
INSERT INTO answer VALUES (3579, 895, 0, 'An Environmental Assessment must be submitted to the FCC', ' ');
INSERT INTO answer VALUES (3577, 895, 1, 'A proposal must be submitted to the National Park Service', ' ');
INSERT INTO answer VALUES (3578, 895, 2, 'A letter of intent must be filed with the Environmental Protection Agency', ' ');
INSERT INTO answer VALUES (3580, 895, 3, 'A form FSD-15 must be submitted to the Department of the Interior', ' ');
INSERT INTO answer VALUES (3583, 896, 0, 'An area surrounding the National Radio Astronomy Observatory', ' ');
INSERT INTO answer VALUES (3581, 896, 1, 'An area in Puerto Rico surrounding the Arecibo Radio Telescope', ' ');
INSERT INTO answer VALUES (3582, 896, 2, 'An area in New Mexico surrounding the White Sands Test Area', ' ');
INSERT INTO answer VALUES (3584, 896, 3, 'An area in Florida surrounding Cape Canaveral', ' ');
INSERT INTO answer VALUES (3585, 897, 0, 'You may have to notify the Federal Aviation Administration and register it with the FCC as required by Part 17 of the FCC rules', ' ');
INSERT INTO answer VALUES (3586, 897, 1, 'You must submit engineering drawings to the FAA', ' ');
INSERT INTO answer VALUES (3587, 897, 2, 'You must file an Environmental Impact Statement with the EPA before construction begins', ' ');
INSERT INTO answer VALUES (3588, 897, 3, 'You must obtain a construction permit from the airport zoning authority', ' ');
INSERT INTO answer VALUES (3591, 898, 0, 'State and local zoning', ' ');
INSERT INTO answer VALUES (3589, 898, 1, 'Homeowners associations', ' ');
INSERT INTO answer VALUES (3590, 898, 2, 'FAA tower height limits', ' ');
INSERT INTO answer VALUES (3592, 898, 3, 'Use of wireless devices in vehicles', ' ');
INSERT INTO answer VALUES (3596, 899, 0, 'The amateur station must avoid transmitting during certain hours on frequencies that cause the interference', ' ');
INSERT INTO answer VALUES (3593, 899, 1, 'The amateur station must cease operation', ' ');
INSERT INTO answer VALUES (3594, 899, 2, 'The amateur station must cease operation on all frequencies below 30 MHz', ' ');
INSERT INTO answer VALUES (3595, 899, 3, 'The amateur station must cease operation on all frequencies above 30 MHz', ' ');
INSERT INTO answer VALUES (3599, 900, 0, 'Any FCC-licensed amateur station certified by the responsible civil defense organization for the area served', ' ');
INSERT INTO answer VALUES (3597, 900, 1, 'Only those club stations licensed to Amateur Extra Class operators', ' ');
INSERT INTO answer VALUES (3598, 900, 2, 'Any FCC-licensed amateur station except a Technician Class', ' ');
INSERT INTO answer VALUES (3600, 900, 3, 'Any FCC-licensed amateur station participating in the Military Auxiliary Radio System (MARS)', ' ');
INSERT INTO answer VALUES (3601, 901, 0, 'All amateur service frequencies authorized to the control operator', ' ');
INSERT INTO answer VALUES (3602, 901, 1, 'Specific segments in the amateur service MF, HF, VHF and UHF bands', ' ');
INSERT INTO answer VALUES (3603, 901, 2, 'Specific local government channels', ' ');
INSERT INTO answer VALUES (3604, 901, 3, 'Military Auxiliary Radio System (MARS) channels', ' ');
INSERT INTO answer VALUES (3606, 902, 0, 'Reasonable accommodations of amateur radio must be made', ' ');
INSERT INTO answer VALUES (3605, 902, 1, 'No limitations may be placed on antenna size or placement', ' ');
INSERT INTO answer VALUES (3607, 902, 2, 'Amateur radio operations must be permitted in any private residence', ' ');
INSERT INTO answer VALUES (3608, 902, 3, 'Use of wireless devices in a vehicle is exempt from regulation', ' ');
INSERT INTO answer VALUES (3609, 903, 0, 'Cease operation or make changes to the repeater to mitigate the interference', ' ');
INSERT INTO answer VALUES (3610, 903, 1, 'File an FAA NOTAM (Notice to Airmen) with the repeater system''s ERP, call sign, and six-character grid locator', ' ');
INSERT INTO answer VALUES (3611, 903, 2, 'Reduce the repeater antenna HAAT (Height Above Average Terrain)', ' ');
INSERT INTO answer VALUES (3612, 903, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3616, 904, 0, '2.8 kHz', ' ');
INSERT INTO answer VALUES (3613, 904, 1, '60 Hz', ' ');
INSERT INTO answer VALUES (3614, 904, 2, '170 Hz', ' ');
INSERT INTO answer VALUES (3615, 904, 3, '1.5 kHz', ' ');
INSERT INTO answer VALUES (3619, 905, 0, 'Communications incidental to the purpose of the amateur service and remarks of a personal nature', ' ');
INSERT INTO answer VALUES (3617, 905, 1, 'Business-related messages for non-profit organizations', ' ');
INSERT INTO answer VALUES (3618, 905, 2, 'Messages intended for users of the maritime satellite service', ' ');
INSERT INTO answer VALUES (3620, 905, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3622, 906, 0, 'Under automatic control the control operator is not required to be present at the control point', ' ');
INSERT INTO answer VALUES (3621, 906, 1, 'Under local control there is no control operator', ' ');
INSERT INTO answer VALUES (3623, 906, 2, 'Under automatic control there is no control operator', ' ');
INSERT INTO answer VALUES (3624, 906, 3, 'Under local control a control operator is not required to be present at a control point', ' ');
INSERT INTO answer VALUES (3625, 907, 0, 'An international amateur radio permit that allows U.S. amateurs to operate in certain countries of the Americas', ' ');
INSERT INTO answer VALUES (3626, 907, 1, 'The internal amateur radio practices policy of the FCC', ' ');
INSERT INTO answer VALUES (3627, 907, 2, 'An indication of increased antenna reflected power', ' ');
INSERT INTO answer VALUES (3628, 907, 3, 'A forecast of intermittent aurora radio propagation', ' ');
INSERT INTO answer VALUES (3629, 908, 0, 'Never', ' ');
INSERT INTO answer VALUES (3630, 908, 1, 'Only when transmitting RTTY or data emissions', ' ');
INSERT INTO answer VALUES (3631, 908, 2, 'When agreed upon by the sending or receiving station', ' ');
INSERT INTO answer VALUES (3632, 908, 3, 'When approved by the National Telecommunication and Information Administration', ' ');
INSERT INTO answer VALUES (3635, 909, 0, 'You must bring a copy of FCC Public Notice DA 16-1048', ' ');
INSERT INTO answer VALUES (3633, 909, 1, 'You must identify in the official language of the country in which you are operating', ' ');
INSERT INTO answer VALUES (3634, 909, 2, 'The U.S. embassy must approve of your operation', ' ');
INSERT INTO answer VALUES (3636, 909, 3, 'You must append "/CEPT" to your call sign', ' ');
INSERT INTO answer VALUES (3640, 910, 0, '26 dB', ' ');
INSERT INTO answer VALUES (3637, 910, 1, '3 dB', ' ');
INSERT INTO answer VALUES (3638, 910, 2, '6 dB', ' ');
INSERT INTO answer VALUES (3639, 910, 3, '23 dB', ' ');
INSERT INTO answer VALUES (3642, 911, 0, '3 minutes', ' ');
INSERT INTO answer VALUES (3641, 911, 1, '30 seconds', ' ');
INSERT INTO answer VALUES (3643, 911, 2, '5 minutes', ' ');
INSERT INTO answer VALUES (3644, 911, 3, '10 minutes', ' ');
INSERT INTO answer VALUES (3646, 912, 0, '1.0', ' ');
INSERT INTO answer VALUES (3645, 912, 1, '0.5', ' ');
INSERT INTO answer VALUES (3647, 912, 2, '2.0', ' ');
INSERT INTO answer VALUES (3648, 912, 3, '3.0', ' ');
INSERT INTO answer VALUES (3649, 913, 0, 'At least 43 dB below', ' ');
INSERT INTO answer VALUES (3650, 913, 1, 'At least 53 dB below', ' ');
INSERT INTO answer VALUES (3651, 913, 2, 'At least 63 dB below', ' ');
INSERT INTO answer VALUES (3652, 913, 3, 'At least 73 dB below', ' ');
INSERT INTO answer VALUES (3653, 914, 0, 'CEPT agreement', ' ');
INSERT INTO answer VALUES (3654, 914, 1, 'IARP agreement', ' ');
INSERT INTO answer VALUES (3655, 914, 2, 'ITU reciprocal license', ' ');
INSERT INTO answer VALUES (3656, 914, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3660, 915, 0, 'The entire band', ' ');
INSERT INTO answer VALUES (3657, 915, 1, 'None', ' ');
INSERT INTO answer VALUES (3658, 915, 2, 'Only the top 3 kHz', ' ');
INSERT INTO answer VALUES (3659, 915, 3, 'Only the bottom 3 kHz', ' ');
INSERT INTO answer VALUES (3663, 916, 0, 'Operators must inform the Utilities Telecom Council of their call sign and coordinates of the station', ' ');
INSERT INTO answer VALUES (3661, 916, 1, 'A special endorsement must be requested from the FCC', ' ');
INSERT INTO answer VALUES (3662, 916, 2, 'An environmental impact statement must be filed with the Department of the Interior', ' ');
INSERT INTO answer VALUES (3664, 916, 3, 'Operators must inform the FAA of their intent to operate, giving their call sign and distance to the nearest runway', ' ');
INSERT INTO answer VALUES (3666, 917, 0, 'Operators may operate after 30 days, providing they have not been told that their station is within 1 km of PLC systems using those frequencies', ' ');
INSERT INTO answer VALUES (3665, 917, 1, 'Operators must not operate until approval is received', ' ');
INSERT INTO answer VALUES (3667, 917, 2, 'Operators may not operate until a test signal has been transmitted in coordination with the local power company', ' ');
INSERT INTO answer VALUES (3668, 917, 3, 'Operations may commence immediately, and may continue unless interference is reported by the UTC', ' ');
INSERT INTO answer VALUES (3669, 918, 0, 'One-way transmission of measurements at a distance from the measuring instrument', ' ');
INSERT INTO answer VALUES (3670, 918, 1, 'Two-way transmissions in excess of 1000 feet', ' ');
INSERT INTO answer VALUES (3671, 918, 2, 'Two-way transmissions of data', ' ');
INSERT INTO answer VALUES (3672, 918, 3, 'One-way transmission that initiates, modifies, or terminates the functions of a device at a distance', ' ');
INSERT INTO answer VALUES (3673, 919, 0, 'Telecommand signals from a space telecommand station', ' ');
INSERT INTO answer VALUES (3674, 919, 1, 'Data containing personal information', ' ');
INSERT INTO answer VALUES (3675, 919, 2, 'Auxiliary relay links carrying repeater audio', ' ');
INSERT INTO answer VALUES (3676, 919, 3, 'Binary control characters', ' ');
INSERT INTO answer VALUES (3678, 920, 0, 'An amateur station that transmits communications to initiate, modify or terminate functions of a space station', ' ');
INSERT INTO answer VALUES (3677, 920, 1, 'An amateur station located on the surface of the Earth for communication with other Earth stations by means of Earth satellites', ' ');
INSERT INTO answer VALUES (3679, 920, 2, 'An amateur station located in a satellite or a balloon more than 50 kilometers above the surface of the earth', ' ');
INSERT INTO answer VALUES (3680, 920, 3, 'An amateur station that receives telemetry from a satellite or balloon more than 50 kilometers above the surface of the earth', ' ');
INSERT INTO answer VALUES (3681, 921, 0, 'Call sign', ' ');
INSERT INTO answer VALUES (3682, 921, 1, 'The output power of the balloon transmitter', ' ');
INSERT INTO answer VALUES (3683, 921, 2, 'The station''s six-character Maidenhead grid locator', ' ');
INSERT INTO answer VALUES (3684, 921, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3688, 922, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3685, 922, 1, 'A photocopy of the station license', ' ');
INSERT INTO answer VALUES (3686, 922, 2, 'A label with the name, address, and telephone number of the station licensee', ' ');
INSERT INTO answer VALUES (3687, 922, 3, 'A label with the name, address, and telephone number of the control operator', ' ');
INSERT INTO answer VALUES (3689, 923, 0, '1 watt', ' ');
INSERT INTO answer VALUES (3690, 923, 1, '2 watts', ' ');
INSERT INTO answer VALUES (3691, 923, 2, '5 watts', ' ');
INSERT INTO answer VALUES (3692, 923, 3, '100 watts', ' ');
INSERT INTO answer VALUES (3693, 924, 0, 'Only the 40, 20, 17, 15, 12, and 10 meter bands', ' ');
INSERT INTO answer VALUES (3694, 924, 1, 'Only the 40, 20, 17, 15, and 10 meter bands', ' ');
INSERT INTO answer VALUES (3695, 924, 2, 'Only the 40, 30, 20, 15, 12, and 10 meter bands', ' ');
INSERT INTO answer VALUES (3696, 924, 3, 'All HF bands', ' ');
INSERT INTO answer VALUES (3700, 925, 0, '2 meters', ' ');
INSERT INTO answer VALUES (3697, 925, 1, '6 meters and 2 meters', ' ');
INSERT INTO answer VALUES (3698, 925, 2, '6 meters, 2 meters, and 1.25 meters', ' ');
INSERT INTO answer VALUES (3699, 925, 3, '2 meters and 1.25 meters', ' ');
INSERT INTO answer VALUES (3702, 926, 0, '70 cm and 13 cm', ' ');
INSERT INTO answer VALUES (3701, 926, 1, '70 cm only', ' ');
INSERT INTO answer VALUES (3703, 926, 2, '70 cm and 33 cm', ' ');
INSERT INTO answer VALUES (3704, 926, 3, '33 cm and 13 cm', ' ');
INSERT INTO answer VALUES (3706, 927, 0, 'Any amateur station so designated by the space station licensee', ' ');
INSERT INTO answer VALUES (3705, 927, 1, 'Any amateur station designated by NASA', ' ');
INSERT INTO answer VALUES (3707, 927, 2, 'Any amateur station so designated by the ITU', ' ');
INSERT INTO answer VALUES (3708, 927, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3712, 928, 0, 'Any amateur station, subject to the privileges of the class of operator license held by the control operator', ' ');
INSERT INTO answer VALUES (3709, 928, 1, 'Any amateur station whose licensee has filed a pre-space notification with the FCC''s International Bureau', ' ');
INSERT INTO answer VALUES (3710, 928, 2, 'Only those of General, Advanced or Amateur Extra Class operators', ' ');
INSERT INTO answer VALUES (3711, 928, 3, 'Only those of Amateur Extra Class operators', ' ');
INSERT INTO answer VALUES (3713, 929, 0, 'A space station, beacon station, or telecommand station', ' ');
INSERT INTO answer VALUES (3714, 929, 1, 'A local repeater or linked repeater station', ' ');
INSERT INTO answer VALUES (3715, 929, 2, 'A message forwarding station or automatically controlled digital station', ' ');
INSERT INTO answer VALUES (3716, 929, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3717, 930, 0, 'Preparing, processing, administering, and coordinating an examination for an amateur radio operator license', ' ');
INSERT INTO answer VALUES (3718, 930, 1, 'Teaching an amateur operator license examination preparation course', ' ');
INSERT INTO answer VALUES (3719, 930, 2, 'No expenses are authorized for reimbursement', ' ');
INSERT INTO answer VALUES (3720, 930, 3, 'Providing amateur operator license examination preparation training materials', ' ');
INSERT INTO answer VALUES (3723, 931, 0, 'The VECs', ' ');
INSERT INTO answer VALUES (3721, 931, 1, 'The VEs', ' ');
INSERT INTO answer VALUES (3722, 931, 2, 'The FCC', ' ');
INSERT INTO answer VALUES (3724, 931, 3, 'The ARRL', ' ');
INSERT INTO answer VALUES (3727, 932, 0, 'An organization that has entered into an agreement with the FCC to coordinate, prepare, and administer amateur operator license examinations', ' ');
INSERT INTO answer VALUES (3725, 932, 1, 'A person who has volunteered to administer amateur operator license examinations', ' ');
INSERT INTO answer VALUES (3726, 932, 2, 'A person who has volunteered to prepare amateur operator license examinations', ' ');
INSERT INTO answer VALUES (3728, 932, 3, 'The person who has entered into an agreement with the FCC to be the VE session manager', ' ');
INSERT INTO answer VALUES (3732, 933, 0, 'The procedure by which a VEC confirms that the VE applicant meets FCC requirements to serve as an examiner', ' ');
INSERT INTO answer VALUES (3729, 933, 1, 'Each General, Advanced and Amateur Extra Class operator is automatically accredited as a VE when the license is granted', ' ');
INSERT INTO answer VALUES (3730, 933, 2, 'The amateur operator applying must pass a VE examination administered by the FCC Enforcement Bureau', ' ');
INSERT INTO answer VALUES (3731, 933, 3, 'The prospective VE obtains accreditation from the FCC', ' ');
INSERT INTO answer VALUES (3734, 934, 0, 'Minimum passing score of 74%', ' ');
INSERT INTO answer VALUES (3733, 934, 1, 'Minimum passing score of 70%', ' ');
INSERT INTO answer VALUES (3735, 934, 2, 'Minimum passing score of 80%', ' ');
INSERT INTO answer VALUES (3736, 934, 3, 'Minimum passing score of 77%', ' ');
INSERT INTO answer VALUES (3739, 935, 0, 'Each administering VE', ' ');
INSERT INTO answer VALUES (3737, 935, 1, 'The VEC coordinating the session', ' ');
INSERT INTO answer VALUES (3738, 935, 2, 'The FCC', ' ');
INSERT INTO answer VALUES (3740, 935, 3, 'The VE session manager', ' ');
INSERT INTO answer VALUES (3742, 936, 0, 'Immediately terminate the candidate''s examination', ' ');
INSERT INTO answer VALUES (3741, 936, 1, 'Warn the candidate that continued failure to comply will result in termination of the examination', ' ');
INSERT INTO answer VALUES (3743, 936, 2, 'Allow the candidate to complete the examination, but invalidate the results', ' ');
INSERT INTO answer VALUES (3744, 936, 3, 'Immediately terminate everyone''s examination and close the session', ' ');
INSERT INTO answer VALUES (3747, 937, 0, 'Relatives of the VE as listed in the FCC rules', ' ');
INSERT INTO answer VALUES (3745, 937, 1, 'Employees of the VE', ' ');
INSERT INTO answer VALUES (3746, 937, 2, 'Friends of the VE', ' ');
INSERT INTO answer VALUES (3748, 937, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3749, 938, 0, 'Revocation of the VE''s amateur station license grant and the suspension of the VE''s amateur operator license grant', ' ');
INSERT INTO answer VALUES (3750, 938, 1, 'A fine of up to $1000 per occurrence', ' ');
INSERT INTO answer VALUES (3751, 938, 2, 'A sentence of up to one year in prison', ' ');
INSERT INTO answer VALUES (3752, 938, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3755, 939, 0, 'They must submit the application document to the coordinating VEC according to the coordinating VEC instructions', ' ');
INSERT INTO answer VALUES (3753, 939, 1, 'They must collect and send the documents to the NCVEC for grading', ' ');
INSERT INTO answer VALUES (3754, 939, 2, 'They must collect and submit the documents to the coordinating VEC for grading', ' ');
INSERT INTO answer VALUES (3756, 939, 3, 'They must collect and send the documents to the FCC according to instructions', ' ');
INSERT INTO answer VALUES (3758, 940, 0, 'Three VEs must certify that the examinee is qualified for the license grant and that they have complied with the administering VE requirements', ' ');
INSERT INTO answer VALUES (3757, 940, 1, 'Photocopy all examination documents and forward them to the FCC for processing', ' ');
INSERT INTO answer VALUES (3759, 940, 2, 'Issue the examinee the new or upgrade license', ' ');
INSERT INTO answer VALUES (3760, 940, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3761, 941, 0, 'Return the application document to the examinee', ' ');
INSERT INTO answer VALUES (3762, 941, 1, 'Maintain the application form with the VEC''s records', ' ');
INSERT INTO answer VALUES (3763, 941, 2, 'Send the application form to the FCC and inform the FCC of the grade', ' ');
INSERT INTO answer VALUES (3764, 941, 3, 'Destroy the application form', ' ');
INSERT INTO answer VALUES (3766, 942, 0, 'Only on amateur frequencies above 222 MHz', ' ');
INSERT INTO answer VALUES (3765, 942, 1, 'Only on amateur frequencies above 50 MHz', ' ');
INSERT INTO answer VALUES (3767, 942, 2, 'Only on amateur frequencies above 420 MHz', ' ');
INSERT INTO answer VALUES (3768, 942, 3, 'Only on amateur frequencies above 144 MHz', ' ');
INSERT INTO answer VALUES (3771, 943, 0, 'The operating terms and conditions of the Canadian amateur service license, not to exceed U.S. Amateur Extra Class license privileges', ' ');
INSERT INTO answer VALUES (3769, 943, 1, 'None, they must obtain a U.S. license', ' ');
INSERT INTO answer VALUES (3770, 943, 2, 'All privileges of the Amateur Extra Class license', ' ');
INSERT INTO answer VALUES (3772, 943, 3, 'Full privileges, up to and including those of the Amateur Extra Class license, on the 80, 40, 20, 15, and 10 meter bands', ' ');
INSERT INTO answer VALUES (3773, 944, 0, 'It was purchased in used condition from an amateur operator and is sold to another amateur operator for use at that operator''s station', ' ');
INSERT INTO answer VALUES (3774, 944, 1, 'The equipment dealer assembled it from a kit', ' ');
INSERT INTO answer VALUES (3775, 944, 2, 'It was imported from a manufacturer in a country that does not require certification of RF power amplifiers', ' ');
INSERT INTO answer VALUES (3776, 944, 3, 'It was imported from a manufacturer in another country and was certificated by that country''s government', ' ');
INSERT INTO answer VALUES (3777, 945, 0, 'A line roughly parallel to and south of the border between the U.S. and Canada', ' ');
INSERT INTO answer VALUES (3778, 945, 1, 'A line roughly parallel to and west of the U.S. Atlantic coastline', ' ');
INSERT INTO answer VALUES (3779, 945, 2, 'A line roughly parallel to and north of the border between the U.S. and Mexico', ' ');
INSERT INTO answer VALUES (3780, 945, 3, 'A line roughly parallel to and east of the U.S. Pacific coastline', ' ');
INSERT INTO answer VALUES (3784, 946, 0, '420 MHz - 430 MHz', ' ');
INSERT INTO answer VALUES (3781, 946, 1, '440 MHz - 450 MHz', ' ');
INSERT INTO answer VALUES (3782, 946, 2, '53 MHz - 54 MHz', ' ');
INSERT INTO answer VALUES (3783, 946, 3, '222 MHz - 223 MHz', ' ');
INSERT INTO answer VALUES (3785, 947, 0, 'To provide for experimental amateur communications', ' ');
INSERT INTO answer VALUES (3786, 947, 1, 'To allow regular operation on Land Mobile channels', ' ');
INSERT INTO answer VALUES (3787, 947, 2, 'To provide additional spectrum for personal use', ' ');
INSERT INTO answer VALUES (3788, 947, 3, 'To provide temporary operation while awaiting normal licensing', ' ');
INSERT INTO answer VALUES (3792, 948, 0, 'When neither the amateur nor his or her employer has a pecuniary interest in the communications', ' ');
INSERT INTO answer VALUES (3789, 948, 1, 'When the total money involved does not exceed $25', ' ');
INSERT INTO answer VALUES (3790, 948, 2, 'When the control operator is employed by the FCC or another government agency', ' ');
INSERT INTO answer VALUES (3791, 948, 3, 'When transmitting international third-party communications', ' ');
INSERT INTO answer VALUES (3793, 949, 0, 'Communications transmitted for hire or material compensation, except as otherwise provided in the rules', ' ');
INSERT INTO answer VALUES (3794, 949, 1, 'Communications that have political content, except as allowed by the Fairness Doctrine', ' ');
INSERT INTO answer VALUES (3795, 949, 2, 'Communications that have religious content', ' ');
INSERT INTO answer VALUES (3796, 949, 3, 'Communications in a language other than English', ' ');
INSERT INTO answer VALUES (3800, 950, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3797, 950, 1, 'A station transmitting SS emission must not cause harmful interference to other stations employing other authorized emissions', ' ');
INSERT INTO answer VALUES (3798, 950, 2, 'The transmitting station must be in an area regulated by the FCC or in a country that permits SS emissions', ' ');
INSERT INTO answer VALUES (3799, 950, 3, 'The transmission must not be used to obscure the meaning of any communication', ' ');
INSERT INTO answer VALUES (3802, 951, 0, 'Only Technician, General, Advanced or Amateur Extra Class operators', ' ');
INSERT INTO answer VALUES (3801, 951, 1, 'Any licensed amateur operator', ' ');
INSERT INTO answer VALUES (3803, 951, 2, 'Only General, Advanced or Amateur Extra Class operators', ' ');
INSERT INTO answer VALUES (3804, 951, 3, 'Only Amateur Extra Class operators', ' ');
INSERT INTO answer VALUES (3808, 952, 0, 'It must satisfy the FCC''s spurious emission standards when operated at the lesser of 1500 watts or its full output power', ' ');
INSERT INTO answer VALUES (3805, 952, 1, 'It must produce full legal output when driven by not more than 5 watts of mean RF input power', ' ');
INSERT INTO answer VALUES (3806, 952, 2, 'It must be capable of external RF switching between its input and output networks', ' ');
INSERT INTO answer VALUES (3807, 952, 3, 'It must exhibit a gain of 0 dB or less over its full output range', ' ');
INSERT INTO answer VALUES (3811, 953, 0, 'From south to north', ' ');
INSERT INTO answer VALUES (3809, 953, 1, 'From west to east', ' ');
INSERT INTO answer VALUES (3810, 953, 2, 'From east to west', ' ');
INSERT INTO answer VALUES (3812, 953, 3, 'From north to south', ' ');
INSERT INTO answer VALUES (3816, 954, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3813, 954, 1, 'Doppler shift is reduced because the uplink and downlink shifts are in opposite directions', ' ');
INSERT INTO answer VALUES (3814, 954, 2, 'Signal position in the band is reversed', ' ');
INSERT INTO answer VALUES (3815, 954, 3, 'Upper sideband on the uplink becomes lower sideband on the downlink, and vice versa', ' ');
INSERT INTO answer VALUES (3820, 955, 0, 'The signal is passed through a mixer and the difference rather than the sum is transmitted', ' ');
INSERT INTO answer VALUES (3817, 955, 1, 'The signal is detected and remodulated on the reverse sideband', ' ');
INSERT INTO answer VALUES (3818, 955, 2, 'The signal is passed through a non-linear filter', ' ');
INSERT INTO answer VALUES (3819, 955, 3, 'The signal is reduced to I and Q components and the Q component is filtered out', ' ');
INSERT INTO answer VALUES (3822, 956, 0, 'The satellite''s uplink and downlink frequency bands', ' ');
INSERT INTO answer VALUES (3821, 956, 1, 'Whether the satellite is in a low earth or geostationary orbit', ' ');
INSERT INTO answer VALUES (3823, 956, 2, 'The satellite''s orientation with respect to the Earth', ' ');
INSERT INTO answer VALUES (3824, 956, 3, 'Whether the satellite is in a polar or equatorial orbit', ' ');
INSERT INTO answer VALUES (3828, 957, 0, 'The uplink and downlink frequency ranges', ' ');
INSERT INTO answer VALUES (3825, 957, 1, 'Power limits for uplink and downlink transmissions', ' ');
INSERT INTO answer VALUES (3826, 957, 2, 'The location of the ground control station', ' ');
INSERT INTO answer VALUES (3827, 957, 3, 'The polarization of uplink and downlink signals', ' ');
INSERT INTO answer VALUES (3829, 958, 0, 'Parameters that define the orbit of a satellite', ' ');
INSERT INTO answer VALUES (3830, 958, 1, 'Phase reversing elements in a Yagi antenna', ' ');
INSERT INTO answer VALUES (3831, 958, 2, 'High-emission heater filaments used in magnetron tubes', ' ');
INSERT INTO answer VALUES (3832, 958, 3, 'Encrypting codes used for spread spectrum modulation', ' ');
INSERT INTO answer VALUES (3836, 959, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3833, 959, 1, 'FM and CW', ' ');
INSERT INTO answer VALUES (3834, 959, 2, 'SSB and SSTV', ' ');
INSERT INTO answer VALUES (3835, 959, 3, 'PSK and packet', ' ');
INSERT INTO answer VALUES (3838, 960, 0, 'To avoid reducing the downlink power to all other users', ' ');
INSERT INTO answer VALUES (3837, 960, 1, 'To prevent creating errors in the satellite telemetry', ' ');
INSERT INTO answer VALUES (3839, 960, 2, 'To prevent the satellite from emitting out-of-band signals', ' ');
INSERT INTO answer VALUES (3840, 960, 3, 'To avoid interfering with terrestrial QSOs', ' ');
INSERT INTO answer VALUES (3841, 961, 0, 'The 23 centimeter and 13 centimeter bands', ' ');
INSERT INTO answer VALUES (3842, 961, 1, 'The 2 meter and 70 centimeter bands', ' ');
INSERT INTO answer VALUES (3843, 961, 2, 'FM and Digital Store-and-Forward systems', ' ');
INSERT INTO answer VALUES (3844, 961, 3, 'Which sideband to use', ' ');
INSERT INTO answer VALUES (3846, 962, 0, 'Geostationary', ' ');
INSERT INTO answer VALUES (3845, 962, 1, 'HEO', ' ');
INSERT INTO answer VALUES (3847, 962, 2, 'Geomagnetic', ' ');
INSERT INTO answer VALUES (3848, 962, 3, 'LEO', ' ');
INSERT INTO answer VALUES (3850, 963, 0, 'A circularly polarized antenna', ' ');
INSERT INTO answer VALUES (3849, 963, 1, 'A linearly polarized antenna', ' ');
INSERT INTO answer VALUES (3851, 963, 2, 'An isotropic antenna', ' ');
INSERT INTO answer VALUES (3852, 963, 3, 'A log-periodic dipole array', ' ');
INSERT INTO answer VALUES (3855, 964, 0, 'To store digital messages in the satellite for later download by other stations', ' ');
INSERT INTO answer VALUES (3853, 964, 1, 'To upload operational software for the transponder', ' ');
INSERT INTO answer VALUES (3854, 964, 2, 'To delay download of telemetry between satellites', ' ');
INSERT INTO answer VALUES (3856, 964, 3, 'To relay messages between satellites', ' ');
INSERT INTO answer VALUES (3858, 965, 0, 'Store-and-forward', ' ');
INSERT INTO answer VALUES (3857, 965, 1, 'Digipeating', ' ');
INSERT INTO answer VALUES (3859, 965, 2, 'Multi-satellite relaying', ' ');
INSERT INTO answer VALUES (3860, 965, 3, 'Node hopping', ' ');
INSERT INTO answer VALUES (3861, 966, 0, '30', ' ');
INSERT INTO answer VALUES (3862, 966, 1, '60', ' ');
INSERT INTO answer VALUES (3863, 966, 2, '90', ' ');
INSERT INTO answer VALUES (3864, 966, 3, '120', ' ');
INSERT INTO answer VALUES (3867, 967, 0, '525', ' ');
INSERT INTO answer VALUES (3865, 967, 1, '30', ' ');
INSERT INTO answer VALUES (3866, 967, 2, '60', ' ');
INSERT INTO answer VALUES (3868, 967, 3, '1080', ' ');
INSERT INTO answer VALUES (3872, 968, 0, 'By scanning odd numbered lines in one field and even numbered lines in the next', ' ');
INSERT INTO answer VALUES (3869, 968, 1, 'By scanning two fields simultaneously', ' ');
INSERT INTO answer VALUES (3870, 968, 2, 'By scanning each field from bottom to top', ' ');
INSERT INTO answer VALUES (3871, 968, 3, 'By scanning lines from left to right in one field and right to left in the next', ' ');
INSERT INTO answer VALUES (3873, 969, 0, 'Color lines are sent sequentially', ' ');
INSERT INTO answer VALUES (3874, 969, 1, 'Color information is sent on a 2.8 kHz subcarrier', ' ');
INSERT INTO answer VALUES (3875, 969, 2, 'Color is sent in a color burst at the end of each line', ' ');
INSERT INTO answer VALUES (3876, 969, 3, 'Color is amplitude modulated on the frequency modulated intensity signal', ' ');
INSERT INTO answer VALUES (3879, 970, 0, 'Vestigial sideband reduces bandwidth while allowing for simple video detector circuitry', ' ');
INSERT INTO answer VALUES (3877, 970, 1, 'The vestigial sideband carries the audio information', ' ');
INSERT INTO answer VALUES (3878, 970, 2, 'The vestigial sideband contains chroma information', ' ');
INSERT INTO answer VALUES (3880, 970, 3, 'Vestigial sideband provides high frequency emphasis to sharpen the picture', ' ');
INSERT INTO answer VALUES (3881, 971, 0, 'Amplitude modulation in which one complete sideband and a portion of the other are transmitted', ' ');
INSERT INTO answer VALUES (3882, 971, 1, 'A type of modulation in which one sideband is inverted', ' ');
INSERT INTO answer VALUES (3883, 971, 2, 'Narrow-band FM modulation achieved by filtering one sideband from the audio before frequency modulating the carrier', ' ');
INSERT INTO answer VALUES (3884, 971, 3, 'Spread spectrum modulation achieved by applying FM modulation following single sideband amplitude modulation', ' ');
INSERT INTO answer VALUES (3886, 972, 0, 'Chroma', ' ');
INSERT INTO answer VALUES (3885, 972, 1, 'Luminance', ' ');
INSERT INTO answer VALUES (3887, 972, 2, 'Hue', ' ');
INSERT INTO answer VALUES (3888, 972, 3, 'Spectral intensity', ' ');
INSERT INTO answer VALUES (3889, 973, 0, 'Transmitting on channels shared with cable TV', ' ');
INSERT INTO answer VALUES (3890, 973, 1, 'Using converted satellite TV dishes', ' ');
INSERT INTO answer VALUES (3891, 973, 2, 'Transmitting on the abandoned TV channel 2', ' ');
INSERT INTO answer VALUES (3892, 973, 3, 'Using USB and demodulating the signal with a computer sound card', ' ');
INSERT INTO answer VALUES (3896, 974, 0, 'No other hardware is needed', ' ');
INSERT INTO answer VALUES (3893, 974, 1, 'A special IF converter', ' ');
INSERT INTO answer VALUES (3894, 974, 2, 'A special front end limiter', ' ');
INSERT INTO answer VALUES (3895, 974, 3, 'A special notch filter to remove synchronization pulses', ' ');
INSERT INTO answer VALUES (3897, 975, 0, 'Tone frequency', ' ');
INSERT INTO answer VALUES (3898, 975, 1, 'Tone amplitude', ' ');
INSERT INTO answer VALUES (3899, 975, 2, 'Sync amplitude', ' ');
INSERT INTO answer VALUES (3900, 975, 3, 'Sync frequency', ' ');
INSERT INTO answer VALUES (3902, 976, 0, 'To identify the SSTV mode being used', ' ');
INSERT INTO answer VALUES (3901, 976, 1, 'To lock the color burst oscillator in color SSTV images', ' ');
INSERT INTO answer VALUES (3903, 976, 2, 'To provide vertical synchronization', ' ');
INSERT INTO answer VALUES (3904, 976, 3, 'To identify the call sign of the station transmitting', ' ');
INSERT INTO answer VALUES (3905, 977, 0, 'Specific tone frequencies', ' ');
INSERT INTO answer VALUES (3906, 977, 1, 'Elapsed time', ' ');
INSERT INTO answer VALUES (3907, 977, 2, 'Specific tone amplitudes', ' ');
INSERT INTO answer VALUES (3908, 977, 3, 'A two-tone signal', ' ');
INSERT INTO answer VALUES (3912, 978, 0, 'No additional indicator is required', ' ');
INSERT INTO answer VALUES (3909, 978, 1, '/ followed by the USPS two-letter abbreviation for the state in which the remote station is located', ' ');
INSERT INTO answer VALUES (3910, 978, 2, '/R# where # is the district of the remote station', ' ');
INSERT INTO answer VALUES (3911, 978, 3, '/ followed by the ARRL Section of the remote station', ' ');
INSERT INTO answer VALUES (3913, 979, 0, 'The often-prohibited practice of posting one''s own call sign and frequency on a spotting network', ' ');
INSERT INTO answer VALUES (3914, 979, 1, 'The acceptable practice of manually posting the call signs of stations on a spotting network', ' ');
INSERT INTO answer VALUES (3915, 979, 2, 'A manual technique for rapidly zero beating or tuning to a station''s frequency before calling that station', ' ');
INSERT INTO answer VALUES (3916, 979, 3, 'An automatic method for rapidly zero beating or tuning to a station''s frequency before calling that station', ' ');
INSERT INTO answer VALUES (3917, 980, 0, '30 meters', ' ');
INSERT INTO answer VALUES (3918, 980, 1, '6 meters', ' ');
INSERT INTO answer VALUES (3919, 980, 2, '2 meters', ' ');
INSERT INTO answer VALUES (3920, 980, 3, '33 centimeters', ' ');
INSERT INTO answer VALUES (3922, 981, 0, 'Frequencies shared with various unlicensed wireless data services', ' ');
INSERT INTO answer VALUES (3921, 981, 1, 'HF frequencies where digital communications are permitted', ' ');
INSERT INTO answer VALUES (3923, 981, 2, 'Cable TV channels 41 through 43', ' ');
INSERT INTO answer VALUES (3924, 981, 3, 'The 60 meter band channel centered on 5373 kHz', ' ');
INSERT INTO answer VALUES (3926, 982, 0, 'To handle the receiving and sending of confirmation cards for a DX station', ' ');
INSERT INTO answer VALUES (3925, 982, 1, 'To allocate frequencies for DXpeditions', ' ');
INSERT INTO answer VALUES (3927, 982, 2, 'To run a net to allow many stations to contact a rare DX station', ' ');
INSERT INTO answer VALUES (3928, 982, 3, 'To relay calls to and from a DX station', ' ');
INSERT INTO answer VALUES (3931, 983, 0, 'In the weak signal segment of the band, with most of the activity near the calling frequency', ' ');
INSERT INTO answer VALUES (3929, 983, 1, 'At the top of each band, usually in a segment reserved for contests', ' ');
INSERT INTO answer VALUES (3930, 983, 2, 'In the middle of each band, usually on the national calling frequency', ' ');
INSERT INTO answer VALUES (3932, 983, 3, 'In the middle of the band, usually 25 kHz above the national calling frequency', ' ');
INSERT INTO answer VALUES (3933, 984, 0, 'A standard for submission of electronic contest logs', ' ');
INSERT INTO answer VALUES (3934, 984, 1, 'A method of exchanging information during a contest QSO', ' ');
INSERT INTO answer VALUES (3935, 984, 2, 'The most common set of contest rules', ' ');
INSERT INTO answer VALUES (3936, 984, 3, 'The rules of order for meetings between contest sponsors', ' ');
INSERT INTO answer VALUES (3938, 985, 0, 'Contacts between a U.S. station and a non-U.S. station', ' ');
INSERT INTO answer VALUES (3937, 985, 1, 'Special event contacts between stations in the U.S.', ' ');
INSERT INTO answer VALUES (3939, 985, 2, 'Repeater contacts between U.S. club members', ' ');
INSERT INTO answer VALUES (3940, 985, 3, 'Contacts using tactical call signs', ' ');
INSERT INTO answer VALUES (3943, 986, 0, 'A wireless router running custom firmware', ' ');
INSERT INTO answer VALUES (3941, 986, 1, 'A 2 meter VHF transceiver with a 1200 baud modem', ' ');
INSERT INTO answer VALUES (3942, 986, 2, 'An optical cable connection between the USB ports of 2 separate computers', ' ');
INSERT INTO answer VALUES (3944, 986, 3, 'A 440 MHz transceiver with a 9600 baud modem', ' ');
INSERT INTO answer VALUES (3948, 987, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3945, 987, 1, 'Because the DX station may be transmitting on a frequency that is prohibited to some responding stations', ' ');
INSERT INTO answer VALUES (3946, 987, 2, 'To separate the calling stations from the DX station', ' ');
INSERT INTO answer VALUES (3947, 987, 3, 'To improve operating efficiency by reducing interference', ' ');
INSERT INTO answer VALUES (3949, 988, 0, 'Send your full call sign once or twice', ' ');
INSERT INTO answer VALUES (3950, 988, 1, 'Send only the last two letters of your call sign until you make contact', ' ');
INSERT INTO answer VALUES (3951, 988, 2, 'Send your full call sign and grid square', ' ');
INSERT INTO answer VALUES (3952, 988, 3, 'Send the call sign of the DX station three times, the words this is,then your call sign three times', ' ');
INSERT INTO answer VALUES (3955, 989, 0, 'Discovery and link establishment protocols', ' ');
INSERT INTO answer VALUES (3953, 989, 1, 'Forward error correction and Viterbi codes', ' ');
INSERT INTO answer VALUES (3954, 989, 2, 'Acting as store-and-forward digipeaters', ' ');
INSERT INTO answer VALUES (3956, 989, 3, 'Custom code plugs for the local trunking systems', ' ');
INSERT INTO answer VALUES (3958, 990, 0, 'MSK144', ' ');
INSERT INTO answer VALUES (3957, 990, 1, 'WSPR', ' ');
INSERT INTO answer VALUES (3959, 990, 2, 'Hellschreiber', ' ');
INSERT INTO answer VALUES (3960, 990, 3, 'APRS', ' ');
INSERT INTO answer VALUES (3964, 991, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (3961, 991, 1, '15-second timed transmission sequences with stations alternating based on location', ' ');
INSERT INTO answer VALUES (3962, 991, 2, 'Use of special digital modes', ' ');
INSERT INTO answer VALUES (3963, 991, 3, 'Short transmissions with rapidly repeated call signs and signal reports', ' ');
INSERT INTO answer VALUES (3968, 992, 0, 'JT65', ' ');
INSERT INTO answer VALUES (3965, 992, 1, 'MSK144', ' ');
INSERT INTO answer VALUES (3966, 992, 2, 'PACTOR III', ' ');
INSERT INTO answer VALUES (3967, 992, 3, 'Olivia', ' ');
INSERT INTO answer VALUES (3971, 993, 0, 'APRS', ' ');
INSERT INTO answer VALUES (3969, 993, 1, 'Ultrasonics', ' ');
INSERT INTO answer VALUES (3970, 993, 2, 'Bandwidth compressed LORAN', ' ');
INSERT INTO answer VALUES (3972, 993, 3, 'Doppler shift of beacon signals', ' ');
INSERT INTO answer VALUES (3974, 994, 0, 'The ability to decode signals which have a very low signal-to-noise ratio', ' ');
INSERT INTO answer VALUES (3973, 994, 1, 'Uses only a 65 Hz bandwidth', ' ');
INSERT INTO answer VALUES (3975, 994, 2, 'Easily copied by ear if necessary', ' ');
INSERT INTO answer VALUES (3976, 994, 3, 'Permits fast-scan TV transmissions over narrow bandwidth', ' ');
INSERT INTO answer VALUES (3977, 995, 0, 'Time synchronous transmissions alternately from each station', ' ');
INSERT INTO answer VALUES (3978, 995, 1, 'Storing and forwarding digital messages', ' ');
INSERT INTO answer VALUES (3979, 995, 2, 'Judging optimum transmission times by monitoring beacons reflected from the moon', ' ');
INSERT INTO answer VALUES (3980, 995, 3, 'High-speed CW identification to avoid fading', ' ');
INSERT INTO answer VALUES (3983, 996, 0, 'AX.25', ' ');
INSERT INTO answer VALUES (3981, 996, 1, 'PACTOR', ' ');
INSERT INTO answer VALUES (3982, 996, 2, '802.11', ' ');
INSERT INTO answer VALUES (3984, 996, 3, 'AMTOR', ' ');
INSERT INTO answer VALUES (3985, 997, 0, 'Unnumbered Information', ' ');
INSERT INTO answer VALUES (3986, 997, 1, 'Disconnect', ' ');
INSERT INTO answer VALUES (3987, 997, 2, 'Acknowledgement', ' ');
INSERT INTO answer VALUES (3988, 997, 3, 'Connect', ' ');
INSERT INTO answer VALUES (3989, 998, 0, 'Multi-tone AFSK', ' ');
INSERT INTO answer VALUES (3990, 998, 1, 'PSK', ' ');
INSERT INTO answer VALUES (3991, 998, 2, 'RTTY', ' ');
INSERT INTO answer VALUES (3992, 998, 3, 'IEEE 802.11', ' ');
INSERT INTO answer VALUES (3995, 999, 0, 'An APRS station with a Global Positioning System unit can automatically transmit information to show a mobile station''s position during the event', ' ');
INSERT INTO answer VALUES (3993, 999, 1, 'An APRS station with an emergency medical technician can automatically transmit medical data to the nearest hospital', ' ');
INSERT INTO answer VALUES (3994, 999, 2, 'APRS stations with General Personnel Scanners can automatically relay the participant numbers and time as they pass the check points', ' ');
INSERT INTO answer VALUES (3996, 999, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4000, 1000, 0, 'Latitude and longitude', ' ');
INSERT INTO answer VALUES (3997, 1000, 1, 'Polar coordinates', ' ');
INSERT INTO answer VALUES (3998, 1000, 2, 'Time and frequency', ' ');
INSERT INTO answer VALUES (3999, 1000, 3, 'Radio direction finding spectrum analysis', ' ');
INSERT INTO answer VALUES (4002, 1001, 0, 'FSK', ' ');
INSERT INTO answer VALUES (4001, 1001, 1, 'DTMF tones modulating an FM signal', ' ');
INSERT INTO answer VALUES (4003, 1001, 2, 'Pulse modulation', ' ');
INSERT INTO answer VALUES (4004, 1001, 3, 'Spread spectrum', ' ');
INSERT INTO answer VALUES (4005, 1002, 0, 'Forward Error Correction', ' ');
INSERT INTO answer VALUES (4006, 1002, 1, 'First Error Correction', ' ');
INSERT INTO answer VALUES (4007, 1002, 2, 'Fatal Error Correction', ' ');
INSERT INTO answer VALUES (4008, 1002, 3, 'Final Error Correction', ' ');
INSERT INTO answer VALUES (4011, 1003, 0, 'Alternating transmissions at 7.5 second intervals', ' ');
INSERT INTO answer VALUES (4009, 1003, 1, 'By exchanging ACK/NAK packets', ' ');
INSERT INTO answer VALUES (4010, 1003, 2, 'Stations take turns on alternate days', ' ');
INSERT INTO answer VALUES (4012, 1003, 3, 'It depends on the lunar phase', ' ');
INSERT INTO answer VALUES (4013, 1004, 0, 'Selective fading has occurred', ' ');
INSERT INTO answer VALUES (4014, 1004, 1, 'One of the signal filters is saturated', ' ');
INSERT INTO answer VALUES (4015, 1004, 2, 'The receiver has drifted 5 kHz from the desired receive frequency', ' ');
INSERT INTO answer VALUES (4016, 1004, 3, 'The mark and space signal have been inverted', ' ');
INSERT INTO answer VALUES (4017, 1005, 0, 'PACTOR', ' ');
INSERT INTO answer VALUES (4018, 1005, 1, 'RTTY', ' ');
INSERT INTO answer VALUES (4019, 1005, 2, 'PSK31', ' ');
INSERT INTO answer VALUES (4020, 1005, 3, 'MFSK', ' ');
INSERT INTO answer VALUES (4023, 1006, 0, '300 baud', ' ');
INSERT INTO answer VALUES (4021, 1006, 1, '48 baud', ' ');
INSERT INTO answer VALUES (4022, 1006, 2, '110 baud', ' ');
INSERT INTO answer VALUES (4024, 1006, 3, '1200 baud', ' ');
INSERT INTO answer VALUES (4028, 1007, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4025, 1007, 1, 'Your transmit frequency is incorrect', ' ');
INSERT INTO answer VALUES (4026, 1007, 2, 'The protocol version you are using is not supported by the digital station', ' ');
INSERT INTO answer VALUES (4027, 1007, 3, 'Another station you are unable to hear is using the frequency', ' ');
INSERT INTO answer VALUES (4030, 1008, 0, 'PACTOR', ' ');
INSERT INTO answer VALUES (4029, 1008, 1, 'Hellschreiber', ' ');
INSERT INTO answer VALUES (4031, 1008, 2, 'RTTY', ' ');
INSERT INTO answer VALUES (4032, 1008, 3, 'AMTOR', ' ');
INSERT INTO answer VALUES (4036, 1009, 0, 'PSK31', ' ');
INSERT INTO answer VALUES (4033, 1009, 1, 'RTTY', ' ');
INSERT INTO answer VALUES (4034, 1009, 2, 'PACTOR', ' ');
INSERT INTO answer VALUES (4035, 1009, 3, 'MT63', ' ');
INSERT INTO answer VALUES (4039, 1010, 0, 'PSK31', ' ');
INSERT INTO answer VALUES (4037, 1010, 1, 'MFSK16', ' ');
INSERT INTO answer VALUES (4038, 1010, 2, '170 Hz shift, 45-baud RTTY', ' ');
INSERT INTO answer VALUES (4040, 1010, 3, '300-baud packet', ' ');
INSERT INTO answer VALUES (4041, 1011, 0, 'Direct FSK applies the data signal to the transmitter VFO, while AFSK transmits tones via phone', ' ');
INSERT INTO answer VALUES (4042, 1011, 1, 'Direct FSK occupies less bandwidth', ' ');
INSERT INTO answer VALUES (4043, 1011, 2, 'Direct FSK can transmit faster baud rates', ' ');
INSERT INTO answer VALUES (4044, 1011, 3, 'Only direct FSK can be decoded by computer', ' ');
INSERT INTO answer VALUES (4045, 1012, 0, 'ALE constantly scans a list of frequencies, activating the radio when the designated call sign is received', ' ');
INSERT INTO answer VALUES (4046, 1012, 1, 'ALE radios monitor an internet site for the frequency they are being paged on', ' ');
INSERT INTO answer VALUES (4047, 1012, 2, 'ALE radios send a constant tone code to establish a frequency for future use', ' ');
INSERT INTO answer VALUES (4048, 1012, 3, 'ALE radios activate when they hear their signal echoed by back scatter', ' ');
INSERT INTO answer VALUES (4052, 1013, 0, '300 baud packet', ' ');
INSERT INTO answer VALUES (4049, 1013, 1, 'AMTOR', ' ');
INSERT INTO answer VALUES (4050, 1013, 2, '170 Hz shift, 45 baud RTTY', ' ');
INSERT INTO answer VALUES (4051, 1013, 3, 'PSK31', ' ');
INSERT INTO answer VALUES (4056, 1014, 0, '12,000 miles, if the moon is visible by both stations', ' ');
INSERT INTO answer VALUES (4053, 1014, 1, '500 miles, if the moon is at perigee', ' ');
INSERT INTO answer VALUES (4054, 1014, 2, '2000 miles, if the moon is at apogee', ' ');
INSERT INTO answer VALUES (4055, 1014, 3, '5000 miles, if the moon is at perigee', ' ');
INSERT INTO answer VALUES (4058, 1015, 0, 'A fluttery irregular fading', ' ');
INSERT INTO answer VALUES (4057, 1015, 1, 'A slow change in the pitch of the CW signal', ' ');
INSERT INTO answer VALUES (4059, 1015, 2, 'A gradual loss of signal as the sun rises', ' ');
INSERT INTO answer VALUES (4060, 1015, 3, 'The returning echo is several hertz lower in frequency than the transmitted signal', ' ');
INSERT INTO answer VALUES (4061, 1016, 0, 'When the moon is at perigee', ' ');
INSERT INTO answer VALUES (4062, 1016, 1, 'When the moon is full', ' ');
INSERT INTO answer VALUES (4063, 1016, 2, 'When the moon is at apogee', ' ');
INSERT INTO answer VALUES (4064, 1016, 3, 'When the MUF is above 30 MHz', ' ');
INSERT INTO answer VALUES (4068, 1017, 0, 'Probability of tropospheric propagation', ' ');
INSERT INTO answer VALUES (4065, 1017, 1, 'Sporadic E propagation', ' ');
INSERT INTO answer VALUES (4066, 1017, 2, 'Locations of auroral reflecting zones', ' ');
INSERT INTO answer VALUES (4067, 1017, 3, 'Likelihood of rain scatter along cold or warm fronts', ' ');
INSERT INTO answer VALUES (4071, 1018, 0, 'Warm and cold fronts', ' ');
INSERT INTO answer VALUES (4069, 1018, 1, 'Grayline', ' ');
INSERT INTO answer VALUES (4070, 1018, 2, 'Lightning discharges', ' ');
INSERT INTO answer VALUES (4072, 1018, 3, 'Sprites and jets', ' ');
INSERT INTO answer VALUES (4074, 1019, 0, 'Switch to a lower frequency HF band', ' ');
INSERT INTO answer VALUES (4073, 1019, 1, 'Switch to a higher frequency HF band', ' ');
INSERT INTO answer VALUES (4075, 1019, 2, 'Wait 90 minutes or so for the signal degradation to pass', ' ');
INSERT INTO answer VALUES (4076, 1019, 3, 'Wait 24 hours before attempting another communication on the band', ' ');
INSERT INTO answer VALUES (4079, 1020, 0, 'Bodies of water', ' ');
INSERT INTO answer VALUES (4077, 1020, 1, 'Mountain ranges', ' ');
INSERT INTO answer VALUES (4078, 1020, 2, 'Forests', ' ');
INSERT INTO answer VALUES (4080, 1020, 3, 'Urban areas', ' ');
INSERT INTO answer VALUES (4081, 1021, 0, 'The E layer', ' ');
INSERT INTO answer VALUES (4082, 1021, 1, 'The F1 layer', ' ');
INSERT INTO answer VALUES (4083, 1021, 2, 'The F2 layer', ' ');
INSERT INTO answer VALUES (4084, 1021, 3, 'The D layer', ' ');
INSERT INTO answer VALUES (4087, 1022, 0, '28 MHz - 148 MHz', ' ');
INSERT INTO answer VALUES (4085, 1022, 1, '1.8 MHz - 1.9 MHz', ' ');
INSERT INTO answer VALUES (4086, 1022, 2, '10 MHz - 14 MHz', ' ');
INSERT INTO answer VALUES (4088, 1022, 3, '220 MHz - 450 MHz', ' ');
INSERT INTO answer VALUES (4090, 1023, 0, 'Temperature inversion', ' ');
INSERT INTO answer VALUES (4089, 1023, 1, 'The jet stream', ' ');
INSERT INTO answer VALUES (4091, 1023, 2, 'Wind shear', ' ');
INSERT INTO answer VALUES (4092, 1023, 3, 'Dust devil', ' ');
INSERT INTO answer VALUES (4094, 1024, 0, '100 miles to 300 miles', ' ');
INSERT INTO answer VALUES (4093, 1024, 1, '10 miles to 50 miles', ' ');
INSERT INTO answer VALUES (4095, 1024, 2, '1200 miles', ' ');
INSERT INTO answer VALUES (4096, 1024, 3, '2500 miles', ' ');
INSERT INTO answer VALUES (4099, 1025, 0, 'The interaction in the E layer of charged particles from the Sun with the Earth''s magnetic field', ' ');
INSERT INTO answer VALUES (4097, 1025, 1, 'The interaction in the F2 layer between the solar wind and the Van Allen belt', ' ');
INSERT INTO answer VALUES (4098, 1025, 2, 'An extreme low-pressure area in the polar regions', ' ');
INSERT INTO answer VALUES (4100, 1025, 3, 'Meteor showers concentrated in the extreme northern and southern latitudes', ' ');
INSERT INTO answer VALUES (4101, 1026, 0, 'CW', ' ');
INSERT INTO answer VALUES (4102, 1026, 1, 'SSB', ' ');
INSERT INTO answer VALUES (4103, 1026, 2, 'FM', ' ');
INSERT INTO answer VALUES (4104, 1026, 3, 'RTTY', ' ');
INSERT INTO answer VALUES (4106, 1027, 0, 'Waves with a rotating electric field', ' ');
INSERT INTO answer VALUES (4105, 1027, 1, 'Waves with an electric field bent into a circular shape', ' ');
INSERT INTO answer VALUES (4107, 1027, 2, 'Waves that circle the Earth', ' ');
INSERT INTO answer VALUES (4108, 1027, 3, 'Waves produced by a loop antenna', ' ');
INSERT INTO answer VALUES (4109, 1028, 0, 'Propagation between two mid-latitude points at approximately the same distance north and south of the magnetic equator', ' ');
INSERT INTO answer VALUES (4110, 1028, 1, 'Propagation between points located on the magnetic equator', ' ');
INSERT INTO answer VALUES (4111, 1028, 2, 'Propagation between a point on the equator and its antipodal point', ' ');
INSERT INTO answer VALUES (4112, 1028, 3, 'Propagation between points at the same latitude', ' ');
INSERT INTO answer VALUES (4115, 1029, 0, '5000 miles', ' ');
INSERT INTO answer VALUES (4113, 1029, 1, '1000 miles', ' ');
INSERT INTO answer VALUES (4114, 1029, 2, '2500 miles', ' ');
INSERT INTO answer VALUES (4116, 1029, 3, '7500 miles', ' ');
INSERT INTO answer VALUES (4119, 1030, 0, 'Afternoon or early evening', ' ');
INSERT INTO answer VALUES (4117, 1030, 1, 'Morning', ' ');
INSERT INTO answer VALUES (4118, 1030, 2, 'Noon', ' ');
INSERT INTO answer VALUES (4120, 1030, 3, 'Late at night', ' ');
INSERT INTO answer VALUES (4122, 1031, 0, 'Independent waves created in the ionosphere that are elliptically polarized', ' ');
INSERT INTO answer VALUES (4121, 1031, 1, 'Extraordinary waves describe rare long-skip propagation compared to ordinary waves, which travel shorter distances', ' ');
INSERT INTO answer VALUES (4123, 1031, 2, 'Long-path and short-path waves', ' ');
INSERT INTO answer VALUES (4124, 1031, 3, 'Refracted rays and reflected waves', ' ');
INSERT INTO answer VALUES (4127, 1032, 0, '160 meters to 10 meters', ' ');
INSERT INTO answer VALUES (4125, 1032, 1, 'Only 160 meters to 40 meters', ' ');
INSERT INTO answer VALUES (4126, 1032, 2, 'Only 30 meters to 10 meters', ' ');
INSERT INTO answer VALUES (4128, 1032, 3, '6 meters to 2 meters', ' ');
INSERT INTO answer VALUES (4130, 1033, 0, '20 meters', ' ');
INSERT INTO answer VALUES (4129, 1033, 1, '80 meters', ' ');
INSERT INTO answer VALUES (4131, 1033, 2, '10 meters', ' ');
INSERT INTO answer VALUES (4132, 1033, 3, '6 meters', ' ');
INSERT INTO answer VALUES (4135, 1034, 0, 'They become elliptically polarized', ' ');
INSERT INTO answer VALUES (4133, 1034, 1, 'They are bent toward the magnetic poles', ' ');
INSERT INTO answer VALUES (4134, 1034, 2, 'They become depolarized', ' ');
INSERT INTO answer VALUES (4136, 1034, 3, 'They become phase locked', ' ');
INSERT INTO answer VALUES (4140, 1035, 0, 'Grayline', ' ');
INSERT INTO answer VALUES (4137, 1035, 1, 'Transequatorial', ' ');
INSERT INTO answer VALUES (4138, 1035, 2, 'Sporadic E', ' ');
INSERT INTO answer VALUES (4139, 1035, 3, 'Long-path', ' ');
INSERT INTO answer VALUES (4141, 1036, 0, 'Around the solstices, especially the summer solstice', ' ');
INSERT INTO answer VALUES (4142, 1036, 1, 'Around the solstices, especially the winter solstice', ' ');
INSERT INTO answer VALUES (4143, 1036, 2, 'Around the equinoxes, especially the spring equinox', ' ');
INSERT INTO answer VALUES (4144, 1036, 3, 'Around the equinoxes, especially the fall equinox', ' ');
INSERT INTO answer VALUES (4145, 1037, 0, 'The signal experiences less loss compared to multi-hop using Earth as a reflector', ' ');
INSERT INTO answer VALUES (4146, 1037, 1, 'The MUF for chordal hop propagation is much lower than for normal skip propagation', ' ');
INSERT INTO answer VALUES (4147, 1037, 2, 'Atmospheric noise is lower in the direction of chordal hop propagation', ' ');
INSERT INTO answer VALUES (4148, 1037, 3, 'Signals travel faster along ionospheric chords', ' ');
INSERT INTO answer VALUES (4152, 1038, 0, 'Any time', ' ');
INSERT INTO answer VALUES (4149, 1038, 1, 'Only around sunset', ' ');
INSERT INTO answer VALUES (4150, 1038, 2, 'Only around sunset and sunrise', ' ');
INSERT INTO answer VALUES (4151, 1038, 3, 'Only in hours of darkness', ' ');
INSERT INTO answer VALUES (4154, 1039, 0, 'Successive ionospheric refractions without an intermediate reflection from the ground', ' ');
INSERT INTO answer VALUES (4153, 1039, 1, 'Propagation away from the great circle bearing between stations', ' ');
INSERT INTO answer VALUES (4155, 1039, 2, 'Propagation across the geomagnetic equator', ' ');
INSERT INTO answer VALUES (4156, 1039, 3, 'Signals reflected back toward the transmitting station', ' ');
INSERT INTO answer VALUES (4158, 1040, 0, 'Modeling a radio wave''s path through the ionosphere', ' ');
INSERT INTO answer VALUES (4157, 1040, 1, 'The process in which an electronic display presents a pattern', ' ');
INSERT INTO answer VALUES (4159, 1040, 2, 'Determining the radiation pattern from an array of antennas', ' ');
INSERT INTO answer VALUES (4160, 1040, 3, 'Evaluating high voltage sources for x-rays', ' ');
INSERT INTO answer VALUES (4161, 1041, 0, 'Increasing disruption of the geomagnetic field', ' ');
INSERT INTO answer VALUES (4162, 1041, 1, 'Decreasing disruption of the geomagnetic field', ' ');
INSERT INTO answer VALUES (4163, 1041, 2, 'Higher levels of solar UV radiation', ' ');
INSERT INTO answer VALUES (4164, 1041, 3, 'An increase in the critical frequency', ' ');
INSERT INTO answer VALUES (4166, 1042, 0, 'Polar', ' ');
INSERT INTO answer VALUES (4165, 1042, 1, 'Transequatorial', ' ');
INSERT INTO answer VALUES (4167, 1042, 2, 'Sporadic E', ' ');
INSERT INTO answer VALUES (4168, 1042, 3, 'NVIS', ' ');
INSERT INTO answer VALUES (4171, 1043, 0, 'Direction and strength of the interplanetary magnetic field', ' ');
INSERT INTO answer VALUES (4169, 1043, 1, 'Geomagnetic field stability', ' ');
INSERT INTO answer VALUES (4170, 1043, 2, 'Critical frequency for vertical transmissions', ' ');
INSERT INTO answer VALUES (4172, 1043, 3, 'Duration of long-delayed echoes', ' ');
INSERT INTO answer VALUES (4173, 1044, 0, 'Southward', ' ');
INSERT INTO answer VALUES (4174, 1044, 1, 'Northward', ' ');
INSERT INTO answer VALUES (4175, 1044, 2, 'Eastward', ' ');
INSERT INTO answer VALUES (4176, 1044, 3, 'Westward', ' ');
INSERT INTO answer VALUES (4177, 1045, 0, 'By approximately 15 percent of the distance', ' ');
INSERT INTO answer VALUES (4178, 1045, 1, 'By approximately twice the distance', ' ');
INSERT INTO answer VALUES (4179, 1045, 2, 'By approximately 50 percent of the distance', ' ');
INSERT INTO answer VALUES (4180, 1045, 3, 'By approximately four times the distance', ' ');
INSERT INTO answer VALUES (4184, 1046, 0, 'Class X', ' ');
INSERT INTO answer VALUES (4181, 1046, 1, 'Class A', ' ');
INSERT INTO answer VALUES (4182, 1046, 2, 'Class B', ' ');
INSERT INTO answer VALUES (4183, 1046, 3, 'Class M', ' ');
INSERT INTO answer VALUES (4185, 1047, 0, 'An extreme geomagnetic storm', ' ');
INSERT INTO answer VALUES (4186, 1047, 1, 'Very low solar activity', ' ');
INSERT INTO answer VALUES (4187, 1047, 2, 'Moderate solar wind', ' ');
INSERT INTO answer VALUES (4188, 1047, 3, 'Waning sunspot numbers', ' ');
INSERT INTO answer VALUES (4190, 1048, 0, '50 percent greater', ' ');
INSERT INTO answer VALUES (4189, 1048, 1, '10 percent greater', ' ');
INSERT INTO answer VALUES (4191, 1048, 2, 'Twice as great', ' ');
INSERT INTO answer VALUES (4192, 1048, 3, 'Four times as great', ' ');
INSERT INTO answer VALUES (4194, 1049, 0, 'UV emissions at 304 angstroms, correlated to the solar flux index', ' ');
INSERT INTO answer VALUES (4193, 1049, 1, 'The ratio of x-ray flux to radio flux, correlated to sunspot number', ' ');
INSERT INTO answer VALUES (4195, 1049, 2, 'The solar wind velocity at 304 degrees from the solar equator, correlated to solar activity', ' ');
INSERT INTO answer VALUES (4196, 1049, 3, 'The solar emission at 304 GHz, correlated to x-ray flare levels', ' ');
INSERT INTO answer VALUES (4199, 1050, 0, 'HF propagation', ' ');
INSERT INTO answer VALUES (4197, 1050, 1, 'AC voltage and impedance', ' ');
INSERT INTO answer VALUES (4198, 1050, 2, 'VHF radio propagation', ' ');
INSERT INTO answer VALUES (4200, 1050, 3, 'AC current and impedance', ' ');
INSERT INTO answer VALUES (4203, 1051, 0, 'It decreases', ' ');
INSERT INTO answer VALUES (4201, 1051, 1, 'It stays the same', ' ');
INSERT INTO answer VALUES (4202, 1051, 2, 'It increases', ' ');
INSERT INTO answer VALUES (4204, 1051, 3, 'It peaks at roughly 14 MHz', ' ');
INSERT INTO answer VALUES (4205, 1052, 0, 'Vertical', ' ');
INSERT INTO answer VALUES (4206, 1052, 1, 'Horizontal', ' ');
INSERT INTO answer VALUES (4207, 1052, 2, 'Circular', ' ');
INSERT INTO answer VALUES (4208, 1052, 3, 'Elliptical', ' ');
INSERT INTO answer VALUES (4212, 1053, 0, 'Downward bending due to density variations in the atmosphere', ' ');
INSERT INTO answer VALUES (4209, 1053, 1, 'E-region skip', ' ');
INSERT INTO answer VALUES (4210, 1053, 2, 'D-region skip', ' ');
INSERT INTO answer VALUES (4211, 1053, 3, 'Due to the Doppler effect', ' ');
INSERT INTO answer VALUES (4214, 1054, 0, 'A solar flare has occurred', ' ');
INSERT INTO answer VALUES (4213, 1054, 1, 'A temperature inversion has occurred', ' ');
INSERT INTO answer VALUES (4215, 1054, 2, 'Increased transequatorial propagation is likely', ' ');
INSERT INTO answer VALUES (4216, 1054, 3, 'Long-path propagation is likely', ' ');
INSERT INTO answer VALUES (4217, 1055, 0, 'Sampling rate of the analog-to-digital converter', ' ');
INSERT INTO answer VALUES (4218, 1055, 1, 'Amount of memory', ' ');
INSERT INTO answer VALUES (4219, 1055, 2, 'Q of the circuit', ' ');
INSERT INTO answer VALUES (4220, 1055, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4222, 1056, 0, 'RF amplitude and frequency', ' ');
INSERT INTO answer VALUES (4221, 1056, 1, 'RF amplitude and time', ' ');
INSERT INTO answer VALUES (4223, 1056, 2, 'SWR and frequency', ' ');
INSERT INTO answer VALUES (4224, 1056, 3, 'SWR and time', ' ');
INSERT INTO answer VALUES (4226, 1057, 0, 'A spectrum analyzer', ' ');
INSERT INTO answer VALUES (4225, 1057, 1, 'A wattmeter', ' ');
INSERT INTO answer VALUES (4227, 1057, 2, 'A logic analyzer', ' ');
INSERT INTO answer VALUES (4228, 1057, 3, 'A time-domain reflectometer', ' ');
INSERT INTO answer VALUES (4229, 1058, 0, 'A square wave is displayed and the probe is adjusted until the horizontal portions of the displayed wave are as nearly flat as possible', ' ');
INSERT INTO answer VALUES (4230, 1058, 1, 'A high frequency sine wave is displayed and the probe is adjusted for maximum amplitude', ' ');
INSERT INTO answer VALUES (4231, 1058, 2, 'A frequency standard is displayed and the probe is adjusted until the deflection time is accurate', ' ');
INSERT INTO answer VALUES (4232, 1058, 3, 'A DC voltage standard is displayed and the probe is adjusted until the displayed voltage is accurate', ' ');
INSERT INTO answer VALUES (4236, 1059, 0, 'It divides a higher frequency signal so a low-frequency counter can display the input frequency', ' ');
INSERT INTO answer VALUES (4233, 1059, 1, 'It amplifies low-level signals for more accurate counting', ' ');
INSERT INTO answer VALUES (4234, 1059, 2, 'It multiplies a higher frequency signal so a low-frequency counter can display the operating frequency', ' ');
INSERT INTO answer VALUES (4235, 1059, 3, 'It prevents oscillation in a low-frequency counter circuit', ' ');
INSERT INTO answer VALUES (4237, 1060, 0, 'A false, jittery low-frequency version of the signal is displayed', ' ');
INSERT INTO answer VALUES (4238, 1060, 1, 'All signals will have a DC offset', ' ');
INSERT INTO answer VALUES (4239, 1060, 2, 'Calibration of the vertical scale is no longer valid', ' ');
INSERT INTO answer VALUES (4240, 1060, 3, 'Excessive blanking occurs, which prevents display of the signal', ' ');
INSERT INTO answer VALUES (4242, 1061, 0, 'Antenna analyzers do not need an external RF source', ' ');
INSERT INTO answer VALUES (4241, 1061, 1, 'Antenna analyzers automatically tune your antenna for resonance', ' ');
INSERT INTO answer VALUES (4243, 1061, 2, 'Antenna analyzers display a time-varying representation of the modulation envelope', ' ');
INSERT INTO answer VALUES (4244, 1061, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4248, 1062, 0, 'An antenna analyzer', ' ');
INSERT INTO answer VALUES (4245, 1062, 1, 'A spectrum analyzer', ' ');
INSERT INTO answer VALUES (4246, 1062, 2, 'A Q meter', ' ');
INSERT INTO answer VALUES (4247, 1062, 3, 'An ohmmeter', ' ');
INSERT INTO answer VALUES (4249, 1063, 0, 'Keep the signal ground connection of the probe as short as possible', ' ');
INSERT INTO answer VALUES (4250, 1063, 1, 'Never use a high-impedance probe to measure a low-impedance circuit', ' ');
INSERT INTO answer VALUES (4251, 1063, 2, 'Never use a DC-coupled probe to measure an AC circuit', ' ');
INSERT INTO answer VALUES (4252, 1063, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4256, 1064, 0, 'Logic analyzer', ' ');
INSERT INTO answer VALUES (4253, 1064, 1, 'Network analyzer', ' ');
INSERT INTO answer VALUES (4254, 1064, 2, 'Bit error rate tester', ' ');
INSERT INTO answer VALUES (4255, 1064, 3, 'Modulation monitor', ' ');
INSERT INTO answer VALUES (4260, 1065, 0, 'Connect the antenna feed line directly to the analyzer''s connector', ' ');
INSERT INTO answer VALUES (4257, 1065, 1, 'Loosely couple the analyzer near the antenna base', ' ');
INSERT INTO answer VALUES (4258, 1065, 2, 'Connect the analyzer via a high-impedance transformer to the antenna', ' ');
INSERT INTO answer VALUES (4259, 1065, 3, 'Loosely couple the antenna and a dummy load to the analyzer', ' ');
INSERT INTO answer VALUES (4262, 1066, 0, 'Time base accuracy', ' ');
INSERT INTO answer VALUES (4261, 1066, 1, 'Input attenuator accuracy', ' ');
INSERT INTO answer VALUES (4263, 1066, 2, 'Decade divider accuracy', ' ');
INSERT INTO answer VALUES (4264, 1066, 3, 'Temperature coefficient of the logic', ' ');
INSERT INTO answer VALUES (4265, 1067, 0, 'The full scale reading of the voltmeter multiplied by its ohms per volt rating will indicate the input impedance of the voltmeter', ' ');
INSERT INTO answer VALUES (4266, 1067, 1, 'When used as a galvanometer, the reading in volts multiplied by the ohms per volt rating will determine the power drawn by the device under test', ' ');
INSERT INTO answer VALUES (4267, 1067, 2, 'When used as an ohmmeter, the reading in ohms divided by the ohms per volt rating will determine the voltage applied to the circuit', ' ');
INSERT INTO answer VALUES (4268, 1067, 3, 'When used as an ammeter, the full scale reading in amps divided by ohms per volt rating will determine the size of shunt needed', ' ');
INSERT INTO answer VALUES (4271, 1068, 0, 'S21', ' ');
INSERT INTO answer VALUES (4269, 1068, 1, 'S11', ' ');
INSERT INTO answer VALUES (4270, 1068, 2, 'S12', ' ');
INSERT INTO answer VALUES (4272, 1068, 3, 'S22', ' ');
INSERT INTO answer VALUES (4273, 1069, 0, 'S11', ' ');
INSERT INTO answer VALUES (4274, 1069, 1, 'S12', ' ');
INSERT INTO answer VALUES (4275, 1069, 2, 'S21', ' ');
INSERT INTO answer VALUES (4276, 1069, 3, 'S22', ' ');
INSERT INTO answer VALUES (4278, 1070, 0, 'Short circuit, open circuit, and 50 ohms', ' ');
INSERT INTO answer VALUES (4277, 1070, 1, '50 ohms, 75 ohms, and 90 ohms', ' ');
INSERT INTO answer VALUES (4279, 1070, 2, 'Short circuit, open circuit, and resonant circuit', ' ');
INSERT INTO answer VALUES (4280, 1070, 3, '50 ohms through 1/8 wavelength, 1/4 wavelength, and 1/2 wavelength of coaxial cable', ' ');
INSERT INTO answer VALUES (4284, 1071, 0, '75 watts', ' ');
INSERT INTO answer VALUES (4281, 1071, 1, '100 watts', ' ');
INSERT INTO answer VALUES (4282, 1071, 2, '125 watts', ' ');
INSERT INTO answer VALUES (4283, 1071, 3, '25 watts', ' ');
INSERT INTO answer VALUES (4285, 1072, 0, 'The port or ports at which measurements are made', ' ');
INSERT INTO answer VALUES (4286, 1072, 1, 'The relative time between measurements', ' ');
INSERT INTO answer VALUES (4287, 1072, 2, 'Relative quality of the data', ' ');
INSERT INTO answer VALUES (4288, 1072, 3, 'Frequency order of the measurements', ' ');
INSERT INTO answer VALUES (4291, 1073, 0, 'The bandwidth of the circuit''s frequency response', ' ');
INSERT INTO answer VALUES (4289, 1073, 1, 'The inductance to capacitance ratio', ' ');
INSERT INTO answer VALUES (4290, 1073, 2, 'The frequency shift', ' ');
INSERT INTO answer VALUES (4292, 1073, 3, 'The resonant frequency of the circuit', ' ');
INSERT INTO answer VALUES (4296, 1074, 0, 'There is more power going into the antenna', ' ');
INSERT INTO answer VALUES (4293, 1074, 1, 'There is possibly a short to ground in the feed line', ' ');
INSERT INTO answer VALUES (4294, 1074, 2, 'The transmitter is not properly neutralized', ' ');
INSERT INTO answer VALUES (4295, 1074, 3, 'There is an impedance mismatch between the antenna and feed line', ' ');
INSERT INTO answer VALUES (4298, 1075, 0, 'Modulate the transmitter using two AF signals having non-harmonically related frequencies and observe the RF output with a spectrum analyzer', ' ');
INSERT INTO answer VALUES (4297, 1075, 1, 'Modulate the transmitter using two RF signals having non-harmonically related frequencies and observe the RF output with a spectrum analyzer', ' ');
INSERT INTO answer VALUES (4299, 1075, 2, 'Modulate the transmitter using two AF signals having harmonically related frequencies and observe the RF output with a peak reading wattmeter', ' ');
INSERT INTO answer VALUES (4300, 1075, 3, 'Modulate the transmitter using two RF signals having harmonically related frequencies and observe the RF output with a logic analyzer', ' ');
INSERT INTO answer VALUES (4304, 1076, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4301, 1076, 1, 'Input impedance', ' ');
INSERT INTO answer VALUES (4302, 1076, 2, 'Output impedance', ' ');
INSERT INTO answer VALUES (4303, 1076, 3, 'Reflection coefficient', ' ');
INSERT INTO answer VALUES (4308, 1077, 0, 'It can combine with strong signals on nearby frequencies to generate interference', ' ');
INSERT INTO answer VALUES (4305, 1077, 1, 'It limits the receiver''s ability to receive strong signals', ' ');
INSERT INTO answer VALUES (4306, 1077, 2, 'It can affect the receiver''s frequency calibration', ' ');
INSERT INTO answer VALUES (4307, 1077, 3, 'It decreases receiver third-order intercept point', ' ');
INSERT INTO answer VALUES (4309, 1078, 0, 'A front-end filter or pre-selector', ' ');
INSERT INTO answer VALUES (4310, 1078, 1, 'A narrow IF filter', ' ');
INSERT INTO answer VALUES (4311, 1078, 2, 'A notch filter', ' ');
INSERT INTO answer VALUES (4312, 1078, 3, 'A properly adjusted product detector', ' ');
INSERT INTO answer VALUES (4315, 1079, 0, 'Capture effect', ' ');
INSERT INTO answer VALUES (4313, 1079, 1, 'Desensitization', ' ');
INSERT INTO answer VALUES (4314, 1079, 2, 'Cross-modulation interference', ' ');
INSERT INTO answer VALUES (4316, 1079, 3, 'Frequency discrimination', ' ');
INSERT INTO answer VALUES (4320, 1080, 0, 'The ratio in dB of the noise generated by the receiver to the theoretical minimum noise', ' ');
INSERT INTO answer VALUES (4317, 1080, 1, 'The ratio of atmospheric noise to phase noise', ' ');
INSERT INTO answer VALUES (4318, 1080, 2, 'The ratio of the noise bandwidth in hertz to the theoretical bandwidth of a resistive network', ' ');
INSERT INTO answer VALUES (4319, 1080, 3, 'The ratio of thermal noise to atmospheric noise', ' ');
INSERT INTO answer VALUES (4322, 1081, 0, 'The theoretical noise in a 1 Hz bandwidth at the input of a perfect receiver at room temperature', ' ');
INSERT INTO answer VALUES (4321, 1081, 1, 'The minimum detectable signal as a function of receive frequency', ' ');
INSERT INTO answer VALUES (4323, 1081, 2, 'The noise figure of a 1 Hz bandwidth receiver', ' ');
INSERT INTO answer VALUES (4324, 1081, 3, 'The galactic noise contribution to minimum detectable signal', ' ');
INSERT INTO answer VALUES (4328, 1082, 0, '-148 dBm', ' ');
INSERT INTO answer VALUES (4325, 1082, 1, '-174 dBm', ' ');
INSERT INTO answer VALUES (4326, 1082, 2, '-164 dBm', ' ');
INSERT INTO answer VALUES (4327, 1082, 3, '-155 dBm', ' ');
INSERT INTO answer VALUES (4330, 1083, 0, 'The minimum discernible signal', ' ');
INSERT INTO answer VALUES (4329, 1083, 1, 'The meter display sensitivity', ' ');
INSERT INTO answer VALUES (4331, 1083, 2, 'The multiplex distortion stability', ' ');
INSERT INTO answer VALUES (4332, 1083, 3, 'The maximum detectable spectrum', ' ');
INSERT INTO answer VALUES (4336, 1084, 0, 'The reference voltage of the analog-to-digital converter', ' ');
INSERT INTO answer VALUES (4333, 1084, 1, 'One-half the maximum sample rate', ' ');
INSERT INTO answer VALUES (4334, 1084, 2, 'One-half the maximum sampling buffer size', ' ');
INSERT INTO answer VALUES (4335, 1084, 3, 'The maximum count value of the analog-to-digital converter', ' ');
INSERT INTO answer VALUES (4339, 1085, 0, 'Easier for front-end circuitry to eliminate image responses', ' ');
INSERT INTO answer VALUES (4337, 1085, 1, 'Fewer components in the receiver', ' ');
INSERT INTO answer VALUES (4338, 1085, 2, 'Reduced drift', ' ');
INSERT INTO answer VALUES (4340, 1085, 3, 'Improved receiver noise figure', ' ');
INSERT INTO answer VALUES (4343, 1086, 0, 'Receive bandwidth can be set to match the modulation bandwidth, maximizing signal-to-noise ratio and minimizing interference', ' ');
INSERT INTO answer VALUES (4341, 1086, 1, 'The noise figure of the RF amplifier can be adjusted to match the modulation type, thus increasing receiver sensitivity', ' ');
INSERT INTO answer VALUES (4342, 1086, 2, 'Receiver power consumption can be reduced when wider bandwidth is not required', ' ');
INSERT INTO answer VALUES (4344, 1086, 3, 'Multiple frequencies can be received simultaneously if desired', ' ');
INSERT INTO answer VALUES (4348, 1087, 0, 'Atmospheric noise is generally greater than internally generated noise even after attenuation', ' ');
INSERT INTO answer VALUES (4345, 1087, 1, 'The attenuator has a low-pass filter to increase the strength of lower frequency signals', ' ');
INSERT INTO answer VALUES (4346, 1087, 2, 'The attenuator has a noise filter to suppress interference', ' ');
INSERT INTO answer VALUES (4347, 1087, 3, 'Signals are attenuated separately from the noise', ' ');
INSERT INTO answer VALUES (4352, 1088, 0, 'Analog-to-digital converter sample width in bits', ' ');
INSERT INTO answer VALUES (4349, 1088, 1, 'CPU register width in bits', ' ');
INSERT INTO answer VALUES (4350, 1088, 2, 'Anti-aliasing input filter bandwidth', ' ');
INSERT INTO answer VALUES (4351, 1088, 3, 'RAM speed used for data storage', ' ');
INSERT INTO answer VALUES (4355, 1089, 0, 'It improves dynamic range by attenuating strong signals near the receive frequency', ' ');
INSERT INTO answer VALUES (4353, 1089, 1, 'It improves sensitivity by reducing front end noise', ' ');
INSERT INTO answer VALUES (4354, 1089, 2, 'It improves intelligibility by using low Q circuitry to reduce ringing', ' ');
INSERT INTO answer VALUES (4356, 1089, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4360, 1090, 0, '15.210 MHz', ' ');
INSERT INTO answer VALUES (4357, 1090, 1, '13.845 MHz', ' ');
INSERT INTO answer VALUES (4358, 1090, 2, '14.755 MHz', ' ');
INSERT INTO answer VALUES (4359, 1090, 3, '14.445 MHz', ' ');
INSERT INTO answer VALUES (4364, 1091, 0, 'Local oscillator phase noise mixing with adjacent strong signals to create interference to desired signals', ' ');
INSERT INTO answer VALUES (4361, 1091, 1, 'Two out-of-band signals mixing to generate an in-band spurious signal', ' ');
INSERT INTO answer VALUES (4362, 1091, 2, 'In-phase signals cancelling in a mixer resulting in loss of receiver sensitivity', ' ');
INSERT INTO answer VALUES (4363, 1091, 3, 'Two digital signals combining from alternate time slots', ' ');
INSERT INTO answer VALUES (4365, 1092, 0, 'The difference in dB between the noise floor and the level of an incoming signal that will cause 1 dB of gain compression', ' ');
INSERT INTO answer VALUES (4366, 1092, 1, 'The minimum difference in dB between the levels of two FM signals that will cause one signal to block the other', ' ');
INSERT INTO answer VALUES (4367, 1092, 2, 'The difference in dB between the noise floor and the third-order intercept point', ' ');
INSERT INTO answer VALUES (4368, 1092, 3, 'The minimum difference in dB between two signals which produce third-order intermodulation products greater than the noise floor', ' ');
INSERT INTO answer VALUES (4369, 1093, 0, 'Spurious signals caused by cross-modulation and desensitization from strong adjacent signals', ' ');
INSERT INTO answer VALUES (4370, 1093, 1, 'Oscillator instability requiring frequent retuning and loss of ability to recover the opposite sideband', ' ');
INSERT INTO answer VALUES (4371, 1093, 2, 'Cross-modulation of the desired signal and insufficient audio power to operate the speaker', ' ');
INSERT INTO answer VALUES (4372, 1093, 3, 'Oscillator instability and severe audio distortion of all but the strongest received signals', ' ');
INSERT INTO answer VALUES (4374, 1094, 0, 'When the repeaters are in close proximity and the signals mix in the final amplifier of one or both transmitters', ' ');
INSERT INTO answer VALUES (4373, 1094, 1, 'When the repeaters are in close proximity and the signals cause feedback in the final amplifier of one or both transmitters', ' ');
INSERT INTO answer VALUES (4375, 1094, 2, 'When the signals from the transmitters are reflected out of phase from airplanes passing overhead', ' ');
INSERT INTO answer VALUES (4376, 1094, 3, 'When the signals from the transmitters are reflected in phase from airplanes passing overhead', ' ');
INSERT INTO answer VALUES (4378, 1095, 0, 'A properly terminated circulator at the output of the repeater''s transmitter', ' ');
INSERT INTO answer VALUES (4377, 1095, 1, 'A band-pass filter in the feed line between the transmitter and receiver', ' ');
INSERT INTO answer VALUES (4379, 1095, 2, 'Utilizing a Class C final amplifier', ' ');
INSERT INTO answer VALUES (4380, 1095, 3, 'Utilizing a Class D final amplifier', ' ');
INSERT INTO answer VALUES (4381, 1096, 0, '146.34 MHz and 146.61 MHz', ' ');
INSERT INTO answer VALUES (4382, 1096, 1, '146.88 MHz and 146.34 MHz', ' ');
INSERT INTO answer VALUES (4383, 1096, 2, '146.10 MHz and 147.30 MHz', ' ');
INSERT INTO answer VALUES (4384, 1096, 3, '173.35 MHz and 139.40 MHz', ' ');
INSERT INTO answer VALUES (4388, 1097, 0, 'Intermodulation', ' ');
INSERT INTO answer VALUES (4385, 1097, 1, 'Amplifier desensitization', ' ');
INSERT INTO answer VALUES (4386, 1097, 2, 'Neutralization', ' ');
INSERT INTO answer VALUES (4387, 1097, 3, 'Adjacent channel interference', ' ');
INSERT INTO answer VALUES (4389, 1098, 0, 'Decrease the RF bandwidth of the receiver', ' ');
INSERT INTO answer VALUES (4390, 1098, 1, 'Raise the receiver IF frequency', ' ');
INSERT INTO answer VALUES (4391, 1098, 2, 'Increase the receiver front end gain', ' ');
INSERT INTO answer VALUES (4392, 1098, 3, 'Switch from fast AGC to slow AGC', ' ');
INSERT INTO answer VALUES (4395, 1099, 0, 'Nonlinear circuits or devices', ' ');
INSERT INTO answer VALUES (4393, 1099, 1, 'Too little gain', ' ');
INSERT INTO answer VALUES (4394, 1099, 2, 'Lack of neutralization', ' ');
INSERT INTO answer VALUES (4396, 1099, 3, 'Positive feedback', ' ');
INSERT INTO answer VALUES (4399, 1100, 0, 'To increase rejection of signals outside the desired band', ' ');
INSERT INTO answer VALUES (4397, 1100, 1, 'To store often-used frequencies', ' ');
INSERT INTO answer VALUES (4398, 1100, 2, 'To provide a range of AGC time constants', ' ');
INSERT INTO answer VALUES (4400, 1100, 3, 'To allow selection of the optimum RF amplifier device', ' ');
INSERT INTO answer VALUES (4403, 1101, 0, 'A pair of 40 dBm input signals will theoretically generate a third-order intermodulation product that has the same output amplitude as either of the input signals', ' ');
INSERT INTO answer VALUES (4401, 1101, 1, 'Signals less than 40 dBm will not generate audible third-order intermodulation products', ' ');
INSERT INTO answer VALUES (4402, 1101, 2, 'The receiver can tolerate signals up to 40 dB above the noise floor without producing third-order intermodulation products', ' ');
INSERT INTO answer VALUES (4404, 1101, 3, 'A pair of 1 mW input signals will produce a third-order intermodulation product that is 40 dB stronger than the input signal', ' ');
INSERT INTO answer VALUES (4405, 1102, 0, 'Odd-order products of two signals in the band of interest are also likely to be within the band', ' ');
INSERT INTO answer VALUES (4406, 1102, 1, 'Odd-order products overload the IF filters', ' ');
INSERT INTO answer VALUES (4407, 1102, 2, 'Odd-order products are an indication of poor image rejection', ' ');
INSERT INTO answer VALUES (4408, 1102, 3, 'Odd-order intermodulation produces three products for every input signal within the band of interest', ' ');
INSERT INTO answer VALUES (4409, 1103, 0, 'Desensitization', ' ');
INSERT INTO answer VALUES (4410, 1103, 1, 'Quieting', ' ');
INSERT INTO answer VALUES (4411, 1103, 2, 'Cross-modulation interference', ' ');
INSERT INTO answer VALUES (4412, 1103, 3, 'Squelch gain rollback', ' ');
INSERT INTO answer VALUES (4413, 1104, 0, 'Removal of the CW signal as well as the interfering carrier', ' ');
INSERT INTO answer VALUES (4414, 1104, 1, 'Any nearby signal passing through the DSP system will overwhelm the desired signal', ' ');
INSERT INTO answer VALUES (4415, 1104, 2, 'Received CW signals will appear to be modulated at the DSP clock frequency', ' ');
INSERT INTO answer VALUES (4416, 1104, 3, 'Ringing in the DSP filter will completely remove the spaces between the CW characters', ' ');
INSERT INTO answer VALUES (4420, 1105, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4417, 1105, 1, 'Broadband white noise', ' ');
INSERT INTO answer VALUES (4418, 1105, 2, 'Ignition noise', ' ');
INSERT INTO answer VALUES (4419, 1105, 3, 'Power line noise', ' ');
INSERT INTO answer VALUES (4422, 1106, 0, 'Signals that appear across a wide bandwidth', ' ');
INSERT INTO answer VALUES (4421, 1106, 1, 'Signals that are constant at all IF levels', ' ');
INSERT INTO answer VALUES (4423, 1106, 2, 'Signals that appear at one IF but not another', ' ');
INSERT INTO answer VALUES (4424, 1106, 3, 'Signals that have a sharply peaked frequency distribution', ' ');
INSERT INTO answer VALUES (4428, 1107, 0, 'By connecting the radio''s power leads directly to the battery and by installing coaxial capacitors in line with the alternator leads', ' ');
INSERT INTO answer VALUES (4425, 1107, 1, 'By installing filter capacitors in series with the DC power lead and a blocking capacitor in the field lead', ' ');
INSERT INTO answer VALUES (4426, 1107, 2, 'By installing a noise suppression resistor and a blocking capacitor in both leads', ' ');
INSERT INTO answer VALUES (4427, 1107, 3, 'By installing a high-pass filter in series with the radio''s power lead and a low-pass filter in parallel with the field lead', ' ');
INSERT INTO answer VALUES (4430, 1108, 0, 'By installing a brute-force AC-line filter in series with the motor leads', ' ');
INSERT INTO answer VALUES (4429, 1108, 1, 'By installing a high-pass filter in series with the motor''s power leads', ' ');
INSERT INTO answer VALUES (4431, 1108, 2, 'By installing a bypass capacitor in series with the motor leads', ' ');
INSERT INTO answer VALUES (4432, 1108, 3, 'By using a ground-fault current interrupter in the circuit used to power the motor', ' ');
INSERT INTO answer VALUES (4435, 1109, 0, 'The appearance of unstable modulated or unmodulated signals at specific frequencies', ' ');
INSERT INTO answer VALUES (4433, 1109, 1, 'A loud AC hum in the audio output of your station receiver', ' ');
INSERT INTO answer VALUES (4434, 1109, 2, 'A clicking noise at intervals of a few seconds', ' ');
INSERT INTO answer VALUES (4436, 1109, 3, 'A whining type noise that continually pulses off and on', ' ');
INSERT INTO answer VALUES (4438, 1110, 0, 'Common-mode currents on the shield and conductors', ' ');
INSERT INTO answer VALUES (4437, 1110, 1, 'Low inductance ground connections at both ends of the shield', ' ');
INSERT INTO answer VALUES (4439, 1110, 2, 'Use of braided shielding material', ' ');
INSERT INTO answer VALUES (4440, 1110, 3, 'Tying all ground connections to a common point resulting in differential-mode currents in the shield', ' ');
INSERT INTO answer VALUES (4442, 1111, 0, 'Common-mode current', ' ');
INSERT INTO answer VALUES (4441, 1111, 1, 'Differential-mode current', ' ');
INSERT INTO answer VALUES (4443, 1111, 2, 'Reactive current only', ' ');
INSERT INTO answer VALUES (4444, 1111, 3, 'Return current', ' ');
INSERT INTO answer VALUES (4447, 1112, 0, 'Nearby signals may appear to be excessively wide even if they meet emission standards', ' ');
INSERT INTO answer VALUES (4445, 1112, 1, 'Received audio in the speech range might have an echo effect', ' ');
INSERT INTO answer VALUES (4446, 1112, 2, 'The audio frequency bandwidth of the received signal might be compressed', ' ');
INSERT INTO answer VALUES (4448, 1112, 3, 'FM signals can no longer be demodulated', ' ');
INSERT INTO answer VALUES (4452, 1113, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4449, 1113, 1, 'Arcing contacts in a thermostatically controlled device', ' ');
INSERT INTO answer VALUES (4450, 1113, 2, 'A defective doorbell or doorbell transformer inside a nearby residence', ' ');
INSERT INTO answer VALUES (4451, 1113, 3, 'A malfunctioning illuminated advertising display', ' ');
INSERT INTO answer VALUES (4454, 1114, 0, 'Nearby corroded metal joints are mixing and re-radiating the broadcast signals', ' ');
INSERT INTO answer VALUES (4453, 1114, 1, 'One or more of the broadcast stations is transmitting an over-modulated signal', ' ');
INSERT INTO answer VALUES (4455, 1114, 2, 'You are receiving skywave signals from a distant station', ' ');
INSERT INTO answer VALUES (4456, 1114, 3, 'Your station receiver IF amplifier stage is defective', ' ');
INSERT INTO answer VALUES (4457, 1115, 0, 'Resonance', ' ');
INSERT INTO answer VALUES (4458, 1115, 1, 'Capacitance', ' ');
INSERT INTO answer VALUES (4459, 1115, 2, 'Conductance', ' ');
INSERT INTO answer VALUES (4460, 1115, 3, 'Resistance', ' ');
INSERT INTO answer VALUES (4463, 1116, 0, 'The frequency at which the capacitive reactance equals the inductive reactance', ' ');
INSERT INTO answer VALUES (4461, 1116, 1, 'The highest frequency that will pass current', ' ');
INSERT INTO answer VALUES (4462, 1116, 2, 'The lowest frequency that will pass current', ' ');
INSERT INTO answer VALUES (4464, 1116, 3, 'The frequency at which the reactive impedance equals the resistive impedance', ' ');
INSERT INTO answer VALUES (4468, 1117, 0, 'Approximately equal to circuit resistance', ' ');
INSERT INTO answer VALUES (4465, 1117, 1, 'High, as compared to the circuit resistance', ' ');
INSERT INTO answer VALUES (4466, 1117, 2, 'Approximately equal to capacitive reactance', ' ');
INSERT INTO answer VALUES (4467, 1117, 3, 'Approximately equal to inductive reactance', ' ');
INSERT INTO answer VALUES (4469, 1118, 0, 'Approximately equal to circuit resistance', ' ');
INSERT INTO answer VALUES (4470, 1118, 1, 'Approximately equal to inductive reactance', ' ');
INSERT INTO answer VALUES (4471, 1118, 2, 'Low compared to the circuit resistance', ' ');
INSERT INTO answer VALUES (4472, 1118, 3, 'High compared to the circuit resistance', ' ');
INSERT INTO answer VALUES (4473, 1119, 0, 'Matching bandwidth is decreased', ' ');
INSERT INTO answer VALUES (4474, 1119, 1, 'Matching bandwidth is increased', ' ');
INSERT INTO answer VALUES (4475, 1119, 2, 'Matching range is increased', ' ');
INSERT INTO answer VALUES (4476, 1119, 3, 'It has no effect on impedance matching', ' ');
INSERT INTO answer VALUES (4478, 1120, 0, 'It is at a maximum', ' ');
INSERT INTO answer VALUES (4477, 1120, 1, 'It is at a minimum', ' ');
INSERT INTO answer VALUES (4479, 1120, 2, 'It equals 1 divided by the quantity 2 times pi, multiplied by the square root of inductance L multiplied by capacitance C', ' ');
INSERT INTO answer VALUES (4480, 1120, 3, 'It equals 2 multiplied by pi, multiplied by frequency, multiplied by inductance', ' ');
INSERT INTO answer VALUES (4481, 1121, 0, 'Minimum', ' ');
INSERT INTO answer VALUES (4482, 1121, 1, 'Maximum', ' ');
INSERT INTO answer VALUES (4483, 1121, 2, 'R/L', ' ');
INSERT INTO answer VALUES (4484, 1121, 3, 'L/R', ' ');
INSERT INTO answer VALUES (4487, 1122, 0, 'The voltage and current are in phase', ' ');
INSERT INTO answer VALUES (4485, 1122, 1, 'The voltage leads the current by 90 degrees', ' ');
INSERT INTO answer VALUES (4486, 1122, 2, 'The current leads the voltage by 90 degrees', ' ');
INSERT INTO answer VALUES (4488, 1122, 3, 'The voltage and current are 180 degrees out of phase', ' ');
INSERT INTO answer VALUES (4491, 1123, 0, 'Resistance divided by the reactance of either the inductance or capacitance', ' ');
INSERT INTO answer VALUES (4489, 1123, 1, 'Reactance of either the inductance or capacitance divided by the resistance', ' ');
INSERT INTO answer VALUES (4490, 1123, 2, 'Reactance of either the inductance or capacitance multiplied by the resistance', ' ');
INSERT INTO answer VALUES (4492, 1123, 3, 'Reactance of the inductance multiplied by the reactance of the capacitance', ' ');
INSERT INTO answer VALUES (4493, 1124, 0, 'Reactance of either the inductance or capacitance divided by the resistance', ' ');
INSERT INTO answer VALUES (4494, 1124, 1, 'Reactance of either the inductance or capacitance multiplied by the resistance', ' ');
INSERT INTO answer VALUES (4495, 1124, 2, 'Resistance divided by the reactance of either the inductance or capacitance', ' ');
INSERT INTO answer VALUES (4496, 1124, 3, 'Reactance of the inductance multiplied by the reactance of the capacitance', ' ');
INSERT INTO answer VALUES (4499, 1125, 0, '47.3 kHz', ' ');
INSERT INTO answer VALUES (4497, 1125, 1, '157.8 Hz', ' ');
INSERT INTO answer VALUES (4498, 1125, 2, '315.6 Hz', ' ');
INSERT INTO answer VALUES (4500, 1125, 3, '23.67 kHz', ' ');
INSERT INTO answer VALUES (4503, 1126, 0, '31.4 kHz', ' ');
INSERT INTO answer VALUES (4501, 1126, 1, '436.6 kHz', ' ');
INSERT INTO answer VALUES (4502, 1126, 2, '218.3 kHz', ' ');
INSERT INTO answer VALUES (4504, 1126, 3, '15.7 kHz', ' ');
INSERT INTO answer VALUES (4507, 1127, 0, 'Internal voltages increase', ' ');
INSERT INTO answer VALUES (4505, 1127, 1, 'Fewer components are needed for the same performance', ' ');
INSERT INTO answer VALUES (4506, 1127, 2, 'Parasitic effects are minimized', ' ');
INSERT INTO answer VALUES (4508, 1127, 3, 'Phase shift can become uncontrolled', ' ');
INSERT INTO answer VALUES (4511, 1128, 0, '3.56 MHz', ' ');
INSERT INTO answer VALUES (4509, 1128, 1, '44.72 MHz', ' ');
INSERT INTO answer VALUES (4510, 1128, 2, '22.36 MHz', ' ');
INSERT INTO answer VALUES (4512, 1128, 3, '1.78 MHz', ' ');
INSERT INTO answer VALUES (4513, 1129, 0, 'Lower losses', ' ');
INSERT INTO answer VALUES (4514, 1129, 1, 'Lower reactance', ' ');
INSERT INTO answer VALUES (4515, 1129, 2, 'Lower self-resonant frequency', ' ');
INSERT INTO answer VALUES (4516, 1129, 3, 'Higher self-resonant frequency', ' ');
INSERT INTO answer VALUES (4520, 1130, 0, '7.12 MHz', ' ');
INSERT INTO answer VALUES (4517, 1130, 1, '23.5 MHz', ' ');
INSERT INTO answer VALUES (4518, 1130, 2, '23.5 kHz', ' ');
INSERT INTO answer VALUES (4519, 1130, 3, '7.12 kHz', ' ');
INSERT INTO answer VALUES (4522, 1131, 0, 'One time constant', ' ');
INSERT INTO answer VALUES (4521, 1131, 1, 'An exponential rate of one', ' ');
INSERT INTO answer VALUES (4523, 1131, 2, 'One exponential period', ' ');
INSERT INTO answer VALUES (4524, 1131, 3, 'A time factor of one', ' ');
INSERT INTO answer VALUES (4528, 1132, 0, 'B', ' ');
INSERT INTO answer VALUES (4525, 1132, 1, 'G', ' ');
INSERT INTO answer VALUES (4526, 1132, 2, 'X', ' ');
INSERT INTO answer VALUES (4527, 1132, 3, 'Y', ' ');
INSERT INTO answer VALUES (4530, 1133, 0, 'Take the reciprocal of the magnitude and change the sign of the angle', ' ');
INSERT INTO answer VALUES (4529, 1133, 1, 'Take the reciprocal of the angle and change the sign of the magnitude', ' ');
INSERT INTO answer VALUES (4531, 1133, 2, 'Take the square root of the magnitude and add 180 degrees to the angle', ' ');
INSERT INTO answer VALUES (4532, 1133, 3, 'Square the magnitude and subtract 90 degrees from the angle', ' ');
INSERT INTO answer VALUES (4536, 1134, 0, '220 seconds', ' ');
INSERT INTO answer VALUES (4533, 1134, 1, '55 seconds', ' ');
INSERT INTO answer VALUES (4534, 1134, 2, '110 seconds', ' ');
INSERT INTO answer VALUES (4535, 1134, 3, '440 seconds', ' ');
INSERT INTO answer VALUES (4540, 1135, 0, 'It becomes the reciprocal', ' ');
INSERT INTO answer VALUES (4537, 1135, 1, 'It is unchanged', ' ');
INSERT INTO answer VALUES (4538, 1135, 2, 'The sign is reversed', ' ');
INSERT INTO answer VALUES (4539, 1135, 3, 'It is shifted by 90 degrees', ' ');
INSERT INTO answer VALUES (4543, 1136, 0, 'The imaginary part of admittance', ' ');
INSERT INTO answer VALUES (4541, 1136, 1, 'The magnetic impedance of a circuit', ' ');
INSERT INTO answer VALUES (4542, 1136, 2, 'The ratio of magnetic field to electric field', ' ');
INSERT INTO answer VALUES (4544, 1136, 3, 'A measure of the efficiency of a transformer', ' ');
INSERT INTO answer VALUES (4547, 1137, 0, '14.0 degrees with the voltage lagging the current', ' ');
INSERT INTO answer VALUES (4545, 1137, 1, '68.2 degrees with the voltage leading the current', ' ');
INSERT INTO answer VALUES (4546, 1137, 2, '14.0 degrees with the voltage leading the current', ' ');
INSERT INTO answer VALUES (4548, 1137, 3, '68.2 degrees with the voltage lagging the current', ' ');
INSERT INTO answer VALUES (4549, 1138, 0, '14 degrees with the voltage lagging the current', ' ');
INSERT INTO answer VALUES (4550, 1138, 1, '14 degrees with the voltage leading the current', ' ');
INSERT INTO answer VALUES (4551, 1138, 2, '76 degrees with the voltage leading the current', ' ');
INSERT INTO answer VALUES (4552, 1138, 3, '76 degrees with the voltage lagging the current', ' ');
INSERT INTO answer VALUES (4556, 1139, 0, 'Current leads voltage by 90 degrees', ' ');
INSERT INTO answer VALUES (4553, 1139, 1, 'Voltage and current are in phase', ' ');
INSERT INTO answer VALUES (4554, 1139, 2, 'Voltage and current are 180 degrees out of phase', ' ');
INSERT INTO answer VALUES (4555, 1139, 3, 'Voltage leads current by 90 degrees', ' ');
INSERT INTO answer VALUES (4557, 1140, 0, 'Voltage leads current by 90 degrees', ' ');
INSERT INTO answer VALUES (4558, 1140, 1, 'Current leads voltage by 90 degrees', ' ');
INSERT INTO answer VALUES (4559, 1140, 2, 'Voltage and current are 180 degrees out of phase', ' ');
INSERT INTO answer VALUES (4560, 1140, 3, 'Voltage and current are in phase', ' ');
INSERT INTO answer VALUES (4562, 1141, 0, '14 degrees with the voltage leading the current', ' ');
INSERT INTO answer VALUES (4561, 1141, 1, '14 degrees with the voltage lagging the current', ' ');
INSERT INTO answer VALUES (4563, 1141, 2, '76 degrees with the voltage lagging the current', ' ');
INSERT INTO answer VALUES (4564, 1141, 3, '76 degrees with the voltage leading the current', ' ');
INSERT INTO answer VALUES (4565, 1142, 0, 'The inverse of impedance', ' ');
INSERT INTO answer VALUES (4566, 1142, 1, 'The term for the gain of a field effect transistor', ' ');
INSERT INTO answer VALUES (4567, 1142, 2, 'The turns ratio of a transformer', ' ');
INSERT INTO answer VALUES (4568, 1142, 3, 'The inverse of Q factor', ' ');
INSERT INTO answer VALUES (4569, 1143, 0, '-jX', ' ');
INSERT INTO answer VALUES (4570, 1143, 1, '+jX', ' ');
INSERT INTO answer VALUES (4571, 1143, 2, 'Delta', ' ');
INSERT INTO answer VALUES (4572, 1143, 3, 'Omega', ' ');
INSERT INTO answer VALUES (4575, 1144, 0, 'By phase angle and magnitude', ' ');
INSERT INTO answer VALUES (4573, 1144, 1, 'By X and R values', ' ');
INSERT INTO answer VALUES (4574, 1144, 2, 'By real and imaginary parts', ' ');
INSERT INTO answer VALUES (4576, 1144, 3, 'By Y and G values', ' ');
INSERT INTO answer VALUES (4579, 1145, 0, 'A positive phase angle', ' ');
INSERT INTO answer VALUES (4577, 1145, 1, 'A positive magnitude', ' ');
INSERT INTO answer VALUES (4578, 1145, 2, 'A negative magnitude', ' ');
INSERT INTO answer VALUES (4580, 1145, 3, 'A negative phase angle', ' ');
INSERT INTO answer VALUES (4584, 1146, 0, 'Rectangular coordinates', ' ');
INSERT INTO answer VALUES (4581, 1146, 1, 'Maidenhead grid', ' ');
INSERT INTO answer VALUES (4582, 1146, 2, 'Faraday grid', ' ');
INSERT INTO answer VALUES (4583, 1146, 3, 'Elliptical coordinates', ' ');
INSERT INTO answer VALUES (4587, 1147, 0, 'Phasor diagram', ' ');
INSERT INTO answer VALUES (4585, 1147, 1, 'Venn diagram', ' ');
INSERT INTO answer VALUES (4586, 1147, 2, 'Near field diagram', ' ');
INSERT INTO answer VALUES (4588, 1147, 3, 'Far field diagram', ' ');
INSERT INTO answer VALUES (4590, 1148, 0, '50 ohms resistance in series with 25 ohms capacitive reactance', ' ');
INSERT INTO answer VALUES (4589, 1148, 1, '50 ohms resistance in series with 25 ohms inductive reactance', ' ');
INSERT INTO answer VALUES (4591, 1148, 2, '25 ohms resistance in series with 50 ohms inductive reactance', ' ');
INSERT INTO answer VALUES (4592, 1148, 3, '25 ohms resistance in series with 50 ohms capacitive reactance', ' ');
INSERT INTO answer VALUES (4596, 1149, 0, 'On the horizontal axis', ' ');
INSERT INTO answer VALUES (4593, 1149, 1, 'On the vertical axis', ' ');
INSERT INTO answer VALUES (4594, 1149, 2, 'On a line through the origin, slanted at 45 degrees', ' ');
INSERT INTO answer VALUES (4595, 1149, 3, 'On a horizontal line, offset vertically above the horizontal axis', ' ');
INSERT INTO answer VALUES (4600, 1150, 0, 'Polar coordinates', ' ');
INSERT INTO answer VALUES (4597, 1150, 1, 'Maidenhead grid', ' ');
INSERT INTO answer VALUES (4598, 1150, 2, 'Faraday grid', ' ');
INSERT INTO answer VALUES (4599, 1150, 3, 'Elliptical coordinates', ' ');
INSERT INTO answer VALUES (4601, 1151, 0, 'The X axis represents the resistive component and the Y axis represents the reactive component', ' ');
INSERT INTO answer VALUES (4602, 1151, 1, 'The X axis represents the reactive component and the Y axis represents the resistive component', ' ');
INSERT INTO answer VALUES (4603, 1151, 2, 'The X axis represents the phase angle and the Y axis represents the magnitude', ' ');
INSERT INTO answer VALUES (4604, 1151, 3, 'The X axis represents the magnitude and the Y axis represents the phase angle', ' ');
INSERT INTO answer VALUES (4606, 1152, 0, 'Point 4', ' ');
INSERT INTO answer VALUES (4605, 1152, 1, 'Point 2', ' ');
INSERT INTO answer VALUES (4607, 1152, 2, 'Point 5', ' ');
INSERT INTO answer VALUES (4608, 1152, 3, 'Point 6', ' ');
INSERT INTO answer VALUES (4610, 1153, 0, 'Point 3', ' ');
INSERT INTO answer VALUES (4609, 1153, 1, 'Point 1', ' ');
INSERT INTO answer VALUES (4611, 1153, 2, 'Point 7', ' ');
INSERT INTO answer VALUES (4612, 1153, 3, 'Point 8', ' ');
INSERT INTO answer VALUES (4613, 1154, 0, 'Point 1', ' ');
INSERT INTO answer VALUES (4614, 1154, 1, 'Point 3', ' ');
INSERT INTO answer VALUES (4615, 1154, 2, 'Point 7', ' ');
INSERT INTO answer VALUES (4616, 1154, 3, 'Point 8', ' ');
INSERT INTO answer VALUES (4617, 1155, 0, 'As frequency increases, RF current flows in a thinner layer of the conductor, closer to the surface', ' ');
INSERT INTO answer VALUES (4618, 1155, 1, 'As frequency decreases, RF current flows in a thinner layer of the conductor, closer to the surface', ' ');
INSERT INTO answer VALUES (4619, 1155, 2, 'Thermal effects on the surface of the conductor increase the impedance', ' ');
INSERT INTO answer VALUES (4620, 1155, 3, 'Thermal effects on the surface of the conductor decrease the impedance', ' ');
INSERT INTO answer VALUES (4622, 1156, 0, 'To avoid unwanted inductive reactance', ' ');
INSERT INTO answer VALUES (4621, 1156, 1, 'To increase the thermal time constant', ' ');
INSERT INTO answer VALUES (4623, 1156, 2, 'To maintain component lifetime', ' ');
INSERT INTO answer VALUES (4624, 1156, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4628, 1157, 0, 'Precision printed circuit conductors above a ground plane that provide constant impedance interconnects at microwave frequencies', ' ');
INSERT INTO answer VALUES (4625, 1157, 1, 'Lightweight transmission line made of common zip cord', ' ');
INSERT INTO answer VALUES (4626, 1157, 2, 'Miniature coax used for low power applications', ' ');
INSERT INTO answer VALUES (4627, 1157, 3, 'Short lengths of coax mounted on printed circuit boards to minimize time delay between microwave circuits', ' ');
INSERT INTO answer VALUES (4630, 1158, 0, 'To reduce phase shift along the connection', ' ');
INSERT INTO answer VALUES (4629, 1158, 1, 'To increase neutralizing resistance', ' ');
INSERT INTO answer VALUES (4631, 1158, 2, 'To increase compensating capacitance', ' ');
INSERT INTO answer VALUES (4632, 1158, 3, 'To reduce noise figure', ' ');
INSERT INTO answer VALUES (4635, 1159, 0, '0.866', ' ');
INSERT INTO answer VALUES (4633, 1159, 1, '1.73', ' ');
INSERT INTO answer VALUES (4634, 1159, 2, '0.5', ' ');
INSERT INTO answer VALUES (4636, 1159, 3, '0.577', ' ');
INSERT INTO answer VALUES (4640, 1160, 0, 'In a circle around the conductor', ' ');
INSERT INTO answer VALUES (4637, 1160, 1, 'In the same direction as the current', ' ');
INSERT INTO answer VALUES (4638, 1160, 2, 'In a direction opposite to the current', ' ');
INSERT INTO answer VALUES (4639, 1160, 3, 'In all directions; omni-directional', ' ');
INSERT INTO answer VALUES (4642, 1161, 0, '355 W', ' ');
INSERT INTO answer VALUES (4641, 1161, 1, '704 W', ' ');
INSERT INTO answer VALUES (4643, 1161, 2, '252 W', ' ');
INSERT INTO answer VALUES (4644, 1161, 3, '1.42 mW', ' ');
INSERT INTO answer VALUES (4648, 1162, 0, '600 watts', ' ');
INSERT INTO answer VALUES (4645, 1162, 1, '200 watts', ' ');
INSERT INTO answer VALUES (4646, 1162, 2, '1000 watts', ' ');
INSERT INTO answer VALUES (4647, 1162, 3, '1600 watts', ' ');
INSERT INTO answer VALUES (4650, 1163, 0, 'It is repeatedly exchanged between the associated magnetic and electric fields, but is not dissipated', ' ');
INSERT INTO answer VALUES (4649, 1163, 1, 'It is dissipated as heat in the circuit', ' ');
INSERT INTO answer VALUES (4651, 1163, 2, 'It is dissipated as kinetic energy in the circuit', ' ');
INSERT INTO answer VALUES (4652, 1163, 3, 'It is dissipated in the formation of inductive and capacitive fields', ' ');
INSERT INTO answer VALUES (4653, 1164, 0, 'By multiplying the apparent power by the power factor', ' ');
INSERT INTO answer VALUES (4654, 1164, 1, 'By dividing the reactive power by the power factor', ' ');
INSERT INTO answer VALUES (4655, 1164, 2, 'By dividing the apparent power by the power factor', ' ');
INSERT INTO answer VALUES (4656, 1164, 3, 'By multiplying the reactive power by the power factor', ' ');
INSERT INTO answer VALUES (4659, 1165, 0, '0.5', ' ');
INSERT INTO answer VALUES (4657, 1165, 1, '1.414', ' ');
INSERT INTO answer VALUES (4658, 1165, 2, '0.866', ' ');
INSERT INTO answer VALUES (4660, 1165, 3, '1.73', ' ');
INSERT INTO answer VALUES (4662, 1166, 0, '80 watts', ' ');
INSERT INTO answer VALUES (4661, 1166, 1, '400 watts', ' ');
INSERT INTO answer VALUES (4663, 1166, 2, '2000 watts', ' ');
INSERT INTO answer VALUES (4664, 1166, 3, '50 watts', ' ');
INSERT INTO answer VALUES (4666, 1167, 0, '100 watts', ' ');
INSERT INTO answer VALUES (4665, 1167, 1, '70.7 watts', ' ');
INSERT INTO answer VALUES (4667, 1167, 2, '141.4 watts', ' ');
INSERT INTO answer VALUES (4668, 1167, 3, '200 watts', ' ');
INSERT INTO answer VALUES (4669, 1168, 0, 'Wattless, nonproductive power', ' ');
INSERT INTO answer VALUES (4670, 1168, 1, 'Power consumed in wire resistance in an inductor', ' ');
INSERT INTO answer VALUES (4671, 1168, 2, 'Power lost because of capacitor leakage', ' ');
INSERT INTO answer VALUES (4672, 1168, 3, 'Power consumed in circuit Q', ' ');
INSERT INTO answer VALUES (4676, 1169, 0, '0.707', ' ');
INSERT INTO answer VALUES (4673, 1169, 1, '0.866', ' ');
INSERT INTO answer VALUES (4674, 1169, 2, '1.0', ' ');
INSERT INTO answer VALUES (4675, 1169, 3, '0.5', ' ');
INSERT INTO answer VALUES (4679, 1170, 0, 'In microwave circuits', ' ');
INSERT INTO answer VALUES (4677, 1170, 1, 'In high-current rectifier circuits', ' ');
INSERT INTO answer VALUES (4678, 1170, 2, 'In high-power audio circuits', ' ');
INSERT INTO answer VALUES (4680, 1170, 3, 'In very low-frequency RF circuits', ' ');
INSERT INTO answer VALUES (4681, 1171, 0, 'N-type', ' ');
INSERT INTO answer VALUES (4682, 1171, 1, 'P-type', ' ');
INSERT INTO answer VALUES (4683, 1171, 2, 'Bipolar', ' ');
INSERT INTO answer VALUES (4684, 1171, 3, 'Insulated gate', ' ');
INSERT INTO answer VALUES (4687, 1172, 0, 'Holes in P-type material and electrons in the N-type material are separated by the applied voltage, widening the depletion region', ' ');
INSERT INTO answer VALUES (4685, 1172, 1, 'Only P-type semiconductor material can conduct current', ' ');
INSERT INTO answer VALUES (4686, 1172, 2, 'Only N-type semiconductor material can conduct current', ' ');
INSERT INTO answer VALUES (4688, 1172, 3, 'Excess holes in P-type material combine with the electrons in N-type material, converting the entire diode into an insulator', ' ');
INSERT INTO answer VALUES (4691, 1173, 0, 'Acceptor impurity', ' ');
INSERT INTO answer VALUES (4689, 1173, 1, 'Insulator impurity', ' ');
INSERT INTO answer VALUES (4690, 1173, 2, 'N-type impurity', ' ');
INSERT INTO answer VALUES (4692, 1173, 3, 'Donor impurity', ' ');
INSERT INTO answer VALUES (4695, 1174, 0, 'An FET has higher input impedance', ' ');
INSERT INTO answer VALUES (4693, 1174, 1, 'They are both low impedance', ' ');
INSERT INTO answer VALUES (4694, 1174, 2, 'An FET has lower input impedance', ' ');
INSERT INTO answer VALUES (4696, 1174, 3, 'They are both high impedance', ' ');
INSERT INTO answer VALUES (4698, 1175, 0, 'The change in collector current with respect to base current', ' ');
INSERT INTO answer VALUES (4697, 1175, 1, 'The frequency at which the current gain is reduced to 0.707', ' ');
INSERT INTO answer VALUES (4699, 1175, 2, 'The breakdown voltage of the base to collector junction', ' ');
INSERT INTO answer VALUES (4700, 1175, 3, 'The switching speed', ' ');
INSERT INTO answer VALUES (4704, 1176, 0, 'Base-to-emitter voltage of approximately 0.6 to 0.7 volts', ' ');
INSERT INTO answer VALUES (4701, 1176, 1, 'Base-to-emitter resistance of approximately 6 to 7 ohms', ' ');
INSERT INTO answer VALUES (4702, 1176, 2, 'Base-to-emitter resistance of approximately 0.6 to 0.7 ohms', ' ');
INSERT INTO answer VALUES (4703, 1176, 3, 'Base-to-emitter voltage of approximately 6 to 7 volts', ' ');
INSERT INTO answer VALUES (4708, 1177, 0, 'Alpha cutoff frequency', ' ');
INSERT INTO answer VALUES (4705, 1177, 1, 'Corner frequency', ' ');
INSERT INTO answer VALUES (4706, 1177, 2, 'Alpha rejection frequency', ' ');
INSERT INTO answer VALUES (4707, 1177, 3, 'Beta cutoff frequency', ' ');
INSERT INTO answer VALUES (4709, 1178, 0, 'An FET that exhibits a current flow between source and drain when no gate voltage is applied', ' ');
INSERT INTO answer VALUES (4710, 1178, 1, 'An FET that has no current flow between source and drain when no gate voltage is applied', ' ');
INSERT INTO answer VALUES (4711, 1178, 2, 'Any FET without a channel', ' ');
INSERT INTO answer VALUES (4712, 1178, 3, 'Any FET for which holes are the majority carriers', ' ');
INSERT INTO answer VALUES (4714, 1179, 0, '4', ' ');
INSERT INTO answer VALUES (4713, 1179, 1, '2', ' ');
INSERT INTO answer VALUES (4715, 1179, 2, '5', ' ');
INSERT INTO answer VALUES (4716, 1179, 3, '6', ' ');
INSERT INTO answer VALUES (4717, 1180, 0, '1', ' ');
INSERT INTO answer VALUES (4718, 1180, 1, '2', ' ');
INSERT INTO answer VALUES (4719, 1180, 2, '3', ' ');
INSERT INTO answer VALUES (4720, 1180, 3, '6', ' ');
INSERT INTO answer VALUES (4724, 1181, 0, 'To reduce the chance of static damage to the gate', ' ');
INSERT INTO answer VALUES (4721, 1181, 1, 'To provide a voltage reference for the correct amount of reverse-bias gate voltage', ' ');
INSERT INTO answer VALUES (4722, 1181, 2, 'To protect the substrate from excessive voltages', ' ');
INSERT INTO answer VALUES (4723, 1181, 3, 'To keep the gate voltage within specifications and prevent the device from overheating', ' ');
INSERT INTO answer VALUES (4726, 1182, 0, 'A constant voltage drop under conditions of varying current', ' ');
INSERT INTO answer VALUES (4725, 1182, 1, 'A constant current drop under conditions of varying voltage', ' ');
INSERT INTO answer VALUES (4727, 1182, 2, 'A negative resistance region', ' ');
INSERT INTO answer VALUES (4728, 1182, 3, 'An internal capacitance that varies with the applied voltage', ' ');
INSERT INTO answer VALUES (4732, 1183, 0, 'Less forward voltage drop', ' ');
INSERT INTO answer VALUES (4729, 1183, 1, 'Much higher reverse voltage breakdown', ' ');
INSERT INTO answer VALUES (4730, 1183, 2, 'More constant reverse avalanche voltage', ' ');
INSERT INTO answer VALUES (4731, 1183, 3, 'Longer carrier retention time', ' ');
INSERT INTO answer VALUES (4734, 1184, 0, 'Forward bias', ' ');
INSERT INTO answer VALUES (4733, 1184, 1, 'Reverse bias', ' ');
INSERT INTO answer VALUES (4735, 1184, 2, 'Zero bias', ' ');
INSERT INTO answer VALUES (4736, 1184, 3, 'Inductive bias', ' ');
INSERT INTO answer VALUES (4737, 1185, 0, 'Varactor diode', ' ');
INSERT INTO answer VALUES (4738, 1185, 1, 'Tunnel diode', ' ');
INSERT INTO answer VALUES (4739, 1185, 2, 'Silicon-controlled rectifier', ' ');
INSERT INTO answer VALUES (4740, 1185, 3, 'Zener diode', ' ');
INSERT INTO answer VALUES (4744, 1186, 0, 'Low junction capacitance', ' ');
INSERT INTO answer VALUES (4741, 1186, 1, 'Extremely high reverse breakdown voltage', ' ');
INSERT INTO answer VALUES (4742, 1186, 2, 'Ability to dissipate large amounts of power', ' ');
INSERT INTO answer VALUES (4743, 1186, 3, 'Reverse bias controls its forward voltage drop', ' ');
INSERT INTO answer VALUES (4748, 1187, 0, 'As a VHF/UHF mixer or detector', ' ');
INSERT INTO answer VALUES (4745, 1187, 1, 'As a rectifier in high current power supplies', ' ');
INSERT INTO answer VALUES (4746, 1187, 2, 'As a variable capacitance in an automatic frequency control circuit', ' ');
INSERT INTO answer VALUES (4747, 1187, 3, 'As a constant voltage reference in a power supply', ' ');
INSERT INTO answer VALUES (4750, 1188, 0, 'Excessive junction temperature', ' ');
INSERT INTO answer VALUES (4749, 1188, 1, 'Excessive inverse voltage', ' ');
INSERT INTO answer VALUES (4751, 1188, 2, 'Insufficient forward voltage', ' ');
INSERT INTO answer VALUES (4752, 1188, 3, 'Charge carrier depletion', ' ');
INSERT INTO answer VALUES (4753, 1189, 0, 'Metal-semiconductor junction', ' ');
INSERT INTO answer VALUES (4754, 1189, 1, 'Electrolytic rectifier', ' ');
INSERT INTO answer VALUES (4755, 1189, 2, 'PIN junction', ' ');
INSERT INTO answer VALUES (4756, 1189, 3, 'Thermionic emission diode', ' ');
INSERT INTO answer VALUES (4759, 1190, 0, 'As an RF detector', ' ');
INSERT INTO answer VALUES (4757, 1190, 1, 'As a constant current source', ' ');
INSERT INTO answer VALUES (4758, 1190, 2, 'As a constant voltage source', ' ');
INSERT INTO answer VALUES (4760, 1190, 3, 'As a high-voltage rectifier', ' ');
INSERT INTO answer VALUES (4762, 1191, 0, '5', ' ');
INSERT INTO answer VALUES (4761, 1191, 1, '1', ' ');
INSERT INTO answer VALUES (4763, 1191, 2, '6', ' ');
INSERT INTO answer VALUES (4764, 1191, 3, '7', ' ');
INSERT INTO answer VALUES (4765, 1192, 0, 'Forward DC bias current', ' ');
INSERT INTO answer VALUES (4766, 1192, 1, 'A sub-harmonic pump signal', ' ');
INSERT INTO answer VALUES (4767, 1192, 2, 'Reverse voltage larger than the RF signal', ' ');
INSERT INTO answer VALUES (4768, 1192, 3, 'Capacitance of an RF coupling capacitor', ' ');
INSERT INTO answer VALUES (4769, 1193, 0, 'To prevent input noise from causing unstable output signals', ' ');
INSERT INTO answer VALUES (4770, 1193, 1, 'To allow the comparator to be used with AC input signals', ' ');
INSERT INTO answer VALUES (4771, 1193, 2, 'To cause the output to change states continually', ' ');
INSERT INTO answer VALUES (4772, 1193, 3, 'To increase the sensitivity', ' ');
INSERT INTO answer VALUES (4774, 1194, 0, 'The comparator changes its output state', ' ');
INSERT INTO answer VALUES (4773, 1194, 1, 'The IC input can be damaged', ' ');
INSERT INTO answer VALUES (4775, 1194, 2, 'The comparator enters latch-up', ' ');
INSERT INTO answer VALUES (4776, 1194, 3, 'The feedback loop becomes unstable', ' ');
INSERT INTO answer VALUES (4777, 1195, 0, 'Logic devices with 0, 1, and high-impedance output states', ' ');
INSERT INTO answer VALUES (4778, 1195, 1, 'Logic devices that utilize ternary math', ' ');
INSERT INTO answer VALUES (4779, 1195, 2, 'Low-power logic devices designed to operate at 3 volts', ' ');
INSERT INTO answer VALUES (4780, 1195, 3, 'Proprietary logic devices manufactured by Tri-State Devices', ' ');
INSERT INTO answer VALUES (4783, 1196, 0, 'It has the high input impedance of CMOS and the low output impedance of bipolar transistors', ' ');
INSERT INTO answer VALUES (4781, 1196, 1, 'Its simplicity results in much less expensive devices than standard CMOS', ' ');
INSERT INTO answer VALUES (4782, 1196, 2, 'It is immune to electrostatic damage', ' ');
INSERT INTO answer VALUES (4784, 1196, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4788, 1197, 0, 'Lower power consumption', ' ');
INSERT INTO answer VALUES (4785, 1197, 1, 'Differential output capability', ' ');
INSERT INTO answer VALUES (4786, 1197, 2, 'Lower distortion', ' ');
INSERT INTO answer VALUES (4787, 1197, 3, 'Immune to damage from static discharge', ' ');
INSERT INTO answer VALUES (4791, 1198, 0, 'The input switching threshold is about one-half the power supply voltage', ' ');
INSERT INTO answer VALUES (4789, 1198, 1, 'Large bypass capacitance is inherent', ' ');
INSERT INTO answer VALUES (4790, 1198, 2, 'The input switching threshold is about two times the power supply voltage', ' ');
INSERT INTO answer VALUES (4792, 1198, 3, 'Bandwidth is very limited', ' ');
INSERT INTO answer VALUES (4794, 1199, 0, 'A resistor connected to the positive or negative supply line used to establish a voltage when an input or output is an open circuit', ' ');
INSERT INTO answer VALUES (4793, 1199, 1, 'A resistor in a keying circuit used to reduce key clicks', ' ');
INSERT INTO answer VALUES (4795, 1199, 2, 'A resistor that ensures that an oscillator frequency does not drift', ' ');
INSERT INTO answer VALUES (4796, 1199, 3, 'A resistor connected to an op-amp output that prevents signals from exceeding the power supply voltage', ' ');
INSERT INTO answer VALUES (4798, 1200, 0, '2', ' ');
INSERT INTO answer VALUES (4797, 1200, 1, '1', ' ');
INSERT INTO answer VALUES (4799, 1200, 2, '3', ' ');
INSERT INTO answer VALUES (4800, 1200, 3, '4', ' ');
INSERT INTO answer VALUES (4802, 1201, 0, 'A programmable collection of logic gates and circuits in a single integrated circuit', ' ');
INSERT INTO answer VALUES (4801, 1201, 1, 'A logic circuit that can be modified during use', ' ');
INSERT INTO answer VALUES (4803, 1201, 2, 'Programmable equipment used for testing digital logic integrated circuits', ' ');
INSERT INTO answer VALUES (4804, 1201, 3, 'A type of transistor whose gain can be changed by digital logic circuits', ' ');
INSERT INTO answer VALUES (4808, 1202, 0, '4', ' ');
INSERT INTO answer VALUES (4805, 1202, 1, '1', ' ');
INSERT INTO answer VALUES (4806, 1202, 2, '2', ' ');
INSERT INTO answer VALUES (4807, 1202, 3, '3', ' ');
INSERT INTO answer VALUES (4811, 1203, 0, '5', ' ');
INSERT INTO answer VALUES (4809, 1203, 1, '2', ' ');
INSERT INTO answer VALUES (4810, 1203, 2, '4', ' ');
INSERT INTO answer VALUES (4812, 1203, 3, '6', ' ');
INSERT INTO answer VALUES (4813, 1204, 0, 'Harmonics and distortion could result', ' ');
INSERT INTO answer VALUES (4814, 1204, 1, 'Magnetic flux would increase with frequency', ' ');
INSERT INTO answer VALUES (4815, 1204, 2, 'RF susceptance would increase', ' ');
INSERT INTO answer VALUES (4816, 1204, 3, 'Temporary changes of the core permeability could result', ' ');
INSERT INTO answer VALUES (4817, 1205, 0, 'Motional capacitance, motional inductance, and loss resistance in series, all in parallel with a shunt capacitor representing electrode and stray capacitance', ' ');
INSERT INTO answer VALUES (4818, 1205, 1, 'Motional capacitance, motional inductance, loss resistance, and a capacitor representing electrode and stray capacitance all in parallel', ' ');
INSERT INTO answer VALUES (4819, 1205, 2, 'Motional capacitance, motional inductance, loss resistance, and a capacitor representing electrode and stray capacitance all in series', ' ');
INSERT INTO answer VALUES (4820, 1205, 3, 'Motional inductance and loss resistance in series, paralleled with motional capacitance and a capacitor representing electrode and stray capacitance', ' ');
INSERT INTO answer VALUES (4821, 1206, 0, 'Mechanical deformation of material by the application of a voltage', ' ');
INSERT INTO answer VALUES (4822, 1206, 1, 'Mechanical deformation of material by the application of a magnetic field', ' ');
INSERT INTO answer VALUES (4823, 1206, 2, 'Generation of electrical energy in the presence of light', ' ');
INSERT INTO answer VALUES (4824, 1206, 3, 'Increased conductivity in the presence of light', ' ');
INSERT INTO answer VALUES (4826, 1207, 0, 'Ferrite and brass', ' ');
INSERT INTO answer VALUES (4825, 1207, 1, 'Polystyrene and polyethylene', ' ');
INSERT INTO answer VALUES (4827, 1207, 2, 'Teflon and Delrin', ' ');
INSERT INTO answer VALUES (4828, 1207, 3, 'Cobalt and aluminum', ' ');
INSERT INTO answer VALUES (4831, 1208, 0, 'Ferrite toroids generally require fewer turns to produce a given inductance value', ' ');
INSERT INTO answer VALUES (4829, 1208, 1, 'Ferrite toroids generally have lower initial permeability', ' ');
INSERT INTO answer VALUES (4830, 1208, 2, 'Ferrite toroids generally have better temperature stability', ' ');
INSERT INTO answer VALUES (4832, 1208, 3, 'Ferrite toroids are easier to use with surface mount technology', ' ');
INSERT INTO answer VALUES (4836, 1209, 0, 'Permeability', ' ');
INSERT INTO answer VALUES (4833, 1209, 1, 'Thermal impedance', ' ');
INSERT INTO answer VALUES (4834, 1209, 2, 'Resistance', ' ');
INSERT INTO answer VALUES (4835, 1209, 3, 'Reactivity', ' ');
INSERT INTO answer VALUES (4837, 1210, 0, 'Magnetizing current', ' ');
INSERT INTO answer VALUES (4838, 1210, 1, 'Direct current', ' ');
INSERT INTO answer VALUES (4839, 1210, 2, 'Excitation current', ' ');
INSERT INTO answer VALUES (4840, 1210, 3, 'Stabilizing current', ' ');
INSERT INTO answer VALUES (4842, 1211, 0, 'Powdered-iron cores generally maintain their characteristics at higher currents', ' ');
INSERT INTO answer VALUES (4841, 1211, 1, 'Powdered-iron cores generally have greater initial permeability', ' ');
INSERT INTO answer VALUES (4843, 1211, 2, 'Powdered-iron cores generally require fewer turns to produce a given inductance', ' ');
INSERT INTO answer VALUES (4844, 1211, 3, 'Powdered-iron cores use smaller diameter wire for the same inductance', ' ');
INSERT INTO answer VALUES (4847, 1212, 0, 'Ferrite beads', ' ');
INSERT INTO answer VALUES (4845, 1212, 1, 'Electrolytic capacitors', ' ');
INSERT INTO answer VALUES (4846, 1212, 2, 'Butterworth filters', ' ');
INSERT INTO answer VALUES (4848, 1212, 3, 'Steel-core toroids', ' ');
INSERT INTO answer VALUES (4849, 1213, 0, 'Toroidal cores confine most of the magnetic field within the core material', ' ');
INSERT INTO answer VALUES (4850, 1213, 1, 'Toroidal cores make it easier to couple the magnetic energy into other components', ' ');
INSERT INTO answer VALUES (4851, 1213, 2, 'Toroidal cores exhibit greater hysteresis', ' ');
INSERT INTO answer VALUES (4852, 1213, 3, 'Toroidal cores have lower Q characteristics', ' ');
INSERT INTO answer VALUES (4854, 1214, 0, 'Brass', ' ');
INSERT INTO answer VALUES (4853, 1214, 1, 'Ceramic', ' ');
INSERT INTO answer VALUES (4855, 1214, 2, 'Ferrite', ' ');
INSERT INTO answer VALUES (4856, 1214, 3, 'Powdered iron', ' ');
INSERT INTO answer VALUES (4859, 1215, 0, 'The ability of the inductor''s core to store magnetic energy has been exceeded', ' ');
INSERT INTO answer VALUES (4857, 1215, 1, 'The inductor windings are over-coupled', ' ');
INSERT INTO answer VALUES (4858, 1215, 2, 'The inductor''s voltage rating is exceeded causing a flashover', ' ');
INSERT INTO answer VALUES (4860, 1215, 3, 'Adjacent inductors become over-coupled', ' ');
INSERT INTO answer VALUES (4861, 1216, 0, 'Inter-turn capacitance', ' ');
INSERT INTO answer VALUES (4862, 1216, 1, 'The skin effect', ' ');
INSERT INTO answer VALUES (4863, 1216, 2, 'Inductive kickback', ' ');
INSERT INTO answer VALUES (4864, 1216, 3, 'Non-linear core hysteresis', ' ');
INSERT INTO answer VALUES (4866, 1217, 0, 'Higher electron mobility', ' ');
INSERT INTO answer VALUES (4865, 1217, 1, 'Higher noise figures', ' ');
INSERT INTO answer VALUES (4867, 1217, 2, 'Lower junction voltage drop', ' ');
INSERT INTO answer VALUES (4868, 1217, 3, 'Lower transconductance', ' ');
INSERT INTO answer VALUES (4869, 1218, 0, 'DIP', ' ');
INSERT INTO answer VALUES (4870, 1218, 1, 'PLCC', ' ');
INSERT INTO answer VALUES (4871, 1218, 2, 'Ball grid array', ' ');
INSERT INTO answer VALUES (4872, 1218, 3, 'SOT', ' ');
INSERT INTO answer VALUES (4876, 1219, 0, 'Gallium nitride', ' ');
INSERT INTO answer VALUES (4873, 1219, 1, 'Silicon', ' ');
INSERT INTO answer VALUES (4874, 1219, 2, 'Silicon nitride', ' ');
INSERT INTO answer VALUES (4875, 1219, 3, 'Silicon dioxide', ' ');
INSERT INTO answer VALUES (4877, 1220, 0, '50 ohms', ' ');
INSERT INTO answer VALUES (4878, 1220, 1, '300 ohms', ' ');
INSERT INTO answer VALUES (4879, 1220, 2, '450 ohms', ' ');
INSERT INTO answer VALUES (4880, 1220, 3, '10 ohms', ' ');
INSERT INTO answer VALUES (4881, 1221, 0, '2 dB', ' ');
INSERT INTO answer VALUES (4882, 1221, 1, '-10 dB', ' ');
INSERT INTO answer VALUES (4883, 1221, 2, '44 dBm', ' ');
INSERT INTO answer VALUES (4884, 1221, 3, '-20 dBm', ' ');
INSERT INTO answer VALUES (4888, 1222, 0, 'Controlled gain, low noise figure, and constant input and output impedance over the specified frequency range', ' ');
INSERT INTO answer VALUES (4885, 1222, 1, 'The ability to retrieve information from a single signal even in the presence of other strong signals', ' ');
INSERT INTO answer VALUES (4886, 1222, 2, 'Plate current that is controlled by a control grid', ' ');
INSERT INTO answer VALUES (4887, 1222, 3, 'Nearly infinite gain, very high input impedance, and very low output impedance', ' ');
INSERT INTO answer VALUES (4892, 1223, 0, 'Microstrip', ' ');
INSERT INTO answer VALUES (4889, 1223, 1, 'Miniature coax', ' ');
INSERT INTO answer VALUES (4890, 1223, 2, 'Circular waveguide', ' ');
INSERT INTO answer VALUES (4891, 1223, 3, 'Parallel wire', ' ');
INSERT INTO answer VALUES (4893, 1224, 0, 'Through a resistor and/or RF choke connected to the amplifier output lead', ' ');
INSERT INTO answer VALUES (4894, 1224, 1, 'MMICs require no operating bias', ' ');
INSERT INTO answer VALUES (4895, 1224, 2, 'Through a capacitor and RF choke connected to the amplifier input lead', ' ');
INSERT INTO answer VALUES (4896, 1224, 3, 'Directly to the bias voltage (VCC IN) lead', ' ');
INSERT INTO answer VALUES (4900, 1225, 0, 'Surface mount', ' ');
INSERT INTO answer VALUES (4897, 1225, 1, 'TO-220', ' ');
INSERT INTO answer VALUES (4898, 1225, 2, 'Axial lead', ' ');
INSERT INTO answer VALUES (4899, 1225, 3, 'Radial lead', ' ');
INSERT INTO answer VALUES (4904, 1226, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (4901, 1226, 1, 'Smaller circuit area', ' ');
INSERT INTO answer VALUES (4902, 1226, 2, 'Shorter circuit-board traces', ' ');
INSERT INTO answer VALUES (4903, 1226, 3, 'Components have less parasitic inductance and capacitance', ' ');
INSERT INTO answer VALUES (4908, 1227, 0, 'A total of two rows of connecting pins placed on opposite sides of the package (Dual In-line Package)', ' ');
INSERT INTO answer VALUES (4905, 1227, 1, 'Package mounts in a direct inverted position', ' ');
INSERT INTO answer VALUES (4906, 1227, 2, 'Low leakage doubly insulated package', ' ');
INSERT INTO answer VALUES (4907, 1227, 3, 'Two chips in each package (Dual In Package)', ' ');
INSERT INTO answer VALUES (4911, 1228, 0, 'Excessive lead length', ' ');
INSERT INTO answer VALUES (4909, 1228, 1, 'Too many pins', ' ');
INSERT INTO answer VALUES (4910, 1228, 2, 'Epoxy coating is conductive above 300 MHz', ' ');
INSERT INTO answer VALUES (4912, 1228, 3, 'Unsuitable for combining analog and digital signals', ' ');
INSERT INTO answer VALUES (4915, 1229, 0, 'Electrons', ' ');
INSERT INTO answer VALUES (4913, 1229, 1, 'Protons', ' ');
INSERT INTO answer VALUES (4914, 1229, 2, 'Photons', ' ');
INSERT INTO answer VALUES (4916, 1229, 3, 'Holes', ' ');
INSERT INTO answer VALUES (4917, 1230, 0, 'It increases', ' ');
INSERT INTO answer VALUES (4918, 1230, 1, 'It decreases', ' ');
INSERT INTO answer VALUES (4919, 1230, 2, 'It stays the same', ' ');
INSERT INTO answer VALUES (4920, 1230, 3, 'It becomes unstable', ' ');
INSERT INTO answer VALUES (4924, 1231, 0, 'An LED and a phototransistor', ' ');
INSERT INTO answer VALUES (4921, 1231, 1, 'A lens and a photomultiplier', ' ');
INSERT INTO answer VALUES (4922, 1231, 2, 'A frequency modulated helium-neon laser', ' ');
INSERT INTO answer VALUES (4923, 1231, 3, 'An amplitude modulated helium-neon laser', ' ');
INSERT INTO answer VALUES (4926, 1232, 0, 'The conversion of light to electrical energy', ' ');
INSERT INTO answer VALUES (4925, 1232, 1, 'The conversion of voltage to current when exposed to light', ' ');
INSERT INTO answer VALUES (4927, 1232, 2, 'The conversion of electrical energy to mechanical energy', ' ');
INSERT INTO answer VALUES (4928, 1232, 3, 'The tendency of a battery to discharge when exposed to light', ' ');
INSERT INTO answer VALUES (4929, 1233, 0, 'A device that detects rotation of a control by interrupting a light source with a patterned wheel', ' ');
INSERT INTO answer VALUES (4930, 1233, 1, 'A device that measures the strength of a beam of light using analog to digital conversion', ' ');
INSERT INTO answer VALUES (4931, 1233, 2, 'A digital encryption device often used to encrypt spacecraft control signals', ' ');
INSERT INTO answer VALUES (4932, 1233, 3, 'A device for generating RTTY signals by means of a rotating light source', ' ');
INSERT INTO answer VALUES (4933, 1234, 0, 'A crystalline semiconductor', ' ');
INSERT INTO answer VALUES (4934, 1234, 1, 'An ordinary metal', ' ');
INSERT INTO answer VALUES (4935, 1234, 2, 'A heavy metal', ' ');
INSERT INTO answer VALUES (4936, 1234, 3, 'A liquid semiconductor', ' ');
INSERT INTO answer VALUES (4938, 1235, 0, 'A device that uses semiconductors to implement the functions of an electromechanical relay', ' ');
INSERT INTO answer VALUES (4937, 1235, 1, 'A relay using transistors to drive the relay coil', ' ');
INSERT INTO answer VALUES (4939, 1235, 2, 'A mechanical relay that latches in the on or off state each time it is pulsed', ' ');
INSERT INTO answer VALUES (4940, 1235, 3, 'A semiconductor passive delay line', ' ');
INSERT INTO answer VALUES (4943, 1236, 0, 'Optoisolators provide a very high degree of electrical isolation between a control circuit and the circuit being switched', ' ');
INSERT INTO answer VALUES (4941, 1236, 1, 'Optoisolators provide a low impedance link between a control circuit and a power circuit', ' ');
INSERT INTO answer VALUES (4942, 1236, 2, 'Optoisolators provide impedance matching between the control circuit and power circuit', ' ');
INSERT INTO answer VALUES (4944, 1236, 3, 'Optoisolators eliminate the effects of reflected light in the control circuit', ' ');
INSERT INTO answer VALUES (4948, 1237, 0, 'The relative fraction of light that is converted to current', ' ');
INSERT INTO answer VALUES (4945, 1237, 1, 'The output RF power divided by the input DC power', ' ');
INSERT INTO answer VALUES (4946, 1237, 2, 'Cost per kilowatt-hour generated', ' ');
INSERT INTO answer VALUES (4947, 1237, 3, 'The open-circuit voltage divided by the short-circuit current under full illumination', ' ');
INSERT INTO answer VALUES (4950, 1238, 0, 'Silicon', ' ');
INSERT INTO answer VALUES (4949, 1238, 1, 'Selenium', ' ');
INSERT INTO answer VALUES (4951, 1238, 2, 'Cadmium Sulfide', ' ');
INSERT INTO answer VALUES (4952, 1238, 3, 'Copper oxide', ' ');
INSERT INTO answer VALUES (4954, 1239, 0, '0.5 V', ' ');
INSERT INTO answer VALUES (4953, 1239, 1, '0.1 V', ' ');
INSERT INTO answer VALUES (4955, 1239, 2, '1.5 V', ' ');
INSERT INTO answer VALUES (4956, 1239, 3, '12 V', ' ');
INSERT INTO answer VALUES (4959, 1240, 0, 'A flip-flop', ' ');
INSERT INTO answer VALUES (4957, 1240, 1, 'An AND gate', ' ');
INSERT INTO answer VALUES (4958, 1240, 2, 'An OR gate', ' ');
INSERT INTO answer VALUES (4960, 1240, 3, 'A bipolar amplifier', ' ');
INSERT INTO answer VALUES (4961, 1241, 0, 'It produces one output pulse for every 10 input pulses', ' ');
INSERT INTO answer VALUES (4962, 1241, 1, 'It decodes a decimal number for display on a seven-segment LED display', ' ');
INSERT INTO answer VALUES (4963, 1241, 2, 'It produces 10 output pulses for every input pulse', ' ');
INSERT INTO answer VALUES (4964, 1241, 3, 'It decodes a binary number for display on a seven-segment LED display', ' ');
INSERT INTO answer VALUES (4966, 1242, 0, 'A flip-flop', ' ');
INSERT INTO answer VALUES (4965, 1242, 1, 'An XOR gate', ' ');
INSERT INTO answer VALUES (4967, 1242, 2, 'An OR gate', ' ');
INSERT INTO answer VALUES (4968, 1242, 3, 'A multiplexer', ' ');
INSERT INTO answer VALUES (4970, 1243, 0, '2', ' ');
INSERT INTO answer VALUES (4969, 1243, 1, '1', ' ');
INSERT INTO answer VALUES (4971, 1243, 2, '4', ' ');
INSERT INTO answer VALUES (4972, 1243, 3, '8', ' ');
INSERT INTO answer VALUES (4976, 1244, 0, 'Astable multivibrator', ' ');
INSERT INTO answer VALUES (4973, 1244, 1, 'Monostable multivibrator', ' ');
INSERT INTO answer VALUES (4974, 1244, 2, 'J-K flip-flop', ' ');
INSERT INTO answer VALUES (4975, 1244, 3, 'T flip-flop', ' ');
INSERT INTO answer VALUES (4977, 1245, 0, 'It switches momentarily to the opposite binary state and then returns to its original state after a set time', ' ');
INSERT INTO answer VALUES (4978, 1245, 1, 'It produces a continuous square wave oscillating between 1 and 0', ' ');
INSERT INTO answer VALUES (4979, 1245, 2, 'It stores one bit of data in either a 0 or 1 state', ' ');
INSERT INTO answer VALUES (4980, 1245, 3, 'It maintains a constant output voltage, regardless of variations in the input voltage', ' ');
INSERT INTO answer VALUES (4984, 1246, 0, 'It produces logic 0 at its output only when all inputs are logic 1', ' ');
INSERT INTO answer VALUES (4981, 1246, 1, 'It produces logic 0 at its output only when all inputs are logic 0', ' ');
INSERT INTO answer VALUES (4982, 1246, 2, 'It produces logic 1 at its output only when all inputs are logic 1', ' ');
INSERT INTO answer VALUES (4983, 1246, 3, 'It produces logic 0 at its output if some but not all inputs are logic 1', ' ');
INSERT INTO answer VALUES (4985, 1247, 0, 'It produces logic 1 at its output if any or all inputs are logic 1', ' ');
INSERT INTO answer VALUES (4986, 1247, 1, 'It produces logic 0 at its output if all inputs are logic 1', ' ');
INSERT INTO answer VALUES (4987, 1247, 2, 'It only produces logic 0 at its output when all inputs are logic 1', ' ');
INSERT INTO answer VALUES (4988, 1247, 3, 'It produces logic 1 at its output if all inputs are logic 0', ' ');
INSERT INTO answer VALUES (4991, 1248, 0, 'It produces logic 0 at its output if only one input is logic 1', ' ');
INSERT INTO answer VALUES (4989, 1248, 1, 'It produces logic 0 at its output only if all inputs are logic 0', ' ');
INSERT INTO answer VALUES (4990, 1248, 2, 'It produces logic 1 at its output only if all inputs are logic 1', ' ');
INSERT INTO answer VALUES (4992, 1248, 3, 'It produces logic 1 at its output if only one input is logic 1', ' ');
INSERT INTO answer VALUES (4995, 1249, 0, 'A list of inputs and corresponding outputs for a digital device', ' ');
INSERT INTO answer VALUES (4993, 1249, 1, 'A table of logic symbols that indicate the high logic states of an op-amp', ' ');
INSERT INTO answer VALUES (4994, 1249, 2, 'A diagram showing logic states when the digital device output is true', ' ');
INSERT INTO answer VALUES (4996, 1249, 3, 'A table of logic symbols that indicate the logic states of an op-amp', ' ');
INSERT INTO answer VALUES (5000, 1250, 0, 'Positive Logic', ' ');
INSERT INTO answer VALUES (4997, 1250, 1, 'Reverse Logic', ' ');
INSERT INTO answer VALUES (4998, 1250, 2, 'Assertive Logic', ' ');
INSERT INTO answer VALUES (4999, 1250, 3, 'Negative logic', ' ');
INSERT INTO answer VALUES (5001, 1251, 0, 'More than 180 degrees but less than 360 degrees', ' ');
INSERT INTO answer VALUES (5002, 1251, 1, 'Exactly 180 degrees', ' ');
INSERT INTO answer VALUES (5003, 1251, 2, 'The entire cycle', ' ');
INSERT INTO answer VALUES (5004, 1251, 3, 'Less than 180 degrees', ' ');
INSERT INTO answer VALUES (5005, 1252, 0, 'A type of amplifier that uses switching technology to achieve high efficiency', ' ');
INSERT INTO answer VALUES (5006, 1252, 1, 'A low power amplifier that uses a differential amplifier for improved linearity', ' ');
INSERT INTO answer VALUES (5007, 1252, 2, 'An amplifier that uses drift-mode FETs for high efficiency', ' ');
INSERT INTO answer VALUES (5008, 1252, 3, 'A frequency doubling amplifier', ' ');
INSERT INTO answer VALUES (5009, 1253, 0, 'A low-pass filter to remove switching signal components', ' ');
INSERT INTO answer VALUES (5010, 1253, 1, 'A high-pass filter to compensate for low gain at low frequencies', ' ');
INSERT INTO answer VALUES (5011, 1253, 2, 'A matched load resistor to prevent damage by switching transients', ' ');
INSERT INTO answer VALUES (5012, 1253, 3, 'A temperature compensating load resistor to improve linearity', ' ');
INSERT INTO answer VALUES (5013, 1254, 0, 'Approximately halfway between saturation and cutoff', ' ');
INSERT INTO answer VALUES (5014, 1254, 1, 'Where the load line intersects the voltage axis', ' ');
INSERT INTO answer VALUES (5015, 1254, 2, 'At a point where the bias resistor equals the load resistor', ' ');
INSERT INTO answer VALUES (5016, 1254, 3, 'At a point where the load line intersects the zero bias current curve', ' ');
INSERT INTO answer VALUES (5019, 1255, 0, 'Install parasitic suppressors and/or neutralize the stage', ' ');
INSERT INTO answer VALUES (5017, 1255, 1, 'Tune the stage for maximum SWR', ' ');
INSERT INTO answer VALUES (5018, 1255, 2, 'Tune both the input and output for maximum power', ' ');
INSERT INTO answer VALUES (5020, 1255, 3, 'Use a phase inverter in the output filter', ' ');
INSERT INTO answer VALUES (5022, 1256, 0, 'Push-pull', ' ');
INSERT INTO answer VALUES (5021, 1256, 1, 'Push-push', ' ');
INSERT INTO answer VALUES (5023, 1256, 2, 'Class C', ' ');
INSERT INTO answer VALUES (5024, 1256, 3, 'Class AB', ' ');
INSERT INTO answer VALUES (5028, 1257, 0, 'Signal distortion and excessive bandwidth', ' ');
INSERT INTO answer VALUES (5025, 1257, 1, 'Reduced intermodulation products', ' ');
INSERT INTO answer VALUES (5026, 1257, 2, 'Increased overall intelligibility', ' ');
INSERT INTO answer VALUES (5027, 1257, 3, 'Signal inversion', ' ');
INSERT INTO answer VALUES (5031, 1258, 0, 'By feeding a 180-degree out-of-phase portion of the output back to the input', ' ');
INSERT INTO answer VALUES (5029, 1258, 1, 'By increasing the driving power', ' ');
INSERT INTO answer VALUES (5030, 1258, 2, 'By reducing the driving power', ' ');
INSERT INTO answer VALUES (5032, 1258, 3, 'By feeding an in-phase component of the output back to the input', ' ');
INSERT INTO answer VALUES (5036, 1259, 0, 'The tuning capacitor is adjusted for minimum plate current, and the loading capacitor is adjusted for maximum permissible plate current', ' ');
INSERT INTO answer VALUES (5033, 1259, 1, 'The loading capacitor is set to maximum capacitance and the tuning capacitor is adjusted for minimum allowable plate current', ' ');
INSERT INTO answer VALUES (5034, 1259, 2, 'The tuning capacitor is set to maximum capacitance and the loading capacitor is adjusted for minimum plate permissible current', ' ');
INSERT INTO answer VALUES (5035, 1259, 3, 'The loading capacitor is adjusted to minimum plate current while alternately adjusting the tuning capacitor for maximum allowable plate current', ' ');
INSERT INTO answer VALUES (5038, 1260, 0, 'Voltage divider bias', ' ');
INSERT INTO answer VALUES (5037, 1260, 1, 'Load resistors', ' ');
INSERT INTO answer VALUES (5039, 1260, 2, 'Self bias', ' ');
INSERT INTO answer VALUES (5040, 1260, 3, 'Feedback', ' ');
INSERT INTO answer VALUES (5044, 1261, 0, 'Self bias', ' ');
INSERT INTO answer VALUES (5041, 1261, 1, 'Fixed bias', ' ');
INSERT INTO answer VALUES (5042, 1261, 2, 'Emitter bypass', ' ');
INSERT INTO answer VALUES (5043, 1261, 3, 'Output load resistor', ' ');
INSERT INTO answer VALUES (5047, 1262, 0, 'Common emitter', ' ');
INSERT INTO answer VALUES (5045, 1262, 1, 'Common base', ' ');
INSERT INTO answer VALUES (5046, 1262, 2, 'Common collector', ' ');
INSERT INTO answer VALUES (5048, 1262, 3, 'Emitter follower', ' ');
INSERT INTO answer VALUES (5052, 1263, 0, 'An amplifier with a low impedance output that follows the base input voltage', ' ');
INSERT INTO answer VALUES (5049, 1263, 1, 'A two-transistor amplifier with the emitters sharing a common bias resistor', ' ');
INSERT INTO answer VALUES (5050, 1263, 2, 'A differential amplifier with both inputs fed to the emitter of the input transistor', ' ');
INSERT INTO answer VALUES (5051, 1263, 3, 'An OR circuit with only one emitter used for output', ' ');
INSERT INTO answer VALUES (5054, 1264, 0, 'The power transistor is at saturation or cutoff most of the time', ' ');
INSERT INTO answer VALUES (5053, 1264, 1, 'Switching amplifiers operate at higher voltages', ' ');
INSERT INTO answer VALUES (5055, 1264, 2, 'Linear amplifiers have high gain resulting in higher harmonic content', ' ');
INSERT INTO answer VALUES (5056, 1264, 3, 'Switching amplifiers use push-pull circuits', ' ');
INSERT INTO answer VALUES (5059, 1265, 0, 'Use a resistor in series with the emitter', ' ');
INSERT INTO answer VALUES (5057, 1265, 1, 'Neutralization', ' ');
INSERT INTO answer VALUES (5058, 1265, 2, 'Select transistors with high beta', ' ');
INSERT INTO answer VALUES (5060, 1265, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5061, 1266, 0, 'Transmission of spurious signals', ' ');
INSERT INTO answer VALUES (5062, 1266, 1, 'Creation of parasitic oscillations', ' ');
INSERT INTO answer VALUES (5063, 1266, 2, 'Low efficiency', ' ');
INSERT INTO answer VALUES (5064, 1266, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5065, 1267, 0, 'Because they are relatively close in frequency to the desired signal', ' ');
INSERT INTO answer VALUES (5066, 1267, 1, 'Because they are relatively far in frequency from the desired signal', ' ');
INSERT INTO answer VALUES (5067, 1267, 2, 'Because they invert the sidebands causing distortion', ' ');
INSERT INTO answer VALUES (5068, 1267, 3, 'Because they maintain the sidebands, thus causing multiple duplicate signals', ' ');
INSERT INTO answer VALUES (5071, 1268, 0, 'Low input impedance', ' ');
INSERT INTO answer VALUES (5069, 1268, 1, 'High power gain', ' ');
INSERT INTO answer VALUES (5070, 1268, 2, 'High filament voltage', ' ');
INSERT INTO answer VALUES (5072, 1268, 3, 'Low bandwidth', ' ');
INSERT INTO answer VALUES (5076, 1269, 0, 'A capacitor is connected between the input and ground, another capacitor is connected between the output and ground, and an inductor is connected between input and output', ' ');
INSERT INTO answer VALUES (5073, 1269, 1, 'Two inductors are in series between the input and output, and a capacitor is connected between the two inductors and ground', ' ');
INSERT INTO answer VALUES (5074, 1269, 2, 'Two capacitors are in series between the input and output, and an inductor is connected between the two capacitors and ground', ' ');
INSERT INTO answer VALUES (5075, 1269, 3, 'An inductor is connected between the input and ground, another inductor is connected between the output and ground, and a capacitor is connected between the input and output', ' ');
INSERT INTO answer VALUES (5079, 1270, 0, 'It is a high-pass filter', ' ');
INSERT INTO answer VALUES (5077, 1270, 1, 'It is a low-pass filter', ' ');
INSERT INTO answer VALUES (5078, 1270, 2, 'It is a band-pass filter', ' ');
INSERT INTO answer VALUES (5080, 1270, 3, 'It is a notch filter', ' ');
INSERT INTO answer VALUES (5081, 1271, 0, 'Greater harmonic suppression', ' ');
INSERT INTO answer VALUES (5082, 1271, 1, 'Higher efficiency', ' ');
INSERT INTO answer VALUES (5083, 1271, 2, 'Does not require a capacitor', ' ');
INSERT INTO answer VALUES (5084, 1271, 3, 'Greater transformation range', ' ');
INSERT INTO answer VALUES (5087, 1272, 0, 'It cancels the reactive part of the impedance and changes the resistive part to a desired value', ' ');
INSERT INTO answer VALUES (5085, 1272, 1, 'It introduces negative resistance to cancel the resistive part of impedance', ' ');
INSERT INTO answer VALUES (5086, 1272, 2, 'It introduces transconductance to cancel the reactive part of impedance', ' ');
INSERT INTO answer VALUES (5088, 1272, 3, 'Reactive currents are dissipated in matched resistances', ' ');
INSERT INTO answer VALUES (5092, 1273, 0, 'A Chebyshev filter', ' ');
INSERT INTO answer VALUES (5089, 1273, 1, 'A Butterworth filter', ' ');
INSERT INTO answer VALUES (5090, 1273, 2, 'An active LC filter', ' ');
INSERT INTO answer VALUES (5091, 1273, 3, 'A passive op-amp filter', ' ');
INSERT INTO answer VALUES (5095, 1274, 0, 'Extremely sharp cutoff with one or more notches in the stop band', ' ');
INSERT INTO answer VALUES (5093, 1274, 1, 'Gradual passband rolloff with minimal stop band ripple', ' ');
INSERT INTO answer VALUES (5094, 1274, 2, 'Extremely flat response over its pass band with gradually rounded stop band corners', ' ');
INSERT INTO answer VALUES (5096, 1274, 3, 'Gradual passband rolloff with extreme stop band ripple', ' ');
INSERT INTO answer VALUES (5098, 1275, 0, 'A Pi-network with an additional series inductor on the output', ' ');
INSERT INTO answer VALUES (5097, 1275, 1, 'A Phase Inverter Load network', ' ');
INSERT INTO answer VALUES (5099, 1275, 2, 'A network with only three discrete parts', ' ');
INSERT INTO answer VALUES (5100, 1275, 3, 'A matching network in which all components are isolated from ground', ' ');
INSERT INTO answer VALUES (5101, 1276, 0, 'The relative frequencies of the individual crystals', ' ');
INSERT INTO answer VALUES (5102, 1276, 1, 'The DC voltage applied to the quartz crystal', ' ');
INSERT INTO answer VALUES (5103, 1276, 2, 'The gain of the RF stage preceding the filter', ' ');
INSERT INTO answer VALUES (5104, 1276, 3, 'The amplitude of the signals passing through the filter', ' ');
INSERT INTO answer VALUES (5108, 1277, 0, 'A filter with narrow bandwidth and steep skirts made using quartz crystals ~~', ' ');
INSERT INTO answer VALUES (5105, 1277, 1, 'A power supply filter made with interlaced quartz crystals', ' ');
INSERT INTO answer VALUES (5106, 1277, 2, 'An audio filter made with four quartz crystals that resonate at 1kHz intervals', ' ');
INSERT INTO answer VALUES (5107, 1277, 3, 'A filter using lattice-shaped quartz crystals for high-Q performance', ' ');
INSERT INTO answer VALUES (5110, 1278, 0, 'A cavity filter', ' ');
INSERT INTO answer VALUES (5109, 1278, 1, 'A crystal filter', ' ');
INSERT INTO answer VALUES (5111, 1278, 2, 'A DSP filter', ' ');
INSERT INTO answer VALUES (5112, 1278, 3, 'An L-C filter', ' ');
INSERT INTO answer VALUES (5115, 1279, 0, 'Shape factor', ' ');
INSERT INTO answer VALUES (5113, 1279, 1, 'Passband ripple', ' ');
INSERT INTO answer VALUES (5114, 1279, 2, 'Phase response', ' ');
INSERT INTO answer VALUES (5116, 1279, 3, 'Noise factor', ' ');
INSERT INTO answer VALUES (5117, 1280, 0, 'The Q of Pi-networks can be controlled', ' ');
INSERT INTO answer VALUES (5118, 1280, 1, 'L-networks cannot perform impedance transformation', ' ');
INSERT INTO answer VALUES (5119, 1280, 2, 'Pi-networks are more stable', ' ');
INSERT INTO answer VALUES (5120, 1280, 3, 'Pi-networks provide balanced input and output', ' ');
INSERT INTO answer VALUES (5124, 1281, 0, 'The conduction of a control element is varied to maintain a constant output voltage', ' ');
INSERT INTO answer VALUES (5121, 1281, 1, 'It has a ramp voltage as its output', ' ');
INSERT INTO answer VALUES (5122, 1281, 2, 'It eliminates the need for a pass transistor', ' ');
INSERT INTO answer VALUES (5123, 1281, 3, 'The control element duty cycle is proportional to the line or load conditions', ' ');
INSERT INTO answer VALUES (5127, 1282, 0, 'The controlled device''s duty cycle is changed to produce a constant average output voltage', ' ');
INSERT INTO answer VALUES (5125, 1282, 1, 'The resistance of a control element is varied in direct proportion to the line voltage or load current', ' ');
INSERT INTO answer VALUES (5126, 1282, 2, 'It is generally less efficient than a linear regulator', ' ');
INSERT INTO answer VALUES (5128, 1282, 3, 'It gives a ramp voltage at its output', ' ');
INSERT INTO answer VALUES (5129, 1283, 0, 'A Zener diode', ' ');
INSERT INTO answer VALUES (5130, 1283, 1, 'A tunnel diode', ' ');
INSERT INTO answer VALUES (5131, 1283, 2, 'An SCR', ' ');
INSERT INTO answer VALUES (5132, 1283, 3, 'A varactor diode', ' ');
INSERT INTO answer VALUES (5134, 1284, 0, 'A series regulator', ' ');
INSERT INTO answer VALUES (5133, 1284, 1, 'A series current source', ' ');
INSERT INTO answer VALUES (5135, 1284, 2, 'A shunt regulator', ' ');
INSERT INTO answer VALUES (5136, 1284, 3, 'A shunt current source', ' ');
INSERT INTO answer VALUES (5140, 1285, 0, 'A shunt regulator', ' ');
INSERT INTO answer VALUES (5137, 1285, 1, 'A constant current source', ' ');
INSERT INTO answer VALUES (5138, 1285, 2, 'A series regulator', ' ');
INSERT INTO answer VALUES (5139, 1285, 3, 'A shunt current source', ' ');
INSERT INTO answer VALUES (5143, 1286, 0, 'It controls the current supplied to the load', ' ');
INSERT INTO answer VALUES (5141, 1286, 1, 'It provides negative feedback to improve regulation', ' ');
INSERT INTO answer VALUES (5142, 1286, 2, 'It provides a constant load for the voltage source', ' ');
INSERT INTO answer VALUES (5144, 1286, 3, 'It provides D1 with current', ' ');
INSERT INTO answer VALUES (5145, 1287, 0, 'It bypasses rectifier output ripple around D1', ' ');
INSERT INTO answer VALUES (5146, 1287, 1, 'It is a brute force filter for the output', ' ');
INSERT INTO answer VALUES (5147, 1287, 2, 'To self-resonate at the hum frequency', ' ');
INSERT INTO answer VALUES (5148, 1287, 3, 'To provide fixed DC bias for Q1', ' ');
INSERT INTO answer VALUES (5151, 1288, 0, 'Linear voltage regulator', ' ');
INSERT INTO answer VALUES (5149, 1288, 1, 'Switching voltage regulator', ' ');
INSERT INTO answer VALUES (5150, 1288, 2, 'Grounded emitter amplifier', ' ');
INSERT INTO answer VALUES (5152, 1288, 3, 'Monostable multivibrator', ' ');
INSERT INTO answer VALUES (5155, 1289, 0, 'Prevention of battery damage due to overcharge', ' ');
INSERT INTO answer VALUES (5153, 1289, 1, 'Prevention of battery undercharge', ' ');
INSERT INTO answer VALUES (5154, 1289, 2, 'Control of electrolyte levels during battery discharge', ' ');
INSERT INTO answer VALUES (5156, 1289, 3, 'Matching of day and night charge rates', ' ');
INSERT INTO answer VALUES (5159, 1290, 0, 'The high frequency inverter design uses much smaller transformers and filter components for an equivalent power output', ' ');
INSERT INTO answer VALUES (5157, 1290, 1, 'The inverter design does not require any output filtering', ' ');
INSERT INTO answer VALUES (5158, 1290, 2, 'It uses a diode bridge rectifier for increased output', ' ');
INSERT INTO answer VALUES (5160, 1290, 3, 'It uses a large power factor compensation capacitor to recover power from the unused portion of the AC cycle', ' ');
INSERT INTO answer VALUES (5164, 1291, 0, 'Maintains nearly constant output voltage over a wide range of load current', ' ');
INSERT INTO answer VALUES (5161, 1291, 1, 'Permits a wide range of output voltage settings', ' ');
INSERT INTO answer VALUES (5162, 1291, 2, 'Provides a stable input impedance over a wide range of source voltage', ' ');
INSERT INTO answer VALUES (5163, 1291, 3, 'Maintains nearly constant output impedance over a wide range of load current', ' ');
INSERT INTO answer VALUES (5167, 1292, 0, 'Minimum input-to-output voltage required to maintain regulation', ' ');
INSERT INTO answer VALUES (5165, 1292, 1, 'Minimum input voltage for rated power dissipation', ' ');
INSERT INTO answer VALUES (5166, 1292, 2, 'Maximum output voltage drops when the input voltage is varied over its specified range', ' ');
INSERT INTO answer VALUES (5168, 1292, 3, 'Maximum that the output voltage may decrease at rated load', ' ');
INSERT INTO answer VALUES (5171, 1293, 0, 'Voltage difference from input to output multiplied by output current', ' ');
INSERT INTO answer VALUES (5169, 1293, 1, 'Input voltage multiplied by input current', ' ');
INSERT INTO answer VALUES (5170, 1293, 2, 'Input voltage divided by output current', ' ');
INSERT INTO answer VALUES (5172, 1293, 3, 'Output voltage multiplied by output current', ' ');
INSERT INTO answer VALUES (5176, 1294, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5173, 1294, 1, 'Equalize the voltage across each capacitor', ' ');
INSERT INTO answer VALUES (5174, 1294, 2, 'Discharge the capacitors when voltage is removed', ' ');
INSERT INTO answer VALUES (5175, 1294, 3, 'Provide a minimum load on the supply', ' ');
INSERT INTO answer VALUES (5180, 1295, 0, 'To allow the filter capacitors to charge gradually', ' ');
INSERT INTO answer VALUES (5177, 1295, 1, 'To provide a dual-voltage output for reduced power applications', ' ');
INSERT INTO answer VALUES (5178, 1295, 2, 'To compensate for variations of the incoming line voltage', ' ');
INSERT INTO answer VALUES (5179, 1295, 3, 'To allow for remote control of the power supply', ' ');
INSERT INTO answer VALUES (5182, 1296, 0, 'A reactance modulator on the oscillator', ' ');
INSERT INTO answer VALUES (5181, 1296, 1, 'A balanced modulator on the audio amplifier', ' ');
INSERT INTO answer VALUES (5183, 1296, 2, 'A reactance modulator on the final amplifier', ' ');
INSERT INTO answer VALUES (5184, 1296, 3, 'A balanced modulator on the oscillator', ' ');
INSERT INTO answer VALUES (5188, 1297, 0, 'To produce PM or FM signals by using an electrically variable inductance or capacitance', ' ');
INSERT INTO answer VALUES (5185, 1297, 1, 'To produce PM signals by using an electrically variable resistance', ' ');
INSERT INTO answer VALUES (5186, 1297, 2, 'To produce AM signals by using an electrically variable inductance or capacitance', ' ');
INSERT INTO answer VALUES (5187, 1297, 3, 'To produce AM signals by using an electrically variable resistance', ' ');
INSERT INTO answer VALUES (5192, 1298, 0, 'A circuit for detecting FM signals', ' ');
INSERT INTO answer VALUES (5189, 1298, 1, 'An FM generator circuit', ' ');
INSERT INTO answer VALUES (5190, 1298, 2, 'A circuit for filtering two closely adjacent signals', ' ');
INSERT INTO answer VALUES (5191, 1298, 3, 'An automatic band-switching circuit', ' ');
INSERT INTO answer VALUES (5193, 1299, 0, 'By using a balanced modulator followed by a filter', ' ');
INSERT INTO answer VALUES (5194, 1299, 1, 'By using a reactance modulator followed by a mixer', ' ');
INSERT INTO answer VALUES (5195, 1299, 2, 'By using a loop modulator followed by a mixer', ' ');
INSERT INTO answer VALUES (5196, 1299, 3, 'By driving a product detector with a DSB signal', ' ');
INSERT INTO answer VALUES (5200, 1300, 0, 'A pre-emphasis network', ' ');
INSERT INTO answer VALUES (5197, 1300, 1, 'A de-emphasis network', ' ');
INSERT INTO answer VALUES (5198, 1300, 2, 'A heterodyne suppressor', ' ');
INSERT INTO answer VALUES (5199, 1300, 3, 'A heterodyne enhancer', ' ');
INSERT INTO answer VALUES (5201, 1301, 0, 'For compatibility with transmitters using phase modulation', ' ');
INSERT INTO answer VALUES (5202, 1301, 1, 'To reduce impulse noise reception', ' ');
INSERT INTO answer VALUES (5203, 1301, 2, 'For higher efficiency', ' ');
INSERT INTO answer VALUES (5204, 1301, 3, 'To remove third-order distortion products', ' ');
INSERT INTO answer VALUES (5206, 1302, 0, 'The frequency range occupied by a message signal prior to modulation', ' ');
INSERT INTO answer VALUES (5205, 1302, 1, 'The lowest frequency band that the transmitter or receiver covers', ' ');
INSERT INTO answer VALUES (5207, 1302, 2, 'The unmodulated bandwidth of the transmitted signal', ' ');
INSERT INTO answer VALUES (5208, 1302, 3, 'The basic oscillator frequency in an FM transmitter that is multiplied to increase the deviation and carrier frequency', ' ');
INSERT INTO answer VALUES (5211, 1303, 0, 'The two input frequencies along with their sum and difference frequencies', ' ');
INSERT INTO answer VALUES (5209, 1303, 1, 'Two and four times the original frequency', ' ');
INSERT INTO answer VALUES (5210, 1303, 2, 'The square root of the product of input frequencies', ' ');
INSERT INTO answer VALUES (5212, 1303, 3, '1.414 and 0.707 times the input frequency', ' ');
INSERT INTO answer VALUES (5213, 1304, 0, 'Spurious mixer products are generated', ' ');
INSERT INTO answer VALUES (5214, 1304, 1, 'Mixer blanking occurs', ' ');
INSERT INTO answer VALUES (5215, 1304, 2, 'Automatic limiting occurs', ' ');
INSERT INTO answer VALUES (5216, 1304, 3, 'A beat frequency is generated', ' ');
INSERT INTO answer VALUES (5217, 1305, 0, 'By rectification and filtering of RF signals', ' ');
INSERT INTO answer VALUES (5218, 1305, 1, 'By breakdown of the Zener voltage', ' ');
INSERT INTO answer VALUES (5219, 1305, 2, 'By mixing signals with noise in the transition region of the diode', ' ');
INSERT INTO answer VALUES (5220, 1305, 3, 'By sensing the change of reactance in the diode with respect to frequency', ' ');
INSERT INTO answer VALUES (5223, 1306, 0, 'Product detector', ' ');
INSERT INTO answer VALUES (5221, 1306, 1, 'Discriminator', ' ');
INSERT INTO answer VALUES (5222, 1306, 2, 'Phase detector', ' ');
INSERT INTO answer VALUES (5224, 1306, 3, 'Phase comparator', ' ');
INSERT INTO answer VALUES (5227, 1307, 0, 'Incoming RF is digitized by an analog-to-digital converter without being mixed with a local oscillator signal', ' ');
INSERT INTO answer VALUES (5225, 1307, 1, 'Software is converted from source code to object code during operation of the receiver', ' ');
INSERT INTO answer VALUES (5226, 1307, 2, 'Incoming RF is converted to a control voltage for a voltage controlled oscillator', ' ');
INSERT INTO answer VALUES (5228, 1307, 3, 'A switching mixer is used to generate I and Q signals directly from the RF input', ' ');
INSERT INTO answer VALUES (5229, 1308, 0, 'An adaptive filter', ' ');
INSERT INTO answer VALUES (5230, 1308, 1, 'A crystal-lattice filter', ' ');
INSERT INTO answer VALUES (5231, 1308, 2, 'A Hilbert-transform filter', ' ');
INSERT INTO answer VALUES (5232, 1308, 3, 'A phase-inverting filter', ' ');
INSERT INTO answer VALUES (5235, 1309, 0, 'A Hilbert-transform filter', ' ');
INSERT INTO answer VALUES (5233, 1309, 1, 'An adaptive filter', ' ');
INSERT INTO answer VALUES (5234, 1309, 2, 'A notch filter', ' ');
INSERT INTO answer VALUES (5236, 1309, 3, 'An elliptical filter', ' ');
INSERT INTO answer VALUES (5240, 1310, 0, 'Signals are combined in quadrature phase relationship', ' ');
INSERT INTO answer VALUES (5237, 1310, 1, 'Mixing products are converted to voltages and subtracted by adder circuits', ' ');
INSERT INTO answer VALUES (5238, 1310, 2, 'A frequency synthesizer removes the unwanted sidebands', ' ');
INSERT INTO answer VALUES (5239, 1310, 3, 'Varying quartz crystal characteristics emulated in digital form', ' ');
INSERT INTO answer VALUES (5242, 1311, 0, 'At least twice the rate of the highest frequency component of the signal', ' ');
INSERT INTO answer VALUES (5241, 1311, 1, 'At least half the rate of the highest frequency component of the signal', ' ');
INSERT INTO answer VALUES (5243, 1311, 2, 'At the same rate as the highest frequency component of the signal', ' ');
INSERT INTO answer VALUES (5244, 1311, 3, 'At four times the rate of the highest frequency component of the signal', ' ');
INSERT INTO answer VALUES (5248, 1312, 0, '10 bits', ' ');
INSERT INTO answer VALUES (5245, 1312, 1, '4 bits', ' ');
INSERT INTO answer VALUES (5246, 1312, 2, '6 bits', ' ');
INSERT INTO answer VALUES (5247, 1312, 3, '8 bits', ' ');
INSERT INTO answer VALUES (5251, 1313, 0, 'Converting digital signals from the time domain to the frequency domain', ' ');
INSERT INTO answer VALUES (5249, 1313, 1, 'Converting analog signals to digital form', ' ');
INSERT INTO answer VALUES (5250, 1313, 2, 'Converting digital signals to analog form', ' ');
INSERT INTO answer VALUES (5252, 1313, 3, 'Converting 8-bit data to 16-bit data', ' ');
INSERT INTO answer VALUES (5254, 1314, 0, 'Reducing the effective sample rate by removing samples', ' ');
INSERT INTO answer VALUES (5253, 1314, 1, 'Converting data to binary code decimal form', ' ');
INSERT INTO answer VALUES (5255, 1314, 2, 'Attenuating the signal', ' ');
INSERT INTO answer VALUES (5256, 1314, 3, 'Removing unnecessary significant digits', ' ');
INSERT INTO answer VALUES (5257, 1315, 0, 'It removes high-frequency signal components that would otherwise be reproduced as lower frequency components', ' ');
INSERT INTO answer VALUES (5258, 1315, 1, 'It peaks the response of the decimator, improving bandwidth', ' ');
INSERT INTO answer VALUES (5259, 1315, 2, 'It removes low-frequency signal components to eliminate the need for DC restoration', ' ');
INSERT INTO answer VALUES (5260, 1315, 3, 'It notches out the sampling frequency to avoid sampling errors', ' ');
INSERT INTO answer VALUES (5261, 1316, 0, 'Sample rate', ' ');
INSERT INTO answer VALUES (5262, 1316, 1, 'Sample width in bits', ' ');
INSERT INTO answer VALUES (5263, 1316, 2, 'Sample clock phase noise', ' ');
INSERT INTO answer VALUES (5264, 1316, 3, 'Processor latency', ' ');
INSERT INTO answer VALUES (5266, 1317, 0, 'Reference voltage level and sample width in bits', ' ');
INSERT INTO answer VALUES (5265, 1317, 1, 'Sample clock phase noise', ' ');
INSERT INTO answer VALUES (5267, 1317, 2, 'Data storage transfer rate', ' ');
INSERT INTO answer VALUES (5268, 1317, 3, 'Missing codes and jitter', ' ');
INSERT INTO answer VALUES (5269, 1318, 0, 'FIR filters can delay all frequency components of the signal by the same amount', ' ');
INSERT INTO answer VALUES (5270, 1318, 1, 'FIR filters are easier to implement for a given set of passband rolloff requirements', ' ');
INSERT INTO answer VALUES (5271, 1318, 2, 'FIR filters can respond faster to impulses', ' ');
INSERT INTO answer VALUES (5272, 1318, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5276, 1319, 0, 'Provide incremental signal delays for filter algorithms', ' ');
INSERT INTO answer VALUES (5273, 1319, 1, 'To reduce excess signal pressure levels', ' ');
INSERT INTO answer VALUES (5274, 1319, 2, 'Provide access for debugging software', ' ');
INSERT INTO answer VALUES (5275, 1319, 3, 'Select the point at which baseband signals are generated', ' ');
INSERT INTO answer VALUES (5278, 1320, 0, 'More taps', ' ');
INSERT INTO answer VALUES (5277, 1320, 1, 'Higher data rate', ' ');
INSERT INTO answer VALUES (5279, 1320, 2, 'Complex phasor representations', ' ');
INSERT INTO answer VALUES (5280, 1320, 3, 'Double-precision math routines', ' ');
INSERT INTO answer VALUES (5281, 1321, 0, 'Very low', ' ');
INSERT INTO answer VALUES (5282, 1321, 1, 'Very high', ' ');
INSERT INTO answer VALUES (5283, 1321, 2, '100 ohms', ' ');
INSERT INTO answer VALUES (5284, 1321, 3, '1000 ohms', ' ');
INSERT INTO answer VALUES (5288, 1322, 0, 'Undesired oscillations added to the desired signal', ' ');
INSERT INTO answer VALUES (5285, 1322, 1, 'An echo caused by a long time delay', ' ');
INSERT INTO answer VALUES (5286, 1322, 2, 'A reduction in high frequency response', ' ');
INSERT INTO answer VALUES (5287, 1322, 3, 'Partial cancellation of the signal over a range of frequencies', ' ');
INSERT INTO answer VALUES (5292, 1323, 0, 'Very high', ' ');
INSERT INTO answer VALUES (5289, 1323, 1, '100 ohms', ' ');
INSERT INTO answer VALUES (5290, 1323, 2, '1000 ohms', ' ');
INSERT INTO answer VALUES (5291, 1323, 3, 'Very low', ' ');
INSERT INTO answer VALUES (5295, 1324, 0, 'The differential input voltage needed to bring the open loop output voltage to zero', ' ');
INSERT INTO answer VALUES (5293, 1324, 1, 'The output voltage of the op-amp minus its input voltage', ' ');
INSERT INTO answer VALUES (5294, 1324, 2, 'The difference between the output voltage of the op-amp and the input voltage required in the immediately following stage', ' ');
INSERT INTO answer VALUES (5296, 1324, 3, 'The potential between the amplifier input terminals of the op-amp in an open loop condition', ' ');
INSERT INTO answer VALUES (5297, 1325, 0, 'Restrict both gain and Q', ' ');
INSERT INTO answer VALUES (5298, 1325, 1, 'Restrict gain but increase Q', ' ');
INSERT INTO answer VALUES (5299, 1325, 2, 'Restrict Q but increase gain', ' ');
INSERT INTO answer VALUES (5300, 1325, 3, 'Increase both gain and Q', ' ');
INSERT INTO answer VALUES (5302, 1326, 0, 'The frequency at which the open-loop gain of the amplifier equals one', ' ');
INSERT INTO answer VALUES (5301, 1326, 1, 'The maximum frequency for a filter circuit using that type of amplifier', ' ');
INSERT INTO answer VALUES (5303, 1326, 2, 'The gain of the amplifier at a filter''s cutoff frequency', ' ');
INSERT INTO answer VALUES (5304, 1326, 3, 'The frequency at which the amplifier''s offset voltage is zero', ' ');
INSERT INTO answer VALUES (5307, 1327, 0, '47', ' ');
INSERT INTO answer VALUES (5305, 1327, 1, '0.21', ' ');
INSERT INTO answer VALUES (5306, 1327, 2, '94', ' ');
INSERT INTO answer VALUES (5308, 1327, 3, '24', ' ');
INSERT INTO answer VALUES (5312, 1328, 0, 'It does not vary with frequency', ' ');
INSERT INTO answer VALUES (5309, 1328, 1, 'It increases linearly with increasing frequency', ' ');
INSERT INTO answer VALUES (5310, 1328, 2, 'It decreases linearly with increasing frequency', ' ');
INSERT INTO answer VALUES (5311, 1328, 3, 'It decreases logarithmically with increasing frequency', ' ');
INSERT INTO answer VALUES (5316, 1329, 0, '-2.3 volts', ' ');
INSERT INTO answer VALUES (5313, 1329, 1, '0.23 volts', ' ');
INSERT INTO answer VALUES (5314, 1329, 2, '2.3 volts', ' ');
INSERT INTO answer VALUES (5315, 1329, 3, '-0.23 volts', ' ');
INSERT INTO answer VALUES (5319, 1330, 0, '38', ' ');
INSERT INTO answer VALUES (5317, 1330, 1, '1', ' ');
INSERT INTO answer VALUES (5318, 1330, 2, '0.03', ' ');
INSERT INTO answer VALUES (5320, 1330, 3, '76', ' ');
INSERT INTO answer VALUES (5322, 1331, 0, '14', ' ');
INSERT INTO answer VALUES (5321, 1331, 1, '28', ' ');
INSERT INTO answer VALUES (5323, 1331, 2, '7', ' ');
INSERT INTO answer VALUES (5324, 1331, 3, '0.07', ' ');
INSERT INTO answer VALUES (5325, 1332, 0, 'A high-gain, direct-coupled differential amplifier with very high input impedance and very low output impedance', ' ');
INSERT INTO answer VALUES (5326, 1332, 1, 'A digital audio amplifier whose characteristics are determined by components external to the amplifier', ' ');
INSERT INTO answer VALUES (5327, 1332, 2, 'An amplifier used to increase the average output of frequency modulated amateur signals to the legal limit', ' ');
INSERT INTO answer VALUES (5328, 1332, 3, 'A RF amplifier used in the UHF and microwave regions', ' ');
INSERT INTO answer VALUES (5332, 1333, 0, 'Colpitts, Hartley and Pierce', ' ');
INSERT INTO answer VALUES (5329, 1333, 1, 'Taft, Pierce and negative feedback', ' ');
INSERT INTO answer VALUES (5330, 1333, 2, 'Pierce, Fenner and Beane', ' ');
INSERT INTO answer VALUES (5331, 1333, 3, 'Taft, Hartley and Pierce', ' ');
INSERT INTO answer VALUES (5335, 1334, 0, 'Changes in oscillator frequency due to mechanical vibration', ' ');
INSERT INTO answer VALUES (5333, 1334, 1, 'An IC used for amplifying microphone signals', ' ');
INSERT INTO answer VALUES (5334, 1334, 2, 'Distortion caused by RF pickup on the microphone cable', ' ');
INSERT INTO answer VALUES (5336, 1334, 3, 'Excess loading of the microphone by an oscillator', ' ');
INSERT INTO answer VALUES (5337, 1335, 0, 'Through a tapped coil', ' ');
INSERT INTO answer VALUES (5338, 1335, 1, 'Through a capacitive divider', ' ');
INSERT INTO answer VALUES (5339, 1335, 2, 'Through link coupling', ' ');
INSERT INTO answer VALUES (5340, 1335, 3, 'Through a neutralizing capacitor', ' ');
INSERT INTO answer VALUES (5343, 1336, 0, 'Through a capacitive divider', ' ');
INSERT INTO answer VALUES (5341, 1336, 1, 'Through a tapped coil', ' ');
INSERT INTO answer VALUES (5342, 1336, 2, 'Through link coupling', ' ');
INSERT INTO answer VALUES (5344, 1336, 3, 'Through a neutralizing capacitor', ' ');
INSERT INTO answer VALUES (5348, 1337, 0, 'Through a quartz crystal', ' ');
INSERT INTO answer VALUES (5345, 1337, 1, 'Through a tapped coil', ' ');
INSERT INTO answer VALUES (5346, 1337, 2, 'Through link coupling', ' ');
INSERT INTO answer VALUES (5347, 1337, 3, 'Through a neutralizing capacitor', ' ');
INSERT INTO answer VALUES (5350, 1338, 0, 'Colpitts and Hartley', ' ');
INSERT INTO answer VALUES (5349, 1338, 1, 'Pierce and Zener', ' ');
INSERT INTO answer VALUES (5351, 1338, 2, 'Armstrong and deForest', ' ');
INSERT INTO answer VALUES (5352, 1338, 3, 'Negative feedback and balanced feedback', ' ');
INSERT INTO answer VALUES (5356, 1339, 0, 'Mechanically isolate the oscillator circuitry from its enclosure', ' ');
INSERT INTO answer VALUES (5353, 1339, 1, 'Use NP0 capacitors', ' ');
INSERT INTO answer VALUES (5354, 1339, 2, 'Reduce noise on the oscillator''s power supply', ' ');
INSERT INTO answer VALUES (5355, 1339, 3, 'Increase the bias voltage', ' ');
INSERT INTO answer VALUES (5357, 1340, 0, 'NP0 capacitors', ' ');
INSERT INTO answer VALUES (5358, 1340, 1, 'Toroidal inductors', ' ');
INSERT INTO answer VALUES (5359, 1340, 2, 'Wirewound resistors', ' ');
INSERT INTO answer VALUES (5360, 1340, 3, 'Non-inductive resistors', ' ');
INSERT INTO answer VALUES (5361, 1341, 0, 'A direct digital synthesizer', ' ');
INSERT INTO answer VALUES (5362, 1341, 1, 'A hybrid synthesizer', ' ');
INSERT INTO answer VALUES (5363, 1341, 2, 'A phase-locked loop synthesizer', ' ');
INSERT INTO answer VALUES (5364, 1341, 3, 'A diode-switching matrix synthesizer', ' ');
INSERT INTO answer VALUES (5366, 1342, 0, 'Amplitude values that represent the desired waveform', ' ');
INSERT INTO answer VALUES (5365, 1342, 1, 'The phase relationship between a reference oscillator and the output waveform', ' ');
INSERT INTO answer VALUES (5367, 1342, 2, 'The phase relationship between a voltage-controlled oscillator and the output waveform', ' ');
INSERT INTO answer VALUES (5368, 1342, 3, 'Frequently used receiver and transmitter frequencies', ' ');
INSERT INTO answer VALUES (5371, 1343, 0, 'Spurious signals at discrete frequencies', ' ');
INSERT INTO answer VALUES (5369, 1343, 1, 'Broadband noise', ' ');
INSERT INTO answer VALUES (5370, 1343, 2, 'Digital conversion noise', ' ');
INSERT INTO answer VALUES (5372, 1343, 3, 'Nyquist limit noise', ' ');
INSERT INTO answer VALUES (5374, 1344, 0, 'Provide the crystal with a specified parallel capacitance', ' ');
INSERT INTO answer VALUES (5373, 1344, 1, 'Provide the crystal with a specified parallel inductance', ' ');
INSERT INTO answer VALUES (5375, 1344, 2, 'Bias the crystal at a specified voltage', ' ');
INSERT INTO answer VALUES (5376, 1344, 3, 'Bias the crystal at a specified current', ' ');
INSERT INTO answer VALUES (5380, 1345, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5377, 1345, 1, 'Use a GPS signal reference', ' ');
INSERT INTO answer VALUES (5378, 1345, 2, 'Use a rubidium stabilized reference oscillator', ' ');
INSERT INTO answer VALUES (5379, 1345, 3, 'Use a temperature-controlled high Q dielectric resonator', ' ');
INSERT INTO answer VALUES (5383, 1346, 0, 'An electronic servo loop consisting of a phase detector, a low-pass filter, a voltage-controlled oscillator, and a stable reference oscillator', ' ');
INSERT INTO answer VALUES (5381, 1346, 1, 'An electronic servo loop consisting of a ratio detector, reactance modulator, and voltage-controlled oscillator', ' ');
INSERT INTO answer VALUES (5382, 1346, 2, 'An electronic circuit also known as a monostable multivibrator', ' ');
INSERT INTO answer VALUES (5384, 1346, 3, 'An electronic circuit consisting of a precision push-pull amplifier with a differential input', ' ');
INSERT INTO answer VALUES (5388, 1347, 0, 'Frequency synthesis, FM demodulation', ' ');
INSERT INTO answer VALUES (5385, 1347, 1, 'Wide-band AF and RF power amplification', ' ');
INSERT INTO answer VALUES (5386, 1347, 2, 'Comparison of two digital input signals, digital pulse counter', ' ');
INSERT INTO answer VALUES (5387, 1347, 3, 'Photovoltaic conversion, optical coupling', ' ');
INSERT INTO answer VALUES (5389, 1348, 0, 'Fourier analysis', ' ');
INSERT INTO answer VALUES (5390, 1348, 1, 'Vector analysis', ' ');
INSERT INTO answer VALUES (5391, 1348, 2, 'Numerical analysis', ' ');
INSERT INTO answer VALUES (5392, 1348, 3, 'Differential analysis', ' ');
INSERT INTO answer VALUES (5393, 1349, 0, 'Successive approximation', ' ');
INSERT INTO answer VALUES (5394, 1349, 1, 'Harmonic regeneration', ' ');
INSERT INTO answer VALUES (5395, 1349, 2, 'Level shifting', ' ');
INSERT INTO answer VALUES (5396, 1349, 3, 'Phase reversal', ' ');
INSERT INTO answer VALUES (5397, 1350, 0, 'A sawtooth wave', ' ');
INSERT INTO answer VALUES (5398, 1350, 1, 'A square wave', ' ');
INSERT INTO answer VALUES (5399, 1350, 2, 'A sine wave', ' ');
INSERT INTO answer VALUES (5400, 1350, 3, 'A cosine wave', ' ');
INSERT INTO answer VALUES (5402, 1351, 0, 'A small amount of noise added to the input signal to allow more precise representation of a signal over time', ' ');
INSERT INTO answer VALUES (5401, 1351, 1, 'An abnormal condition where the converter cannot settle on a value to represent the signal', ' ');
INSERT INTO answer VALUES (5403, 1351, 2, 'An error caused by irregular quantization step size', ' ');
INSERT INTO answer VALUES (5404, 1351, 3, 'A method of decimation by randomly skipping samples', ' ');
INSERT INTO answer VALUES (5408, 1352, 0, 'A true-RMS calculating meter', ' ');
INSERT INTO answer VALUES (5405, 1352, 1, 'A grid dip meter', ' ');
INSERT INTO answer VALUES (5406, 1352, 2, 'A D''Arsonval meter', ' ');
INSERT INTO answer VALUES (5407, 1352, 3, 'An absorption wave meter', ' ');
INSERT INTO answer VALUES (5409, 1353, 0, '2.5 to 1', ' ');
INSERT INTO answer VALUES (5410, 1353, 1, '25 to 1', ' ');
INSERT INTO answer VALUES (5411, 1353, 2, '1 to 1', ' ');
INSERT INTO answer VALUES (5412, 1353, 3, '100 to 1', ' ');
INSERT INTO answer VALUES (5414, 1354, 0, 'Speech characteristics', ' ');
INSERT INTO answer VALUES (5413, 1354, 1, 'The frequency of the modulating signal', ' ');
INSERT INTO answer VALUES (5415, 1354, 2, 'The degree of carrier suppression', ' ');
INSERT INTO answer VALUES (5416, 1354, 3, 'Amplifier gain', ' ');
INSERT INTO answer VALUES (5419, 1355, 0, 'Very high speed allows digitizing high frequencies', ' ');
INSERT INTO answer VALUES (5417, 1355, 1, 'Very low power consumption decreases frequency drift', ' ');
INSERT INTO answer VALUES (5418, 1355, 2, 'Immunity to out-of-sequence coding reduces spurious responses', ' ');
INSERT INTO answer VALUES (5420, 1355, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5424, 1356, 0, '256', ' ');
INSERT INTO answer VALUES (5421, 1356, 1, '8', ' ');
INSERT INTO answer VALUES (5422, 1356, 2, '8 multiplied by the gain of the input amplifier', ' ');
INSERT INTO answer VALUES (5423, 1356, 3, '256 divided by the gain of the input amplifier', ' ');
INSERT INTO answer VALUES (5427, 1357, 0, 'Remove harmonics from the output caused by the discrete analog levels generated', ' ');
INSERT INTO answer VALUES (5425, 1357, 1, 'Lower the input bandwidth to increase the effective resolution', ' ');
INSERT INTO answer VALUES (5426, 1357, 2, 'Improve accuracy by removing out-of-sequence codes from the input', ' ');
INSERT INTO answer VALUES (5428, 1357, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5429, 1358, 0, 'Total harmonic distortion', ' ');
INSERT INTO answer VALUES (5430, 1358, 1, 'Peak envelope power', ' ');
INSERT INTO answer VALUES (5431, 1358, 2, 'Reciprocal mixing', ' ');
INSERT INTO answer VALUES (5432, 1358, 3, 'Power factor', ' ');
INSERT INTO answer VALUES (5433, 1359, 0, 'The ratio of frequency deviation to modulating signal frequency', ' ');
INSERT INTO answer VALUES (5434, 1359, 1, 'The ratio of modulating signal amplitude to frequency deviation', ' ');
INSERT INTO answer VALUES (5435, 1359, 2, 'The type of modulation used by the transmitter', ' ');
INSERT INTO answer VALUES (5436, 1359, 3, 'The bandwidth of the transmitted signal divided by the modulating signal frequency', ' ');
INSERT INTO answer VALUES (5440, 1360, 0, 'It does not depend on the RF carrier frequency', ' ');
INSERT INTO answer VALUES (5437, 1360, 1, 'It increases as the RF carrier frequency increases', ' ');
INSERT INTO answer VALUES (5438, 1360, 2, 'It decreases as the RF carrier frequency increases', ' ');
INSERT INTO answer VALUES (5439, 1360, 3, 'It varies with the square root of the RF carrier frequency', ' ');
INSERT INTO answer VALUES (5441, 1361, 0, '3', ' ');
INSERT INTO answer VALUES (5442, 1361, 1, '0.3', ' ');
INSERT INTO answer VALUES (5443, 1361, 2, '3000', ' ');
INSERT INTO answer VALUES (5444, 1361, 3, '1000', ' ');
INSERT INTO answer VALUES (5446, 1362, 0, '3', ' ');
INSERT INTO answer VALUES (5445, 1362, 1, '6000', ' ');
INSERT INTO answer VALUES (5447, 1362, 2, '2000', ' ');
INSERT INTO answer VALUES (5448, 1362, 3, '1/3', ' ');
INSERT INTO answer VALUES (5452, 1363, 0, '1.67', ' ');
INSERT INTO answer VALUES (5449, 1363, 1, '60', ' ');
INSERT INTO answer VALUES (5450, 1363, 2, '0.167', ' ');
INSERT INTO answer VALUES (5451, 1363, 3, '0.6', ' ');
INSERT INTO answer VALUES (5453, 1364, 0, '2.14', ' ');
INSERT INTO answer VALUES (5454, 1364, 1, '0.214', ' ');
INSERT INTO answer VALUES (5455, 1364, 2, '0.47', ' ');
INSERT INTO answer VALUES (5456, 1364, 3, '47', ' ');
INSERT INTO answer VALUES (5457, 1365, 0, 'High-speed digital modes', ' ');
INSERT INTO answer VALUES (5458, 1365, 1, 'Extremely low-power contacts', ' ');
INSERT INTO answer VALUES (5459, 1365, 2, 'EME', ' ');
INSERT INTO answer VALUES (5460, 1365, 3, 'OFDM signals are not allowed on amateur bands', ' ');
INSERT INTO answer VALUES (5464, 1366, 0, 'A digital modulation technique using subcarriers at frequencies chosen to avoid intersymbol interference', ' ');
INSERT INTO answer VALUES (5461, 1366, 1, 'A frequency modulation technique that uses non-harmonically related frequencies', ' ');
INSERT INTO answer VALUES (5462, 1366, 2, 'A bandwidth compression technique using Fourier transforms', ' ');
INSERT INTO answer VALUES (5463, 1366, 3, 'A digital mode for narrow-band, slow-speed transmissions', ' ');
INSERT INTO answer VALUES (5466, 1367, 0, 'The ratio of the maximum carrier frequency deviation to the highest audio modulating frequency', ' ');
INSERT INTO answer VALUES (5465, 1367, 1, 'The ratio of the audio modulating frequency to the center carrier frequency', ' ');
INSERT INTO answer VALUES (5467, 1367, 2, 'The ratio of the carrier center frequency to the audio modulating frequency', ' ');
INSERT INTO answer VALUES (5468, 1367, 3, 'The ratio of the highest audio modulating frequency to the average audio modulating frequency', ' ');
INSERT INTO answer VALUES (5470, 1368, 0, 'Two or more information streams are merged into a baseband, which then modulates the transmitter', ' ');
INSERT INTO answer VALUES (5469, 1368, 1, 'The transmitted signal jumps from band to band at a predetermined rate', ' ');
INSERT INTO answer VALUES (5471, 1368, 2, 'The transmitted signal is divided into packets of information', ' ');
INSERT INTO answer VALUES (5472, 1368, 3, 'Two or more information streams are merged into a digital combiner, which then pulse position modulates the transmitter', ' ');
INSERT INTO answer VALUES (5474, 1369, 0, 'Two or more signals are arranged to share discrete time slots of a data transmission', ' ');
INSERT INTO answer VALUES (5473, 1369, 1, 'Two or more data streams are assigned to discrete sub-carriers on an FM transmitter', ' ');
INSERT INTO answer VALUES (5475, 1369, 2, 'Two or more data streams share the same channel by transmitting time of transmission as the sub-carrier', ' ');
INSERT INTO answer VALUES (5476, 1369, 3, 'Two or more signals are quadrature modulated to increase bandwidth efficiency', ' ');
INSERT INTO answer VALUES (5479, 1370, 0, 'By transmitting extra data that may be used to detect and correct transmission errors', ' ');
INSERT INTO answer VALUES (5477, 1370, 1, 'By the receiving station repeating each block of three data characters', ' ');
INSERT INTO answer VALUES (5478, 1370, 2, 'By transmitting a special algorithm to the receiving station along with the data characters', ' ');
INSERT INTO answer VALUES (5480, 1370, 3, 'By varying the frequency shift of the transmitted signal according to a predefined algorithm', ' ');
INSERT INTO answer VALUES (5483, 1371, 0, 'The rate at which the waveform changes to convey information', ' ');
INSERT INTO answer VALUES (5481, 1371, 1, 'The number of control characters in a message packet', ' ');
INSERT INTO answer VALUES (5482, 1371, 2, 'The duration of each bit in a message sent over the air', ' ');
INSERT INTO answer VALUES (5484, 1371, 3, 'The number of characters carried per second by the station-to-station link', ' ');
INSERT INTO answer VALUES (5485, 1372, 0, 'To minimize bandwidth', ' ');
INSERT INTO answer VALUES (5486, 1372, 1, 'To simplify modulation', ' ');
INSERT INTO answer VALUES (5487, 1372, 2, 'To improve carrier suppression', ' ');
INSERT INTO answer VALUES (5488, 1372, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5491, 1373, 0, 'Use of sinusoidal data pulses', ' ');
INSERT INTO answer VALUES (5489, 1373, 1, 'Zero-sum character encoding', ' ');
INSERT INTO answer VALUES (5490, 1373, 2, 'Reed-Solomon character encoding', ' ');
INSERT INTO answer VALUES (5492, 1373, 3, 'Use of trapezoidal data pulses', ' ');
INSERT INTO answer VALUES (5495, 1374, 0, '52 Hz', ' ');
INSERT INTO answer VALUES (5493, 1374, 1, '13 Hz', ' ');
INSERT INTO answer VALUES (5494, 1374, 2, '26 Hz', ' ');
INSERT INTO answer VALUES (5496, 1374, 3, '104 Hz', ' ');
INSERT INTO answer VALUES (5499, 1375, 0, '0.5 kHz', ' ');
INSERT INTO answer VALUES (5497, 1375, 1, '0.1 Hz', ' ');
INSERT INTO answer VALUES (5498, 1375, 2, '0.3 kHz', ' ');
INSERT INTO answer VALUES (5500, 1375, 3, '1.0 kHz', ' ');
INSERT INTO answer VALUES (5501, 1376, 0, '15.36 kHz', ' ');
INSERT INTO answer VALUES (5502, 1376, 1, '9.6 kHz', ' ');
INSERT INTO answer VALUES (5503, 1376, 2, '4.8 kHz', ' ');
INSERT INTO answer VALUES (5504, 1376, 3, '5.76 kHz', ' ');
INSERT INTO answer VALUES (5508, 1377, 0, 'If errors are detected, a retransmission is requested', ' ');
INSERT INTO answer VALUES (5505, 1377, 1, 'Special binary codes provide automatic correction', ' ');
INSERT INTO answer VALUES (5506, 1377, 2, 'Special polynomial codes provide automatic correction', ' ');
INSERT INTO answer VALUES (5507, 1377, 3, 'If errors are detected, redundant data is substituted', ' ');
INSERT INTO answer VALUES (5512, 1378, 0, 'Gray code', ' ');
INSERT INTO answer VALUES (5509, 1378, 1, 'Binary Coded Decimal Code', ' ');
INSERT INTO answer VALUES (5510, 1378, 2, 'Extended Binary Coded Decimal Interchange Code', ' ');
INSERT INTO answer VALUES (5511, 1378, 3, 'Excess 3 code', ' ');
INSERT INTO answer VALUES (5515, 1379, 0, 'Using a more efficient digital code', ' ');
INSERT INTO answer VALUES (5513, 1379, 1, 'It is impossible', ' ');
INSERT INTO answer VALUES (5514, 1379, 2, 'Increasing analog-to-digital conversion resolution', ' ');
INSERT INTO answer VALUES (5516, 1379, 3, 'Using forward error correction', ' ');
INSERT INTO answer VALUES (5517, 1380, 0, 'They are the same', ' ');
INSERT INTO answer VALUES (5518, 1380, 1, 'Baud is twice the symbol rate', ' ');
INSERT INTO answer VALUES (5519, 1380, 2, 'Symbol rate is only used for packet-based modes', ' ');
INSERT INTO answer VALUES (5520, 1380, 3, 'Baud is only used for RTTY', ' ');
INSERT INTO answer VALUES (5523, 1381, 0, 'Keying speed and shape factor (rise and fall time)', ' ');
INSERT INTO answer VALUES (5521, 1381, 1, 'IF bandwidth and Q', ' ');
INSERT INTO answer VALUES (5522, 1381, 2, 'Modulation index and output power', ' ');
INSERT INTO answer VALUES (5524, 1381, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5525, 1382, 0, 'Signals not using the spread spectrum algorithm are suppressed in the receiver', ' ');
INSERT INTO answer VALUES (5526, 1382, 1, 'The high power used by a spread spectrum transmitter keeps its signal from being easily overpowered', ' ');
INSERT INTO answer VALUES (5527, 1382, 2, 'The receiver is always equipped with a digital blanker', ' ');
INSERT INTO answer VALUES (5528, 1382, 3, 'If interference is detected by the receiver it will signal the transmitter to change frequencies', ' ');
INSERT INTO answer VALUES (5530, 1383, 0, 'Direct sequence', ' ');
INSERT INTO answer VALUES (5529, 1383, 1, 'Frequency hopping', ' ');
INSERT INTO answer VALUES (5531, 1383, 2, 'Binary phase-shift keying', ' ');
INSERT INTO answer VALUES (5532, 1383, 3, 'Phase compandored spread spectrum', ' ');
INSERT INTO answer VALUES (5536, 1384, 0, 'The frequency of the transmitted signal is changed very rapidly according to a pseudorandom sequence also used by the receiving station', ' ');
INSERT INTO answer VALUES (5533, 1384, 1, 'If interference is detected by the receiver it will signal the transmitter to change frequencies', ' ');
INSERT INTO answer VALUES (5534, 1384, 2, 'If interference is detected by the receiver it will signal the transmitter to wait until the frequency is clear', ' ');
INSERT INTO answer VALUES (5535, 1384, 3, 'A binary bit stream is used to shift the phase of an RF carrier very rapidly in a pseudorandom sequence', ' ');
INSERT INTO answer VALUES (5539, 1385, 0, 'The generation of key clicks', ' ');
INSERT INTO answer VALUES (5537, 1385, 1, 'More difficult to copy', ' ');
INSERT INTO answer VALUES (5538, 1385, 2, 'The generation of RF harmonics', ' ');
INSERT INTO answer VALUES (5540, 1385, 3, 'Limits data speed', ' ');
INSERT INTO answer VALUES (5541, 1386, 0, 'Increase keying waveform rise and fall times', ' ');
INSERT INTO answer VALUES (5542, 1386, 1, 'Low-pass filters at the transmitter output', ' ');
INSERT INTO answer VALUES (5543, 1386, 2, 'Reduce keying waveform rise and fall times', ' ');
INSERT INTO answer VALUES (5544, 1386, 3, 'High-pass filters at the transmitter output', ' ');
INSERT INTO answer VALUES (5548, 1387, 0, 'Some types of errors can be detected', ' ');
INSERT INTO answer VALUES (5545, 1387, 1, 'Faster transmission rate', ' ');
INSERT INTO answer VALUES (5546, 1387, 2, 'The signal can overpower interfering signals', ' ');
INSERT INTO answer VALUES (5547, 1387, 3, 'Foreign language characters can be sent', ' ');
INSERT INTO answer VALUES (5552, 1388, 0, 'Excessive transmit audio levels', ' ');
INSERT INTO answer VALUES (5549, 1388, 1, 'Excessive numbers of retries', ' ');
INSERT INTO answer VALUES (5550, 1388, 2, 'Ground loops', ' ');
INSERT INTO answer VALUES (5551, 1388, 3, 'Bit errors in the modem', ' ');
INSERT INTO answer VALUES (5556, 1389, 0, 'Intermodulation Distortion (IMD)', ' ');
INSERT INTO answer VALUES (5553, 1389, 1, 'Signal-to-noise ratio', ' ');
INSERT INTO answer VALUES (5554, 1389, 2, 'Baud rate', ' ');
INSERT INTO answer VALUES (5555, 1389, 3, 'Repeat Request Rate (RRR)', ' ');
INSERT INTO answer VALUES (5560, 1390, 0, '-30 dB', ' ');
INSERT INTO answer VALUES (5557, 1390, 1, '+10 dB', ' ');
INSERT INTO answer VALUES (5558, 1390, 2, '+15 dB', ' ');
INSERT INTO answer VALUES (5559, 1390, 3, '-20 dB', ' ');
INSERT INTO answer VALUES (5562, 1391, 0, 'Baudot uses 5 data bits per character, ASCII uses 7 or 8; Baudot uses 2 characters as letters/figures shift codes, ASCII has no letters/figures shift code', ' ');
INSERT INTO answer VALUES (5561, 1391, 1, 'Baudot uses 4 data bits per character, ASCII uses 7 or 8; Baudot uses 1 character as a letters/figures shift code, ASCII has no letters/figures code', ' ');
INSERT INTO answer VALUES (5563, 1391, 2, 'Baudot uses 6 data bits per character, ASCII uses 7 or 8; Baudot has no letters/figures shift code, ASCII uses 2 letters/figures shift codes', ' ');
INSERT INTO answer VALUES (5564, 1391, 3, 'Baudot uses 7 data bits per character, ASCII uses 8; Baudot has no letters/figures shift code, ASCII uses 2 letters/figures shift codes', ' ');
INSERT INTO answer VALUES (5567, 1392, 0, 'It is possible to transmit both upper and lower case text', ' ');
INSERT INTO answer VALUES (5565, 1392, 1, 'It includes built-in error correction features', ' ');
INSERT INTO answer VALUES (5566, 1392, 2, 'It contains fewer information bits per character than any other code', ' ');
INSERT INTO answer VALUES (5568, 1392, 3, 'It uses one character as a shift code to send numeric and special characters', ' ');
INSERT INTO answer VALUES (5571, 1393, 0, 'A theoretical, omnidirectional antenna used as a reference for antenna gain', ' ');
INSERT INTO answer VALUES (5569, 1393, 1, 'A grounded antenna used to measure Earth conductivity', ' ');
INSERT INTO answer VALUES (5570, 1393, 2, 'A horizontally polarized antenna used to compare Yagi antennas', ' ');
INSERT INTO answer VALUES (5572, 1393, 3, 'A spacecraft antenna used to direct signals toward Earth', ' ');
INSERT INTO answer VALUES (5576, 1394, 0, '286 watts', ' ');
INSERT INTO answer VALUES (5573, 1394, 1, '1977 watts', ' ');
INSERT INTO answer VALUES (5574, 1394, 2, '78.7 watts', ' ');
INSERT INTO answer VALUES (5575, 1394, 3, '420 watts', ' ');
INSERT INTO answer VALUES (5579, 1395, 0, 'The value of a resistance that would dissipate the same amount of power as that radiated from an antenna', ' ');
INSERT INTO answer VALUES (5577, 1395, 1, 'The combined losses of the antenna elements and feed line', ' ');
INSERT INTO answer VALUES (5578, 1395, 2, 'The specific impedance of the antenna', ' ');
INSERT INTO answer VALUES (5580, 1395, 3, 'The resistance in the atmosphere that an antenna must overcome to be able to radiate a signal', ' ');
INSERT INTO answer VALUES (5582, 1396, 0, 'Antenna height', ' ');
INSERT INTO answer VALUES (5581, 1396, 1, 'Transmission line length', ' ');
INSERT INTO answer VALUES (5583, 1396, 2, 'The settings of an antenna tuner at the transmitter', ' ');
INSERT INTO answer VALUES (5584, 1396, 3, 'The input power level', ' ');
INSERT INTO answer VALUES (5588, 1397, 0, 'Radiation resistance plus loss resistance', ' ');
INSERT INTO answer VALUES (5585, 1397, 1, 'Radiation resistance plus space impedance', ' ');
INSERT INTO answer VALUES (5586, 1397, 2, 'Radiation resistance plus transmission resistance', ' ');
INSERT INTO answer VALUES (5587, 1397, 3, 'Transmission-line resistance plus radiation resistance', ' ');
INSERT INTO answer VALUES (5589, 1398, 0, '317 watts', ' ');
INSERT INTO answer VALUES (5590, 1398, 1, '2000 watts', ' ');
INSERT INTO answer VALUES (5591, 1398, 2, '126 watts', ' ');
INSERT INTO answer VALUES (5592, 1398, 3, '300 watts', ' ');
INSERT INTO answer VALUES (5594, 1399, 0, '252 watts', ' ');
INSERT INTO answer VALUES (5593, 1399, 1, '159 watts', ' ');
INSERT INTO answer VALUES (5595, 1399, 2, '632 watts', ' ');
INSERT INTO answer VALUES (5596, 1399, 3, '63.2 watts', ' ');
INSERT INTO answer VALUES (5598, 1400, 0, 'The frequency range over which an antenna satisfies a performance requirement', ' ');
INSERT INTO answer VALUES (5597, 1400, 1, 'Antenna length divided by the number of elements', ' ');
INSERT INTO answer VALUES (5599, 1400, 2, 'The angle between the half-power radiation points', ' ');
INSERT INTO answer VALUES (5600, 1400, 3, 'The angle formed between two imaginary lines drawn through the element ends', ' ');
INSERT INTO answer VALUES (5602, 1401, 0, 'Radiation resistance divided by total resistance', ' ');
INSERT INTO answer VALUES (5601, 1401, 1, 'Radiation resistance divided by transmission resistance', ' ');
INSERT INTO answer VALUES (5603, 1401, 2, 'Total resistance divided by radiation resistance', ' ');
INSERT INTO answer VALUES (5604, 1401, 3, 'Effective radiated power divided by transmitter output', ' ');
INSERT INTO answer VALUES (5605, 1402, 0, 'Installing a radial system', ' ');
INSERT INTO answer VALUES (5606, 1402, 1, 'Isolating the coax shield from ground', ' ');
INSERT INTO answer VALUES (5607, 1402, 2, 'Shortening the radiating element', ' ');
INSERT INTO answer VALUES (5608, 1402, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5611, 1403, 0, 'Soil conductivity', ' ');
INSERT INTO answer VALUES (5609, 1403, 1, 'The standing wave ratio', ' ');
INSERT INTO answer VALUES (5610, 1403, 2, 'Distance from the transmitter', ' ');
INSERT INTO answer VALUES (5612, 1403, 3, 'Take-off angle', ' ');
INSERT INTO answer VALUES (5613, 1404, 0, '3.85 dB', ' ');
INSERT INTO answer VALUES (5614, 1404, 1, '6.0 dB', ' ');
INSERT INTO answer VALUES (5615, 1404, 2, '8.15 dB', ' ');
INSERT INTO answer VALUES (5616, 1404, 3, '2.79 dB', ' ');
INSERT INTO answer VALUES (5619, 1405, 0, 'Effective radiated power', ' ');
INSERT INTO answer VALUES (5617, 1405, 1, 'Power factor', ' ');
INSERT INTO answer VALUES (5618, 1405, 2, 'Half-power bandwidth', ' ');
INSERT INTO answer VALUES (5620, 1405, 3, 'Apparent power', ' ');
INSERT INTO answer VALUES (5622, 1406, 0, '50 degrees', ' ');
INSERT INTO answer VALUES (5621, 1406, 1, '75 degrees', ' ');
INSERT INTO answer VALUES (5623, 1406, 2, '25 degrees', ' ');
INSERT INTO answer VALUES (5624, 1406, 3, '30 degrees', ' ');
INSERT INTO answer VALUES (5626, 1407, 0, '18 dB', ' ');
INSERT INTO answer VALUES (5625, 1407, 1, '36 dB', ' ');
INSERT INTO answer VALUES (5627, 1407, 2, '24 dB', ' ');
INSERT INTO answer VALUES (5628, 1407, 3, '14 dB', ' ');
INSERT INTO answer VALUES (5630, 1408, 0, '14 dB', ' ');
INSERT INTO answer VALUES (5629, 1408, 1, '12 dB', ' ');
INSERT INTO answer VALUES (5631, 1408, 2, '18 dB', ' ');
INSERT INTO answer VALUES (5632, 1408, 3, '24 dB', ' ');
INSERT INTO answer VALUES (5634, 1409, 0, '28 dB', ' ');
INSERT INTO answer VALUES (5633, 1409, 1, '15 dB', ' ');
INSERT INTO answer VALUES (5635, 1409, 2, '3 dB', ' ');
INSERT INTO answer VALUES (5636, 1409, 3, '38 dB', ' ');
INSERT INTO answer VALUES (5637, 1410, 0, 'Elevation', ' ');
INSERT INTO answer VALUES (5638, 1410, 1, 'Azimuth', ' ');
INSERT INTO answer VALUES (5639, 1410, 2, 'Radiation resistance', ' ');
INSERT INTO answer VALUES (5640, 1410, 3, 'Polarization', ' ');
INSERT INTO answer VALUES (5643, 1411, 0, '7.5 degrees', ' ');
INSERT INTO answer VALUES (5641, 1411, 1, '45 degrees', ' ');
INSERT INTO answer VALUES (5642, 1411, 2, '75 degrees', ' ');
INSERT INTO answer VALUES (5644, 1411, 3, '25 degrees', ' ');
INSERT INTO answer VALUES (5647, 1412, 0, 'They are the same', ' ');
INSERT INTO answer VALUES (5645, 1412, 1, 'The total amount of radiation from the directional antenna is increased by the gain of the antenna', ' ');
INSERT INTO answer VALUES (5646, 1412, 2, 'The total amount of radiation from the directional antenna is stronger by its front-to-back ratio', ' ');
INSERT INTO answer VALUES (5648, 1412, 3, 'The radiation from the isotropic antenna is 2.15 dB stronger than that from the directional antenna', ' ');
INSERT INTO answer VALUES (5652, 1413, 0, 'The region where the shape of the antenna pattern is independent of distance', ' ');
INSERT INTO answer VALUES (5649, 1413, 1, 'The region of the ionosphere where radiated power is not refracted', ' ');
INSERT INTO answer VALUES (5650, 1413, 2, 'The region where radiated power dissipates over a specified time period', ' ');
INSERT INTO answer VALUES (5651, 1413, 3, 'The region where radiated field strengths are constant', ' ');
INSERT INTO answer VALUES (5654, 1414, 0, 'Method of Moments', ' ');
INSERT INTO answer VALUES (5653, 1414, 1, 'Graphical analysis', ' ');
INSERT INTO answer VALUES (5655, 1414, 2, 'Mutual impedance analysis', ' ');
INSERT INTO answer VALUES (5656, 1414, 3, 'Calculus differentiation with respect to physical properties', ' ');
INSERT INTO answer VALUES (5657, 1415, 0, 'A wire is modeled as a series of segments, each having a uniform value of current', ' ');
INSERT INTO answer VALUES (5658, 1415, 1, 'A wire is modeled as a single sine-wave current generator', ' ');
INSERT INTO answer VALUES (5659, 1415, 2, 'A wire is modeled as a single sine-wave voltage source', ' ');
INSERT INTO answer VALUES (5660, 1415, 3, 'A wire is modeled as a series of segments, each having a distinct value of voltage across it', ' ');
INSERT INTO answer VALUES (5663, 1416, 0, 'The computed feed point impedance may be incorrect', ' ');
INSERT INTO answer VALUES (5661, 1416, 1, 'Ground conductivity will not be accurately modeled', ' ');
INSERT INTO answer VALUES (5662, 1416, 2, 'The resulting design will favor radiation of harmonic energy', ' ');
INSERT INTO answer VALUES (5664, 1416, 3, 'The antenna will become mechanically unstable', ' ');
INSERT INTO answer VALUES (5668, 1417, 0, 'A figure-8 oriented along the axis of the array', ' ');
INSERT INTO answer VALUES (5665, 1417, 1, 'Cardioid', ' ');
INSERT INTO answer VALUES (5666, 1417, 2, 'Omni-directional', ' ');
INSERT INTO answer VALUES (5667, 1417, 3, 'A figure-8 broadside to the axis of the array', ' ');
INSERT INTO answer VALUES (5669, 1418, 0, 'Cardioid', ' ');
INSERT INTO answer VALUES (5670, 1418, 1, 'A figure-8 end-fire along the axis of the array', ' ');
INSERT INTO answer VALUES (5671, 1418, 2, 'A figure-8 broadside to the axis of the array', ' ');
INSERT INTO answer VALUES (5672, 1418, 3, 'Omni-directional', ' ');
INSERT INTO answer VALUES (5675, 1419, 0, 'A Figure-8 broadside to the axis of the array', ' ');
INSERT INTO answer VALUES (5673, 1419, 1, 'Omni-directional', ' ');
INSERT INTO answer VALUES (5674, 1419, 2, 'Cardioid', ' ');
INSERT INTO answer VALUES (5676, 1419, 3, 'A Figure-8 end-fire along the axis of the array', ' ');
INSERT INTO answer VALUES (5678, 1420, 0, 'The lobes align more in the direction of the wire', ' ');
INSERT INTO answer VALUES (5677, 1420, 1, 'The lobes become more perpendicular to the wire', ' ');
INSERT INTO answer VALUES (5679, 1420, 2, 'The vertical angle increases', ' ');
INSERT INTO answer VALUES (5680, 1420, 3, 'The front-to-back ratio decreases', ' ');
INSERT INTO answer VALUES (5681, 1421, 0, 'A dipole fed approximately 1/3 the way from one end with a 4:1 balun to provide multiband operation', ' ');
INSERT INTO answer VALUES (5682, 1421, 1, 'A remotely tunable dipole antenna using orthogonally controlled frequency diversity', ' ');
INSERT INTO answer VALUES (5683, 1421, 2, 'A folded dipole center-fed with 300-ohm transmission line', ' ');
INSERT INTO answer VALUES (5684, 1421, 3, 'A multiband dipole antenna using one-way circular polarization for frequency diversity', ' ');
INSERT INTO answer VALUES (5686, 1422, 0, 'It changes the radiation pattern from bidirectional to unidirectional', ' ');
INSERT INTO answer VALUES (5685, 1422, 1, 'It reflects the standing waves on the antenna elements back to the transmitter', ' ');
INSERT INTO answer VALUES (5687, 1422, 2, 'It changes the radiation pattern from horizontal to vertical polarization', ' ');
INSERT INTO answer VALUES (5688, 1422, 3, 'It decreases the ground loss', ' ');
INSERT INTO answer VALUES (5689, 1423, 0, '300 ohms', ' ');
INSERT INTO answer VALUES (5690, 1423, 1, '72 ohms', ' ');
INSERT INTO answer VALUES (5691, 1423, 2, '50 ohms', ' ');
INSERT INTO answer VALUES (5692, 1423, 3, '450 ohms', ' ');
INSERT INTO answer VALUES (5695, 1424, 0, 'A half-wave dipole with an additional parallel wire connecting its two ends', ' ');
INSERT INTO answer VALUES (5693, 1424, 1, 'A dipole one-quarter wavelength long', ' ');
INSERT INTO answer VALUES (5694, 1424, 2, 'A type of ground-plane antenna', ' ');
INSERT INTO answer VALUES (5696, 1424, 3, 'A dipole configured to provide forward gain', ' ');
INSERT INTO answer VALUES (5697, 1425, 0, 'A multi-band dipole antenna fed with coax and a balun through a selected length of open wire transmission line', ' ');
INSERT INTO answer VALUES (5698, 1425, 1, 'A multi-band trap antenna', ' ');
INSERT INTO answer VALUES (5699, 1425, 2, 'A phased array antenna consisting of multiple loops', ' ');
INSERT INTO answer VALUES (5700, 1425, 3, 'A wide band dipole using shorted coaxial cable for the radiating elements and fed with a balun', ' ');
INSERT INTO answer VALUES (5702, 1426, 0, 'An end-fed dipole antenna', ' ');
INSERT INTO answer VALUES (5701, 1426, 1, 'A dipole constructed from zip cord', ' ');
INSERT INTO answer VALUES (5703, 1426, 2, 'An omni-directional antenna commonly used for satellite communications', ' ');
INSERT INTO answer VALUES (5704, 1426, 3, 'A vertical array capable of quickly changing the direction of maximum radiation by changing phasing lines', ' ');
INSERT INTO answer VALUES (5708, 1427, 0, 'The low-angle radiation increases', ' ');
INSERT INTO answer VALUES (5705, 1427, 1, 'The low-angle radiation decreases', ' ');
INSERT INTO answer VALUES (5706, 1427, 2, 'Additional higher vertical angle lobes will appear', ' ');
INSERT INTO answer VALUES (5707, 1427, 3, 'Fewer vertical angle lobes will be present', ' ');
INSERT INTO answer VALUES (5711, 1428, 0, 'A center-fed 1.25-wavelength antenna (two 5/8-wave elements in phase)', ' ');
INSERT INTO answer VALUES (5709, 1428, 1, 'A wideband vertical antenna constructed from precisely tapered aluminum tubing', ' ');
INSERT INTO answer VALUES (5710, 1428, 2, 'A portable antenna erected using two push support poles', ' ');
INSERT INTO answer VALUES (5712, 1428, 3, 'An end-fed folded dipole antenna', ' ');
INSERT INTO answer VALUES (5714, 1429, 0, 'The takeoff angle of the lowest elevation lobe decreases', ' ');
INSERT INTO answer VALUES (5713, 1429, 1, 'The takeoff angle of the lowest elevation lobe increases', ' ');
INSERT INTO answer VALUES (5715, 1429, 2, 'The horizontal beamwidth increases', ' ');
INSERT INTO answer VALUES (5716, 1429, 3, 'The horizontal beamwidth decreases', ' ');
INSERT INTO answer VALUES (5718, 1430, 0, 'The main lobe takeoff angle decreases in the downhill direction', ' ');
INSERT INTO answer VALUES (5717, 1430, 1, 'The main lobe takeoff angle increases in the downhill direction', ' ');
INSERT INTO answer VALUES (5719, 1430, 2, 'The horizontal beamwidth decreases in the downhill direction', ' ');
INSERT INTO answer VALUES (5720, 1430, 3, 'The horizontal beamwidth increases in the uphill direction', ' ');
INSERT INTO answer VALUES (5724, 1431, 0, '6 dB', ' ');
INSERT INTO answer VALUES (5721, 1431, 1, '2 dB', ' ');
INSERT INTO answer VALUES (5722, 1431, 2, '3 dB', ' ');
INSERT INTO answer VALUES (5723, 1431, 3, '4 dB', ' ');
INSERT INTO answer VALUES (5727, 1432, 0, 'Arrange two Yagis perpendicular to each other with the driven elements at the same point on the boom fed 90 degrees out of phase', ' ');
INSERT INTO answer VALUES (5725, 1432, 1, 'Stack two Yagis fed 90 degrees out of phase to form an array with the respective elements in parallel planes', ' ');
INSERT INTO answer VALUES (5726, 1432, 2, 'Stack two Yagis fed in phase to form an array with the respective elements in parallel planes', ' ');
INSERT INTO answer VALUES (5728, 1432, 3, 'Arrange two Yagis collinear to each other with the driven elements fed 180 degrees out of phase', ' ');
INSERT INTO answer VALUES (5729, 1433, 0, 'Near the center of the vertical radiator', ' ');
INSERT INTO answer VALUES (5730, 1433, 1, 'As low as possible on the vertical radiator', ' ');
INSERT INTO answer VALUES (5731, 1433, 2, 'As close to the transmitter as possible', ' ');
INSERT INTO answer VALUES (5732, 1433, 3, 'At a voltage node', ' ');
INSERT INTO answer VALUES (5735, 1434, 0, 'To minimize losses', ' ');
INSERT INTO answer VALUES (5733, 1434, 1, 'To swamp out harmonics', ' ');
INSERT INTO answer VALUES (5734, 1434, 2, 'To lower the radiation angle', ' ');
INSERT INTO answer VALUES (5736, 1434, 3, 'To minimize the Q', ' ');
INSERT INTO answer VALUES (5738, 1435, 0, 'The front-to-back ratio decreases', ' ');
INSERT INTO answer VALUES (5737, 1435, 1, 'The front-to-back ratio increases', ' ');
INSERT INTO answer VALUES (5739, 1435, 2, 'The frequency response is widened over the whole frequency band', ' ');
INSERT INTO answer VALUES (5740, 1435, 3, 'The SWR is reduced', ' ');
INSERT INTO answer VALUES (5742, 1436, 0, 'It is decreased', ' ');
INSERT INTO answer VALUES (5741, 1436, 1, 'It is increased', ' ');
INSERT INTO answer VALUES (5743, 1436, 2, 'It is unchanged if the loading coil is located at the feed point', ' ');
INSERT INTO answer VALUES (5744, 1436, 3, 'It is unchanged if the loading coil is located at a voltage maximum point', ' ');
INSERT INTO answer VALUES (5748, 1437, 0, 'Improved radiation efficiency', ' ');
INSERT INTO answer VALUES (5745, 1437, 1, 'Lower Q', ' ');
INSERT INTO answer VALUES (5746, 1437, 2, 'Greater structural strength', ' ');
INSERT INTO answer VALUES (5747, 1437, 3, 'Higher losses', ' ');
INSERT INTO answer VALUES (5750, 1438, 0, 'SWR bandwidth decreases', ' ');
INSERT INTO answer VALUES (5749, 1438, 1, 'SWR bandwidth increases', ' ');
INSERT INTO answer VALUES (5751, 1438, 2, 'Gain is reduced', ' ');
INSERT INTO answer VALUES (5752, 1438, 3, 'More common-mode current is present on the feed line', ' ');
INSERT INTO answer VALUES (5756, 1439, 0, 'To cancel capacitive reactance', ' ');
INSERT INTO answer VALUES (5753, 1439, 1, 'To increase the SWR bandwidth', ' ');
INSERT INTO answer VALUES (5754, 1439, 2, 'To lower the losses', ' ');
INSERT INTO answer VALUES (5755, 1439, 3, 'To lower the Q', ' ');
INSERT INTO answer VALUES (5758, 1440, 0, 'The radiation resistance decreases and the capacitive reactance increases', ' ');
INSERT INTO answer VALUES (5757, 1440, 1, 'The radiation resistance decreases and the capacitive reactance decreases', ' ');
INSERT INTO answer VALUES (5759, 1440, 2, 'The radiation resistance increases and the capacitive reactance decreases', ' ');
INSERT INTO answer VALUES (5760, 1440, 3, 'The radiation resistance increases and the capacitive reactance increases', ' ');
INSERT INTO answer VALUES (5762, 1441, 0, 'Wide flat copper strap', ' ');
INSERT INTO answer VALUES (5761, 1441, 1, 'Resistive wire, such as spark plug wire', ' ');
INSERT INTO answer VALUES (5763, 1441, 2, 'Stranded wire', ' ');
INSERT INTO answer VALUES (5764, 1441, 3, 'Solid wire', ' ');
INSERT INTO answer VALUES (5767, 1442, 0, 'An electrically short connection to 3 or 4 interconnected ground rods driven into the Earth', ' ');
INSERT INTO answer VALUES (5765, 1442, 1, 'A 50-ohm resistor connected to ground', ' ');
INSERT INTO answer VALUES (5766, 1442, 2, 'An electrically short connection to a metal water pipe', ' ');
INSERT INTO answer VALUES (5768, 1442, 3, 'An electrically short connection to 3 or 4 interconnected ground rods via a series RF choke', ' ');
INSERT INTO answer VALUES (5770, 1443, 0, 'The delta matching system', ' ');
INSERT INTO answer VALUES (5769, 1443, 1, 'The gamma matching system', ' ');
INSERT INTO answer VALUES (5771, 1443, 2, 'The omega matching system', ' ');
INSERT INTO answer VALUES (5772, 1443, 3, 'The stub matching system', ' ');
INSERT INTO answer VALUES (5773, 1444, 0, 'The gamma match', ' ');
INSERT INTO answer VALUES (5774, 1444, 1, 'The delta match', ' ');
INSERT INTO answer VALUES (5775, 1444, 2, 'The epsilon match', ' ');
INSERT INTO answer VALUES (5776, 1444, 3, 'The stub match', ' ');
INSERT INTO answer VALUES (5780, 1445, 0, 'The stub match', ' ');
INSERT INTO answer VALUES (5777, 1445, 1, 'The gamma match', ' ');
INSERT INTO answer VALUES (5778, 1445, 2, 'The delta match', ' ');
INSERT INTO answer VALUES (5779, 1445, 3, 'The omega match', ' ');
INSERT INTO answer VALUES (5782, 1446, 0, 'To cancel the inductive reactance of the matching network', ' ');
INSERT INTO answer VALUES (5781, 1446, 1, 'To provide DC isolation between the feed line and the antenna', ' ');
INSERT INTO answer VALUES (5783, 1446, 2, 'To provide a rejection notch that prevents the radiation of harmonics', ' ');
INSERT INTO answer VALUES (5784, 1446, 3, 'To transform the antenna impedance to a higher value', ' ');
INSERT INTO answer VALUES (5785, 1447, 0, 'The driven element reactance must be capacitive', ' ');
INSERT INTO answer VALUES (5786, 1447, 1, 'The driven element reactance must be inductive', ' ');
INSERT INTO answer VALUES (5787, 1447, 2, 'The driven element resonance must be lower than the operating frequency', ' ');
INSERT INTO answer VALUES (5788, 1447, 3, 'The driven element radiation resistance must be higher than the characteristic impedance of the transmission line', ' ');
INSERT INTO answer VALUES (5791, 1448, 0, '75 ohms', ' ');
INSERT INTO answer VALUES (5789, 1448, 1, '50 ohms', ' ');
INSERT INTO answer VALUES (5790, 1448, 2, '62 ohms', ' ');
INSERT INTO answer VALUES (5792, 1448, 3, '450 ohms', ' ');
INSERT INTO answer VALUES (5794, 1449, 0, 'Reflection coefficient', ' ');
INSERT INTO answer VALUES (5793, 1449, 1, 'Characteristic impedance', ' ');
INSERT INTO answer VALUES (5795, 1449, 2, 'Velocity factor', ' ');
INSERT INTO answer VALUES (5796, 1449, 3, 'Dielectric constant', ' ');
INSERT INTO answer VALUES (5799, 1450, 0, 'It is used to divide power equally between two 50-ohm loads while maintaining 50-ohm input impedance', ' ');
INSERT INTO answer VALUES (5797, 1450, 1, 'It divides the operating frequency of a transmitter signal so it can be used on a lower frequency band', ' ');
INSERT INTO answer VALUES (5798, 1450, 2, 'It is used to feed high-impedance antennas from a low-impedance source', ' ');
INSERT INTO answer VALUES (5800, 1450, 3, 'It is used to feed low-impedance loads from a high-impedance source', ' ');
INSERT INTO answer VALUES (5803, 1451, 0, 'Gamma match', ' ');
INSERT INTO answer VALUES (5801, 1451, 1, 'Double-bazooka match', ' ');
INSERT INTO answer VALUES (5802, 1451, 2, 'Hairpin match', ' ');
INSERT INTO answer VALUES (5804, 1451, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5807, 1452, 0, 'Insert a 1/4-wavelength piece of 75-ohm coaxial cable transmission line in series between the antenna terminals and the 50-ohm feed cable', ' ');
INSERT INTO answer VALUES (5805, 1452, 1, 'Connect a 1/4-wavelength open stub of 300-ohm twinlead in parallel with the coaxial feed line where it connects to the antenna', ' ');
INSERT INTO answer VALUES (5806, 1452, 2, 'Insert a 1/2 wavelength piece of 300-ohm twinlead in series between the antenna terminals and the 50-ohm feed cable', ' ');
INSERT INTO answer VALUES (5808, 1452, 3, 'Connect a 1/2 wavelength shorted stub of 75-ohm cable in parallel with the 50-ohm cable where it attaches to the antenna', ' ');
INSERT INTO answer VALUES (5809, 1453, 0, 'It ensures that each driven element operates in concert with the others to create the desired antenna pattern', ' ');
INSERT INTO answer VALUES (5810, 1453, 1, 'It prevents reflected power from traveling back down the feed line and causing harmonic radiation from the transmitter', ' ');
INSERT INTO answer VALUES (5811, 1453, 2, 'It allows single-band antennas to operate on other bands', ' ');
INSERT INTO answer VALUES (5812, 1453, 3, 'It creates a low-angle radiation pattern', ' ');
INSERT INTO answer VALUES (5816, 1454, 0, 'The velocity of the wave in the transmission line divided by the velocity of light in a vacuum', ' ');
INSERT INTO answer VALUES (5813, 1454, 1, 'The ratio of the characteristic impedance of the line to the terminating impedance', ' ');
INSERT INTO answer VALUES (5814, 1454, 2, 'The index of shielding for coaxial cable', ' ');
INSERT INTO answer VALUES (5815, 1454, 3, 'The velocity of the wave in the transmission line multiplied by the velocity of light in a vacuum', ' ');
INSERT INTO answer VALUES (5819, 1455, 0, 'Dielectric materials used in the line', ' ');
INSERT INTO answer VALUES (5817, 1455, 1, 'The termination impedance', ' ');
INSERT INTO answer VALUES (5818, 1455, 2, 'The line length', ' ');
INSERT INTO answer VALUES (5820, 1455, 3, 'The center conductor resistivity', ' ');
INSERT INTO answer VALUES (5824, 1456, 0, 'Electrical signals move more slowly in a coaxial cable than in air', ' ');
INSERT INTO answer VALUES (5821, 1456, 1, 'Skin effect is less pronounced in the coaxial cable', ' ');
INSERT INTO answer VALUES (5822, 1456, 2, 'The characteristic impedance is higher in a parallel feed line', ' ');
INSERT INTO answer VALUES (5823, 1456, 3, 'The surge impedance is higher in a parallel feed line', ' ');
INSERT INTO answer VALUES (5826, 1457, 0, 'Very low impedance', ' ');
INSERT INTO answer VALUES (5825, 1457, 1, 'Very high impedance', ' ');
INSERT INTO answer VALUES (5827, 1457, 2, 'The same as the characteristic impedance of the line', ' ');
INSERT INTO answer VALUES (5828, 1457, 3, 'The same as the output impedance of the generator', ' ');
INSERT INTO answer VALUES (5832, 1458, 0, '3.5 meters', ' ');
INSERT INTO answer VALUES (5829, 1458, 1, '10.6 meters', ' ');
INSERT INTO answer VALUES (5830, 1458, 2, '5.3 meters', ' ');
INSERT INTO answer VALUES (5831, 1458, 3, '4.3 meters', ' ');
INSERT INTO answer VALUES (5835, 1459, 0, '10.6 meters', ' ');
INSERT INTO answer VALUES (5833, 1459, 1, '7.0 meters', ' ');
INSERT INTO answer VALUES (5834, 1459, 2, '8.5 meters', ' ');
INSERT INTO answer VALUES (5836, 1459, 3, '13.3 meters', ' ');
INSERT INTO answer VALUES (5837, 1460, 0, 'Lower loss', ' ');
INSERT INTO answer VALUES (5838, 1460, 1, 'Higher SWR', ' ');
INSERT INTO answer VALUES (5839, 1460, 2, 'Smaller reflection coefficient', ' ');
INSERT INTO answer VALUES (5840, 1460, 3, 'Lower velocity factor', ' ');
INSERT INTO answer VALUES (5844, 1461, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5841, 1461, 1, 'Foam dielectric has lower safe operating voltage limits', ' ');
INSERT INTO answer VALUES (5842, 1461, 2, 'Foam dielectric has lower loss per unit of length', ' ');
INSERT INTO answer VALUES (5843, 1461, 3, 'Foam dielectric has higher velocity factor', ' ');
INSERT INTO answer VALUES (5846, 1462, 0, '8.3 meters', ' ');
INSERT INTO answer VALUES (5845, 1462, 1, '10.4 meters', ' ');
INSERT INTO answer VALUES (5847, 1462, 2, '6.9 meters', ' ');
INSERT INTO answer VALUES (5848, 1462, 3, '5.2 meters', ' ');
INSERT INTO answer VALUES (5851, 1463, 0, 'An inductive reactance', ' ');
INSERT INTO answer VALUES (5849, 1463, 1, 'A capacitive reactance', ' ');
INSERT INTO answer VALUES (5850, 1463, 2, 'The same as the characteristic impedance of the line', ' ');
INSERT INTO answer VALUES (5852, 1463, 3, 'Zero', ' ');
INSERT INTO answer VALUES (5855, 1464, 0, 'A capacitive reactance', ' ');
INSERT INTO answer VALUES (5853, 1464, 1, 'The same as the characteristic impedance of the line', ' ');
INSERT INTO answer VALUES (5854, 1464, 2, 'An inductive reactance', ' ');
INSERT INTO answer VALUES (5856, 1464, 3, 'Infinite', ' ');
INSERT INTO answer VALUES (5860, 1465, 0, 'Very low impedance', ' ');
INSERT INTO answer VALUES (5857, 1465, 1, 'The same as the characteristic impedance of the line', ' ');
INSERT INTO answer VALUES (5858, 1465, 2, 'The same as the input impedance to the generator', ' ');
INSERT INTO answer VALUES (5859, 1465, 3, 'Very high impedance', ' ');
INSERT INTO answer VALUES (5861, 1466, 0, 'Very high impedance', ' ');
INSERT INTO answer VALUES (5862, 1466, 1, 'Very low impedance', ' ');
INSERT INTO answer VALUES (5863, 1466, 2, 'The same as the characteristic impedance of the transmission line', ' ');
INSERT INTO answer VALUES (5864, 1466, 3, 'The same as the generator output impedance', ' ');
INSERT INTO answer VALUES (5865, 1467, 0, 'Impedance along transmission lines', ' ');
INSERT INTO answer VALUES (5866, 1467, 1, 'Radiation resistance', ' ');
INSERT INTO answer VALUES (5867, 1467, 2, 'Antenna radiation pattern', ' ');
INSERT INTO answer VALUES (5868, 1467, 3, 'Radio propagation', ' ');
INSERT INTO answer VALUES (5870, 1468, 0, 'Resistance circles and reactance arcs', ' ');
INSERT INTO answer VALUES (5869, 1468, 1, 'Voltage circles and current arcs', ' ');
INSERT INTO answer VALUES (5871, 1468, 2, 'Voltage lines and current chords', ' ');
INSERT INTO answer VALUES (5872, 1468, 3, 'Resistance lines and reactance chords', ' ');
INSERT INTO answer VALUES (5875, 1469, 0, 'Impedance and SWR values in transmission lines', ' ');
INSERT INTO answer VALUES (5873, 1469, 1, 'Beam headings and radiation patterns', ' ');
INSERT INTO answer VALUES (5874, 1469, 2, 'Satellite azimuth and elevation bearings', ' ');
INSERT INTO answer VALUES (5876, 1469, 3, 'Trigonometric functions', ' ');
INSERT INTO answer VALUES (5879, 1470, 0, 'Resistance and reactance', ' ');
INSERT INTO answer VALUES (5877, 1470, 1, 'Resistance and voltage', ' ');
INSERT INTO answer VALUES (5878, 1470, 2, 'Reactance and voltage', ' ');
INSERT INTO answer VALUES (5880, 1470, 3, 'Voltage and impedance', ' ');
INSERT INTO answer VALUES (5881, 1471, 0, 'Determine the length and position of an impedance matching stub', ' ');
INSERT INTO answer VALUES (5882, 1471, 1, 'Determine the impedance of a transmission line, given the physical dimensions', ' ');
INSERT INTO answer VALUES (5883, 1471, 2, 'Determine the gain of an antenna given the physical and electrical parameters', ' ');
INSERT INTO answer VALUES (5884, 1471, 3, 'Determine the loss/100 feet of a transmission line, given the velocity factor and conductor materials', ' ');
INSERT INTO answer VALUES (5886, 1472, 0, 'Reactance axis', ' ');
INSERT INTO answer VALUES (5885, 1472, 1, 'Prime axis', ' ');
INSERT INTO answer VALUES (5887, 1472, 2, 'Impedance axis', ' ');
INSERT INTO answer VALUES (5888, 1472, 3, 'Polar axis', ' ');
INSERT INTO answer VALUES (5892, 1473, 0, 'The resistance axis', ' ');
INSERT INTO answer VALUES (5889, 1473, 1, 'The reactance axis', ' ');
INSERT INTO answer VALUES (5890, 1473, 2, 'The current axis', ' ');
INSERT INTO answer VALUES (5891, 1473, 3, 'The voltage axis', ' ');
INSERT INTO answer VALUES (5895, 1474, 0, 'Reassigning impedance values with regard to the prime center', ' ');
INSERT INTO answer VALUES (5893, 1474, 1, 'Reassigning resistance values with regard to the reactance axis', ' ');
INSERT INTO answer VALUES (5894, 1474, 2, 'Reassigning reactance values with regard to the resistance axis', ' ');
INSERT INTO answer VALUES (5896, 1474, 3, 'Reassigning prime center with regard to the reactance axis', ' ');
INSERT INTO answer VALUES (5897, 1475, 0, 'Standing wave ratio circles', ' ');
INSERT INTO answer VALUES (5898, 1475, 1, 'Antenna-length circles', ' ');
INSERT INTO answer VALUES (5899, 1475, 2, 'Coaxial-length circles', ' ');
INSERT INTO answer VALUES (5900, 1475, 3, 'Radiation-pattern circles', ' ');
INSERT INTO answer VALUES (5904, 1476, 0, 'Points with constant reactance', ' ');
INSERT INTO answer VALUES (5901, 1476, 1, 'Frequency', ' ');
INSERT INTO answer VALUES (5902, 1476, 2, 'SWR', ' ');
INSERT INTO answer VALUES (5903, 1476, 3, 'Points with constant resistance', ' ');
INSERT INTO answer VALUES (5906, 1477, 0, 'In fractions of transmission line electrical wavelength', ' ');
INSERT INTO answer VALUES (5905, 1477, 1, 'In fractions of transmission line electrical frequency', ' ');
INSERT INTO answer VALUES (5907, 1477, 2, 'In fractions of antenna electrical wavelength', ' ');
INSERT INTO answer VALUES (5908, 1477, 3, 'In fractions of antenna electrical frequency', ' ');
INSERT INTO answer VALUES (5912, 1478, 0, 'It should be one or more wavelengths long', ' ');
INSERT INTO answer VALUES (5909, 1478, 1, 'Its overall length must not exceed 1/4 wavelength', ' ');
INSERT INTO answer VALUES (5910, 1478, 2, 'It must be mounted more than 1 wavelength above ground', ' ');
INSERT INTO answer VALUES (5911, 1478, 3, 'It should be configured as a four-sided loop', ' ');
INSERT INTO answer VALUES (5913, 1479, 0, 'Atmospheric noise is so high that gain over a dipole is not important', ' ');
INSERT INTO answer VALUES (5914, 1479, 1, 'They must be erected at least 1/2 wavelength above the ground to attain good directivity', ' ');
INSERT INTO answer VALUES (5915, 1479, 2, 'Low loss coax transmission line is essential for good performance', ' ');
INSERT INTO answer VALUES (5916, 1479, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5920, 1480, 0, 'Forward gain compared to average gain over the entire hemisphere', ' ');
INSERT INTO answer VALUES (5917, 1480, 1, 'Forward gain compared to the gain in the reverse direction', ' ');
INSERT INTO answer VALUES (5918, 1480, 2, 'Relative directivity compared to isotropic', ' ');
INSERT INTO answer VALUES (5919, 1480, 3, 'Relative directivity compared to a dipole', ' ');
INSERT INTO answer VALUES (5922, 1481, 0, 'It eliminates unbalanced capacitive coupling to the surroundings, improving the nulls', ' ');
INSERT INTO answer VALUES (5921, 1481, 1, 'It adds capacitive loading, increasing the bandwidth of the antenna', ' ');
INSERT INTO answer VALUES (5923, 1481, 2, 'It eliminates tracking errors caused by strong out-of-band signals', ' ');
INSERT INTO answer VALUES (5924, 1481, 3, 'It increases signal strength by providing a better match to the feed line', ' ');
INSERT INTO answer VALUES (5925, 1482, 0, 'It has a bidirectional pattern', ' ');
INSERT INTO answer VALUES (5926, 1482, 1, 'It has no clearly defined null', ' ');
INSERT INTO answer VALUES (5927, 1482, 2, 'It is practical for use only on VHF and higher bands', ' ');
INSERT INTO answer VALUES (5928, 1482, 3, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5931, 1483, 0, 'Antenna headings from several different receiving locations are used to locate the signal source', ' ');
INSERT INTO answer VALUES (5929, 1483, 1, 'The geometric angles of sky waves from the source are used to determine its position', ' ');
INSERT INTO answer VALUES (5930, 1483, 2, 'A fixed receiving station plots three headings to the signal source', ' ');
INSERT INTO answer VALUES (5932, 1483, 3, 'A fixed receiving station uses three different antennas to plot the location of the signal source', ' ');
INSERT INTO answer VALUES (5936, 1484, 0, 'To prevent receiver overload which reduces pattern nulls', ' ');
INSERT INTO answer VALUES (5933, 1484, 1, 'To narrow the receiver bandwidth', ' ');
INSERT INTO answer VALUES (5934, 1484, 2, 'To compensate for isotropic directivity and the antenna effect of feed lines', ' ');
INSERT INTO answer VALUES (5935, 1484, 3, 'To increase receiver sensitivity', ' ');
INSERT INTO answer VALUES (5937, 1485, 0, 'It modifies the pattern of a DF antenna array to provide a null in one direction', ' ');
INSERT INTO answer VALUES (5938, 1485, 1, 'It increases the sensitivity of a DF antenna array', ' ');
INSERT INTO answer VALUES (5939, 1485, 2, 'It allows DF antennas to receive signals at different vertical angles', ' ');
INSERT INTO answer VALUES (5940, 1485, 3, 'It provides diversity reception that cancels multipath signals', ' ');
INSERT INTO answer VALUES (5942, 1486, 0, 'A small, vertically oriented receiving antenna consisting of a triangular loop terminated in approximately 900 ohms', ' ');
INSERT INTO answer VALUES (5941, 1486, 1, 'A four-element, high-gain vertical array invented by George Pennant', ' ');
INSERT INTO answer VALUES (5943, 1486, 2, 'A form of rhombic antenna terminated in a variable capacitor to provide frequency diversity', ' ');
INSERT INTO answer VALUES (5944, 1486, 3, 'A stealth antenna built to look like a flagpole', ' ');
INSERT INTO answer VALUES (5948, 1487, 0, 'By increasing the number of turns and/or the area', ' ');
INSERT INTO answer VALUES (5945, 1487, 1, 'By reducing the permeability of the loop shield', ' ');
INSERT INTO answer VALUES (5946, 1487, 2, 'By utilizing high impedance wire for the coupling loop', ' ');
INSERT INTO answer VALUES (5947, 1487, 3, 'By winding adjacent turns in opposing directions', ' ');
INSERT INTO answer VALUES (5950, 1488, 0, 'A very sharp single null', ' ');
INSERT INTO answer VALUES (5949, 1488, 1, 'A very sharp peak', ' ');
INSERT INTO answer VALUES (5951, 1488, 2, 'Broadband response', ' ');
INSERT INTO answer VALUES (5952, 1488, 3, 'High radiation angle', ' ');
INSERT INTO answer VALUES (5954, 1489, 0, 'Lightning protection', ' ');
INSERT INTO answer VALUES (5953, 1489, 1, 'Reduce received noise', ' ');
INSERT INTO answer VALUES (5955, 1489, 2, 'Reduce RF current flow between pieces of equipment', ' ');
INSERT INTO answer VALUES (5956, 1489, 3, 'Reduce RFI to telephones and home entertainment systems', ' ');
INSERT INTO answer VALUES (5958, 1490, 0, 'Ensure signals from your station are less than the uncontrolled Maximum Permitted Exposure (MPE) limits', ' ');
INSERT INTO answer VALUES (5957, 1490, 1, 'Ensure signals from your station are less than the controlled Maximum Permitted Exposure (MPE) limits', ' ');
INSERT INTO answer VALUES (5959, 1490, 2, 'Ensure signals from your station are less than the controlled Maximum Permitted Emission (MPE) limits', ' ');
INSERT INTO answer VALUES (5960, 1490, 3, 'Ensure signals from your station are less than the uncontrolled Maximum Permitted Emission (MPE) limits', ' ');
INSERT INTO answer VALUES (5963, 1491, 0, '30 to 300 MHz', ' ');
INSERT INTO answer VALUES (5961, 1491, 1, '300 kHz to 3 MHz', ' ');
INSERT INTO answer VALUES (5962, 1491, 2, '3 to 30 MHz', ' ');
INSERT INTO answer VALUES (5964, 1491, 3, '300 to 3000 MHz', ' ');
INSERT INTO answer VALUES (5967, 1492, 0, 'Each transmitter that produces 5 percent or more of its MPE limit in areas where the total MPE limit is exceeded.', ' ');
INSERT INTO answer VALUES (5965, 1492, 1, 'Only the most powerful transmitter', ' ');
INSERT INTO answer VALUES (5966, 1492, 2, 'Only commercial transmitters', ' ');
INSERT INTO answer VALUES (5968, 1492, 3, 'Each transmitter operating with a duty cycle greater than 50 percent', ' ');
INSERT INTO answer VALUES (5970, 1493, 0, 'The high gain antennas commonly used can result in high exposure levels', ' ');
INSERT INTO answer VALUES (5969, 1493, 1, 'Microwaves are ionizing radiation', ' ');
INSERT INTO answer VALUES (5971, 1493, 2, 'Microwaves often travel long distances by ionospheric reflection', ' ');
INSERT INTO answer VALUES (5972, 1493, 3, 'The extremely high frequency energy can damage the joints of antenna structures', ' ');
INSERT INTO answer VALUES (5976, 1494, 0, 'All these choices are correct', ' ');
INSERT INTO answer VALUES (5973, 1494, 1, 'The body reacts to electromagnetic radiation from both the E and H fields', ' ');
INSERT INTO answer VALUES (5974, 1494, 2, 'Ground reflections and scattering make the field strength vary with location', ' ');
INSERT INTO answer VALUES (5975, 1494, 3, 'E field and H field radiation intensity peaks can occur at different locations', ' ');
INSERT INTO answer VALUES (5978, 1495, 0, 'Only with a carbon monoxide detector', ' ');
INSERT INTO answer VALUES (5977, 1495, 1, 'By the odor', ' ');
INSERT INTO answer VALUES (5979, 1495, 2, 'Any ordinary smoke detector can be used', ' ');
INSERT INTO answer VALUES (5980, 1495, 3, 'By the yellowish appearance of the gas', ' ');
INSERT INTO answer VALUES (5983, 1496, 0, 'The rate at which RF energy is absorbed by the body', ' ');
INSERT INTO answer VALUES (5981, 1496, 1, 'Synthetic Aperture Ratio of the human body', ' ');
INSERT INTO answer VALUES (5982, 1496, 2, 'Signal Amplification Rating', ' ');
INSERT INTO answer VALUES (5984, 1496, 3, 'The rate of RF energy reflected from stationary terrain', ' ');
INSERT INTO answer VALUES (5987, 1497, 0, 'Beryllium Oxide', ' ');
INSERT INTO answer VALUES (5985, 1497, 1, 'Mica', ' ');
INSERT INTO answer VALUES (5986, 1497, 2, 'Zinc oxide', ' ');
INSERT INTO answer VALUES (5988, 1497, 3, 'Uranium Hexafluoride', ' ');
INSERT INTO answer VALUES (5989, 1498, 0, 'Polychlorinated biphenyls', ' ');
INSERT INTO answer VALUES (5990, 1498, 1, 'Polyethylene', ' ');
INSERT INTO answer VALUES (5991, 1498, 2, 'Polytetrafluoroethylene', ' ');
INSERT INTO answer VALUES (5992, 1498, 3, 'Polymorphic silicon', ' ');
INSERT INTO answer VALUES (5995, 1499, 0, 'Localized heating of the body from RF exposure in excess of the MPE limits', ' ');
INSERT INTO answer VALUES (5993, 1499, 1, 'Hearing loss caused by high voltage corona discharge', ' ');
INSERT INTO answer VALUES (5994, 1499, 2, 'Blood clotting from the intense magnetic field', ' ');
INSERT INTO answer VALUES (5996, 1499, 3, 'Ingestion of ozone gas from the cooling system', ' ');

INSERT INTO answer VALUES (5997, 1500, 0, 'No, the sideband will extend beyond the band edge', ' ');
INSERT INTO answer VALUES (5998, 1500, 1, 'Yes, because you were not the station calling CQ', ' ');
INSERT INTO answer VALUES (5999, 1500, 2, 'Yes, because the displayed frequency is within the 20 meter band', ' ');
INSERT INTO answer VALUES (6000, 1500, 3, 'No, U.S. stations are not permitted to use phone emissions above 14.340 MHz', ' ');
INSERT INTO answer VALUES (6001, 1501, 0, '60 meter band', ' ');
INSERT INTO answer VALUES (6002, 1501, 1, '12 meter band', ' ');
INSERT INTO answer VALUES (6003, 1501, 2, '17 meter band', ' ');
INSERT INTO answer VALUES (6004, 1501, 3, '30 meter band', ' ');
INSERT INTO answer VALUES (6005, 1502, 0, 'No, one of the sidebands of the CW signal will be out of the band', ' ');
INSERT INTO answer VALUES (6006, 1502, 1, 'Yes, the DX station initiated the contact', ' ');
INSERT INTO answer VALUES (6007, 1502, 2, 'Yes, the displayed frequency is within the 80 meter CW band segment', ' ');
INSERT INTO answer VALUES (6008, 1502, 3, 'No, U.S. stations are not permitted to use CW emissions below 3.525 MHz', ' ');
INSERT INTO answer VALUES (6009, 1503, 0, 'The location is of environmental importance or significant in American history, architecture, or culture', ' ');
INSERT INTO answer VALUES (6010, 1503, 1, 'The location is near an area of political conflict', ' ');
INSERT INTO answer VALUES (6011, 1503, 2, 'The location is of geographical or horticultural importance', ' ');
INSERT INTO answer VALUES (6012, 1503, 3, 'The location is in an ITU Zone designated for coordination with one or more foreign governments', ' ');
INSERT INTO answer VALUES (6013, 1504, 0, 'A station controlled indirectly through a control link', ' ');
INSERT INTO answer VALUES (6014, 1504, 1, 'A station operated away from its regular home location', ' ');
INSERT INTO answer VALUES (6015, 1504, 2, 'A station controlled by someone other than the licensee', ' ');
INSERT INTO answer VALUES (6016, 1504, 3, 'A station operating under automatic control', ' ');
INSERT INTO answer VALUES (6017, 1505, 0, 'The use of devices and procedures for control so that the control operator does not have to be present at a control point', ' ');
INSERT INTO answer VALUES (6018, 1505, 1, 'A station operating with its output power controlled automatically', ' ');
INSERT INTO answer VALUES (6019, 1505, 2, 'Remotely controlling a station’s antenna pattern through a directional control link', ' ');
INSERT INTO answer VALUES (6020, 1505, 3, 'The use of a control link between a control point and a locally controlled station', ' ');
INSERT INTO answer VALUES (6021, 1506, 0, 'A control operator must be present at the control point', ' ');
INSERT INTO answer VALUES (6022, 1506, 1, 'Only Extra Class operators may be the control operator of a remote station', ' ');
INSERT INTO answer VALUES (6023, 1506, 2, 'A control operator need not be present at the control point', ' ');
INSERT INTO answer VALUES (6024, 1506, 3, 'Repeater and auxiliary stations may not be remotely controlled', ' ');
INSERT INTO answer VALUES (6025, 1507, 0, 'Direct manipulation of the transmitter by a control operator', ' ');
INSERT INTO answer VALUES (6026, 1507, 1, 'Controlling a station through a local auxiliary link', ' ');
INSERT INTO answer VALUES (6027, 1507, 2, 'Automatically manipulating local station controls', ' ');
INSERT INTO answer VALUES (6028, 1507, 3, 'Controlling a repeater using a portable handheld transceiver', ' ');
INSERT INTO answer VALUES (6029, 1508, 0, '29.500 MHz - 29.700 MHz', ' ');
INSERT INTO answer VALUES (6030, 1508, 1, '18.110 MHz - 18.168 MHz', ' ');
INSERT INTO answer VALUES (6031, 1508, 2, '24.940 MHz - 24.990 MHz', ' ');
INSERT INTO answer VALUES (6032, 1508, 3, '10.100 MHz - 10.150 MHz', ' ');
INSERT INTO answer VALUES (6033, 1509, 0, 'Only auxiliary, repeater or space stations', ' ');
INSERT INTO answer VALUES (6034, 1509, 1, 'Only beacon, repeater or space stations', ' ');
INSERT INTO answer VALUES (6035, 1509, 2, 'Only earth stations, repeater stations or model craft', ' ');
INSERT INTO answer VALUES (6036, 1509, 3, 'Only auxiliary, beacon or space stations', ' ');
INSERT INTO answer VALUES (6037, 1510, 0, 'A radio communications service using amateur radio stations on satellites', ' ');
INSERT INTO answer VALUES (6038, 1510, 1, 'A radio navigation service using satellites for the purpose of self training, intercommunication and technical studies carried out by amateurs', ' ');
INSERT INTO answer VALUES (6039, 1510, 2, 'A spacecraft launching service for amateur-built satellites', ' ');
INSERT INTO answer VALUES (6040, 1510, 3, 'A radio communications service using stations on Earth satellites for public service broadcast', ' ');
INSERT INTO answer VALUES (6041, 1511, 0, 'An amateur station within 50 km of the Earth''s surface intended for communications with amateur stations by means of objects in space', ' ');
INSERT INTO answer VALUES (6042, 1511, 1, 'An amateur station that is not able to communicate using amateur satellites', ' ');
INSERT INTO answer VALUES (6043, 1511, 2, 'An amateur station that transmits telemetry consisting of measurement of upper atmosphere data', ' ');
INSERT INTO answer VALUES (6044, 1511, 3, 'Any amateur station on the surface of the Earth', ' ');
INSERT INTO answer VALUES (6045, 1512, 0, 'Any class with appropriate operator privileges', ' ');
INSERT INTO answer VALUES (6046, 1512, 1, 'All except Technician Class', ' ');
INSERT INTO answer VALUES (6047, 1512, 2, 'Only General, Advanced or Amateur Extra Class', ' ');
INSERT INTO answer VALUES (6048, 1512, 3, 'Only Amateur Extra Class', ' ');
INSERT INTO answer VALUES (6049, 1513, 0, 'The space station must be capable of terminating transmissions by telecommand when directed by the FCC', ' ');
INSERT INTO answer VALUES (6050, 1513, 1, 'The space station must cease all transmissions after 5 years', ' ');
INSERT INTO answer VALUES (6051, 1513, 2, 'The space station must be capable of changing its orbit whenever such a change is ordered by NASA', ' ');
INSERT INTO answer VALUES (6052, 1513, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6053, 1514, 0, '3', ' ');
INSERT INTO answer VALUES (6054, 1514, 1, '5', ' ');
INSERT INTO answer VALUES (6055, 1514, 2, '2', ' ');
INSERT INTO answer VALUES (6056, 1514, 3, '4', ' ');
INSERT INTO answer VALUES (6057, 1515, 0, 'Use a real-time video link and the Internet to connect the exam session to the observing VEs', ' ');
INSERT INTO answer VALUES (6058, 1515, 1, 'Record the exam session on video tape for later review by the VE team', ' ');
INSERT INTO answer VALUES (6059, 1515, 2, 'The exam proctor observes the applicants and reports any violations', ' ');
INSERT INTO answer VALUES (6060, 1515, 3, 'Have each applicant sign an affidavit stating that all session rules were followed', ' ');
INSERT INTO answer VALUES (6061, 1516, 0, '10 W', ' ');
INSERT INTO answer VALUES (6062, 1516, 1, '1 W', ' ');
INSERT INTO answer VALUES (6063, 1516, 2, '1.5 W', ' ');
INSERT INTO answer VALUES (6064, 1516, 3, '1.5 kW', ' ');
INSERT INTO answer VALUES (6065, 1517, 0, 'From north to south', ' ');
INSERT INTO answer VALUES (6066, 1517, 1, 'From west to east', ' ');
INSERT INTO answer VALUES (6067, 1517, 2, 'From east to west', ' ');
INSERT INTO answer VALUES (6068, 1517, 3, 'From south to north', ' ');
INSERT INTO answer VALUES (6069, 1518, 0, 'The time it takes for a satellite to complete one revolution around the Earth', ' ');
INSERT INTO answer VALUES (6070, 1518, 1, 'The point of maximum height of a satellite''s orbit', ' ');
INSERT INTO answer VALUES (6071, 1518, 2, 'The point of minimum height of a satellite''s orbit', ' ');
INSERT INTO answer VALUES (6072, 1518, 3, 'The time it takes for a satellite to travel from perigee to apogee', ' ');
INSERT INTO answer VALUES (6073, 1519, 0, '435 MHz - 438 MHz', ' ');
INSERT INTO answer VALUES (6074, 1519, 1, '144 MHz - 146 MHz', ' ');
INSERT INTO answer VALUES (6075, 1519, 2, '50.0 MHz - 50.2 MHz', ' ');
INSERT INTO answer VALUES (6076, 1519, 3, '29.5 MHz - 29.7 MHz', ' ');
INSERT INTO answer VALUES (6077, 1520, 0, 'Because the satellite is spinning', ' ');
INSERT INTO answer VALUES (6078, 1520, 1, 'Because of ionospheric absorption', ' ');
INSERT INTO answer VALUES (6079, 1520, 2, 'Because of the satellite''s low orbital altitude', ' ');
INSERT INTO answer VALUES (6080, 1520, 3, 'Because of the Doppler Effect', ' ');
INSERT INTO answer VALUES (6081, 1521, 0, 'By calculations using the Keplerian elements for the specified satellite', ' ');
INSERT INTO answer VALUES (6082, 1521, 1, 'By means of the Doppler data for the specified satellite', ' ');
INSERT INTO answer VALUES (6083, 1521, 2, 'By subtracting the mean anomaly from the orbital inclination', ' ');
INSERT INTO answer VALUES (6084, 1521, 3, 'By adding the mean anomaly to the orbital inclination', ' ');
INSERT INTO answer VALUES (6085, 1522, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6086, 1522, 1, 'Frequency-modulated sub-carrier', ' ');
INSERT INTO answer VALUES (6087, 1522, 2, 'A separate VHF or UHF audio link', ' ');
INSERT INTO answer VALUES (6088, 1522, 3, 'Frequency modulation of the video carrier', ' ');
INSERT INTO answer VALUES (6089, 1523, 0, 'Varying tone frequencies representing the video are transmitted using single sideband', ' ');
INSERT INTO answer VALUES (6090, 1523, 1, 'Video is converted to equivalent Baudot representation', ' ');
INSERT INTO answer VALUES (6091, 1523, 2, 'Video is converted to equivalent ASCII representation', ' ');
INSERT INTO answer VALUES (6092, 1523, 3, 'Varying tone frequencies representing the video are transmitted using PSK', ' ');
INSERT INTO answer VALUES (6093, 1524, 0, '128 or 256', ' ');
INSERT INTO answer VALUES (6094, 1524, 1, '30 or 60', ' ');
INSERT INTO answer VALUES (6095, 1524, 2, '60 or 100', ' ');
INSERT INTO answer VALUES (6096, 1524, 3, '180 or 360', ' ');
INSERT INTO answer VALUES (6097, 1525, 0, '3 kHz', ' ');
INSERT INTO answer VALUES (6098, 1525, 1, '600 Hz', ' ');
INSERT INTO answer VALUES (6099, 1525, 2, '2 MHz', ' ');
INSERT INTO answer VALUES (6100, 1525, 3, '6 MHz', ' ');
INSERT INTO answer VALUES (6101, 1526, 0, '1255 MHz', ' ');
INSERT INTO answer VALUES (6102, 1526, 1, '14.230 MHz', ' ');
INSERT INTO answer VALUES (6103, 1526, 2, '29.6 MHz', ' ');
INSERT INTO answer VALUES (6104, 1526, 3, '52.525 MHz', ' ');
INSERT INTO answer VALUES (6105, 1527, 0, 'Operators are permitted to make contacts even if they do not submit a log', ' ');
INSERT INTO answer VALUES (6106, 1527, 1, 'Interference to other amateurs is unavoidable and therefore acceptable', ' ');
INSERT INTO answer VALUES (6107, 1527, 2, 'It is mandatory to transmit the call sign of the station being worked as part of every transmission to that station', ' ');
INSERT INTO answer VALUES (6108, 1527, 3, 'Every contest requires a signal report in the exchange', ' ');
INSERT INTO answer VALUES (6109, 1528, 0, 'It can decode signals many dB below the noise floor using FEC', ' ');
INSERT INTO answer VALUES (6110, 1528, 1, 'It controls the receiver to track Doppler shift', ' ');
INSERT INTO answer VALUES (6111, 1528, 2, 'It supplies signals to guide the antenna to track the Moon', ' ');
INSERT INTO answer VALUES (6112, 1528, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6113, 1529, 0, '316 Hz', ' ');
INSERT INTO answer VALUES (6114, 1529, 1, '31 Hz', ' ');
INSERT INTO answer VALUES (6115, 1529, 2, '550 Hz', ' ');
INSERT INTO answer VALUES (6116, 1529, 3, '2.16 kHz', ' ');
INSERT INTO answer VALUES (6117, 1530, 0, 'Automatic', ' ');
INSERT INTO answer VALUES (6118, 1530, 1, 'Local', ' ');
INSERT INTO answer VALUES (6119, 1530, 2, 'Remote', ' ');
INSERT INTO answer VALUES (6120, 1530, 3, 'ALE can use any type of control', ' ');
INSERT INTO answer VALUES (6121, 1531, 0, 'The rain must be within radio range of both stations', ' ');
INSERT INTO answer VALUES (6122, 1531, 1, 'Rain droplets must be electrically charged', ' ');
INSERT INTO answer VALUES (6123, 1531, 2, 'Rain droplets must be within the E layer', ' ');
INSERT INTO answer VALUES (6124, 1531, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6125, 1532, 0, 'North', ' ');
INSERT INTO answer VALUES (6126, 1532, 1, 'South', ' ');
INSERT INTO answer VALUES (6127, 1532, 2, 'East', ' ');
INSERT INTO answer VALUES (6128, 1532, 3, 'West', ' ');
INSERT INTO answer VALUES (6129, 1533, 0, 'A wave consisting of an electric field and a magnetic field oscillating at right angles to each other', ' ');
INSERT INTO answer VALUES (6130, 1533, 1, 'A wave of alternating current, in the core of an electromagnet', ' ');
INSERT INTO answer VALUES (6131, 1533, 2, 'A wave consisting of two electric fields at parallel right angles to each other', ' ');
INSERT INTO answer VALUES (6132, 1533, 3, 'A wave consisting of two magnetic fields at right angles to each other', ' ');
INSERT INTO answer VALUES (6133, 1534, 0, 'Changing electric and magnetic fields propagate the energy', ' ');
INSERT INTO answer VALUES (6134, 1534, 1, 'Electric and magnetic fields become aligned as they travel', ' ');
INSERT INTO answer VALUES (6135, 1534, 2, 'The energy propagates through a medium with a high refractive index', ' ');
INSERT INTO answer VALUES (6136, 1534, 3, 'The waves are reflected by the ionosphere and return to their source', ' ');
INSERT INTO answer VALUES (6137, 1535, 0, 'Receipt of a signal by more than one path', ' ');
INSERT INTO answer VALUES (6138, 1535, 1, 'High D layer absorption', ' ');
INSERT INTO answer VALUES (6139, 1535, 2, 'Meteor scatter', ' ');
INSERT INTO answer VALUES (6140, 1535, 3, 'Transmit frequency is higher than the MUF', ' ');
INSERT INTO answer VALUES (6141, 1536, 0, 'At twilight and sunrise, D-layer absorption is low while E-layer and F-layer propagation remains high', ' ');
INSERT INTO answer VALUES (6142, 1536, 1, 'At midday, the Sun super heats the ionosphere causing increased refraction of radio waves', ' ');
INSERT INTO answer VALUES (6143, 1536, 2, 'In darkness, solar absorption drops greatly while atmospheric ionization remains steady', ' ');
INSERT INTO answer VALUES (6144, 1536, 3, 'At mid-afternoon, the Sun heats the ionosphere decreasing radio wave refraction and the MUF', ' ');
INSERT INTO answer VALUES (6145, 1537, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6146, 1537, 1, 'Automatic amplitude and frequency numerical readout', ' ');
INSERT INTO answer VALUES (6147, 1537, 2, 'Storage of traces for future reference', ' ');
INSERT INTO answer VALUES (6148, 1537, 3, 'Manipulation of time base after trace capture', ' ');
INSERT INTO answer VALUES (6149, 1538, 0, 'One-half the sample rate', ' ');
INSERT INTO answer VALUES (6150, 1538, 1, 'The same as the sample rate', ' ');
INSERT INTO answer VALUES (6151, 1538, 2, 'One-tenth the sample rate', ' ');
INSERT INTO answer VALUES (6152, 1538, 3, 'It depends on how the data is stored internally', ' ');
INSERT INTO answer VALUES (6153, 1539, 0, 'Attenuate the transmitter output going to the spectrum analyzer', ' ');
INSERT INTO answer VALUES (6154, 1539, 1, 'Use high quality double shielded coaxial cables to reduce signal losses', ' ');
INSERT INTO answer VALUES (6155, 1539, 2, 'Match the antenna to the load', ' ');
INSERT INTO answer VALUES (6156, 1539, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6157, 1540, 0, 'It provides improved resolution of low-frequency signals within a comparable time period', ' ');
INSERT INTO answer VALUES (6158, 1540, 1, 'It can run on battery power for remote measurements', ' ');
INSERT INTO answer VALUES (6159, 1540, 2, 'It does not require an expensive high-precision time base', ' ');
INSERT INTO answer VALUES (6160, 1540, 3, 'It can directly measure the modulation index of an FM transmitter', ' ');
INSERT INTO answer VALUES (6161, 1541, 0, 'It is very precise in obtaining a signal null', ' ');
INSERT INTO answer VALUES (6162, 1541, 1, 'It provides an excellent match under all conditions', ' ');
INSERT INTO answer VALUES (6163, 1541, 2, 'It is relatively immune to drift in the signal generator source', ' ');
INSERT INTO answer VALUES (6164, 1541, 3, 'It can display results directly in Smith chart format', ' ');
INSERT INTO answer VALUES (6165, 1542, 0, '146.52 Hz', ' ');
INSERT INTO answer VALUES (6166, 1542, 1, '165.2 Hz', ' ');
INSERT INTO answer VALUES (6167, 1542, 2, '14.652 kHz', ' ');
INSERT INTO answer VALUES (6168, 1542, 3, '1.4652 MHz', ' ');
INSERT INTO answer VALUES (6169, 1543, 0, '14.652 Hz', ' ');
INSERT INTO answer VALUES (6170, 1543, 1, '0.1 MHz', ' ');
INSERT INTO answer VALUES (6171, 1543, 2, '1.4652 Hz', ' ');
INSERT INTO answer VALUES (6172, 1543, 3, '1.4652 kHz', ' ');
INSERT INTO answer VALUES (6173, 1544, 0, '1465.20 Hz', ' ');
INSERT INTO answer VALUES (6174, 1544, 1, '146.52 Hz', ' ');
INSERT INTO answer VALUES (6175, 1544, 2, '10 Hz', ' ');
INSERT INTO answer VALUES (6176, 1544, 3, '146.52 kHz', ' ');
INSERT INTO answer VALUES (6177, 1545, 0, 'A less accurate reading results', ' ');
INSERT INTO answer VALUES (6178, 1545, 1, 'Harmonics are generated', ' ');
INSERT INTO answer VALUES (6179, 1545, 2, 'Cross modulation occurs', ' ');
INSERT INTO answer VALUES (6180, 1545, 3, 'Intermodulation distortion occurs', ' ');
INSERT INTO answer VALUES (6181, 1546, 0, '300 Hz', ' ');
INSERT INTO answer VALUES (6182, 1546, 1, '100 Hz', ' ');
INSERT INTO answer VALUES (6183, 1546, 2, '6000 Hz', ' ');
INSERT INTO answer VALUES (6184, 1546, 3, '2400 Hz', ' ');
INSERT INTO answer VALUES (6185, 1547, 0, '2.4 kHz', ' ');
INSERT INTO answer VALUES (6186, 1547, 1, '1 kHz', ' ');
INSERT INTO answer VALUES (6187, 1547, 2, '4.2 kHz', ' ');
INSERT INTO answer VALUES (6188, 1547, 3, '4.8 kHz', ' ');
INSERT INTO answer VALUES (6189, 1548, 0, 'Undesired signals may be heard', ' ');
INSERT INTO answer VALUES (6190, 1548, 1, 'Output-offset overshoot', ' ');
INSERT INTO answer VALUES (6191, 1548, 2, 'Filter ringing', ' ');
INSERT INTO answer VALUES (6192, 1548, 3, 'Thermal-noise distortion', ' ');
INSERT INTO answer VALUES (6193, 1549, 0, 'Distortion', ' ');
INSERT INTO answer VALUES (6194, 1549, 1, 'Overload', ' ');
INSERT INTO answer VALUES (6195, 1549, 2, 'Loss of sensitivity', ' ');
INSERT INTO answer VALUES (6196, 1549, 3, 'Excess output level', ' ');
INSERT INTO answer VALUES (6197, 1550, 0, 'Analog-to-digital converter sample width in bits', ' ');
INSERT INTO answer VALUES (6198, 1550, 1, 'CPU register width in bits', ' ');
INSERT INTO answer VALUES (6199, 1550, 2, 'Anti-aliasing input filter bandwidth', ' ');
INSERT INTO answer VALUES (6200, 1550, 3, 'RAM speed used for data storage', ' ');
INSERT INTO answer VALUES (6201, 1551, 0, 'The off-frequency unwanted signal is heard in addition to the desired signal', ' ');
INSERT INTO answer VALUES (6202, 1551, 1, 'A large increase in background noise', ' ');
INSERT INTO answer VALUES (6203, 1551, 2, 'A reduction in apparent signal strength', ' ');
INSERT INTO answer VALUES (6204, 1551, 3, 'The desired signal can no longer be heard', ' ');
INSERT INTO answer VALUES (6205, 1552, 0, 'Strong adjacent channel signals', ' ');
INSERT INTO answer VALUES (6206, 1552, 1, 'Audio gain adjusted too low', ' ');
INSERT INTO answer VALUES (6207, 1552, 2, 'Audio bias adjusted too high', ' ');
INSERT INTO answer VALUES (6208, 1552, 3, 'Squelch gain misadjusted', ' ');
INSERT INTO answer VALUES (6209, 1553, 0, 'Ignition noise', ' ');
INSERT INTO answer VALUES (6210, 1553, 1, 'Broadband white noise', ' ');
INSERT INTO answer VALUES (6211, 1553, 2, 'Heterodyne interference', ' ');
INSERT INTO answer VALUES (6212, 1553, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6213, 1554, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6214, 1554, 1, 'Broadband white noise', ' ');
INSERT INTO answer VALUES (6215, 1554, 2, 'Ignition noise', ' ');
INSERT INTO answer VALUES (6216, 1554, 3, 'Power line noise', ' ');
INSERT INTO answer VALUES (6217, 1555, 0, 'Thunderstorms', ' ');
INSERT INTO answer VALUES (6218, 1555, 1, 'Solar radio frequency emissions', ' ');
INSERT INTO answer VALUES (6219, 1555, 2, 'Geomagnetic storms', ' ');
INSERT INTO answer VALUES (6220, 1555, 3, 'Meteor showers', ' ');
INSERT INTO answer VALUES (6221, 1556, 0, 'By turning off the AC power line main circuit breaker and listening on a battery operated radio', ' ');
INSERT INTO answer VALUES (6222, 1556, 1, 'By checking the power line voltage with a time domain reflectometer', ' ');
INSERT INTO answer VALUES (6223, 1556, 2, 'By observing the AC power line waveform with an oscilloscope', ' ');
INSERT INTO answer VALUES (6224, 1556, 3, 'By observing the AC power line voltage with a spectrum analyzer', ' ');
INSERT INTO answer VALUES (6225, 1557, 0, 'A common-mode signal at the frequency of the radio transmitter', ' ');
INSERT INTO answer VALUES (6226, 1557, 1, 'An electrical-sparking signal', ' ');
INSERT INTO answer VALUES (6227, 1557, 2, 'A differential-mode signal at the AC power line frequency', ' ');
INSERT INTO answer VALUES (6228, 1557, 3, 'Harmonics of the AC power line frequency', ' ');
INSERT INTO answer VALUES (6229, 1558, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6230, 1558, 1, 'The interfering signal sounds like AC hum on an AM receiver or a carrier modulated by 60 Hz hum on a SSB or CW receiver', ' ');
INSERT INTO answer VALUES (6231, 1558, 2, 'The interfering signal may drift slowly across the HF spectrum', ' ');
INSERT INTO answer VALUES (6232, 1558, 3, 'The interfering signal can be several kHz in width and usually repeats at regular intervals across a HF band', ' ');
INSERT INTO answer VALUES (6233, 1559, 0, 'Nearby corroded metal joints are mixing and re-radiating the broadcast signals', ' ');
INSERT INTO answer VALUES (6234, 1559, 1, 'The broadcast station is transmitting an over-modulated signal', ' ');
INSERT INTO answer VALUES (6235, 1559, 2, 'You are receiving sky wave signals from a distant station', ' ');
INSERT INTO answer VALUES (6236, 1559, 3, 'Your station receiver IF amplifier stage is defective', ' ');
INSERT INTO answer VALUES (6237, 1560, 0, 'Approximately equal to circuit resistance', ' ');
INSERT INTO answer VALUES (6238, 1560, 1, 'Approximately equal to inductive reactance', ' ');
INSERT INTO answer VALUES (6239, 1560, 2, 'Low, as compared to the circuit resistance', ' ');
INSERT INTO answer VALUES (6240, 1560, 3, 'Approximately equal to capacitive reactance', ' ');
INSERT INTO answer VALUES (6241, 1561, 0, 'Maximum', ' ');
INSERT INTO answer VALUES (6242, 1561, 1, 'Minimum', ' ');
INSERT INTO answer VALUES (6243, 1561, 2, 'R/L', ' ');
INSERT INTO answer VALUES (6244, 1561, 3, 'L/R', ' ');
INSERT INTO answer VALUES (6245, 1562, 0, 'One time constant', ' ');
INSERT INTO answer VALUES (6246, 1562, 1, 'One discharge period', ' ');
INSERT INTO answer VALUES (6247, 1562, 2, 'An exponential discharge rate of one', ' ');
INSERT INTO answer VALUES (6248, 1562, 3, 'A discharge factor of one', ' ');
INSERT INTO answer VALUES (6249, 1563, 0, 'The sign is reversed', ' ');
INSERT INTO answer VALUES (6250, 1563, 1, 'It is unchanged', ' ');
INSERT INTO answer VALUES (6251, 1563, 2, 'It is shifted by 90 degrees', ' ');
INSERT INTO answer VALUES (6252, 1563, 3, 'The susceptance phase angle is the inverse of the reactance phase angle', ' ');
INSERT INTO answer VALUES (6253, 1564, 0, 'A negative phase angle', ' ');
INSERT INTO answer VALUES (6254, 1564, 1, 'A positive real part', ' ');
INSERT INTO answer VALUES (6255, 1564, 2, 'A negative real part', ' ');
INSERT INTO answer VALUES (6256, 1564, 3, 'A positive phase angle', ' ');
INSERT INTO answer VALUES (6257, 1565, 0, 'A quantity with both magnitude and an angular component', ' ');
INSERT INTO answer VALUES (6258, 1565, 1, 'The value of a quantity that changes over time', ' ');
INSERT INTO answer VALUES (6259, 1565, 2, 'The inverse of the tangent function', ' ');
INSERT INTO answer VALUES (6260, 1565, 3, 'The inverse of the sine function', ' ');
INSERT INTO answer VALUES (6261, 1566, 0, 'Reactive component', ' ');
INSERT INTO answer VALUES (6262, 1566, 1, 'Resistive component', ' ');
INSERT INTO answer VALUES (6263, 1566, 2, 'The sum of the reactive and resistive components', ' ');
INSERT INTO answer VALUES (6264, 1566, 3, 'The difference between the resistive and reactive components', ' ');
INSERT INTO answer VALUES (6265, 1567, 0, 'The coordinate values along the horizontal and vertical axes', ' ');
INSERT INTO answer VALUES (6266, 1567, 1, 'The magnitude and phase of the point', ' ');
INSERT INTO answer VALUES (6267, 1567, 2, 'The sine and cosine values', ' ');
INSERT INTO answer VALUES (6268, 1567, 3, 'The tangent and cotangent values', ' ');
INSERT INTO answer VALUES (6269, 1568, 0, 'It is equivalent to a pure resistance', ' ');
INSERT INTO answer VALUES (6270, 1568, 1, 'It has to be a direct current circuit', ' ');
INSERT INTO answer VALUES (6271, 1568, 2, 'It contains resistance and capacitive reactance', ' ');
INSERT INTO answer VALUES (6272, 1568, 3, 'It contains resistance and inductive reactance', ' ');
INSERT INTO answer VALUES (6273, 1569, 0, 'Point 8', ' ');
INSERT INTO answer VALUES (6274, 1569, 1, 'Point 1', ' ');
INSERT INTO answer VALUES (6275, 1569, 2, 'Point 3', ' ');
INSERT INTO answer VALUES (6276, 1569, 3, 'Point 5', ' ');
INSERT INTO answer VALUES (6277, 1570, 0, 'Inductance', ' ');
INSERT INTO answer VALUES (6278, 1570, 1, 'Permeability', ' ');
INSERT INTO answer VALUES (6279, 1570, 2, 'Permittivity', ' ');
INSERT INTO answer VALUES (6280, 1570, 3, 'Malleability', ' ');
INSERT INTO answer VALUES (6281, 1571, 0, 'The amount of current flowing through the conductor', ' ');
INSERT INTO answer VALUES (6282, 1571, 1, 'The resistance divided by the current', ' ');
INSERT INTO answer VALUES (6283, 1571, 2, 'The ratio of the current to the resistance', ' ');
INSERT INTO answer VALUES (6284, 1571, 3, 'The diameter of the conductor', ' ');
INSERT INTO answer VALUES (6285, 1572, 0, 'Potential energy', ' ');
INSERT INTO answer VALUES (6286, 1572, 1, 'Electromechanical energy', ' ');
INSERT INTO answer VALUES (6287, 1572, 2, 'Thermodynamic energy', ' ');
INSERT INTO answer VALUES (6288, 1572, 3, 'Kinetic energy', ' ');
INSERT INTO answer VALUES (6289, 1573, 0, 'The change of collector current with respect to emitter current', ' ');
INSERT INTO answer VALUES (6290, 1573, 1, 'The change of collector current with respect to base current', ' ');
INSERT INTO answer VALUES (6291, 1573, 2, 'The change of base current with respect to collector current', ' ');
INSERT INTO answer VALUES (6292, 1573, 3, 'The change of collector current with respect to gate current', ' ');
INSERT INTO answer VALUES (6293, 1574, 0, 'Complementary Metal-Oxide Semiconductor', ' ');
INSERT INTO answer VALUES (6294, 1574, 1, 'Common Mode Oscillating System', ' ');
INSERT INTO answer VALUES (6295, 1574, 2, 'Complementary Mica-Oxide Silicon', ' ');
INSERT INTO answer VALUES (6296, 1574, 3, 'Common Mode Organic Silicon', ' ');
INSERT INTO answer VALUES (6297, 1575, 0, 'P-type', ' ');
INSERT INTO answer VALUES (6298, 1575, 1, 'N-type', ' ');
INSERT INTO answer VALUES (6299, 1575, 2, 'Superconductor-type', ' ');
INSERT INTO answer VALUES (6300, 1575, 3, 'Bipolar-type', ' ');
INSERT INTO answer VALUES (6301, 1576, 0, 'Free electrons', ' ');
INSERT INTO answer VALUES (6302, 1576, 1, 'Holes', ' ');
INSERT INTO answer VALUES (6303, 1576, 2, 'Free protons', ' ');
INSERT INTO answer VALUES (6304, 1576, 3, 'Free neutrons', ' ');
INSERT INTO answer VALUES (6305, 1577, 0, 'Gate, drain, source', ' ');
INSERT INTO answer VALUES (6306, 1577, 1, 'Gate 1, gate 2, drain', ' ');
INSERT INTO answer VALUES (6307, 1577, 2, 'Emitter, base, collector', ' ');
INSERT INTO answer VALUES (6308, 1577, 3, 'Emitter, base 1, base 2', ' ');
INSERT INTO answer VALUES (6309, 1578, 0, 'Tunnel', ' ');
INSERT INTO answer VALUES (6310, 1578, 1, 'Point contact', ' ');
INSERT INTO answer VALUES (6311, 1578, 2, 'Zener', ' ');
INSERT INTO answer VALUES (6312, 1578, 3, 'Junction', ' ');
INSERT INTO answer VALUES (6313, 1579, 0, 'As an RF switch', ' ');
INSERT INTO answer VALUES (6314, 1579, 1, 'As a constant current source', ' ');
INSERT INTO answer VALUES (6315, 1579, 2, 'As a constant voltage source', ' ');
INSERT INTO answer VALUES (6316, 1579, 3, 'As a high voltage rectifier', ' ');
INSERT INTO answer VALUES (6317, 1580, 0, 'An integrated circuit logic family using both bipolar and CMOS transistors', ' ');
INSERT INTO answer VALUES (6318, 1580, 1, 'A logic device with two CMOS circuits per package', ' ');
INSERT INTO answer VALUES (6319, 1580, 2, 'A FET logic family based on bimetallic semiconductors', ' ');
INSERT INTO answer VALUES (6320, 1580, 3, 'A logic family based on bismuth CMOS devices', ' ');
INSERT INTO answer VALUES (6321, 1581, 0, 'It has the high input impedance of CMOS and the low output impedance of bipolar transistors', ' ');
INSERT INTO answer VALUES (6322, 1581, 1, 'Its simplicity results in much less expensive devices than standard CMOS', ' ');
INSERT INTO answer VALUES (6323, 1581, 2, 'It is totally immune to electrostatic damage', ' ');
INSERT INTO answer VALUES (6324, 1581, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6325, 1582, 0, 'Complex logic functions can be created in a single integrated circuit', ' ');
INSERT INTO answer VALUES (6326, 1582, 1, 'Many similar gates are less expensive than a mixture of gate types', ' ');
INSERT INTO answer VALUES (6327, 1582, 2, 'A PGA contains its own internal power supply', ' ');
INSERT INTO answer VALUES (6328, 1582, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6329, 1583, 0, '35 turns', ' ');
INSERT INTO answer VALUES (6330, 1583, 1, '13 turns', ' ');
INSERT INTO answer VALUES (6331, 1583, 2, '79 turns', ' ');
INSERT INTO answer VALUES (6332, 1583, 3, '141 turns', ' ');
INSERT INTO answer VALUES (6333, 1584, 0, 'From less than 20 Hz to approximately 300 MHz', ' ');
INSERT INTO answer VALUES (6334, 1584, 1, 'From a few kHz to no more than 30 MHz', ' ');
INSERT INTO answer VALUES (6335, 1584, 2, 'From approximately 10 Hz to no more than 3000 kHz', ' ');
INSERT INTO answer VALUES (6336, 1584, 3, 'From about 100 kHz to at least 1000 GHz', ' ');
INSERT INTO answer VALUES (6337, 1585, 0, '43 turns', ' ');
INSERT INTO answer VALUES (6338, 1585, 1, '2 turns', ' ');
INSERT INTO answer VALUES (6339, 1585, 2, '4 turns', ' ');
INSERT INTO answer VALUES (6340, 1585, 3, '229 turns', ' ');
INSERT INTO answer VALUES (6341, 1586, 0, 'The ability of the inductor’s core to store magnetic energy has been exceeded', ' ');
INSERT INTO answer VALUES (6342, 1586, 1, 'The inductor windings are over coupled', ' ');
INSERT INTO answer VALUES (6343, 1586, 2, 'The inductor’s voltage rating is exceeded causing a flashover', ' ');
INSERT INTO answer VALUES (6344, 1586, 3, 'Adjacent inductors become over-coupled', ' ');
INSERT INTO answer VALUES (6345, 1587, 0, 'Brass', ' ');
INSERT INTO answer VALUES (6346, 1587, 1, 'Ceramic', ' ');
INSERT INTO answer VALUES (6347, 1587, 2, 'Ferrite', ' ');
INSERT INTO answer VALUES (6348, 1587, 3, 'Powdered-iron', ' ');
INSERT INTO answer VALUES (6349, 1588, 0, 'Snubber capacitor', ' ');
INSERT INTO answer VALUES (6350, 1588, 1, 'Clipper capacitor', ' ');
INSERT INTO answer VALUES (6351, 1588, 2, 'Trimmer capacitor', ' ');
INSERT INTO answer VALUES (6352, 1588, 3, 'Feedback capacitor', ' ');
INSERT INTO answer VALUES (6353, 1589, 0, 'It samples an analog signal and passes it in stages from the input to the output', ' ');
INSERT INTO answer VALUES (6354, 1589, 1, 'Its phase shift changes rapidly with frequency', ' ');
INSERT INTO answer VALUES (6355, 1589, 2, 'It is a CMOS analog-to-digital converter', ' ');
INSERT INTO answer VALUES (6356, 1589, 3, 'It is used in a battery charger circuit', ' ');
INSERT INTO answer VALUES (6357, 1590, 0, 'Microstrip construction', ' ');
INSERT INTO answer VALUES (6358, 1590, 1, 'Ground-plane construction', ' ');
INSERT INTO answer VALUES (6359, 1590, 2, 'Point-to-point construction', ' ');
INSERT INTO answer VALUES (6360, 1590, 3, 'Wave-soldering construction', ' ');
INSERT INTO answer VALUES (6361, 1591, 0, 'Surface mount', ' ');
INSERT INTO answer VALUES (6362, 1591, 1, 'Direct soldering', ' ');
INSERT INTO answer VALUES (6363, 1591, 2, 'Virtual lead mounting', ' ');
INSERT INTO answer VALUES (6364, 1591, 3, 'Stripped lead', ' ');
INSERT INTO answer VALUES (6365, 1592, 0, 'Better dissipation of heat', ' ');
INSERT INTO answer VALUES (6366, 1592, 1, 'High-voltage insulating ability', ' ');
INSERT INTO answer VALUES (6367, 1592, 2, 'Enhanced sensitivity to light', ' ');
INSERT INTO answer VALUES (6368, 1592, 3, 'To provide a low-pass frequency response', ' ');
INSERT INTO answer VALUES (6369, 1593, 0, 'The increased conductivity of an illuminated semiconductor', ' ');
INSERT INTO answer VALUES (6370, 1593, 1, 'The conversion of photon energy to electromotive energy', ' ');
INSERT INTO answer VALUES (6371, 1593, 2, 'The conversion of electromotive energy to photon energy', ' ');
INSERT INTO answer VALUES (6372, 1593, 3, 'The decreased conductivity of an illuminated semiconductor', ' ');
INSERT INTO answer VALUES (6373, 1594, 0, 'A display utilizing a crystalline liquid and polarizing filters which becomes opaque when voltage is applied', ' ');
INSERT INTO answer VALUES (6374, 1594, 1, 'A modern replacement for a quartz crystal oscillator which displays its fundamental frequency', ' ');
INSERT INTO answer VALUES (6375, 1594, 2, 'A frequency-determining unit for a transmitter or receiver', ' ');
INSERT INTO answer VALUES (6376, 1594, 3, 'A display that uses a glowing liquid to remain brightly lit in dim light', ' ');
INSERT INTO answer VALUES (6377, 1595, 0, 'They may be hard to view through polarized lenses', ' ');
INSERT INTO answer VALUES (6378, 1595, 1, 'They are hard to view in high ambient light conditions', ' ');
INSERT INTO answer VALUES (6379, 1595, 2, 'They only display alphanumeric symbols', ' ');
INSERT INTO answer VALUES (6380, 1595, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6381, 1596, 0, 'Negative logic', ' ');
INSERT INTO answer VALUES (6382, 1596, 1, 'Reverse Logic', ' ');
INSERT INTO answer VALUES (6383, 1596, 2, 'Assertive Logic', ' ');
INSERT INTO answer VALUES (6384, 1596, 3, 'Positive Logic', ' ');
INSERT INTO answer VALUES (6385, 1597, 0, 'Emitter load', ' ');
INSERT INTO answer VALUES (6386, 1597, 1, 'Fixed bias', ' ');
INSERT INTO answer VALUES (6387, 1597, 2, 'Collector load', ' ');
INSERT INTO answer VALUES (6388, 1597, 3, 'Voltage regulation', ' ');
INSERT INTO answer VALUES (6389, 1598, 0, 'A notch filter', ' ');
INSERT INTO answer VALUES (6390, 1598, 1, 'A band-pass filter', ' ');
INSERT INTO answer VALUES (6391, 1598, 2, 'A Pi-network filter', ' ');
INSERT INTO answer VALUES (6392, 1598, 3, 'An all-pass filter', ' ');
INSERT INTO answer VALUES (6393, 1599, 0, 'A variable bandwidth crystal lattice filter', ' ');
INSERT INTO answer VALUES (6394, 1599, 1, 'An automatic notch filter', ' ');
INSERT INTO answer VALUES (6395, 1599, 2, 'A special filter that emphasizes image responses', ' ');
INSERT INTO answer VALUES (6396, 1599, 3, 'A filter that removes impulse noise', ' ');
INSERT INTO answer VALUES (6397, 1600, 0, 'Pi', ' ');
INSERT INTO answer VALUES (6398, 1600, 1, 'Pi-L', ' ');
INSERT INTO answer VALUES (6399, 1600, 2, 'Cascode', ' ');
INSERT INTO answer VALUES (6400, 1600, 3, 'Omega', ' ');
INSERT INTO answer VALUES (6401, 1601, 0, 'Digital', ' ');
INSERT INTO answer VALUES (6402, 1601, 1, 'Meteor scatter', ' ');
INSERT INTO answer VALUES (6403, 1601, 2, 'Single-Sideband voice', ' ');
INSERT INTO answer VALUES (6404, 1601, 3, 'Video', ' ');
INSERT INTO answer VALUES (6405, 1602, 0, 'Pass transistor', ' ');
INSERT INTO answer VALUES (6406, 1602, 1, 'Reference voltage', ' ');
INSERT INTO answer VALUES (6407, 1602, 2, 'Switching inductance', ' ');
INSERT INTO answer VALUES (6408, 1602, 3, 'Error amplifier', ' ');
INSERT INTO answer VALUES (6409, 1603, 0, 'To improve output voltage regulation', ' ');
INSERT INTO answer VALUES (6410, 1603, 1, 'To cut down on waste heat generated by the power supply', ' ');
INSERT INTO answer VALUES (6411, 1603, 2, 'To balance the low-voltage filament windings', ' ');
INSERT INTO answer VALUES (6412, 1603, 3, 'To boost the amount of output current', ' ');
INSERT INTO answer VALUES (6413, 1604, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6414, 1604, 1, 'To equalize, as much as possible, the voltage drop across each capacitor', ' ');
INSERT INTO answer VALUES (6415, 1604, 2, 'To provide a safety bleeder to discharge the capacitors when the supply is off', ' ');
INSERT INTO answer VALUES (6416, 1604, 3, 'To provide a minimum load current to reduce voltage excursions at light loads', ' ');
INSERT INTO answer VALUES (6417, 1605, 0, 'By varying the tuning of an amplifier tank circuit to produce PM signals', ' ');
INSERT INTO answer VALUES (6418, 1605, 1, 'By varying the tuning of a microphone preamplifier to produce PM signals', ' ');
INSERT INTO answer VALUES (6419, 1605, 2, 'By varying the tuning of an amplifier tank circuit to produce AM signals', ' ');
INSERT INTO answer VALUES (6420, 1605, 3, 'By varying the tuning of a microphone preamplifier to produce AM signals', ' ');
INSERT INTO answer VALUES (6421, 1606, 0, 'Fast Fourier Transform', ' ');
INSERT INTO answer VALUES (6422, 1606, 1, 'Decimation', ' ');
INSERT INTO answer VALUES (6423, 1606, 2, 'Signal conditioning', ' ');
INSERT INTO answer VALUES (6424, 1606, 3, 'Quadrature mixing', ' ');
INSERT INTO answer VALUES (6425, 1607, 0, 'Interpolate by a factor of three, then decimate by a factor of four', ' ');
INSERT INTO answer VALUES (6426, 1607, 1, 'Change the gain by a factor of 3/4', ' ');
INSERT INTO answer VALUES (6427, 1607, 2, 'Multiply each sample value by a factor of 3/4', ' ');
INSERT INTO answer VALUES (6428, 1607, 3, 'Add 3 to each input value and subtract 4 from each output value', ' ');
INSERT INTO answer VALUES (6429, 1608, 0, 'In-phase and Quadrature', ' ');
INSERT INTO answer VALUES (6430, 1608, 1, 'Inactive and Quiescent', ' ');
INSERT INTO answer VALUES (6431, 1608, 2, 'Instantaneous and Quasi-stable', ' ');
INSERT INTO answer VALUES (6432, 1608, 3, 'Instantaneous and Quenched', ' ');
INSERT INTO answer VALUES (6433, 1609, 0, 'As an audio filter in a receiver', ' ');
INSERT INTO answer VALUES (6434, 1609, 1, 'As a high-pass filter used to block RFI at the input to receivers', ' ');
INSERT INTO answer VALUES (6435, 1609, 2, 'As a low-pass filter used between a transmitter and a transmission line', ' ');
INSERT INTO answer VALUES (6436, 1609, 3, 'For smoothing power supply output', ' ');
INSERT INTO answer VALUES (6437, 1610, 0, 'A sawtooth wave', ' ');
INSERT INTO answer VALUES (6438, 1610, 1, 'A cosine wave', ' ');
INSERT INTO answer VALUES (6439, 1610, 2, 'A square wave', ' ');
INSERT INTO answer VALUES (6440, 1610, 3, 'A sine wave', ' ');
INSERT INTO answer VALUES (6441, 1611, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6442, 1611, 1, 'Human speech', ' ');
INSERT INTO answer VALUES (6443, 1611, 2, 'Video signals', ' ');
INSERT INTO answer VALUES (6444, 1611, 3, 'Data', ' ');
INSERT INTO answer VALUES (6445, 1612, 0, 'Digital signals can be regenerated multiple times without error', ' ');
INSERT INTO answer VALUES (6446, 1612, 1, 'Less complex circuitry is required for digital signal generation and detection', ' ');
INSERT INTO answer VALUES (6447, 1612, 2, 'Digital signals always occupy a narrower bandwidth', ' ');
INSERT INTO answer VALUES (6448, 1612, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6449, 1613, 0, 'Modulation index', ' ');
INSERT INTO answer VALUES (6450, 1613, 1, 'FM compressibility', ' ');
INSERT INTO answer VALUES (6451, 1613, 2, 'Quieting index', ' ');
INSERT INTO answer VALUES (6452, 1613, 3, 'Percentage of modulation', ' ');
INSERT INTO answer VALUES (6453, 1614, 0, 'It facilitates error detection', ' ');
INSERT INTO answer VALUES (6454, 1614, 1, 'It increases security', ' ');
INSERT INTO answer VALUES (6455, 1614, 2, 'It has more possible states than simple binary', ' ');
INSERT INTO answer VALUES (6456, 1614, 3, 'It has more resolution than simple binary', ' ');
INSERT INTO answer VALUES (6457, 1615, 0, 'Strong ALC action', ' ');
INSERT INTO answer VALUES (6458, 1615, 1, 'High reflected power', ' ');
INSERT INTO answer VALUES (6459, 1615, 2, 'Harmonics on higher bands', ' ');
INSERT INTO answer VALUES (6460, 1615, 3, 'Rapid signal fading', ' ');
INSERT INTO answer VALUES (6461, 1616, 0, 'Isotropic antenna', ' ');
INSERT INTO answer VALUES (6462, 1616, 1, 'Quarter-wave vertical', ' ');
INSERT INTO answer VALUES (6463, 1616, 2, 'Yagi', ' ');
INSERT INTO answer VALUES (6464, 1616, 3, 'Half-wave dipole', ' ');
INSERT INTO answer VALUES (6465, 1617, 0, 'To match impedances in order to minimize standing wave ratio on the transmission line', ' ');
INSERT INTO answer VALUES (6466, 1617, 1, 'To measure the near-field radiation density from a transmitting antenna', ' ');
INSERT INTO answer VALUES (6467, 1617, 2, 'To calculate the front-to-side ratio of the antenna', ' ');
INSERT INTO answer VALUES (6468, 1617, 3, 'To calculate the front-to-back ratio of the antenna', ' ');
INSERT INTO answer VALUES (6469, 1618, 0, 'It decreases', ' ');
INSERT INTO answer VALUES (6470, 1618, 1, 'It increases geometrically', ' ');
INSERT INTO answer VALUES (6471, 1618, 2, 'It increases arithmetically', ' ');
INSERT INTO answer VALUES (6472, 1618, 3, 'It is essentially unaffected', ' ');
INSERT INTO answer VALUES (6473, 1619, 0, 'The ratio of the radiated signal strength of an antenna in the direction of maximum radiation to that of a reference antenna', ' ');
INSERT INTO answer VALUES (6474, 1619, 1, 'The ratio of the signal in the forward direction to that in the opposite direction', ' ');
INSERT INTO answer VALUES (6475, 1619, 2, 'The ratio of the amount of power radiated by an antenna compared to the transmitter output power', ' ');
INSERT INTO answer VALUES (6476, 1619, 3, 'The final amplifier gain minus the transmission line losses', ' ');
INSERT INTO answer VALUES (6477, 1620, 0, '9.85 dB', ' ');
INSERT INTO answer VALUES (6478, 1620, 1, '6.17 dB', ' ');
INSERT INTO answer VALUES (6479, 1620, 2, '12.5 dB', ' ');
INSERT INTO answer VALUES (6480, 1620, 3, '14.15 dB', ' ');
INSERT INTO answer VALUES (6481, 1621, 0, '252 watts', ' ');
INSERT INTO answer VALUES (6482, 1621, 1, '159 watts', ' ');
INSERT INTO answer VALUES (6483, 1621, 2, '632 watts', ' ');
INSERT INTO answer VALUES (6484, 1621, 3, '63.2 watts', ' ');
INSERT INTO answer VALUES (6485, 1622, 0, 'The gain may change depending on frequency', ' ');
INSERT INTO answer VALUES (6486, 1622, 1, 'Feed point impedance may become negative', ' ');
INSERT INTO answer VALUES (6487, 1622, 2, 'The E-field and H-field patterns may reverse', ' ');
INSERT INTO answer VALUES (6488, 1622, 3, 'Element spacing limits could be exceeded', ' ');
INSERT INTO answer VALUES (6489, 1623, 0, 'Note the two points where the signal strength of the antenna is 3 dB less than maximum and compute the angular difference', ' ');
INSERT INTO answer VALUES (6490, 1623, 1, 'Measure the ratio of the signal strengths of the radiated power lobes from the front and rear of the antenna', ' ');
INSERT INTO answer VALUES (6491, 1623, 2, 'Draw two imaginary lines through the ends of the elements and measure the angle between the lines', ' ');
INSERT INTO answer VALUES (6492, 1623, 3, 'Measure the ratio of the signal strengths of the radiated power lobes from the front and side of the antenna', ' ');
INSERT INTO answer VALUES (6493, 1624, 0, 'Numerical Electromagnetic Code', ' ');
INSERT INTO answer VALUES (6494, 1624, 1, 'Next Element Comparison', ' ');
INSERT INTO answer VALUES (6495, 1624, 2, 'National Electrical Code', ' ');
INSERT INTO answer VALUES (6496, 1624, 3, 'Numeric Electrical Computation', ' ');
INSERT INTO answer VALUES (6497, 1625, 0, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6498, 1625, 1, 'SWR vs frequency charts', ' ');
INSERT INTO answer VALUES (6499, 1625, 2, 'Polar plots of the far field elevation and azimuth patterns', ' ');
INSERT INTO answer VALUES (6500, 1625, 3, 'Antenna gain', ' ');
INSERT INTO answer VALUES (6501, 1626, 0, '4', ' ');
INSERT INTO answer VALUES (6502, 1626, 1, '3', ' ');
INSERT INTO answer VALUES (6503, 1626, 2, '1', ' ');
INSERT INTO answer VALUES (6504, 1626, 3, '7', ' ');
INSERT INTO answer VALUES (6505, 1627, 0, 'A dipole fed approximately 1/3 the way from one end with a 4:1 balun to provide multiband operation', ' ');
INSERT INTO answer VALUES (6506, 1627, 1, 'A remotely tunable dipole antenna using orthogonally controlled frequency diversity', ' ');
INSERT INTO answer VALUES (6507, 1627, 2, 'An eight band dipole antenna using octophase filters', ' ');
INSERT INTO answer VALUES (6508, 1627, 3, 'A multiband dipole antenna using one-way circular polarization for frequency diversity', ' ');
INSERT INTO answer VALUES (6509, 1628, 0, 'It reduces low-angle radiation', ' ');
INSERT INTO answer VALUES (6510, 1628, 1, 'It causes increased SWR', ' ');
INSERT INTO answer VALUES (6511, 1628, 2, 'It changes the impedance angle of the matching network', ' ');
INSERT INTO answer VALUES (6512, 1628, 3, 'It reduces losses in the radiating portion of the antenna', ' ');
INSERT INTO answer VALUES (6513, 1629, 0, 'It might radiate harmonics', ' ');
INSERT INTO answer VALUES (6514, 1629, 1, 'It radiates the harmonics and fundamental equally well', ' ');
INSERT INTO answer VALUES (6515, 1629, 2, 'It is too sharply directional at lower frequencies', ' ');
INSERT INTO answer VALUES (6516, 1629, 3, 'It must be neutralized', ' ');
INSERT INTO answer VALUES (6517, 1630, 0, 'A shunt inductor', ' ');
INSERT INTO answer VALUES (6518, 1630, 1, 'Pi-network', ' ');
INSERT INTO answer VALUES (6519, 1630, 2, 'Pi-L-network', ' ');
INSERT INTO answer VALUES (6520, 1630, 3, 'A series capacitor', ' ');
INSERT INTO answer VALUES (6521, 1631, 0, 'An SWR greater than 1:1', ' ');
INSERT INTO answer VALUES (6522, 1631, 1, 'An SWR less than 1:1', ' ');
INSERT INTO answer VALUES (6523, 1631, 2, 'A reflection coefficient greater than 1', ' ');
INSERT INTO answer VALUES (6524, 1631, 3, 'A dielectric constant greater than 1', ' ');
INSERT INTO answer VALUES (6525, 1632, 0, 'Gamma match', ' ');
INSERT INTO answer VALUES (6526, 1632, 1, 'Double-bazooka match', ' ');
INSERT INTO answer VALUES (6527, 1632, 2, 'Hairpin match', ' ');
INSERT INTO answer VALUES (6528, 1632, 3, 'All of these choices are correct', ' ');
INSERT INTO answer VALUES (6529, 1633, 0, 'Use the universal stub matching technique', ' ');
INSERT INTO answer VALUES (6530, 1633, 1, 'Use a 50 ohm 1:1 balun between the antenna and feed line', ' ');
INSERT INTO answer VALUES (6531, 1633, 2, 'Connect a series-resonant LC network across the antenna feed terminals', ' ');
INSERT INTO answer VALUES (6532, 1633, 3, 'Connect a parallel-resonant LC network across the antenna feed terminals', ' ');
INSERT INTO answer VALUES (6533, 1634, 0, '0.66', ' ');
INSERT INTO answer VALUES (6534, 1634, 1, '2.70', ' ');
INSERT INTO answer VALUES (6535, 1634, 2, '0.30', ' ');
INSERT INTO answer VALUES (6536, 1634, 3, '0.10', ' ');
INSERT INTO answer VALUES (6537, 1635, 0, 'Velocity factor', ' ');
INSERT INTO answer VALUES (6538, 1635, 1, 'Characteristic impedance', ' ');
INSERT INTO answer VALUES (6539, 1635, 2, 'Surge impedance', ' ');
INSERT INTO answer VALUES (6540, 1635, 3, 'Standing wave ratio', ' ');
INSERT INTO answer VALUES (6541, 1636, 0, '6.9 meters', ' ');
INSERT INTO answer VALUES (6542, 1636, 1, '10 meters', ' ');
INSERT INTO answer VALUES (6543, 1636, 2, '24 meters', ' ');
INSERT INTO answer VALUES (6544, 1636, 3, '50 meters', ' ');
INSERT INTO answer VALUES (6545, 1637, 0, 'Very high impedance', ' ');
INSERT INTO answer VALUES (6546, 1637, 1, 'Very low impedance', ' ');
INSERT INTO answer VALUES (6547, 1637, 2, 'The same as the characteristic impedance of the line', ' ');
INSERT INTO answer VALUES (6548, 1637, 3, 'The same as the output impedance of the generator', ' ');
INSERT INTO answer VALUES (6549, 1638, 0, 'Smith chart', ' ');
INSERT INTO answer VALUES (6550, 1638, 1, 'Free space radiation directivity chart', ' ');
INSERT INTO answer VALUES (6551, 1638, 2, 'Elevation angle radiation pattern chart', ' ');
INSERT INTO answer VALUES (6552, 1638, 3, 'Azimuth angle radiation pattern chart', ' ');
INSERT INTO answer VALUES (6553, 1639, 0, 'It is electro statically balanced against ground, giving better nulls', ' ');
INSERT INTO answer VALUES (6554, 1639, 1, 'It automatically cancels ignition noise in mobile installations', ' ');
INSERT INTO answer VALUES (6555, 1639, 2, 'It eliminates tracking errors caused by strong out-of-band signals', ' ');
INSERT INTO answer VALUES (6556, 1639, 3, 'It allows stations to communicate without giving away their position', ' ');
INSERT INTO answer VALUES (6557, 1640, 0, 'One or more turns of wire wound in the shape of a large open coil', ' ');
INSERT INTO answer VALUES (6558, 1640, 1, 'A large circularly polarized antenna', ' ');
INSERT INTO answer VALUES (6559, 1640, 2, 'A small coil of wire tightly wound around a toroidal ferrite core', ' ');
INSERT INTO answer VALUES (6560, 1640, 3, 'A vertical antenna coupled to a feed line through an inductive loop of wire', ' ');
INSERT INTO answer VALUES (6561, 1641, 0, 'Use an antenna modeling program to calculate field strength at accessible locations', ' ');
INSERT INTO answer VALUES (6562, 1641, 1, 'Use a calibrated antenna analyzer', ' ');
INSERT INTO answer VALUES (6563, 1641, 2, 'Use a hand calculator plus Smith-chart equations to calculate the fields', ' ');
INSERT INTO answer VALUES (6564, 1641, 3, 'All of the choices are correct', ' ');


INSERT INTO category_to_topic VALUES (1, 1, 1);
INSERT INTO category_to_topic VALUES (2, 2, 2);
INSERT INTO category_to_topic VALUES (3, 3, 3);
INSERT INTO category_to_topic VALUES (4, 4, 1);
INSERT INTO category_to_topic VALUES (5, 5, 1);
INSERT INTO category_to_topic VALUES (6, 6, 1);
INSERT INTO category_to_topic VALUES (7, 7, 1);
INSERT INTO category_to_topic VALUES (8, 8, 1);
INSERT INTO category_to_topic VALUES (9, 9, 1);
INSERT INTO category_to_topic VALUES (10, 10, 1);
INSERT INTO category_to_topic VALUES (11, 11, 1);
INSERT INTO category_to_topic VALUES (12, 12, 1);
INSERT INTO category_to_topic VALUES (13, 13, 1);
INSERT INTO category_to_topic VALUES (14, 14, 1);
INSERT INTO category_to_topic VALUES (15, 15, 1);
INSERT INTO category_to_topic VALUES (16, 16, 1);
INSERT INTO category_to_topic VALUES (17, 17, 1);
INSERT INTO category_to_topic VALUES (18, 18, 1);
INSERT INTO category_to_topic VALUES (19, 19, 1);
INSERT INTO category_to_topic VALUES (20, 20, 1);
INSERT INTO category_to_topic VALUES (21, 21, 1);
INSERT INTO category_to_topic VALUES (22, 22, 1);
INSERT INTO category_to_topic VALUES (23, 23, 1);
INSERT INTO category_to_topic VALUES (24, 24, 1);
INSERT INTO category_to_topic VALUES (25, 25, 1);
INSERT INTO category_to_topic VALUES (26, 26, 1);
INSERT INTO category_to_topic VALUES (27, 27, 1);
INSERT INTO category_to_topic VALUES (28, 28, 1);
INSERT INTO category_to_topic VALUES (29, 29, 1);
INSERT INTO category_to_topic VALUES (30, 30, 1);
INSERT INTO category_to_topic VALUES (31, 31, 1);
INSERT INTO category_to_topic VALUES (32, 32, 1);
INSERT INTO category_to_topic VALUES (33, 33, 1);
INSERT INTO category_to_topic VALUES (34, 34, 1);
INSERT INTO category_to_topic VALUES (35, 35, 1);
INSERT INTO category_to_topic VALUES (36, 36, 1);
INSERT INTO category_to_topic VALUES (37, 37, 1);
INSERT INTO category_to_topic VALUES (38, 38, 1);
INSERT INTO category_to_topic VALUES (39, 39, 1);
INSERT INTO category_to_topic VALUES (40, 40, 1);
INSERT INTO category_to_topic VALUES (41, 41, 1);
INSERT INTO category_to_topic VALUES (42, 42, 1);
INSERT INTO category_to_topic VALUES (43, 43, 1);
INSERT INTO category_to_topic VALUES (44, 44, 1);
INSERT INTO category_to_topic VALUES (45, 45, 1);
INSERT INTO category_to_topic VALUES (46, 46, 1);
INSERT INTO category_to_topic VALUES (47, 47, 1);
INSERT INTO category_to_topic VALUES (48, 48, 1);

INSERT INTO category_to_topic VALUES (49, 49, 2);
INSERT INTO category_to_topic VALUES (50, 50, 2);
INSERT INTO category_to_topic VALUES (51, 51, 2);
INSERT INTO category_to_topic VALUES (52, 52, 2);
INSERT INTO category_to_topic VALUES (53, 53, 2);
INSERT INTO category_to_topic VALUES (54, 54, 2);
INSERT INTO category_to_topic VALUES (55, 55, 2);
INSERT INTO category_to_topic VALUES (56, 56, 2);
INSERT INTO category_to_topic VALUES (57, 57, 2);
INSERT INTO category_to_topic VALUES (58, 58, 2);
INSERT INTO category_to_topic VALUES (59, 59, 2);
INSERT INTO category_to_topic VALUES (60, 60, 2);
INSERT INTO category_to_topic VALUES (61, 61, 2);
INSERT INTO category_to_topic VALUES (62, 62, 2);
INSERT INTO category_to_topic VALUES (63, 63, 2);
INSERT INTO category_to_topic VALUES (64, 64, 2);
INSERT INTO category_to_topic VALUES (65, 65, 2);
INSERT INTO category_to_topic VALUES (66, 66, 2);
INSERT INTO category_to_topic VALUES (67, 67, 2);
INSERT INTO category_to_topic VALUES (68, 68, 2);
INSERT INTO category_to_topic VALUES (69, 69, 2);
INSERT INTO category_to_topic VALUES (70, 70, 2);
INSERT INTO category_to_topic VALUES (71, 71, 2);
INSERT INTO category_to_topic VALUES (72, 72, 2);
INSERT INTO category_to_topic VALUES (73, 73, 2);
INSERT INTO category_to_topic VALUES (74, 74, 2);
INSERT INTO category_to_topic VALUES (75, 75, 2);
INSERT INTO category_to_topic VALUES (76, 76, 2);
INSERT INTO category_to_topic VALUES (77, 77, 2);
INSERT INTO category_to_topic VALUES (78, 78, 2);
INSERT INTO category_to_topic VALUES (79, 79, 2);
INSERT INTO category_to_topic VALUES (80, 80, 2);
INSERT INTO category_to_topic VALUES (81, 81, 2);
INSERT INTO category_to_topic VALUES (82, 82, 2);
INSERT INTO category_to_topic VALUES (83, 83, 2);
INSERT INTO category_to_topic VALUES (84, 84, 2);
INSERT INTO category_to_topic VALUES (85, 85, 2);
INSERT INTO category_to_topic VALUES (86, 86, 2);
INSERT INTO category_to_topic VALUES (87, 87, 2);
INSERT INTO category_to_topic VALUES (88, 88, 2);
INSERT INTO category_to_topic VALUES (89, 89, 2);
INSERT INTO category_to_topic VALUES (90, 90, 2);
INSERT INTO category_to_topic VALUES (91, 91, 2);
INSERT INTO category_to_topic VALUES (92, 92, 2);
INSERT INTO category_to_topic VALUES (93, 93, 2);

INSERT INTO category_to_topic VALUES (94, 94, 3);
INSERT INTO category_to_topic VALUES (95, 95, 3);
INSERT INTO category_to_topic VALUES (96, 96, 3);
INSERT INTO category_to_topic VALUES (97, 97, 3);
INSERT INTO category_to_topic VALUES (98, 98, 3);
INSERT INTO category_to_topic VALUES (99, 99, 3);
INSERT INTO category_to_topic VALUES (100, 100, 3);
INSERT INTO category_to_topic VALUES (101, 101, 3);
INSERT INTO category_to_topic VALUES (102, 102, 3);
INSERT INTO category_to_topic VALUES (103, 103, 3);
INSERT INTO category_to_topic VALUES (104, 104, 3);
INSERT INTO category_to_topic VALUES (105, 105, 3);
INSERT INTO category_to_topic VALUES (106, 106, 3);
INSERT INTO category_to_topic VALUES (107, 107, 3);
INSERT INTO category_to_topic VALUES (108, 108, 3);
INSERT INTO category_to_topic VALUES (109, 109, 3);
INSERT INTO category_to_topic VALUES (110, 110, 3);
INSERT INTO category_to_topic VALUES (111, 111, 3);
INSERT INTO category_to_topic VALUES (112, 112, 3);
INSERT INTO category_to_topic VALUES (113, 113, 3);
INSERT INTO category_to_topic VALUES (114, 114, 3);
INSERT INTO category_to_topic VALUES (115, 115, 3);
INSERT INTO category_to_topic VALUES (116, 116, 3);
INSERT INTO category_to_topic VALUES (117, 117, 3);
INSERT INTO category_to_topic VALUES (118, 118, 3);
INSERT INTO category_to_topic VALUES (119, 119, 3);
INSERT INTO category_to_topic VALUES (120, 120, 3);
INSERT INTO category_to_topic VALUES (121, 121, 3);
INSERT INTO category_to_topic VALUES (122, 122, 3);
INSERT INTO category_to_topic VALUES (123, 123, 3);
INSERT INTO category_to_topic VALUES (124, 124, 3);
INSERT INTO category_to_topic VALUES (125, 125, 3);
INSERT INTO category_to_topic VALUES (126, 126, 3);
INSERT INTO category_to_topic VALUES (127, 127, 3);
INSERT INTO category_to_topic VALUES (128, 128, 3);
INSERT INTO category_to_topic VALUES (129, 129, 3);
INSERT INTO category_to_topic VALUES (130, 130, 3);
INSERT INTO category_to_topic VALUES (131, 131, 3);
INSERT INTO category_to_topic VALUES (132, 132, 3);
INSERT INTO category_to_topic VALUES (133, 133, 3);
INSERT INTO category_to_topic VALUES (134, 134, 3);
INSERT INTO category_to_topic VALUES (135, 135, 3);
INSERT INTO category_to_topic VALUES (136, 136, 3);
INSERT INTO category_to_topic VALUES (137, 137, 3);
INSERT INTO category_to_topic VALUES (138, 138, 3);
INSERT INTO category_to_topic VALUES (139, 139, 3);
INSERT INTO category_to_topic VALUES (140, 140, 3);
INSERT INTO category_to_topic VALUES (141, 141, 3);
INSERT INTO category_to_topic VALUES (142, 142, 3);
INSERT INTO category_to_topic VALUES (143, 143, 3);
INSERT INTO category_to_topic VALUES (144, 144, 3);
INSERT INTO category_to_topic VALUES (145, 145, 3);
INSERT INTO category_to_topic VALUES (146, 146, 3);
INSERT INTO category_to_topic VALUES (147, 147, 3);
INSERT INTO category_to_topic VALUES (148, 148, 3);
INSERT INTO category_to_topic VALUES (149, 149, 3);
INSERT INTO category_to_topic VALUES (150, 150, 3);
INSERT INTO category_to_topic VALUES (151, 151, 3);
INSERT INTO category_to_topic VALUES (152, 152, 3);
INSERT INTO category_to_topic VALUES (153, 153, 3);


INSERT INTO question_to_topic VALUES (1, 1, 1);
INSERT INTO question_to_topic VALUES (2, 2, 1);
INSERT INTO question_to_topic VALUES (3, 3, 1);
INSERT INTO question_to_topic VALUES (4, 4, 1);
INSERT INTO question_to_topic VALUES (5, 5, 1);
INSERT INTO question_to_topic VALUES (6, 6, 1);
INSERT INTO question_to_topic VALUES (7, 7, 1);
INSERT INTO question_to_topic VALUES (8, 8, 1);
INSERT INTO question_to_topic VALUES (9, 9, 1);
INSERT INTO question_to_topic VALUES (10, 10, 1);
INSERT INTO question_to_topic VALUES (11, 11, 1);
INSERT INTO question_to_topic VALUES (12, 12, 1);
INSERT INTO question_to_topic VALUES (13, 13, 1);
INSERT INTO question_to_topic VALUES (14, 14, 1);
INSERT INTO question_to_topic VALUES (15, 15, 1);
INSERT INTO question_to_topic VALUES (16, 16, 1);
INSERT INTO question_to_topic VALUES (17, 17, 1);
INSERT INTO question_to_topic VALUES (18, 18, 1);
INSERT INTO question_to_topic VALUES (19, 19, 1);
INSERT INTO question_to_topic VALUES (20, 20, 1);
INSERT INTO question_to_topic VALUES (21, 21, 1);
INSERT INTO question_to_topic VALUES (22, 22, 1);
INSERT INTO question_to_topic VALUES (23, 23, 1);
INSERT INTO question_to_topic VALUES (24, 24, 1);
INSERT INTO question_to_topic VALUES (25, 25, 1);
INSERT INTO question_to_topic VALUES (26, 26, 1);
INSERT INTO question_to_topic VALUES (27, 27, 1);
INSERT INTO question_to_topic VALUES (28, 28, 1);
INSERT INTO question_to_topic VALUES (29, 29, 1);
INSERT INTO question_to_topic VALUES (30, 30, 1);
INSERT INTO question_to_topic VALUES (31, 31, 1);
INSERT INTO question_to_topic VALUES (32, 32, 1);
INSERT INTO question_to_topic VALUES (33, 33, 1);
INSERT INTO question_to_topic VALUES (34, 34, 1);
INSERT INTO question_to_topic VALUES (35, 35, 1);
INSERT INTO question_to_topic VALUES (36, 36, 1);
INSERT INTO question_to_topic VALUES (37, 37, 1);
INSERT INTO question_to_topic VALUES (38, 38, 1);
INSERT INTO question_to_topic VALUES (39, 39, 1);
INSERT INTO question_to_topic VALUES (40, 40, 1);
INSERT INTO question_to_topic VALUES (41, 41, 1);
INSERT INTO question_to_topic VALUES (42, 42, 1);
INSERT INTO question_to_topic VALUES (43, 43, 1);
INSERT INTO question_to_topic VALUES (44, 44, 1);
INSERT INTO question_to_topic VALUES (45, 45, 1);
INSERT INTO question_to_topic VALUES (46, 46, 1);
INSERT INTO question_to_topic VALUES (47, 47, 1);
INSERT INTO question_to_topic VALUES (48, 48, 1);
INSERT INTO question_to_topic VALUES (49, 49, 1);
INSERT INTO question_to_topic VALUES (50, 50, 1);
INSERT INTO question_to_topic VALUES (51, 51, 1);
INSERT INTO question_to_topic VALUES (52, 52, 1);
INSERT INTO question_to_topic VALUES (53, 53, 1);
INSERT INTO question_to_topic VALUES (54, 54, 1);
INSERT INTO question_to_topic VALUES (55, 55, 1);
INSERT INTO question_to_topic VALUES (56, 56, 1);
INSERT INTO question_to_topic VALUES (57, 57, 1);
INSERT INTO question_to_topic VALUES (58, 58, 1);
INSERT INTO question_to_topic VALUES (59, 59, 1);
INSERT INTO question_to_topic VALUES (60, 60, 1);
INSERT INTO question_to_topic VALUES (61, 61, 1);
INSERT INTO question_to_topic VALUES (62, 62, 1);
INSERT INTO question_to_topic VALUES (63, 63, 1);
INSERT INTO question_to_topic VALUES (64, 64, 1);
INSERT INTO question_to_topic VALUES (65, 65, 1);
INSERT INTO question_to_topic VALUES (66, 66, 1);
INSERT INTO question_to_topic VALUES (67, 67, 1);
INSERT INTO question_to_topic VALUES (68, 68, 1);
INSERT INTO question_to_topic VALUES (69, 69, 1);
INSERT INTO question_to_topic VALUES (70, 70, 1);
INSERT INTO question_to_topic VALUES (71, 71, 1);
INSERT INTO question_to_topic VALUES (72, 72, 1);
INSERT INTO question_to_topic VALUES (73, 73, 1);
INSERT INTO question_to_topic VALUES (74, 74, 1);
INSERT INTO question_to_topic VALUES (75, 75, 1);
INSERT INTO question_to_topic VALUES (76, 76, 1);
INSERT INTO question_to_topic VALUES (77, 77, 1);
INSERT INTO question_to_topic VALUES (78, 78, 1);
INSERT INTO question_to_topic VALUES (79, 79, 1);
INSERT INTO question_to_topic VALUES (80, 80, 1);
INSERT INTO question_to_topic VALUES (81, 81, 1);
INSERT INTO question_to_topic VALUES (82, 82, 1);
INSERT INTO question_to_topic VALUES (83, 83, 1);
INSERT INTO question_to_topic VALUES (84, 84, 1);
INSERT INTO question_to_topic VALUES (85, 85, 1);
INSERT INTO question_to_topic VALUES (86, 86, 1);
INSERT INTO question_to_topic VALUES (87, 87, 1);
INSERT INTO question_to_topic VALUES (88, 88, 1);
INSERT INTO question_to_topic VALUES (89, 89, 1);
INSERT INTO question_to_topic VALUES (90, 90, 1);
INSERT INTO question_to_topic VALUES (91, 91, 1);
INSERT INTO question_to_topic VALUES (92, 92, 1);
INSERT INTO question_to_topic VALUES (93, 93, 1);
INSERT INTO question_to_topic VALUES (94, 94, 1);
INSERT INTO question_to_topic VALUES (95, 95, 1);
INSERT INTO question_to_topic VALUES (96, 96, 1);
INSERT INTO question_to_topic VALUES (97, 97, 1);
INSERT INTO question_to_topic VALUES (98, 98, 1);
INSERT INTO question_to_topic VALUES (99, 99, 1);
INSERT INTO question_to_topic VALUES (100, 100, 1);
INSERT INTO question_to_topic VALUES (101, 101, 1);
INSERT INTO question_to_topic VALUES (102, 102, 1);
INSERT INTO question_to_topic VALUES (103, 103, 1);
INSERT INTO question_to_topic VALUES (104, 104, 1);
INSERT INTO question_to_topic VALUES (105, 105, 1);
INSERT INTO question_to_topic VALUES (106, 106, 1);
INSERT INTO question_to_topic VALUES (107, 107, 1);
INSERT INTO question_to_topic VALUES (108, 108, 1);
INSERT INTO question_to_topic VALUES (109, 109, 1);
INSERT INTO question_to_topic VALUES (110, 110, 1);
INSERT INTO question_to_topic VALUES (111, 111, 1);
INSERT INTO question_to_topic VALUES (112, 112, 1);
INSERT INTO question_to_topic VALUES (113, 113, 1);
INSERT INTO question_to_topic VALUES (114, 114, 1);
INSERT INTO question_to_topic VALUES (115, 115, 1);
INSERT INTO question_to_topic VALUES (116, 116, 1);
INSERT INTO question_to_topic VALUES (117, 117, 1);
INSERT INTO question_to_topic VALUES (118, 118, 1);
INSERT INTO question_to_topic VALUES (119, 119, 1);
INSERT INTO question_to_topic VALUES (120, 120, 1);
INSERT INTO question_to_topic VALUES (121, 121, 1);
INSERT INTO question_to_topic VALUES (122, 122, 1);
INSERT INTO question_to_topic VALUES (123, 123, 1);
INSERT INTO question_to_topic VALUES (124, 124, 1);
INSERT INTO question_to_topic VALUES (125, 125, 1);
INSERT INTO question_to_topic VALUES (126, 126, 1);
INSERT INTO question_to_topic VALUES (127, 127, 1);
INSERT INTO question_to_topic VALUES (128, 128, 1);
INSERT INTO question_to_topic VALUES (129, 129, 1);
INSERT INTO question_to_topic VALUES (130, 130, 1);
INSERT INTO question_to_topic VALUES (131, 131, 1);
INSERT INTO question_to_topic VALUES (132, 132, 1);
INSERT INTO question_to_topic VALUES (133, 133, 1);
INSERT INTO question_to_topic VALUES (134, 134, 1);
INSERT INTO question_to_topic VALUES (135, 135, 1);
INSERT INTO question_to_topic VALUES (136, 136, 1);
INSERT INTO question_to_topic VALUES (137, 137, 1);
INSERT INTO question_to_topic VALUES (138, 138, 1);
INSERT INTO question_to_topic VALUES (139, 139, 1);
INSERT INTO question_to_topic VALUES (140, 140, 1);
INSERT INTO question_to_topic VALUES (141, 141, 1);
INSERT INTO question_to_topic VALUES (142, 142, 1);
INSERT INTO question_to_topic VALUES (143, 143, 1);
INSERT INTO question_to_topic VALUES (144, 144, 1);
INSERT INTO question_to_topic VALUES (145, 145, 1);
INSERT INTO question_to_topic VALUES (146, 146, 1);
INSERT INTO question_to_topic VALUES (147, 147, 1);
INSERT INTO question_to_topic VALUES (148, 148, 1);
INSERT INTO question_to_topic VALUES (149, 149, 1);
INSERT INTO question_to_topic VALUES (150, 150, 1);
INSERT INTO question_to_topic VALUES (151, 151, 1);
INSERT INTO question_to_topic VALUES (152, 152, 1);
INSERT INTO question_to_topic VALUES (153, 153, 1);
INSERT INTO question_to_topic VALUES (154, 154, 1);
INSERT INTO question_to_topic VALUES (155, 155, 1);
INSERT INTO question_to_topic VALUES (156, 156, 1);
INSERT INTO question_to_topic VALUES (157, 157, 1);
INSERT INTO question_to_topic VALUES (158, 158, 1);
INSERT INTO question_to_topic VALUES (159, 159, 1);
INSERT INTO question_to_topic VALUES (160, 160, 1);
INSERT INTO question_to_topic VALUES (161, 161, 1);
INSERT INTO question_to_topic VALUES (162, 162, 1);
INSERT INTO question_to_topic VALUES (163, 163, 1);
INSERT INTO question_to_topic VALUES (164, 164, 1);
INSERT INTO question_to_topic VALUES (165, 165, 1);
INSERT INTO question_to_topic VALUES (166, 166, 1);
INSERT INTO question_to_topic VALUES (167, 167, 1);
INSERT INTO question_to_topic VALUES (168, 168, 1);
INSERT INTO question_to_topic VALUES (169, 169, 1);
INSERT INTO question_to_topic VALUES (170, 170, 1);
INSERT INTO question_to_topic VALUES (171, 171, 1);
INSERT INTO question_to_topic VALUES (172, 172, 1);
INSERT INTO question_to_topic VALUES (173, 173, 1);
INSERT INTO question_to_topic VALUES (174, 174, 1);
INSERT INTO question_to_topic VALUES (175, 175, 1);
INSERT INTO question_to_topic VALUES (176, 176, 1);
INSERT INTO question_to_topic VALUES (177, 177, 1);
INSERT INTO question_to_topic VALUES (178, 178, 1);
INSERT INTO question_to_topic VALUES (179, 179, 1);
INSERT INTO question_to_topic VALUES (180, 180, 1);
INSERT INTO question_to_topic VALUES (181, 181, 1);
INSERT INTO question_to_topic VALUES (182, 182, 1);
INSERT INTO question_to_topic VALUES (183, 183, 1);
INSERT INTO question_to_topic VALUES (184, 184, 1);
INSERT INTO question_to_topic VALUES (185, 185, 1);
INSERT INTO question_to_topic VALUES (186, 186, 1);
INSERT INTO question_to_topic VALUES (187, 187, 1);
INSERT INTO question_to_topic VALUES (188, 188, 1);
INSERT INTO question_to_topic VALUES (189, 189, 1);
INSERT INTO question_to_topic VALUES (190, 190, 1);
INSERT INTO question_to_topic VALUES (191, 191, 1);
INSERT INTO question_to_topic VALUES (192, 192, 1);
INSERT INTO question_to_topic VALUES (193, 193, 1);
INSERT INTO question_to_topic VALUES (194, 194, 1);
INSERT INTO question_to_topic VALUES (195, 195, 1);
INSERT INTO question_to_topic VALUES (196, 196, 1);
INSERT INTO question_to_topic VALUES (197, 197, 1);
INSERT INTO question_to_topic VALUES (198, 198, 1);
INSERT INTO question_to_topic VALUES (199, 199, 1);
INSERT INTO question_to_topic VALUES (200, 200, 1);
INSERT INTO question_to_topic VALUES (201, 201, 1);
INSERT INTO question_to_topic VALUES (202, 202, 1);
INSERT INTO question_to_topic VALUES (203, 203, 1);
INSERT INTO question_to_topic VALUES (204, 204, 1);
INSERT INTO question_to_topic VALUES (205, 205, 1);
INSERT INTO question_to_topic VALUES (206, 206, 1);
INSERT INTO question_to_topic VALUES (207, 207, 1);
INSERT INTO question_to_topic VALUES (208, 208, 1);
INSERT INTO question_to_topic VALUES (209, 209, 1);
INSERT INTO question_to_topic VALUES (210, 210, 1);
INSERT INTO question_to_topic VALUES (211, 211, 1);
INSERT INTO question_to_topic VALUES (212, 212, 1);
INSERT INTO question_to_topic VALUES (213, 213, 1);
INSERT INTO question_to_topic VALUES (214, 214, 1);
INSERT INTO question_to_topic VALUES (215, 215, 1);
INSERT INTO question_to_topic VALUES (216, 216, 1);
INSERT INTO question_to_topic VALUES (217, 217, 1);
INSERT INTO question_to_topic VALUES (218, 218, 1);
INSERT INTO question_to_topic VALUES (219, 219, 1);
INSERT INTO question_to_topic VALUES (220, 220, 1);
INSERT INTO question_to_topic VALUES (221, 221, 1);
INSERT INTO question_to_topic VALUES (222, 222, 1);
INSERT INTO question_to_topic VALUES (223, 223, 1);
INSERT INTO question_to_topic VALUES (224, 224, 1);
INSERT INTO question_to_topic VALUES (225, 225, 1);
INSERT INTO question_to_topic VALUES (226, 226, 1);
INSERT INTO question_to_topic VALUES (227, 227, 1);
INSERT INTO question_to_topic VALUES (228, 228, 1);
INSERT INTO question_to_topic VALUES (229, 229, 1);
INSERT INTO question_to_topic VALUES (230, 230, 1);
INSERT INTO question_to_topic VALUES (231, 231, 1);
INSERT INTO question_to_topic VALUES (232, 232, 1);
INSERT INTO question_to_topic VALUES (233, 233, 1);
INSERT INTO question_to_topic VALUES (234, 234, 1);
INSERT INTO question_to_topic VALUES (235, 235, 1);
INSERT INTO question_to_topic VALUES (236, 236, 1);
INSERT INTO question_to_topic VALUES (237, 237, 1);
INSERT INTO question_to_topic VALUES (238, 238, 1);
INSERT INTO question_to_topic VALUES (239, 239, 1);
INSERT INTO question_to_topic VALUES (240, 240, 1);
INSERT INTO question_to_topic VALUES (241, 241, 1);
INSERT INTO question_to_topic VALUES (242, 242, 1);
INSERT INTO question_to_topic VALUES (243, 243, 1);
INSERT INTO question_to_topic VALUES (244, 244, 1);
INSERT INTO question_to_topic VALUES (245, 245, 1);
INSERT INTO question_to_topic VALUES (246, 246, 1);
INSERT INTO question_to_topic VALUES (247, 247, 1);
INSERT INTO question_to_topic VALUES (248, 248, 1);
INSERT INTO question_to_topic VALUES (249, 249, 1);
INSERT INTO question_to_topic VALUES (250, 250, 1);
INSERT INTO question_to_topic VALUES (251, 251, 1);
INSERT INTO question_to_topic VALUES (252, 252, 1);
INSERT INTO question_to_topic VALUES (253, 253, 1);
INSERT INTO question_to_topic VALUES (254, 254, 1);
INSERT INTO question_to_topic VALUES (255, 255, 1);
INSERT INTO question_to_topic VALUES (256, 256, 1);
INSERT INTO question_to_topic VALUES (257, 257, 1);
INSERT INTO question_to_topic VALUES (258, 258, 1);
INSERT INTO question_to_topic VALUES (259, 259, 1);
INSERT INTO question_to_topic VALUES (260, 260, 1);
INSERT INTO question_to_topic VALUES (261, 261, 1);
INSERT INTO question_to_topic VALUES (262, 262, 1);
INSERT INTO question_to_topic VALUES (263, 263, 1);
INSERT INTO question_to_topic VALUES (264, 264, 1);
INSERT INTO question_to_topic VALUES (265, 265, 1);
INSERT INTO question_to_topic VALUES (266, 266, 1);
INSERT INTO question_to_topic VALUES (267, 267, 1);
INSERT INTO question_to_topic VALUES (268, 268, 1);
INSERT INTO question_to_topic VALUES (269, 269, 1);
INSERT INTO question_to_topic VALUES (270, 270, 1);
INSERT INTO question_to_topic VALUES (271, 271, 1);
INSERT INTO question_to_topic VALUES (272, 272, 1);
INSERT INTO question_to_topic VALUES (273, 273, 1);
INSERT INTO question_to_topic VALUES (274, 274, 1);
INSERT INTO question_to_topic VALUES (275, 275, 1);
INSERT INTO question_to_topic VALUES (276, 276, 1);
INSERT INTO question_to_topic VALUES (277, 277, 1);
INSERT INTO question_to_topic VALUES (278, 278, 1);
INSERT INTO question_to_topic VALUES (279, 279, 1);
INSERT INTO question_to_topic VALUES (280, 280, 1);
INSERT INTO question_to_topic VALUES (281, 281, 1);
INSERT INTO question_to_topic VALUES (282, 282, 1);
INSERT INTO question_to_topic VALUES (283, 283, 1);
INSERT INTO question_to_topic VALUES (284, 284, 1);
INSERT INTO question_to_topic VALUES (285, 285, 1);
INSERT INTO question_to_topic VALUES (286, 286, 1);
INSERT INTO question_to_topic VALUES (287, 287, 1);
INSERT INTO question_to_topic VALUES (288, 288, 1);
INSERT INTO question_to_topic VALUES (289, 289, 1);
INSERT INTO question_to_topic VALUES (290, 290, 1);
INSERT INTO question_to_topic VALUES (291, 291, 1);
INSERT INTO question_to_topic VALUES (292, 292, 1);
INSERT INTO question_to_topic VALUES (293, 293, 1);
INSERT INTO question_to_topic VALUES (294, 294, 1);
INSERT INTO question_to_topic VALUES (295, 295, 1);
INSERT INTO question_to_topic VALUES (296, 296, 1);
INSERT INTO question_to_topic VALUES (297, 297, 1);
INSERT INTO question_to_topic VALUES (298, 298, 1);
INSERT INTO question_to_topic VALUES (299, 299, 1);
INSERT INTO question_to_topic VALUES (300, 300, 1);
INSERT INTO question_to_topic VALUES (301, 301, 1);
INSERT INTO question_to_topic VALUES (302, 302, 1);
INSERT INTO question_to_topic VALUES (303, 303, 1);
INSERT INTO question_to_topic VALUES (304, 304, 1);
INSERT INTO question_to_topic VALUES (305, 305, 1);
INSERT INTO question_to_topic VALUES (306, 306, 1);
INSERT INTO question_to_topic VALUES (307, 307, 1);
INSERT INTO question_to_topic VALUES (308, 308, 1);
INSERT INTO question_to_topic VALUES (309, 309, 1);
INSERT INTO question_to_topic VALUES (310, 310, 1);
INSERT INTO question_to_topic VALUES (311, 311, 1);
INSERT INTO question_to_topic VALUES (312, 312, 1);
INSERT INTO question_to_topic VALUES (313, 313, 1);
INSERT INTO question_to_topic VALUES (314, 314, 1);
INSERT INTO question_to_topic VALUES (315, 315, 1);
INSERT INTO question_to_topic VALUES (316, 316, 1);
INSERT INTO question_to_topic VALUES (317, 317, 1);
INSERT INTO question_to_topic VALUES (318, 318, 1);
INSERT INTO question_to_topic VALUES (319, 319, 1);
INSERT INTO question_to_topic VALUES (320, 320, 1);
INSERT INTO question_to_topic VALUES (321, 321, 1);
INSERT INTO question_to_topic VALUES (322, 322, 1);
INSERT INTO question_to_topic VALUES (323, 323, 1);
INSERT INTO question_to_topic VALUES (324, 324, 1);
INSERT INTO question_to_topic VALUES (325, 325, 1);
INSERT INTO question_to_topic VALUES (326, 326, 1);
INSERT INTO question_to_topic VALUES (327, 327, 1);
INSERT INTO question_to_topic VALUES (328, 328, 1);
INSERT INTO question_to_topic VALUES (329, 329, 1);
INSERT INTO question_to_topic VALUES (330, 330, 1);
INSERT INTO question_to_topic VALUES (331, 331, 1);
INSERT INTO question_to_topic VALUES (332, 332, 1);
INSERT INTO question_to_topic VALUES (333, 333, 1);
INSERT INTO question_to_topic VALUES (334, 334, 1);
INSERT INTO question_to_topic VALUES (335, 335, 1);
INSERT INTO question_to_topic VALUES (336, 336, 1);
INSERT INTO question_to_topic VALUES (337, 337, 1);
INSERT INTO question_to_topic VALUES (338, 338, 1);
INSERT INTO question_to_topic VALUES (339, 339, 1);
INSERT INTO question_to_topic VALUES (340, 340, 1);
INSERT INTO question_to_topic VALUES (341, 341, 1);
INSERT INTO question_to_topic VALUES (342, 342, 1);
INSERT INTO question_to_topic VALUES (343, 343, 1);
INSERT INTO question_to_topic VALUES (344, 344, 1);
INSERT INTO question_to_topic VALUES (345, 345, 1);
INSERT INTO question_to_topic VALUES (346, 346, 1);
INSERT INTO question_to_topic VALUES (347, 347, 1);
INSERT INTO question_to_topic VALUES (348, 348, 1);
INSERT INTO question_to_topic VALUES (349, 349, 1);
INSERT INTO question_to_topic VALUES (350, 350, 1);
INSERT INTO question_to_topic VALUES (351, 351, 1);
INSERT INTO question_to_topic VALUES (352, 352, 1);
INSERT INTO question_to_topic VALUES (353, 353, 1);
INSERT INTO question_to_topic VALUES (354, 354, 1);
INSERT INTO question_to_topic VALUES (355, 355, 1);
INSERT INTO question_to_topic VALUES (356, 356, 1);
INSERT INTO question_to_topic VALUES (357, 357, 1);
INSERT INTO question_to_topic VALUES (358, 358, 1);
INSERT INTO question_to_topic VALUES (359, 359, 1);
INSERT INTO question_to_topic VALUES (360, 360, 1);
INSERT INTO question_to_topic VALUES (361, 361, 1);
INSERT INTO question_to_topic VALUES (362, 362, 1);
INSERT INTO question_to_topic VALUES (363, 363, 1);
INSERT INTO question_to_topic VALUES (364, 364, 1);
INSERT INTO question_to_topic VALUES (365, 365, 1);
INSERT INTO question_to_topic VALUES (366, 366, 1);
INSERT INTO question_to_topic VALUES (367, 367, 1);
INSERT INTO question_to_topic VALUES (368, 368, 1);
INSERT INTO question_to_topic VALUES (369, 369, 1);
INSERT INTO question_to_topic VALUES (370, 370, 1);
INSERT INTO question_to_topic VALUES (371, 371, 1);
INSERT INTO question_to_topic VALUES (372, 372, 1);
INSERT INTO question_to_topic VALUES (373, 373, 1);
INSERT INTO question_to_topic VALUES (374, 374, 1);
INSERT INTO question_to_topic VALUES (375, 375, 1);
INSERT INTO question_to_topic VALUES (376, 376, 1);
INSERT INTO question_to_topic VALUES (377, 377, 1);
INSERT INTO question_to_topic VALUES (378, 378, 1);
INSERT INTO question_to_topic VALUES (379, 379, 1);
INSERT INTO question_to_topic VALUES (380, 380, 1);
INSERT INTO question_to_topic VALUES (381, 381, 1);
INSERT INTO question_to_topic VALUES (382, 382, 1);
INSERT INTO question_to_topic VALUES (383, 383, 1);
INSERT INTO question_to_topic VALUES (384, 384, 1);
INSERT INTO question_to_topic VALUES (385, 385, 1);
INSERT INTO question_to_topic VALUES (386, 386, 1);
INSERT INTO question_to_topic VALUES (387, 387, 1);
INSERT INTO question_to_topic VALUES (388, 388, 1);
INSERT INTO question_to_topic VALUES (389, 389, 1);
INSERT INTO question_to_topic VALUES (390, 390, 1);
INSERT INTO question_to_topic VALUES (391, 391, 1);
INSERT INTO question_to_topic VALUES (392, 392, 1);
INSERT INTO question_to_topic VALUES (393, 393, 1);
INSERT INTO question_to_topic VALUES (394, 394, 1);
INSERT INTO question_to_topic VALUES (395, 395, 1);
INSERT INTO question_to_topic VALUES (396, 396, 1);
INSERT INTO question_to_topic VALUES (397, 397, 1);
INSERT INTO question_to_topic VALUES (398, 398, 1);
INSERT INTO question_to_topic VALUES (399, 399, 1);
INSERT INTO question_to_topic VALUES (400, 400, 1);
INSERT INTO question_to_topic VALUES (401, 401, 1);
INSERT INTO question_to_topic VALUES (402, 402, 1);
INSERT INTO question_to_topic VALUES (403, 403, 1);
INSERT INTO question_to_topic VALUES (404, 404, 1);
INSERT INTO question_to_topic VALUES (405, 405, 1);
INSERT INTO question_to_topic VALUES (406, 406, 1);
INSERT INTO question_to_topic VALUES (407, 407, 1);
INSERT INTO question_to_topic VALUES (408, 408, 1);
INSERT INTO question_to_topic VALUES (409, 409, 1);
INSERT INTO question_to_topic VALUES (410, 410, 1);
INSERT INTO question_to_topic VALUES (411, 411, 1);
INSERT INTO question_to_topic VALUES (412, 412, 1);
INSERT INTO question_to_topic VALUES (413, 413, 1);
INSERT INTO question_to_topic VALUES (414, 414, 1);
INSERT INTO question_to_topic VALUES (415, 415, 1);
INSERT INTO question_to_topic VALUES (416, 416, 1);
INSERT INTO question_to_topic VALUES (417, 417, 1);
INSERT INTO question_to_topic VALUES (418, 418, 1);
INSERT INTO question_to_topic VALUES (419, 419, 1);
INSERT INTO question_to_topic VALUES (420, 420, 1);
INSERT INTO question_to_topic VALUES (421, 421, 1);
INSERT INTO question_to_topic VALUES (422, 422, 1);
INSERT INTO question_to_topic VALUES (423, 423, 1);

INSERT INTO question_to_topic VALUES (424, 424, 2);
INSERT INTO question_to_topic VALUES (425, 425, 2);
INSERT INTO question_to_topic VALUES (426, 426, 2);
INSERT INTO question_to_topic VALUES (427, 427, 2);
INSERT INTO question_to_topic VALUES (428, 428, 2);
INSERT INTO question_to_topic VALUES (429, 429, 2);
INSERT INTO question_to_topic VALUES (430, 430, 2);
INSERT INTO question_to_topic VALUES (431, 431, 2);
INSERT INTO question_to_topic VALUES (432, 432, 2);
INSERT INTO question_to_topic VALUES (433, 433, 2);
INSERT INTO question_to_topic VALUES (434, 434, 2);
INSERT INTO question_to_topic VALUES (435, 435, 2);
INSERT INTO question_to_topic VALUES (436, 436, 2);
INSERT INTO question_to_topic VALUES (437, 437, 2);
INSERT INTO question_to_topic VALUES (438, 438, 2);
INSERT INTO question_to_topic VALUES (439, 439, 2);
INSERT INTO question_to_topic VALUES (440, 440, 2);
INSERT INTO question_to_topic VALUES (441, 441, 2);
INSERT INTO question_to_topic VALUES (442, 442, 2);
INSERT INTO question_to_topic VALUES (443, 443, 2);
INSERT INTO question_to_topic VALUES (444, 444, 2);
INSERT INTO question_to_topic VALUES (445, 445, 2);
INSERT INTO question_to_topic VALUES (446, 446, 2);
INSERT INTO question_to_topic VALUES (447, 447, 2);
INSERT INTO question_to_topic VALUES (448, 448, 2);
INSERT INTO question_to_topic VALUES (449, 449, 2);
INSERT INTO question_to_topic VALUES (450, 450, 2);
INSERT INTO question_to_topic VALUES (451, 451, 2);
INSERT INTO question_to_topic VALUES (452, 452, 2);
INSERT INTO question_to_topic VALUES (453, 453, 2);
INSERT INTO question_to_topic VALUES (454, 454, 2);
INSERT INTO question_to_topic VALUES (455, 455, 2);
INSERT INTO question_to_topic VALUES (456, 456, 2);
INSERT INTO question_to_topic VALUES (457, 457, 2);
INSERT INTO question_to_topic VALUES (458, 458, 2);
INSERT INTO question_to_topic VALUES (459, 459, 2);
INSERT INTO question_to_topic VALUES (460, 460, 2);
INSERT INTO question_to_topic VALUES (461, 461, 2);
INSERT INTO question_to_topic VALUES (462, 462, 2);
INSERT INTO question_to_topic VALUES (463, 463, 2);
INSERT INTO question_to_topic VALUES (464, 464, 2);
INSERT INTO question_to_topic VALUES (465, 465, 2);
INSERT INTO question_to_topic VALUES (466, 466, 2);
INSERT INTO question_to_topic VALUES (467, 467, 2);
INSERT INTO question_to_topic VALUES (468, 468, 2);
INSERT INTO question_to_topic VALUES (469, 469, 2);
INSERT INTO question_to_topic VALUES (470, 470, 2);
INSERT INTO question_to_topic VALUES (471, 471, 2);
INSERT INTO question_to_topic VALUES (472, 472, 2);
INSERT INTO question_to_topic VALUES (473, 473, 2);
INSERT INTO question_to_topic VALUES (474, 474, 2);
INSERT INTO question_to_topic VALUES (475, 475, 2);
INSERT INTO question_to_topic VALUES (476, 476, 2);
INSERT INTO question_to_topic VALUES (477, 477, 2);
INSERT INTO question_to_topic VALUES (478, 478, 2);
INSERT INTO question_to_topic VALUES (479, 479, 2);
INSERT INTO question_to_topic VALUES (480, 480, 2);
INSERT INTO question_to_topic VALUES (481, 481, 2);
INSERT INTO question_to_topic VALUES (482, 482, 2);
INSERT INTO question_to_topic VALUES (483, 483, 2);
INSERT INTO question_to_topic VALUES (484, 484, 2);
INSERT INTO question_to_topic VALUES (485, 485, 2);
INSERT INTO question_to_topic VALUES (486, 486, 2);
INSERT INTO question_to_topic VALUES (487, 487, 2);
INSERT INTO question_to_topic VALUES (488, 488, 2);
INSERT INTO question_to_topic VALUES (489, 489, 2);
INSERT INTO question_to_topic VALUES (490, 490, 2);
INSERT INTO question_to_topic VALUES (491, 491, 2);
INSERT INTO question_to_topic VALUES (492, 492, 2);
INSERT INTO question_to_topic VALUES (493, 493, 2);
INSERT INTO question_to_topic VALUES (494, 494, 2);
INSERT INTO question_to_topic VALUES (495, 495, 2);
INSERT INTO question_to_topic VALUES (496, 496, 2);
INSERT INTO question_to_topic VALUES (497, 497, 2);
INSERT INTO question_to_topic VALUES (498, 498, 2);
INSERT INTO question_to_topic VALUES (499, 499, 2);
INSERT INTO question_to_topic VALUES (500, 500, 2);
INSERT INTO question_to_topic VALUES (501, 501, 2);
INSERT INTO question_to_topic VALUES (502, 502, 2);
INSERT INTO question_to_topic VALUES (503, 503, 2);
INSERT INTO question_to_topic VALUES (504, 504, 2);
INSERT INTO question_to_topic VALUES (505, 505, 2);
INSERT INTO question_to_topic VALUES (506, 506, 2);
INSERT INTO question_to_topic VALUES (507, 507, 2);
INSERT INTO question_to_topic VALUES (508, 508, 2);
INSERT INTO question_to_topic VALUES (509, 509, 2);
INSERT INTO question_to_topic VALUES (510, 510, 2);
INSERT INTO question_to_topic VALUES (511, 511, 2);
INSERT INTO question_to_topic VALUES (512, 512, 2);
INSERT INTO question_to_topic VALUES (513, 513, 2);
INSERT INTO question_to_topic VALUES (514, 514, 2);
INSERT INTO question_to_topic VALUES (515, 515, 2);
INSERT INTO question_to_topic VALUES (516, 516, 2);
INSERT INTO question_to_topic VALUES (517, 517, 2);
INSERT INTO question_to_topic VALUES (518, 518, 2);
INSERT INTO question_to_topic VALUES (519, 519, 2);
INSERT INTO question_to_topic VALUES (520, 520, 2);
INSERT INTO question_to_topic VALUES (521, 521, 2);
INSERT INTO question_to_topic VALUES (522, 522, 2);
INSERT INTO question_to_topic VALUES (523, 523, 2);
INSERT INTO question_to_topic VALUES (524, 524, 2);
INSERT INTO question_to_topic VALUES (525, 525, 2);
INSERT INTO question_to_topic VALUES (526, 526, 2);
INSERT INTO question_to_topic VALUES (527, 527, 2);
INSERT INTO question_to_topic VALUES (528, 528, 2);
INSERT INTO question_to_topic VALUES (529, 529, 2);
INSERT INTO question_to_topic VALUES (530, 530, 2);
INSERT INTO question_to_topic VALUES (531, 531, 2);
INSERT INTO question_to_topic VALUES (532, 532, 2);
INSERT INTO question_to_topic VALUES (533, 533, 2);
INSERT INTO question_to_topic VALUES (534, 534, 2);
INSERT INTO question_to_topic VALUES (535, 535, 2);
INSERT INTO question_to_topic VALUES (536, 536, 2);
INSERT INTO question_to_topic VALUES (537, 537, 2);
INSERT INTO question_to_topic VALUES (538, 538, 2);
INSERT INTO question_to_topic VALUES (539, 539, 2);
INSERT INTO question_to_topic VALUES (540, 540, 2);
INSERT INTO question_to_topic VALUES (541, 541, 2);
INSERT INTO question_to_topic VALUES (542, 542, 2);
INSERT INTO question_to_topic VALUES (543, 543, 2);
INSERT INTO question_to_topic VALUES (544, 544, 2);
INSERT INTO question_to_topic VALUES (545, 545, 2);
INSERT INTO question_to_topic VALUES (546, 546, 2);
INSERT INTO question_to_topic VALUES (547, 547, 2);
INSERT INTO question_to_topic VALUES (548, 548, 2);
INSERT INTO question_to_topic VALUES (549, 549, 2);
INSERT INTO question_to_topic VALUES (550, 550, 2);
INSERT INTO question_to_topic VALUES (551, 551, 2);
INSERT INTO question_to_topic VALUES (552, 552, 2);
INSERT INTO question_to_topic VALUES (553, 553, 2);
INSERT INTO question_to_topic VALUES (554, 554, 2);
INSERT INTO question_to_topic VALUES (555, 555, 2);
INSERT INTO question_to_topic VALUES (556, 556, 2);
INSERT INTO question_to_topic VALUES (557, 557, 2);
INSERT INTO question_to_topic VALUES (558, 558, 2);
INSERT INTO question_to_topic VALUES (559, 559, 2);
INSERT INTO question_to_topic VALUES (560, 560, 2);
INSERT INTO question_to_topic VALUES (561, 561, 2);
INSERT INTO question_to_topic VALUES (562, 562, 2);
INSERT INTO question_to_topic VALUES (563, 563, 2);
INSERT INTO question_to_topic VALUES (564, 564, 2);
INSERT INTO question_to_topic VALUES (565, 565, 2);
INSERT INTO question_to_topic VALUES (566, 566, 2);
INSERT INTO question_to_topic VALUES (567, 567, 2);
INSERT INTO question_to_topic VALUES (568, 568, 2);
INSERT INTO question_to_topic VALUES (569, 569, 2);
INSERT INTO question_to_topic VALUES (570, 570, 2);
INSERT INTO question_to_topic VALUES (571, 571, 2);
INSERT INTO question_to_topic VALUES (572, 572, 2);
INSERT INTO question_to_topic VALUES (573, 573, 2);
INSERT INTO question_to_topic VALUES (574, 574, 2);
INSERT INTO question_to_topic VALUES (575, 575, 2);
INSERT INTO question_to_topic VALUES (576, 576, 2);
INSERT INTO question_to_topic VALUES (577, 577, 2);
INSERT INTO question_to_topic VALUES (578, 578, 2);
INSERT INTO question_to_topic VALUES (579, 579, 2);
INSERT INTO question_to_topic VALUES (580, 580, 2);
INSERT INTO question_to_topic VALUES (581, 581, 2);
INSERT INTO question_to_topic VALUES (582, 582, 2);
INSERT INTO question_to_topic VALUES (583, 583, 2);
INSERT INTO question_to_topic VALUES (584, 584, 2);
INSERT INTO question_to_topic VALUES (585, 585, 2);
INSERT INTO question_to_topic VALUES (586, 586, 2);
INSERT INTO question_to_topic VALUES (587, 587, 2);
INSERT INTO question_to_topic VALUES (588, 588, 2);
INSERT INTO question_to_topic VALUES (589, 589, 2);
INSERT INTO question_to_topic VALUES (590, 590, 2);
INSERT INTO question_to_topic VALUES (591, 591, 2);
INSERT INTO question_to_topic VALUES (592, 592, 2);
INSERT INTO question_to_topic VALUES (593, 593, 2);
INSERT INTO question_to_topic VALUES (594, 594, 2);
INSERT INTO question_to_topic VALUES (595, 595, 2);
INSERT INTO question_to_topic VALUES (596, 596, 2);
INSERT INTO question_to_topic VALUES (597, 597, 2);
INSERT INTO question_to_topic VALUES (598, 598, 2);
INSERT INTO question_to_topic VALUES (599, 599, 2);
INSERT INTO question_to_topic VALUES (600, 600, 2);
INSERT INTO question_to_topic VALUES (601, 601, 2);
INSERT INTO question_to_topic VALUES (602, 602, 2);
INSERT INTO question_to_topic VALUES (603, 603, 2);
INSERT INTO question_to_topic VALUES (604, 604, 2);
INSERT INTO question_to_topic VALUES (605, 605, 2);
INSERT INTO question_to_topic VALUES (606, 606, 2);
INSERT INTO question_to_topic VALUES (607, 607, 2);
INSERT INTO question_to_topic VALUES (608, 608, 2);
INSERT INTO question_to_topic VALUES (609, 609, 2);
INSERT INTO question_to_topic VALUES (610, 610, 2);
INSERT INTO question_to_topic VALUES (611, 611, 2);
INSERT INTO question_to_topic VALUES (612, 612, 2);
INSERT INTO question_to_topic VALUES (613, 613, 2);
INSERT INTO question_to_topic VALUES (614, 614, 2);
INSERT INTO question_to_topic VALUES (615, 615, 2);
INSERT INTO question_to_topic VALUES (616, 616, 2);
INSERT INTO question_to_topic VALUES (617, 617, 2);
INSERT INTO question_to_topic VALUES (618, 618, 2);
INSERT INTO question_to_topic VALUES (619, 619, 2);
INSERT INTO question_to_topic VALUES (620, 620, 2);
INSERT INTO question_to_topic VALUES (621, 621, 2);
INSERT INTO question_to_topic VALUES (622, 622, 2);
INSERT INTO question_to_topic VALUES (623, 623, 2);
INSERT INTO question_to_topic VALUES (624, 624, 2);
INSERT INTO question_to_topic VALUES (625, 625, 2);
INSERT INTO question_to_topic VALUES (626, 626, 2);
INSERT INTO question_to_topic VALUES (627, 627, 2);
INSERT INTO question_to_topic VALUES (628, 628, 2);
INSERT INTO question_to_topic VALUES (629, 629, 2);
INSERT INTO question_to_topic VALUES (630, 630, 2);
INSERT INTO question_to_topic VALUES (631, 631, 2);
INSERT INTO question_to_topic VALUES (632, 632, 2);
INSERT INTO question_to_topic VALUES (633, 633, 2);
INSERT INTO question_to_topic VALUES (634, 634, 2);
INSERT INTO question_to_topic VALUES (635, 635, 2);
INSERT INTO question_to_topic VALUES (636, 636, 2);
INSERT INTO question_to_topic VALUES (637, 637, 2);
INSERT INTO question_to_topic VALUES (638, 638, 2);
INSERT INTO question_to_topic VALUES (639, 639, 2);
INSERT INTO question_to_topic VALUES (640, 640, 2);
INSERT INTO question_to_topic VALUES (641, 641, 2);
INSERT INTO question_to_topic VALUES (642, 642, 2);
INSERT INTO question_to_topic VALUES (643, 643, 2);
INSERT INTO question_to_topic VALUES (644, 644, 2);
INSERT INTO question_to_topic VALUES (645, 645, 2);
INSERT INTO question_to_topic VALUES (646, 646, 2);
INSERT INTO question_to_topic VALUES (647, 647, 2);
INSERT INTO question_to_topic VALUES (648, 648, 2);
INSERT INTO question_to_topic VALUES (649, 649, 2);
INSERT INTO question_to_topic VALUES (650, 650, 2);
INSERT INTO question_to_topic VALUES (651, 651, 2);
INSERT INTO question_to_topic VALUES (652, 652, 2);
INSERT INTO question_to_topic VALUES (653, 653, 2);
INSERT INTO question_to_topic VALUES (654, 654, 2);
INSERT INTO question_to_topic VALUES (655, 655, 2);
INSERT INTO question_to_topic VALUES (656, 656, 2);
INSERT INTO question_to_topic VALUES (657, 657, 2);
INSERT INTO question_to_topic VALUES (658, 658, 2);
INSERT INTO question_to_topic VALUES (659, 659, 2);
INSERT INTO question_to_topic VALUES (660, 660, 2);
INSERT INTO question_to_topic VALUES (661, 661, 2);
INSERT INTO question_to_topic VALUES (662, 662, 2);
INSERT INTO question_to_topic VALUES (663, 663, 2);
INSERT INTO question_to_topic VALUES (664, 664, 2);
INSERT INTO question_to_topic VALUES (665, 665, 2);
INSERT INTO question_to_topic VALUES (666, 666, 2);
INSERT INTO question_to_topic VALUES (667, 667, 2);
INSERT INTO question_to_topic VALUES (668, 668, 2);
INSERT INTO question_to_topic VALUES (669, 669, 2);
INSERT INTO question_to_topic VALUES (670, 670, 2);
INSERT INTO question_to_topic VALUES (671, 671, 2);
INSERT INTO question_to_topic VALUES (672, 672, 2);
INSERT INTO question_to_topic VALUES (673, 673, 2);
INSERT INTO question_to_topic VALUES (674, 674, 2);
INSERT INTO question_to_topic VALUES (675, 675, 2);
INSERT INTO question_to_topic VALUES (676, 676, 2);
INSERT INTO question_to_topic VALUES (677, 677, 2);
INSERT INTO question_to_topic VALUES (678, 678, 2);
INSERT INTO question_to_topic VALUES (679, 679, 2);
INSERT INTO question_to_topic VALUES (680, 680, 2);
INSERT INTO question_to_topic VALUES (681, 681, 2);
INSERT INTO question_to_topic VALUES (682, 682, 2);
INSERT INTO question_to_topic VALUES (683, 683, 2);
INSERT INTO question_to_topic VALUES (684, 684, 2);
INSERT INTO question_to_topic VALUES (685, 685, 2);
INSERT INTO question_to_topic VALUES (686, 686, 2);
INSERT INTO question_to_topic VALUES (687, 687, 2);
INSERT INTO question_to_topic VALUES (688, 688, 2);
INSERT INTO question_to_topic VALUES (689, 689, 2);
INSERT INTO question_to_topic VALUES (690, 690, 2);
INSERT INTO question_to_topic VALUES (691, 691, 2);
INSERT INTO question_to_topic VALUES (692, 692, 2);
INSERT INTO question_to_topic VALUES (693, 693, 2);
INSERT INTO question_to_topic VALUES (694, 694, 2);
INSERT INTO question_to_topic VALUES (695, 695, 2);
INSERT INTO question_to_topic VALUES (696, 696, 2);
INSERT INTO question_to_topic VALUES (697, 697, 2);
INSERT INTO question_to_topic VALUES (698, 698, 2);
INSERT INTO question_to_topic VALUES (699, 699, 2);
INSERT INTO question_to_topic VALUES (700, 700, 2);
INSERT INTO question_to_topic VALUES (701, 701, 2);
INSERT INTO question_to_topic VALUES (702, 702, 2);
INSERT INTO question_to_topic VALUES (703, 703, 2);
INSERT INTO question_to_topic VALUES (704, 704, 2);
INSERT INTO question_to_topic VALUES (705, 705, 2);
INSERT INTO question_to_topic VALUES (706, 706, 2);
INSERT INTO question_to_topic VALUES (707, 707, 2);
INSERT INTO question_to_topic VALUES (708, 708, 2);
INSERT INTO question_to_topic VALUES (709, 709, 2);
INSERT INTO question_to_topic VALUES (710, 710, 2);
INSERT INTO question_to_topic VALUES (711, 711, 2);
INSERT INTO question_to_topic VALUES (712, 712, 2);
INSERT INTO question_to_topic VALUES (713, 713, 2);
INSERT INTO question_to_topic VALUES (714, 714, 2);
INSERT INTO question_to_topic VALUES (715, 715, 2);
INSERT INTO question_to_topic VALUES (716, 716, 2);
INSERT INTO question_to_topic VALUES (717, 717, 2);
INSERT INTO question_to_topic VALUES (718, 718, 2);
INSERT INTO question_to_topic VALUES (719, 719, 2);
INSERT INTO question_to_topic VALUES (720, 720, 2);
INSERT INTO question_to_topic VALUES (721, 721, 2);
INSERT INTO question_to_topic VALUES (722, 722, 2);
INSERT INTO question_to_topic VALUES (723, 723, 2);
INSERT INTO question_to_topic VALUES (724, 724, 2);
INSERT INTO question_to_topic VALUES (725, 725, 2);
INSERT INTO question_to_topic VALUES (726, 726, 2);
INSERT INTO question_to_topic VALUES (727, 727, 2);
INSERT INTO question_to_topic VALUES (728, 728, 2);
INSERT INTO question_to_topic VALUES (729, 729, 2);
INSERT INTO question_to_topic VALUES (730, 730, 2);
INSERT INTO question_to_topic VALUES (731, 731, 2);
INSERT INTO question_to_topic VALUES (732, 732, 2);
INSERT INTO question_to_topic VALUES (733, 733, 2);
INSERT INTO question_to_topic VALUES (734, 734, 2);
INSERT INTO question_to_topic VALUES (735, 735, 2);
INSERT INTO question_to_topic VALUES (736, 736, 2);
INSERT INTO question_to_topic VALUES (737, 737, 2);
INSERT INTO question_to_topic VALUES (738, 738, 2);
INSERT INTO question_to_topic VALUES (739, 739, 2);
INSERT INTO question_to_topic VALUES (740, 740, 2);
INSERT INTO question_to_topic VALUES (741, 741, 2);
INSERT INTO question_to_topic VALUES (742, 742, 2);
INSERT INTO question_to_topic VALUES (743, 743, 2);
INSERT INTO question_to_topic VALUES (744, 744, 2);
INSERT INTO question_to_topic VALUES (745, 745, 2);
INSERT INTO question_to_topic VALUES (746, 746, 2);
INSERT INTO question_to_topic VALUES (747, 747, 2);
INSERT INTO question_to_topic VALUES (748, 748, 2);
INSERT INTO question_to_topic VALUES (749, 749, 2);
INSERT INTO question_to_topic VALUES (750, 750, 2);
INSERT INTO question_to_topic VALUES (751, 751, 2);
INSERT INTO question_to_topic VALUES (752, 752, 2);
INSERT INTO question_to_topic VALUES (753, 753, 2);
INSERT INTO question_to_topic VALUES (754, 754, 2);
INSERT INTO question_to_topic VALUES (755, 755, 2);
INSERT INTO question_to_topic VALUES (756, 756, 2);
INSERT INTO question_to_topic VALUES (757, 757, 2);
INSERT INTO question_to_topic VALUES (758, 758, 2);
INSERT INTO question_to_topic VALUES (759, 759, 2);
INSERT INTO question_to_topic VALUES (760, 760, 2);
INSERT INTO question_to_topic VALUES (761, 761, 2);
INSERT INTO question_to_topic VALUES (762, 762, 2);
INSERT INTO question_to_topic VALUES (763, 763, 2);
INSERT INTO question_to_topic VALUES (764, 764, 2);
INSERT INTO question_to_topic VALUES (765, 765, 2);
INSERT INTO question_to_topic VALUES (766, 766, 2);
INSERT INTO question_to_topic VALUES (767, 767, 2);
INSERT INTO question_to_topic VALUES (768, 768, 2);
INSERT INTO question_to_topic VALUES (769, 769, 2);
INSERT INTO question_to_topic VALUES (770, 770, 2);
INSERT INTO question_to_topic VALUES (771, 771, 2);
INSERT INTO question_to_topic VALUES (772, 772, 2);
INSERT INTO question_to_topic VALUES (773, 773, 2);
INSERT INTO question_to_topic VALUES (774, 774, 2);
INSERT INTO question_to_topic VALUES (775, 775, 2);
INSERT INTO question_to_topic VALUES (776, 776, 2);
INSERT INTO question_to_topic VALUES (777, 777, 2);
INSERT INTO question_to_topic VALUES (778, 778, 2);
INSERT INTO question_to_topic VALUES (779, 779, 2);
INSERT INTO question_to_topic VALUES (780, 780, 2);
INSERT INTO question_to_topic VALUES (781, 781, 2);
INSERT INTO question_to_topic VALUES (782, 782, 2);
INSERT INTO question_to_topic VALUES (783, 783, 2);
INSERT INTO question_to_topic VALUES (784, 784, 2);
INSERT INTO question_to_topic VALUES (785, 785, 2);
INSERT INTO question_to_topic VALUES (786, 786, 2);
INSERT INTO question_to_topic VALUES (787, 787, 2);
INSERT INTO question_to_topic VALUES (788, 788, 2);
INSERT INTO question_to_topic VALUES (789, 789, 2);
INSERT INTO question_to_topic VALUES (790, 790, 2);
INSERT INTO question_to_topic VALUES (791, 791, 2);
INSERT INTO question_to_topic VALUES (792, 792, 2);
INSERT INTO question_to_topic VALUES (793, 793, 2);
INSERT INTO question_to_topic VALUES (794, 794, 2);
INSERT INTO question_to_topic VALUES (795, 795, 2);
INSERT INTO question_to_topic VALUES (796, 796, 2);
INSERT INTO question_to_topic VALUES (797, 797, 2);
INSERT INTO question_to_topic VALUES (798, 798, 2);
INSERT INTO question_to_topic VALUES (799, 799, 2);
INSERT INTO question_to_topic VALUES (800, 800, 2);
INSERT INTO question_to_topic VALUES (801, 801, 2);
INSERT INTO question_to_topic VALUES (802, 802, 2);
INSERT INTO question_to_topic VALUES (803, 803, 2);
INSERT INTO question_to_topic VALUES (804, 804, 2);
INSERT INTO question_to_topic VALUES (805, 805, 2);
INSERT INTO question_to_topic VALUES (806, 806, 2);
INSERT INTO question_to_topic VALUES (807, 807, 2);
INSERT INTO question_to_topic VALUES (808, 808, 2);
INSERT INTO question_to_topic VALUES (809, 809, 2);
INSERT INTO question_to_topic VALUES (810, 810, 2);
INSERT INTO question_to_topic VALUES (811, 811, 2);
INSERT INTO question_to_topic VALUES (812, 812, 2);
INSERT INTO question_to_topic VALUES (813, 813, 2);
INSERT INTO question_to_topic VALUES (814, 814, 2);
INSERT INTO question_to_topic VALUES (815, 815, 2);
INSERT INTO question_to_topic VALUES (816, 816, 2);
INSERT INTO question_to_topic VALUES (817, 817, 2);
INSERT INTO question_to_topic VALUES (818, 818, 2);
INSERT INTO question_to_topic VALUES (819, 819, 2);
INSERT INTO question_to_topic VALUES (820, 820, 2);
INSERT INTO question_to_topic VALUES (821, 821, 2);
INSERT INTO question_to_topic VALUES (822, 822, 2);
INSERT INTO question_to_topic VALUES (823, 823, 2);
INSERT INTO question_to_topic VALUES (824, 824, 2);
INSERT INTO question_to_topic VALUES (825, 825, 2);
INSERT INTO question_to_topic VALUES (826, 826, 2);
INSERT INTO question_to_topic VALUES (827, 827, 2);
INSERT INTO question_to_topic VALUES (828, 828, 2);
INSERT INTO question_to_topic VALUES (829, 829, 2);
INSERT INTO question_to_topic VALUES (830, 830, 2);
INSERT INTO question_to_topic VALUES (831, 831, 2);
INSERT INTO question_to_topic VALUES (832, 832, 2);
INSERT INTO question_to_topic VALUES (833, 833, 2);
INSERT INTO question_to_topic VALUES (834, 834, 2);
INSERT INTO question_to_topic VALUES (835, 835, 2);
INSERT INTO question_to_topic VALUES (836, 836, 2);
INSERT INTO question_to_topic VALUES (837, 837, 2);
INSERT INTO question_to_topic VALUES (838, 838, 2);
INSERT INTO question_to_topic VALUES (839, 839, 2);
INSERT INTO question_to_topic VALUES (840, 840, 2);
INSERT INTO question_to_topic VALUES (841, 841, 2);
INSERT INTO question_to_topic VALUES (842, 842, 2);
INSERT INTO question_to_topic VALUES (843, 843, 2);
INSERT INTO question_to_topic VALUES (844, 844, 2);
INSERT INTO question_to_topic VALUES (845, 845, 2);
INSERT INTO question_to_topic VALUES (846, 846, 2);
INSERT INTO question_to_topic VALUES (847, 847, 2);
INSERT INTO question_to_topic VALUES (848, 848, 2);
INSERT INTO question_to_topic VALUES (849, 849, 2);
INSERT INTO question_to_topic VALUES (850, 850, 2);
INSERT INTO question_to_topic VALUES (851, 851, 2);
INSERT INTO question_to_topic VALUES (852, 852, 2);
INSERT INTO question_to_topic VALUES (853, 853, 2);
INSERT INTO question_to_topic VALUES (854, 854, 2);
INSERT INTO question_to_topic VALUES (855, 855, 2);
INSERT INTO question_to_topic VALUES (856, 856, 2);
INSERT INTO question_to_topic VALUES (857, 857, 2);
INSERT INTO question_to_topic VALUES (858, 858, 2);
INSERT INTO question_to_topic VALUES (859, 859, 2);
INSERT INTO question_to_topic VALUES (860, 860, 2);
INSERT INTO question_to_topic VALUES (861, 861, 2);
INSERT INTO question_to_topic VALUES (862, 862, 2);
INSERT INTO question_to_topic VALUES (863, 863, 2);
INSERT INTO question_to_topic VALUES (864, 864, 2);
INSERT INTO question_to_topic VALUES (865, 865, 2);
INSERT INTO question_to_topic VALUES (866, 866, 2);
INSERT INTO question_to_topic VALUES (867, 867, 2);
INSERT INTO question_to_topic VALUES (868, 868, 2);
INSERT INTO question_to_topic VALUES (869, 869, 2);
INSERT INTO question_to_topic VALUES (870, 870, 2);
INSERT INTO question_to_topic VALUES (871, 871, 2);
INSERT INTO question_to_topic VALUES (872, 872, 2);
INSERT INTO question_to_topic VALUES (873, 873, 2);
INSERT INTO question_to_topic VALUES (874, 874, 2);
INSERT INTO question_to_topic VALUES (875, 875, 2);
INSERT INTO question_to_topic VALUES (876, 876, 2);
INSERT INTO question_to_topic VALUES (877, 877, 2);

INSERT INTO question_to_topic VALUES (878, 878, 3);
INSERT INTO question_to_topic VALUES (879, 879, 3);
INSERT INTO question_to_topic VALUES (880, 880, 3);
INSERT INTO question_to_topic VALUES (881, 881, 3);
INSERT INTO question_to_topic VALUES (882, 882, 3);
INSERT INTO question_to_topic VALUES (883, 883, 3);
INSERT INTO question_to_topic VALUES (884, 884, 3);
INSERT INTO question_to_topic VALUES (885, 885, 3);
INSERT INTO question_to_topic VALUES (886, 886, 3);
INSERT INTO question_to_topic VALUES (887, 887, 3);
INSERT INTO question_to_topic VALUES (888, 888, 3);
INSERT INTO question_to_topic VALUES (889, 889, 3);
INSERT INTO question_to_topic VALUES (890, 890, 3);
INSERT INTO question_to_topic VALUES (891, 891, 3);
INSERT INTO question_to_topic VALUES (892, 892, 3);
INSERT INTO question_to_topic VALUES (893, 893, 3);
INSERT INTO question_to_topic VALUES (894, 894, 3);
INSERT INTO question_to_topic VALUES (895, 895, 3);
INSERT INTO question_to_topic VALUES (896, 896, 3);
INSERT INTO question_to_topic VALUES (897, 897, 3);
INSERT INTO question_to_topic VALUES (898, 898, 3);
INSERT INTO question_to_topic VALUES (899, 899, 3);
INSERT INTO question_to_topic VALUES (900, 900, 3);
INSERT INTO question_to_topic VALUES (901, 901, 3);
INSERT INTO question_to_topic VALUES (902, 902, 3);
INSERT INTO question_to_topic VALUES (903, 903, 3);
INSERT INTO question_to_topic VALUES (904, 904, 3);
INSERT INTO question_to_topic VALUES (905, 905, 3);
INSERT INTO question_to_topic VALUES (906, 906, 3);
INSERT INTO question_to_topic VALUES (907, 907, 3);
INSERT INTO question_to_topic VALUES (908, 908, 3);
INSERT INTO question_to_topic VALUES (909, 909, 3);
INSERT INTO question_to_topic VALUES (910, 910, 3);
INSERT INTO question_to_topic VALUES (911, 911, 3);
INSERT INTO question_to_topic VALUES (912, 912, 3);
INSERT INTO question_to_topic VALUES (913, 913, 3);
INSERT INTO question_to_topic VALUES (914, 914, 3);
INSERT INTO question_to_topic VALUES (915, 915, 3);
INSERT INTO question_to_topic VALUES (916, 916, 3);
INSERT INTO question_to_topic VALUES (917, 917, 3);
INSERT INTO question_to_topic VALUES (918, 918, 3);
INSERT INTO question_to_topic VALUES (919, 919, 3);
INSERT INTO question_to_topic VALUES (920, 920, 3);
INSERT INTO question_to_topic VALUES (921, 921, 3);
INSERT INTO question_to_topic VALUES (922, 922, 3);
INSERT INTO question_to_topic VALUES (923, 923, 3);
INSERT INTO question_to_topic VALUES (924, 924, 3);
INSERT INTO question_to_topic VALUES (925, 925, 3);
INSERT INTO question_to_topic VALUES (926, 926, 3);
INSERT INTO question_to_topic VALUES (927, 927, 3);
INSERT INTO question_to_topic VALUES (928, 928, 3);
INSERT INTO question_to_topic VALUES (929, 929, 3);
INSERT INTO question_to_topic VALUES (930, 930, 3);
INSERT INTO question_to_topic VALUES (931, 931, 3);
INSERT INTO question_to_topic VALUES (932, 932, 3);
INSERT INTO question_to_topic VALUES (933, 933, 3);
INSERT INTO question_to_topic VALUES (934, 934, 3);
INSERT INTO question_to_topic VALUES (935, 935, 3);
INSERT INTO question_to_topic VALUES (936, 936, 3);
INSERT INTO question_to_topic VALUES (937, 937, 3);
INSERT INTO question_to_topic VALUES (938, 938, 3);
INSERT INTO question_to_topic VALUES (939, 939, 3);
INSERT INTO question_to_topic VALUES (940, 940, 3);
INSERT INTO question_to_topic VALUES (941, 941, 3);
INSERT INTO question_to_topic VALUES (942, 942, 3);
INSERT INTO question_to_topic VALUES (943, 943, 3);
INSERT INTO question_to_topic VALUES (944, 944, 3);
INSERT INTO question_to_topic VALUES (945, 945, 3);
INSERT INTO question_to_topic VALUES (946, 946, 3);
INSERT INTO question_to_topic VALUES (947, 947, 3);
INSERT INTO question_to_topic VALUES (948, 948, 3);
INSERT INTO question_to_topic VALUES (949, 949, 3);
INSERT INTO question_to_topic VALUES (950, 950, 3);
INSERT INTO question_to_topic VALUES (951, 951, 3);
INSERT INTO question_to_topic VALUES (952, 952, 3);
INSERT INTO question_to_topic VALUES (953, 953, 3);
INSERT INTO question_to_topic VALUES (954, 954, 3);
INSERT INTO question_to_topic VALUES (955, 955, 3);
INSERT INTO question_to_topic VALUES (956, 956, 3);
INSERT INTO question_to_topic VALUES (957, 957, 3);
INSERT INTO question_to_topic VALUES (958, 958, 3);
INSERT INTO question_to_topic VALUES (959, 959, 3);
INSERT INTO question_to_topic VALUES (960, 960, 3);
INSERT INTO question_to_topic VALUES (961, 961, 3);
INSERT INTO question_to_topic VALUES (962, 962, 3);
INSERT INTO question_to_topic VALUES (963, 963, 3);
INSERT INTO question_to_topic VALUES (964, 964, 3);
INSERT INTO question_to_topic VALUES (965, 965, 3);
INSERT INTO question_to_topic VALUES (966, 966, 3);
INSERT INTO question_to_topic VALUES (967, 967, 3);
INSERT INTO question_to_topic VALUES (968, 968, 3);
INSERT INTO question_to_topic VALUES (969, 969, 3);
INSERT INTO question_to_topic VALUES (970, 970, 3);
INSERT INTO question_to_topic VALUES (971, 971, 3);
INSERT INTO question_to_topic VALUES (972, 972, 3);
INSERT INTO question_to_topic VALUES (973, 973, 3);
INSERT INTO question_to_topic VALUES (974, 974, 3);
INSERT INTO question_to_topic VALUES (975, 975, 3);
INSERT INTO question_to_topic VALUES (976, 976, 3);
INSERT INTO question_to_topic VALUES (977, 977, 3);
INSERT INTO question_to_topic VALUES (978, 978, 3);
INSERT INTO question_to_topic VALUES (979, 979, 3);
INSERT INTO question_to_topic VALUES (980, 980, 3);
INSERT INTO question_to_topic VALUES (981, 981, 3);
INSERT INTO question_to_topic VALUES (982, 982, 3);
INSERT INTO question_to_topic VALUES (983, 983, 3);
INSERT INTO question_to_topic VALUES (984, 984, 3);
INSERT INTO question_to_topic VALUES (985, 985, 3);
INSERT INTO question_to_topic VALUES (986, 986, 3);
INSERT INTO question_to_topic VALUES (987, 987, 3);
INSERT INTO question_to_topic VALUES (988, 988, 3);
INSERT INTO question_to_topic VALUES (989, 989, 3);
INSERT INTO question_to_topic VALUES (990, 990, 3);
INSERT INTO question_to_topic VALUES (991, 991, 3);
INSERT INTO question_to_topic VALUES (992, 992, 3);
INSERT INTO question_to_topic VALUES (993, 993, 3);
INSERT INTO question_to_topic VALUES (994, 994, 3);
INSERT INTO question_to_topic VALUES (995, 995, 3);
INSERT INTO question_to_topic VALUES (996, 996, 3);
INSERT INTO question_to_topic VALUES (997, 997, 3);
INSERT INTO question_to_topic VALUES (998, 998, 3);
INSERT INTO question_to_topic VALUES (999, 999, 3);
INSERT INTO question_to_topic VALUES (1000, 1000, 3);
INSERT INTO question_to_topic VALUES (1001, 1001, 3);
INSERT INTO question_to_topic VALUES (1002, 1002, 3);
INSERT INTO question_to_topic VALUES (1003, 1003, 3);
INSERT INTO question_to_topic VALUES (1004, 1004, 3);
INSERT INTO question_to_topic VALUES (1005, 1005, 3);
INSERT INTO question_to_topic VALUES (1006, 1006, 3);
INSERT INTO question_to_topic VALUES (1007, 1007, 3);
INSERT INTO question_to_topic VALUES (1008, 1008, 3);
INSERT INTO question_to_topic VALUES (1009, 1009, 3);
INSERT INTO question_to_topic VALUES (1010, 1010, 3);
INSERT INTO question_to_topic VALUES (1011, 1011, 3);
INSERT INTO question_to_topic VALUES (1012, 1012, 3);
INSERT INTO question_to_topic VALUES (1013, 1013, 3);
INSERT INTO question_to_topic VALUES (1014, 1014, 3);
INSERT INTO question_to_topic VALUES (1015, 1015, 3);
INSERT INTO question_to_topic VALUES (1016, 1016, 3);
INSERT INTO question_to_topic VALUES (1017, 1017, 3);
INSERT INTO question_to_topic VALUES (1018, 1018, 3);
INSERT INTO question_to_topic VALUES (1019, 1019, 3);
INSERT INTO question_to_topic VALUES (1020, 1020, 3);
INSERT INTO question_to_topic VALUES (1021, 1021, 3);
INSERT INTO question_to_topic VALUES (1022, 1022, 3);
INSERT INTO question_to_topic VALUES (1023, 1023, 3);
INSERT INTO question_to_topic VALUES (1024, 1024, 3);
INSERT INTO question_to_topic VALUES (1025, 1025, 3);
INSERT INTO question_to_topic VALUES (1026, 1026, 3);
INSERT INTO question_to_topic VALUES (1027, 1027, 3);
INSERT INTO question_to_topic VALUES (1028, 1028, 3);
INSERT INTO question_to_topic VALUES (1029, 1029, 3);
INSERT INTO question_to_topic VALUES (1030, 1030, 3);
INSERT INTO question_to_topic VALUES (1031, 1031, 3);
INSERT INTO question_to_topic VALUES (1032, 1032, 3);
INSERT INTO question_to_topic VALUES (1033, 1033, 3);
INSERT INTO question_to_topic VALUES (1034, 1034, 3);
INSERT INTO question_to_topic VALUES (1035, 1035, 3);
INSERT INTO question_to_topic VALUES (1036, 1036, 3);
INSERT INTO question_to_topic VALUES (1037, 1037, 3);
INSERT INTO question_to_topic VALUES (1038, 1038, 3);
INSERT INTO question_to_topic VALUES (1039, 1039, 3);
INSERT INTO question_to_topic VALUES (1040, 1040, 3);
INSERT INTO question_to_topic VALUES (1041, 1041, 3);
INSERT INTO question_to_topic VALUES (1042, 1042, 3);
INSERT INTO question_to_topic VALUES (1043, 1043, 3);
INSERT INTO question_to_topic VALUES (1044, 1044, 3);
INSERT INTO question_to_topic VALUES (1045, 1045, 3);
INSERT INTO question_to_topic VALUES (1046, 1046, 3);
INSERT INTO question_to_topic VALUES (1047, 1047, 3);
INSERT INTO question_to_topic VALUES (1048, 1048, 3);
INSERT INTO question_to_topic VALUES (1049, 1049, 3);
INSERT INTO question_to_topic VALUES (1050, 1050, 3);
INSERT INTO question_to_topic VALUES (1051, 1051, 3);
INSERT INTO question_to_topic VALUES (1052, 1052, 3);
INSERT INTO question_to_topic VALUES (1053, 1053, 3);
INSERT INTO question_to_topic VALUES (1054, 1054, 3);
INSERT INTO question_to_topic VALUES (1055, 1055, 3);
INSERT INTO question_to_topic VALUES (1056, 1056, 3);
INSERT INTO question_to_topic VALUES (1057, 1057, 3);
INSERT INTO question_to_topic VALUES (1058, 1058, 3);
INSERT INTO question_to_topic VALUES (1059, 1059, 3);
INSERT INTO question_to_topic VALUES (1060, 1060, 3);
INSERT INTO question_to_topic VALUES (1061, 1061, 3);
INSERT INTO question_to_topic VALUES (1062, 1062, 3);
INSERT INTO question_to_topic VALUES (1063, 1063, 3);
INSERT INTO question_to_topic VALUES (1064, 1064, 3);
INSERT INTO question_to_topic VALUES (1065, 1065, 3);
INSERT INTO question_to_topic VALUES (1066, 1066, 3);
INSERT INTO question_to_topic VALUES (1067, 1067, 3);
INSERT INTO question_to_topic VALUES (1068, 1068, 3);
INSERT INTO question_to_topic VALUES (1069, 1069, 3);
INSERT INTO question_to_topic VALUES (1070, 1070, 3);
INSERT INTO question_to_topic VALUES (1071, 1071, 3);
INSERT INTO question_to_topic VALUES (1072, 1072, 3);
INSERT INTO question_to_topic VALUES (1073, 1073, 3);
INSERT INTO question_to_topic VALUES (1074, 1074, 3);
INSERT INTO question_to_topic VALUES (1075, 1075, 3);
INSERT INTO question_to_topic VALUES (1076, 1076, 3);
INSERT INTO question_to_topic VALUES (1077, 1077, 3);
INSERT INTO question_to_topic VALUES (1078, 1078, 3);
INSERT INTO question_to_topic VALUES (1079, 1079, 3);
INSERT INTO question_to_topic VALUES (1080, 1080, 3);
INSERT INTO question_to_topic VALUES (1081, 1081, 3);
INSERT INTO question_to_topic VALUES (1082, 1082, 3);
INSERT INTO question_to_topic VALUES (1083, 1083, 3);
INSERT INTO question_to_topic VALUES (1084, 1084, 3);
INSERT INTO question_to_topic VALUES (1085, 1085, 3);
INSERT INTO question_to_topic VALUES (1086, 1086, 3);
INSERT INTO question_to_topic VALUES (1087, 1087, 3);
INSERT INTO question_to_topic VALUES (1088, 1088, 3);
INSERT INTO question_to_topic VALUES (1089, 1089, 3);
INSERT INTO question_to_topic VALUES (1090, 1090, 3);
INSERT INTO question_to_topic VALUES (1091, 1091, 3);
INSERT INTO question_to_topic VALUES (1092, 1092, 3);
INSERT INTO question_to_topic VALUES (1093, 1093, 3);
INSERT INTO question_to_topic VALUES (1094, 1094, 3);
INSERT INTO question_to_topic VALUES (1095, 1095, 3);
INSERT INTO question_to_topic VALUES (1096, 1096, 3);
INSERT INTO question_to_topic VALUES (1097, 1097, 3);
INSERT INTO question_to_topic VALUES (1098, 1098, 3);
INSERT INTO question_to_topic VALUES (1099, 1099, 3);
INSERT INTO question_to_topic VALUES (1100, 1100, 3);
INSERT INTO question_to_topic VALUES (1101, 1101, 3);
INSERT INTO question_to_topic VALUES (1102, 1102, 3);
INSERT INTO question_to_topic VALUES (1103, 1103, 3);
INSERT INTO question_to_topic VALUES (1104, 1104, 3);
INSERT INTO question_to_topic VALUES (1105, 1105, 3);
INSERT INTO question_to_topic VALUES (1106, 1106, 3);
INSERT INTO question_to_topic VALUES (1107, 1107, 3);
INSERT INTO question_to_topic VALUES (1108, 1108, 3);
INSERT INTO question_to_topic VALUES (1109, 1109, 3);
INSERT INTO question_to_topic VALUES (1110, 1110, 3);
INSERT INTO question_to_topic VALUES (1111, 1111, 3);
INSERT INTO question_to_topic VALUES (1112, 1112, 3);
INSERT INTO question_to_topic VALUES (1113, 1113, 3);
INSERT INTO question_to_topic VALUES (1114, 1114, 3);
INSERT INTO question_to_topic VALUES (1115, 1115, 3);
INSERT INTO question_to_topic VALUES (1116, 1116, 3);
INSERT INTO question_to_topic VALUES (1117, 1117, 3);
INSERT INTO question_to_topic VALUES (1118, 1118, 3);
INSERT INTO question_to_topic VALUES (1119, 1119, 3);
INSERT INTO question_to_topic VALUES (1120, 1120, 3);
INSERT INTO question_to_topic VALUES (1121, 1121, 3);
INSERT INTO question_to_topic VALUES (1122, 1122, 3);
INSERT INTO question_to_topic VALUES (1123, 1123, 3);
INSERT INTO question_to_topic VALUES (1124, 1124, 3);
INSERT INTO question_to_topic VALUES (1125, 1125, 3);
INSERT INTO question_to_topic VALUES (1126, 1126, 3);
INSERT INTO question_to_topic VALUES (1127, 1127, 3);
INSERT INTO question_to_topic VALUES (1128, 1128, 3);
INSERT INTO question_to_topic VALUES (1129, 1129, 3);
INSERT INTO question_to_topic VALUES (1130, 1130, 3);
INSERT INTO question_to_topic VALUES (1131, 1131, 3);
INSERT INTO question_to_topic VALUES (1132, 1132, 3);
INSERT INTO question_to_topic VALUES (1133, 1133, 3);
INSERT INTO question_to_topic VALUES (1134, 1134, 3);
INSERT INTO question_to_topic VALUES (1135, 1135, 3);
INSERT INTO question_to_topic VALUES (1136, 1136, 3);
INSERT INTO question_to_topic VALUES (1137, 1137, 3);
INSERT INTO question_to_topic VALUES (1138, 1138, 3);
INSERT INTO question_to_topic VALUES (1139, 1139, 3);
INSERT INTO question_to_topic VALUES (1140, 1140, 3);
INSERT INTO question_to_topic VALUES (1141, 1141, 3);
INSERT INTO question_to_topic VALUES (1142, 1142, 3);
INSERT INTO question_to_topic VALUES (1143, 1143, 3);
INSERT INTO question_to_topic VALUES (1144, 1144, 3);
INSERT INTO question_to_topic VALUES (1145, 1145, 3);
INSERT INTO question_to_topic VALUES (1146, 1146, 3);
INSERT INTO question_to_topic VALUES (1147, 1147, 3);
INSERT INTO question_to_topic VALUES (1148, 1148, 3);
INSERT INTO question_to_topic VALUES (1149, 1149, 3);
INSERT INTO question_to_topic VALUES (1150, 1150, 3);
INSERT INTO question_to_topic VALUES (1151, 1151, 3);
INSERT INTO question_to_topic VALUES (1152, 1152, 3);
INSERT INTO question_to_topic VALUES (1153, 1153, 3);
INSERT INTO question_to_topic VALUES (1154, 1154, 3);
INSERT INTO question_to_topic VALUES (1155, 1155, 3);
INSERT INTO question_to_topic VALUES (1156, 1156, 3);
INSERT INTO question_to_topic VALUES (1157, 1157, 3);
INSERT INTO question_to_topic VALUES (1158, 1158, 3);
INSERT INTO question_to_topic VALUES (1159, 1159, 3);
INSERT INTO question_to_topic VALUES (1160, 1160, 3);
INSERT INTO question_to_topic VALUES (1161, 1161, 3);
INSERT INTO question_to_topic VALUES (1162, 1162, 3);
INSERT INTO question_to_topic VALUES (1163, 1163, 3);
INSERT INTO question_to_topic VALUES (1164, 1164, 3);
INSERT INTO question_to_topic VALUES (1165, 1165, 3);
INSERT INTO question_to_topic VALUES (1166, 1166, 3);
INSERT INTO question_to_topic VALUES (1167, 1167, 3);
INSERT INTO question_to_topic VALUES (1168, 1168, 3);
INSERT INTO question_to_topic VALUES (1169, 1169, 3);
INSERT INTO question_to_topic VALUES (1170, 1170, 3);
INSERT INTO question_to_topic VALUES (1171, 1171, 3);
INSERT INTO question_to_topic VALUES (1172, 1172, 3);
INSERT INTO question_to_topic VALUES (1173, 1173, 3);
INSERT INTO question_to_topic VALUES (1174, 1174, 3);
INSERT INTO question_to_topic VALUES (1175, 1175, 3);
INSERT INTO question_to_topic VALUES (1176, 1176, 3);
INSERT INTO question_to_topic VALUES (1177, 1177, 3);
INSERT INTO question_to_topic VALUES (1178, 1178, 3);
INSERT INTO question_to_topic VALUES (1179, 1179, 3);
INSERT INTO question_to_topic VALUES (1180, 1180, 3);
INSERT INTO question_to_topic VALUES (1181, 1181, 3);
INSERT INTO question_to_topic VALUES (1182, 1182, 3);
INSERT INTO question_to_topic VALUES (1183, 1183, 3);
INSERT INTO question_to_topic VALUES (1184, 1184, 3);
INSERT INTO question_to_topic VALUES (1185, 1185, 3);
INSERT INTO question_to_topic VALUES (1186, 1186, 3);
INSERT INTO question_to_topic VALUES (1187, 1187, 3);
INSERT INTO question_to_topic VALUES (1188, 1188, 3);
INSERT INTO question_to_topic VALUES (1189, 1189, 3);
INSERT INTO question_to_topic VALUES (1190, 1190, 3);
INSERT INTO question_to_topic VALUES (1191, 1191, 3);
INSERT INTO question_to_topic VALUES (1192, 1192, 3);
INSERT INTO question_to_topic VALUES (1193, 1193, 3);
INSERT INTO question_to_topic VALUES (1194, 1194, 3);
INSERT INTO question_to_topic VALUES (1195, 1195, 3);
INSERT INTO question_to_topic VALUES (1196, 1196, 3);
INSERT INTO question_to_topic VALUES (1197, 1197, 3);
INSERT INTO question_to_topic VALUES (1198, 1198, 3);
INSERT INTO question_to_topic VALUES (1199, 1199, 3);
INSERT INTO question_to_topic VALUES (1200, 1200, 3);
INSERT INTO question_to_topic VALUES (1201, 1201, 3);
INSERT INTO question_to_topic VALUES (1202, 1202, 3);
INSERT INTO question_to_topic VALUES (1203, 1203, 3);
INSERT INTO question_to_topic VALUES (1204, 1204, 3);
INSERT INTO question_to_topic VALUES (1205, 1205, 3);
INSERT INTO question_to_topic VALUES (1206, 1206, 3);
INSERT INTO question_to_topic VALUES (1207, 1207, 3);
INSERT INTO question_to_topic VALUES (1208, 1208, 3);
INSERT INTO question_to_topic VALUES (1209, 1209, 3);
INSERT INTO question_to_topic VALUES (1210, 1210, 3);
INSERT INTO question_to_topic VALUES (1211, 1211, 3);
INSERT INTO question_to_topic VALUES (1212, 1212, 3);
INSERT INTO question_to_topic VALUES (1213, 1213, 3);
INSERT INTO question_to_topic VALUES (1214, 1214, 3);
INSERT INTO question_to_topic VALUES (1215, 1215, 3);
INSERT INTO question_to_topic VALUES (1216, 1216, 3);
INSERT INTO question_to_topic VALUES (1217, 1217, 3);
INSERT INTO question_to_topic VALUES (1218, 1218, 3);
INSERT INTO question_to_topic VALUES (1219, 1219, 3);
INSERT INTO question_to_topic VALUES (1220, 1220, 3);
INSERT INTO question_to_topic VALUES (1221, 1221, 3);
INSERT INTO question_to_topic VALUES (1222, 1222, 3);
INSERT INTO question_to_topic VALUES (1223, 1223, 3);
INSERT INTO question_to_topic VALUES (1224, 1224, 3);
INSERT INTO question_to_topic VALUES (1225, 1225, 3);
INSERT INTO question_to_topic VALUES (1226, 1226, 3);
INSERT INTO question_to_topic VALUES (1227, 1227, 3);
INSERT INTO question_to_topic VALUES (1228, 1228, 3);
INSERT INTO question_to_topic VALUES (1229, 1229, 3);
INSERT INTO question_to_topic VALUES (1230, 1230, 3);
INSERT INTO question_to_topic VALUES (1231, 1231, 3);
INSERT INTO question_to_topic VALUES (1232, 1232, 3);
INSERT INTO question_to_topic VALUES (1233, 1233, 3);
INSERT INTO question_to_topic VALUES (1234, 1234, 3);
INSERT INTO question_to_topic VALUES (1235, 1235, 3);
INSERT INTO question_to_topic VALUES (1236, 1236, 3);
INSERT INTO question_to_topic VALUES (1237, 1237, 3);
INSERT INTO question_to_topic VALUES (1238, 1238, 3);
INSERT INTO question_to_topic VALUES (1239, 1239, 3);
INSERT INTO question_to_topic VALUES (1240, 1240, 3);
INSERT INTO question_to_topic VALUES (1241, 1241, 3);
INSERT INTO question_to_topic VALUES (1242, 1242, 3);
INSERT INTO question_to_topic VALUES (1243, 1243, 3);
INSERT INTO question_to_topic VALUES (1244, 1244, 3);
INSERT INTO question_to_topic VALUES (1245, 1245, 3);
INSERT INTO question_to_topic VALUES (1246, 1246, 3);
INSERT INTO question_to_topic VALUES (1247, 1247, 3);
INSERT INTO question_to_topic VALUES (1248, 1248, 3);
INSERT INTO question_to_topic VALUES (1249, 1249, 3);
INSERT INTO question_to_topic VALUES (1250, 1250, 3);
INSERT INTO question_to_topic VALUES (1251, 1251, 3);
INSERT INTO question_to_topic VALUES (1252, 1252, 3);
INSERT INTO question_to_topic VALUES (1253, 1253, 3);
INSERT INTO question_to_topic VALUES (1254, 1254, 3);
INSERT INTO question_to_topic VALUES (1255, 1255, 3);
INSERT INTO question_to_topic VALUES (1256, 1256, 3);
INSERT INTO question_to_topic VALUES (1257, 1257, 3);
INSERT INTO question_to_topic VALUES (1258, 1258, 3);
INSERT INTO question_to_topic VALUES (1259, 1259, 3);
INSERT INTO question_to_topic VALUES (1260, 1260, 3);
INSERT INTO question_to_topic VALUES (1261, 1261, 3);
INSERT INTO question_to_topic VALUES (1262, 1262, 3);
INSERT INTO question_to_topic VALUES (1263, 1263, 3);
INSERT INTO question_to_topic VALUES (1264, 1264, 3);
INSERT INTO question_to_topic VALUES (1265, 1265, 3);
INSERT INTO question_to_topic VALUES (1266, 1266, 3);
INSERT INTO question_to_topic VALUES (1267, 1267, 3);
INSERT INTO question_to_topic VALUES (1268, 1268, 3);
INSERT INTO question_to_topic VALUES (1269, 1269, 3);
INSERT INTO question_to_topic VALUES (1270, 1270, 3);
INSERT INTO question_to_topic VALUES (1271, 1271, 3);
INSERT INTO question_to_topic VALUES (1272, 1272, 3);
INSERT INTO question_to_topic VALUES (1273, 1273, 3);
INSERT INTO question_to_topic VALUES (1274, 1274, 3);
INSERT INTO question_to_topic VALUES (1275, 1275, 3);
INSERT INTO question_to_topic VALUES (1276, 1276, 3);
INSERT INTO question_to_topic VALUES (1277, 1277, 3);
INSERT INTO question_to_topic VALUES (1278, 1278, 3);
INSERT INTO question_to_topic VALUES (1279, 1279, 3);
INSERT INTO question_to_topic VALUES (1280, 1280, 3);
INSERT INTO question_to_topic VALUES (1281, 1281, 3);
INSERT INTO question_to_topic VALUES (1282, 1282, 3);
INSERT INTO question_to_topic VALUES (1283, 1283, 3);
INSERT INTO question_to_topic VALUES (1284, 1284, 3);
INSERT INTO question_to_topic VALUES (1285, 1285, 3);
INSERT INTO question_to_topic VALUES (1286, 1286, 3);
INSERT INTO question_to_topic VALUES (1287, 1287, 3);
INSERT INTO question_to_topic VALUES (1288, 1288, 3);
INSERT INTO question_to_topic VALUES (1289, 1289, 3);
INSERT INTO question_to_topic VALUES (1290, 1290, 3);
INSERT INTO question_to_topic VALUES (1291, 1291, 3);
INSERT INTO question_to_topic VALUES (1292, 1292, 3);
INSERT INTO question_to_topic VALUES (1293, 1293, 3);
INSERT INTO question_to_topic VALUES (1294, 1294, 3);
INSERT INTO question_to_topic VALUES (1295, 1295, 3);
INSERT INTO question_to_topic VALUES (1296, 1296, 3);
INSERT INTO question_to_topic VALUES (1297, 1297, 3);
INSERT INTO question_to_topic VALUES (1298, 1298, 3);
INSERT INTO question_to_topic VALUES (1299, 1299, 3);
INSERT INTO question_to_topic VALUES (1300, 1300, 3);
INSERT INTO question_to_topic VALUES (1301, 1301, 3);
INSERT INTO question_to_topic VALUES (1302, 1302, 3);
INSERT INTO question_to_topic VALUES (1303, 1303, 3);
INSERT INTO question_to_topic VALUES (1304, 1304, 3);
INSERT INTO question_to_topic VALUES (1305, 1305, 3);
INSERT INTO question_to_topic VALUES (1306, 1306, 3);
INSERT INTO question_to_topic VALUES (1307, 1307, 3);
INSERT INTO question_to_topic VALUES (1308, 1308, 3);
INSERT INTO question_to_topic VALUES (1309, 1309, 3);
INSERT INTO question_to_topic VALUES (1310, 1310, 3);
INSERT INTO question_to_topic VALUES (1311, 1311, 3);
INSERT INTO question_to_topic VALUES (1312, 1312, 3);
INSERT INTO question_to_topic VALUES (1313, 1313, 3);
INSERT INTO question_to_topic VALUES (1314, 1314, 3);
INSERT INTO question_to_topic VALUES (1315, 1315, 3);
INSERT INTO question_to_topic VALUES (1316, 1316, 3);
INSERT INTO question_to_topic VALUES (1317, 1317, 3);
INSERT INTO question_to_topic VALUES (1318, 1318, 3);
INSERT INTO question_to_topic VALUES (1319, 1319, 3);
INSERT INTO question_to_topic VALUES (1320, 1320, 3);
INSERT INTO question_to_topic VALUES (1321, 1321, 3);
INSERT INTO question_to_topic VALUES (1322, 1322, 3);
INSERT INTO question_to_topic VALUES (1323, 1323, 3);
INSERT INTO question_to_topic VALUES (1324, 1324, 3);
INSERT INTO question_to_topic VALUES (1325, 1325, 3);
INSERT INTO question_to_topic VALUES (1326, 1326, 3);
INSERT INTO question_to_topic VALUES (1327, 1327, 3);
INSERT INTO question_to_topic VALUES (1328, 1328, 3);
INSERT INTO question_to_topic VALUES (1329, 1329, 3);
INSERT INTO question_to_topic VALUES (1330, 1330, 3);
INSERT INTO question_to_topic VALUES (1331, 1331, 3);
INSERT INTO question_to_topic VALUES (1332, 1332, 3);
INSERT INTO question_to_topic VALUES (1333, 1333, 3);
INSERT INTO question_to_topic VALUES (1334, 1334, 3);
INSERT INTO question_to_topic VALUES (1335, 1335, 3);
INSERT INTO question_to_topic VALUES (1336, 1336, 3);
INSERT INTO question_to_topic VALUES (1337, 1337, 3);
INSERT INTO question_to_topic VALUES (1338, 1338, 3);
INSERT INTO question_to_topic VALUES (1339, 1339, 3);
INSERT INTO question_to_topic VALUES (1340, 1340, 3);
INSERT INTO question_to_topic VALUES (1341, 1341, 3);
INSERT INTO question_to_topic VALUES (1342, 1342, 3);
INSERT INTO question_to_topic VALUES (1343, 1343, 3);
INSERT INTO question_to_topic VALUES (1344, 1344, 3);
INSERT INTO question_to_topic VALUES (1345, 1345, 3);
INSERT INTO question_to_topic VALUES (1346, 1346, 3);
INSERT INTO question_to_topic VALUES (1347, 1347, 3);
INSERT INTO question_to_topic VALUES (1348, 1348, 3);
INSERT INTO question_to_topic VALUES (1349, 1349, 3);
INSERT INTO question_to_topic VALUES (1350, 1350, 3);
INSERT INTO question_to_topic VALUES (1351, 1351, 3);
INSERT INTO question_to_topic VALUES (1352, 1352, 3);
INSERT INTO question_to_topic VALUES (1353, 1353, 3);
INSERT INTO question_to_topic VALUES (1354, 1354, 3);
INSERT INTO question_to_topic VALUES (1355, 1355, 3);
INSERT INTO question_to_topic VALUES (1356, 1356, 3);
INSERT INTO question_to_topic VALUES (1357, 1357, 3);
INSERT INTO question_to_topic VALUES (1358, 1358, 3);
INSERT INTO question_to_topic VALUES (1359, 1359, 3);
INSERT INTO question_to_topic VALUES (1360, 1360, 3);
INSERT INTO question_to_topic VALUES (1361, 1361, 3);
INSERT INTO question_to_topic VALUES (1362, 1362, 3);
INSERT INTO question_to_topic VALUES (1363, 1363, 3);
INSERT INTO question_to_topic VALUES (1364, 1364, 3);
INSERT INTO question_to_topic VALUES (1365, 1365, 3);
INSERT INTO question_to_topic VALUES (1366, 1366, 3);
INSERT INTO question_to_topic VALUES (1367, 1367, 3);
INSERT INTO question_to_topic VALUES (1368, 1368, 3);
INSERT INTO question_to_topic VALUES (1369, 1369, 3);
INSERT INTO question_to_topic VALUES (1370, 1370, 3);
INSERT INTO question_to_topic VALUES (1371, 1371, 3);
INSERT INTO question_to_topic VALUES (1372, 1372, 3);
INSERT INTO question_to_topic VALUES (1373, 1373, 3);
INSERT INTO question_to_topic VALUES (1374, 1374, 3);
INSERT INTO question_to_topic VALUES (1375, 1375, 3);
INSERT INTO question_to_topic VALUES (1376, 1376, 3);
INSERT INTO question_to_topic VALUES (1377, 1377, 3);
INSERT INTO question_to_topic VALUES (1378, 1378, 3);
INSERT INTO question_to_topic VALUES (1379, 1379, 3);
INSERT INTO question_to_topic VALUES (1380, 1380, 3);
INSERT INTO question_to_topic VALUES (1381, 1381, 3);
INSERT INTO question_to_topic VALUES (1382, 1382, 3);
INSERT INTO question_to_topic VALUES (1383, 1383, 3);
INSERT INTO question_to_topic VALUES (1384, 1384, 3);
INSERT INTO question_to_topic VALUES (1385, 1385, 3);
INSERT INTO question_to_topic VALUES (1386, 1386, 3);
INSERT INTO question_to_topic VALUES (1387, 1387, 3);
INSERT INTO question_to_topic VALUES (1388, 1388, 3);
INSERT INTO question_to_topic VALUES (1389, 1389, 3);
INSERT INTO question_to_topic VALUES (1390, 1390, 3);
INSERT INTO question_to_topic VALUES (1391, 1391, 3);
INSERT INTO question_to_topic VALUES (1392, 1392, 3);
INSERT INTO question_to_topic VALUES (1393, 1393, 3);
INSERT INTO question_to_topic VALUES (1394, 1394, 3);
INSERT INTO question_to_topic VALUES (1395, 1395, 3);
INSERT INTO question_to_topic VALUES (1396, 1396, 3);
INSERT INTO question_to_topic VALUES (1397, 1397, 3);
INSERT INTO question_to_topic VALUES (1398, 1398, 3);
INSERT INTO question_to_topic VALUES (1399, 1399, 3);
INSERT INTO question_to_topic VALUES (1400, 1400, 3);
INSERT INTO question_to_topic VALUES (1401, 1401, 3);
INSERT INTO question_to_topic VALUES (1402, 1402, 3);
INSERT INTO question_to_topic VALUES (1403, 1403, 3);
INSERT INTO question_to_topic VALUES (1404, 1404, 3);
INSERT INTO question_to_topic VALUES (1405, 1405, 3);
INSERT INTO question_to_topic VALUES (1406, 1406, 3);
INSERT INTO question_to_topic VALUES (1407, 1407, 3);
INSERT INTO question_to_topic VALUES (1408, 1408, 3);
INSERT INTO question_to_topic VALUES (1409, 1409, 3);
INSERT INTO question_to_topic VALUES (1410, 1410, 3);
INSERT INTO question_to_topic VALUES (1411, 1411, 3);
INSERT INTO question_to_topic VALUES (1412, 1412, 3);
INSERT INTO question_to_topic VALUES (1413, 1413, 3);
INSERT INTO question_to_topic VALUES (1414, 1414, 3);
INSERT INTO question_to_topic VALUES (1415, 1415, 3);
INSERT INTO question_to_topic VALUES (1416, 1416, 3);
INSERT INTO question_to_topic VALUES (1417, 1417, 3);
INSERT INTO question_to_topic VALUES (1418, 1418, 3);
INSERT INTO question_to_topic VALUES (1419, 1419, 3);
INSERT INTO question_to_topic VALUES (1420, 1420, 3);
INSERT INTO question_to_topic VALUES (1421, 1421, 3);
INSERT INTO question_to_topic VALUES (1422, 1422, 3);
INSERT INTO question_to_topic VALUES (1423, 1423, 3);
INSERT INTO question_to_topic VALUES (1424, 1424, 3);
INSERT INTO question_to_topic VALUES (1425, 1425, 3);
INSERT INTO question_to_topic VALUES (1426, 1426, 3);
INSERT INTO question_to_topic VALUES (1427, 1427, 3);
INSERT INTO question_to_topic VALUES (1428, 1428, 3);
INSERT INTO question_to_topic VALUES (1429, 1429, 3);
INSERT INTO question_to_topic VALUES (1430, 1430, 3);
INSERT INTO question_to_topic VALUES (1431, 1431, 3);
INSERT INTO question_to_topic VALUES (1432, 1432, 3);
INSERT INTO question_to_topic VALUES (1433, 1433, 3);
INSERT INTO question_to_topic VALUES (1434, 1434, 3);
INSERT INTO question_to_topic VALUES (1435, 1435, 3);
INSERT INTO question_to_topic VALUES (1436, 1436, 3);
INSERT INTO question_to_topic VALUES (1437, 1437, 3);
INSERT INTO question_to_topic VALUES (1438, 1438, 3);
INSERT INTO question_to_topic VALUES (1439, 1439, 3);
INSERT INTO question_to_topic VALUES (1440, 1440, 3);
INSERT INTO question_to_topic VALUES (1441, 1441, 3);
INSERT INTO question_to_topic VALUES (1442, 1442, 3);
INSERT INTO question_to_topic VALUES (1443, 1443, 3);
INSERT INTO question_to_topic VALUES (1444, 1444, 3);
INSERT INTO question_to_topic VALUES (1445, 1445, 3);
INSERT INTO question_to_topic VALUES (1446, 1446, 3);
INSERT INTO question_to_topic VALUES (1447, 1447, 3);
INSERT INTO question_to_topic VALUES (1448, 1448, 3);
INSERT INTO question_to_topic VALUES (1449, 1449, 3);
INSERT INTO question_to_topic VALUES (1450, 1450, 3);
INSERT INTO question_to_topic VALUES (1451, 1451, 3);
INSERT INTO question_to_topic VALUES (1452, 1452, 3);
INSERT INTO question_to_topic VALUES (1453, 1453, 3);
INSERT INTO question_to_topic VALUES (1454, 1454, 3);
INSERT INTO question_to_topic VALUES (1455, 1455, 3);
INSERT INTO question_to_topic VALUES (1456, 1456, 3);
INSERT INTO question_to_topic VALUES (1457, 1457, 3);
INSERT INTO question_to_topic VALUES (1458, 1458, 3);
INSERT INTO question_to_topic VALUES (1459, 1459, 3);
INSERT INTO question_to_topic VALUES (1460, 1460, 3);
INSERT INTO question_to_topic VALUES (1461, 1461, 3);
INSERT INTO question_to_topic VALUES (1462, 1462, 3);
INSERT INTO question_to_topic VALUES (1463, 1463, 3);
INSERT INTO question_to_topic VALUES (1464, 1464, 3);
INSERT INTO question_to_topic VALUES (1465, 1465, 3);
INSERT INTO question_to_topic VALUES (1466, 1466, 3);
INSERT INTO question_to_topic VALUES (1467, 1467, 3);
INSERT INTO question_to_topic VALUES (1468, 1468, 3);
INSERT INTO question_to_topic VALUES (1469, 1469, 3);
INSERT INTO question_to_topic VALUES (1470, 1470, 3);
INSERT INTO question_to_topic VALUES (1471, 1471, 3);
INSERT INTO question_to_topic VALUES (1472, 1472, 3);
INSERT INTO question_to_topic VALUES (1473, 1473, 3);
INSERT INTO question_to_topic VALUES (1474, 1474, 3);
INSERT INTO question_to_topic VALUES (1475, 1475, 3);
INSERT INTO question_to_topic VALUES (1476, 1476, 3);
INSERT INTO question_to_topic VALUES (1477, 1477, 3);
INSERT INTO question_to_topic VALUES (1478, 1478, 3);
INSERT INTO question_to_topic VALUES (1479, 1479, 3);
INSERT INTO question_to_topic VALUES (1480, 1480, 3);
INSERT INTO question_to_topic VALUES (1481, 1481, 3);
INSERT INTO question_to_topic VALUES (1482, 1482, 3);
INSERT INTO question_to_topic VALUES (1483, 1483, 3);
INSERT INTO question_to_topic VALUES (1484, 1484, 3);
INSERT INTO question_to_topic VALUES (1485, 1485, 3);
INSERT INTO question_to_topic VALUES (1486, 1486, 3);
INSERT INTO question_to_topic VALUES (1487, 1487, 3);
INSERT INTO question_to_topic VALUES (1488, 1488, 3);
INSERT INTO question_to_topic VALUES (1489, 1489, 3);
INSERT INTO question_to_topic VALUES (1490, 1490, 3);
INSERT INTO question_to_topic VALUES (1491, 1491, 3);
INSERT INTO question_to_topic VALUES (1492, 1492, 3);
INSERT INTO question_to_topic VALUES (1493, 1493, 3);
INSERT INTO question_to_topic VALUES (1494, 1494, 3);
INSERT INTO question_to_topic VALUES (1495, 1495, 3);
INSERT INTO question_to_topic VALUES (1496, 1496, 3);
INSERT INTO question_to_topic VALUES (1497, 1497, 3);
INSERT INTO question_to_topic VALUES (1498, 1498, 3);
INSERT INTO question_to_topic VALUES (1499, 1499, 3);

INSERT INTO question_to_topic VALUES (1500, 1500, 3);
INSERT INTO question_to_topic VALUES (1501, 1501, 3);
INSERT INTO question_to_topic VALUES (1502, 1502, 3);
INSERT INTO question_to_topic VALUES (1503, 1503, 3);
INSERT INTO question_to_topic VALUES (1504, 1504, 3);
INSERT INTO question_to_topic VALUES (1505, 1505, 3);
INSERT INTO question_to_topic VALUES (1506, 1506, 3);
INSERT INTO question_to_topic VALUES (1507, 1507, 3);
INSERT INTO question_to_topic VALUES (1508, 1508, 3);
INSERT INTO question_to_topic VALUES (1509, 1509, 3);
INSERT INTO question_to_topic VALUES (1510, 1510, 3);
INSERT INTO question_to_topic VALUES (1511, 1511, 3);
INSERT INTO question_to_topic VALUES (1512, 1512, 3);
INSERT INTO question_to_topic VALUES (1513, 1513, 3);
INSERT INTO question_to_topic VALUES (1514, 1514, 3);
INSERT INTO question_to_topic VALUES (1515, 1515, 3);
INSERT INTO question_to_topic VALUES (1516, 1516, 3);
INSERT INTO question_to_topic VALUES (1517, 1517, 3);
INSERT INTO question_to_topic VALUES (1518, 1518, 3);
INSERT INTO question_to_topic VALUES (1519, 1519, 3);
INSERT INTO question_to_topic VALUES (1520, 1520, 3);
INSERT INTO question_to_topic VALUES (1521, 1521, 3);
INSERT INTO question_to_topic VALUES (1522, 1522, 3);
INSERT INTO question_to_topic VALUES (1523, 1523, 3);
INSERT INTO question_to_topic VALUES (1524, 1524, 3);
INSERT INTO question_to_topic VALUES (1525, 1525, 3);
INSERT INTO question_to_topic VALUES (1526, 1526, 3);
INSERT INTO question_to_topic VALUES (1527, 1527, 3);
INSERT INTO question_to_topic VALUES (1528, 1528, 3);
INSERT INTO question_to_topic VALUES (1529, 1529, 3);
INSERT INTO question_to_topic VALUES (1530, 1530, 3);
INSERT INTO question_to_topic VALUES (1531, 1531, 3);
INSERT INTO question_to_topic VALUES (1532, 1532, 3);
INSERT INTO question_to_topic VALUES (1533, 1533, 3);
INSERT INTO question_to_topic VALUES (1534, 1534, 3);
INSERT INTO question_to_topic VALUES (1535, 1535, 3);
INSERT INTO question_to_topic VALUES (1536, 1536, 3);
INSERT INTO question_to_topic VALUES (1537, 1537, 3);
INSERT INTO question_to_topic VALUES (1538, 1538, 3);
INSERT INTO question_to_topic VALUES (1539, 1539, 3);
INSERT INTO question_to_topic VALUES (1540, 1540, 3);
INSERT INTO question_to_topic VALUES (1541, 1541, 3);
INSERT INTO question_to_topic VALUES (1542, 1542, 3);
INSERT INTO question_to_topic VALUES (1543, 1543, 3);
INSERT INTO question_to_topic VALUES (1544, 1544, 3);
INSERT INTO question_to_topic VALUES (1545, 1545, 3);
INSERT INTO question_to_topic VALUES (1546, 1546, 3);
INSERT INTO question_to_topic VALUES (1547, 1547, 3);
INSERT INTO question_to_topic VALUES (1548, 1548, 3);
INSERT INTO question_to_topic VALUES (1549, 1549, 3);
INSERT INTO question_to_topic VALUES (1550, 1550, 3);
INSERT INTO question_to_topic VALUES (1551, 1551, 3);
INSERT INTO question_to_topic VALUES (1552, 1552, 3);
INSERT INTO question_to_topic VALUES (1553, 1553, 3);
INSERT INTO question_to_topic VALUES (1554, 1554, 3);
INSERT INTO question_to_topic VALUES (1555, 1555, 3);
INSERT INTO question_to_topic VALUES (1556, 1556, 3);
INSERT INTO question_to_topic VALUES (1557, 1557, 3);
INSERT INTO question_to_topic VALUES (1558, 1558, 3);
INSERT INTO question_to_topic VALUES (1559, 1559, 3);
INSERT INTO question_to_topic VALUES (1560, 1560, 3);
INSERT INTO question_to_topic VALUES (1561, 1561, 3);
INSERT INTO question_to_topic VALUES (1562, 1562, 3);
INSERT INTO question_to_topic VALUES (1563, 1563, 3);
INSERT INTO question_to_topic VALUES (1564, 1564, 3);
INSERT INTO question_to_topic VALUES (1565, 1565, 3);
INSERT INTO question_to_topic VALUES (1566, 1566, 3);
INSERT INTO question_to_topic VALUES (1567, 1567, 3);
INSERT INTO question_to_topic VALUES (1568, 1568, 3);
INSERT INTO question_to_topic VALUES (1569, 1569, 3);
INSERT INTO question_to_topic VALUES (1570, 1570, 3);
INSERT INTO question_to_topic VALUES (1571, 1571, 3);
INSERT INTO question_to_topic VALUES (1572, 1572, 3);
INSERT INTO question_to_topic VALUES (1573, 1573, 3);
INSERT INTO question_to_topic VALUES (1574, 1574, 3);
INSERT INTO question_to_topic VALUES (1575, 1575, 3);
INSERT INTO question_to_topic VALUES (1576, 1576, 3);
INSERT INTO question_to_topic VALUES (1577, 1577, 3);
INSERT INTO question_to_topic VALUES (1578, 1578, 3);
INSERT INTO question_to_topic VALUES (1579, 1579, 3);
INSERT INTO question_to_topic VALUES (1580, 1580, 3);
INSERT INTO question_to_topic VALUES (1581, 1581, 3);
INSERT INTO question_to_topic VALUES (1582, 1582, 3);
INSERT INTO question_to_topic VALUES (1583, 1583, 3);
INSERT INTO question_to_topic VALUES (1584, 1584, 3);
INSERT INTO question_to_topic VALUES (1585, 1585, 3);
INSERT INTO question_to_topic VALUES (1586, 1586, 3);
INSERT INTO question_to_topic VALUES (1587, 1587, 3);
INSERT INTO question_to_topic VALUES (1588, 1588, 3);
INSERT INTO question_to_topic VALUES (1589, 1589, 3);
INSERT INTO question_to_topic VALUES (1590, 1590, 3);
INSERT INTO question_to_topic VALUES (1591, 1591, 3);
INSERT INTO question_to_topic VALUES (1592, 1592, 3);
INSERT INTO question_to_topic VALUES (1593, 1593, 3);
INSERT INTO question_to_topic VALUES (1594, 1594, 3);
INSERT INTO question_to_topic VALUES (1595, 1595, 3);
INSERT INTO question_to_topic VALUES (1596, 1596, 3);
INSERT INTO question_to_topic VALUES (1597, 1597, 3);
INSERT INTO question_to_topic VALUES (1598, 1598, 3);
INSERT INTO question_to_topic VALUES (1599, 1599, 3);
INSERT INTO question_to_topic VALUES (1600, 1600, 3);
INSERT INTO question_to_topic VALUES (1601, 1601, 3);
INSERT INTO question_to_topic VALUES (1602, 1602, 3);
INSERT INTO question_to_topic VALUES (1603, 1603, 3);
INSERT INTO question_to_topic VALUES (1604, 1604, 3);
INSERT INTO question_to_topic VALUES (1605, 1605, 3);
INSERT INTO question_to_topic VALUES (1606, 1606, 3);
INSERT INTO question_to_topic VALUES (1607, 1607, 3);
INSERT INTO question_to_topic VALUES (1608, 1608, 3);
INSERT INTO question_to_topic VALUES (1609, 1609, 3);
INSERT INTO question_to_topic VALUES (1610, 1610, 3);
INSERT INTO question_to_topic VALUES (1611, 1611, 3);
INSERT INTO question_to_topic VALUES (1612, 1612, 3);
INSERT INTO question_to_topic VALUES (1613, 1613, 3);
INSERT INTO question_to_topic VALUES (1614, 1614, 3);
INSERT INTO question_to_topic VALUES (1615, 1615, 3);
INSERT INTO question_to_topic VALUES (1616, 1616, 3);
INSERT INTO question_to_topic VALUES (1617, 1617, 3);
INSERT INTO question_to_topic VALUES (1618, 1618, 3);
INSERT INTO question_to_topic VALUES (1619, 1619, 3);
INSERT INTO question_to_topic VALUES (1620, 1620, 3);
INSERT INTO question_to_topic VALUES (1621, 1621, 3);
INSERT INTO question_to_topic VALUES (1622, 1622, 3);
INSERT INTO question_to_topic VALUES (1623, 1623, 3);
INSERT INTO question_to_topic VALUES (1624, 1624, 3);
INSERT INTO question_to_topic VALUES (1625, 1625, 3);
INSERT INTO question_to_topic VALUES (1626, 1626, 3);
INSERT INTO question_to_topic VALUES (1627, 1627, 3);
INSERT INTO question_to_topic VALUES (1628, 1628, 3);
INSERT INTO question_to_topic VALUES (1629, 1629, 3);
INSERT INTO question_to_topic VALUES (1630, 1630, 3);
INSERT INTO question_to_topic VALUES (1631, 1631, 3);
INSERT INTO question_to_topic VALUES (1632, 1632, 3);
INSERT INTO question_to_topic VALUES (1633, 1633, 3);
INSERT INTO question_to_topic VALUES (1634, 1634, 3);
INSERT INTO question_to_topic VALUES (1635, 1635, 3);
INSERT INTO question_to_topic VALUES (1636, 1636, 3);
INSERT INTO question_to_topic VALUES (1637, 1637, 3);
INSERT INTO question_to_topic VALUES (1638, 1638, 3);
INSERT INTO question_to_topic VALUES (1639, 1639, 3);
INSERT INTO question_to_topic VALUES (1640, 1640, 3);
INSERT INTO question_to_topic VALUES (1641, 1641, 3);


INSERT INTO question_to_category VALUES (1, 1, 5);
INSERT INTO question_to_category VALUES (2, 2, 5);
INSERT INTO question_to_category VALUES (3, 3, 5);
INSERT INTO question_to_category VALUES (4, 4, 5);
INSERT INTO question_to_category VALUES (5, 5, 5);
INSERT INTO question_to_category VALUES (6, 6, 5);
INSERT INTO question_to_category VALUES (7, 7, 5);
INSERT INTO question_to_category VALUES (8, 8, 5);
INSERT INTO question_to_category VALUES (9, 9, 5);
INSERT INTO question_to_category VALUES (10, 10, 5);
INSERT INTO question_to_category VALUES (11, 11, 5);
INSERT INTO question_to_category VALUES (12, 12, 6);
INSERT INTO question_to_category VALUES (13, 13, 6);
INSERT INTO question_to_category VALUES (14, 14, 6);
INSERT INTO question_to_category VALUES (15, 15, 6);
INSERT INTO question_to_category VALUES (16, 16, 6);
INSERT INTO question_to_category VALUES (17, 17, 6);
INSERT INTO question_to_category VALUES (18, 18, 6);
INSERT INTO question_to_category VALUES (19, 19, 6);
INSERT INTO question_to_category VALUES (20, 20, 6);
INSERT INTO question_to_category VALUES (21, 21, 6);
INSERT INTO question_to_category VALUES (22, 22, 6);
INSERT INTO question_to_category VALUES (23, 23, 6);
INSERT INTO question_to_category VALUES (24, 24, 7);
INSERT INTO question_to_category VALUES (25, 25, 7);
INSERT INTO question_to_category VALUES (26, 26, 7);
INSERT INTO question_to_category VALUES (27, 27, 7);
INSERT INTO question_to_category VALUES (28, 28, 7);
INSERT INTO question_to_category VALUES (29, 29, 7);
INSERT INTO question_to_category VALUES (30, 30, 7);
INSERT INTO question_to_category VALUES (31, 31, 7);
INSERT INTO question_to_category VALUES (32, 32, 7);
INSERT INTO question_to_category VALUES (33, 33, 7);
INSERT INTO question_to_category VALUES (34, 34, 7);
INSERT INTO question_to_category VALUES (35, 35, 8);
INSERT INTO question_to_category VALUES (36, 36, 8);
INSERT INTO question_to_category VALUES (37, 37, 8);
INSERT INTO question_to_category VALUES (38, 38, 8);
INSERT INTO question_to_category VALUES (39, 39, 8);
INSERT INTO question_to_category VALUES (40, 40, 8);
INSERT INTO question_to_category VALUES (41, 41, 8);
INSERT INTO question_to_category VALUES (42, 42, 8);
INSERT INTO question_to_category VALUES (43, 43, 8);
INSERT INTO question_to_category VALUES (44, 44, 8);
INSERT INTO question_to_category VALUES (45, 45, 8);
INSERT INTO question_to_category VALUES (46, 46, 9);
INSERT INTO question_to_category VALUES (47, 47, 9);
INSERT INTO question_to_category VALUES (48, 48, 9);
INSERT INTO question_to_category VALUES (49, 49, 9);
INSERT INTO question_to_category VALUES (50, 50, 9);
INSERT INTO question_to_category VALUES (51, 51, 9);
INSERT INTO question_to_category VALUES (52, 52, 9);
INSERT INTO question_to_category VALUES (53, 53, 9);
INSERT INTO question_to_category VALUES (54, 54, 9);
INSERT INTO question_to_category VALUES (55, 55, 9);
INSERT INTO question_to_category VALUES (56, 56, 9);
INSERT INTO question_to_category VALUES (57, 57, 10);
INSERT INTO question_to_category VALUES (58, 58, 10);
INSERT INTO question_to_category VALUES (59, 59, 10);
INSERT INTO question_to_category VALUES (60, 60, 10);
INSERT INTO question_to_category VALUES (61, 61, 10);
INSERT INTO question_to_category VALUES (62, 62, 10);
INSERT INTO question_to_category VALUES (63, 63, 10);
INSERT INTO question_to_category VALUES (64, 64, 10);
INSERT INTO question_to_category VALUES (65, 65, 10);
INSERT INTO question_to_category VALUES (66, 66, 10);
INSERT INTO question_to_category VALUES (67, 67, 10);
INSERT INTO question_to_category VALUES (68, 68, 12);
INSERT INTO question_to_category VALUES (69, 69, 12);
INSERT INTO question_to_category VALUES (70, 70, 12);
INSERT INTO question_to_category VALUES (71, 71, 12);
INSERT INTO question_to_category VALUES (72, 72, 12);
INSERT INTO question_to_category VALUES (73, 73, 12);
INSERT INTO question_to_category VALUES (74, 74, 12);
INSERT INTO question_to_category VALUES (75, 75, 12);
INSERT INTO question_to_category VALUES (76, 76, 12);
INSERT INTO question_to_category VALUES (77, 77, 12);
INSERT INTO question_to_category VALUES (78, 78, 12);
INSERT INTO question_to_category VALUES (79, 79, 12);
INSERT INTO question_to_category VALUES (80, 80, 13);
INSERT INTO question_to_category VALUES (81, 81, 13);
INSERT INTO question_to_category VALUES (82, 82, 13);
INSERT INTO question_to_category VALUES (83, 83, 13);
INSERT INTO question_to_category VALUES (84, 84, 13);
INSERT INTO question_to_category VALUES (85, 85, 13);
INSERT INTO question_to_category VALUES (86, 86, 13);
INSERT INTO question_to_category VALUES (87, 87, 13);
INSERT INTO question_to_category VALUES (88, 88, 13);
INSERT INTO question_to_category VALUES (89, 89, 13);
INSERT INTO question_to_category VALUES (90, 90, 13);
INSERT INTO question_to_category VALUES (91, 91, 13);
INSERT INTO question_to_category VALUES (92, 92, 13);
INSERT INTO question_to_category VALUES (93, 93, 13);
INSERT INTO question_to_category VALUES (94, 94, 14);
INSERT INTO question_to_category VALUES (95, 95, 14);
INSERT INTO question_to_category VALUES (96, 96, 14);
INSERT INTO question_to_category VALUES (97, 97, 14);
INSERT INTO question_to_category VALUES (98, 98, 14);
INSERT INTO question_to_category VALUES (99, 99, 14);
INSERT INTO question_to_category VALUES (100, 100, 14);
INSERT INTO question_to_category VALUES (101, 101, 14);
INSERT INTO question_to_category VALUES (102, 102, 14);
INSERT INTO question_to_category VALUES (103, 103, 14);
INSERT INTO question_to_category VALUES (104, 104, 14);
INSERT INTO question_to_category VALUES (105, 105, 14);
INSERT INTO question_to_category VALUES (106, 106, 16);
INSERT INTO question_to_category VALUES (107, 107, 16);
INSERT INTO question_to_category VALUES (108, 108, 16);
INSERT INTO question_to_category VALUES (109, 109, 16);
INSERT INTO question_to_category VALUES (110, 110, 16);
INSERT INTO question_to_category VALUES (111, 111, 16);
INSERT INTO question_to_category VALUES (112, 112, 16);
INSERT INTO question_to_category VALUES (113, 113, 16);
INSERT INTO question_to_category VALUES (114, 114, 16);
INSERT INTO question_to_category VALUES (115, 115, 16);
INSERT INTO question_to_category VALUES (116, 116, 16);
INSERT INTO question_to_category VALUES (117, 117, 16);
INSERT INTO question_to_category VALUES (118, 118, 16);
INSERT INTO question_to_category VALUES (119, 119, 17);
INSERT INTO question_to_category VALUES (120, 120, 17);
INSERT INTO question_to_category VALUES (121, 121, 17);
INSERT INTO question_to_category VALUES (122, 122, 17);
INSERT INTO question_to_category VALUES (123, 123, 17);
INSERT INTO question_to_category VALUES (124, 124, 17);
INSERT INTO question_to_category VALUES (125, 125, 17);
INSERT INTO question_to_category VALUES (126, 126, 17);
INSERT INTO question_to_category VALUES (127, 127, 17);
INSERT INTO question_to_category VALUES (128, 128, 17);
INSERT INTO question_to_category VALUES (129, 129, 17);
INSERT INTO question_to_category VALUES (130, 130, 18);
INSERT INTO question_to_category VALUES (131, 131, 18);
INSERT INTO question_to_category VALUES (132, 132, 18);
INSERT INTO question_to_category VALUES (133, 133, 18);
INSERT INTO question_to_category VALUES (134, 134, 18);
INSERT INTO question_to_category VALUES (135, 135, 18);
INSERT INTO question_to_category VALUES (136, 136, 18);
INSERT INTO question_to_category VALUES (137, 137, 18);
INSERT INTO question_to_category VALUES (138, 138, 18);
INSERT INTO question_to_category VALUES (139, 139, 18);
INSERT INTO question_to_category VALUES (140, 140, 18);
INSERT INTO question_to_category VALUES (141, 141, 20);
INSERT INTO question_to_category VALUES (142, 142, 20);
INSERT INTO question_to_category VALUES (143, 143, 20);
INSERT INTO question_to_category VALUES (144, 144, 20);
INSERT INTO question_to_category VALUES (145, 145, 20);
INSERT INTO question_to_category VALUES (146, 146, 20);
INSERT INTO question_to_category VALUES (147, 147, 20);
INSERT INTO question_to_category VALUES (148, 148, 20);
INSERT INTO question_to_category VALUES (149, 149, 20);
INSERT INTO question_to_category VALUES (150, 150, 20);
INSERT INTO question_to_category VALUES (151, 151, 20);
INSERT INTO question_to_category VALUES (152, 152, 21);
INSERT INTO question_to_category VALUES (153, 153, 21);
INSERT INTO question_to_category VALUES (154, 154, 21);
INSERT INTO question_to_category VALUES (155, 155, 21);
INSERT INTO question_to_category VALUES (156, 156, 21);
INSERT INTO question_to_category VALUES (157, 157, 21);
INSERT INTO question_to_category VALUES (158, 158, 21);
INSERT INTO question_to_category VALUES (159, 159, 21);
INSERT INTO question_to_category VALUES (160, 160, 21);
INSERT INTO question_to_category VALUES (161, 161, 21);
INSERT INTO question_to_category VALUES (162, 162, 21);
INSERT INTO question_to_category VALUES (163, 163, 21);
INSERT INTO question_to_category VALUES (164, 164, 21);
INSERT INTO question_to_category VALUES (165, 165, 23);
INSERT INTO question_to_category VALUES (166, 166, 23);
INSERT INTO question_to_category VALUES (167, 167, 23);
INSERT INTO question_to_category VALUES (168, 168, 23);
INSERT INTO question_to_category VALUES (169, 169, 23);
INSERT INTO question_to_category VALUES (170, 170, 23);
INSERT INTO question_to_category VALUES (171, 171, 23);
INSERT INTO question_to_category VALUES (172, 172, 23);
INSERT INTO question_to_category VALUES (173, 173, 23);
INSERT INTO question_to_category VALUES (174, 174, 23);
INSERT INTO question_to_category VALUES (175, 175, 23);
INSERT INTO question_to_category VALUES (176, 176, 23);
INSERT INTO question_to_category VALUES (177, 177, 23);
INSERT INTO question_to_category VALUES (178, 178, 23);
INSERT INTO question_to_category VALUES (179, 179, 24);
INSERT INTO question_to_category VALUES (180, 180, 24);
INSERT INTO question_to_category VALUES (181, 181, 24);
INSERT INTO question_to_category VALUES (182, 182, 24);
INSERT INTO question_to_category VALUES (183, 183, 24);
INSERT INTO question_to_category VALUES (184, 184, 24);
INSERT INTO question_to_category VALUES (185, 185, 24);
INSERT INTO question_to_category VALUES (186, 186, 24);
INSERT INTO question_to_category VALUES (187, 187, 24);
INSERT INTO question_to_category VALUES (188, 188, 24);
INSERT INTO question_to_category VALUES (189, 189, 24);
INSERT INTO question_to_category VALUES (190, 190, 24);
INSERT INTO question_to_category VALUES (191, 191, 24);
INSERT INTO question_to_category VALUES (192, 192, 25);
INSERT INTO question_to_category VALUES (193, 193, 25);
INSERT INTO question_to_category VALUES (194, 194, 25);
INSERT INTO question_to_category VALUES (195, 195, 25);
INSERT INTO question_to_category VALUES (196, 196, 25);
INSERT INTO question_to_category VALUES (197, 197, 25);
INSERT INTO question_to_category VALUES (198, 198, 25);
INSERT INTO question_to_category VALUES (199, 199, 25);
INSERT INTO question_to_category VALUES (200, 200, 25);
INSERT INTO question_to_category VALUES (201, 201, 25);
INSERT INTO question_to_category VALUES (202, 202, 25);
INSERT INTO question_to_category VALUES (203, 203, 25);
INSERT INTO question_to_category VALUES (204, 204, 25);
INSERT INTO question_to_category VALUES (205, 205, 25);
INSERT INTO question_to_category VALUES (206, 206, 26);
INSERT INTO question_to_category VALUES (207, 207, 26);
INSERT INTO question_to_category VALUES (208, 208, 26);
INSERT INTO question_to_category VALUES (209, 209, 26);
INSERT INTO question_to_category VALUES (210, 210, 26);
INSERT INTO question_to_category VALUES (211, 211, 26);
INSERT INTO question_to_category VALUES (212, 212, 26);
INSERT INTO question_to_category VALUES (213, 213, 26);
INSERT INTO question_to_category VALUES (214, 214, 26);
INSERT INTO question_to_category VALUES (215, 215, 26);
INSERT INTO question_to_category VALUES (216, 216, 26);
INSERT INTO question_to_category VALUES (217, 217, 26);
INSERT INTO question_to_category VALUES (218, 218, 26);
INSERT INTO question_to_category VALUES (219, 219, 26);
INSERT INTO question_to_category VALUES (220, 220, 26);
INSERT INTO question_to_category VALUES (221, 221, 26);
INSERT INTO question_to_category VALUES (222, 222, 28);
INSERT INTO question_to_category VALUES (223, 223, 28);
INSERT INTO question_to_category VALUES (224, 224, 28);
INSERT INTO question_to_category VALUES (225, 225, 28);
INSERT INTO question_to_category VALUES (226, 226, 28);
INSERT INTO question_to_category VALUES (227, 227, 28);
INSERT INTO question_to_category VALUES (228, 228, 28);
INSERT INTO question_to_category VALUES (229, 229, 28);
INSERT INTO question_to_category VALUES (230, 230, 28);
INSERT INTO question_to_category VALUES (231, 231, 28);
INSERT INTO question_to_category VALUES (232, 232, 28);
INSERT INTO question_to_category VALUES (233, 233, 29);
INSERT INTO question_to_category VALUES (234, 234, 29);
INSERT INTO question_to_category VALUES (235, 235, 29);
INSERT INTO question_to_category VALUES (236, 236, 29);
INSERT INTO question_to_category VALUES (237, 237, 29);
INSERT INTO question_to_category VALUES (238, 238, 29);
INSERT INTO question_to_category VALUES (239, 239, 29);
INSERT INTO question_to_category VALUES (240, 240, 29);
INSERT INTO question_to_category VALUES (241, 241, 29);
INSERT INTO question_to_category VALUES (242, 242, 29);
INSERT INTO question_to_category VALUES (243, 243, 29);
INSERT INTO question_to_category VALUES (244, 244, 30);
INSERT INTO question_to_category VALUES (245, 245, 30);
INSERT INTO question_to_category VALUES (246, 246, 30);
INSERT INTO question_to_category VALUES (247, 247, 30);
INSERT INTO question_to_category VALUES (248, 248, 30);
INSERT INTO question_to_category VALUES (249, 249, 30);
INSERT INTO question_to_category VALUES (250, 250, 30);
INSERT INTO question_to_category VALUES (251, 251, 30);
INSERT INTO question_to_category VALUES (252, 252, 30);
INSERT INTO question_to_category VALUES (253, 253, 30);
INSERT INTO question_to_category VALUES (254, 254, 30);
INSERT INTO question_to_category VALUES (255, 255, 30);
INSERT INTO question_to_category VALUES (256, 256, 30);
INSERT INTO question_to_category VALUES (257, 257, 31);
INSERT INTO question_to_category VALUES (258, 258, 31);
INSERT INTO question_to_category VALUES (259, 259, 31);
INSERT INTO question_to_category VALUES (260, 260, 31);
INSERT INTO question_to_category VALUES (261, 261, 31);
INSERT INTO question_to_category VALUES (262, 262, 31);
INSERT INTO question_to_category VALUES (263, 263, 31);
INSERT INTO question_to_category VALUES (264, 264, 31);
INSERT INTO question_to_category VALUES (265, 265, 31);
INSERT INTO question_to_category VALUES (266, 266, 31);
INSERT INTO question_to_category VALUES (267, 267, 31);
INSERT INTO question_to_category VALUES (268, 268, 31);
INSERT INTO question_to_category VALUES (269, 269, 33);
INSERT INTO question_to_category VALUES (270, 270, 33);
INSERT INTO question_to_category VALUES (271, 271, 33);
INSERT INTO question_to_category VALUES (272, 272, 33);
INSERT INTO question_to_category VALUES (273, 273, 33);
INSERT INTO question_to_category VALUES (274, 274, 33);
INSERT INTO question_to_category VALUES (275, 275, 33);
INSERT INTO question_to_category VALUES (276, 276, 33);
INSERT INTO question_to_category VALUES (277, 277, 33);
INSERT INTO question_to_category VALUES (278, 278, 33);
INSERT INTO question_to_category VALUES (279, 279, 33);
INSERT INTO question_to_category VALUES (280, 280, 34);
INSERT INTO question_to_category VALUES (281, 281, 34);
INSERT INTO question_to_category VALUES (282, 282, 34);
INSERT INTO question_to_category VALUES (283, 283, 34);
INSERT INTO question_to_category VALUES (284, 284, 34);
INSERT INTO question_to_category VALUES (285, 285, 34);
INSERT INTO question_to_category VALUES (286, 286, 34);
INSERT INTO question_to_category VALUES (287, 287, 34);
INSERT INTO question_to_category VALUES (288, 288, 34);
INSERT INTO question_to_category VALUES (289, 289, 34);
INSERT INTO question_to_category VALUES (290, 290, 34);
INSERT INTO question_to_category VALUES (291, 291, 34);
INSERT INTO question_to_category VALUES (292, 292, 35);
INSERT INTO question_to_category VALUES (293, 293, 35);
INSERT INTO question_to_category VALUES (294, 294, 35);
INSERT INTO question_to_category VALUES (295, 295, 35);
INSERT INTO question_to_category VALUES (296, 296, 35);
INSERT INTO question_to_category VALUES (297, 297, 35);
INSERT INTO question_to_category VALUES (298, 298, 35);
INSERT INTO question_to_category VALUES (299, 299, 35);
INSERT INTO question_to_category VALUES (300, 300, 35);
INSERT INTO question_to_category VALUES (301, 301, 35);
INSERT INTO question_to_category VALUES (302, 302, 35);
INSERT INTO question_to_category VALUES (303, 303, 35);
INSERT INTO question_to_category VALUES (304, 304, 36);
INSERT INTO question_to_category VALUES (305, 305, 36);
INSERT INTO question_to_category VALUES (306, 306, 36);
INSERT INTO question_to_category VALUES (307, 307, 36);
INSERT INTO question_to_category VALUES (308, 308, 36);
INSERT INTO question_to_category VALUES (309, 309, 36);
INSERT INTO question_to_category VALUES (310, 310, 36);
INSERT INTO question_to_category VALUES (311, 311, 36);
INSERT INTO question_to_category VALUES (312, 312, 36);
INSERT INTO question_to_category VALUES (313, 313, 36);
INSERT INTO question_to_category VALUES (314, 314, 36);
INSERT INTO question_to_category VALUES (315, 315, 36);
INSERT INTO question_to_category VALUES (316, 316, 38);
INSERT INTO question_to_category VALUES (317, 317, 38);
INSERT INTO question_to_category VALUES (318, 318, 38);
INSERT INTO question_to_category VALUES (319, 319, 38);
INSERT INTO question_to_category VALUES (320, 320, 38);
INSERT INTO question_to_category VALUES (321, 321, 38);
INSERT INTO question_to_category VALUES (322, 322, 38);
INSERT INTO question_to_category VALUES (323, 323, 38);
INSERT INTO question_to_category VALUES (324, 324, 38);
INSERT INTO question_to_category VALUES (325, 325, 38);
INSERT INTO question_to_category VALUES (326, 326, 38);
INSERT INTO question_to_category VALUES (327, 327, 39);
INSERT INTO question_to_category VALUES (328, 328, 39);
INSERT INTO question_to_category VALUES (329, 329, 39);
INSERT INTO question_to_category VALUES (330, 330, 39);
INSERT INTO question_to_category VALUES (331, 331, 39);
INSERT INTO question_to_category VALUES (332, 332, 39);
INSERT INTO question_to_category VALUES (333, 333, 39);
INSERT INTO question_to_category VALUES (334, 334, 39);
INSERT INTO question_to_category VALUES (335, 335, 39);
INSERT INTO question_to_category VALUES (336, 336, 39);
INSERT INTO question_to_category VALUES (337, 337, 39);
INSERT INTO question_to_category VALUES (338, 338, 39);
INSERT INTO question_to_category VALUES (339, 339, 40);
INSERT INTO question_to_category VALUES (340, 340, 40);
INSERT INTO question_to_category VALUES (341, 341, 40);
INSERT INTO question_to_category VALUES (342, 342, 40);
INSERT INTO question_to_category VALUES (343, 343, 40);
INSERT INTO question_to_category VALUES (344, 344, 40);
INSERT INTO question_to_category VALUES (345, 345, 40);
INSERT INTO question_to_category VALUES (346, 346, 40);
INSERT INTO question_to_category VALUES (347, 347, 40);
INSERT INTO question_to_category VALUES (348, 348, 40);
INSERT INTO question_to_category VALUES (349, 349, 40);
INSERT INTO question_to_category VALUES (350, 350, 41);
INSERT INTO question_to_category VALUES (351, 351, 41);
INSERT INTO question_to_category VALUES (352, 352, 41);
INSERT INTO question_to_category VALUES (353, 353, 41);
INSERT INTO question_to_category VALUES (354, 354, 41);
INSERT INTO question_to_category VALUES (355, 355, 41);
INSERT INTO question_to_category VALUES (356, 356, 41);
INSERT INTO question_to_category VALUES (357, 357, 41);
INSERT INTO question_to_category VALUES (358, 358, 41);
INSERT INTO question_to_category VALUES (359, 359, 41);
INSERT INTO question_to_category VALUES (360, 360, 41);
INSERT INTO question_to_category VALUES (361, 361, 41);
INSERT INTO question_to_category VALUES (362, 362, 41);
INSERT INTO question_to_category VALUES (363, 363, 41);
INSERT INTO question_to_category VALUES (364, 364, 43);
INSERT INTO question_to_category VALUES (365, 365, 43);
INSERT INTO question_to_category VALUES (366, 366, 43);
INSERT INTO question_to_category VALUES (367, 367, 43);
INSERT INTO question_to_category VALUES (368, 368, 43);
INSERT INTO question_to_category VALUES (369, 369, 43);
INSERT INTO question_to_category VALUES (370, 370, 43);
INSERT INTO question_to_category VALUES (371, 371, 43);
INSERT INTO question_to_category VALUES (372, 372, 43);
INSERT INTO question_to_category VALUES (373, 373, 43);
INSERT INTO question_to_category VALUES (374, 374, 43);
INSERT INTO question_to_category VALUES (375, 375, 43);
INSERT INTO question_to_category VALUES (376, 376, 44);
INSERT INTO question_to_category VALUES (377, 377, 44);
INSERT INTO question_to_category VALUES (378, 378, 44);
INSERT INTO question_to_category VALUES (379, 379, 44);
INSERT INTO question_to_category VALUES (380, 380, 44);
INSERT INTO question_to_category VALUES (381, 381, 44);
INSERT INTO question_to_category VALUES (382, 382, 44);
INSERT INTO question_to_category VALUES (383, 383, 44);
INSERT INTO question_to_category VALUES (384, 384, 44);
INSERT INTO question_to_category VALUES (385, 385, 44);
INSERT INTO question_to_category VALUES (386, 386, 44);
INSERT INTO question_to_category VALUES (387, 387, 46);
INSERT INTO question_to_category VALUES (388, 388, 46);
INSERT INTO question_to_category VALUES (389, 389, 46);
INSERT INTO question_to_category VALUES (390, 390, 46);
INSERT INTO question_to_category VALUES (391, 391, 46);
INSERT INTO question_to_category VALUES (392, 392, 46);
INSERT INTO question_to_category VALUES (393, 393, 46);
INSERT INTO question_to_category VALUES (394, 394, 46);
INSERT INTO question_to_category VALUES (395, 395, 46);
INSERT INTO question_to_category VALUES (396, 396, 46);
INSERT INTO question_to_category VALUES (397, 397, 46);
INSERT INTO question_to_category VALUES (398, 398, 47);
INSERT INTO question_to_category VALUES (399, 399, 47);
INSERT INTO question_to_category VALUES (400, 400, 47);
INSERT INTO question_to_category VALUES (401, 401, 47);
INSERT INTO question_to_category VALUES (402, 402, 47);
INSERT INTO question_to_category VALUES (403, 403, 47);
INSERT INTO question_to_category VALUES (404, 404, 47);
INSERT INTO question_to_category VALUES (405, 405, 47);
INSERT INTO question_to_category VALUES (406, 406, 47);
INSERT INTO question_to_category VALUES (407, 407, 47);
INSERT INTO question_to_category VALUES (408, 408, 47);
INSERT INTO question_to_category VALUES (409, 409, 47);
INSERT INTO question_to_category VALUES (410, 410, 47);
INSERT INTO question_to_category VALUES (411, 411, 48);
INSERT INTO question_to_category VALUES (412, 412, 48);
INSERT INTO question_to_category VALUES (413, 413, 48);
INSERT INTO question_to_category VALUES (414, 414, 48);
INSERT INTO question_to_category VALUES (415, 415, 48);
INSERT INTO question_to_category VALUES (416, 416, 48);
INSERT INTO question_to_category VALUES (417, 417, 48);
INSERT INTO question_to_category VALUES (418, 418, 48);
INSERT INTO question_to_category VALUES (419, 419, 48);
INSERT INTO question_to_category VALUES (420, 420, 48);
INSERT INTO question_to_category VALUES (421, 421, 48);
INSERT INTO question_to_category VALUES (422, 422, 48);
INSERT INTO question_to_category VALUES (423, 423, 48);

INSERT INTO question_to_category VALUES (424, 424, 50);
INSERT INTO question_to_category VALUES (425, 425, 50);
INSERT INTO question_to_category VALUES (426, 426, 50);
INSERT INTO question_to_category VALUES (427, 427, 50);
INSERT INTO question_to_category VALUES (428, 428, 50);
INSERT INTO question_to_category VALUES (429, 429, 50);
INSERT INTO question_to_category VALUES (430, 430, 50);
INSERT INTO question_to_category VALUES (431, 431, 50);
INSERT INTO question_to_category VALUES (432, 432, 50);
INSERT INTO question_to_category VALUES (433, 433, 50);
INSERT INTO question_to_category VALUES (434, 434, 50);
INSERT INTO question_to_category VALUES (435, 435, 50);
INSERT INTO question_to_category VALUES (436, 436, 50);
INSERT INTO question_to_category VALUES (437, 437, 50);
INSERT INTO question_to_category VALUES (438, 438, 50);
INSERT INTO question_to_category VALUES (439, 439, 51);
INSERT INTO question_to_category VALUES (440, 440, 51);
INSERT INTO question_to_category VALUES (441, 441, 51);
INSERT INTO question_to_category VALUES (442, 442, 51);
INSERT INTO question_to_category VALUES (443, 443, 51);
INSERT INTO question_to_category VALUES (444, 444, 51);
INSERT INTO question_to_category VALUES (445, 445, 51);
INSERT INTO question_to_category VALUES (446, 446, 51);
INSERT INTO question_to_category VALUES (447, 447, 51);
INSERT INTO question_to_category VALUES (448, 448, 51);
INSERT INTO question_to_category VALUES (449, 449, 51);
INSERT INTO question_to_category VALUES (450, 450, 51);
INSERT INTO question_to_category VALUES (451, 451, 52);
INSERT INTO question_to_category VALUES (452, 452, 52);
INSERT INTO question_to_category VALUES (453, 453, 52);
INSERT INTO question_to_category VALUES (454, 454, 52);
INSERT INTO question_to_category VALUES (455, 455, 52);
INSERT INTO question_to_category VALUES (456, 456, 52);
INSERT INTO question_to_category VALUES (457, 457, 52);
INSERT INTO question_to_category VALUES (458, 458, 52);
INSERT INTO question_to_category VALUES (459, 459, 52);
INSERT INTO question_to_category VALUES (460, 460, 52);
INSERT INTO question_to_category VALUES (461, 461, 52);
INSERT INTO question_to_category VALUES (462, 462, 52);
INSERT INTO question_to_category VALUES (463, 463, 52);
INSERT INTO question_to_category VALUES (464, 464, 52);
INSERT INTO question_to_category VALUES (465, 465, 52);
INSERT INTO question_to_category VALUES (466, 466, 53);
INSERT INTO question_to_category VALUES (467, 467, 53);
INSERT INTO question_to_category VALUES (468, 468, 53);
INSERT INTO question_to_category VALUES (469, 469, 53);
INSERT INTO question_to_category VALUES (470, 470, 53);
INSERT INTO question_to_category VALUES (471, 471, 53);
INSERT INTO question_to_category VALUES (472, 472, 53);
INSERT INTO question_to_category VALUES (473, 473, 53);
INSERT INTO question_to_category VALUES (474, 474, 53);
INSERT INTO question_to_category VALUES (475, 475, 53);
INSERT INTO question_to_category VALUES (476, 476, 53);
INSERT INTO question_to_category VALUES (477, 477, 54);
INSERT INTO question_to_category VALUES (478, 478, 54);
INSERT INTO question_to_category VALUES (479, 479, 54);
INSERT INTO question_to_category VALUES (480, 480, 54);
INSERT INTO question_to_category VALUES (481, 481, 54);
INSERT INTO question_to_category VALUES (482, 482, 54);
INSERT INTO question_to_category VALUES (483, 483, 54);
INSERT INTO question_to_category VALUES (484, 484, 54);
INSERT INTO question_to_category VALUES (485, 485, 54);
INSERT INTO question_to_category VALUES (486, 486, 54);
INSERT INTO question_to_category VALUES (487, 487, 54);
INSERT INTO question_to_category VALUES (488, 488, 56);
INSERT INTO question_to_category VALUES (489, 489, 56);
INSERT INTO question_to_category VALUES (490, 490, 56);
INSERT INTO question_to_category VALUES (491, 491, 56);
INSERT INTO question_to_category VALUES (492, 492, 56);
INSERT INTO question_to_category VALUES (493, 493, 56);
INSERT INTO question_to_category VALUES (494, 494, 56);
INSERT INTO question_to_category VALUES (495, 495, 56);
INSERT INTO question_to_category VALUES (496, 496, 56);
INSERT INTO question_to_category VALUES (497, 497, 56);
INSERT INTO question_to_category VALUES (498, 498, 56);
INSERT INTO question_to_category VALUES (499, 499, 56);
INSERT INTO question_to_category VALUES (500, 500, 57);
INSERT INTO question_to_category VALUES (501, 501, 57);
INSERT INTO question_to_category VALUES (502, 502, 57);
INSERT INTO question_to_category VALUES (503, 503, 57);
INSERT INTO question_to_category VALUES (504, 504, 57);
INSERT INTO question_to_category VALUES (505, 505, 57);
INSERT INTO question_to_category VALUES (506, 506, 57);
INSERT INTO question_to_category VALUES (507, 507, 57);
INSERT INTO question_to_category VALUES (508, 508, 57);
INSERT INTO question_to_category VALUES (509, 509, 57);
INSERT INTO question_to_category VALUES (510, 510, 57);
INSERT INTO question_to_category VALUES (511, 511, 58);
INSERT INTO question_to_category VALUES (512, 512, 58);
INSERT INTO question_to_category VALUES (513, 513, 58);
INSERT INTO question_to_category VALUES (514, 514, 58);
INSERT INTO question_to_category VALUES (515, 515, 58);
INSERT INTO question_to_category VALUES (516, 516, 58);
INSERT INTO question_to_category VALUES (517, 517, 58);
INSERT INTO question_to_category VALUES (518, 518, 58);
INSERT INTO question_to_category VALUES (519, 519, 58);
INSERT INTO question_to_category VALUES (520, 520, 58);
INSERT INTO question_to_category VALUES (521, 521, 58);
INSERT INTO question_to_category VALUES (522, 522, 59);
INSERT INTO question_to_category VALUES (523, 523, 59);
INSERT INTO question_to_category VALUES (524, 524, 59);
INSERT INTO question_to_category VALUES (525, 525, 59);
INSERT INTO question_to_category VALUES (526, 526, 59);
INSERT INTO question_to_category VALUES (527, 527, 59);
INSERT INTO question_to_category VALUES (528, 528, 59);
INSERT INTO question_to_category VALUES (529, 529, 59);
INSERT INTO question_to_category VALUES (530, 530, 59);
INSERT INTO question_to_category VALUES (531, 531, 59);
INSERT INTO question_to_category VALUES (532, 532, 59);
INSERT INTO question_to_category VALUES (533, 533, 60);
INSERT INTO question_to_category VALUES (534, 534, 60);
INSERT INTO question_to_category VALUES (535, 535, 60);
INSERT INTO question_to_category VALUES (536, 536, 60);
INSERT INTO question_to_category VALUES (537, 537, 60);
INSERT INTO question_to_category VALUES (538, 538, 60);
INSERT INTO question_to_category VALUES (539, 539, 60);
INSERT INTO question_to_category VALUES (540, 540, 60);
INSERT INTO question_to_category VALUES (541, 541, 60);
INSERT INTO question_to_category VALUES (542, 542, 60);
INSERT INTO question_to_category VALUES (543, 543, 60);
INSERT INTO question_to_category VALUES (544, 544, 60);
INSERT INTO question_to_category VALUES (545, 545, 60);
INSERT INTO question_to_category VALUES (546, 546, 60);
INSERT INTO question_to_category VALUES (547, 547, 60);
INSERT INTO question_to_category VALUES (548, 548, 62);
INSERT INTO question_to_category VALUES (549, 549, 62);
INSERT INTO question_to_category VALUES (550, 550, 62);
INSERT INTO question_to_category VALUES (551, 551, 62);
INSERT INTO question_to_category VALUES (552, 552, 62);
INSERT INTO question_to_category VALUES (553, 553, 62);
INSERT INTO question_to_category VALUES (554, 554, 62);
INSERT INTO question_to_category VALUES (555, 555, 62);
INSERT INTO question_to_category VALUES (556, 556, 62);
INSERT INTO question_to_category VALUES (557, 557, 62);
INSERT INTO question_to_category VALUES (558, 558, 62);
INSERT INTO question_to_category VALUES (559, 559, 62);
INSERT INTO question_to_category VALUES (560, 560, 62);
INSERT INTO question_to_category VALUES (561, 561, 62);
INSERT INTO question_to_category VALUES (562, 562, 63);
INSERT INTO question_to_category VALUES (563, 563, 63);
INSERT INTO question_to_category VALUES (564, 564, 63);
INSERT INTO question_to_category VALUES (565, 565, 63);
INSERT INTO question_to_category VALUES (566, 566, 63);
INSERT INTO question_to_category VALUES (567, 567, 63);
INSERT INTO question_to_category VALUES (568, 568, 63);
INSERT INTO question_to_category VALUES (569, 569, 63);
INSERT INTO question_to_category VALUES (570, 570, 63);
INSERT INTO question_to_category VALUES (571, 571, 63);
INSERT INTO question_to_category VALUES (572, 572, 63);
INSERT INTO question_to_category VALUES (573, 573, 64);
INSERT INTO question_to_category VALUES (574, 574, 64);
INSERT INTO question_to_category VALUES (575, 575, 64);
INSERT INTO question_to_category VALUES (576, 576, 64);
INSERT INTO question_to_category VALUES (577, 577, 64);
INSERT INTO question_to_category VALUES (578, 578, 64);
INSERT INTO question_to_category VALUES (579, 579, 64);
INSERT INTO question_to_category VALUES (580, 580, 64);
INSERT INTO question_to_category VALUES (581, 581, 64);
INSERT INTO question_to_category VALUES (582, 582, 64);
INSERT INTO question_to_category VALUES (583, 583, 64);
INSERT INTO question_to_category VALUES (584, 584, 66);
INSERT INTO question_to_category VALUES (585, 585, 66);
INSERT INTO question_to_category VALUES (586, 586, 66);
INSERT INTO question_to_category VALUES (587, 587, 66);
INSERT INTO question_to_category VALUES (588, 588, 66);
INSERT INTO question_to_category VALUES (589, 589, 66);
INSERT INTO question_to_category VALUES (590, 590, 66);
INSERT INTO question_to_category VALUES (591, 591, 66);
INSERT INTO question_to_category VALUES (592, 592, 66);
INSERT INTO question_to_category VALUES (593, 593, 66);
INSERT INTO question_to_category VALUES (594, 594, 66);
INSERT INTO question_to_category VALUES (595, 595, 66);
INSERT INTO question_to_category VALUES (596, 596, 66);
INSERT INTO question_to_category VALUES (597, 597, 66);
INSERT INTO question_to_category VALUES (598, 598, 66);
INSERT INTO question_to_category VALUES (599, 599, 66);
INSERT INTO question_to_category VALUES (600, 600, 66);
INSERT INTO question_to_category VALUES (601, 601, 67);
INSERT INTO question_to_category VALUES (602, 602, 67);
INSERT INTO question_to_category VALUES (603, 603, 67);
INSERT INTO question_to_category VALUES (604, 604, 67);
INSERT INTO question_to_category VALUES (605, 605, 67);
INSERT INTO question_to_category VALUES (606, 606, 67);
INSERT INTO question_to_category VALUES (607, 607, 67);
INSERT INTO question_to_category VALUES (608, 608, 67);
INSERT INTO question_to_category VALUES (609, 609, 67);
INSERT INTO question_to_category VALUES (610, 610, 67);
INSERT INTO question_to_category VALUES (611, 611, 67);
INSERT INTO question_to_category VALUES (612, 612, 67);
INSERT INTO question_to_category VALUES (613, 613, 67);
INSERT INTO question_to_category VALUES (614, 614, 67);
INSERT INTO question_to_category VALUES (615, 615, 67);
INSERT INTO question_to_category VALUES (616, 616, 68);
INSERT INTO question_to_category VALUES (617, 617, 68);
INSERT INTO question_to_category VALUES (618, 618, 68);
INSERT INTO question_to_category VALUES (619, 619, 68);
INSERT INTO question_to_category VALUES (620, 620, 68);
INSERT INTO question_to_category VALUES (621, 621, 68);
INSERT INTO question_to_category VALUES (622, 622, 68);
INSERT INTO question_to_category VALUES (623, 623, 68);
INSERT INTO question_to_category VALUES (624, 624, 68);
INSERT INTO question_to_category VALUES (625, 625, 68);
INSERT INTO question_to_category VALUES (626, 626, 68);
INSERT INTO question_to_category VALUES (627, 627, 68);
INSERT INTO question_to_category VALUES (628, 628, 68);
INSERT INTO question_to_category VALUES (629, 629, 69);
INSERT INTO question_to_category VALUES (630, 630, 69);
INSERT INTO question_to_category VALUES (631, 631, 69);
INSERT INTO question_to_category VALUES (632, 632, 69);
INSERT INTO question_to_category VALUES (633, 633, 69);
INSERT INTO question_to_category VALUES (634, 634, 69);
INSERT INTO question_to_category VALUES (635, 635, 69);
INSERT INTO question_to_category VALUES (636, 636, 69);
INSERT INTO question_to_category VALUES (637, 637, 69);
INSERT INTO question_to_category VALUES (638, 638, 69);
INSERT INTO question_to_category VALUES (639, 639, 69);
INSERT INTO question_to_category VALUES (640, 640, 70);
INSERT INTO question_to_category VALUES (641, 641, 70);
INSERT INTO question_to_category VALUES (642, 642, 70);
INSERT INTO question_to_category VALUES (643, 643, 70);
INSERT INTO question_to_category VALUES (644, 644, 70);
INSERT INTO question_to_category VALUES (645, 645, 70);
INSERT INTO question_to_category VALUES (646, 646, 70);
INSERT INTO question_to_category VALUES (647, 647, 70);
INSERT INTO question_to_category VALUES (648, 648, 70);
INSERT INTO question_to_category VALUES (649, 649, 70);
INSERT INTO question_to_category VALUES (650, 650, 70);
INSERT INTO question_to_category VALUES (651, 651, 72);
INSERT INTO question_to_category VALUES (652, 652, 72);
INSERT INTO question_to_category VALUES (653, 653, 72);
INSERT INTO question_to_category VALUES (654, 654, 72);
INSERT INTO question_to_category VALUES (655, 655, 72);
INSERT INTO question_to_category VALUES (656, 656, 72);
INSERT INTO question_to_category VALUES (657, 657, 72);
INSERT INTO question_to_category VALUES (658, 658, 72);
INSERT INTO question_to_category VALUES (659, 659, 72);
INSERT INTO question_to_category VALUES (660, 660, 72);
INSERT INTO question_to_category VALUES (661, 661, 72);
INSERT INTO question_to_category VALUES (662, 662, 73);
INSERT INTO question_to_category VALUES (663, 663, 73);
INSERT INTO question_to_category VALUES (664, 664, 73);
INSERT INTO question_to_category VALUES (665, 665, 73);
INSERT INTO question_to_category VALUES (666, 666, 73);
INSERT INTO question_to_category VALUES (667, 667, 73);
INSERT INTO question_to_category VALUES (668, 668, 73);
INSERT INTO question_to_category VALUES (669, 669, 73);
INSERT INTO question_to_category VALUES (670, 670, 73);
INSERT INTO question_to_category VALUES (671, 671, 73);
INSERT INTO question_to_category VALUES (672, 672, 73);
INSERT INTO question_to_category VALUES (673, 673, 73);
INSERT INTO question_to_category VALUES (674, 674, 73);
INSERT INTO question_to_category VALUES (675, 675, 73);
INSERT INTO question_to_category VALUES (676, 676, 74);
INSERT INTO question_to_category VALUES (677, 677, 74);
INSERT INTO question_to_category VALUES (678, 678, 74);
INSERT INTO question_to_category VALUES (679, 679, 74);
INSERT INTO question_to_category VALUES (680, 680, 74);
INSERT INTO question_to_category VALUES (681, 681, 74);
INSERT INTO question_to_category VALUES (682, 682, 74);
INSERT INTO question_to_category VALUES (683, 683, 74);
INSERT INTO question_to_category VALUES (684, 684, 74);
INSERT INTO question_to_category VALUES (685, 685, 74);
INSERT INTO question_to_category VALUES (686, 686, 74);
INSERT INTO question_to_category VALUES (687, 687, 74);
INSERT INTO question_to_category VALUES (688, 688, 74);
INSERT INTO question_to_category VALUES (689, 689, 74);
INSERT INTO question_to_category VALUES (690, 690, 74);
INSERT INTO question_to_category VALUES (691, 691, 74);
INSERT INTO question_to_category VALUES (692, 692, 74);
INSERT INTO question_to_category VALUES (693, 693, 74);
INSERT INTO question_to_category VALUES (694, 694, 76);
INSERT INTO question_to_category VALUES (695, 695, 76);
INSERT INTO question_to_category VALUES (696, 696, 76);
INSERT INTO question_to_category VALUES (697, 697, 76);
INSERT INTO question_to_category VALUES (698, 698, 76);
INSERT INTO question_to_category VALUES (699, 699, 76);
INSERT INTO question_to_category VALUES (700, 700, 76);
INSERT INTO question_to_category VALUES (701, 701, 76);
INSERT INTO question_to_category VALUES (702, 702, 76);
INSERT INTO question_to_category VALUES (703, 703, 76);
INSERT INTO question_to_category VALUES (704, 704, 76);
INSERT INTO question_to_category VALUES (705, 705, 76);
INSERT INTO question_to_category VALUES (706, 706, 76);
INSERT INTO question_to_category VALUES (707, 707, 76);
INSERT INTO question_to_category VALUES (708, 708, 77);
INSERT INTO question_to_category VALUES (709, 709, 77);
INSERT INTO question_to_category VALUES (710, 710, 77);
INSERT INTO question_to_category VALUES (711, 711, 77);
INSERT INTO question_to_category VALUES (712, 712, 77);
INSERT INTO question_to_category VALUES (713, 713, 77);
INSERT INTO question_to_category VALUES (714, 714, 77);
INSERT INTO question_to_category VALUES (715, 715, 77);
INSERT INTO question_to_category VALUES (716, 716, 77);
INSERT INTO question_to_category VALUES (717, 717, 77);
INSERT INTO question_to_category VALUES (718, 718, 77);
INSERT INTO question_to_category VALUES (719, 719, 77);
INSERT INTO question_to_category VALUES (720, 720, 77);
INSERT INTO question_to_category VALUES (721, 721, 79);
INSERT INTO question_to_category VALUES (722, 722, 79);
INSERT INTO question_to_category VALUES (723, 723, 79);
INSERT INTO question_to_category VALUES (724, 724, 79);
INSERT INTO question_to_category VALUES (725, 725, 79);
INSERT INTO question_to_category VALUES (726, 726, 79);
INSERT INTO question_to_category VALUES (727, 727, 79);
INSERT INTO question_to_category VALUES (728, 728, 79);
INSERT INTO question_to_category VALUES (729, 729, 79);
INSERT INTO question_to_category VALUES (730, 730, 79);
INSERT INTO question_to_category VALUES (731, 731, 79);
INSERT INTO question_to_category VALUES (732, 732, 79);
INSERT INTO question_to_category VALUES (733, 733, 79);
INSERT INTO question_to_category VALUES (734, 734, 80);
INSERT INTO question_to_category VALUES (735, 735, 80);
INSERT INTO question_to_category VALUES (736, 736, 80);
INSERT INTO question_to_category VALUES (737, 737, 80);
INSERT INTO question_to_category VALUES (738, 738, 80);
INSERT INTO question_to_category VALUES (739, 739, 80);
INSERT INTO question_to_category VALUES (740, 740, 80);
INSERT INTO question_to_category VALUES (741, 741, 80);
INSERT INTO question_to_category VALUES (742, 742, 80);
INSERT INTO question_to_category VALUES (743, 743, 80);
INSERT INTO question_to_category VALUES (744, 744, 80);
INSERT INTO question_to_category VALUES (745, 745, 81);
INSERT INTO question_to_category VALUES (746, 746, 81);
INSERT INTO question_to_category VALUES (747, 747, 81);
INSERT INTO question_to_category VALUES (748, 748, 81);
INSERT INTO question_to_category VALUES (749, 749, 81);
INSERT INTO question_to_category VALUES (750, 750, 81);
INSERT INTO question_to_category VALUES (751, 751, 81);
INSERT INTO question_to_category VALUES (752, 752, 81);
INSERT INTO question_to_category VALUES (753, 753, 81);
INSERT INTO question_to_category VALUES (754, 754, 81);
INSERT INTO question_to_category VALUES (755, 755, 81);
INSERT INTO question_to_category VALUES (756, 756, 81);
INSERT INTO question_to_category VALUES (757, 757, 81);
INSERT INTO question_to_category VALUES (758, 758, 81);
INSERT INTO question_to_category VALUES (759, 759, 81);
INSERT INTO question_to_category VALUES (760, 760, 81);
INSERT INTO question_to_category VALUES (761, 761, 83);
INSERT INTO question_to_category VALUES (762, 762, 83);
INSERT INTO question_to_category VALUES (763, 763, 83);
INSERT INTO question_to_category VALUES (764, 764, 83);
INSERT INTO question_to_category VALUES (765, 765, 83);
INSERT INTO question_to_category VALUES (766, 766, 83);
INSERT INTO question_to_category VALUES (767, 767, 83);
INSERT INTO question_to_category VALUES (768, 768, 83);
INSERT INTO question_to_category VALUES (769, 769, 83);
INSERT INTO question_to_category VALUES (770, 770, 83);
INSERT INTO question_to_category VALUES (771, 771, 83);
INSERT INTO question_to_category VALUES (772, 772, 83);
INSERT INTO question_to_category VALUES (773, 773, 84);
INSERT INTO question_to_category VALUES (774, 774, 84);
INSERT INTO question_to_category VALUES (775, 775, 84);
INSERT INTO question_to_category VALUES (776, 776, 84);
INSERT INTO question_to_category VALUES (777, 777, 84);
INSERT INTO question_to_category VALUES (778, 778, 84);
INSERT INTO question_to_category VALUES (779, 779, 84);
INSERT INTO question_to_category VALUES (780, 780, 84);
INSERT INTO question_to_category VALUES (781, 781, 84);
INSERT INTO question_to_category VALUES (782, 782, 84);
INSERT INTO question_to_category VALUES (783, 783, 84);
INSERT INTO question_to_category VALUES (784, 784, 84);
INSERT INTO question_to_category VALUES (785, 785, 85);
INSERT INTO question_to_category VALUES (786, 786, 85);
INSERT INTO question_to_category VALUES (787, 787, 85);
INSERT INTO question_to_category VALUES (788, 788, 85);
INSERT INTO question_to_category VALUES (789, 789, 85);
INSERT INTO question_to_category VALUES (790, 790, 85);
INSERT INTO question_to_category VALUES (791, 791, 85);
INSERT INTO question_to_category VALUES (792, 792, 85);
INSERT INTO question_to_category VALUES (793, 793, 85);
INSERT INTO question_to_category VALUES (794, 794, 85);
INSERT INTO question_to_category VALUES (795, 795, 85);
INSERT INTO question_to_category VALUES (796, 796, 85);
INSERT INTO question_to_category VALUES (797, 797, 85);
INSERT INTO question_to_category VALUES (798, 798, 85);
INSERT INTO question_to_category VALUES (799, 799, 87);
INSERT INTO question_to_category VALUES (800, 800, 87);
INSERT INTO question_to_category VALUES (801, 801, 87);
INSERT INTO question_to_category VALUE