export interface IOptions {
    /**
     * Combine segments if the {@link Segment.startTime}, {@link Segment.endTime}, and {@link Segment.speaker} match
     * between the current and prior segments
     *
     * Can be used with {@link combineSegments}. The {@link combineEqualTimes} rule is applied first.
     *
     * Can be used with {@link speakerChange}. The {@link speakerChange} rule is applied last.
     *
     * Cannot be used with {@link combineSpeaker}
     */
    combineEqualTimes?: boolean;
    /**
     * Character to use when {@link combineEqualTimes} is true.
     *
     * Default: `\n`
     */
    combineEqualTimesSeparator?: string;
    /**
     * Combine segments where speaker is the same and concatenated `body` fits in the {@link combineSegmentsLength}
     *
     * Can be used with {@link combineEqualTimes}. The {@link combineSegments} rule is applied first.
     *
     * Can be used with {@link speakerChange}. The {@link speakerChange} rule is applied last.
     *
     * Cannot be used with {@link combineSpeaker}
     */
    combineSegments?: boolean;
    /**
     * Max length of body text to use when {@link combineSegments} is true
     *
     * Default: See {@link DEFAULT_COMBINE_SEGMENTS_LENGTH}
     */
    combineSegmentsLength?: number;
    /**
     * Combine consecutive segments from the same speaker.
     *
     * Note: If this is enabled, {@link combineEqualTimes} and {@link combineSegments} will not be applied.
     *
     * Warning: if the transcript does not contain speaker information, resulting segment will contain entire transcript text.
     */
    combineSpeaker?: boolean;
    /**
     * Only include {@link Segment.speaker} when speaker changes
     *
     * May be used in combination with {@link combineSpeaker}, {@link combineEqualTimes}, or {@link combineSegments}
     */
    speakerChange?: boolean;
}
/**
 * Provides a way to convert numeric timestamp to a formatted string.
 *
 * A custom formatter may be registered.
 * If one isn't registered, the default formatter will be used and the data will be formatted as HH:mm:SS.fff
 */
export declare class OptionsManager implements IOptions {
    static _instance: OptionsManager;
    /**
     * Combine segments if the {@link Segment.startTime}, {@link Segment.endTime}, and {@link Segment.speaker} match
     * between the current and prior segments
     *
     * Can be used with {@link combineSegments}. The {@link combineEqualTimes} rule is applied first.
     *
     * Can be used with {@link speakerChange}. The {@link speakerChange} rule is applied last.
     *
     * Cannot be used with {@link combineSpeaker}
     */
    combineEqualTimes: boolean;
    /**
     * Character to use when {@link combineEqualTimes} is true.
     */
    combineEqualTimesSeparator: string;
    /**
     * Combine segments where speaker is the same and concatenated `body` fits in the {@link combineSegmentsLength}
     *
     * Can be used with {@link combineEqualTimes}. The {@link combineSegments} rule is applied first.
     *
     * Can be used with {@link speakerChange}. The {@link speakerChange} rule is applied last.
     *
     * Cannot be used with {@link combineSpeaker}
     */
    combineSegments: boolean;
    /**
     * Max length of body text to use when {@link combineSegments} is true
     */
    combineSegmentsLength: number;
    /**
     * Combine consecutive segments from the same speaker.
     *
     * Note: If this is enabled, {@link combineEqualTimes} and {@link combineSegments} will not be applied.
     *
     * Warning: if the transcript does not contain speaker information, resulting segment will contain entire transcript text.
     */
    combineSpeaker: boolean;
    /**
     * Only include {@link Segment.speaker} when speaker changes
     *
     * May be used in combination with {@link combineSpeaker}, {@link combineEqualTimes}, or {@link combineSegments}
     */
    speakerChange: boolean;
    /**
     * Create the options manager
     */
    constructor();
    /**
     * Get option value from it's name
     *
     * @param name name of option to get
     * @returns value of option. If unknown, returns undefined
     */
    getOptionByName: (name: string) => boolean | string | number;
    /**
     * Set option value using it's name
     *
     * @param name name of option to set
     * @param value value to set option to
     */
    setOptionByName: (name: string, value: boolean | string | number) => void;
    /**
     * Set all options to their default value
     */
    restoreDefaultSettings: () => void;
    /**
     * Set one or more options
     *
     * @param options the options to set
     * @param setDefault true: set all values to the default before setting values specified by `options`
     */
    setOptions: (options: IOptions, setDefault?: boolean) => void;
    /**
     * Helper to determine if at least one option should be applied
     *
     * @returns true: at least one option set
     */
    optionsSet: () => boolean;
}
export declare const Options: OptionsManager;
