import { Segment, TranscriptFormat } from "./types";
export { Segment, TranscriptFormat } from "./types";
export { TimestampFormatter, FormatterCallback } from "./timestamp";
export { Options, IOptions } from "./options";
/**
 * Determines the format of transcript by inspecting the data
 *
 * @param data The transcript data
 * @returns The determined transcript format
 * @throws {TypeError} Cannot determine format of data or error parsing data
 */
export declare const determineFormat: (data: string) => TranscriptFormat;
/**
 * Convert the data to an Array of {@link Segment}
 *
 * @param data The transcript data
 * @param transcriptFormat The format of the data.
 * @returns An Array of Segment objects from the parsed data
 * @throws {TypeError} When `transcriptFormat` is unknown
 */
export declare const convertFile: (data: string, transcriptFormat?: TranscriptFormat) => Array<Segment>;
