import { Segment } from "../types";
/**
 * Determines if the value of data is a valid HTML transcript format
 *
 * @param data The transcript data
 * @returns True: data is valid HTML transcript format
 */
export declare const isHTML: (data: string) => boolean;
/**
 * Parse HTML data to an Array of {@link Segment}
 *
 * @param data The transcript data
 * @returns An array of Segments from the parsed data
 * @throws {TypeError} When `data` is not valid HTML format
 */
export declare const parseHTML: (data: string) => Array<Segment>;
