import { Reducers, State } from '../default';
import Callback from '../types/callback';
import DispatchFunction from '../types/dispatch-function';
import Dispatcher, { ExtractArguments } from '../types/dispatcher';
import Dispatchers from '../types/dispatchers';
import Middleware, { MiddlewareCreator } from '../types/middleware';
import NewGlobalState, { FunctionalNewGlobalState } from '../types/new-global-state';
import Reducer, { AdditionalReducers } from '../types/reducer';
declare type BooleanFunction = () => boolean;
export declare type PropertyListener = () => void;
export declare const INVALID_NEW_GLOBAL_STATE: Error;
export default class GlobalStateManager<G extends {} = State, R extends {} = Reducers> {
    private _callbacks;
    private _dispatchers;
    private _initialReducers;
    private _initialState;
    private _middlewares;
    private _propertyListeners;
    private _queue;
    private _state;
    constructor(initialState?: G, initialReducers?: R);
    addCallback(callback: Callback<G>): BooleanFunction;
    addMiddleware(createMiddleware: MiddlewareCreator<G, R>): BooleanFunction;
    addPropertyListener(property: keyof G, propertyListener: PropertyListener): void;
    addReducer<A extends any[] = any[]>(name: string, reducer: Reducer<G, R, A>): BooleanFunction;
    addReducers(reducers: AdditionalReducers<G, R & any>): void;
    clearQueue(): void;
    createDispatcher<A extends any[] = []>(reducer: Reducer<G, R, A>, name?: string): Dispatcher<G, A>;
    get dispatcherMap(): DispatchFunction<G> & Dispatchers<G, R>;
    get dispatchers(): Dispatchers<G, R>;
    enqueue<Property extends keyof G>(property: Property, value: G[Property]): void;
    flush(reducerName?: string, reducerArgs?: any[]): Partial<G>;
    getDispatcher<K extends keyof R>(name: K): Dispatcher<G, ExtractArguments<R[K]>>;
    hasCallback(callback: Callback<G>): boolean;
    hasMiddleware(middleware: Middleware<G, R>): boolean;
    hasPropertyListener(pl: PropertyListener): boolean;
    hasDispatcher(name: keyof R | string): boolean;
    get queue(): Map<keyof G, G[keyof G]>;
    get propertyListeners(): Map<keyof G, Set<PropertyListener>>;
    removeCallback(callback: Callback<G>): boolean;
    removeDispatcher(name: string): boolean;
    removeMiddleware(middleware: Middleware<G, R>): boolean;
    removePropertyListener(propertyListener: PropertyListener): boolean;
    reset(): void;
    set(newGlobalState: NewGlobalState<G>, reducerName?: string, reducerArgs?: any[]): Promise<Partial<G>>;
    setFunction(f: FunctionalNewGlobalState<G>, reducerName?: string, reducerArgs?: any[]): Promise<Partial<G>>;
    setObject<O extends Partial<G> = Partial<G>>(obj: O, reducerName?: string, reducerArgs?: any[]): Promise<Partial<G>>;
    setPromise(promise: Promise<NewGlobalState<G>>, reducerName?: string, reducerArgs?: any[]): Promise<Partial<G>>;
    spyState(propertyListener: PropertyListener): G;
    get state(): Readonly<G>;
}
export {};
