/**
* Copyright (c) Facebook, Inc. and its affiliates.
*
* This source code is licensed under the MIT license found in the
* LICENSE file in the root directory of this source tree.
*
* @generated by codegen project: GenerateComponentHObjCpp.js
*/

#import <Foundation/Foundation.h>
#import <React/RCTDefines.h>
#import <React/RCTLog.h>

NS_ASSUME_NONNULL_BEGIN

@protocol RCTActivityIndicatorViewViewProtocol <NSObject>

@end

@protocol RCTDatePickerViewProtocol <NSObject>
- (void)setNativeDate:(float)date;
@end

RCT_EXTERN inline void RCTDatePickerHandleCommand(
  id<RCTDatePickerViewProtocol> componentView,
  NSString const *commandName,
  NSArray const *args)
{
  if ([commandName isEqualToString:@"setNativeDate"]) {
#if RCT_DEBUG
  if ([args count] != 1) {
    RCTLogError(@"%@ command %@ received %d arguments, expected %d.", @"DatePicker", commandName, (int)[args count], 1);
    return;
  }
#endif

  NSObject *arg0 = args[0];
#if RCT_DEBUG
  if (!RCTValidateTypeOfViewCommandArgument(arg0, [NSNumber class], @"float", @"DatePicker", commandName, @"1st")) {
    return;
  }
#endif
  float date = [(NSNumber *)arg0 floatValue];

  [componentView setNativeDate:date];
  return;
}

#if RCT_DEBUG
  RCTLogError(@"%@ received command %@, which is not a supported command.", @"DatePicker", commandName);
#endif
}

@protocol RCTAndroidDrawerLayoutViewProtocol <NSObject>
- (void)openDrawer;
- (void)closeDrawer;
@end

RCT_EXTERN inline void RCTAndroidDrawerLayoutHandleCommand(
  id<RCTAndroidDrawerLayoutViewProtocol> componentView,
  NSString const *commandName,
  NSArray const *args)
{
  if ([commandName isEqualToString:@"openDrawer"]) {
#if RCT_DEBUG
  if ([args count] != 0) {
    RCTLogError(@"%@ command %@ received %d arguments, expected %d.", @"AndroidDrawerLayout", commandName, (int)[args count], 0);
    return;
  }
#endif

  

  [componentView openDrawer];
  return;
}

if ([commandName isEqualToString:@"closeDrawer"]) {
#if RCT_DEBUG
  if ([args count] != 0) {
    RCTLogError(@"%@ command %@ received %d arguments, expected %d.", @"AndroidDrawerLayout", commandName, (int)[args count], 0);
    return;
  }
#endif

  

  [componentView closeDrawer];
  return;
}

#if RCT_DEBUG
  RCTLogError(@"%@ received command %@, which is not a supported command.", @"AndroidDrawerLayout", commandName);
#endif
}

@protocol RCTRCTMaskedViewViewProtocol <NSObject>

@end

@protocol RCTAndroidProgressBarViewProtocol <NSObject>

@end

@protocol RCTRCTProgressViewViewProtocol <NSObject>

@end

@protocol RCTAndroidSwipeRefreshLayoutViewProtocol <NSObject>
- (void)setNativeRefreshing:(BOOL)value;
@end

RCT_EXTERN inline void RCTAndroidSwipeRefreshLayoutHandleCommand(
  id<RCTAndroidSwipeRefreshLayoutViewProtocol> componentView,
  NSString const *commandName,
  NSArray const *args)
{
  if ([commandName isEqualToString:@"setNativeRefreshing"]) {
#if RCT_DEBUG
  if ([args count] != 1) {
    RCTLogError(@"%@ command %@ received %d arguments, expected %d.", @"AndroidSwipeRefreshLayout", commandName, (int)[args count], 1);
    return;
  }
#endif

  NSObject *arg0 = args[0];
#if RCT_DEBUG
  if (!RCTValidateTypeOfViewCommandArgument(arg0, [NSNumber class], @"boolean", @"AndroidSwipeRefreshLayout", commandName, @"1st")) {
    return;
  }
#endif
  BOOL value = [(NSNumber *)arg0 boolValue];

  [componentView setNativeRefreshing:value];
  return;
}

#if RCT_DEBUG
  RCTLogError(@"%@ received command %@, which is not a supported command.", @"AndroidSwipeRefreshLayout", commandName);
#endif
}

@protocol RCTPullToRefreshViewViewProtocol <NSObject>
- (void)setNativeRefreshing:(BOOL)refreshing;
@end

RCT_EXTERN inline void RCTPullToRefreshViewHandleCommand(
  id<RCTPullToRefreshViewViewProtocol> componentView,
  NSString const *commandName,
  NSArray const *args)
{
  if ([commandName isEqualToString:@"setNativeRefreshing"]) {
#if RCT_DEBUG
  if ([args count] != 1) {
    RCTLogError(@"%@ command %@ received %d arguments, expected %d.", @"PullToRefreshView", commandName, (int)[args count], 1);
    return;
  }
#endif

  NSObject *arg0 = args[0];
#if RCT_DEBUG
  if (!RCTValidateTypeOfViewCommandArgument(arg0, [NSNumber class], @"boolean", @"PullToRefreshView", commandName, @"1st")) {
    return;
  }
#endif
  BOOL refreshing = [(NSNumber *)arg0 boolValue];

  [componentView setNativeRefreshing:refreshing];
  return;
}

#if RCT_DEBUG
  RCTLogError(@"%@ received command %@, which is not a supported command.", @"PullToRefreshView", commandName);
#endif
}

@protocol RCTSafeAreaViewViewProtocol <NSObject>

@end

@protocol RCTAndroidHorizontalScrollContentViewViewProtocol <NSObject>

@end

@protocol RCTRCTSegmentedControlViewProtocol <NSObject>

@end

@protocol RCTSliderViewProtocol <NSObject>

@end

@protocol RCTAndroidSwitchViewProtocol <NSObject>
- (void)setNativeValue:(BOOL)value;
@end

RCT_EXTERN inline void RCTAndroidSwitchHandleCommand(
  id<RCTAndroidSwitchViewProtocol> componentView,
  NSString const *commandName,
  NSArray const *args)
{
  if ([commandName isEqualToString:@"setNativeValue"]) {
#if RCT_DEBUG
  if ([args count] != 1) {
    RCTLogError(@"%@ command %@ received %d arguments, expected %d.", @"AndroidSwitch", commandName, (int)[args count], 1);
    return;
  }
#endif

  NSObject *arg0 = args[0];
#if RCT_DEBUG
  if (!RCTValidateTypeOfViewCommandArgument(arg0, [NSNumber class], @"boolean", @"AndroidSwitch", commandName, @"1st")) {
    return;
  }
#endif
  BOOL value = [(NSNumber *)arg0 boolValue];

  [componentView setNativeValue:value];
  return;
}

#if RCT_DEBUG
  RCTLogError(@"%@ received command %@, which is not a supported command.", @"AndroidSwitch", commandName);
#endif
}

@protocol RCTSwitchViewProtocol <NSObject>
- (void)setValue:(BOOL)value;
@end

RCT_EXTERN inline void RCTSwitchHandleCommand(
  id<RCTSwitchViewProtocol> componentView,
  NSString const *commandName,
  NSArray const *args)
{
  if ([commandName isEqualToString:@"setValue"]) {
#if RCT_DEBUG
  if ([args count] != 1) {
    RCTLogError(@"%@ command %@ received %d arguments, expected %d.", @"Switch", commandName, (int)[args count], 1);
    return;
  }
#endif

  NSObject *arg0 = args[0];
#if RCT_DEBUG
  if (!RCTValidateTypeOfViewCommandArgument(arg0, [NSNumber class], @"boolean", @"Switch", commandName, @"1st")) {
    return;
  }
#endif
  BOOL value = [(NSNumber *)arg0 boolValue];

  [componentView setValue:value];
  return;
}

#if RCT_DEBUG
  RCTLogError(@"%@ received command %@, which is not a supported command.", @"Switch", commandName);
#endif
}

@protocol RCTInputAccessoryViewProtocol <NSObject>

@end

@protocol RCTUnimplementedNativeViewViewProtocol <NSObject>

@end

@protocol RCTModalHostViewViewProtocol <NSObject>

@end

NS_ASSUME_NONNULL_END