"use strict";var _interopRequireDefault=require("@babel/runtime/helpers/interopRequireDefault");var _interopRequireWildcard=require("@babel/runtime/helpers/interopRequireWildcard");Object.defineProperty(exports,"__esModule",{value:true});exports.SvgAst=SvgAst;exports.SvgXml=SvgXml;exports.fetchText=fetchText;exports.SvgUri=SvgUri;exports.getStyle=getStyle;exports.astToReact=astToReact;exports.parse=_parse;exports.camelCase=exports.SvgFromUri=exports.SvgFromXml=exports.err=exports.tags=void 0;var _classCallCheck2=_interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));var _createClass2=_interopRequireDefault(require("@babel/runtime/helpers/createClass"));var _possibleConstructorReturn2=_interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));var _getPrototypeOf4=_interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));var _assertThisInitialized2=_interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));var _inherits2=_interopRequireDefault(require("@babel/runtime/helpers/inherits"));var _defineProperty2=_interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));var _slicedToArray2=_interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));var _regenerator=_interopRequireDefault(require("@babel/runtime/regenerator"));var _extends2=_interopRequireDefault(require("@babel/runtime/helpers/extends"));var _react=_interopRequireWildcard(require("react"));var _Rect=_interopRequireDefault(require("./elements/Rect"));var _Circle=_interopRequireDefault(require("./elements/Circle"));var _Ellipse=_interopRequireDefault(require("./elements/Ellipse"));var _Polygon=_interopRequireDefault(require("./elements/Polygon"));var _Polyline=_interopRequireDefault(require("./elements/Polyline"));var _Line=_interopRequireDefault(require("./elements/Line"));var _Svg=_interopRequireDefault(require("./elements/Svg"));var _Path=_interopRequireDefault(require("./elements/Path"));var _G=_interopRequireDefault(require("./elements/G"));var _Text=_interopRequireDefault(require("./elements/Text"));var _TSpan=_interopRequireDefault(require("./elements/TSpan"));var _TextPath=_interopRequireDefault(require("./elements/TextPath"));var _Use=_interopRequireDefault(require("./elements/Use"));var _Image=_interopRequireDefault(require("./elements/Image"));var _Symbol=_interopRequireDefault(require("./elements/Symbol"));var _Defs=_interopRequireDefault(require("./elements/Defs"));var _LinearGradient=_interopRequireDefault(require("./elements/LinearGradient"));var _RadialGradient=_interopRequireDefault(require("./elements/RadialGradient"));var _Stop=_interopRequireDefault(require("./elements/Stop"));var _ClipPath=_interopRequireDefault(require("./elements/ClipPath"));var _Pattern=_interopRequireDefault(require("./elements/Pattern"));var _Mask=_interopRequireDefault(require("./elements/Mask"));var _Marker=_interopRequireDefault(require("./elements/Marker"));var _jsxFileName="/Users/horcrux/Work/react-native-svg/src/xml.tsx";var tags={svg:_Svg.default,circle:_Circle.default,ellipse:_Ellipse.default,g:_G.default,text:_Text.default,tspan:_TSpan.default,textPath:_TextPath.default,path:_Path.default,polygon:_Polygon.default,polyline:_Polyline.default,line:_Line.default,rect:_Rect.default,use:_Use.default,image:_Image.default,symbol:_Symbol.default,defs:_Defs.default,linearGradient:_LinearGradient.default,radialGradient:_RadialGradient.default,stop:_Stop.default,clipPath:_ClipPath.default,pattern:_Pattern.default,mask:_Mask.default,marker:_Marker.default};exports.tags=tags;function missingTag(){return null;}function SvgAst(_ref){var ast=_ref.ast,override=_ref.override;if(!ast){return null;}var props=ast.props,children=ast.children;return _react.default.createElement(_Svg.default,(0,_extends2.default)({},props,override,{__source:{fileName:_jsxFileName,lineNumber:103}}),children);}var err=console.error.bind(console);exports.err=err;function SvgXml(props){var _props$onError=props.onError,onError=_props$onError===void 0?err:_props$onError,xml=props.xml,override=props.override;var ast=(0,_react.useMemo)(function(){return xml!==null?_parse(xml):null;},[xml]);try{return _react.default.createElement(SvgAst,{ast:ast,override:override||props,__source:{fileName:_jsxFileName,lineNumber:118}});}catch(error){onError(error);return null;}}function fetchText(uri){var response;return _regenerator.default.async(function fetchText$(_context){while(1){switch(_context.prev=_context.next){case 0:_context.next=2;return _regenerator.default.awrap(fetch(uri));case 2:response=_context.sent;_context.next=5;return _regenerator.default.awrap(response.text());case 5:return _context.abrupt("return",_context.sent);case 6:case"end":return _context.stop();}}},null,null,null,Promise);}function SvgUri(props){var _props$onError2=props.onError,onError=_props$onError2===void 0?err:_props$onError2,uri=props.uri;var _useState=(0,_react.useState)(null),_useState2=(0,_slicedToArray2.default)(_useState,2),xml=_useState2[0],setXml=_useState2[1];(0,_react.useEffect)(function(){uri?fetchText(uri).then(setXml).catch(onError):setXml(null);},[onError,uri]);return _react.default.createElement(SvgXml,{xml:xml,override:props,__source:{fileName:_jsxFileName,lineNumber:140}});}var SvgFromXml=function(_Component){(0,_inherits2.default)(SvgFromXml,_Component);function SvgFromXml(){var _getPrototypeOf2;var _this;(0,_classCallCheck2.default)(this,SvgFromXml);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key];}_this=(0,_possibleConstructorReturn2.default)(this,(_getPrototypeOf2=(0,_getPrototypeOf4.default)(SvgFromXml)).call.apply(_getPrototypeOf2,[this].concat(args)));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"state",{ast:null});return _this;}(0,_createClass2.default)(SvgFromXml,[{key:"componentDidMount",value:function componentDidMount(){this.parse(this.props.xml);}},{key:"componentDidUpdate",value:function componentDidUpdate(prevProps){var xml=this.props.xml;if(xml!==prevProps.xml){this.parse(xml);}}},{key:"parse",value:function parse(xml){try{this.setState({ast:xml?_parse(xml):null});}catch(e){console.error(e);}}},{key:"render",value:function render(){var props=this.props,ast=this.state.ast;return _react.default.createElement(SvgAst,{ast:ast,override:props.override||props,__source:{fileName:_jsxFileName,lineNumber:168}});}}]);return SvgFromXml;}(_react.Component);exports.SvgFromXml=SvgFromXml;var SvgFromUri=function(_Component2){(0,_inherits2.default)(SvgFromUri,_Component2);function SvgFromUri(){var _getPrototypeOf3;var _this2;(0,_classCallCheck2.default)(this,SvgFromUri);for(var _len3=arguments.length,args=new Array(_len3),_key3=0;_key3<_len3;_key3++){args[_key3]=arguments[_key3];}_this2=(0,_possibleConstructorReturn2.default)(this,(_getPrototypeOf3=(0,_getPrototypeOf4.default)(SvgFromUri)).call.apply(_getPrototypeOf3,[this].concat(args)));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this2),"state",{xml:null});return _this2;}(0,_createClass2.default)(SvgFromUri,[{key:"componentDidMount",value:function componentDidMount(){this.fetch(this.props.uri);}},{key:"componentDidUpdate",value:function componentDidUpdate(prevProps){var uri=this.props.uri;if(uri!==prevProps.uri){this.fetch(uri);}}},{key:"fetch",value:function fetch(uri){return _regenerator.default.async(function fetch$(_context2){while(1){switch(_context2.prev=_context2.next){case 0:_context2.prev=0;_context2.t0=this;if(!uri){_context2.next=8;break;}_context2.next=5;return _regenerator.default.awrap(fetchText(uri));case 5:_context2.t1=_context2.sent;_context2.next=9;break;case 8:_context2.t1=null;case 9:_context2.t2=_context2.t1;_context2.t3={xml:_context2.t2};_context2.t0.setState.call(_context2.t0,_context2.t3);_context2.next=17;break;case 14:_context2.prev=14;_context2.t4=_context2["catch"](0);console.error(_context2.t4);case 17:case"end":return _context2.stop();}}},null,this,[[0,14]],Promise);}},{key:"render",value:function render(){var props=this.props,xml=this.state.xml;return _react.default.createElement(SvgFromXml,{xml:xml,override:props,__source:{fileName:_jsxFileName,lineNumber:195}});}}]);return SvgFromUri;}(_react.Component);exports.SvgFromUri=SvgFromUri;var upperCase=function upperCase(_match,letter){return letter.toUpperCase();};var camelCase=function camelCase(phrase){return phrase.replace(/[:-]([a-z])/g,upperCase);};exports.camelCase=camelCase;function getStyle(string){var style={};var declarations=string.split(';');var length=declarations.length;for(var i=0;i<length;i++){var declaration=declarations[i];if(declaration.length!==0){var split=declaration.split(':');var _property=split[0];var value=split[1];style[camelCase(_property.trim())]=value.trim();}}return style;}function astToReact(value,index){if(typeof value==='object'){var Tag=value.Tag,props=value.props,children=value.children;return _react.default.createElement(Tag,(0,_extends2.default)({key:index},props,{__source:{fileName:_jsxFileName,lineNumber:229}}),children.map(astToReact));}return value;}function repeat(str,i){var result='';while(i--){result+=str;}return result;}var toSpaces=function toSpaces(tabs){return repeat('  ',tabs.length);};function locate(source,i){var lines=source.split('\n');var nLines=lines.length;var column=i;var line=0;for(;line<nLines;line++){var length=lines[line].length;if(column>=length){column-=length;}else{break;}}var before=source.slice(0,i).replace(/^\t+/,toSpaces);var beforeExec=/(^|\n).*$/.exec(before);var beforeLine=beforeExec&&beforeExec[0]||'';var after=source.slice(i);var afterExec=/.*(\n|$)/.exec(after);var afterLine=afterExec&&afterExec[0];var pad=repeat(' ',beforeLine.length);var snippet="".concat(beforeLine).concat(afterLine,"\n").concat(pad,"^");return{line:line,column:column,snippet:snippet};}var validNameCharacters=/[a-zA-Z0-9:_-]/;var whitespace=/[\s\t\r\n]/;var quotemarks=/['"]/;function _parse(source,middleware){var length=source.length;var currentElement=null;var state=metadata;var children=null;var root;var stack=[];function error(message){var _locate=locate(source,i),line=_locate.line,column=_locate.column,snippet=_locate.snippet;throw new Error("".concat(message," (").concat(line,":").concat(column,"). If this is valid SVG, it's probably a bug. Please raise an issue\n\n").concat(snippet));}function metadata(){while(i+1<length&&(source[i]!=='<'||!validNameCharacters.test(source[i+1]))){i++;}return neutral();}function neutral(){var text='';var char;while(i<length&&(char=source[i])!=='<'){text+=char;i+=1;}if(/\S/.test(text)){children.push(text);}if(source[i]==='<'){return openingTag;}return neutral;}function openingTag(){var char=source[i];if(char==='?'){return neutral;}if(char==='!'){var start=i+1;if(source.slice(start,i+3)==='--'){return comment;}var end=i+8;if(source.slice(start,end)==='[CDATA['){return cdata;}if(/doctype/i.test(source.slice(start,end))){return neutral;}}if(char==='/'){return closingTag;}var tag=getName();var props={};var element={tag:tag,props:props,children:[],parent:currentElement,Tag:tags[tag]||missingTag};if(currentElement){children.push(element);}else{root=element;}getAttributes(props);var style=props.style;if(typeof style==='string'){element.styles=style;props.style=getStyle(style);}var selfClosing=false;if(source[i]==='/'){i+=1;selfClosing=true;}if(source[i]!=='>'){error('Expected >');}if(!selfClosing){currentElement=element;children=element.children;stack.push(element);}return neutral;}function comment(){var index=source.indexOf('-->',i);if(!~index){error('expected -->');}i=index+2;return neutral;}function cdata(){var index=source.indexOf(']]>',i);if(!~index){error('expected ]]>');}children.push(source.slice(i+7,index));i=index+2;return neutral;}function closingTag(){var tag=getName();if(!tag){error('Expected tag name');}if(currentElement&&tag!==currentElement.tag){error("Expected closing tag </".concat(tag,"> to match opening tag <").concat(currentElement.tag,">"));}if(source[i]!=='>'){error('Expected >');}stack.pop();currentElement=stack[stack.length-1];if(currentElement){var _currentElement=currentElement;children=_currentElement.children;}return neutral;}function getName(){var name='';var char;while(i<length&&validNameCharacters.test(char=source[i])){name+=char;i+=1;}return name;}function getAttributes(props){while(i<length){if(!whitespace.test(source[i])){return;}allowSpaces();var name=getName();if(!name){return;}var value=true;allowSpaces();if(source[i]==='='){i+=1;allowSpaces();value=getAttributeValue();if(!isNaN(+value)&&value.trim()!==''){value=+value;}}props[camelCase(name)]=value;}}function getAttributeValue(){return quotemarks.test(source[i])?getQuotedAttributeValue():getUnquotedAttributeValue();}function getUnquotedAttributeValue(){var value='';do{var char=source[i];if(char===' '||char==='>'||char==='/'){return value;}value+=char;i+=1;}while(i<length);return value;}function getQuotedAttributeValue(){var quotemark=source[i++];var value='';var escaped=false;while(i<length){var char=source[i++];if(char===quotemark&&!escaped){return value;}if(char==='\\'&&!escaped){escaped=true;}value+=escaped?"\\".concat(char):char;escaped=false;}return value;}function allowSpaces(){while(i<length&&whitespace.test(source[i])){i+=1;}}var i=0;while(i<length){if(!state){error('Unexpected character');}state=state();i+=1;}if(state!==neutral){error('Unexpected end of input');}if(root){var xml=(middleware?middleware(root):root)||root;var _ast=xml.children.map(astToReact);var jsx=xml;jsx.children=_ast;return jsx;}return null;}
//# sourceMappingURL=xml.js.map