function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import React from 'react';
import { Platform } from 'react-native';
import { Screen, ScreenContext } from 'react-native-screens'; // @ts-ignore file to be used only if `react-native-reanimated` available in the project

import Animated, { useEvent, useSharedValue } from 'react-native-reanimated';
import ReanimatedTransitionProgressContext from './ReanimatedTransitionProgressContext';
const AnimatedScreen = Animated.createAnimatedComponent(Screen);

class ReanimatedScreenWrapper extends React.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "ref", null);

    _defineProperty(this, "setRef", ref => {
      var _this$props$onCompone, _this$props;

      this.ref = ref;
      (_this$props$onCompone = (_this$props = this.props).onComponentRef) === null || _this$props$onCompone === void 0 ? void 0 : _this$props$onCompone.call(_this$props, ref);
    });
  }

  setNativeProps(props) {
    var _this$ref;

    (_this$ref = this.ref) === null || _this$ref === void 0 ? void 0 : _this$ref.setNativeProps(props);
  }

  render() {
    return /*#__PURE__*/React.createElement(ReanimatedScreen, _extends({}, this.props, {
      // @ts-ignore some problems with ref
      ref: this.setRef
    }));
  }

}

const ReanimatedScreen = /*#__PURE__*/React.forwardRef((props, ref) => {
  const {
    children,
    ...rest
  } = props;
  const progress = useSharedValue(0);
  const closing = useSharedValue(0);
  const goingForward = useSharedValue(0);
  return /*#__PURE__*/React.createElement(AnimatedScreen // @ts-ignore some problems with ref and onTransitionProgressReanimated being "fake" prop for parsing of `useEvent` return value
  , _extends({
    ref: ref // ReanimatedScreen.tsx should only be used by Screens of native-stack, but it always better to check
    ,
    onTransitionProgressReanimated: !props.isNativeStack ? undefined : useEvent(event => {
      'worklet';

      progress.value = event.progress;
      closing.value = event.closing;
      goingForward.value = event.goingForward;
    }, [// This should not be necessary, but is not properly managed by `react-native-reanimated`
    // @ts-ignore wrong type
    Platform.OS === 'android' ? 'onTransitionProgress' : 'topTransitionProgress'])
  }, rest), !props.isNativeStack ? // see comment of this prop in types.tsx for information why it is needed
  children : /*#__PURE__*/React.createElement(ReanimatedTransitionProgressContext.Provider, {
    value: {
      progress: progress,
      closing: closing,
      goingForward: goingForward
    }
  }, children));
}); // used to silence error "Component definition is missing display name"

ReanimatedScreen.displayName = 'ReanimatedScreen';
export default function ReanimatedScreenProvider(props) {
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    React.createElement(ScreenContext.Provider, {
      value: ReanimatedScreenWrapper
    }, props.children)
  );
}
//# sourceMappingURL=ReanimatedScreen.js.map