import { getCalendar, getCountry, getCurrencies, getLocales, getNumberFormatSettings, getTemperatureUnit, getTimeZone, uses24HourClock, usesAutoDateAndTime, usesAutoTimeZone, usesMetricSystem } from "./module";
import { LocalizationEvent } from "./types";
export declare function addEventListener(type: LocalizationEvent, handler: Function): void;
export declare function removeEventListener(type: LocalizationEvent, handler: Function): void;
export declare function findBestAvailableLanguage<T extends string>(languageTags: ReadonlyArray<T>): {
    languageTag: T;
    isRTL: boolean;
} | undefined;
export * from "./types";
export { getCalendar, getCountry, getCurrencies, getLocales, getNumberFormatSettings, getTemperatureUnit, getTimeZone, uses24HourClock, usesAutoDateAndTime, usesAutoTimeZone, usesMetricSystem, } from "./module";
declare const _default: {
    getCalendar: typeof getCalendar;
    getCountry: typeof getCountry;
    getCurrencies: typeof getCurrencies;
    getLocales: typeof getLocales;
    getNumberFormatSettings: typeof getNumberFormatSettings;
    getTemperatureUnit: typeof getTemperatureUnit;
    getTimeZone: typeof getTimeZone;
    uses24HourClock: typeof uses24HourClock;
    usesAutoDateAndTime: typeof usesAutoDateAndTime;
    usesAutoTimeZone: typeof usesAutoTimeZone;
    usesMetricSystem: typeof usesMetricSystem;
    findBestAvailableLanguage: typeof findBestAvailableLanguage;
    addEventListener: typeof addEventListener;
    removeEventListener: typeof removeEventListener;
};
export default _default;
