"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  addEventListener: true,
  removeEventListener: true,
  findBestAvailableLanguage: true,
  getCalendar: true,
  getCountry: true,
  getCurrencies: true,
  getLocales: true,
  getNumberFormatSettings: true,
  getTemperatureUnit: true,
  getTimeZone: true,
  uses24HourClock: true,
  usesAutoDateAndTime: true,
  usesAutoTimeZone: true,
  usesMetricSystem: true
};
exports.addEventListener = addEventListener;
exports.removeEventListener = removeEventListener;
exports.findBestAvailableLanguage = findBestAvailableLanguage;
Object.defineProperty(exports, "getCalendar", {
  enumerable: true,
  get: function () {
    return _module.getCalendar;
  }
});
Object.defineProperty(exports, "getCountry", {
  enumerable: true,
  get: function () {
    return _module.getCountry;
  }
});
Object.defineProperty(exports, "getCurrencies", {
  enumerable: true,
  get: function () {
    return _module.getCurrencies;
  }
});
Object.defineProperty(exports, "getLocales", {
  enumerable: true,
  get: function () {
    return _module.getLocales;
  }
});
Object.defineProperty(exports, "getNumberFormatSettings", {
  enumerable: true,
  get: function () {
    return _module.getNumberFormatSettings;
  }
});
Object.defineProperty(exports, "getTemperatureUnit", {
  enumerable: true,
  get: function () {
    return _module.getTemperatureUnit;
  }
});
Object.defineProperty(exports, "getTimeZone", {
  enumerable: true,
  get: function () {
    return _module.getTimeZone;
  }
});
Object.defineProperty(exports, "uses24HourClock", {
  enumerable: true,
  get: function () {
    return _module.uses24HourClock;
  }
});
Object.defineProperty(exports, "usesAutoDateAndTime", {
  enumerable: true,
  get: function () {
    return _module.usesAutoDateAndTime;
  }
});
Object.defineProperty(exports, "usesAutoTimeZone", {
  enumerable: true,
  get: function () {
    return _module.usesAutoTimeZone;
  }
});
Object.defineProperty(exports, "usesMetricSystem", {
  enumerable: true,
  get: function () {
    return _module.usesMetricSystem;
  }
});
exports.default = void 0;

var _module = require("./module");

var _types = require("./types");

Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});

function logUnknownEvent(type) {
  console.error(`\`${type}\` is not a valid react-native-localize event`);
}

function getPartialTag({
  languageCode,
  scriptCode
}) {
  return languageCode + (scriptCode ? "-" + scriptCode : "");
}

function addEventListener(type, handler) {
  if (type !== "change") {
    logUnknownEvent(type);
  } else if (!_module.handlers.has(handler)) {
    _module.handlers.add(handler);
  }
}

function removeEventListener(type, handler) {
  if (type !== "change") {
    logUnknownEvent(type);
  } else if (_module.handlers.has(handler)) {
    _module.handlers.delete(handler);
  }
}

function findBestAvailableLanguage(languageTags) {
  const locales = (0, _module.getLocales)();

  for (let i = 0; i < locales.length; i++) {
    const currentLocale = locales[i];
    const {
      languageTag,
      languageCode,
      isRTL
    } = currentLocale;

    if (languageTags.includes(languageTag)) {
      return {
        languageTag: languageTag,
        isRTL
      };
    }

    const partial = getPartialTag(currentLocale);
    const next = locales[i + 1];

    if ((!next || partial !== getPartialTag(next)) && languageTags.includes(partial)) {
      return {
        languageTag: partial,
        isRTL
      };
    }

    if ((!next || languageCode !== next.languageCode) && languageTags.includes(languageCode)) {
      return {
        languageTag: languageCode,
        isRTL
      };
    }
  }
}

var _default = {
  getCalendar: _module.getCalendar,
  getCountry: _module.getCountry,
  getCurrencies: _module.getCurrencies,
  getLocales: _module.getLocales,
  getNumberFormatSettings: _module.getNumberFormatSettings,
  getTemperatureUnit: _module.getTemperatureUnit,
  getTimeZone: _module.getTimeZone,
  uses24HourClock: _module.uses24HourClock,
  usesAutoDateAndTime: _module.usesAutoDateAndTime,
  usesAutoTimeZone: _module.usesAutoTimeZone,
  usesMetricSystem: _module.usesMetricSystem,
  findBestAvailableLanguage,
  addEventListener,
  removeEventListener
};
exports.default = _default;
//# sourceMappingURL=index.js.map