"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Util = void 0;

/**
 * Escape for use as literal string in a regex.
 */
function regexEscape(literal) {
  return literal.replace(/[\^$\\.*+?()[\]{}|]/g, '\\$&');
}
/**
 * Condense consecutive separators.
 */


function normalizeSeparator(path, separator) {
  const sepRe = new RegExp(`(${regexEscape(separator)}){2,}`, 'g');
  return path.replace(sepRe, separator.replace(/\$/g, '$$$$'));
}
/**
 * Split path on last separator.
 */


function splitPath(path, separator) {
  let norm = normalizeSeparator(path, separator);

  if (norm === separator) {
    return {
      dir: separator,
      base: ''
    };
  }

  if (norm.endsWith(separator)) {
    norm = norm.substring(0, norm.length - separator.length);
  }

  const idx = norm.lastIndexOf(separator);

  if (idx === -1) {
    return {
      dir: '.',
      base: norm
    };
  }

  return {
    dir: norm.substring(0, idx),
    base: norm.substring(idx + separator.length)
  };
}

const Util = {
  /**
   * Get the file/folder name from the end of the path.
   */
  basename(path, separator = '/') {
    return splitPath(path, separator).base;
  },

  /**
   * Get the path containing the file/folder.
   */
  dirname(path, separator = '/') {
    return splitPath(path, separator).dir;
  },

  /**
   * Get the file extension.
   */
  extname(path, separator = '/') {
    const extIdx = path.lastIndexOf('.');

    if (extIdx <= 0) {
      return '';
    }

    const sepIdx = path.lastIndexOf(separator);

    if (sepIdx === -1 || extIdx > sepIdx + separator.length) {
      return path.substring(extIdx + 1);
    }

    return '';
  }

};
exports.Util = Util;
//# sourceMappingURL=util.js.map