"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.capitalizeFirstLetter = exports.removeArticles = exports.parseCommaDelimitedNamesAndURLsString = exports.overrideImageUrlWithChapterImageUrl = exports.numberWithCommas = exports.encodeSpacesInString = exports.convertBytesToHumanReadableString = exports.checkIfIdMatchesClipIdOrEpisodeIdOrAddByUrl = void 0;
var checkIfIdMatchesClipIdOrEpisodeIdOrAddByUrl = function (id, clipId, episodeId, addByRSSPodcastFeedUrl) {
    var matches = false;
    if (addByRSSPodcastFeedUrl) {
        matches = addByRSSPodcastFeedUrl === id;
    }
    else if (clipId) {
        matches = clipId === id;
    }
    else if (episodeId) {
        matches = episodeId === id;
    }
    return matches;
};
exports.checkIfIdMatchesClipIdOrEpisodeIdOrAddByUrl = checkIfIdMatchesClipIdOrEpisodeIdOrAddByUrl;
var convertBytesToHumanReadableString = function (bytes) {
    var thresh = 1000;
    if (Math.abs(bytes) < thresh) {
        return bytes + ' B';
    }
    var units = ['kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
    var u = -1;
    do {
        bytes /= thresh;
        ++u;
    } while (Math.abs(bytes) >= thresh && u < units.length - 1);
    return bytes.toFixed(1) + ' ' + units[u];
};
exports.convertBytesToHumanReadableString = convertBytesToHumanReadableString;
var encodeSpacesInString = function (str) {
    return str.replace(/ /g, '%20');
};
exports.encodeSpacesInString = encodeSpacesInString;
var numberWithCommas = function (x) {
    if (!x || x === 0)
        return x;
    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
};
exports.numberWithCommas = numberWithCommas;
var overrideImageUrlWithChapterImageUrl = function (nowPlayingItem, currentChapter) {
    var imageUrl = nowPlayingItem ? nowPlayingItem.podcastImageUrl : '';
    if (nowPlayingItem && !nowPlayingItem.clipId && currentChapter && currentChapter.imageUrl) {
        imageUrl = currentChapter.imageUrl;
    }
    return imageUrl;
};
exports.overrideImageUrlWithChapterImageUrl = overrideImageUrlWithChapterImageUrl;
var parseCommaDelimitedNamesAndURLsString = function (str) {
    if (!str)
        return [];
    var arr = str.split(',');
    var persons = arr.map(function (str) {
        var name = '';
        var url = '';
        if (str.indexOf('<') && str.indexOf('>') > str.indexOf('<')) {
            name = str.substring(0, str.indexOf('<'));
            url = str.substring(str.indexOf('<') + 1, str.indexOf('>'));
        }
        else {
            name = str;
        }
        return { name: name, url: url };
    });
    return persons;
};
exports.parseCommaDelimitedNamesAndURLsString = parseCommaDelimitedNamesAndURLsString;
var removeArticles = function (str) {
    var words = str.split(' ');
    if (words.length <= 1)
        return str;
    if (words[0] === 'a' || words[0] === 'the' || words[0] === 'an') {
        return words.splice(1).join(' ');
    }
    return str;
};
exports.removeArticles = removeArticles;
var capitalizeFirstLetter = function (str) {
    str = str || '';
    return str.charAt(0).toUpperCase() + str.slice(1);
};
exports.capitalizeFirstLetter = capitalizeFirstLetter;
