"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLocationURL = exports.getExtensionFromUrl = exports.generateQueryParams = exports.createEmailLinkUrl = exports.convertUrlToSecureHTTPS = exports.addParameterToURL = void 0;
var addParameterToURL = function (uri, param) {
    uri += (uri.split('?')[1] ? '&' : '?') + param;
    return uri;
};
exports.addParameterToURL = addParameterToURL;
var convertUrlToSecureHTTPS = function (originalUrl) {
    return originalUrl ? originalUrl.replace('http://', 'https://') : '';
};
exports.convertUrlToSecureHTTPS = convertUrlToSecureHTTPS;
var createEmailLinkUrl = function (obj) {
    var str = 'mailto:' + obj.email + '?';
    str += encodeURI(obj.subject ? 'subject=' + obj.subject + '&' : '');
    str += encodeURI(obj.body ? 'body=' + obj.body : '');
    return str;
};
exports.createEmailLinkUrl = createEmailLinkUrl;
var generateQueryParams = function (query) {
    return Object.keys(query)
        .map(function (key) {
        return "".concat(key, "=").concat(query[key]);
    })
        .join('&');
};
exports.generateQueryParams = generateQueryParams;
var getExtensionFromUrl = function (url) {
    var path = url.split('?'); // Remove query params
    if (path[0]) {
        var filePathArr = path[0].split('/'); // Split url in paths
        if (filePathArr.length > 0) {
            var filePath = filePathArr.pop() || ''; // Grab last path in url
            if (filePath) {
                var extension = filePath.split('.').pop(); // Split last path in name.extension and grab extension
                return ".".concat(extension || 'mp3');
            }
        }
    }
    return '.mp3'; // If all else fails, assume mp3
};
exports.getExtensionFromUrl = getExtensionFromUrl;
// Function provided by Rems and mattdlockyer
// https://stackoverflow.com/questions/736513/how-do-i-parse-a-url-into-hostname-and-path-in-javascript
var getLocationURL = function (href) {
    var match = href.match(/^(https?\:)\/\/(([^:\/?#]*)(?:\:([0-9]+))?)([\/]{0,1}[^?#]*)(\?[^#]*|)(#.*|)$/);
    return match && {
        href: href,
        protocol: match[1],
        host: match[2],
        hostname: match[3],
        port: match[4],
        pathname: match[5],
        search: match[6],
        hash: match[7]
    };
};
exports.getLocationURL = getLocationURL;
