export type Transcript = {
    language?: string;
    rel?: string;
    type: TranscriptType;
    url: string;
};
export type TranscriptRow = {
    line?: number;
    startTime: number;
    startTimeFormatted: string | null;
    endTime: number;
    endTimeFormatted: string | null;
    body: string;
    speaker?: string;
};
export type TranscriptType = 'text/html' | 'application/json' | 'application/srt' | 'text/srt' | 'text/vtt' | 'application/x-subrip';
export declare const getTranscriptForLocale: (transcripts: Transcript[], locale: string) => Transcript | null;
export declare const parseTranscriptFile: (data: any, transcriptType: TranscriptType) => TranscriptRow[];
