"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertThreadcapResponseToPVComment = void 0;
var html_entities_1 = require("html-entities");
var striptags_1 = __importDefault(require("striptags"));
var ActivityPub_1 = require("./ActivityPub");
var urls_1 = require("../urls");
var parseUserInfo = function (comment, protocol, commenters) {
    var _a, _b;
    var username = '';
    var profileIcon = '';
    var commenter = commenters[comment.attributedTo];
    if (protocol === 'activitypub' || protocol === 'mastodon') {
        var url = (0, urls_1.getLocationURL)(comment.attributedTo);
        if (url) {
            var hostname = url.hostname;
            var segments = url.pathname.split('/');
            var last = segments.pop() || segments.pop(); // Handle potential trailing slash
            if (commenter === null || commenter === void 0 ? void 0 : commenter.fqUsername) {
                username = commenter.fqUsername;
            }
            else if (hostname && last) {
                username = "".concat(last, "@").concat(hostname);
            }
        }
        var isAllowedImageOrigin = (0, ActivityPub_1.checkIfAllowedImageOrigin)(commenter);
        if (isAllowedImageOrigin) {
            profileIcon = ((_a = commenter.icon) === null || _a === void 0 ? void 0 : _a.url) || '';
        }
    }
    else if (protocol === 'twitter') {
        username = commenter.fqUsername;
        profileIcon = ((_b = commenter.icon) === null || _b === void 0 ? void 0 : _b.url) || '';
    }
    return { profileIcon: profileIcon, username: username };
};
var getAttachmentImage = function (attachments) {
    return attachments === null || attachments === void 0 ? void 0 : attachments.find(function (attachment) { var _a; return ((_a = attachment === null || attachment === void 0 ? void 0 : attachment.mediaType) === null || _a === void 0 ? void 0 : _a.indexOf('image')) === 0; });
};
var decodeHtml = function (html) {
    if (html === void 0) { html = ''; }
    return (0, html_entities_1.decode)(html);
};
var convertThreadcapResponseToPVComment = function (response) {
    var commenters = response.commenters, nodes = response.nodes, protocol = response.protocol, roots = response.roots;
    var root = roots[0];
    var rootNode = nodes[root];
    var generatePVComment = function (node, protocol) {
        var comment = node.comment, replies = node.replies;
        var attachments = comment.attachments, content = comment.content, published = comment.published, url = comment.url;
        var nestedReplies = Array.isArray(replies)
            ? replies.map(function (replyUrl) {
                var nestedNode = nodes[replyUrl];
                var pvComment = null;
                if (nestedNode && !nestedNode.commentError) {
                    pvComment = generatePVComment(nestedNode, protocol);
                    return pvComment;
                }
            })
            : [];
        var contentKeys = content && typeof content === 'object' ? Object.keys(content) : [];
        var contentLangKey = contentKeys[0];
        var cleanedContent = contentLangKey ? decodeHtml((0, striptags_1.default)(content[contentLangKey])) : '';
        cleanedContent = (0, ActivityPub_1.removeUsernamesFromBeginningOfString)(cleanedContent);
        var attachmentImage = getAttachmentImage(attachments);
        var _a = parseUserInfo(comment, protocol, commenters), profileIcon = _a.profileIcon, username = _a.username;
        var pvComment = {
            content: cleanedContent,
            imageUrl: (attachmentImage === null || attachmentImage === void 0 ? void 0 : attachmentImage.url) || null,
            profileIcon: profileIcon,
            published: published,
            replies: nestedReplies,
            url: url,
            username: username
        };
        return pvComment;
    };
    var pvCommentThread = generatePVComment(rootNode, protocol);
    return pvCommentThread;
};
exports.convertThreadcapResponseToPVComment = convertThreadcapResponseToPVComment;
