"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SocialInteractionKeys = exports.checkIfHasSupportedCommentTag = void 0;
var checkIfHasSupportedCommentTag = function (episode) {
    return !!(episode.socialInteraction &&
        episode.socialInteraction.some(function (si) {
            return si.platform === 'activitypub' ||
                si.protocol === 'activitypub' ||
                si.platform === 'mastodon' ||
                si.platform === 'twitter' ||
                si.protocol === 'twitter';
        }));
};
exports.checkIfHasSupportedCommentTag = checkIfHasSupportedCommentTag;
exports.SocialInteractionKeys = {
    platform: {
        activitypub: 'activitypub',
        castopod: 'castopod',
        mastodon: 'mastodon',
        peertube: 'peertube',
        twitter: 'twitter'
    },
    protocol: {
        activitypub: 'activitypub',
        twitter: 'twitter'
    }
};
