"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSeasonOrSerialEpisodesData = void 0;
var orderBy_1 = __importDefault(require("lodash/orderBy"));
var _otherKey = 'otherKey';
var _trailerKey = 'trailer';
var _bonusKey = 'bonus';
var getSeasonOrSerialEpisodesData = function (_a) {
    var _b, _c;
    var data = _a.data, querySort = _a.querySort, extraParams = _a.extraParams, translator = _a.translator, _oldestKey = _a._oldestKey, _mostRecentKey = _a._mostRecentKey;
    var seasons = {};
    var seasonSections = [];
    var ascSort = 'asc';
    var descSort = 'desc';
    var newState = {
        hasSeasons: false,
        querySort: querySort,
        seasonSections: []
    };
    if (!querySort && extraParams.isSerial) {
        querySort = _oldestKey;
    }
    if (extraParams.hasSeasons) {
        for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
            var episode = data_1[_i];
            var seasonKey = parseInt(episode.itunesSeason, 10) >= 0 ? parseInt(episode.itunesSeason, 10) : _otherKey;
            if (episode.itunesEpisodeType === _bonusKey) {
                seasonKey = "".concat(seasonKey, "_").concat(_bonusKey);
            }
            var seasonEpisodes = seasons[seasonKey] || [];
            seasons[seasonKey] = seasonEpisodes;
            seasonEpisodes.push(episode);
            seasons[seasonKey] = seasonEpisodes;
        }
        var otherSection = { seasonKey: '', title: '', data: [], orderByNumber: 0 };
        var otherBonusSection = { seasonKey: '', title: '', data: [], orderByNumber: -1 };
        for (var seasonKey in seasons) {
            if (seasons.hasOwnProperty(seasonKey)) {
                var seasonNumber = seasonKey.split('_')[0];
                var orderByNumber = parseInt(seasonNumber, 10) || -1;
                var isBonus = seasonKey.split('_')[1] === _bonusKey;
                var isOther = seasonNumber === _otherKey;
                var title = "".concat(translator('Season'), " ").concat(seasonNumber);
                if (isBonus) {
                    orderByNumber = orderByNumber + 0.5;
                    var label = isOther ? translator('Other') : "".concat(translator('Season'), " ").concat(seasonNumber);
                    title = "".concat(label, " - ").concat(translator('Bonus'));
                }
                else if (isOther) {
                    // Other has the same orderByNumber as Other - Bonus (-0.5).
                    orderByNumber = -0.5;
                    title = translator('Other');
                }
                var section = {
                    orderByNumber: orderByNumber,
                    seasonKey: seasonKey,
                    title: title,
                    data: seasons[seasonKey]
                };
                if (isOther && isBonus) {
                    otherBonusSection = section;
                }
                else if (isOther) {
                    otherSection = section;
                }
                else {
                    seasonSections.push(section);
                }
            }
        }
        if (querySort === _mostRecentKey) {
            seasonSections = (0, orderBy_1.default)(seasonSections, ['orderByNumber'], [descSort]);
        }
        else if (querySort === _oldestKey) {
            seasonSections = (0, orderBy_1.default)(seasonSections, ['orderByNumber'], [ascSort]);
        }
        if (((_b = otherSection === null || otherSection === void 0 ? void 0 : otherSection.data) === null || _b === void 0 ? void 0 : _b.length) > 0) {
            seasonSections.push(otherSection);
        }
        if (((_c = otherBonusSection === null || otherBonusSection === void 0 ? void 0 : otherBonusSection.data) === null || _c === void 0 ? void 0 : _c.length) > 0) {
            seasonSections.push(otherBonusSection);
        }
        var customItunesEpisodeOrderBy = function (resultItem) {
            return resultItem.itunesEpisodeType === _trailerKey;
        };
        var finalSections = [];
        for (var _d = 0, seasonSections_1 = seasonSections; _d < seasonSections_1.length; _d++) {
            var section = seasonSections_1[_d];
            var data_2 = section.data;
            if (querySort === _mostRecentKey) {
                section.data = (0, orderBy_1.default)(data_2, [customItunesEpisodeOrderBy, 'itunesEpisode', 'pubDate'], [ascSort, descSort, descSort]);
            }
            else if (querySort === _oldestKey) {
                section.data = (0, orderBy_1.default)(data_2, [customItunesEpisodeOrderBy, 'itunesEpisode', 'pubDate'], [descSort, ascSort, ascSort]);
            }
            finalSections.push(section);
        }
        newState.seasonSections = finalSections;
        newState.hasSeasons = true;
    }
    newState.querySort = querySort;
    return newState;
};
exports.getSeasonOrSerialEpisodesData = getSeasonOrSerialEpisodesData;
