"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseTranslatorsSection = void 0;
var parseTranslatorsSection = function (language, str) {
    var splits = str.split(",");
    var translatorsSection = {
        language: language,
        translators: [],
    };
    for (var _i = 0, splits_1 = splits; _i < splits_1.length; _i++) {
        var split = splits_1[_i];
        var name_1 = split || '';
        // eslint-disable-next-line @typescript-eslint/prefer-regexp-exec
        var regexResults = name_1.match(new RegExp("<(.*?)>"));
        var url = regexResults && regexResults[1];
        var translator = {
            name: url && regexResults && name_1 ? name_1.substring(0, regexResults.index).trim() : name_1.trim(),
            url: url,
        };
        if (translator.name) {
            translatorsSection.translators.push(translator);
        }
    }
    return translatorsSection;
};
exports.parseTranslatorsSection = parseTranslatorsSection;
