"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseLatestLiveItemInfo = exports.parseLatestLiveItemStatus = void 0;
var parseLatestLiveItemStatus = function (parsedLiveItemEpisodes) {
    var _a;
    var latestLiveItemStatus = 'none';
    for (var _i = 0, parsedLiveItemEpisodes_1 = parsedLiveItemEpisodes; _i < parsedLiveItemEpisodes_1.length; _i++) {
        var parsedLiveItemEpisode = parsedLiveItemEpisodes_1[_i];
        var liveItemStatus = (_a = parsedLiveItemEpisode.liveItemStatus) === null || _a === void 0 ? void 0 : _a.toLowerCase();
        if (liveItemStatus === 'live') {
            latestLiveItemStatus = 'live';
            break;
        }
        else if (liveItemStatus === 'pending'
            && latestLiveItemStatus !== 'live') {
            latestLiveItemStatus = 'pending';
        }
        else if (liveItemStatus === 'ended'
            && latestLiveItemStatus !== 'live'
            && latestLiveItemStatus !== 'pending') {
            latestLiveItemStatus = 'ended';
        }
    }
    return latestLiveItemStatus;
};
exports.parseLatestLiveItemStatus = parseLatestLiveItemStatus;
var parseLatestLiveItemInfo = function (parsedLiveItemEpisodes) {
    var _a;
    var liveItemLatestPubDate = null;
    var liveItemLatestTitle = '';
    var liveItemLatestImageUrl = '';
    for (var _i = 0, parsedLiveItemEpisodes_2 = parsedLiveItemEpisodes; _i < parsedLiveItemEpisodes_2.length; _i++) {
        var parsedLiveItemEpisode = parsedLiveItemEpisodes_2[_i];
        var liveItemStatus = (_a = parsedLiveItemEpisode.liveItemStatus) === null || _a === void 0 ? void 0 : _a.toLowerCase();
        if (liveItemStatus === 'live'
            && (!liveItemLatestPubDate
                || new Date(parsedLiveItemEpisode.liveItemStart) > new Date(liveItemLatestPubDate))) {
            liveItemLatestPubDate = parsedLiveItemEpisode.liveItemStart;
            liveItemLatestTitle = parsedLiveItemEpisode.title || 'Untitled Livestream';
            liveItemLatestImageUrl = parsedLiveItemEpisode.imageURL || '';
        }
    }
    return { liveItemLatestImageUrl: liveItemLatestImageUrl, liveItemLatestPubDate: liveItemLatestPubDate, liveItemLatestTitle: liveItemLatestTitle };
};
exports.parseLatestLiveItemInfo = parseLatestLiveItemInfo;
