import { Episode, ParsedEpisode } from ".";
export type LiveItemStatus = 'pending' | 'live' | 'ended' | 'none';
export type LiveItem = {
    status: LiveItemStatus;
    start: Date;
    end: Date | null;
    episode: Episode;
    chatIRCURL: string | null;
};
export declare const parseLatestLiveItemStatus: (parsedLiveItemEpisodes: ParsedEpisode[]) => LiveItemStatus;
export declare const parseLatestLiveItemInfo: (parsedLiveItemEpisodes: ParsedEpisode[]) => {
    liveItemLatestImageUrl: string;
    liveItemLatestPubDate: Date | null | undefined;
    liveItemLatestTitle: string;
};
