"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateCategoryItems = exports.generateCategoriesText = void 0;
var generateCategoriesText = function (categories) {
    var categoryText = '';
    if (categories) {
        for (var i = 0; i < categories.length; i++) {
            var category = categories[i];
            categoryText += "".concat(category.title).concat(i < categories.length - 1 ? ', ' : '');
        }
    }
    return categoryText;
};
exports.generateCategoriesText = generateCategoriesText;
var generateCategoryItems = function (categories) {
    var items = [];
    if (categories && categories.length > 0) {
        for (var _i = 0, categories_1 = categories; _i < categories_1.length; _i++) {
            var category = categories_1[_i];
            items.push({
                label: category === null || category === void 0 ? void 0 : category.title,
                value: category === null || category === void 0 ? void 0 : category.id
            });
        }
    }
    return items;
};
exports.generateCategoryItems = generateCategoryItems;
