"use strict";
/* eslint-disable @typescript-eslint/no-unsafe-return */
/* eslint-disable @typescript-eslint/restrict-plus-operands */
/* eslint-disable sonarjs/no-duplicate-string */
/* eslint-disable @typescript-eslint/no-unsafe-assignment */
/* eslint-disable sonarjs/no-identical-functions */
/* eslint-disable @typescript-eslint/no-unsafe-member-access */
/* eslint-disable @typescript-eslint/no-unsafe-call */
/* eslint-disable sonarjs/cognitive-complexity */
/* eslint-disable @typescript-eslint/explicit-function-return-type */
/* eslint-disable @typescript-eslint/explicit-module-boundary-types */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unifiedParser = void 0;
const mergeWith_1 = __importDefault(require("ramda/src/mergeWith"));
const concat_1 = __importDefault(require("ramda/src/concat"));
const mergeDeepRight_1 = __importDefault(require("ramda/src/mergeDeepRight"));
const logger_1 = require("../logger");
const shared_1 = require("./shared");
const phase_1 = require("./phase");
const item_1 = require("./item");
const feed_1 = require("./feed");
function unifiedParser(theFeed, type, options) {
    const epochDate = new Date(0);
    if (typeof theFeed.rss.channel === "undefined") {
        logger_1.logger.warn("Provided XML has no channel node, unparsable");
        return null;
    }
    let feedObj = feed_1.handleFeed(theFeed.rss.channel, type);
    let phaseSupport = {};
    // Feed Phase Support
    const feedResult = phase_1.updateFeed(theFeed);
    feedObj = mergeWith_1.default(concat_1.default, feedObj, feedResult.feedUpdate);
    phaseSupport = mergeDeepRight_1.default(phaseSupport, feedResult.phaseUpdate);
    //------------------------------------------------------------------------
    // Are there even any items to get
    if (typeof theFeed.rss.channel.item !== "undefined") {
        // Items
        feedObj.items = shared_1.ensureArray(theFeed.rss.channel.item)
            .map((item) => {
            if (!item_1.isValidItem(item, options)) {
                return undefined;
            }
            let newFeedItem = item_1.handleItem(item, feedObj);
            // Item Phase Support
            const itemResult = phase_1.updateItem(item, theFeed);
            newFeedItem = mergeWith_1.default(concat_1.default, newFeedItem, itemResult.itemUpdate);
            phaseSupport = mergeDeepRight_1.default(phaseSupport, itemResult.phaseUpdate);
            // Value Block Fallback
            if (!newFeedItem.value && feedObj.value) {
                newFeedItem.value = feedObj.value;
            }
            return newFeedItem;
        })
            .filter((x) => x);
        feedObj.newestItemPubDate = feedObj.items.reduce((oldestDate, currEpisode) => currEpisode.pubDate && currEpisode.pubDate > oldestDate ? currEpisode.pubDate : oldestDate, epochDate);
        feedObj.oldestItemPubDate = feedObj.items.reduce((newestDate, currEpisode) => currEpisode.pubDate && currEpisode.pubDate < newestDate ? currEpisode.pubDate : newestDate, feedObj.newestItemPubDate);
    }
    else {
        logger_1.logger.warn("Provided feed has no items to parse.");
    }
    if (feedObj.newestItemPubDate && !feedObj.pubDate) {
        feedObj.pubDate = feedObj.newestItemPubDate;
    }
    if (Object.keys(phaseSupport).length > 0) {
        feedObj.pc20support = Object.entries(phaseSupport).reduce((phases, [phase, kv]) => ({ ...phases, [phase]: Object.keys(kv) }), {});
    }
    return feedObj;
}
exports.unifiedParser = unifiedParser;
//# sourceMappingURL=unified.js.map