import type { EmptyObj } from "./types";
export declare function sanitizeUrl(url?: string): string;
export declare function pubDateToTimestamp(pubDate: number | string | Date): number;
export declare function pubDateToDate(pubDate: number | string | Date): Date | null;
export declare function guessEnclosureType(url?: string): string;
export declare function timeToSeconds(timeString: string): number;
export declare function isNotUndefined<T>(x: T | undefined): x is T;
/** Returns the first value from an array, otherwise, passes the value through */
export declare function firstIfArray<T>(maybeArr: T | T[]): T;
export declare function firstWithValue<T>(maybeArr: T | T[]): T | null;
export declare function firstWithAttributes<T>(maybeArr: T | T[], attrs: string[]): T | null;
/** Will pass through the value if its an array, otherwise, will wrap the value as an array */
export declare function ensureArray<T>(maybeArr: T | T[]): T[];
/** Gets the value of the XML node as text */
export declare function getText(node: {
    "#text": string;
} | string, { sanitize }?: {
    sanitize?: boolean;
}): string;
export declare function sanitizeNewLines(text: string): string;
export declare function sanitizeMultipleSpaces(text: string): string;
export declare function sanitizeText(text: string): string;
/** Gets the value of the XML node as a number */
export declare function getNumber(node: {
    "#text": number;
} | number): number | null;
/** Gets the attribute value from a give node. Returns null if the attribute does not exist */
export declare function getAttribute(node: {
    attr: Record<string, string>;
}, name: string): string | null;
/** Gets the attribute value from a give node. Returns false if the attribute does not exist */
export declare function getBooleanAttribute(node: {
    attr: Record<string, string>;
}, name: string): boolean;
/** Gets the attribute value from a give node. It will throw if the attribute does not exist */
export declare function getKnownAttribute(node: {
    attr: Record<string, string>;
}, name: string): string;
export declare function extractOptionalStringAttribute(node: {
    attr: Record<string, string>;
}, attrName: string, key?: string): EmptyObj | {
    [key: string]: string;
};
export declare function extractOptionalIntegerAttribute(node: {
    attr: Record<string, string>;
}, attrName: string, key?: string): EmptyObj | {
    [key: string]: number;
};
declare type StringEnum = {
    [key: string]: any;
};
export declare function lookup<E extends StringEnum>(stringEnum: E, s: string): E[keyof E] | undefined;
export declare function knownLookup<E extends StringEnum>(stringEnum: E, s: string): E[keyof E];
export declare function extractOptionalFloatAttribute(node: {
    attr: Record<string, string>;
}, attrName: string, key?: string): EmptyObj | {
    [key: string]: number;
};
export {};
