"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.podcastGateway = exports.podcastRecommendations = exports.socialInteraction = exports.social = exports.id = void 0;
const shared_1 = require("../shared");
const types_1 = require("./types");
exports.id = {
    phase: Infinity,
    tag: "podcast:id",
    name: "id",
    nodeTransform: shared_1.ensureArray,
    supportCheck: (node) => node.some((n) => Boolean(shared_1.getAttribute(n, "platform")) && Boolean(shared_1.getAttribute(n, "url"))),
    fn(node) {
        return {
            podcastId: node
                .map((n) => ({
                platform: shared_1.getAttribute(n, "platform"),
                url: shared_1.getAttribute(n, "url"),
                ...shared_1.extractOptionalStringAttribute(n, "id"),
            }))
                .filter((x) => Boolean(x.platform) && Boolean(x.url)),
        };
    },
};
exports.social = {
    phase: Infinity,
    tag: "podcast:social",
    name: "social",
    nodeTransform: shared_1.ensureArray,
    supportCheck: (node, type) => type === types_1.XmlNodeSource.Feed &&
        node.some((n) => Boolean(shared_1.getAttribute(n, "platform")) &&
            (Boolean(shared_1.getAttribute(n, "url")) || Boolean(shared_1.getAttribute(n, "podcastAccountUrl")))),
    fn(node) {
        const isValidFeedNode = (n) => Boolean(shared_1.getAttribute(n, "platform")) &&
            (Boolean(shared_1.getAttribute(n, "url")) || Boolean(shared_1.getAttribute(n, "podcastAccountUrl")));
        return {
            podcastSocial: node.reduce((acc, n) => {
                const url = shared_1.getAttribute(n, "url") || shared_1.getAttribute(n, "podcastAccountUrl");
                if (isValidFeedNode(n) && url) {
                    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
                    const signUps = shared_1.ensureArray(n["podcast:socialSignUp"]);
                    const name = shared_1.getText(n);
                    const signUp = signUps.length > 0
                        ? {
                            signUp: signUps.reduce((signUpAcc, signUpNode) => {
                                if (shared_1.getAttribute(signUpNode, "signUpUrl") &&
                                    shared_1.getAttribute(signUpNode, "homeUrl")) {
                                    return [
                                        ...signUpAcc,
                                        {
                                            signUpUrl: shared_1.getKnownAttribute(signUpNode, "signUpUrl"),
                                            homeUrl: shared_1.getKnownAttribute(signUpNode, "homeUrl"),
                                            ...shared_1.extractOptionalFloatAttribute(signUpNode, "priority"),
                                        },
                                    ];
                                }
                                return signUpAcc;
                            }, []),
                        }
                        : undefined;
                    return [
                        ...acc,
                        {
                            url,
                            platform: shared_1.getKnownAttribute(n, "platform"),
                            ...(name ? { name } : undefined),
                            ...shared_1.extractOptionalStringAttribute(n, "podcastAccountId", "id"),
                            ...shared_1.extractOptionalFloatAttribute(n, "priority"),
                            ...signUp,
                        },
                    ];
                }
                return acc;
            }, []),
        };
    },
};
function getSocialPlatform(n) {
    var _a;
    return (_a = (shared_1.getAttribute(n, "platform") || shared_1.getAttribute(n, "protocol"))) !== null && _a !== void 0 ? _a : null;
}
function getSocialAccount(n) {
    var _a;
    return (_a = (shared_1.getAttribute(n, "podcastAccountId") || shared_1.getAttribute(n, "accountId"))) !== null && _a !== void 0 ? _a : null;
}
function getSocialUrl(n) {
    var _a;
    return (_a = (shared_1.getAttribute(n, "uri") || shared_1.getText(n))) !== null && _a !== void 0 ? _a : null;
}
function getSocialProfileUrl(n) {
    var _a;
    return (_a = shared_1.getAttribute(n, "accountUrl")) !== null && _a !== void 0 ? _a : null;
}
exports.socialInteraction = {
    phase: Infinity,
    name: "social",
    tag: "podcast:socialInteract",
    nodeTransform: shared_1.ensureArray,
    supportCheck: (node, type) => type === types_1.XmlNodeSource.Item &&
        node.some((n) => Boolean(getSocialPlatform(n)) && Boolean(getSocialUrl(n))),
    fn(node) {
        const isValidItemNode = (n) => Boolean(getSocialPlatform(n)) && Boolean(getSocialUrl(n));
        return {
            podcastSocialInteraction: node.reduce((acc, n) => {
                var _a;
                if (isValidItemNode(n)) {
                    const profileUrl = getSocialProfileUrl(n);
                    const pubDateText = shared_1.getAttribute(n, "pubDate");
                    const pubDateAsDate = pubDateText && shared_1.pubDateToDate(pubDateText);
                    return [
                        ...acc,
                        {
                            platform: getSocialPlatform(n),
                            id: (_a = getSocialAccount(n)) !== null && _a !== void 0 ? _a : "",
                            url: getSocialUrl(n),
                            ...shared_1.extractOptionalFloatAttribute(n, "priority"),
                            ...(pubDateAsDate ? { pubDate: pubDateAsDate } : undefined),
                            ...(profileUrl ? { profileUrl } : undefined),
                        },
                    ];
                }
                return acc;
            }, []),
        };
    },
};
exports.podcastRecommendations = {
    phase: Infinity,
    name: "recommendations",
    tag: "podcast:recommendations",
    nodeTransform: (node) => 
    // eslint-disable-next-line @typescript-eslint/no-unsafe-return
    shared_1.ensureArray(node).filter((n) => shared_1.getAttribute(n, "url") && shared_1.getAttribute(n, "type")),
    supportCheck: (node) => node.length > 0,
    fn(node) {
        return {
            podcastRecommendations: node.map((n) => ({
                url: shared_1.getKnownAttribute(n, "url"),
                type: shared_1.getKnownAttribute(n, "type"),
                ...shared_1.extractOptionalStringAttribute(n, "language"),
                ...(shared_1.getText(n) ? { text: shared_1.getText(n) } : undefined),
            })),
        };
    },
};
exports.podcastGateway = {
    phase: Infinity,
    name: "gateway",
    tag: "podcast:gateway",
    nodeTransform: (node) => 
    // eslint-disable-next-line @typescript-eslint/no-unsafe-return
    shared_1.ensureArray(node).find((n) => shared_1.getText(n)),
    supportCheck: (node) => Boolean(shared_1.getText(node)),
    fn(node) {
        return {
            podcastGateway: {
                message: shared_1.getText(node),
                ...shared_1.extractOptionalIntegerAttribute(node, "order"),
            },
        };
    },
};
//# sourceMappingURL=phase-pending.js.map