import { ensureArray } from "../shared";
import type { XmlNode } from "../types";
import { XmlNodeSource } from "./types";
export declare type PhasePendingPodcastId = {
    platform: string;
    url: string;
    id?: string;
};
export declare const id: {
    phase: number;
    tag: string;
    name: string;
    nodeTransform: typeof ensureArray;
    supportCheck: (node: XmlNode[]) => boolean;
    fn(node: XmlNode[]): {
        podcastId: PhasePendingPodcastId[];
    };
};
export declare type PhasePendingSocial = {
    platform: string;
    url: string;
    id?: string;
    name?: string;
    priority?: number;
    signUp?: SocialSignUp[];
};
declare type SocialSignUp = {
    homeUrl: string;
    signUpUrl: string;
    priority?: number;
};
export declare const social: {
    phase: number;
    tag: string;
    name: string;
    nodeTransform: typeof ensureArray;
    supportCheck: (node: XmlNode[], type: XmlNodeSource) => boolean;
    fn(node: XmlNode[]): {
        podcastSocial: PhasePendingSocial[];
    };
};
export declare type PhasePendingSocialInteract = {
    /** slug of social protocol being used */
    platform: string;
    /** account id of posting party */
    id: string;
    /** uri of root post/comment */
    url: string;
    /** url to posting party's platform profile */
    profileUrl?: string;
    /** DEPRECATED */
    pubDate?: Date;
    /** the order of rendering */
    priority?: number;
};
export declare const socialInteraction: {
    phase: number;
    name: string;
    tag: string;
    nodeTransform: typeof ensureArray;
    supportCheck: (node: XmlNode[], type: XmlNodeSource) => boolean;
    fn(node: XmlNode[]): {
        podcastSocialInteraction: PhasePendingSocialInteract[];
    };
};
export declare type PhasePendingPodcastRecommendation = {
    url: string;
    type: string;
    language?: string;
    text?: string;
};
export declare const podcastRecommendations: {
    phase: number;
    name: string;
    tag: string;
    nodeTransform: (node: XmlNode | XmlNode[]) => XmlNode;
    supportCheck: (node: XmlNode[]) => boolean;
    fn(node: XmlNode[]): {
        podcastRecommendations: PhasePendingPodcastRecommendation[];
    };
};
export declare type PhasePendingGateway = {
    order?: number;
    message: string;
};
export declare const podcastGateway: {
    phase: number;
    name: string;
    tag: string;
    nodeTransform: (node: XmlNode | XmlNode[]) => XmlNode;
    supportCheck: (node: XmlNode) => boolean;
    fn(node: XmlNode): {
        podcastGateway: PhasePendingGateway;
    };
};
export {};
