"use strict";
/* eslint-disable @typescript-eslint/no-unsafe-member-access */
/* eslint-disable @typescript-eslint/no-unsafe-assignment */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateItem = exports.updateFeed = exports.defaultSupportCheck = exports.defaultNodeTransform = void 0;
const concat_1 = __importDefault(require("ramda/src/concat"));
const mergeDeepRight_1 = __importDefault(require("ramda/src/mergeDeepRight"));
const mergeWith_1 = __importDefault(require("ramda/src/mergeWith"));
const logger_1 = require("../../logger");
const phase1 = __importStar(require("./phase-1"));
const phase2 = __importStar(require("./phase-2"));
const phase3 = __importStar(require("./phase-3"));
const phase4 = __importStar(require("./phase-4"));
const pending = __importStar(require("./phase-pending"));
const types_1 = require("./types");
// eslint-disable-next-line @typescript-eslint/no-unsafe-return
const defaultNodeTransform = (x) => x;
exports.defaultNodeTransform = defaultNodeTransform;
const defaultSupportCheck = (x) => typeof x === "object";
exports.defaultSupportCheck = defaultSupportCheck;
const feeds = [
    phase1.locked,
    phase1.funding,
    phase2.person,
    phase2.location,
    phase3.trailer,
    phase3.license,
    phase3.guid,
    phase4.value,
    phase4.medium,
    phase4.podcastImages,
    phase4.liveItem,
    pending.id,
    pending.social,
    pending.podcastRecommendations,
];
const items = [
    phase1.transcript,
    phase1.chapters,
    phase1.soundbite,
    phase2.person,
    phase2.location,
    phase2.season,
    phase2.episode,
    phase3.license,
    phase3.alternativeEnclosure,
    phase4.value,
    phase4.podcastImages,
    pending.socialInteraction,
    pending.podcastRecommendations,
    pending.podcastGateway,
];
function updateFeed(theFeed, feedUpdates = feeds) {
    return feedUpdates.reduce(({ feedUpdate, phaseUpdate }, { phase, tag, fn, nodeTransform, supportCheck, name }) => {
        const tagName = tag;
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        const node = (nodeTransform !== null && nodeTransform !== void 0 ? nodeTransform : exports.defaultNodeTransform)(theFeed.rss.channel[tagName]);
        logger_1.logger.trace(`Checking feed ${tagName} support`);
        const tagSupported = node && (supportCheck !== null && supportCheck !== void 0 ? supportCheck : exports.defaultSupportCheck)(node, types_1.XmlNodeSource.Feed);
        if (tagSupported) {
            logger_1.logger.info(`Feed supports ${tagName}`);
            try {
                const feedResult = fn(node, theFeed, types_1.XmlNodeSource.Feed);
                logger_1.logger.debug(feedResult, `Feed update for ${tagName}`);
                return {
                    feedUpdate: mergeWith_1.default(concat_1.default, feedUpdate, feedResult),
                    phaseUpdate: mergeDeepRight_1.default(phaseUpdate, { [phase]: { [name !== null && name !== void 0 ? name : tag]: true } }),
                };
            }
            catch (err) {
                logger_1.logger.warn(err, `Exception thrown while trying to parse feed tag ${tagName}`);
            }
        }
        logger_1.logger.trace(`Feed doesn't support ${tagName}`, node, tagSupported);
        return {
            feedUpdate,
            phaseUpdate,
        };
    }, {
        feedUpdate: {},
        phaseUpdate: {},
    });
}
exports.updateFeed = updateFeed;
function updateItem(item, feed, itemUpdates = items) {
    return itemUpdates.reduce(({ itemUpdate, phaseUpdate }, { phase, tag, fn, nodeTransform, supportCheck, name }) => {
        const tagName = tag;
        logger_1.logger.trace(`Checking feed item ${tagName} support`);
        const node = (nodeTransform !== null && nodeTransform !== void 0 ? nodeTransform : exports.defaultNodeTransform)(item[tagName]);
        const tagSupported = node && (supportCheck !== null && supportCheck !== void 0 ? supportCheck : exports.defaultSupportCheck)(node, types_1.XmlNodeSource.Item);
        if (tagSupported) {
            logger_1.logger.info(`Feed item supports ${tagName}`);
            try {
                const itemResult = fn(node, feed, types_1.XmlNodeSource.Item);
                logger_1.logger.debug(itemResult, `Item update for ${tagName}`);
                return {
                    itemUpdate: mergeWith_1.default(concat_1.default, itemUpdate, itemResult),
                    phaseUpdate: mergeDeepRight_1.default(phaseUpdate, { [phase]: { [name !== null && name !== void 0 ? name : tag]: true } }),
                };
            }
            catch (err) {
                logger_1.logger.warn(err, `Exception thrown while trying to parse item tag ${tagName}`);
            }
        }
        logger_1.logger.trace(`Feed item doesn't support ${tagName}`, node, tagSupported);
        return {
            itemUpdate,
            phaseUpdate,
        };
    }, {
        itemUpdate: {},
        phaseUpdate: {},
    });
}
exports.updateItem = updateItem;
//# sourceMappingURL=index.js.map