import type { Enclosure, Episode, FeedObject, XmlNode } from "./types";
export declare enum ItunesEpisodeType {
    Full = "full",
    Trailer = "trailer",
    Bonus = "bonus"
}
export declare function isValidItem(item: XmlNode, { allowMissingGuid }?: {
    allowMissingGuid?: boolean;
}): boolean;
/** If an item guid is empty, its considered invalid and will be skipped */
export declare function getGuid(item: XmlNode): string;
export declare function getEnclosure(item: XmlNode): Enclosure | null;
export declare function getAuthor(item: XmlNode): undefined | {
    author: string;
};
export declare function getTitle(item: XmlNode): undefined | {
    title: string;
};
export declare function getDescription(item: XmlNode): undefined | {
    description: string;
};
export declare function getContent(item: XmlNode): undefined | {
    content: string;
};
export declare function getLink(item: XmlNode): undefined | {
    link: string;
};
export declare function getImage(item: XmlNode): undefined | {
    image: string;
};
export declare function handleItem(item: XmlNode, _feed: FeedObject): Episode;
