"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const execa_1 = __importDefault(require("execa"));
const get_stdin_1 = __importDefault(require("get-stdin"));
const path_1 = __importDefault(require("path"));
const read_pkg_1 = __importDefault(require("read-pkg"));
const debug_1 = __importDefault(require("../debug"));
const getConf_1 = __importDefault(require("../getConf"));
/**
 * @param {array} argv - process.argv
 * @param {promise} getStdinFn - used for mocking only
 */
function run([, scriptPath, hookName = '', HUSKY_GIT_PARAMS], getStdinFn = get_stdin_1.default) {
    return __awaiter(this, void 0, void 0, function* () {
        // Update CWD
        const cwd = path_1.default.resolve(scriptPath.split('node_modules')[0]);
        // Debug
        debug_1.default(`Changed current working directory to '${cwd}'`);
        // In some cases, package.json may not exist
        // For example, when switching to gh-page branch
        let pkg;
        try {
            pkg = read_pkg_1.default.sync({ cwd, normalize: false });
        }
        catch (err) {
            if (err.code !== 'ENOENT') {
                throw err;
            }
        }
        const config = getConf_1.default(cwd);
        const command = config && config.hooks && config.hooks[hookName];
        const oldCommand = pkg && pkg.scripts && pkg.scripts[hookName.replace('-', '')];
        // Run command
        try {
            const env = {};
            if (HUSKY_GIT_PARAMS) {
                env.HUSKY_GIT_PARAMS = HUSKY_GIT_PARAMS;
            }
            if (['pre-push', 'pre-receive', 'post-receive', 'post-rewrite'].includes(hookName)) {
                // Wait for stdin
                env.HUSKY_GIT_STDIN = yield getStdinFn();
            }
            if (oldCommand) {
                console.log();
                console.log(`Warning: Setting ${hookName} script in package.json > scripts will be deprecated`);
                console.log(`Please move it to husky.hooks in package.json, a .huskyrc file, or a husky.config.js file`);
                console.log(`Or run ./node_modules/.bin/husky-upgrade for automatic update`);
                console.log();
                console.log(`See https://github.com/typicode/husky for usage`);
                console.log();
            }
            if (command || oldCommand) {
                console.log(`husky > ${hookName} (node ${process.version})`);
                execa_1.default.shellSync(command || oldCommand, { cwd, env, stdio: 'inherit' });
            }
            return 0;
        }
        catch (err) {
            const noVerifyMessage = [
                'commit-msg',
                'pre-commit',
                'pre-rebase',
                'pre-push'
            ].includes(hookName)
                ? '(add --no-verify to bypass)'
                : '(cannot be bypassed with --no-verify due to Git specs)';
            console.log(`husky > ${hookName} hook failed ${noVerifyMessage}`);
            return err.code;
        }
    });
}
exports.default = run;
