/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 */
'use strict';

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var HermesASTAdapter = require('./HermesASTAdapter');

var HermesToBabelAdapter = /*#__PURE__*/function (_HermesASTAdapter) {
  _inherits(HermesToBabelAdapter, _HermesASTAdapter);

  var _super = _createSuper(HermesToBabelAdapter);

  function HermesToBabelAdapter() {
    _classCallCheck(this, HermesToBabelAdapter);

    return _super.apply(this, arguments);
  }

  _createClass(HermesToBabelAdapter, [{
    key: "fixSourceLocation",
    value: function fixSourceLocation(node) {
      var _this$sourceFilename;

      var loc = node.loc;

      if (loc == null) {
        return;
      }

      node.loc = {
        source: (_this$sourceFilename = this.sourceFilename) !== null && _this$sourceFilename !== void 0 ? _this$sourceFilename : null,
        start: loc.start,
        end: loc.end
      };
      node.start = loc.rangeStart;
      node.end = loc.rangeEnd;
    }
  }, {
    key: "mapNode",
    value: function mapNode(node) {
      this.fixSourceLocation(node);

      switch (node.type) {
        case 'Program':
          return this.mapProgram(node);

        case 'BlockStatement':
          return this.mapNodeWithDirectives(node);

        case 'Empty':
          return this.mapEmpty(node);

        case 'Identifier':
          return this.mapIdentifier(node);

        case 'TemplateElement':
          return this.mapTemplateElement(node);

        case 'GenericTypeAnnotation':
          return this.mapGenericTypeAnnotation(node);

        case 'SymbolTypeAnnotation':
          return this.mapSymbolTypeAnnotation(node);

        case 'Property':
          return this.mapProperty(node);

        case 'MethodDefinition':
          return this.mapMethodDefinition(node);

        case 'ImportDeclaration':
          return this.mapImportDeclaration(node);

        case 'ImportSpecifier':
          return this.mapImportSpecifier(node);

        case 'ExportDefaultDeclaration':
          return this.mapExportDefaultDeclaration(node);

        case 'ExportNamedDeclaration':
          return this.mapExportNamedDeclaration(node);

        case 'ExportAllDeclaration':
          return this.mapExportAllDeclaration(node);

        case 'RestElement':
          return this.mapRestElement(node);

        case 'ImportExpression':
          return this.mapImportExpression(node);

        case 'PrivateName':
        case 'ClassPrivateProperty':
          return this.mapPrivateProperty(node);

        case 'FunctionDeclaration':
        case 'FunctionExpression':
          return this.mapFunction(node);

        default:
          return this.mapNodeDefault(node);
      }
    }
  }, {
    key: "mapProgram",
    value: function mapProgram(node) {
      // Visit child nodes and convert to directives
      var _this$mapNodeWithDire = this.mapNodeWithDirectives(node),
          comments = _this$mapNodeWithDire.comments,
          program = _objectWithoutProperties(_this$mapNodeWithDire, ["comments"]);

      program.sourceType = this.getSourceType(); // Adjust start loc to beginning of file

      program.loc.start = {
        line: 1,
        column: 0
      };
      program.start = 0; // Adjust end loc to include last comment if program ends with a comment

      if (comments.length > 0) {
        var lastComment = comments[comments.length - 1];

        if (lastComment.end > program.end) {
          program.loc.end = lastComment.loc.end;
          program.end = lastComment.end;
        }
      } // Rename root node to File node and move Program node under program property


      return {
        type: 'File',
        loc: program.loc,
        start: program.start,
        end: program.end,
        program: program,
        comments: comments
      };
    }
  }, {
    key: "mapNodeWithDirectives",
    value: function mapNodeWithDirectives(node) {
      var directives = [];

      var _iterator = _createForOfIteratorHelper(node.body),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _child = _step.value;

          if (_child.type === 'ExpressionStatement' && _child.directive != null) {
            // Visit directive children
            var directiveChild = this.mapNode(_child); // Modify string literal node to be DirectiveLiteral node

            directiveChild.expression.type = 'DirectiveLiteral'; // Construct Directive node with DirectiveLiteral value

            directives.push({
              type: 'Directive',
              loc: directiveChild.loc,
              start: directiveChild.start,
              end: directiveChild.end,
              value: directiveChild.expression
            });
          } else {
            // Once we have found the first non-directive node we know there cannot be any more directives
            break;
          }
        } // Move directives from body to new directives array

      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      node.directives = directives;

      if (directives.length !== 0) {
        node.body = node.body.slice(directives.length);
      } // Visit expression statement children


      var body = node.body;

      for (var i = 0; i < body.length; i++) {
        var child = body[i];

        if (child != null) {
          body[i] = this.mapNode(child);
        }
      }

      return node;
    }
  }, {
    key: "mapIdentifier",
    value: function mapIdentifier(node) {
      node.loc.identifierName = node.name;
      return this.mapNodeDefault(node);
    }
  }, {
    key: "mapTemplateElement",
    value: function mapTemplateElement(node) {
      // Adjust start loc to exclude "`" at beginning of template literal if this is the first quasi,
      // otherwise exclude "}" from previous expression.
      var startCharsToExclude = 1; // Adjust end loc to exclude "`" at end of template literal if this is the last quasi,
      // otherwise exclude "${" from next expression.

      var endCharsToExclude = node.tail ? 1 : 2;
      return {
        type: 'TemplateElement',
        loc: {
          start: {
            line: node.loc.start.line,
            column: node.loc.start.column + startCharsToExclude
          },
          end: {
            line: node.loc.end.line,
            column: node.loc.end.column - endCharsToExclude
          }
        },
        start: node.start + startCharsToExclude,
        end: node.end - endCharsToExclude,
        tail: node.tail,
        value: {
          cooked: node.cooked,
          raw: node.raw
        }
      };
    }
  }, {
    key: "mapGenericTypeAnnotation",
    value: function mapGenericTypeAnnotation(node) {
      // Convert simple `this` generic type to ThisTypeAnnotation
      if (node.typeParameters === null && node.id.type === 'Identifier' && node.id.name === 'this') {
        return {
          type: 'ThisTypeAnnotation',
          loc: node.loc,
          start: node.start,
          end: node.end
        };
      }

      return this.mapNodeDefault(node);
    }
  }, {
    key: "mapSymbolTypeAnnotation",
    value: function mapSymbolTypeAnnotation(node) {
      return {
        type: 'GenericTypeAnnotation',
        loc: node.loc,
        start: node.start,
        end: node.end,
        id: {
          type: 'Identifier',
          loc: node.loc,
          start: node.start,
          end: node.end,
          name: 'symbol'
        },
        typeParameters: null
      };
    }
  }, {
    key: "mapProperty",
    value: function mapProperty(node) {
      var key = this.mapNode(node.key);
      var value = this.mapNode(node.value); // Convert methods, getters, and setters to ObjectMethod nodes

      if (node.method || node.kind !== 'init') {
        // Properties under the FunctionExpression value that should be moved
        // to the ObjectMethod node itself.
        var id = value.id,
            params = value.params,
            body = value.body,
            async = value.async,
            generator = value.generator,
            returnType = value.returnType,
            typeParameters = value.typeParameters,
            predicate = value.predicate;
        return {
          type: 'ObjectMethod',
          loc: node.loc,
          start: node.start,
          end: node.end,
          // Non getter or setter methods have `kind = method`
          kind: node.kind === 'init' ? 'method' : node.kind,
          computed: node.computed,
          key: key,
          id: id,
          params: params,
          body: body,
          async: async,
          generator: generator,
          returnType: returnType,
          typeParameters: typeParameters,
          predicate: predicate
        };
      } else {
        // Non-method property nodes should be renamed to ObjectProperty
        node.type = 'ObjectProperty';
        return node;
      }
    }
  }, {
    key: "mapMethodDefinition",
    value: function mapMethodDefinition(node) {
      var key = this.mapNode(node.key);
      var value = this.mapNode(node.value); // Properties under the FunctionExpression value that should be moved
      // to the ClassMethod node itself.

      var id = value.id,
          params = value.params,
          body = value.body,
          async = value.async,
          generator = value.generator,
          returnType = value.returnType,
          typeParameters = value.typeParameters,
          predicate = value.predicate;
      return {
        type: 'ClassMethod',
        loc: node.loc,
        start: node.start,
        end: node.end,
        kind: node.kind,
        computed: node.computed,
        "static": node["static"],
        key: key,
        id: id,
        params: params,
        body: body,
        async: async,
        generator: generator,
        returnType: returnType,
        typeParameters: typeParameters,
        predicate: predicate
      };
    }
  }, {
    key: "mapRestElement",
    value: function mapRestElement(node) {
      var restElement = this.mapNodeDefault(node); // Hermes puts type annotations on rest elements on the argument node,
      // but Babel expects type annotations on the rest element node itself.

      var annotation = restElement.argument.typeAnnotation;

      if (annotation != null) {
        restElement.typeAnnotation = annotation;
        restElement.argument.typeAnnotation = null;
      }

      return restElement;
    }
  }, {
    key: "mapImportExpression",
    value: function mapImportExpression(node) {
      // Babel expects ImportExpression to be structued as a regular
      // CallExpression where the callee is an Import node.
      return {
        type: 'CallExpression',
        loc: node.loc,
        start: node.start,
        end: node.end,
        callee: {
          type: 'Import',
          loc: node.loc,
          start: node.start,
          end: node.end
        },
        arguments: [this.mapNode(node.source)]
      };
    }
  }, {
    key: "mapFunction",
    value: function mapFunction(node) {
      // Remove the first parameter if it is a this-type annotation,
      // which is not recognized by Babel.
      if (node.params.length !== 0 && node.params[0].name === 'this') {
        node.params.shift();
      }

      return this.mapNodeDefault(node);
    }
  }]);

  return HermesToBabelAdapter;
}(HermesASTAdapter);

module.exports = HermesToBabelAdapter;