<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [@jsamr/counter-style](./counter-style.md) &gt; [CounterStyleStatic](./counter-style.counterstylestatic.md)

## CounterStyleStatic interface

An object to build counter style renderers.

<b>Signature:</b>

```typescript
export interface CounterStyleStatic 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [additive](./counter-style.counterstylestatic.additive.md) | (symbols: Record&lt;number, string&gt;) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create an additive system renderer.<!-- -->See [CSS Counter Styles Level 3, Accumulating Numerals: the additive system](https://www.w3.org/TR/css-counter-styles-3/#additive-system)<!-- -->. |
|  [alphabetic](./counter-style.counterstylestatic.alphabetic.md) | (...symbols: string\[\]) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create an alphabetic system renderer.<!-- -->See [CSS Counter Styles Level 3, Bijective Numerals: the alphabetic system](https://www.w3.org/TR/css-counter-styles-3/#alphabetic-system)<!-- -->. |
|  [alphabeticFromUnicodeRange](./counter-style.counterstylestatic.alphabeticfromunicoderange.md) | (originUnicode: number, alphabetLength: number) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create an alphabetic system renderer from a UTF-16 code unit and an alphabet length. The set of symbols for this alphabetic system will be generated by incrementing <code>originUnicode</code> with every integer in range \[0, <code>alphabetLength</code> - 1\].<!-- -->See [CSS Counter Styles Level 3, Bijective Numerals: the alphabetic system](https://www.w3.org/TR/css-counter-styles-3/#alphabetic-system)<!-- -->. |
|  [cyclic](./counter-style.counterstylestatic.cyclic.md) | (...symbols: string\[\]) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create a cyclic system renderer.<!-- -->See [CSS Counter Styles Level 3, Cycling Symbols: the cyclic system](https://www.w3.org/TR/css-counter-styles-3/#cyclic-system)<!-- -->. |
|  [fixed](./counter-style.counterstylestatic.fixed.md) | (...symbols: string\[\]) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create a fixed system renderer.<!-- -->See [CSS Counter Styles Level 3, Exhaustible Symbols: the fixed system](https://www.w3.org/TR/css-counter-styles-3/#fixed-system)<!-- -->. |
|  [numeric](./counter-style.counterstylestatic.numeric.md) | (...symbols: string\[\]) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create a numeric system renderer.<!-- -->See [CSS Counter Styles Level 3, Positional Numerals: the numeric system](https://www.w3.org/TR/css-counter-styles-3/#numeric-system)<!-- -->. |
|  [numericFromUnicodeRange](./counter-style.counterstylestatic.numericfromunicoderange.md) | (originUnicode: number, base: number) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create a numeric system renderer from a UTF-16 code unit and a base. The set of numerals for this range will be generated by incrementing <code>originUnicode</code> with every integer in range \[0, <code>base</code> - 1\].<!-- -->See [CSS Counter Styles Level 3, Positional Numerals: the numeric system](https://www.w3.org/TR/css-counter-styles-3/#numeric-system)<!-- -->. |
|  [raw](./counter-style.counterstylestatic.raw.md) | (initialCounterFormatter: [InitialCounterFormatter](./counter-style.initialcounterformatter.md)<!-- -->) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create a renderer from a formatter function. |
|  [symbolic](./counter-style.counterstylestatic.symbolic.md) | (...symbols: string\[\]) =&gt; [CounterStyleRenderer](./counter-style.counterstylerenderer.md) | Create a symbolic system renderer.<!-- -->See [CSS Counter Styles Level 3, Repeating Symbols: the symbolic system](https://www.w3.org/TR/css-counter-styles-3/#symbolic-system)<!-- -->. |

