# Attention: Send PRs to the [podverse-rn repo](https://github.com/podverse/podverse-rn) instead of this one :)

The podverse-fdroid repo is downstream from the podverse-rn repo. Both repos are identical, except podverse-fdroid has a small amount of changes specific to it, such as the Podverse F-Droid build config and assets, our Azure F-Droid build pipeline, the removal of Matomo tracking code, and the removal of other libraries.

If you'd like to add features or a bug fix to the Podverse mobile app, please make those changes in [podverse-rn](https://github.com/podverse/podverse-rn) instead of podverse-fdroid, _unless_ you're absolutely sure these changes should only apply to the podverse-fdroid build.

# Podverse F-Droid
<p align="center">
    <img src="https://avatars.githubusercontent.com/u/11860029?s=200&v=4"
    alt="Company Logo"
    height="200">
</p>

<p align="center">
    <img src="https://play-lh.googleusercontent.com/7gyLggXCV-N2rsYUKNuDD9TqRuP5XaJzBqgNwU4e82N3ErjC-VvEEkwtx7PIlaJCCw=w2560-h1440-rw"
    alt="im1"
    width="200" />
    <img src="https://play-lh.googleusercontent.com/UyrgF34I1-y0OYW_5hNLf3Qc5B5HXhO6buL2aYa6-CO_HekHbUzL-WD2NVAXIHrvDQ=w2560-h1440-rw"
    alt="img2"
    width="200" />
    <img src="https://play-lh.googleusercontent.com/eSBIllmpr4KXfKy-wlksQn4i1G6B9CbgmJ8ujiXGuzRngfzv-9ducHpQ6qeV6oP0oz2u=w2560-h1440-rw"
    alt="img3"
    width="200" />
</p>

# Podverse

- [About](#about)
- [Licensing](#licensing)
- [Version support](#version-support)
- [Getting started](#getting-started)
- [More contributing info](#more-contributing-info)
  * [Translations on Hosted Weblate](#translations-on-hosted-weblate)
- [Team:](#team-)
- [Thank you to our contributors!](#thank-you-to-our-contributors-)
- [FAQ:](#faq-)
  * [Why do some clips start at the wrong time?](#why-do-some-clips-start-at-the-wrong-time-)
  * [What does the license (AGPLv3) mean?](#what-does-the-license--agplv3--mean-)
  * [Why is Podverse free as in freedom?](#why-is-podverse-free-as-in-freedom-)

<small><i><a href='http://ecotrust-canada.github.io/markdown-toc/'>generated with markdown-toc</a></i></small>

## About
Free and open source podcast manager for Android, iOS, and the web. \
Check it out at [podverse.fm](https://podverse.fm/)

Listen to all your podcasts on a single application with Podverse!

Podverse included features:
- Subscribe to podcasts
- Auto-download episodes
- Drag-and-drop queue
- Sleep timer
- Light/dark mode

Podverse premium features:
- Create and share podcast clips
- Switch devices and play from where you left off
- Sync your subscriptions across devices
- Sync your queue across devices
- Create and share playlists
- Subscribe to playlists

Features requiring updating our servers require Podverse premium membership. \
Sign up and try it gratis for three months 🥳

Find us on on these App Stores and our [Website](https://podverse.fm/):

<a href="https://f-droid.org/en/packages/com.podverse.fdroid/" target="_blank">
    <img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
    alt="Get it on F-Droid"
    height="80">
</a>
<a href="https://play.google.com/store/apps/details?id=com.podverse" target="_blank">
    <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
    alt="Get it on Google Play"
    height="80">
</a>
<a href="https://apps.apple.com/us/app/podverse/id1390888454" target="_blank">
    <img src="https://raw.githubusercontent.com/osmandapp/osmandapp.github.io/master/website/images/app-store-badge.png"
    alt="Get it on AppStore"
    height="60"/>
</a>

## Licensing

All Podverse software is provided under a [libre software licence](https://github.com/podverse/podverse-rn/blob/develop/LICENSE).

## Version support

Officially, Podverse supports the following OS versions:

- iOS: 14-16
- Android: 11-13

That said, Podverse might work on earlier versions, but our target for each release is to provide full support for at least those versions.

## Getting started

If you are looking to run this app or contribute to Podverse for the first time, please read the sections that are relevant for you in our [CONTRIBUTE.md](https://github.com/podverse/podverse-ops/blob/master/CONTRIBUTING.md) file in the podverse-ops repo. Among other things, that file contains instructions for running a local instance of the Podverse database.

## More contributing info

[Instruction for contributing to the repo](https://github.com/podverse/podverse-rn/blob/master/Contributing.md) for the **Podverse Mobile App**.

Additional environment setup and installation for Mac or Windows is found within the contribution page.

### Translations on Hosted Weblate

<a href="https://hosted.weblate.org/engage/podverse/">
<img src="https://hosted.weblate.org/widgets/podverse/-/podverse-rn/horizontal-auto.svg" alt="Oversettelsesstatus" />
</a>

## Team:
- [Mitch Downey](https://github.com/mitchdowney)
- [Creon Creonopoulos](https://github.com/kreonjr)
- Gary Johnson
- [Kyle Downey](https://github.com/KyleFDowney)


## Thank you to our contributors!

<a href="https://github.com/podverse/podverse-rn/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=podverse/podverse-rn" />
</a>


## FAQ:

### Why do some clips start at the wrong time?
Most podcast apps today limit clips to be less than a minute, but Podverse allows creating and sharing clips of any length. \
The current approach has the drawback of not supporting clips from podcasts that insert dynamic ads.

Dynamic ads are different advertisements rotated into the same episode, so each listener can hear a different series of advertisements. \
Since dynamic ads change the overall length of the episode, timestamps of clips created from that episode may be inaccurate.

Full support for podcasts with dynamic ads is possible, but for fair use/legal reasons permission from each podcaster is needed to do so.

### What does the license (AGPLv3) mean?
AGPLv3 is the license of all Podverse software. Anyone can use, inspect, change and share freely, as long as everyone gets to share the software. \
This is also known as a "share-alike" or "copyleft" license.

### Why is Podverse free as in freedom?
Podverse software lets anyone launch their own podcast app as affordably as possible. \
Podcast networks can use the Podverse codebase to create their own app for a tiny fraction of what it costs to hire programmers to build a podcast app from scratch.

This levels the playing field between the corporate world and independent media, \
so independent media enjoy the same technological advantages as large corporations. \
Copylefted libre software and donations is essential to that mission.
