#ifndef __START_NEW_ROUND_COMMOBJ__
#define __START_NEW_ROUND_COMMOBJ__

#if defined MAKE_MULTIPLAYERROUND_LIB
#define MULTIPLAYER_EXPORT Q_DECL_EXPORT
#else
#define MULTIPLAYER_EXPORT Q_DECL_IMPORT
#endif

#include "basiscommobj.h"
#include "viewmodels/startnewroundviewmodel.h"
class MultiplayerRound;

class MULTIPLAYER_EXPORT StartNewRoundCommObj : public BasisCommObj {
    Q_OBJECT
    
public:
    StartNewRoundCommObj(const QString& requestPath, const QString& actionName, QWidget* parentWidget, QNetworkAccessManager* networkManager, QSettings* settings, bool isSinglePlayer, GlobalData* globalData, MultiplayerRound* mrd):
        BasisCommObj(requestPath, actionName, parentWidget, networkManager, settings, isSinglePlayer, globalData), m_MultiRound(mrd) {}
    
    bool makeRequest();
    bool validateReply(const QJsonObject& retJson) override;
    
protected:
    StartNewRoundCommObj() {}

public slots:
    void finishedRequest() override;       
    
signals:
    void startNewRound();

private:
    void processResponse(const QJsonObject& retJson);
    StartNewRoundViewModel prepareViewModel();
    
private:
    MultiplayerRound* m_MultiRound;

    friend class StartNewRoundCommObjTest;
    
};















#endif
