<p align="center">
   <img alt="Logline App-Logo" src="readme/LoglineLogo.svg" width="92" />
</p>
<h1 align="center">Logline - MovieApp</h1>

[<img src="https://img.shields.io/github/tag-date/patch4code/logline.svg?color=blue&label=release"
alt="Github release">](https://github.com/Patch4Code/Logline/releases)
[<img src="https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/com.patch4code.logline"
alt="IzzyOnDroid release">](https://apt.izzysoft.de/fdroid/index/apk/com.patch4code.logline)
[<img src="https://img.shields.io/f-droid/v/com.patch4code.logline?logo=fdroid"
alt="F-Droid release">](https://f-droid.org/en/packages/com.patch4code.logline)
[<img src="https://img.shields.io/github/downloads/patch4code/logline/total?logo=github&color=%230f81c2"
alt="Downloads">](https://github.com/patch4code/Logline/releases)
[<img src="https://img.shields.io/badge/License-GPL%20v3-orange"
alt="GPLv3 License">](https://www.gnu.org/licenses/gpl-3.0)


**Logline** is an open-source Android app that provides a seamless movie browsing experience with an emphasis on user privacy and transparency. 
The app offers core functionality to discover, organize, and rate movies while ensuring that user data remains under their control.


## Download

[<img src="readme/get-it-on-github.png"
alt="Get it on Github" height="80">](https://github.com/Patch4Code/Logline/releases)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png"
alt="Get it on IzzyOnDroid" height="80">](https://apt.izzysoft.de/fdroid/index/apk/com.patch4code.logline)
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid" height="80">](https://f-droid.org/en/packages/com.patch4code.logline)
[<img src="https://www.openapk.net/images/openapk-badge.png"
alt="OpenAPK" height="80">](https://www.openapk.net/logline-movieapp/com.patch4code.logline/)
[<img src="https://www.androidfreeware.net/images/androidfreeware-badge.png"
alt="OpenAPK" height="80">](https://www.androidfreeware.net/download-logline-movieapp-apk.html)


## Features
- **Discover new Movies**: Explore popular, top-rated, and upcoming movies.
  Use advanced filters to find exactly what you're looking for, from genres to release years and more.
- **Search Functionality**: Find your favorite movies quickly.
- **Detailed Movie Information**: Access details about movies (including cast, release information and more).
- **Watchlist**: Organize your movies by adding them to a personal watchlist.
- **Rate Movies**: Privately rate movies you’ve watched.
- **Activity Tracking**: Keep a personal log of your watched movies.
- **Write Personal Reviews**: Write down your personal thoughts and impressions about movies.
- **Custom Lists**: Create and manage general lists of movies.
- **Export/Import Data**: Securely back up your data or transfer it to a new device.
- **Privacy First**: Local data storage ensures full control of your personal information.



## Screenshots

[<img src="readme/home.jpeg" width=160>](readme/home.jpeg)
[<img src="readme/search.jpeg" width=160>](readme/search.jpeg)
[<img src="readme/discover.jpeg" width=160>](readme/discover.jpeg)
[<img src="readme/watchlist.jpeg" width=160>](readme/watchlist.jpeg)
[<img src="readme/movie_page.jpeg" width=160>](readme/movie_page.jpeg)
[<img src="readme/profile.jpeg" width=160>](readme/profile.jpeg)
[<img src="readme/my_movies.jpeg" width=160>](readme/my_movies.jpeg)
[<img src="readme/diary.jpeg" width=160>](readme/diary.jpeg)
[<img src="readme/reviews.jpeg" width=160>](readme/reviews.jpeg)
[<img src="readme/list_table.jpeg" width=160>](readme/list_table.jpeg)

