package com.patch4code.logline.features.core.domain.model

import android.content.Context
import com.patch4code.logline.features.core.presentation.utils.StringResourceHelper.getStringResourceFromName

/**
 * GNU GENERAL PUBLIC LICENSE, VERSION 3.0 (https://www.gnu.org/licenses/gpl-3.0.html)
 *
 * MovieLanguages - Provides mappings of language-code to language name.
 *
 * @author Patch4Code
 */

object MovieLanguages {

    fun getPrimaryLanguages(context: Context): Map<String, String>{
        return mapOf(
            "de" to getStringResourceFromName(context, "language_de"),
            "en" to getStringResourceFromName(context, "language_en"),
            "es" to getStringResourceFromName(context, "language_es"),
            "fr" to getStringResourceFromName(context, "language_fr"),
            "hi" to getStringResourceFromName(context, "language_hi"),
            "it" to getStringResourceFromName(context, "language_it"),
            "ja" to getStringResourceFromName(context, "language_ja"),
            "ko" to getStringResourceFromName(context, "language_ko"),
            "zh" to getStringResourceFromName(context, "language_zh"),
        )
    }

    fun getAllLanguages(context: Context): Map<String, String>{
        return mapOf(
            "xx" to getStringResourceFromName(context, "language_xx"),
            "aa" to getStringResourceFromName(context, "language_aa"),
            "af" to getStringResourceFromName(context, "language_af"),
            "ak" to getStringResourceFromName(context, "language_ak"),
            "an" to getStringResourceFromName(context, "language_an"),
            "as" to getStringResourceFromName(context, "language_as"),
            "av" to getStringResourceFromName(context, "language_av"),
            "ae" to getStringResourceFromName(context, "language_ae"),
            "ay" to getStringResourceFromName(context, "language_ay"),
            "az" to getStringResourceFromName(context, "language_az"),
            "ba" to getStringResourceFromName(context, "language_ba"),
            "bm" to getStringResourceFromName(context, "language_bm"),
            "bn" to getStringResourceFromName(context, "language_bn"),
            "bi" to getStringResourceFromName(context, "language_bi"),
            "bo" to getStringResourceFromName(context, "language_bo"),
            "bs" to getStringResourceFromName(context, "language_bs"),
            "br" to getStringResourceFromName(context, "language_br"),
            "ca" to getStringResourceFromName(context, "language_ca"),
            "cs" to getStringResourceFromName(context, "language_cs"),
            "ch" to getStringResourceFromName(context, "language_ch"),
            "ce" to getStringResourceFromName(context, "language_ce"),
            "cu" to getStringResourceFromName(context, "language_cu"),
            "cv" to getStringResourceFromName(context, "language_cv"),
            "kw" to getStringResourceFromName(context, "language_kw"),
            "co" to getStringResourceFromName(context, "language_co"),
            "cr" to getStringResourceFromName(context, "language_cr"),
            "cy" to getStringResourceFromName(context, "language_cy"),
            "da" to getStringResourceFromName(context, "language_da"),
            "de" to getStringResourceFromName(context, "language_de"),
            "dv" to getStringResourceFromName(context, "language_dv"),
            "dz" to getStringResourceFromName(context, "language_dz"),
            "en" to getStringResourceFromName(context, "language_en"),
            "eo" to getStringResourceFromName(context, "language_eo"),
            "et" to getStringResourceFromName(context, "language_et"),
            "eu" to getStringResourceFromName(context, "language_eu"),
            "fo" to getStringResourceFromName(context, "language_fo"),
            "fj" to getStringResourceFromName(context, "language_fj"),
            "fi" to getStringResourceFromName(context, "language_fi"),
            "fr" to getStringResourceFromName(context, "language_fr"),
            "fy" to getStringResourceFromName(context, "language_fy"),
            "ff" to getStringResourceFromName(context, "language_ff"),
            "gd" to getStringResourceFromName(context, "language_gd"),
            "ga" to getStringResourceFromName(context, "language_ga"),
            "gl" to getStringResourceFromName(context, "language_gl"),
            "gv" to getStringResourceFromName(context, "language_gv"),
            "gn" to getStringResourceFromName(context, "language_gn"),
            "gu" to getStringResourceFromName(context, "language_gu"),
            "ht" to getStringResourceFromName(context, "language_ht"),
            "ha" to getStringResourceFromName(context, "language_ha"),
            "sh" to getStringResourceFromName(context, "language_sh"),
            "hz" to getStringResourceFromName(context, "language_hz"),
            "ho" to getStringResourceFromName(context, "language_ho"),
            "hr" to getStringResourceFromName(context, "language_hr"),
            "hu" to getStringResourceFromName(context, "language_hu"),
            "ig" to getStringResourceFromName(context, "language_ig"),
            "io" to getStringResourceFromName(context, "language_io"),
            "ii" to getStringResourceFromName(context, "language_ii"),
            "iu" to getStringResourceFromName(context, "language_iu"),
            "ie" to getStringResourceFromName(context, "language_ie"),
            "ia" to getStringResourceFromName(context, "language_ia"),
            "id" to getStringResourceFromName(context, "language_id"),
            "ik" to getStringResourceFromName(context, "language_ik"),
            "is" to getStringResourceFromName(context, "language_is"),
            "it" to getStringResourceFromName(context, "language_it"),
            "jv" to getStringResourceFromName(context, "language_jv"),
            "ja" to getStringResourceFromName(context, "language_ja"),
            "kl" to getStringResourceFromName(context, "language_kl"),
            "kn" to getStringResourceFromName(context, "language_kn"),
            "ks" to getStringResourceFromName(context, "language_ks"),
            "ka" to getStringResourceFromName(context, "language_ka"),
            "kr" to getStringResourceFromName(context, "language_kr"),
            "kk" to getStringResourceFromName(context, "language_kk"),
            "km" to getStringResourceFromName(context, "language_km"),
            "ki" to getStringResourceFromName(context, "language_ki"),
            "rw" to getStringResourceFromName(context, "language_rw"),
            "ky" to getStringResourceFromName(context, "language_ky"),
            "kv" to getStringResourceFromName(context, "language_kv"),
            "kg" to getStringResourceFromName(context, "language_kg"),
            "ko" to getStringResourceFromName(context, "language_ko"),
            "kj" to getStringResourceFromName(context, "language_kj"),
            "ku" to getStringResourceFromName(context, "language_ku"),
            "lo" to getStringResourceFromName(context, "language_lo"),
            "la" to getStringResourceFromName(context, "language_la"),
            "lv" to getStringResourceFromName(context, "language_lv"),
            "li" to getStringResourceFromName(context, "language_li"),
            "ln" to getStringResourceFromName(context, "language_ln"),
            "lt" to getStringResourceFromName(context, "language_lt"),
            "lb" to getStringResourceFromName(context, "language_lb"),
            "lu" to getStringResourceFromName(context, "language_lu"),
            "lg" to getStringResourceFromName(context, "language_lg"),
            "mh" to getStringResourceFromName(context, "language_mh"),
            "ml" to getStringResourceFromName(context, "language_ml"),
            "mr" to getStringResourceFromName(context, "language_mr"),
            "mg" to getStringResourceFromName(context, "language_mg"),
            "mt" to getStringResourceFromName(context, "language_mt"),
            "mo" to getStringResourceFromName(context, "language_mo"),
            "mn" to getStringResourceFromName(context, "language_mn"),
            "mi" to getStringResourceFromName(context, "language_mi"),
            "ms" to getStringResourceFromName(context, "language_ms"),
            "my" to getStringResourceFromName(context, "language_my"),
            "na" to getStringResourceFromName(context, "language_na"),
            "nv" to getStringResourceFromName(context, "language_nv"),
            "nr" to getStringResourceFromName(context, "language_nr"),
            "nd" to getStringResourceFromName(context, "language_nd"),
            "ng" to getStringResourceFromName(context, "language_ng"),
            "ne" to getStringResourceFromName(context, "language_ne"),
            "nl" to getStringResourceFromName(context, "language_nl"),
            "nn" to getStringResourceFromName(context, "language_nn"),
            "nb" to getStringResourceFromName(context, "language_nb"),
            "no" to getStringResourceFromName(context, "language_no"),
            "ny" to getStringResourceFromName(context, "language_ny"),
            "oc" to getStringResourceFromName(context, "language_oc"),
            "oj" to getStringResourceFromName(context, "language_oj"),
            "or" to getStringResourceFromName(context, "language_or"),
            "om" to getStringResourceFromName(context, "language_om"),
            "os" to getStringResourceFromName(context, "language_os"),
            "pa" to getStringResourceFromName(context, "language_pa"),
            "pi" to getStringResourceFromName(context, "language_pi"),
            "pl" to getStringResourceFromName(context, "language_pl"),
            "pt" to getStringResourceFromName(context, "language_pt"),
            "qu" to getStringResourceFromName(context, "language_qu"),
            "rm" to getStringResourceFromName(context, "language_rm"),
            "ro" to getStringResourceFromName(context, "language_ro"),
            "rn" to getStringResourceFromName(context, "language_rn"),
            "ru" to getStringResourceFromName(context, "language_ru"),
            "sg" to getStringResourceFromName(context, "language_sg"),
            "sa" to getStringResourceFromName(context, "language_sa"),
            "si" to getStringResourceFromName(context, "language_si"),
            "sk" to getStringResourceFromName(context, "language_sk"),
            "sl" to getStringResourceFromName(context, "language_sl"),
            "se" to getStringResourceFromName(context, "language_se"),
            "sm" to getStringResourceFromName(context, "language_sm"),
            "sn" to getStringResourceFromName(context, "language_sn"),
            "sd" to getStringResourceFromName(context, "language_sd"),
            "so" to getStringResourceFromName(context, "language_so"),
            "st" to getStringResourceFromName(context, "language_st"),
            "es" to getStringResourceFromName(context, "language_es"),
            "sq" to getStringResourceFromName(context, "language_sq"),
            "sc" to getStringResourceFromName(context, "language_sc"),
            "sr" to getStringResourceFromName(context, "language_sr"),
            "ss" to getStringResourceFromName(context, "language_ss"),
            "su" to getStringResourceFromName(context, "language_su"),
            "sw" to getStringResourceFromName(context, "language_sw"),
            "sv" to getStringResourceFromName(context, "language_sv"),
            "ty" to getStringResourceFromName(context, "language_ty"),
            "ta" to getStringResourceFromName(context, "language_ta"),
            "tt" to getStringResourceFromName(context, "language_tt"),
            "te" to getStringResourceFromName(context, "language_te"),
            "tg" to getStringResourceFromName(context, "language_tg"),
            "tl" to getStringResourceFromName(context, "language_tl"),
            "th" to getStringResourceFromName(context, "language_th"),
            "ti" to getStringResourceFromName(context, "language_ti"),
            "to" to getStringResourceFromName(context, "language_to"),
            "tn" to getStringResourceFromName(context, "language_tn"),
            "ts" to getStringResourceFromName(context, "language_ts"),
            "tk" to getStringResourceFromName(context, "language_tk"),
            "tr" to getStringResourceFromName(context, "language_tr"),
            "tw" to getStringResourceFromName(context, "language_tw"),
            "ug" to getStringResourceFromName(context, "language_ug"),
            "uk" to getStringResourceFromName(context, "language_uk"),
            "ur" to getStringResourceFromName(context, "language_ur"),
            "uz" to getStringResourceFromName(context, "language_uz"),
            "ve" to getStringResourceFromName(context, "language_ve"),
            "vi" to getStringResourceFromName(context, "language_vi"),
            "vo" to getStringResourceFromName(context, "language_vo"),
            "wa" to getStringResourceFromName(context, "language_wa"),
            "wo" to getStringResourceFromName(context, "language_wo"),
            "xh" to getStringResourceFromName(context, "language_xh"),
            "yi" to getStringResourceFromName(context, "language_yi"),
            "za" to getStringResourceFromName(context, "language_za"),
            "zu" to getStringResourceFromName(context, "language_zu"),
            "ab" to getStringResourceFromName(context, "language_ab"),
            "zh" to getStringResourceFromName(context, "language_zh"),
            "ps" to getStringResourceFromName(context, "language_ps"),
            "am" to getStringResourceFromName(context, "language_am"),
            "ar" to getStringResourceFromName(context, "language_ar"),
            "be" to getStringResourceFromName(context, "language_be"),
            "bg" to getStringResourceFromName(context, "language_bg"),
            "cn" to getStringResourceFromName(context, "language_cn"),
            "mk" to getStringResourceFromName(context, "language_mk"),
            "ee" to getStringResourceFromName(context, "language_ee"),
            "el" to getStringResourceFromName(context, "language_el"),
            "fa" to getStringResourceFromName(context, "language_fa"),
            "he" to getStringResourceFromName(context, "language_he"),
            "hi" to getStringResourceFromName(context, "language_hi"),
            "hy" to getStringResourceFromName(context, "language_hy"),
            "yo" to getStringResourceFromName(context, "language_yo")
        )
    }
}
