package com.patch4code.logline.features.core.domain.model

import android.content.Context
import com.patch4code.logline.features.core.presentation.utils.StringResourceHelper.getStringResourceFromName

/**
 * GNU GENERAL PUBLIC LICENSE, VERSION 3.0 (https://www.gnu.org/licenses/gpl-3.0.html)
 *
 * MovieCountries - Provides mappings of country codes to country names for movies.
 *
 * @author Patch4Code
 */

object MovieCountries {

    fun getPrimaryCountries(context: Context): Map<String, String>{
        return mapOf(
            "DE" to getStringResourceFromName(context, "country_DE"),
            "US" to getStringResourceFromName(context, "country_US_short"),
            "ES" to getStringResourceFromName(context, "country_ES"),
            "FR" to getStringResourceFromName(context, "country_FR"),
            "IN" to getStringResourceFromName(context, "country_IN"),
            "IT" to getStringResourceFromName(context, "country_IT"),
            "JP" to getStringResourceFromName(context, "country_JP"),
            "KR" to getStringResourceFromName(context, "country_KR"),
            "CN" to getStringResourceFromName(context, "country_CN")
        )
    }

    fun geAllCountries(context: Context): Map<String, String>{
        return mapOf(
            "AD" to getStringResourceFromName(context, "country_AD"),
            "AE" to getStringResourceFromName(context, "country_AE"),
            "AF" to getStringResourceFromName(context, "country_AF"),
            "AG" to getStringResourceFromName(context, "country_AG"),
            "AI" to getStringResourceFromName(context, "country_AI"),
            "AL" to getStringResourceFromName(context, "country_AL"),
            "AM" to getStringResourceFromName(context, "country_AM"),
            "AN" to getStringResourceFromName(context, "country_AN"),
            "AO" to getStringResourceFromName(context, "country_AO"),
            "AQ" to getStringResourceFromName(context, "country_AQ"),
            "AR" to getStringResourceFromName(context, "country_AR"),
            "AS" to getStringResourceFromName(context, "country_AS"),
            "AT" to getStringResourceFromName(context, "country_AT"),
            "AU" to getStringResourceFromName(context, "country_AU"),
            "AW" to getStringResourceFromName(context, "country_AW"),
            "AZ" to getStringResourceFromName(context, "country_AZ"),
            "BA" to getStringResourceFromName(context, "country_BA"),
            "BB" to getStringResourceFromName(context, "country_BB"),
            "BD" to getStringResourceFromName(context, "country_BD"),
            "BE" to getStringResourceFromName(context, "country_BE"),
            "BF" to getStringResourceFromName(context, "country_BF"),
            "BG" to getStringResourceFromName(context, "country_BG"),
            "BH" to getStringResourceFromName(context, "country_BH"),
            "BI" to getStringResourceFromName(context, "country_BI"),
            "BJ" to getStringResourceFromName(context, "country_BJ"),
            "BM" to getStringResourceFromName(context, "country_BM"),
            "BN" to getStringResourceFromName(context, "country_BN"),
            "BO" to getStringResourceFromName(context, "country_BO"),
            "BR" to getStringResourceFromName(context, "country_BR"),
            "BS" to getStringResourceFromName(context, "country_BS"),
            "BT" to getStringResourceFromName(context, "country_BT"),
            "BU" to getStringResourceFromName(context, "country_BU"),
            "BV" to getStringResourceFromName(context, "country_BV"),
            "BW" to getStringResourceFromName(context, "country_BW"),
            "BY" to getStringResourceFromName(context, "country_BY"),
            "BZ" to getStringResourceFromName(context, "country_BZ"),
            "CA" to getStringResourceFromName(context, "country_CA"),
            "CC" to getStringResourceFromName(context, "country_CC"),
            "CD" to getStringResourceFromName(context, "country_CD"),
            "CF" to getStringResourceFromName(context, "country_CF"),
            "CG" to getStringResourceFromName(context, "country_CG"),
            "CH" to getStringResourceFromName(context, "country_CH"),
            "CI" to getStringResourceFromName(context, "country_CI"),
            "CK" to getStringResourceFromName(context, "country_CK"),
            "CL" to getStringResourceFromName(context, "country_CL"),
            "CM" to getStringResourceFromName(context, "country_CM"),
            "CN" to getStringResourceFromName(context, "country_CN"),
            "CO" to getStringResourceFromName(context, "country_CO"),
            "CR" to getStringResourceFromName(context, "country_CR"),
            "CS" to getStringResourceFromName(context, "country_CS"),
            "CU" to getStringResourceFromName(context, "country_CU"),
            "CV" to getStringResourceFromName(context, "country_CV"),
            "CX" to getStringResourceFromName(context, "country_CX"),
            "CY" to getStringResourceFromName(context, "country_CY"),
            "CZ" to getStringResourceFromName(context, "country_CZ"),
            "DE" to getStringResourceFromName(context, "country_DE"),
            "DJ" to getStringResourceFromName(context, "country_DJ"),
            "DK" to getStringResourceFromName(context, "country_DK"),
            "DM" to getStringResourceFromName(context, "country_DM"),
            "DO" to getStringResourceFromName(context, "country_DO"),
            "DZ" to getStringResourceFromName(context, "country_DZ"),
            "EC" to getStringResourceFromName(context, "country_EC"),
            "EE" to getStringResourceFromName(context, "country_EE"),
            "EG" to getStringResourceFromName(context, "country_EG"),
            "EH" to getStringResourceFromName(context, "country_EH"),
            "ER" to getStringResourceFromName(context, "country_ER"),
            "ES" to getStringResourceFromName(context, "country_ES"),
            "ET" to getStringResourceFromName(context, "country_ET"),
            "FI" to getStringResourceFromName(context, "country_FI"),
            "FJ" to getStringResourceFromName(context, "country_FJ"),
            "FK" to getStringResourceFromName(context, "country_FK"),
            "FM" to getStringResourceFromName(context, "country_FM"),
            "FO" to getStringResourceFromName(context, "country_FO"),
            "FR" to getStringResourceFromName(context, "country_FR"),
            "GA" to getStringResourceFromName(context, "country_GA"),
            "GB" to getStringResourceFromName(context, "country_GB"),
            "GD" to getStringResourceFromName(context, "country_GD"),
            "GE" to getStringResourceFromName(context, "country_GE"),
            "GF" to getStringResourceFromName(context, "country_GF"),
            "GH" to getStringResourceFromName(context, "country_GH"),
            "GI" to getStringResourceFromName(context, "country_GI"),
            "GL" to getStringResourceFromName(context, "country_GL"),
            "GM" to getStringResourceFromName(context, "country_GM"),
            "GN" to getStringResourceFromName(context, "country_GN"),
            "GP" to getStringResourceFromName(context, "country_GP"),
            "GQ" to getStringResourceFromName(context, "country_GQ"),
            "GR" to getStringResourceFromName(context, "country_GR"),
            "GS" to getStringResourceFromName(context, "country_GS"),
            "GT" to getStringResourceFromName(context, "country_GT"),
            "GU" to getStringResourceFromName(context, "country_GU"),
            "GW" to getStringResourceFromName(context, "country_GW"),
            "GY" to getStringResourceFromName(context, "country_GY"),
            "HK" to getStringResourceFromName(context, "country_HK"),
            "HM" to getStringResourceFromName(context, "country_HM"),
            "HN" to getStringResourceFromName(context, "country_HN"),
            "HR" to getStringResourceFromName(context, "country_HR"),
            "HT" to getStringResourceFromName(context, "country_HT"),
            "HU" to getStringResourceFromName(context, "country_HU"),
            "ID" to getStringResourceFromName(context, "country_ID"),
            "IE" to getStringResourceFromName(context, "country_IE"),
            "IL" to getStringResourceFromName(context, "country_IL"),
            "IN" to getStringResourceFromName(context, "country_IN"),
            "IO" to getStringResourceFromName(context, "country_IO"),
            "IQ" to getStringResourceFromName(context, "country_IQ"),
            "IR" to getStringResourceFromName(context, "country_IR"),
            "IS" to getStringResourceFromName(context, "country_IS"),
            "IT" to getStringResourceFromName(context, "country_IT"),
            "JM" to getStringResourceFromName(context, "country_JM"),
            "JO" to getStringResourceFromName(context, "country_JO"),
            "JP" to getStringResourceFromName(context, "country_JP"),
            "KE" to getStringResourceFromName(context, "country_KE"),
            "KG" to getStringResourceFromName(context, "country_KG"),
            "KH" to getStringResourceFromName(context, "country_KH"),
            "KI" to getStringResourceFromName(context, "country_KI"),
            "KM" to getStringResourceFromName(context, "country_KM"),
            "KN" to getStringResourceFromName(context, "country_KN"),
            "KP" to getStringResourceFromName(context, "country_KP"),
            "KR" to getStringResourceFromName(context, "country_KR"),
            "KW" to getStringResourceFromName(context, "country_KW"),
            "KY" to getStringResourceFromName(context, "country_KY"),
            "KZ" to getStringResourceFromName(context, "country_KZ"),
            "LA" to getStringResourceFromName(context, "country_LA"),
            "LB" to getStringResourceFromName(context, "country_LB"),
            "LC" to getStringResourceFromName(context, "country_LC"),
            "LI" to getStringResourceFromName(context, "country_LI"),
            "LK" to getStringResourceFromName(context, "country_LK"),
            "LR" to getStringResourceFromName(context, "country_LR"),
            "LS" to getStringResourceFromName(context, "country_LS"),
            "LT" to getStringResourceFromName(context, "country_LT"),
            "LU" to getStringResourceFromName(context, "country_LU"),
            "LV" to getStringResourceFromName(context, "country_LV"),
            "LY" to getStringResourceFromName(context, "country_LY"),
            "MA" to getStringResourceFromName(context, "country_MA"),
            "MC" to getStringResourceFromName(context, "country_MC"),
            "MD" to getStringResourceFromName(context, "country_MD"),
            "ME" to getStringResourceFromName(context, "country_ME"),
            "MG" to getStringResourceFromName(context, "country_MG"),
            "MH" to getStringResourceFromName(context, "country_MH"),
            "MK" to getStringResourceFromName(context, "country_MK"),
            "ML" to getStringResourceFromName(context, "country_ML"),
            "MM" to getStringResourceFromName(context, "country_MM"),
            "MN" to getStringResourceFromName(context, "country_MN"),
            "MO" to getStringResourceFromName(context, "country_MO"),
            "MP" to getStringResourceFromName(context, "country_MP"),
            "MQ" to getStringResourceFromName(context, "country_MQ"),
            "MR" to getStringResourceFromName(context, "country_MR"),
            "MS" to getStringResourceFromName(context, "country_MS"),
            "MT" to getStringResourceFromName(context, "country_MT"),
            "MU" to getStringResourceFromName(context, "country_MU"),
            "MV" to getStringResourceFromName(context, "country_MV"),
            "MW" to getStringResourceFromName(context, "country_MW"),
            "MX" to getStringResourceFromName(context, "country_MX"),
            "MY" to getStringResourceFromName(context, "country_MY"),
            "MZ" to getStringResourceFromName(context, "country_MZ"),
            "NA" to getStringResourceFromName(context, "country_NA"),
            "NC" to getStringResourceFromName(context, "country_NC"),
            "NE" to getStringResourceFromName(context, "country_NE"),
            "NF" to getStringResourceFromName(context, "country_NF"),
            "NG" to getStringResourceFromName(context, "country_NG"),
            "NI" to getStringResourceFromName(context, "country_NI"),
            "NL" to getStringResourceFromName(context, "country_NL"),
            "NO" to getStringResourceFromName(context, "country_NO"),
            "NP" to getStringResourceFromName(context, "country_NP"),
            "NR" to getStringResourceFromName(context, "country_NR"),
            "NU" to getStringResourceFromName(context, "country_NU"),
            "NZ" to getStringResourceFromName(context, "country_NZ"),
            "OM" to getStringResourceFromName(context, "country_OM"),
            "PA" to getStringResourceFromName(context, "country_PA"),
            "PE" to getStringResourceFromName(context, "country_PE"),
            "PF" to getStringResourceFromName(context, "country_PF"),
            "PG" to getStringResourceFromName(context, "country_PG"),
            "PH" to getStringResourceFromName(context, "country_PH"),
            "PK" to getStringResourceFromName(context, "country_PK"),
            "PL" to getStringResourceFromName(context, "country_PL"),
            "PM" to getStringResourceFromName(context, "country_PM"),
            "PN" to getStringResourceFromName(context, "country_PN"),
            "PR" to getStringResourceFromName(context, "country_PR"),
            "PS" to getStringResourceFromName(context, "country_PS"),
            "PT" to getStringResourceFromName(context, "country_PT"),
            "PW" to getStringResourceFromName(context, "country_PW"),
            "PY" to getStringResourceFromName(context, "country_PY"),
            "QA" to getStringResourceFromName(context, "country_QA"),
            "RE" to getStringResourceFromName(context, "country_RE"),
            "RO" to getStringResourceFromName(context, "country_RO"),
            "RS" to getStringResourceFromName(context, "country_RS"),
            "RU" to getStringResourceFromName(context, "country_RU"),
            "RW" to getStringResourceFromName(context, "country_RW"),
            "SA" to getStringResourceFromName(context, "country_SA"),
            "SB" to getStringResourceFromName(context, "country_SB"),
            "SC" to getStringResourceFromName(context, "country_SC"),
            "SD" to getStringResourceFromName(context, "country_SD"),
            "SE" to getStringResourceFromName(context, "country_SE"),
            "SG" to getStringResourceFromName(context, "country_SG"),
            "SH" to getStringResourceFromName(context, "country_SH"),
            "SI" to getStringResourceFromName(context, "country_SI"),
            "SJ" to getStringResourceFromName(context, "country_SJ"),
            "SK" to getStringResourceFromName(context, "country_SK"),
            "SL" to getStringResourceFromName(context, "country_SL"),
            "SM" to getStringResourceFromName(context, "country_SM"),
            "SN" to getStringResourceFromName(context, "country_SN"),
            "SO" to getStringResourceFromName(context, "country_SO"),
            "SR" to getStringResourceFromName(context, "country_SR"),
            "SS" to getStringResourceFromName(context, "country_SS"),
            "ST" to getStringResourceFromName(context, "country_ST"),
            "SU" to getStringResourceFromName(context, "country_SU"),
            "SV" to getStringResourceFromName(context, "country_SV"),
            "SY" to getStringResourceFromName(context, "country_SY"),
            "SZ" to getStringResourceFromName(context, "country_SZ"),
            "TC" to getStringResourceFromName(context, "country_TC"),
            "TD" to getStringResourceFromName(context, "country_TD"),
            "TF" to getStringResourceFromName(context, "country_TF"),
            "TG" to getStringResourceFromName(context, "country_TG"),
            "TH" to getStringResourceFromName(context, "country_TH"),
            "TJ" to getStringResourceFromName(context, "country_TJ"),
            "TK" to getStringResourceFromName(context, "country_TK"),
            "TL" to getStringResourceFromName(context, "country_TL"),
            "TM" to getStringResourceFromName(context, "country_TM"),
            "TN" to getStringResourceFromName(context, "country_TN"),
            "TO" to getStringResourceFromName(context, "country_TO"),
            "TP" to getStringResourceFromName(context, "country_TP"),
            "TR" to getStringResourceFromName(context, "country_TR"),
            "TT" to getStringResourceFromName(context, "country_TT"),
            "TV" to getStringResourceFromName(context, "country_TV"),
            "TW" to getStringResourceFromName(context, "country_TW"),
            "TZ" to getStringResourceFromName(context, "country_TZ"),
            "UA" to getStringResourceFromName(context, "country_UA"),
            "UG" to getStringResourceFromName(context, "country_UG"),
            "UM" to getStringResourceFromName(context, "country_UM"),
            "US" to getStringResourceFromName(context, "country_US"),
            "UY" to getStringResourceFromName(context, "country_UY"),
            "UZ" to getStringResourceFromName(context, "country_UZ"),
            "VA" to getStringResourceFromName(context, "country_VA"),
            "VC" to getStringResourceFromName(context, "country_VC"),
            "VE" to getStringResourceFromName(context, "country_VE"),
            "VG" to getStringResourceFromName(context, "country_VG"),
            "VI" to getStringResourceFromName(context, "country_VI"),
            "VN" to getStringResourceFromName(context, "country_VN"),
            "VU" to getStringResourceFromName(context, "country_VU"),
            "WF" to getStringResourceFromName(context, "country_WF"),
            "WS" to getStringResourceFromName(context, "country_WS"),
            "XC" to getStringResourceFromName(context, "country_XC"),
            "XG" to getStringResourceFromName(context, "country_XG"),
            "XI" to getStringResourceFromName(context, "country_XI"),
            "XK" to getStringResourceFromName(context, "country_XK"),
            "YE" to getStringResourceFromName(context, "country_YE"),
            "YT" to getStringResourceFromName(context, "country_YT"),
            "YU" to getStringResourceFromName(context, "country_YU"),
            "ZA" to getStringResourceFromName(context, "country_ZA"),
            "ZM" to getStringResourceFromName(context, "country_ZM"),
            "ZR" to getStringResourceFromName(context, "country_ZR"),
            "ZW" to getStringResourceFromName(context, "country_ZW")
        )
    }
}