package com.oml.recordtimedroid.presentacion;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import com.oml.recordtimedroid.R;
import com.oml.recordtimedroid.casos_uso.DiasHorasMinutosSegundosMilisegundos;
import com.oml.recordtimedroid.datos.MainDB;
import com.oml.recordtimedroid.modelo.MyTextView;
import com.oml.recordtimedroid.modelo.RegistroTiempos;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.widget.NestedScrollView;
import android.os.CountDownTimer;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.LinearLayout;
import android.widget.Toast;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import static android.view.ViewGroup.LayoutParams.MATCH_PARENT;
import static android.view.ViewGroup.LayoutParams.WRAP_CONTENT;
import static com.oml.recordtimedroid.datos.MainDB.extraeRegistroTiempos;

public class ScrollingActivity extends AppCompatActivity {
    private int linea;
    private long lFechaAnterior;
    private String fileName;
    private MyTextView mtvSumLapses;
    private long lTotal;
    private long lFechaInicial;
    private LinearLayout csLL;
    private final Context myContext = this;
    private MainDB mainDB;
    private Toast mToastToShow;
    private String mToastToShowMessage;
    private SimpleDateFormat sdfDateFormat;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_scrolling);
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        this.csLL = findViewById(R.id.cs_linear_layout);
        this.mtvSumLapses = findViewById(R.id.sumLapses);
        this.mainDB = new MainDB(this);
        this.mToastToShowMessage = "";
        this.sdfDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS", Locale.ROOT);
        this.linea = 1;
        this.fileName = "lines";
        this.lFechaInicial = -1;

        primeraLecturaLineas();

        FloatingActionButton fab = findViewById(R.id.fab);
        fab.setOnClickListener(this::recordTime);
    }

    private void calculaDiasHorasMinutosSegundos(long dIni, long dFin,
                                                 DiasHorasMinutosSegundosMilisegundos dhmsm) {
        long diff = dFin - dIni;
        long secondsInMilli = 1000;
        long minutesInMilli = secondsInMilli * 60;
        long hoursInMilli = minutesInMilli * 60;
        long daysInMilli = hoursInMilli * 24;

        long elapsedDays = diff / daysInMilli;
        diff = diff % daysInMilli;

        long elapsedHours = diff / hoursInMilli;
        diff = diff % hoursInMilli;

        long elapsedMinutes = diff / minutesInMilli;
        diff = diff % minutesInMilli;

        long elapsedSeconds = diff / secondsInMilli;
        diff = diff % secondsInMilli;

        dhmsm.setDias(elapsedDays);
        dhmsm.setHoras(elapsedHours);
        dhmsm.setMinutos(elapsedMinutes);
        dhmsm.setSegundos(elapsedSeconds);
        dhmsm.setMilisegundos(diff);
    }

    @Override
    public boolean onCreateOptionsMenu(@NonNull Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_scrolling, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        if (id == R.id.action_acerca_de) {
            Intent i = new Intent(this, AcercaDeActivity.class);
            startActivity(i);

            return true;
        }

        if (id == R.id.action_reset) {
            try {
                mainDB.inicializaDB();
                int csLLGCC = csLL.getChildCount();
                for (int i = 1; i < csLLGCC; i++) {
                    csLL.removeView(csLL.getChildAt(1));
                }

                linea = 1;
                mtvSumLapses.setText("");
                mtvSumLapses.setlDiferencia(0);
                lFechaInicial = -1;

            } catch(Exception e) {
                e.printStackTrace();
                //Toast.makeText(getBaseContext(),e.getMessage(), Toast.LENGTH_LONG).show();
                showToast(getBaseContext(), e.getMessage(), 10000);
            }

            return true;
        }

        if (id == R.id.action_delete) {
            boolean cambiarlFechaAnterior = false;
            boolean cambiarMtvSiguiente = false;

            for (int i = csLL.getChildCount() - 1; i > 0; i--) {
                if ( csLL.getChildAt( i ) instanceof MyTextView ) {

                    MyTextView mtv = (MyTextView) csLL.getChildAt( i );

                    if ( cambiarMtvSiguiente && (i < (csLL.getChildCount() - 1)) ) {
                        reCalculaDiferencia(i);
                    }

                    if (cambiarlFechaAnterior) {
                        int _id = mtv.get_id();
                        if (_id == -1) {
                            lFechaAnterior = -1;
                        } else {
                            RegistroTiempos rt = mainDB.elemento(_id);
                            lFechaAnterior = rt.getTiempo();
                        }
                        cambiarlFechaAnterior = false;
                    }

                    if (mtv.isSelected()) {
                        if ( i == (csLL.getChildCount() - 1) ) cambiarlFechaAnterior = true;
                        RestaTotalYSelected(i);
                        mainDB.borra(mtv.get_id());
                        csLL.removeViewAt(i);
                        linea--;
                        cambiarMtvSiguiente = true;
                    }

                }
            }

            return true;
        }

        if (id == R.id.action_delete_first) {
            for (int i = 1; i < csLL.getChildCount(); i++) {
                if ( csLL.getChildAt( i ) instanceof MyTextView ) {

                    mainDB.borra(((MyTextView) csLL.getChildAt(i)).get_id());

                    calculaTotal1(i);

                    csLL.removeViewAt(i);
                    linea--;

                    if ( i < csLL.getChildCount()) {
                        int _id = ((MyTextView) csLL.getChildAt(i)).get_id();
                        RegistroTiempos rt = mainDB.elemento(_id);
                        lFechaInicial = rt.getTiempo();
                    } else {
                        lFechaInicial = -1;
                    }

                    if (i < csLL.getChildCount()) {
                        MyTextView mtv = (MyTextView) csLL.getChildAt(i);
                        String s = mtv.getText().toString();
                        String[] sa = s.split("\\|");
                        String text = sa[0] + "|" + sa[1] + "|";
                        mtv.setText(text);
                        if (mtv.isSelected()) mtv.callOnClick();
                        mtv.setOnClickListener(null);
                    }

                    break;
                }
            }

            return true;
        }

        if (id == R.id.action_go_top) {
            AppBarLayout abl = findViewById(R.id.app_bar);
            abl.setExpanded(true);
            NestedScrollView nsv = findViewById(R.id.content_scrolling);
            nsv.fullScroll(View.FOCUS_UP);

            return true;
        }

        if (id == R.id.action_go_bottom) {
            AppBarLayout abl = findViewById(R.id.app_bar);
            abl.setExpanded(false);
            NestedScrollView nsv = findViewById(R.id.content_scrolling);
            nsv.fullScroll(View.FOCUS_DOWN);

            return true;
        }

        if (id == R.id.action_record_time) {
            View view = findViewById(R.id.content_scrolling);
            recordTime(view);

            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    //On click listener for dynamic myTextView
    final private View.OnClickListener mtv_OnClickListener = new View.OnClickListener() {
        public void onClick(final View v) {
            if (((MyTextView) v).getSelectionStart() != ((MyTextView) v).getSelectionEnd()) return;
            // Issue:
            // If you click over a selected line it doesn't deselect if you click again.
            // You need to select another line and click again the previous line to deselect it.
            // Executes twice this method, so I set enabled to false to avoid it.
            v.setEnabled(false);
            boolean selected = !v.isSelected();
            DiasHorasMinutosSegundosMilisegundos dhmsmTempo =
                    new DiasHorasMinutosSegundosMilisegundos();
            String sTipo;

            v.setSelected(selected);
            v.setBackgroundColor(selected ? Color.CYAN : Color.TRANSPARENT);

            if (selected) {
                mtvSumLapses.setlDiferencia(mtvSumLapses.getlDiferencia() +
                        ((MyTextView) v).getlDiferencia());
            } else {
                mtvSumLapses.setlDiferencia(mtvSumLapses.getlDiferencia() -
                        ((MyTextView) v).getlDiferencia());
            }

            if (mtvSumLapses.getlDiferencia() == 0) {
                sTipo = getResources().getString(R.string.total);
                calculaDiasHorasMinutosSegundos(lTotal, 0, dhmsmTempo);
            } else {
                sTipo = getResources().getString(R.string.selected_lines);
                calculaDiasHorasMinutosSegundos(mtvSumLapses.getlDiferencia(), 0, dhmsmTempo);
            }

            if (lTotal == 0L) {
                mtvSumLapses.setText("");
            } else {
                mtvSumLapses.setText(String.format(Locale.ROOT,
                        "%s %03d %s %02d:%02d:%02d.%03d",
                        sTipo,
                        (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
                        (int) dhmsmTempo.getHoras(),
                        (int) dhmsmTempo.getMinutos(), (int) dhmsmTempo.getSegundos(),
                        (int) dhmsmTempo.getMilisegundos()));
                mtvSumLapses.resizeText();
            }
            v.setEnabled(true);
        }
    };

    private void addDateDB(RegistroTiempos r) {
        mainDB.anade(r);
    }

    private void showToast(Context context, String message, int toastDurationInMilliSeconds) {
        if (mToastToShowMessage.equals("")) {
            mToastToShowMessage = message;
        } else {
            mToastToShowMessage += "\n" + message;
        }
        mToastToShow = Toast.makeText(context, mToastToShowMessage, Toast.LENGTH_LONG);

        // Set the countdown to display the toast
        CountDownTimer toastCountDown;
        toastCountDown = new CountDownTimer(toastDurationInMilliSeconds, 1000) {
            public void onTick(long millisUntilFinished) {
                mToastToShow.show();
            }

            public void onFinish() {
                mToastToShow.cancel();
                mToastToShowMessage = "";
            }
        };

        // Show the toast and starts the countdown
        mToastToShow.show();
        toastCountDown.start();
    }

    private void primeraLecturaLineas() {
        runOnUiThread(() -> {
            DiasHorasMinutosSegundosMilisegundos dhmsmTempo =
                    new DiasHorasMinutosSegundosMilisegundos();
            StringBuilder sbBuff = new StringBuilder();

            try {

                String[] sFileList = myContext.fileList();
                // Read data from sequencial file, saves it in DB SQLite and deletes file.
                if (Arrays.asList(sFileList).contains(fileName)) {
                    FileInputStream fin = openFileInput(fileName);
                    int c;
                    long lFecha;
                    lFechaAnterior = -1;

                    mtvSumLapses.setlDiferencia(0);

                    while ((c = fin.read()) != -1) {
                        if (c == '\n') {
                            // To be backward compatible with file format dd-MM-yyyy HH:mm:ss.SSS
                            if (sbBuff.toString().contains("-")) {
                                Date d = sdfDateFormat.parse(sbBuff.toString());
                                if (d != null) {
                                    lFecha = d.getTime();
                                    //Add Fecha to DB
                                    RegistroTiempos r = new RegistroTiempos(lFecha);
                                    addDateDB(r);
                                } else {
                                    lFecha = 0;
                                }
                            } else {
                                lFecha = Long.parseLong(sbBuff.toString());
                                // Add Fecha to DB
                                RegistroTiempos reg = new RegistroTiempos(lFecha);
                                addDateDB(reg);
                            }
                            if (lFechaInicial == -1) lFechaInicial = lFecha;
                            lFechaAnterior = lFecha;
                            sbBuff.setLength(0);
                            lTotal = lFechaInicial - lFecha;
                        } else {
                            sbBuff.append( (char)c );
                        }
                    }
                    fin.close();
                    // Delete file
                    boolean ret = deleteFile(fileName);
                    if (!ret) {
                        showToast(getBaseContext(),
                                getResources().getString(R.string.error_deleting_file) +
                                " " + fileName, 10000);
                    }
                }

                // TODO:Read data from SQLite DB
                // SELECT _id, DATETIME(ROUND(time / 1000), 'unixepoch') AS isodate FROM recordtimes;
                // INSERT INTO recordtimes (time) VALUES(1589025299803);
                // DELETE FROM recordtimes WHERE _id = 282;
                Cursor c = mainDB.extraeCursor();
                lFechaAnterior = -1;
                RegistroTiempos registroTiempos;
                float mtvTextSize = 12f;

                while (c.moveToNext()) {
                    registroTiempos = extraeRegistroTiempos(c);
                    if (lFechaInicial == -1) lFechaInicial = registroTiempos.getTiempo();
                    Date d = new Date(registroTiempos.getTiempo());
                    String sFecha = sdfDateFormat.format(d);
                    // Create MyTextView dynamically
                    MyTextView mtv = new MyTextView(myContext);
                    mtv.setText(String.format(Locale.ROOT, "%03d | %s |",
                            registroTiempos.get_id(), sFecha));
                    mtv.setSelected(false);
                    if (lFechaAnterior != -1) {
                        calculaDiasHorasMinutosSegundos(lFechaAnterior,
                                registroTiempos.getTiempo(), dhmsmTempo);
                        mtv.setText(String.format(Locale.ROOT,
                                "%s %03d %s %02d:%02d:%02d.%03d",
                                mtv.getText(),
                                (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
                                (int) dhmsmTempo.getHoras(),
                                (int) dhmsmTempo.getMinutos(), (int) dhmsmTempo.getSegundos(),
                                (int) dhmsmTempo.getMilisegundos()));
                        mtv.setlDiferencia(lFechaAnterior - registroTiempos.getTiempo());
                        calculaDiasHorasMinutosSegundos(lFechaInicial,
                                registroTiempos.getTiempo(), dhmsmTempo);
                        mtvSumLapses.setText(String.format(Locale.ROOT,
                                "%s %03d %s %02d:%02d:%02d.%03d",
                                getResources().getString(R.string.total),
                                (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
                                (int) dhmsmTempo.getHoras(),
                                (int) dhmsmTempo.getMinutos(), (int) dhmsmTempo.getSegundos(),
                                (int) dhmsmTempo.getMilisegundos()));
                        mtvSumLapses.resizeText();
                        mtv.setOnClickListener(mtv_OnClickListener);
                    }

                    lFechaAnterior = registroTiempos.getTiempo();
                    sbBuff.setLength(0);
                    mtv.setTextIsSelectable(true);
                    mtv.set_id(registroTiempos.get_id());

                    mtv.setMaxLines(1);
                    mtv.resizeText();
                    csLL.addView(mtv);
                    lTotal = lFechaInicial - lFechaAnterior;
                    linea++;
                }

                c.close();
            } catch(Exception e) {
                e.printStackTrace();
                showToast(getBaseContext(), e.getMessage(), 10000);
            }
        });
    }

    private void RestaTotalYSelected(int pos) {
        if ( csLL.getChildAt( pos ) instanceof MyTextView ) {
            MyTextView mtv = (MyTextView) csLL.getChildAt( pos );
            if (pos == csLL.getChildCount() - 1) lTotal -= mtv.getlDiferencia();
            if (mtv.isSelected()) {
                mtv.callOnClick();
            }
        }
    }

    private void reCalculaDiferencia(int pos) {
        MyTextView mtv = (MyTextView) csLL.getChildAt( pos + 1);

        int _id1 = ((MyTextView) csLL.getChildAt( pos )).get_id();
        RegistroTiempos rt1 = mainDB.elemento(_id1);

        int _id2 = ((MyTextView) csLL.getChildAt( pos + 1)).get_id();
        RegistroTiempos rt2 = mainDB.elemento(_id2);

        mtv.setlDiferencia( rt1.getTiempo() - rt2.getTiempo());

        DiasHorasMinutosSegundosMilisegundos dhmsmTempo =
                new DiasHorasMinutosSegundosMilisegundos();

        Date d = new Date(rt2.getTiempo());
        String sFecha = sdfDateFormat.format(d);
        mtv.setText(String.format(Locale.ROOT, "%03d | %s |", rt2.get_id(), sFecha));
        calculaDiasHorasMinutosSegundos(rt1.getTiempo(), rt2.getTiempo(), dhmsmTempo);
        mtv.setText(String.format(Locale.ROOT, "%s %03d %s %02d:%02d:%02d.%03d",
            mtv.getText(),
            (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
            (int) dhmsmTempo.getHoras(),
            (int) dhmsmTempo.getMinutos(), (int) dhmsmTempo.getSegundos(),
            (int) dhmsmTempo.getMilisegundos()));
    }

    private void calculaTotal1(int pos) {
        if ( (pos + 1) < csLL.getChildCount() ) {
            lTotal -= ((MyTextView) csLL.getChildAt(pos + 1)).getlDiferencia();
        } else {
            lTotal = 0;
        }

        boolean bSubTotal = false;

        for (int i = 1; i < csLL.getChildCount(); i++) {

            if ( csLL.getChildAt( i ) instanceof MyTextView ) {
                MyTextView mtv = (MyTextView) csLL.getChildAt(i);

                if (mtv.isSelected()) {
                    bSubTotal = true;
                    break;
                }

            }
        }

        if (bSubTotal) {
            DiasHorasMinutosSegundosMilisegundos dhmsmTempo =
                    new DiasHorasMinutosSegundosMilisegundos();
            calculaDiasHorasMinutosSegundos(mtvSumLapses.getlDiferencia(), 0, dhmsmTempo);

            mtvSumLapses.setText(String.format(Locale.ROOT, "%s %03d %s %02d:%02d:%02d.%03d",
                    getResources().getString(R.string.selected_lines),
                    (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
                    (int) dhmsmTempo.getHoras(),
                    (int) dhmsmTempo.getMinutos(), (int) dhmsmTempo.getSegundos(),
                    (int) dhmsmTempo.getMilisegundos()));
        } else {
            if (lTotal == 0L) {
                mtvSumLapses.setText("");
            } else {
                DiasHorasMinutosSegundosMilisegundos dhmsmTempo =
                        new DiasHorasMinutosSegundosMilisegundos();
                calculaDiasHorasMinutosSegundos(lTotal, 0, dhmsmTempo);

                mtvSumLapses.setText(String.format(Locale.ROOT,
                        "%s %03d %s %02d:%02d:%02d.%03d",
                        getResources().getString(R.string.total),
                        (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
                        (int) dhmsmTempo.getHoras(),
                        (int) dhmsmTempo.getMinutos(), (int) dhmsmTempo.getSegundos(),
                        (int) dhmsmTempo.getMilisegundos()));
            }
        }
    }

    @Override
    public void onDestroy(){
        super.onDestroy();
        mainDB.close();
    }

    private void recordTime(View view) {
        Date dFechaHora = new Date();
        long lFechaActual = dFechaHora.getTime();

        if (lFechaInicial == -1) lFechaInicial = lFechaActual;
        String sFecha = sdfDateFormat.format(dFechaHora);
        MyTextView mtv = new MyTextView(myContext);

        // Save time in DB with unix timestamp in milliseconds
        int _id = -1;
        try {
            RegistroTiempos registroTiempos = new RegistroTiempos(lFechaActual);
            _id = mainDB.anade(registroTiempos);
            mtv.set_id(_id);
        } catch(Exception e) {
            e.printStackTrace();
            showToast(getBaseContext(), e.getMessage(), 10000);
        }

        LinearLayout.LayoutParams llLP = new LinearLayout.LayoutParams(MATCH_PARENT,
                WRAP_CONTENT);
        llLP.setMargins(0, 2, 0, 0);
        mtv.setLayoutParams(llLP);
        mtv.setText(String.format(Locale.ROOT, "%03d | %s |", _id, sFecha));
        if (linea > 1) {
            DiasHorasMinutosSegundosMilisegundos dhmsmTempo =
                    new DiasHorasMinutosSegundosMilisegundos();
            calculaDiasHorasMinutosSegundos(lFechaAnterior, lFechaActual, dhmsmTempo);
            String sDiferencia = String.format(Locale.ROOT,
                    "%03d %s %02d:%02d:%02d.%03d",
                    (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
                    (int) dhmsmTempo.getHoras(), (int) dhmsmTempo.getMinutos(),
                    (int) dhmsmTempo.getSegundos(), (int) dhmsmTempo.getMilisegundos());
            mtv.setText(String.format(Locale.ROOT, "%s %s", mtv.getText(),
                    sDiferencia));
            mtv.resizeText();
            lTotal = lFechaInicial - lFechaActual;
            mtv.setlDiferencia(lFechaAnterior - lFechaActual);

            boolean bSubTotal = false;

            for (int i = 0; i < csLL.getChildCount(); i++) {
                if (csLL.getChildAt(i).isSelected()) {
                    bSubTotal = true;
                    break;
                }
            }

            if (!bSubTotal) {

                if (lTotal == 0L) {
                    mtvSumLapses.setText("");
                } else {
                    calculaDiasHorasMinutosSegundos(lTotal, 0, dhmsmTempo);
                    mtvSumLapses.setText(String.format(Locale.ROOT,
                            "%s %03d %s %02d:%02d:%02d.%03d",
                            getResources().getString(R.string.total),
                            (int) dhmsmTempo.getDias(), getResources().getString(R.string.dias),
                            (int) dhmsmTempo.getHoras(),
                            (int) dhmsmTempo.getMinutos(), (int) dhmsmTempo.getSegundos(),
                            (int) dhmsmTempo.getMilisegundos()));
                    mtvSumLapses.resizeText();
                }
            }

            mtv.setOnClickListener(mtv_OnClickListener);
            String notification = getResources().getString(R.string.notificacion) + " " +
                    linea + " +" + sDiferencia;
            Snackbar.make(view, notification, Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
        }

        linea++;
        lFechaAnterior = lFechaActual;
        mtv.setTextIsSelectable(true);
        csLL.addView(mtv);
    }
}
