package com.oml.recordtimedroid.datos;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.oml.recordtimedroid.R;
import com.oml.recordtimedroid.modelo.RegistroTiempos;

public class MainDB extends SQLiteOpenHelper implements RepositorioTimes {

    Context contexto;

    public MainDB(Context contexto) {
        super(contexto, "recordtimedroid.sqlite", null ,1);
        this.contexto = contexto;
    }

    @Override
    public void onCreate(SQLiteDatabase bd) {
        bd.execSQL("CREATE TABLE recordtimes ("+
                "_id INTEGER PRIMARY KEY AUTOINCREMENT, " +
                "time LONG)");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion,
                                             int newVersion) {
    }

    public static RegistroTiempos extraeRegistroTiempos(Cursor cursor) {
        RegistroTiempos registroTiempo = new RegistroTiempos();
        registroTiempo.set_id(cursor.getInt(0));
        registroTiempo.setTiempo(cursor.getLong(1));
        return registroTiempo;
    }

    public Cursor extraeCursor() {
        //SharedPreferences pref =
        //        PreferenceManager.getDefaultSharedPreferences(contexto);
        //String ordenacion = pref.getString("ordenacion","_id");
        String ordenacion = "time";
        String consulta = "SELECT * FROM recordtimes ORDER BY " +
                ordenacion;
        SQLiteDatabase bd = getReadableDatabase();
        return bd.rawQuery(consulta, null);
    }

    @Override
    public void actualiza(int id, RegistroTiempos registroTiempos) {
        getWritableDatabase().execSQL("UPDATE recordtimes SET" +
                " time = " + registroTiempos.getTiempo() +
                " WHERE _id = " + id);
    }

    @Override
    public int tamanyo() {
        return 0;
    }

    @Override
    public void borra(int id) {
        getWritableDatabase().execSQL("DELETE FROM recordtimes WHERE _id = " + id);
    }

    @Override
    public int anade(RegistroTiempos registroTiempos) {
        int _id = 0;

        getWritableDatabase().execSQL("INSERT INTO recordtimes (time) VALUES (" +
                registroTiempos.getTiempo() + ")");
        Cursor c = getReadableDatabase().rawQuery(
                "SELECT _id FROM recordtimes WHERE time = " + registroTiempos.getTiempo(), null);
        if (c.moveToNext()) _id = c.getInt(0);
        c.close();

        return _id;
    }

    @Override
    public RegistroTiempos elemento(int id) {
        try (Cursor cursor = getReadableDatabase().rawQuery(
                "SELECT * FROM recordtimes WHERE _id = " + id, null)) {
            if (cursor.moveToNext())
                return extraeRegistroTiempos(cursor);
            else
                throw new SQLException(contexto.getResources().getString(R.string.error_accesing_element) + " " + id);
        } catch (Exception e) {
            Log.i("ERROR", "elemento: Exception: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void inicializaDB() {
        this.close();
        String dbPath = contexto.getDatabasePath(this.getDatabaseName()).getPath();
        contexto.deleteDatabase(this.getDatabaseName());
        SQLiteDatabase.openOrCreateDatabase(dbPath, null);
    }
}
