<p align="center">
  <a href="#">
    <img src="https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/rounder_icon.png?raw=true" alt="Logo" width="120" height="120">
  </a>

  <h3 align="center">Privacy Indicators for Android</h3>

  <p align="center">
    Get notified every time a third-party app or a service uses camera or microphone. Inspired from ios14 and Android 12 recording indicators. 
    <br />
    <a href="#download-from-here">Download</a>
    .
    <a href="https://github.com/NitishGadangi/Privacy-Indicator-App/issues">Report Bug</a>
    .
    <a href="https://github.com/NitishGadangi/Privacy-Indicator-App/issues">Request Feature</a>
    .
   <a href="https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/CONTRIBUTING.md">Contribute</a>
  
  <h4 align="center">Check out the Demo Video 📽 on <a href="https://www.youtube.com/watch?v=kDc7TF9JSyc&feature=youtu.be">Youtube</a></h3>
  <h5 align="center">Made with ❤️ by <a href="https://nitishgadangi.github.io/">Nitish Gadangi</a></h3>
  <h5 align="center">Winner 🏆 <a href="https://fossunited.org/hackathon">FOSS HACKS 2020</a></h3>
<p align="center">
  <a href='https://nitishgadangi.github.io/?buy_me_coffee' target='_blank'>
    <img height='36' style='border:0px;height:36px;' src='https://bmc-cdn.nyc3.digitaloceanspaces.com/BMC-button-images/custom_images/orange_img.png' border='0' alt='Buy Me a Coffee' />
  </a>
</p>
  </p>
</p>
</br>
<hr/>

<!--
## FOSS HACKS 2020
Privacy Indicators App is ideated and built in [FossHacks 2020](https://fossunited.org/hackathon). The [results for the Hackathon](https://forum.fossunited.org/t/foss-hack-2020-results/424) are out and Privacy Indicators App stood one among the Winning projects and Bagged prize money of ₹25000. Special thanks to [Team FOSS UNITED](https://fossunited.org/) for establishing such an amazing platform and uplifting Free and OpenSource software in India.

![Results](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/foss_hacks_results.jpg?raw=true)

Also checkout other [projects which are into list of Winners](https://forum.fossunited.org/t/foss-hack-2020-results/424), trust me they are equally interesting and amazing 💯. 
-->


##  About Privacy Indicators app
Privacy Indicators will bring the above Recording Indicators feature of iOS 14 to Android (With more extra features and Customizations 🥳). 
* Get Notified every time any third-party app is accessing your Camera.
* Get Notified every time any app is accessing your Microphone.
* You can customize indicator color, size, opacity and its position
* Option to enable Haptic feedback when indicators appear
* You can turn off any individual features in required
* View log of Indicators tiggered at one place.

*So install the app and you will never have trust issues with the Camera and Mic usage 😉.*

![demo gif](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/demo.gif?raw=true)

## Screenshots
|![Screenshot1](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/ss1.png?raw=true)|![Screenshot2](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/ss2.png?raw=true)|![Screenshot3](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/ss3.png?raw=true)|
|---|---|---|
|![Screenshot4](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/ss4.png?raw=true)|![Screenshot5](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/ss5.png?raw=true)|![Screenshot6](https://github.com/NitishGadangi/Privacy-Indicator-App/blob/master/screenshots/ss6.png?raw=true)|

> This Service/App doesn\'t have any permission to use the internet or your
> device\'s camera, microphone, or any other Hardware. And will NOT
> gather any data whatsoever.


## Download from here:

<a href='https://play.google.com/store/apps/details?id=com.nitish.privacyindicator' target='_blank'>
    <img height='150' style='border:0px;height:150px;' src='https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png' border='0' alt='Download from Google Play' />   </a>
  
<a href='https://f-droid.org/en/packages/com.nitish.privacyindicator/' target='_blank'>
    <img height='150' style='border:0px;height:150px;' src='https://fdroid.gitlab.io/artwork/badge/get-it-on.png' border='0' alt='Download from F-Droid' />   </a>

<h4>You can also access all the releases from <a href="https://github.com/NitishGadangi/Privacy-Indicator-App/releases">Releases tab</a></h3>


## How to Use

1. This App will work only on devices with _Android_ 7.0 (_API_ level _24_) and above, so make sure you having the compatible device.
2. After installing the App, Enable the Service from the Accessibility Settings.
3. You can Customise the Indicators color and position as per your choice from the Home.
4. Also if required you can enable the Vibration Feedback option.
5. Kudos 🤝, You are good to go. 
6. The Service keeps running in the background and automatically starts even you restart the mobile 😎.


## Built With  🛠

Some of the popular libraries and MVVM clean architecture used with Room database as a source

-   [Kotlin](https://kotlinlang.org/)  - First class and official programming language for Android development.
    
-   [Coroutines](https://kotlinlang.org/docs/reference/coroutines-overview.html)  - Threads on steroids for Kotlin
    
-   [Android JetPack](https://developer.android.com/jetpack)  - Collection of libraries that help you design robust, testable, and maintainable apps.
    
    -   [Paging3](https://developer.android.com/topic/libraries/architecture/paging)  - Load and display small chunks of data at a time.
    -   [ViewModel](https://developer.android.com/topic/libraries/architecture/viewmodel)  - Stores UI-related data that isn't destroyed on UI changes.
    -   [ViewBinding](https://developer.android.com/topic/libraries/view-binding)  - A robust replacement for findViewById, kotlin sytnhetics and DataBinding
    -   [Navigation Components](https://developer.android.com/guide/navigation/navigation-getting-started)  - Navigate fragments as never easier before
    -   [SavedStateHandle](https://developer.android.com/reference/androidx/lifecycle/SavedStateHandle)  - A handle to saved state passed down to androidx.lifecycle.ViewModel.
    -   [Room](https://developer.android.google.cn/jetpack/androidx/releases/room)  - Persistence library provides an abstraction layer over SQLite to allow for more robust database access while harnessing the full power of SQLite.

-   [Material Components for Android](https://github.com/material-components/material-components-android)  - Modular and customizable Material Design UI components for Android.
    
-   [Dependency Injection](https://developer.android.com/training/dependency-injection)  -
    
    -   [Hilt-Dagger](https://dagger.dev/hilt/)  - Standard library to incorporate Dagger dependency injection into an Android application.
    -   [Hilt-ViewModel](https://developer.android.com/training/dependency-injection/hilt-jetpack)  - DI for injecting  `ViewModel`.
-   Architecture
    
    -   Clean Architecture
    -   MVVM
    -   Offline with Room


## Back Story
**Recording Indicators in iOS14 :** With iOS 14, Apple is introducing a camera and microphone recording indicator in the status bar. It will appear as an orange dot above the signal bar. The **idea of a recording indicator is to alert users whenever the mic or camera are being used.** The feature will give users more control over data and privacy.
![enter image description here](https://9to5mac.com/wp-content/uploads/sites/6/2020/07/green-dot-ios-14.jpg?quality=82&strip=all)

**However Android lacks such kind of privacy feature**. **Apparently, any app can use your Camera and Mic without any special notification** (once you have granted the permission). This might give a door for Malware to run a service in the background and Track everything you do Visually and Might be a threat to your privacy.

With the increase in usage of Online Platforms for Audio and Video Conferences, it's important to track which app is accessing your Camera or Microphone in the Realtime.


## Like my work?
I am a student, tutor, engineer, and a maker to various projects. For 2+ years, I have been working on Open Source.

If you use any of my projects or like what I'm doing, please consider backing me with simple donations so that I can continue my open source work.

[![Buy me a coffee](https://bmc-cdn.nyc3.digitaloceanspaces.com/BMC-button-images/custom_images/orange_img.png)](https://nitishgadangi.github.io/?buy_me_coffee)

**Consider Giving a ⭐ [here](https://github.com/NitishGadangi/Privacy-Indicator-App/) .**

## Credits

**Thanks to [Dhaval2404](https://github.com/Dhaval2404/) for the amazing [ColorPicker](https://github.com/Dhaval2404/ColorPicker) for Android**

**Special Credits to [sanjaveljanoska](https://dribbble.com/sanjaveljanoska) for the awesome icon**

**Made with ❤️ by Nitish**
