package com.mshdabiola.designsystem.icon

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.outlined.ArrowBack
import androidx.compose.material.icons.automirrored.outlined.Label
import androidx.compose.material.icons.automirrored.outlined.Redo
import androidx.compose.material.icons.automirrored.outlined.Undo
import androidx.compose.material.icons.filled.PushPin
import androidx.compose.material.icons.outlined.AccessTime
import androidx.compose.material.icons.outlined.Add
import androidx.compose.material.icons.outlined.AddBox
import androidx.compose.material.icons.outlined.Archive
import androidx.compose.material.icons.outlined.Brush
import androidx.compose.material.icons.outlined.Cancel
import androidx.compose.material.icons.outlined.CheckBox
import androidx.compose.material.icons.outlined.CheckBoxOutlineBlank
import androidx.compose.material.icons.outlined.Clear
import androidx.compose.material.icons.outlined.ColorLens
import androidx.compose.material.icons.outlined.ContentCopy
import androidx.compose.material.icons.outlined.Delete
import androidx.compose.material.icons.outlined.Done
import androidx.compose.material.icons.outlined.Edit
import androidx.compose.material.icons.outlined.ExpandLess
import androidx.compose.material.icons.outlined.ExpandMore
import androidx.compose.material.icons.outlined.FormatColorReset
import androidx.compose.material.icons.outlined.GridView
import androidx.compose.material.icons.outlined.Image
import androidx.compose.material.icons.outlined.ImageNotSupported
import androidx.compose.material.icons.outlined.Info
import androidx.compose.material.icons.outlined.KeyboardVoice
import androidx.compose.material.icons.outlined.Link
import androidx.compose.material.icons.outlined.Menu
import androidx.compose.material.icons.outlined.MoreVert
import androidx.compose.material.icons.outlined.NotificationAdd
import androidx.compose.material.icons.outlined.Notifications
import androidx.compose.material.icons.outlined.PauseCircle
import androidx.compose.material.icons.outlined.PhotoCamera
import androidx.compose.material.icons.outlined.PlayCircle
import androidx.compose.material.icons.outlined.PushPin
import androidx.compose.material.icons.outlined.Search
import androidx.compose.material.icons.outlined.Settings
import androidx.compose.material.icons.outlined.Share
import androidx.compose.material.icons.outlined.Unarchive
import androidx.compose.material.icons.outlined.ViewAgenda
import androidx.compose.ui.graphics.Color
import com.mshdabiola.designsystem.R

object NoteIcon {

    val Edit = Icons.Outlined.Edit
    val ViewAgenda = Icons.Outlined.ViewAgenda
    val Menu = Icons.Outlined.Menu
    val GridView = Icons.Outlined.GridView
    val CheckBoxOutlineBlank = Icons.Outlined.CheckBoxOutlineBlank
    val Undo = Icons.AutoMirrored.Outlined.Undo
    val Redo = Icons.AutoMirrored.Outlined.Redo
    val AccessTime = Icons.Outlined.AccessTime
    val Share = Icons.Outlined.Share
    val ContentCopy = Icons.Outlined.ContentCopy
    val Unarchive = Icons.Outlined.Unarchive
    val PushPinD = Icons.Default.PushPin
    val PushPin = Icons.Outlined.PushPin
    val NotificationAdd = Icons.Outlined.NotificationAdd
    val AddBox = Icons.Outlined.AddBox
    val ColorLens = Icons.Outlined.ColorLens
    val Clear = Icons.Outlined.Clear
    val PauseCircle = Icons.Outlined.PauseCircle
    val PlayCircle = Icons.Outlined.PlayCircle
    val ImageNotSupported = Icons.Outlined.ImageNotSupported
    val Done = Icons.Outlined.Done
    val FormatColorReset = Icons.Outlined.FormatColorReset
    val PhotoCamera = Icons.Outlined.PhotoCamera
    val Brush = Icons.Outlined.Brush
    val CheckBox = Icons.Outlined.CheckBox
    val Image = Icons.Outlined.Image
    val KeyboardVoice = Icons.Outlined.KeyboardVoice
    val Cancel = Icons.Outlined.Cancel
    val ArrowBack = Icons.AutoMirrored.Outlined.ArrowBack
    val MoreVert = Icons.Outlined.MoreVert
    val Search = Icons.Outlined.Search
    val Add = Icons.Outlined.Add
    val Archive = Icons.Outlined.Archive
    val Delete = Icons.Outlined.Delete
    val Info = Icons.Outlined.Info
    val Label = Icons.AutoMirrored.Outlined.Label
    val Notification = Icons.Outlined.Notifications
    val Settings = Icons.Outlined.Settings
    val Link = Icons.Outlined.Link

    val More = Icons.Outlined.ExpandMore
    val Less = Icons.Outlined.ExpandLess
    val background = listOf(
        NoteBg(Color(0xFF737D55), R.drawable.modules_designsystem_asset_1),
        NoteBg(Color(0xFFDB69A3), R.drawable.modules_designsystem_asset_2),
        NoteBg(Color(0xFFB80D57), R.drawable.modules_designsystem_asset_3),
        NoteBg(Color(0xFFC26744), R.drawable.modules_designsystem_asset_4),
        NoteBg(Color(0xFFA3F7B7), R.drawable.modules_designsystem_asset_5),
        NoteBg(Color(0xFFE660B7), R.drawable.modules_designsystem_asset_6),
        NoteBg(Color(0xFFEE7D62), R.drawable.modules_designsystem_asset_7),
        NoteBg(Color(0xFFCACA5E), R.drawable.modules_designsystem_asset_8),
        NoteBg(Color(0xFF8D59B6), R.drawable.modules_designsystem_asset_9),
        NoteBg(Color(0xFFCF1879), R.drawable.modules_designsystem_asset_10),
    )
    val noteColors = listOf(
        Color(0xFFB590CA),
        Color(0xFFA8D3DA),
        Color(0xFFF5CAB3),
        Color(0xFFF3ECB8),
        Color(0xFFC2F0FC),
        Color(0xFFFFB6B6),
        Color(0xFFDBC890),
        Color(0xFFEF9A9A),
        Color(0xFFF48FB1),
        Color(0xFFB39DDB),
        Color(0xFF81D4FA),
        Color(0xFFA5D6A7),
        Color(0xFFFFF59D),
        Color(0xFFFFCC80),
        Color(0xFFFFAB91),
    )

    val searchIcons = arrayOf(
        Notification,
        CheckBox,
        Image,
        KeyboardVoice,
        Brush,
        Link,
        Label,
    )
}
