/*
 * Copyright (C) 2020 Miles Krell and the Text Torch contributors
 *
 * This file is part of Text Torch.
 *
 * Text Torch is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Text Torch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Text Torch.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.mileskrell.texttorch.util

import android.Manifest
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import android.provider.Settings
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import com.mileskrell.texttorch.R

/**
 * Permissions-related functions and resources used in multiple places
 */

fun Fragment.readSmsGranted() = ContextCompat.checkSelfPermission(
    requireContext(),
    Manifest.permission.READ_SMS
) == PackageManager.PERMISSION_GRANTED

fun Fragment.readContactsGranted() = ContextCompat.checkSelfPermission(
    requireContext(),
    Manifest.permission.READ_CONTACTS
) == PackageManager.PERMISSION_GRANTED

fun Fragment.showAppSettingsDialog(logTag: String) {
    MaterialAlertDialogBuilder(requireContext())
        .setMessage(R.string.app_settings_explanation)
        .setPositiveButton(R.string.open_app_settings) { _, _ ->
            logToBoth(logTag, "User opened system app info page")
            val appSettingsIntent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS).apply {
                data = Uri.fromParts("package", requireContext().packageName, null)
            }
            startActivity(appSettingsIntent)
        }
        .create().apply {
            window?.attributes?.windowAnimations = R.style.SlidingDialogStyle
        }
        .show()
}
