/*
 * Copyright 2013 Nytyr [me at nytyr dot me]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.memetro.android.ui.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;

import androidx.appcompat.content.res.AppCompatResources;

import com.memetro.android.R;

public class GifView extends ImageView {

    public GifView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    public GifView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public GifView(Context context) {
        super(context);
        init();
    }

    private void init() {
        // TODO REVIEW WHY ISN'T WORKING
        setBackground(AppCompatResources.getDrawable(getContext(), R.drawable.loader));
        //setBackgroundResource(R.drawable.loader);
        final AnimatedImageDrawable frameAnimation;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.P) {
            frameAnimation = (AnimatedImageDrawable) getBackground();
            post(new Runnable(){
                public void run(){
                    frameAnimation.start();
                }
            });
        }
    }
}
